/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.MenuFrame;
import ProWin.MessageBox;
import ProWin.Setup;
import java.awt.Frame;
import java.io.File;

public class PS_Printer
implements Runnable {
    String PSfile;
    MenuFrame mFrame;
    Thread runThread = null;

    public PS_Printer(MenuFrame mFrame, String PSfile) {
        this.mFrame = mFrame;
        this.PSfile = PSfile;
        if (System.getProperty("os.name").substring(0, 3).equals("Win")) {
            MessageBox mBox = new MessageBox((Frame)mFrame, "Note", "Does not work under Windows.", "Sorry.");
            mBox.setLocation(mFrame.DialogCorner(mBox, mFrame));
            mBox.setVisible(true);
        } else {
            this.runThread = new Thread((Runnable)this, "PS_Printer");
            this.runThread.setPriority(5);
            this.runThread.start();
        }
    }

    public void run() {
        File file = new File(this.PSfile);
        if (!file.exists()) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "Postscript file does not exist: ", this.PSfile);
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            return;
        }
        String[] commandLine = new String[]{"lp", "-d" + Setup.m_Printer, this.PSfile};
        try {
            Runtime r = Runtime.getRuntime();
            Process p = null;
            p = r.exec(commandLine);
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Note", "Printing command executed.", "You will be notified upon termination.");
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            p.waitFor();
            if (p.exitValue() != 0) {
                mBox = new MessageBox((Frame)this.mFrame, "Note", "Errors occurred during printing;", "exit value = " + p.exitValue() + "!");
                mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
                mBox.setVisible(true);
            } else {
                mBox = new MessageBox((Frame)this.mFrame, "Note", "Printing terminated successfully.", "No errors (exit value = 0).");
                mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
                mBox.setVisible(true);
            }
        }
        catch (Exception e1) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "Error occurred during printing:", e1.toString());
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            System.out.println("Error during printing: " + e1);
        }
    }
}

