/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.Alpine3D;
import alpine3d.FileSpecIF;
import alpine3d.RasterImage;
import alpine3d.SurfaceArea;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UNKNOWNStrategy
implements FileSpecIF {
    DecimalFormat formatter2 = new DecimalFormat("###");

    public String checkBoxLabel() {
        return "Unknown";
    }

    public int getEditIndex(Alpine3D a3d) {
        return -1;
    }

    public String getFiletype() {
        return "";
    }

    public Object[] getLegendColors(RasterImage rasImage) {
        Object[] panelArr = new JPanel[rasImage.getNumOfColors()];
        int i = 0;
        while (i < rasImage.getNumOfColors()) {
            panelArr[i] = new JPanel();
            ((JComponent)panelArr[i]).setBackground(rasImage.getColor(i));
            ++i;
        }
        return panelArr;
    }

    public Object[] getLegendText(RasterImage rasImage) {
        Object[] labelArr = new JLabel[rasImage.getNumOfColors()];
        labelArr[0] = new JLabel("No Data");
        labelArr[1] = new JLabel("< " + rasImage.getLimit(0));
        labelArr[rasImage.getNumOfColors() - 1] = new JLabel("> " + rasImage.getLimit(rasImage.getNumOfColors() - 3));
        int i = 2;
        while (i < rasImage.getNumOfColors() - 1) {
            labelArr[i] = new JLabel(rasImage.getLimit(i - 2) + "  -  " + rasImage.getLimit(i - 1));
            ++i;
        }
        int i2 = 0;
        while (i2 < rasImage.getNumOfColors()) {
            ((JLabel)labelArr[i2]).setHorizontalAlignment(0);
            ((JComponent)labelArr[i2]).setFont(new Font("Dialog", 0, 11));
            ++i2;
        }
        return labelArr;
    }

    public ArrayList getPointList(Alpine3D a3d) {
        return null;
    }

    public Map getPointMap(Alpine3D a3d) {
        return null;
    }

    public Map getUndoIndexMap(Alpine3D a3d) {
        return null;
    }

    public String getUnit() {
        return "Unknown Unit";
    }

    public float getValue(SurfaceArea sArea, int i, int j) {
        return sArea.sPoint[i][j].getValue();
    }

    public float retransformeValue(float value) {
        return value;
    }

    public byte[][] setColorArrays() {
        byte[][] colorMatrix = new byte[3][32];
        byte[] r = new byte[32];
        byte[] g = new byte[32];
        byte[] b = new byte[32];
        r[0] = -1;
        b[0] = -1;
        g[0] = -1;
        int i = 1;
        while (i < 4) {
            r[i] = 0;
            g[i] = 0;
            b[i] = (byte)(139 + (i - 1) * 116 / 2);
            ++i;
        }
        int i2 = 4;
        while (i2 < 12) {
            r[i2] = 0;
            g[i2] = (byte)(0 + (i2 - 4) * 255 / 7);
            b[i2] = -1;
            ++i2;
        }
        int i3 = 12;
        while (i3 < 16) {
            r[i3] = 0;
            g[i3] = -1;
            b[i3] = (byte)(255 - (i3 - 12) * 255 / 3);
            ++i3;
        }
        int i4 = 16;
        while (i4 < 20) {
            r[i4] = (byte)(0 + (i4 - 16) * 255 / 3);
            g[i4] = -1;
            b[i4] = 0;
            ++i4;
        }
        int i5 = 20;
        while (i5 < 28) {
            r[i5] = -1;
            g[i5] = (byte)(255 - (i5 - 20) * 255 / 7);
            b[i5] = 0;
            ++i5;
        }
        int i6 = 28;
        while (i6 < 32) {
            r[i6] = (byte)(255 - (i6 - 28) * 116 / 3);
            g[i6] = 0;
            b[i6] = 0;
            ++i6;
        }
        colorMatrix[0] = r;
        colorMatrix[1] = g;
        colorMatrix[2] = b;
        return colorMatrix;
    }

    public byte[] setDataBuffer(SurfaceArea sArea, int nColors, float lowerLimit, float upperLimit) {
        byte[] pixels = new byte[sArea.getNRows() * sArea.getNCols()];
        double mult = (upperLimit - lowerLimit) / (float)(nColors - 3);
        float top = 0.0f;
        int k = 0;
        int i = 0;
        while (i < sArea.getNRows()) {
            int j = 0;
            while (j < sArea.getNCols()) {
                if (this.getValue(sArea, i, j) == (float)sArea.getNoDataValue()) {
                    pixels[k] = 0;
                    ++k;
                } else if (this.getValue(sArea, i, j) == upperLimit) {
                    pixels[k] = (byte)(nColors - 2);
                    ++k;
                } else if (this.getValue(sArea, i, j) > upperLimit) {
                    pixels[k] = (byte)(nColors - 1);
                    ++k;
                } else if (this.getValue(sArea, i, j) < lowerLimit) {
                    pixels[k] = 1;
                    ++k;
                } else {
                    int color = 0;
                    while (color < nColors - 3) {
                        float bottom = lowerLimit + (float)((double)color * mult);
                        top = lowerLimit + (float)((double)(color + 1) * mult);
                        if (bottom <= this.getValue(sArea, i, j) && this.getValue(sArea, i, j) < top) {
                            pixels[k] = (byte)(color + 2);
                            ++k;
                        }
                        color = (byte)(color + 1);
                    }
                }
                ++j;
            }
            ++i;
        }
        return pixels;
    }

    public void setEditIndex(Alpine3D a3d, int value) {
    }

    public String[] setLimits(int nColors, float lowerLimit, float upperLimit) {
        double mult = (upperLimit - lowerLimit) / (float)(nColors - 3);
        String[] limits = new String[nColors - 2];
        float top = 0.0f;
        int color = 0;
        while (color < nColors - 3) {
            float bottom = lowerLimit + (float)((double)color * mult);
            top = bottom + (float)mult;
            limits[color] = this.formatter2.format(bottom);
            color = (byte)(color + 1);
        }
        limits[nColors - 3] = this.formatter2.format(top);
        return limits;
    }

    public void setValue(float value, SurfaceArea sArea, int i, int j) {
        sArea.sPoint[i][j].setValue(value);
    }

    public float transformeValue(float value) {
        return value;
    }

    public String valueToString(float value) {
        return String.valueOf(value);
    }
}

