/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GPSData {
    private String datum;
    private String grid;
    private ArrayList trackList;
    private ArrayList wayPointList = new ArrayList();
    private Map wayPointNameMap = new HashMap();

    public GPSData(File file) throws IOException {
        this.trackList = new ArrayList();
        this.readFile(file);
    }

    public ArrayList getTrackList() {
        return this.trackList;
    }

    public ArrayList getWayPointList() {
        return this.wayPointList;
    }

    public Map getWayPointNameMap() {
        return this.wayPointNameMap;
    }

    /*
     * WARNING - void declaration
     */
    public void readFile(File file) throws IOException {
        String line;
        FileReader in = new FileReader(file);
        LineNumberReader lnr = new LineNumberReader(in);
        boolean isTrack = false;
        ArrayList<Point2D.Float> trPList = new ArrayList<Point2D.Float>();
        while ((line = lnr.readLine()) != null) {
            Point2D.Float p;
            float y;
            String[] pos;
            void var4_6;
            String[] splitLine = var4_6.split("\\t");
            if (!isTrack && splitLine.length > 0) {
                StringBuffer buffer;
                if (this.grid == null && splitLine[0].equals("Grid")) {
                    buffer = new StringBuffer();
                    int i = 0;
                    while (i < splitLine.length) {
                        buffer.append(splitLine[i]);
                        ++i;
                    }
                    this.grid = buffer.toString();
                    continue;
                }
                if (this.datum == null && splitLine[0].equals("Datum")) {
                    buffer = new StringBuffer();
                    int i = 0;
                    while (i < splitLine.length) {
                        buffer.append(splitLine[i]);
                        ++i;
                    }
                    this.datum = buffer.toString();
                    continue;
                }
                if (splitLine[0].equals("Waypoint")) {
                    String name = splitLine[1];
                    pos = splitLine[4].split("\\s");
                    float x = Float.parseFloat(pos[0]);
                    y = Float.parseFloat(pos[1]);
                    p = new Point2D.Float(x, y);
                    this.wayPointList.add(p);
                    this.wayPointNameMap.put(p, name);
                    continue;
                }
                if (!splitLine[0].equals("Track")) continue;
                isTrack = true;
                continue;
            }
            if (!isTrack) continue;
            if (splitLine[0].equals("Trackpoint")) {
                pos = splitLine[1].split("\\s");
                float x = Float.parseFloat(pos[0]);
                y = Float.parseFloat(pos[1]);
                p = new Point2D.Float(x, y);
                trPList.add(p);
                continue;
            }
            if (!var4_6.equals("") || trPList.isEmpty()) continue;
            ArrayList trPListClone = (ArrayList)trPList.clone();
            this.trackList.add(trPListClone);
            trPList.clear();
            isTrack = false;
        }
        if (lnr.readLine() == null && !trPList.isEmpty()) {
            ArrayList trPListClone = (ArrayList)trPList.clone();
            this.trackList.add(trPListClone);
        }
    }
}

