/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.SurfaceArea;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;

public class SurfaceCodeWriter {
    DecimalFormat formatter = new DecimalFormat("00");

    public SurfaceCodeWriter(File file, SurfaceArea sArea) throws IOException {
        this.writeFile(file, sArea);
    }

    private void writeFile(File file, SurfaceArea sArea) throws IOException {
        FileWriter out = new FileWriter(file);
        out.write("ncols\t\t" + sArea.getNCols() + "\n");
        out.write("nrows\t\t" + sArea.getNRows() + "\n");
        out.write("xllcorner\t" + sArea.getXllCorner() + "\n");
        out.write("yllcorner\t" + sArea.getYllCorner() + "\n");
        out.write("cellsize\t" + sArea.getCellsize() + "\n");
        out.write("NODATA_value\t" + sArea.getNoDataValue() + " \n");
        int i = 0;
        while (i < sArea.getNRows()) {
            int j = 0;
            while (j < sArea.getNCols()) {
                if (sArea.sPoint[i][j].isNoDataValue()) {
                    out.write(new Integer(sArea.getNoDataValue()).toString() + " ");
                } else {
                    out.write("1" + this.formatter.format(sArea.sPoint[i][j].getLanduse()) + String.valueOf(sArea.sPoint[i][j].getSoilDepth()) + String.valueOf(sArea.sPoint[i][j].getFieldCapacity()) + " ");
                }
                ++j;
            }
            out.write("\n");
            ++i;
        }
        out.close();
    }
}

