/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.ASCIIFileReader;
import alpine3d.SurfaceArea;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public class SurfaceCodeReader
extends ASCIIFileReader {
    public SurfaceCodeReader(File file, SurfaceArea sArea) throws IOException {
        super(file, sArea);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readMatrix(File file, SurfaceArea sArea) throws IOException {
        sArea.createSurfacePoints(this.nRows, this.nCols);
        FileReader in = new FileReader(file);
        StreamTokenizer tok = new StreamTokenizer(in);
        tok.parseNumbers();
        int countCols = 0;
        int countRows = 0;
        while (tok.nextToken() != -1) {
            if (tok.ttype != -2 || tok.lineno() <= 6) continue;
            if (countCols == this.nCols) {
                countCols = 0;
                ++countRows;
            }
            sArea.sPoint[countRows][countCols].setValue((float)tok.nval);
            String buffer = String.valueOf((int)tok.nval);
            if (Float.parseFloat(buffer) == (float)sArea.getNoDataValue()) {
                sArea.sPoint[countRows][countCols].setIsNoDataValue(true);
                sArea.sPoint[countRows][countCols].setLanduse(-9999);
                sArea.sPoint[countRows][countCols].setFieldCapacity(-9999);
                sArea.sPoint[countRows][countCols].setSoilDepth(-9999);
            } else {
                int lus = Integer.parseInt(buffer.substring(1, 3));
                int sd = Integer.parseInt(buffer.substring(3, 4));
                int fc = Integer.parseInt(buffer.substring(4, 5));
                sArea.sPoint[countRows][countCols].setLanduse(lus);
                sArea.sPoint[countRows][countCols].setSoilDepth(sd);
                sArea.sPoint[countRows][countCols].setFieldCapacity(fc);
            }
            ++countCols;
        }
    }
}

