/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.SurfaceArea;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.util.StringTokenizer;

public class ASCIIFileReader {
    int nCols;
    int nRows;

    public ASCIIFileReader(File file, SurfaceArea sArea) throws IOException {
        this.readHeader(file, sArea);
        this.readMatrix(file, sArea);
    }

    /*
     * WARNING - void declaration
     */
    private void readHeader(File file, SurfaceArea sArea) throws IOException {
        String line;
        FileReader in = new FileReader(file);
        LineNumberReader lnr = new LineNumberReader(in);
        String[] header = new String[12];
        int count = 0;
        while ((line = lnr.readLine()) != null && lnr.getLineNumber() < 7) {
            void var6_7;
            StringTokenizer token = new StringTokenizer((String)var6_7, "\t ", false);
            while (token.hasMoreTokens()) {
                header[count] = token.nextToken();
                ++count;
            }
        }
        this.nCols = Integer.parseInt(header[1]);
        this.nRows = Integer.parseInt(header[3]);
        sArea.setNCols(this.nCols);
        sArea.setNRows(this.nRows);
        sArea.setXllCorner(Float.parseFloat(header[5]));
        sArea.setYllCorner(Float.parseFloat(header[7]));
        sArea.setCellsize(Float.parseFloat(header[9]));
        sArea.setNoDataValue(Integer.parseInt(header[11]));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readMatrix(File file, SurfaceArea sArea) throws IOException {
        sArea.createSurfacePoints(this.nRows, this.nCols);
        FileReader in = new FileReader(file);
        StreamTokenizer tok = new StreamTokenizer(in);
        tok.parseNumbers();
        int countCols = 0;
        int countRows = 0;
        while (tok.nextToken() != -1) {
            if (tok.ttype != -2 || tok.lineno() <= 6) continue;
            if (countCols == this.nCols) {
                countCols = 0;
                ++countRows;
            }
            sArea.sPoint[countRows][countCols].setValue((float)tok.nval);
            if (tok.nval != (double)sArea.getNoDataValue()) {
                if (tok.nval < (double)sArea.getMinValue()) {
                    sArea.setMinValue((float)tok.nval);
                }
                if (tok.nval > (double)sArea.getMaxValue()) {
                    sArea.setMaxValue((float)tok.nval);
                }
            }
            ++countCols;
        }
    }
}

