/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.DataLine;
import ProWin.ErrorFile;
import java.io.IOException;
import java.util.StringTokenizer;

public class ZValuesDataLine
extends DataLine
implements C_DataFile {
    protected static String ModulName = "ZValuesDataLine";
    protected int m_NrOfValues = 0;
    protected float[] m_ValueArray;

    ZValuesDataLine(int IdCode, int NrOfValues, float[] values) {
        this();
        this.SetIdCode(IdCode);
        this.m_NrOfValues = NrOfValues;
        this.m_ValueArray = new float[this.m_NrOfValues];
        System.arraycopy(values, 0, this.m_ValueArray, 0, this.m_NrOfValues);
    }

    ZValuesDataLine() {
    }

    public int GetDataType() {
        return 3;
    }

    public int GetNrOfSnowValues() {
        int NrOfSnowValues = 0;
        int i = 0;
        while (i < this.m_NrOfValues) {
            if (this.m_ValueArray[i] > 0.0f) {
                ++NrOfSnowValues;
            }
            ++i;
        }
        return NrOfSnowValues;
    }

    public int GetNrOfValues() {
        return this.m_NrOfValues;
    }

    public float GetZValue(int LayerNr) {
        return this.m_ValueArray[LayerNr];
    }

    public boolean HasDate() {
        return false;
    }

    public boolean ParseLine(String Line) throws IOException {
        String ProcName = ModulName + ".ParseLine";
        if (Line == null) {
            ErrorFile.write("ERR_PAR_FUNCTION", 1, ProcName);
            return false;
        }
        StringTokenizer st = new StringTokenizer(Line, ",");
        if (!st.hasMoreTokens()) {
            ErrorFile.write("ERR_LINE_SYNTAX", 2, ProcName);
            return false;
        }
        this.SetIdCode(Integer.parseInt(st.nextToken()));
        if (!st.hasMoreTokens()) {
            ErrorFile.write("ERR_LINE_SYNTAX", 3, ProcName);
            return false;
        }
        try {
            this.m_NrOfValues = Integer.parseInt(st.nextToken());
            if (this.m_NrOfValues <= 0 || this.m_NrOfValues > 400) {
                if (this.m_NrOfValues != 0) {
                    ErrorFile.write("ERR_LINE_SYNTAX", 4, ProcName);
                }
                return false;
            }
        }
        catch (NumberFormatException e) {
            ErrorFile.write("ERR_LINE_SYNTAX", 5, ProcName);
            return false;
        }
        this.m_ValueArray = new float[this.m_NrOfValues];
        int i = 0;
        while (st.hasMoreTokens() && i < this.m_NrOfValues) {
            try {
                this.m_ValueArray[i] = Float.valueOf(st.nextToken()).floatValue();
            }
            catch (NumberFormatException e) {
                ErrorFile.write("ERR_LINE_SYNTAX", 6, ProcName);
                return false;
            }
            ++i;
        }
        if (st.hasMoreTokens() || i < this.m_NrOfValues) {
            ErrorFile.write("ERR_LINE_SYNTAX", 7, ProcName);
            return false;
        }
        return true;
    }
}

