/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.DataFile;
import ProWin.FileStatus;
import ProWin.Graph;
import ProWin.MenuFrame;
import ProWin.MessageBox;
import ProWin.MetDataFile;
import ProWin.ProDataFile;
import ProWin.Setup;
import ProWin.SnowPackDoc;
import ProWin.SnowPackView;
import ProWin.XYPlotView;
import com.borland.jbcl.control.SplitPanel;
import com.borland.jbcl.layout.PaneConstraints;
import com.borland.jbcl.layout.PaneLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SnowPackFrame
extends JInternalFrame
implements C_DataFile {
    int IdCode = 0;
    BorderLayout borderLayout1 = new BorderLayout();
    boolean created = true;
    DataFile dataFile = null;
    File file;
    JPanel jPanel1;
    JPanel jPanel2;
    MenuFrame mFrame;
    PaneLayout paneLayout1;
    PaneLayout paneLayout2;
    SnowPackView snowPackView = null;
    SnowPackDoc spDoc = null;
    SplitPanel splitPanel1 = new SplitPanel();
    XYPlotView xyPlotView;
    private int yAxis;

    public SnowPackFrame(File file, int IdCode, MenuFrame mFrame) {
        super(file.getName(), true, true, true, true);
        this.paneLayout1 = new PaneLayout();
        this.paneLayout2 = new PaneLayout();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.mFrame = mFrame;
        this.setVisible(true);
        this.file = file;
        this.IdCode = IdCode;
        try {
            this.dataFile = Setup.modelRunning ? null : mFrame.NewDataFile(file);
            if (this.dataFile == null) {
                if (file.getName().endsWith(".pro") || file.getName().endsWith(".PRO")) {
                    this.dataFile = new ProDataFile();
                } else if (file.getName().endsWith(".met") || file.getName().endsWith(".MET")) {
                    this.dataFile = new MetDataFile();
                }
                FileStatus fileStatus = new FileStatus((Frame)mFrame, "Please wait ... reading file " + file.getName() + "!", false, file.getName());
                fileStatus.setLocation(mFrame.DialogCorner(fileStatus, mFrame));
                if (!Setup.m_PrintMode) {
                    fileStatus.setVisible(true);
                }
                Date curDate = new Date();
                long mSec = curDate.getTime();
                System.out.println("=== Start ReadDataFile(" + file.getName() + "): " + curDate);
                try {
                    this.dataFile.ReadDataFile(file);
                    curDate = new Date();
                    mSec = curDate.getTime() - mSec;
                    System.out.println("=== End ReadDataFile(" + file.getName() + "): " + curDate);
                }
                catch (Exception e) {
                    MessageBox mBox = new MessageBox((Frame)mFrame, "Error", "Error reading " + file.getName() + ":", e + "!");
                    mBox.setLocation(mFrame.DialogCorner(mBox, mFrame));
                    mBox.setVisible(true);
                }
                fileStatus.dispose();
            }
            if (!this.dataFile.CalculateMinMaxValue(IdCode)) {
                String IdStr = new Integer(IdCode).toString();
                MessageBox mBox = new MessageBox((Frame)mFrame, "Error", "No (correct) data for sel. parameter (Id=" + IdStr + ") in file", this.getInputFile().getPath() + "!");
                mBox.setLocation(mFrame.DialogCorner(mBox, mFrame));
                mBox.setVisible(true);
                mFrame.RemoveSnowPackFrame(this);
                this.created = false;
                this.dispose();
            } else {
                MessageBox mBox;
                this.spDoc = new SnowPackDoc(file, this.dataFile, mFrame, this);
                if (this.spDoc.GetStationParameters() && this.spDoc.GetDefaultIdParameters(IdCode) && this.spDoc.GetYAxisRange(IdCode)) {
                    if (this.spDoc.GetXAxisRange(IdCode)) {
                        this.snowPackView = new SnowPackView(this.spDoc, IdCode);
                        this.xyPlotView = new XYPlotView(this.spDoc, IdCode);
                        MenuFrame.statusBar.setText("");
                    } else {
                        mBox = new MessageBox((Frame)mFrame, "Error", "Just one data record in file!", this.getInputFile().getPath());
                        mBox.setLocation(mFrame.DialogCorner(mBox, mFrame));
                        mBox.setVisible(true);
                    }
                }
                this.setBackground(this.spDoc.m_Background);
                this.created = true;
                this.jbInit();
                if (!this.dataFile.m_SoilDataExist && Setup.m_SoilDataDisplay && IdCode >= 500) {
                    mBox = new MessageBox((Frame)mFrame, "Note", "No soil data in file", this.getInputFile().getPath() + "!");
                    mBox.setLocation(mFrame.DialogCorner(mBox, mFrame));
                    mBox.setVisible(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageBox mBox = new MessageBox((Frame)mFrame, "Error", e + "!", this.getInputFile().getPath());
            mBox.setLocation(mFrame.DialogCorner(mBox, mFrame));
            mBox.setVisible(true);
            mFrame.RemoveSnowPackFrame(this);
            this.created = false;
            this.dispose();
        }
    }

    public void Animation() {
        int speed = Setup.m_animationSpeed;
        int delay = 0;
        if (speed == 1) {
            delay = 1000;
        } else if (speed == 2) {
            delay = 500;
        } else if (speed == 3) {
            delay = 200;
        } else if (speed == 4) {
            delay = 100;
        } else if (speed == 5) {
            delay = 50;
        }
        Thread t = Thread.currentThread();
        int IdCode = this.snowPackView.m_IdCode;
        this.snowPackView.DrawMarker(this.snowPackView.getGraphics(), IdCode);
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return;
        }
        this.snowPackView.PrepareGraph(graph);
        this.spDoc.m_MarkerDataEntry = null;
        this.spDoc.GetMarkerValue(IdCode);
        GregorianCalendar xTime = this.spDoc.m_ActTime;
        GregorianCalendar ActDataTimeClone = this.dataFile.GetActDataTime();
        ActDataTimeClone.add(13, -this.spDoc.m_TimeStep);
        GregorianCalendar TimeRangeStartTime = this.dataFile.GetTimeRangeStartTime();
        if (!ActDataTimeClone.before(TimeRangeStartTime)) {
            this.spDoc.OnMarkerBackward("Home");
            this.spDoc.m_MarkerDataEntry = null;
            this.spDoc.GetMarkerValue(IdCode);
            xTime = this.spDoc.m_ActTime;
        }
        while (!xTime.after(this.spDoc.m_AnimationEndTime)) {
            if (!xTime.before(this.spDoc.m_AnimationStartTime)) {
                this.spDoc.activeSliderMovement = false;
                this.spDoc.jSlider.setValue(graph.CalcXPosLP(xTime));
                this.spDoc.activeSliderMovement = true;
                this.snowPackView.DrawMarker(this.snowPackView.getGraphics(), IdCode);
                this.xyPlotView.DrawXYPlot(this.xyPlotView.getGraphics());
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    System.out.println("SnowPackView, Animation(): problems with Thread.sleep");
                }
                this.snowPackView.DrawMarker(this.snowPackView.getGraphics(), IdCode);
            }
            ActDataTimeClone = this.dataFile.GetActDataTime();
            ActDataTimeClone.add(13, this.spDoc.m_TimeStep);
            GregorianCalendar TimeRangeEndTime = this.dataFile.GetTimeRangeEndTime();
            if (ActDataTimeClone.after(TimeRangeEndTime) || ActDataTimeClone.after(this.spDoc.m_AnimationEndTime)) break;
            this.spDoc.OnMarkerForward("RightArrow");
            this.spDoc.m_MarkerDataEntry = null;
            this.spDoc.GetMarkerValue(IdCode);
            xTime = this.spDoc.m_ActTime;
        }
        this.snowPackView.DrawMarker(this.snowPackView.getGraphics(), IdCode);
        if (Setup.m_Synchronization) {
            this.mFrame.MarkerMovement("End", 0);
        }
    }

    void RedrawFrame() {
        this.snowPackView.DrawSnowPackView(this.snowPackView.getGraphics());
        this.xyPlotView.DrawXYPlot(this.xyPlotView.getGraphics());
    }

    public void SliderMovement(int value) {
        int IdCode = this.snowPackView.m_IdCode;
        this.snowPackView.DrawMarker(this.snowPackView.getGraphics(), IdCode);
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return;
        }
        this.snowPackView.PrepareGraph(graph);
        this.spDoc.m_MarkerDataEntry = null;
        this.spDoc.GetMarkerValue(IdCode);
        GregorianCalendar xTime = this.spDoc.m_ActTime;
        GregorianCalendar ActDataTimeClone = this.dataFile.GetActDataTime();
        ActDataTimeClone.add(13, -this.spDoc.m_TimeStep);
        GregorianCalendar TimeRangeStartTime = this.dataFile.GetTimeRangeStartTime();
        if (!ActDataTimeClone.before(TimeRangeStartTime)) {
            this.spDoc.OnMarkerBackward("Home");
            this.spDoc.m_MarkerDataEntry = null;
            this.spDoc.GetMarkerValue(IdCode);
            xTime = this.spDoc.m_ActTime;
        }
        ActDataTimeClone = this.dataFile.GetActDataTime();
        ActDataTimeClone.add(13, this.spDoc.m_TimeStep);
        while (graph.CalcXPosLP(ActDataTimeClone) < value) {
            ActDataTimeClone = this.dataFile.GetActDataTime();
            ActDataTimeClone.add(13, this.spDoc.m_TimeStep);
            GregorianCalendar TimeRangeEndTime = this.dataFile.GetTimeRangeEndTime();
            if (ActDataTimeClone.after(TimeRangeEndTime)) break;
            this.spDoc.OnMarkerForward("RightArrow");
            this.spDoc.m_MarkerDataEntry = null;
            this.spDoc.GetMarkerValue(IdCode);
            xTime = this.spDoc.m_ActTime;
            ActDataTimeClone = this.dataFile.GetActDataTime();
            ActDataTimeClone.add(13, this.spDoc.m_TimeStep);
        }
        this.spDoc.activeSliderMovement = false;
        this.spDoc.jSlider.setValue(graph.CalcXPosLP(xTime));
        this.spDoc.activeSliderMovement = true;
        this.snowPackView.DrawMarker(this.snowPackView.getGraphics(), IdCode);
        this.xyPlotView.DrawXYPlot(this.xyPlotView.getGraphics());
    }

    void adjustSplitPaneDivider(float dividerLoc) {
        this.splitPanel1.remove(this.jPanel2);
        this.splitPanel1.add((Component)this.jPanel2, new PaneConstraints("jPanel2", "jPanel1", "Right", dividerLoc));
    }

    public void changeId(int IdCode, MenuFrame mFrame) {
        int IdCode_old = this.snowPackView.m_IdCode;
        this.IdCode = IdCode;
        this.snowPackView.m_IdCode = IdCode;
        this.xyPlotView.m_IdCode = IdCode;
        if (this.spDoc.GetDefaultIdParameters(IdCode) && this.dataFile.CalculateMinMaxValue(IdCode)) {
            if (IdCode < 500) {
                this.spDoc.GetYAxisRange(IdCode);
            }
            this.spDoc.m_xNrOfGrids = 4;
            this.repaint();
        } else {
            MessageBox mBox = new MessageBox((Frame)mFrame, "Error", "No (correct) data for selected parameter in file", this.getInputFile().getPath() + "!");
            mBox.setLocation(mFrame.DialogCorner(mBox, mFrame));
            mBox.setVisible(true);
            this.IdCode = IdCode_old;
            this.snowPackView.m_IdCode = IdCode_old;
            this.xyPlotView.m_IdCode = IdCode_old;
            if (this.spDoc.GetDefaultIdParameters(IdCode_old) && this.spDoc.GetYAxisRange(IdCode_old) && this.dataFile.CalculateMinMaxValue(IdCode_old)) {
                this.spDoc.m_xNrOfGrids = 4;
                this.repaint();
            }
        }
        String Id = this.spDoc.GetAxisText(this.IdCode);
        mFrame.AdjustWindowsMenu(this, this.file, Id, 0);
    }

    public int getColorTab() {
        return this.spDoc.m_ColorTab;
    }

    public float getEndValue() {
        return this.spDoc.m_EndValue;
    }

    public File getInputFile() {
        return this.file;
    }

    SnowPackView getSnowPackView() {
        return this.snowPackView;
    }

    public float getStartValue() {
        return this.spDoc.m_StartValue;
    }

    public void jbInit() throws Exception {
        this.setClosable(true);
        this.setIconifiable(true);
        this.setBorder(null);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                SnowPackFrame.this.this_internalFrameActivated(e);
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                SnowPackFrame.this.this_internalFrameClosing(e);
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                SnowPackFrame.this.this_internalFrameDeactivated(e);
            }
        });
        this.setMaximizable(true);
        this.setResizable(true);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jPanel1.setLayout(this.paneLayout1);
        this.jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jPanel2.setLayout(this.paneLayout2);
        this.getContentPane().add((Component)this.splitPanel1, "Center");
        this.splitPanel1.add((Component)this.jPanel1, new PaneConstraints("jPanel1", "jPanel1", "Root", 0.5f));
        this.splitPanel1.add((Component)this.jPanel2, new PaneConstraints("jPanel2", "jPanel1", "Right", 0.25f));
        this.jPanel1.add((Component)this.snowPackView, new PaneConstraints("jPanel3", "jPanel3", "Root", 0.5f));
        this.jPanel2.add((Component)this.xyPlotView, new PaneConstraints("jPanel5", "jPanel5", "Root", 0.5f));
    }

    public void marker(String type) {
        block20: {
            boolean repaintSPView = true;
            if (type == "Home") {
                repaintSPView = this.spDoc.OnMarkerBackward("Home");
            } else if (type == "End") {
                repaintSPView = this.spDoc.OnMarkerForward("End");
            } else if (type == "Left") {
                repaintSPView = this.spDoc.OnMarkerBackward("LeftArrow");
            } else if (type == "Right") {
                repaintSPView = this.spDoc.OnMarkerForward("RightArrow");
            } else {
                System.out.println("SnowPackFrame, marker(): unknown argument");
            }
            int IdCode = this.snowPackView.m_IdCode;
            if (repaintSPView) {
                try {
                    if (!this.spDoc.GetXAxisRange(IdCode)) break block20;
                    this.spDoc.SaveDataFile();
                    this.repaint();
                    if (type.equals("Home") || type.equals("Left")) {
                        this.marker("Home");
                        this.spDoc.SaveDataFile();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.snowPackView.DrawMarker(this.snowPackView.getGraphics(), IdCode);
                if (type == "Home") {
                    this.spDoc.OnMarkerBackward("Home");
                } else if (type == "End") {
                    this.spDoc.OnMarkerForward("End");
                } else if (type == "Left") {
                    this.spDoc.OnMarkerBackward("LeftArrow");
                } else if (type == "Right") {
                    this.spDoc.OnMarkerForward("RightArrow");
                }
                this.spDoc.m_MarkerDataEntry = null;
                this.spDoc.SaveDataFile();
                this.snowPackView.DrawMarker(this.snowPackView.getGraphics(), IdCode);
                this.xyPlotView.DrawXYPlot(this.xyPlotView.getGraphics());
            }
        }
    }

    public void moveHigher() {
        this.spDoc.OnMoveHigher();
        this.repaint();
    }

    public void moveLower() {
        this.spDoc.OnMoveLower();
        this.repaint();
    }

    public void setBackGrnd(String colorStr) {
        this.spDoc.OnSetBackGrnd(colorStr);
        this.setBackground(this.spDoc.m_Background);
        this.repaint();
    }

    public void setColorParameters(float StartValue, float EndValue, int ColorTab2) {
        this.spDoc.OnSetColorParameters(StartValue, EndValue, ColorTab2);
        this.repaint();
    }

    public void setXAxis(float XMinValue, float XMaxValue, int xNrOfGrids) {
        this.spDoc.OnSetXAxis(XMinValue, XMaxValue, xNrOfGrids);
        this.repaint();
    }

    public void setYAxis(float YMinValue, float YMaxValue, int yNrOfGrids) {
        this.spDoc.OnSetYAxis(YMinValue, YMaxValue, yNrOfGrids);
        this.repaint();
    }

    void this_internalFrameActivated(InternalFrameEvent e) {
        if (this.spDoc.datafile_m_ActStartTime != null && this.spDoc != null) {
            this.spDoc.RetrieveDataFile();
        }
    }

    void this_internalFrameClosing(InternalFrameEvent e) {
        this.mFrame.Close(this);
    }

    void this_internalFrameDeactivated(InternalFrameEvent e) {
        if (this.spDoc != null) {
            this.spDoc.SaveDataFile();
        }
    }

    public void timeRange(GregorianCalendar StartTime, GregorianCalendar EndTime) {
        this.spDoc.OnTimeRange(StartTime, EndTime);
        this.spDoc.m_MarkerDataEntry = null;
        int IdCode = this.snowPackView.m_IdCode;
        try {
            if (this.spDoc.GetXAxisRange(IdCode)) {
                this.repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.spDoc.SaveDataFile();
    }

    public void timeRangeAll() {
        this.spDoc.OnTimeRangeAll();
        int IdCode = this.snowPackView.m_IdCode;
        try {
            if (this.spDoc.GetXAxisRange(IdCode)) {
                this.repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.spDoc.SaveDataFile();
    }

    public void timeRangeSet(int TimeRange) {
        this.dataFile.m_ActDataEntry = this.spDoc.m_MarkerDataEntry;
        if (TimeRange == 3) {
            this.spDoc.OnTimeRange3();
        } else if (TimeRange == 7) {
            this.spDoc.OnTimeRange7();
        } else if (TimeRange == 14) {
            this.spDoc.OnTimeRange14();
        } else if (TimeRange == 30) {
            this.spDoc.OnTimeRange30();
        } else if (TimeRange == 60) {
            this.spDoc.OnTimeRange60();
        }
        if (!this.dataFile.m_ActEndTime.equals(this.spDoc.m_MarkerDataEntry.GetTime())) {
            this.spDoc.OnMarkerForward("End");
            this.spDoc.m_MarkerDataEntry = null;
            this.spDoc.OnMarkerBackward("LeftArrow");
            this.spDoc.m_MarkerDataEntry = null;
        }
        int IdCode = this.snowPackView.m_IdCode;
        try {
            if (this.spDoc.GetXAxisRange(IdCode)) {
                this.repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.spDoc.SaveDataFile();
    }

    public void zoomIn() {
        this.spDoc.OnZoomIn();
        this.repaint();
    }

    public void zoomOut() {
        this.spDoc.OnZoomOut();
        this.repaint();
    }
}

