/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.MenuFrame;
import ProWin.MessageBox;
import java.awt.Frame;
import java.io.File;

public class PS_Maker
implements Runnable {
    String JPGfile;
    MenuFrame mFrame;
    Thread runThread = null;

    public PS_Maker(MenuFrame mFrame, String JPGfile) {
        this.mFrame = mFrame;
        this.JPGfile = JPGfile;
        if (System.getProperty("os.name").substring(0, 3).equals("Win")) {
            MessageBox mBox = new MessageBox((Frame)mFrame, "Note", "Does not work under Windows.", "Sorry.");
            mBox.setLocation(mFrame.DialogCorner(mBox, mFrame));
            mBox.setVisible(true);
        } else {
            this.runThread = new Thread((Runnable)this, "PS_Maker");
            this.runThread.setPriority(5);
            this.runThread.start();
        }
    }

    public void run() {
        File JPG = new File(this.JPGfile);
        if (!JPG.exists()) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "Input file *.JPG does not exist: ", this.JPGfile);
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            return;
        }
        String PSfile = this.JPGfile.substring(1, this.JPGfile.length() - 4) + ".ps";
        String[] commandLine = new String[]{"convert", "-page", "a4", this.JPGfile, PSfile};
        try {
            Runtime r = Runtime.getRuntime();
            Process p = null;
            p = r.exec(commandLine);
            System.out.println("Started: command line = " + commandLine[0] + " " + commandLine[1] + " " + commandLine[2] + " " + commandLine[3] + " " + commandLine[4]);
            p.waitFor();
            if (p.exitValue() != 0) {
                MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "Error in *.jpg-to-*.ps conversion.", "Exit value = " + p.exitValue() + "!");
                mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
                mBox.setVisible(true);
            } else {
                MessageBox mBox = new MessageBox((Frame)this.mFrame, "Note", "*.ps-file was constructed:", PSfile);
                mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
                mBox.setVisible(true);
            }
            System.out.println("JPG->PS-conversion finished, exit value = " + p.exitValue());
        }
        catch (Exception e1) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "Error in *.jpg-to-*.ps conversion:", e1.toString());
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            System.out.println("Error in *.jpg-to-*.ps conversion: " + e1);
        }
    }
}

