/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.ArrayMap;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class IniFile {
    protected ArrayMap actEntryList = null;
    protected String fileName;
    protected ArrayMap sectionList = new ArrayMap();

    public IniFile() {
        this.setFileName("");
    }

    public IniFile(String iniFileName) throws IOException {
        this.setFileName(iniFileName);
        this.read();
    }

    public Properties BigProperty(boolean interchange) throws IOException {
        Properties BigPropList = new Properties();
        int i = 0;
        while (i < this.getSectionSize()) {
            String value;
            String key;
            String section = this.getSection(i);
            if (section.indexOf("=") != -1) {
                key = section.substring(0, section.indexOf("=")).trim();
                value = section.substring(section.indexOf("=") + 1, section.length()).trim();
                if (interchange) {
                    BigPropList.put(value, key);
                } else {
                    BigPropList.put(key, value);
                }
            } else {
                this.setSection(section);
                int j = 0;
                while (j < this.getKeySize()) {
                    key = this.getKey(j);
                    value = this.getEntry(key, "");
                    if (interchange) {
                        BigPropList.put(value, key);
                    } else {
                        BigPropList.put(key, value);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return BigPropList;
    }

    public void clear() {
        Iterator secIt = this.sectionList.entrySet().iterator();
        while (secIt.hasNext()) {
            Map.Entry secEntry = secIt.next();
            Map entryList = (Map)secEntry.getValue();
            entryList.clear();
        }
        this.sectionList.clear();
        this.actEntryList = null;
    }

    public String getEntry(String key) throws NullPointerException {
        return this.getEntry(key, null);
    }

    public String getEntry(String key, String defaultValue) throws NullPointerException {
        if (this.actEntryList == null) {
            throw new NullPointerException();
        }
        String retStr = (String)this.actEntryList.get(key);
        if (retStr == null) {
            return defaultValue;
        }
        return retStr;
    }

    public String getEntry(String sectionName, String key, String defaultValue) {
        this.setSection(sectionName);
        return this.getEntry(key, defaultValue);
    }

    public String getKey(int index) {
        return (String)this.actEntryList.getKey(index);
    }

    public int getKeySize() {
        return this.actEntryList.size();
    }

    public String getSection(int index) {
        return (String)this.sectionList.getKey(index);
    }

    public int getSectionSize() {
        return this.sectionList.size();
    }

    public void read() throws IOException {
        String line;
        FileInputStream InFile = new FileInputStream(this.fileName);
        BufferedReader InReader = new BufferedReader(new InputStreamReader(InFile));
        this.clear();
        do {
            if ((line = InReader.readLine()) == null || (line = line.trim()).equals("") || line.startsWith(";") || line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]") && line.length() > 2) {
                line = line.substring(1);
                line = line.substring(0, line.length() - 1);
                line = line.trim();
                this.setSection(line);
                continue;
            }
            if (line.indexOf("=") == -1) continue;
            String key = line.substring(0, line.indexOf("="));
            key = key.trim();
            String entry = line.substring(line.indexOf("=") + 1);
            entry = entry.trim();
            this.setEntry(key, entry);
        } while (line != null);
        InReader.close();
        InFile.close();
    }

    public void removeEntries(String sectionName) {
        this.actEntryList = (ArrayMap)this.sectionList.get(sectionName);
        if (this.actEntryList != null) {
            this.actEntryList.clear();
        }
    }

    public void removeEntry(String key) {
        this.actEntryList.remove(key);
    }

    public void removeEntry(String sectionName, String key) {
        this.setSection(sectionName);
        this.removeEntry(key);
    }

    public void removeSection(String sectionName) {
        this.actEntryList = (ArrayMap)this.sectionList.get(sectionName);
        if (this.actEntryList != null) {
            this.actEntryList.clear();
            this.sectionList.remove(sectionName);
        }
    }

    public void setEntry(String key, String value) {
        this.actEntryList.put(key, value);
    }

    public void setEntry(String sectionName, String key, String value) {
        this.setSection(sectionName);
        this.setEntry(key, value);
    }

    public void setFileName(String iniFileName) {
        this.fileName = iniFileName;
    }

    public void setSection(String sectionName) {
        this.actEntryList = (ArrayMap)this.sectionList.get(sectionName);
        if (this.actEntryList == null) {
            this.actEntryList = new ArrayMap();
            this.sectionList.put(sectionName, this.actEntryList);
        }
    }

    public void write(String iniFileName) throws IOException {
        FileOutputStream outFile = new FileOutputStream(iniFileName);
        PrintWriter prnt = new PrintWriter(outFile);
        int i = 0;
        while (i < this.getSectionSize()) {
            String section = this.getSection(i);
            prnt.println();
            prnt.println("[" + section + "]");
            this.setSection(section);
            int j = 0;
            while (j < this.getKeySize()) {
                String key = this.getKey(j);
                prnt.print(key);
                prnt.write(61);
                prnt.println(this.getEntry(key, ""));
                ++j;
            }
            ++i;
        }
        prnt.flush();
        ((OutputStream)outFile).close();
    }

    public void write() throws IOException {
        this.write(this.fileName);
    }

    public void writeWithBlanks(String iniFileName) throws IOException {
        FileOutputStream outFile = new FileOutputStream(iniFileName);
        PrintWriter prnt = new PrintWriter(outFile);
        int i = 0;
        while (i < this.getSectionSize()) {
            String section = this.getSection(i);
            prnt.println();
            prnt.println("[" + section + "]");
            this.setSection(section);
            int j = 0;
            while (j < this.getKeySize()) {
                String key = this.getKey(j);
                prnt.print(key);
                prnt.write(" = ");
                prnt.println(this.getEntry(key, ""));
                ++j;
            }
            ++i;
        }
        prnt.flush();
        ((OutputStream)outFile).close();
    }

    public void writeWithBlanks() throws IOException {
        this.writeWithBlanks(this.fileName);
    }
}

