/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.DataLine;
import ProWin.ErrorFile;
import ProWin.MenuFrame;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;

public class DateTimeDataLine
extends DataLine
implements C_DataFile {
    protected static String ModulName = "DateTimeDataLine";
    String m_SnowStat = "";
    String m_StatAbbrev = "";
    GregorianCalendar m_Time = new GregorianCalendar(new SimpleTimeZone(3600000, "MEZ"));

    DateTimeDataLine(int IdCode, GregorianCalendar Time) {
        this();
        this.SetIdCode(IdCode);
        this.m_Time = (GregorianCalendar)Time.clone();
    }

    DateTimeDataLine() {
    }

    public int GetDataType() {
        return 1;
    }

    public String GetSnowStat() {
        return this.m_SnowStat;
    }

    public String GetStatAbbrev() {
        return this.m_StatAbbrev;
    }

    public GregorianCalendar GetTime() {
        return (GregorianCalendar)this.m_Time.clone();
    }

    public boolean HasDate() {
        return true;
    }

    public boolean ParseLine(String Line) throws IOException {
        String ProcName = ModulName + ".ParseLine";
        if (Line == null) {
            ErrorFile.write("ERR_PAR_FUNCTION", 1, ProcName);
            return false;
        }
        StringTokenizer st = new StringTokenizer(Line, ",");
        int countTokens = st.countTokens();
        if (!st.hasMoreTokens()) {
            ErrorFile.write("ERR_LINE_SYNTAX", 2, ProcName);
            return false;
        }
        this.SetIdCode(Integer.parseInt(st.nextToken()));
        if (countTokens > 2) {
            int i = 2;
            while (i < countTokens) {
                st.nextToken();
                ++i;
            }
        }
        if (!st.hasMoreTokens()) {
            ErrorFile.write("ERR_LINE_SYNTAX", 5, ProcName);
            return false;
        }
        String DateLine = st.nextToken();
        GregorianCalendar xTime = DateTimeDataLine.ScanDate(DateLine);
        if (xTime.equals(this.m_Time)) {
            ErrorFile.write("ERR_LINE_SYNTAX", 6, ProcName);
            return false;
        }
        this.m_Time = (GregorianCalendar)xTime.clone();
        MenuFrame.statusBar.setText("File reading: Current input date: " + DateLine);
        return true;
    }

    static GregorianCalendar ScanDate(String Line) {
        GregorianCalendar xTime = new GregorianCalendar(new SimpleTimeZone(3600000, "MEZ"));
        if (Line.length() < 16) {
            return xTime;
        }
        if (Line.charAt(2) != '.' || Line.charAt(5) != '.') {
            return xTime;
        }
        if (Line.charAt(10) != ' ') {
            return xTime;
        }
        if (Line.charAt(13) != ':') {
            return xTime;
        }
        int i = 0;
        while (i < 16) {
            block15: {
                if (i != 2 && i != 5 && i != 10 && i != 13) {
                    int j = 48;
                    while (j < 58) {
                        if (Line.charAt(i) != j) {
                            ++j;
                            continue;
                        }
                        break block15;
                    }
                    return xTime;
                }
            }
            ++i;
        }
        int Day = 10 * (Line.charAt(0) - 48) + (Line.charAt(1) - 48);
        int Month = 10 * (Line.charAt(3) - 48) + (Line.charAt(4) - 48);
        int Year = 1000 * (Line.charAt(6) - 48) + 100 * (Line.charAt(7) - 48) + 10 * (Line.charAt(8) - 48) + (Line.charAt(9) - 48);
        int Hour = 10 * (Line.charAt(11) - 48) + (Line.charAt(12) - 48);
        int Minute = 10 * (Line.charAt(14) - 48) + (Line.charAt(15) - 48);
        if (Day < 1 || Day > 31) {
            return xTime;
        }
        if (Month < 1 || Month > 12) {
            return xTime;
        }
        if (Year < 1 || Year > 9999) {
            return xTime;
        }
        if (Hour < 0 || Hour > 24) {
            return xTime;
        }
        if (Minute < 0 || Minute > 59) {
            return xTime;
        }
        if (Hour == 24) {
            Hour = 0;
            xTime.set(Year, Month - 1, Day, Hour, Minute, 0);
            xTime.add(10, 24);
        } else {
            xTime.set(Year, Month - 1, Day, Hour, Minute, 0);
        }
        xTime.set(14, 0);
        return xTime;
    }
}

