/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.DrawingArea;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class Util {
    public static final int BUILT_UP = 2;
    public static final int CONIFEROUS_F = 3;
    public static final int WATER = 1;
    public static DecimalFormat formatter01;
    public static DecimalFormat formatter2;
    public static DecimalFormat formatter4;

    static {
        formatter2 = new DecimalFormat("00");
        formatter4 = new DecimalFormat("0000");
        formatter01 = new DecimalFormat("###.#");
    }

    public static String getAbsoluteBaseName(String filename) {
        String base = null;
        String s = filename;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            base = s.substring(0, i);
        }
        return base;
    }

    public static String getExtension(String filename) {
        String ext = null;
        String s = filename;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean isGoodFormat(String filename) {
        boolean isGood = true;
        String base = Util.getAbsoluteBaseName(filename);
        String year = base.substring(base.length() - 10, base.length() - 6);
        String month = base.substring(base.length() - 6, base.length() - 4);
        String day = base.substring(base.length() - 4, base.length() - 2);
        String hour = base.substring(base.length() - 2);
        int yearCount = 0;
        while (yearCount < year.length()) {
            if (!Character.isDigit(year.charAt(yearCount))) {
                // empty if block
            }
            ++yearCount;
        }
        if (yearCount != year.length()) {
            isGood = false;
        }
        if (!Character.isDigit(month.charAt(0)) || !Character.isDigit(month.charAt(1)) || Integer.parseInt(month) > 12) {
            isGood = false;
        }
        if (!Character.isDigit(day.charAt(0)) || !Character.isDigit(day.charAt(1)) || Integer.parseInt(day) > 31) {
            isGood = false;
        }
        if (!Character.isDigit(hour.charAt(0)) || !Character.isDigit(hour.charAt(1)) || Integer.parseInt(hour) > 24) {
            isGood = false;
        }
        return isGood;
    }

    public static Point2D.Float transformDrawingAreaPixelToRaster(Point dAreaP, DrawingArea dArea) {
        float x = (float)(dAreaP.getX() / dArea.getZoom() * dArea.getAdjustRasX() - (double)dArea.getXulRCoord() * dArea.getAdjustRasX());
        float y = (float)(dAreaP.getY() / dArea.getZoom() * dArea.getAdjustRasX() - (double)dArea.getYulRCoord() * dArea.getAdjustRasX());
        Point2D.Float rasP = new Point2D.Float(x, y);
        return rasP;
    }
}

