/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.Alpine3D;
import alpine3d.FileSpecIF;
import alpine3d.RasterImage;
import alpine3d.SurfaceArea;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LANDUSEStrategy
implements FileSpecIF {
    private Map valueMap = new HashMap();

    public LANDUSEStrategy() {
        this.valueMap.put(new Integer(0), "No Data");
        this.valueMap.put(new Integer(1), "Water");
        this.valueMap.put(new Integer(2), "Buildings");
        this.valueMap.put(new Integer(3), "Coniferous F.");
        this.valueMap.put(new Integer(4), "Deciduous F.");
        this.valueMap.put(new Integer(5), "Mixed F.");
        this.valueMap.put(new Integer(6), "Cereals");
        this.valueMap.put(new Integer(7), "Pasture");
        this.valueMap.put(new Integer(8), "Bush");
        this.valueMap.put(new Integer(10), "Bridge");
        this.valueMap.put(new Integer(11), "Road");
        this.valueMap.put(new Integer(13), "Firn");
        this.valueMap.put(new Integer(14), "Bare Ice");
        this.valueMap.put(new Integer(15), "Rock");
        this.valueMap.put(new Integer(18), "Fruits");
        this.valueMap.put(new Integer(19), "Vegetables");
        this.valueMap.put(new Integer(20), "Wheat");
        this.valueMap.put(new Integer(21), "Alpine Veg.");
        this.valueMap.put(new Integer(22), "Wetlands");
        this.valueMap.put(new Integer(23), "Rough Pasture");
        this.valueMap.put(new Integer(24), "Sub-Alpine Mead.");
        this.valueMap.put(new Integer(25), "Alpine Meadow");
        this.valueMap.put(new Integer(26), "Bare Soil Veg.");
        this.valueMap.put(new Integer(28), "Corn");
        this.valueMap.put(new Integer(29), "Grapes");
    }

    public String checkBoxLabel() {
        return "Landuse";
    }

    public int getEditIndex(Alpine3D a3d) {
        return a3d.getLusEditIndex();
    }

    public String getFiletype() {
        return "Landuse";
    }

    public Object[] getLegendColors(RasterImage rasImage) {
        Object[] panelArr = new JPanel[16];
        int i = 0;
        while (i < 16) {
            panelArr[i] = new JPanel();
            ++i;
        }
        panelArr[0].setBackground(Color.white);
        panelArr[1].setBackground(rasImage.getColor(1));
        panelArr[2].setBackground(rasImage.getColor(2));
        panelArr[3].setBackground(rasImage.getColor(3));
        panelArr[4].setBackground(rasImage.getColor(4));
        panelArr[5].setBackground(rasImage.getColor(5));
        panelArr[6].setBackground(rasImage.getColor(6));
        panelArr[7].setBackground(rasImage.getColor(7));
        panelArr[8].setBackground(rasImage.getColor(8));
        panelArr[9].setBackground(rasImage.getColor(11));
        panelArr[10].setBackground(rasImage.getColor(10));
        panelArr[11].setBackground(rasImage.getColor(14));
        panelArr[12].setBackground(rasImage.getColor(15));
        panelArr[13].setBackground(rasImage.getColor(18));
        panelArr[14].setBackground(rasImage.getColor(22));
        panelArr[15].setBackground(rasImage.getColor(26));
        return panelArr;
    }

    public Object[] getLegendText(RasterImage rasImage) {
        Object[] labelArr = new JLabel[16];
        int i = 0;
        while (i < 16) {
            labelArr[i] = new JLabel();
            labelArr[i].setFont(new Font("Dialog", 0, 11));
            ++i;
        }
        labelArr[15].setText("Bare Soil Veg");
        labelArr[14].setText("Wetlands");
        labelArr[13].setText("Fruits, Vegetables");
        labelArr[12].setText("Rock");
        labelArr[11].setText("Firn, Ice");
        labelArr[10].setText("Bridge");
        labelArr[9].setText("Road");
        labelArr[8].setText("Alpine Veg., Bush");
        labelArr[7].setText("Pasture");
        labelArr[6].setText("Cereals");
        labelArr[5].setText("Mixed Forest");
        labelArr[4].setText("Deciduous Forest");
        labelArr[3].setText("Coniferous Forest");
        labelArr[2].setText("Buildings");
        labelArr[1].setText("Water");
        labelArr[0].setText("No Data");
        return labelArr;
    }

    public ArrayList getPointList(Alpine3D a3d) {
        return a3d.getLusPointList();
    }

    public Map getPointMap(Alpine3D a3d) {
        return a3d.getLusPointMap();
    }

    public Map getUndoIndexMap(Alpine3D a3d) {
        return a3d.getLusUndoIndexMap();
    }

    public String getUnit() {
        return "";
    }

    public float getValue(SurfaceArea sArea, int i, int j) {
        return sArea.sPoint[i][j].getLanduse();
    }

    public float retransformeValue(float value) {
        return (int)value;
    }

    public byte[][] setColorArrays() {
        byte[][] colorMatrix = new byte[3][32];
        byte[] r = new byte[32];
        byte[] g = new byte[32];
        byte[] b = new byte[32];
        r[0] = -1;
        g[0] = -1;
        b[0] = -1;
        r[1] = 100;
        g[1] = -107;
        b[1] = -19;
        r[2] = -1;
        g[2] = 0;
        b[2] = 0;
        r[3] = 0;
        g[3] = 100;
        b[3] = 0;
        r[4] = 50;
        g[4] = -51;
        b[4] = 50;
        r[5] = 34;
        g[5] = -117;
        b[5] = 34;
        r[6] = -1;
        g[6] = -41;
        b[6] = 0;
        r[7] = -102;
        g[7] = -11;
        b[7] = 50;
        r[8] = 107;
        g[8] = -114;
        b[8] = 35;
        r[9] = -1;
        g[9] = -1;
        b[9] = -1;
        r[10] = -116;
        g[10] = -116;
        b[10] = -116;
        r[11] = 0;
        g[11] = 0;
        b[11] = 0;
        r[12] = -1;
        g[12] = -1;
        b[12] = -1;
        r[13] = -80;
        g[13] = -32;
        b[13] = -26;
        r[14] = -80;
        g[14] = -32;
        b[14] = -26;
        r[15] = 105;
        g[15] = 105;
        b[15] = 105;
        r[16] = -1;
        g[16] = -1;
        b[16] = -1;
        r[17] = -1;
        g[17] = -1;
        b[17] = -1;
        r[18] = -1;
        g[18] = 99;
        b[18] = 71;
        r[19] = -1;
        g[19] = 99;
        b[19] = 71;
        r[20] = -1;
        g[20] = -41;
        b[20] = 0;
        r[21] = 107;
        g[21] = -114;
        b[21] = 35;
        r[22] = 85;
        g[22] = 107;
        b[22] = 47;
        r[23] = -102;
        g[23] = -31;
        b[23] = 50;
        r[24] = -102;
        g[24] = -21;
        b[24] = 50;
        r[25] = -102;
        g[25] = -11;
        b[25] = 50;
        r[26] = -117;
        g[26] = 69;
        b[26] = 19;
        r[27] = -1;
        g[27] = -1;
        b[27] = -1;
        r[28] = -1;
        g[28] = -41;
        b[28] = 0;
        r[29] = -1;
        g[29] = 99;
        b[29] = 71;
        colorMatrix[0] = r;
        colorMatrix[1] = g;
        colorMatrix[2] = b;
        return colorMatrix;
    }

    public byte[] setDataBuffer(SurfaceArea sArea, int nColors, float lowerLimit, float upperLimit) {
        byte[] pixels = new byte[sArea.getNRows() * sArea.getNCols()];
        int k = 0;
        int i = 0;
        while (i < sArea.getNRows()) {
            int j = 0;
            while (j < sArea.getNCols()) {
                if (sArea.sPoint[i][j].isNoDataValue()) {
                    pixels[k] = 0;
                    ++k;
                } else {
                    pixels[k] = (byte)this.getValue(sArea, i, j);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return pixels;
    }

    public void setEditIndex(Alpine3D a3d, int value) {
        a3d.setLusEditIndex(value);
    }

    public String[] setLimits(int nColors, float lowerLimit, float upperLimit) {
        return null;
    }

    public void setValue(float value, SurfaceArea sArea, int i, int j) {
        sArea.sPoint[i][j].setLanduse((int)value);
    }

    public float transformeValue(float value) {
        return (int)value;
    }

    public String valueToString(float value) {
        return (String)this.valueMap.get(new Integer((int)value));
    }
}

