/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.text.ItemFormatter;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.view.TextItemEditor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.JScrollPane;

public class ExpandingTextItemEditor
extends TextItemEditor
implements Serializable {
    private int hMargin = 5;
    private Rectangle startRect;

    public ExpandingTextItemEditor(int alignment, ItemFormatter itemFormatter) {
        super(alignment, itemFormatter);
    }

    public ExpandingTextItemEditor(int alignment) {
        super(alignment);
    }

    public ExpandingTextItemEditor() {
    }

    public int getHMargin() {
        return this.hMargin;
    }

    public void setHMargin(int hMargin) {
        this.hMargin = hMargin;
    }

    public void startEdit(Object data, Rectangle bounds, ItemEditSite editSite) {
        bounds.width += this.hMargin;
        this.startRect = new Rectangle(bounds);
        super.startEdit(data, bounds, editSite);
        this.resizeComponent();
        int ss = this.getSelectionStart();
        int se = this.getSelectionEnd();
        int cp = this.getCaretPosition();
        this.setCaretPosition(0);
        this.setCaretPosition(cp);
        this.setSelectionStart(ss);
        this.setSelectionEnd(se);
    }

    public void changeBounds(Rectangle bounds) {
        this.setLocation(bounds.x, bounds.y);
        this.resizeComponent();
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.getID() == 401) {
            this.resizeComponent();
        }
    }

    private void resizeComponent() {
        Dimension ps = this.getPreferredSize();
        Dimension sz = this.getSize();
        if (sz.width != ps.width && ps.width > this.startRect.width) {
            Dimension newSize = new Dimension(0, sz.height);
            Rectangle hb = this.getHostBounds();
            newSize.width = ps.width + this.hMargin < hb.width + hb.x - this.getLocation().x ? ps.width + this.hMargin : hb.width + hb.x - this.getLocation().x;
            this.setSize(newSize);
        }
    }

    private Rectangle getHostBounds() {
        Container p = this.getParent();
        Container pp = p.getParent();
        if (pp instanceof ScrollPane) {
            Point sp = ((ScrollPane)pp).getScrollPosition();
            Dimension vp = ((ScrollPane)pp).getViewportSize();
            return new Rectangle(sp.x, sp.y, vp.width, vp.height);
        }
        if (pp instanceof JScrollPane) {
            return new Rectangle(((JScrollPane)pp).getViewport().getViewRect());
        }
        Rectangle hb = p.getBounds();
        if (hb == null) {
            return new Rectangle();
        }
        hb.x = 0;
        hb.y = 0;
        return hb;
    }
}

