/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnPaintListener;
import com.borland.dx.dataset.ColumnVariant;
import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ExceptionEvent;
import com.borland.dx.dataset.MatrixData;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.Variant;
import com.borland.dx.text.ItemEditMask;
import com.borland.dx.text.ItemFormatter;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jbcl.control.ExceptionDialog;
import com.borland.jbcl.control.MaskableTextItemEditor;
import com.borland.jbcl.control.PickListItemEditor;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.Res;
import com.borland.jbcl.view.BooleanToggleItemEditor;
import com.borland.jbcl.view.CheckboxItemPainter;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.ImageItemEditor;
import com.borland.jbcl.view.ImageItemPainter;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Component;
import java.awt.Frame;
import java.io.InputStream;

public class DataSetModel {
    private DataSet dataSet;
    private Column column;
    private Component component;
    private ItemPainter painter;
    private CustomItemPainter customPainter;
    private CustomItemEditor customEditor;
    private ColumnPaintListener paintListener;
    private ItemEditor editor;
    private ColumnVariant value;

    DataSetModel(DataSet dataSet, Column column, Component component) {
        this.dataSet = dataSet;
        this.column = column;
        this.component = component;
        this.value = new ColumnVariant(column, dataSet);
        this.editor = (ItemEditor)column.getItemEditor();
        this.painter = (ItemPainter)column.getItemPainter();
    }

    DataSet getDataSet() {
        return this.dataSet;
    }

    Column getColumn() {
        return this.column;
    }

    ItemPainter getPainter(Object value) {
        return this.getPainter(this.dataSet.getRow(), value);
    }

    ItemPainter getPainter(int row, Object object) {
        if (this.painter == null) {
            switch (this.column.getDataType()) {
                case 11: {
                    this.painter = new CheckboxItemPainter();
                    break;
                }
                case 12: {
                    this.painter = new ImageItemPainter();
                    break;
                }
                case 17: {
                    this.painter = new TextItemPainter((ItemFormatter)this.column.getFormatter());
                    break;
                }
                default: {
                    this.painter = new TextItemPainter((ItemFormatter)this.column.getFormatter());
                }
            }
            this.paintListener = this.column.getColumnPaintListener();
            if (this.paintListener != null) {
                this.customPainter = new CustomItemPainter((ItemPainter)new SelectableItemPainter(this.painter));
                this.painter = new FocusableItemPainter(this.customPainter);
            } else {
                this.painter = new FocusableItemPainter((ItemPainter)new SelectableItemPainter(this.painter));
            }
        }
        if (this.paintListener != null) {
            if (this.customPainter == null) {
                this.customPainter = new CustomItemPainter((ItemPainter)new SelectableItemPainter(this.painter));
                this.painter = new FocusableItemPainter(this.customPainter);
            }
            this.customPainter.reset();
            this.paintListener.painting(this.dataSet, this.column, row, (Variant)object, (CustomPaintSite)this.customPainter);
        }
        return this.painter;
    }

    ItemEditor getEditor() {
        if (this.editor == null) {
            switch (this.column.getDataType()) {
                case 11: {
                    this.editor = new BooleanToggleItemEditor();
                    break;
                }
                case 12: {
                    this.editor = new ImageItemEditor();
                    break;
                }
                default: {
                    PickListDescriptor pickList = this.column.getPickList();
                    if (pickList != null) {
                        PickListItemEditor pickListEditor = new PickListItemEditor();
                        pickListEditor.setCachePickList(true);
                        this.editor = pickListEditor;
                        break;
                    }
                    int precision = -1;
                    ItemEditMask mask = this.column.getEditMasker();
                    if (this.column.getDataType() == 16 && mask == null) {
                        precision = this.column.getPrecision();
                    }
                    this.editor = new MaskableTextItemEditor((ItemFormatter)this.column.getFormatter(), mask);
                }
            }
            this.paintListener = this.column.getColumnPaintListener();
            if (this.paintListener != null) {
                this.customEditor = new CustomItemEditor(this.editor);
                this.editor = this.customEditor;
            }
        }
        if (this.paintListener != null) {
            if (this.customEditor == null) {
                this.customEditor = new CustomItemEditor(this.editor);
                this.editor = this.customEditor;
            }
            this.customEditor.reset();
            this.paintListener.editing(this.dataSet, this.column, (CustomPaintSite)this.customEditor);
        }
        return this.editor;
    }

    final void addDataChangeListener(DataChangeListener listener) {
        this.dataSet.addDataChangeListener(listener);
    }

    final void addNavigationListener(NavigationListener listener) {
        this.dataSet.addNavigationListener(listener);
    }

    final void handleThisException(Exception ex) {
        DataSetModel.handleException(this.dataSet, this.component, ex);
    }

    final Variant get() {
        try {
            this.dataSet.getDisplayVariant(this.column.getOrdinal(), this.dataSet.getRow(), (Variant)this.value);
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
        catch (Exception ex) {
            this.handleThisException(ex);
            this.value.setUnassignedNull();
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
    }

    final Variant get(int row) {
        if (this.column == null) {
            return null;
        }
        try {
            this.dataSet.getDisplayVariant(this.column.getOrdinal(), row, (Variant)this.value);
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
        catch (Exception ex) {
            this.handleThisException(ex);
            this.value.setUnassignedNull();
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
    }

    final int getRowCount() {
        try {
            int n = this.dataSet.getRowCount();
            return n;
        }
        catch (Exception ex) {
            this.handleThisException(ex);
            int n = 0;
            return n;
        }
    }

    final boolean canSet(boolean startEdit) {
        return this.canSet(this.dataSet.getRow(), startEdit);
    }

    final boolean canSet(int row, boolean startEdit) {
        if (!this.column.isEditable()) {
            return false;
        }
        try {
            if (startEdit) {
                this.dataSet.startEdit(this.column);
            } else {
                this.dataSet.startEditCheck(this.column);
            }
            boolean bl = true;
            return bl;
        }
        catch (DataSetException ex) {
            this.handleThisException((Exception)((Object)ex));
            return false;
        }
    }

    private final void setVariant(Variant value) throws DataSetException {
        int ordinal = this.column.getOrdinal();
        this.dataSet.setDisplayVariant(ordinal, value);
    }

    final void set(Object data) {
        try {
            if (data instanceof Variant) {
                this.setVariant((Variant)data);
            } else if (data instanceof InputStream) {
                this.dataSet.setInputStream(this.column.getOrdinal(), (InputStream)data);
            } else if (data instanceof ReadRow && this.column.getPickList() != null) {
                PickListDescriptor pickList = this.column.getPickList();
                ReadRow.copyTo((String[])pickList.getPickListColumns(), (ReadRow)((ReadRow)data), (String[])pickList.getDestinationColumns(), (ReadWriteRow)this.dataSet);
            } else if (data != null) {
                this.column.getFormatter().parse(data.toString(), (Variant)this.value);
                this.setVariant((Variant)this.value);
            } else {
                this.value.setAssignedNull();
                this.dataSet.setVariant(this.column.getOrdinal(), (Variant)this.value);
            }
        }
        catch (Exception ex) {
            this.handleThisException(ex);
            throw new IllegalArgumentException();
        }
    }

    final void set(int row, Object data) {
        if (row != this.dataSet.getRow()) {
            try {
                this.dataSet.goToRow(row);
            }
            catch (DataSetException ex) {
                this.handleThisException((Exception)((Object)ex));
                return;
            }
        }
        this.set(data);
    }

    void addRow(int aheadOf) {
        try {
            if (aheadOf != this.dataSet.getRow()) {
                this.dataSet.goToRow(aheadOf);
            }
            this.dataSet.insertRow(true);
        }
        catch (Exception ex) {
            this.handleThisException(ex);
        }
    }

    final void addRow() {
        try {
            if (!this.dataSet.atLast()) {
                if (this.dataSet.getStorageDataSet().provideMoreData()) {
                    return;
                }
                this.dataSet.last();
            }
            this.dataSet.insertRow(false);
        }
        catch (Exception ex) {
            this.handleThisException(ex);
        }
    }

    final void removeRow(int row) {
        try {
            if (row != this.dataSet.getRow()) {
                this.dataSet.goToRow(row);
            }
            this.dataSet.deleteRow();
        }
        catch (Exception ex) {
            this.handleThisException(ex);
        }
    }

    private static final Frame getFrame(Component component) {
        for (Component parent = component; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            return (Frame)parent;
        }
        return new Frame();
    }

    public static final void handleException(DataSet dataSet, Component component, Exception ex, boolean modal) {
        Frame frame = DataSetModel.getFrame(component);
        if (DataSetException.getExceptionListeners() != null) {
            DataSetException.getExceptionListeners().dispatch((DispatchableEvent)new ExceptionEvent(dataSet, component, (Throwable)ex));
        } else if ((dataSet == null || MatrixData.displayError((DataSet)dataSet, (Throwable)ex)) && frame != null && ExceptionDialog.getShowCount() < 1) {
            new ExceptionDialog(frame, Res._Error, ex, modal).setVisible(true);
        }
    }

    public static final void handleException(DataSet dataSet, Component component, Exception ex) {
        DataSetModel.handleException(dataSet, component, ex, false);
    }

    public static final void handleException(Component component, Exception ex, boolean modal) {
        DataSetModel.handleException(null, component, ex, modal);
    }

    public static final void handleException(Exception ex) {
        DataSetModel.handleException(null, null, ex);
    }

    public static final void handleException(Exception ex, boolean modal) {
        DataSetModel.handleException(null, null, ex, modal);
    }
}

