/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.SerializableImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;

public class TransparentImage
extends Component
implements Serializable {
    private transient Image canvas;
    protected transient Image image;
    protected String imageName;
    protected URL url;
    protected Color edgeColor = Color.black;
    protected boolean drawEdge = true;
    protected boolean transparent = true;
    protected int alignment = 68;

    public TransparentImage() {
        this.setSize(100, 100);
    }

    public void setImageName(String path) throws IOException {
        if (path != null && !path.equals("")) {
            this.setupImage(ImageLoader.load(path, (Component)this), path);
        } else {
            this.imageName = null;
            this.image = null;
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImage(Image image) throws IOException {
        this.setupImage(image, "");
    }

    public Image getImage() {
        return this.image;
    }

    public void setImageURL(URL url) throws IOException {
        this.url = url;
        this.setupImage(ImageLoader.load(url, (Component)this), url.toString());
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public int getAlignment() {
        return this.alignment;
    }

    protected void setupImage(Image im, String path) throws IOException {
        Graphics g;
        this.prepareImage(im, this);
        if ((this.checkImage(im, this) & 0x40) != 0) {
            throw new IOException(Res.bundle.format(24, new String[]{path}));
        }
        this.imageName = path;
        if (this.isVisible() && (g = this.getGraphics()) != null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.image = im;
        this.repaint(100L);
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.repaint(100L);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
        this.repaint(100L);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setDrawEdge(boolean drawEdge) {
        this.drawEdge = drawEdge;
        this.repaint(100L);
    }

    public boolean isDrawEdge() {
        return this.drawEdge;
    }

    public Dimension getPreferredSize() {
        return this.image != null ? new Dimension(this.image.getWidth(this), this.image.getHeight(this)) : new Dimension(100, 100);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics pg) {
        Dimension size = this.getSize();
        Color old = pg.getColor();
        Graphics g = pg;
        if (!this.transparent) {
            if (this.canvas == null || this.canvas.getWidth(null) != size.width || this.canvas.getHeight(null) != size.height) {
                this.canvas = this.createImage(size.width, size.height);
            }
            g = this.canvas.getGraphics();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (this.image != null) {
            int height;
            int width;
            int imageWidth = this.image.getWidth(null);
            int imageHeight = this.image.getHeight(null);
            int x = 0;
            switch (this.alignment & 0xF) {
                default: {
                    width = imageWidth;
                    break;
                }
                case 2: {
                    x = (size.width - imageWidth) / 2;
                    width = imageWidth;
                    break;
                }
                case 3: {
                    x = size.width - imageWidth;
                    width = imageWidth;
                    break;
                }
                case 4: {
                    width = size.width;
                }
            }
            int y = 0;
            switch (this.alignment & 0xF0) {
                default: {
                    height = imageHeight;
                    break;
                }
                case 32: {
                    y = (size.height - imageHeight) / 2;
                    height = imageHeight;
                    break;
                }
                case 48: {
                    y = size.height - imageHeight;
                    height = imageHeight;
                    break;
                }
                case 64: {
                    height = size.height;
                }
            }
            try {
                g.drawImage(this.image, x, y, width, height, this);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (!this.transparent) {
                pg.drawImage(this.canvas, 0, 0, null);
                g.dispose();
            }
        }
        if (this.drawEdge) {
            g.setColor(this.edgeColor);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        }
        g.setColor(old);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.image != null ? SerializableImage.create(this.image) : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof SerializableImage) {
            this.image = ((SerializableImage)data).getImage();
        }
    }
}

