/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.DrawingArea;
import alpine3d.MapImage;
import alpine3d.RasterImage;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    public static final int ALB = 5;
    public static final int ALPINE_MEADOW = 25;
    public static final int ALPINE_VEGETATION = 21;
    public static final int BARE_ICE = 14;
    public static final int BARE_SOIL_VEGETATION = 26;
    public static final int BRIDGE = 10;
    public static final int BUILT_UP = 2;
    public static final int BUSH = 8;
    public static final int CEREALS = 6;
    public static final int CONIFEROUS_F = 3;
    public static final int CORN = 28;
    public static final int DECIDUOUS_F = 4;
    public static final int DEM = 1;
    public static final int FIELD_CAPACITY = 101;
    public static final int FIRN = 13;
    public static final int FRUITS = 18;
    public static final int GRAPES = 29;
    public static final int INT_NODATA = -9999;
    public static final int LANDUSE = 100;
    public static final int LWR = 4;
    public static final int MIXED_F = 5;
    public static final int PASTURE = 7;
    public static final int ROAD = 11;
    public static final int ROCK = 15;
    public static final int ROUGH_PASTURE = 23;
    public static final int SDP = 8;
    public static final int SOIL_DEPTH = 102;
    public static final int SUB_ALPINE_MEADOW = 24;
    public static final int SURFACE_CODE = 2;
    public static final int SWE = 9;
    public static final int SWR = 3;
    public static final int TSS = 6;
    public static final int UNKNOWN = 10;
    public static final int VEGETABLES = 19;
    public static final int WATER = 1;
    public static final int WET = 7;
    public static final int WETLANDS = 22;
    public static final int WHEAT = 20;
    public static final String alb = "alb";
    public static final String dem = "dem";
    public static Map fileSpecStrategyMap;
    public static DecimalFormat formatter01;
    public static DecimalFormat formatter2;
    public static DecimalFormat formatter4;
    public static final String grd = "grd";
    public static final String lus = "lus";
    public static final String lwr = "lwr";
    public static final String sdp = "sdp";
    public static final String swe = "swe";
    public static final String swr = "swr";
    public static final String tss = "tss";
    public static final String txt = "txt";
    public static final String wet = "wet";

    static {
        formatter2 = new DecimalFormat("00");
        formatter4 = new DecimalFormat("0000");
        formatter01 = new DecimalFormat("###.#");
        fileSpecStrategyMap = new HashMap();
    }

    public static String getAbsoluteBaseName(String filename) {
        String base = null;
        String s = filename;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            base = s.substring(0, i);
        }
        return base;
    }

    public static String getAbsoluteBaseName(File f) {
        String base = null;
        String s = f.getAbsolutePath();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            base = s.substring(0, i);
        }
        return base;
    }

    public static String getExtension(String filename) {
        String ext = null;
        String s = filename;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean isEven(int n) {
        int i = 0;
        while (i < 1000000) {
            if (n == 2 * i) {
                return true;
            }
            if (n == 2 * i + 1) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static boolean isGoodFormat(String filename) {
        boolean isGood = true;
        String base = Utils.getAbsoluteBaseName(filename);
        String year = base.substring(base.length() - 10, base.length() - 6);
        String month = base.substring(base.length() - 6, base.length() - 4);
        String day = base.substring(base.length() - 4, base.length() - 2);
        String hour = base.substring(base.length() - 2);
        int yearCount = 0;
        while (yearCount < year.length()) {
            if (!Character.isDigit(year.charAt(yearCount))) {
                // empty if block
            }
            ++yearCount;
        }
        if (yearCount != year.length()) {
            isGood = false;
        }
        if (!Character.isDigit(month.charAt(0)) || !Character.isDigit(month.charAt(1)) || Integer.parseInt(month) > 12) {
            isGood = false;
        }
        if (!Character.isDigit(day.charAt(0)) || !Character.isDigit(day.charAt(1)) || Integer.parseInt(day) > 31) {
            isGood = false;
        }
        if (!Character.isDigit(hour.charAt(0)) || !Character.isDigit(hour.charAt(1)) || Integer.parseInt(hour) > 24) {
            isGood = false;
        }
        return isGood;
    }

    public static boolean isImage(File f) {
        String ext = Utils.getExtension(f);
        return ext.equals("png") || ext.equals("jpg") || ext.equals("gif");
    }

    public static boolean isSNOWPACKFile(File f) {
        String ext = Utils.getExtension(f);
        return ext.equals("met") || ext.equals("pro");
    }

    public static boolean isYear(String test) {
        try {
            int year = Integer.parseInt(test);
            if (year < 10000 && year > 999) {
                return true;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return false;
    }

    public static Point2D.Float transformDrawingAreaPixelToGrid(Point dAreaP, MapImage mImage, RasterImage rImage, DrawingArea dArea) {
        float y;
        float x;
        if (mImage != null) {
            x = (float)(dAreaP.getX() * (double)mImage.getXCellsize() / dArea.getZoom() + (double)dArea.getXulGrid());
            y = (float)(dAreaP.getY() * -1.0 * (double)mImage.getYCellsize() / dArea.getZoom() + (double)dArea.getYulGrid());
        } else if (rImage != null) {
            x = (float)(dAreaP.getX() * (double)rImage.getSurfaceArea().getCellsize() / dArea.getZoom() + (double)dArea.getXulGrid());
            y = (float)(dAreaP.getY() * -1.0 * (double)rImage.getSurfaceArea().getCellsize() / dArea.getZoom() + (double)dArea.getYulGrid());
        } else {
            return new Point2D.Float(0.0f, 0.0f);
        }
        Point2D.Float grid = new Point2D.Float(x, y);
        return grid;
    }

    public static Point2D.Float transformDrawingAreaPixelToRaster(Point dAreaP, DrawingArea dArea) {
        float x = (float)(dAreaP.getX() / dArea.getZoom() * dArea.getAdjustRasX() - (double)dArea.getXulRCoord() * dArea.getAdjustRasX());
        float y = (float)(dAreaP.getY() / dArea.getZoom() * dArea.getAdjustRasX() - (double)dArea.getYulRCoord() * dArea.getAdjustRasX());
        Point2D.Float rasP = new Point2D.Float(x, y);
        return rasP;
    }

    public static Point transformGridToDrawingAreaPixel(Point2D.Float grid, MapImage mImage1, RasterImage actRImage, DrawingArea dArea) {
        int y;
        int x;
        if (mImage1 != null) {
            x = (int)((grid.getX() - (double)dArea.getXulGrid()) * dArea.getZoom() / (double)mImage1.getXCellsize());
            y = (int)((grid.getY() - (double)dArea.getYulGrid()) * -1.0 * dArea.getZoom() / (double)mImage1.getYCellsize());
        } else if (actRImage != null) {
            x = (int)((grid.getX() - (double)dArea.getXulGrid()) * dArea.getZoom() / (double)actRImage.getSurfaceArea().getCellsize());
            y = (int)((grid.getY() - (double)dArea.getYulGrid()) * -1.0 * dArea.getZoom() / (double)actRImage.getSurfaceArea().getCellsize());
        } else {
            return null;
        }
        Point pixel = new Point(x, y);
        return pixel;
    }

    public static Point transformGridToRaster(Point2D.Float grid, RasterImage rImage) {
        int x = (int)((grid.getX() - (double)rImage.getSurfaceArea().getXllCorner()) / (double)rImage.getSurfaceArea().getCellsize());
        int y = (int)(-1.0 * (grid.getY() - (double)rImage.getSurfaceArea().getYulCorner()) / (double)rImage.getSurfaceArea().getCellsize());
        return new Point(x, y);
    }

    public static Point transformRasterToDrawingAreaPixel(Point2D.Float rasP, DrawingArea dArea) {
        int x = (int)(rasP.getX() * dArea.getZoom() / dArea.getAdjustRasX() + (double)dArea.getXulRCoord() * dArea.getZoom());
        int y = (int)(rasP.getY() * dArea.getZoom() / dArea.getAdjustRasX() + (double)dArea.getYulRCoord() * dArea.getZoom());
        Point pixel = new Point(x, y);
        return pixel;
    }
}

