/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.SurfaceArea;
import alpine3d.Utils;
import java.awt.Point;
import java.io.File;

public class SNOWPACKFile {
    private String filename;
    private Point location;
    private String name;

    public SNOWPACKFile(File file, SurfaceArea sArea) {
        this.filename = file.getAbsolutePath();
        this.name = file.getName();
        this.location = this.getLocation(file, sArea);
    }

    public String getFilename() {
        return this.filename;
    }

    private Point getLocation(File file, SurfaceArea sArea) {
        String base = Utils.getAbsoluteBaseName(file);
        int count = 0;
        int last = -1;
        int secLast = -1;
        int i = base.length() - 1;
        while (i >= 0) {
            if (base.charAt(i) == '_') {
                if (++count == 1) {
                    last = i;
                } else if (count == 2) {
                    secLast = i;
                }
            }
            --i;
        }
        if (last == -1 || secLast == -1) {
            return null;
        }
        int xCoord = Integer.parseInt(base.substring(secLast + 1, last));
        int yCoord = sArea.getNRows() - Integer.parseInt(base.substring(last + 1)) - 1;
        Point loc = new Point(xCoord, yCoord);
        return loc;
    }

    public Point getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public int getXCoord() {
        return (int)this.location.getX();
    }

    public int getYcoord() {
        return (int)this.location.getY();
    }
}

