/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.MyFileFilter;
import alpine3d.OpenFileChooser_cancelButton_actionAdapter;
import alpine3d.OpenFileChooser_openButton_actionAdapter;
import alpine3d.OpenFileChooser_radioButtonAdd_actionAdapter;
import alpine3d.OpenFileChooser_radioButtonIn_actionAdapter;
import alpine3d.OpenFileChooser_radioButtonOut_actionAdapter;
import alpine3d.Utils;
import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OpenFileChooser
extends JDialog
implements PropertyChangeListener {
    ButtonGroup buttonGroup1;
    JPanel buttonPanel;
    JButton cancelButton;
    String[] cb1;
    String[] cb2;
    String[] cb3;
    JComboBox comboBoxAdd;
    JComboBox comboBoxIn;
    JComboBox comboBoxOut;
    File file;
    FlowLayout flowLayout1;
    JFileChooser jFileChooser1;
    JButton openButton;
    JPanel panel1 = new JPanel();
    JRadioButton radioButtonAdd;
    JRadioButton radioButtonBuffer;
    JRadioButton radioButtonIn;
    JRadioButton radioButtonOut;
    JPanel select1Panel;
    JPanel select2Panel;
    JPanel select3Panel;
    JPanel selectPanel;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    VerticalFlowLayout verticalFlowLayout2;
    VerticalFlowLayout verticalFlowLayout3;
    VerticalFlowLayout verticalFlowLayout4;

    public OpenFileChooser(File file) {
        this.selectPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.select1Panel = new JPanel();
        this.select2Panel = new JPanel();
        this.select3Panel = new JPanel();
        this.cb1 = new String[]{"Elevation Model", "Surface Code"};
        this.cb2 = new String[]{"Surface Temperature", "Shortwave Radiation", "Longwave Radiation", "Albedo", "Snowwater Equivalent", "Snowwater Content", "Snowdepth", "Unknown Raster"};
        this.cb3 = new String[]{"Map", "GPS Data", "SNOWPACK File"};
        this.verticalFlowLayout2 = new VerticalFlowLayout();
        this.radioButtonIn = new JRadioButton();
        this.comboBoxIn = new JComboBox<String>(this.cb1);
        this.verticalFlowLayout3 = new VerticalFlowLayout();
        this.verticalFlowLayout4 = new VerticalFlowLayout();
        this.comboBoxOut = new JComboBox<String>(this.cb2);
        this.comboBoxAdd = new JComboBox<String>(this.cb3);
        this.radioButtonOut = new JRadioButton();
        this.radioButtonAdd = new JRadioButton();
        this.radioButtonBuffer = new JRadioButton();
        this.flowLayout1 = new FlowLayout();
        this.openButton = new JButton();
        this.cancelButton = new JButton();
        this.buttonGroup1 = new ButtonGroup();
        try {
            this.jbInit(file);
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void enableBox() {
        if (this.radioButtonIn.isSelected()) {
            this.comboBoxIn.setEnabled(true);
            this.comboBoxOut.setEnabled(false);
            this.comboBoxAdd.setEnabled(false);
            this.openButton.setEnabled(true);
        } else if (this.radioButtonOut.isSelected()) {
            this.comboBoxOut.setEnabled(true);
            this.comboBoxIn.setEnabled(false);
            this.comboBoxAdd.setEnabled(false);
            this.openButton.setEnabled(true);
        } else if (this.radioButtonAdd.isSelected()) {
            this.comboBoxAdd.setEnabled(true);
            this.comboBoxIn.setEnabled(false);
            this.comboBoxOut.setEnabled(false);
            this.openButton.setEnabled(true);
        }
    }

    private void jbInit(File file) throws Exception {
        this.jFileChooser1 = new JFileChooser(file);
        this.panel1.setLayout(this.verticalFlowLayout1);
        this.select1Panel.setLayout(this.verticalFlowLayout2);
        this.radioButtonIn.setPreferredSize(new Dimension(97, 23));
        this.radioButtonIn.setText("Input Data");
        this.radioButtonIn.addActionListener(new OpenFileChooser_radioButtonIn_actionAdapter(this));
        this.select2Panel.setLayout(this.verticalFlowLayout3);
        this.select3Panel.setLayout(this.verticalFlowLayout4);
        this.radioButtonOut.setPreferredSize(new Dimension(97, 23));
        this.radioButtonOut.setText("Output Data");
        this.radioButtonOut.addActionListener(new OpenFileChooser_radioButtonOut_actionAdapter(this));
        this.radioButtonAdd.setToolTipText("");
        this.radioButtonAdd.setText("Additional Data");
        this.radioButtonAdd.addActionListener(new OpenFileChooser_radioButtonAdd_actionAdapter(this));
        this.radioButtonBuffer.setSelected(true);
        this.buttonPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(5);
        this.openButton.setPreferredSize(new Dimension(67, 25));
        this.openButton.setText("Open");
        this.openButton.setEnabled(false);
        this.openButton.addActionListener(new OpenFileChooser_openButton_actionAdapter(this));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new OpenFileChooser_cancelButton_actionAdapter(this));
        this.jFileChooser1.setControlButtonsAreShown(false);
        this.comboBoxIn.setBackground(Color.white);
        this.comboBoxIn.setEnabled(false);
        this.comboBoxOut.setBackground(Color.white);
        this.comboBoxOut.setEnabled(false);
        this.comboBoxAdd.setBackground(Color.white);
        this.comboBoxAdd.setEnabled(false);
        this.buttonGroup1.add(this.radioButtonIn);
        this.buttonGroup1.add(this.radioButtonOut);
        this.buttonGroup1.add(this.radioButtonAdd);
        this.buttonGroup1.add(this.radioButtonBuffer);
        this.setTitle("Open");
        this.verticalFlowLayout1.setHgap(5);
        this.verticalFlowLayout1.setVgap(0);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jFileChooser1, null);
        this.panel1.add((Component)this.selectPanel, null);
        this.selectPanel.add((Component)this.select1Panel, null);
        this.select1Panel.add((Component)this.radioButtonIn, null);
        this.select1Panel.add((Component)this.comboBoxIn, null);
        this.selectPanel.add((Component)this.select2Panel, null);
        this.select2Panel.add((Component)this.radioButtonOut, null);
        this.select2Panel.add((Component)this.comboBoxOut, null);
        this.selectPanel.add((Component)this.select3Panel, null);
        this.select3Panel.add((Component)this.radioButtonAdd, null);
        this.select3Panel.add((Component)this.comboBoxAdd, null);
        this.panel1.add((Component)this.buttonPanel, null);
        this.buttonPanel.add((Component)this.openButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.enableBox();
        this.jFileChooser1.addPropertyChangeListener(this);
        MyFileFilter lusfilter = new MyFileFilter();
        MyFileFilter swrfilter = new MyFileFilter();
        MyFileFilter lwrfilter = new MyFileFilter();
        MyFileFilter tssfilter = new MyFileFilter();
        MyFileFilter demfilter = new MyFileFilter();
        MyFileFilter albfilter = new MyFileFilter();
        MyFileFilter sdpfilter = new MyFileFilter();
        MyFileFilter swefilter = new MyFileFilter();
        MyFileFilter wetfilter = new MyFileFilter();
        MyFileFilter txtfilter = new MyFileFilter();
        MyFileFilter imagefilter = new MyFileFilter();
        MyFileFilter snfilter = new MyFileFilter();
        lusfilter.addExtension("lus");
        swrfilter.addExtension("swr");
        lwrfilter.addExtension("lwr");
        demfilter.addExtension("dem");
        demfilter.addExtension("grd");
        albfilter.addExtension("alb");
        tssfilter.addExtension("tss");
        sdpfilter.addExtension("sdp");
        swefilter.addExtension("swe");
        wetfilter.addExtension("wet");
        imagefilter.addExtension("png");
        imagefilter.addExtension("jpg");
        imagefilter.addExtension("gif");
        snfilter.addExtension("met");
        snfilter.addExtension("pro");
        txtfilter.addExtension("txt");
        lusfilter.setDescription("Landuse Files");
        swrfilter.setDescription("Shortwave Radiation");
        lwrfilter.setDescription("Longwave Radiation");
        demfilter.setDescription("Elevation Models");
        albfilter.setDescription("Albedo");
        tssfilter.setDescription("Surface Temp.");
        sdpfilter.setDescription("Snowdepth");
        swefilter.setDescription("Snowwater Equivalent");
        wetfilter.setDescription("Snowwater Content");
        imagefilter.setDescription("Image");
        snfilter.setDescription("SNOWPACK Files");
        txtfilter.setDescription("GPS Data");
        this.jFileChooser1.addChoosableFileFilter(demfilter);
        this.jFileChooser1.addChoosableFileFilter(lusfilter);
        this.jFileChooser1.addChoosableFileFilter(swrfilter);
        this.jFileChooser1.addChoosableFileFilter(lwrfilter);
        this.jFileChooser1.addChoosableFileFilter(tssfilter);
        this.jFileChooser1.addChoosableFileFilter(albfilter);
        this.jFileChooser1.addChoosableFileFilter(sdpfilter);
        this.jFileChooser1.addChoosableFileFilter(swefilter);
        this.jFileChooser1.addChoosableFileFilter(wetfilter);
        this.jFileChooser1.addChoosableFileFilter(imagefilter);
        this.jFileChooser1.addChoosableFileFilter(snfilter);
        this.jFileChooser1.addChoosableFileFilter(txtfilter);
        this.jFileChooser1.setAcceptAllFileFilterUsed(true);
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("SelectedFileChangedProperty".equals(prop) && e.getNewValue() != null) {
            this.file = (File)e.getNewValue();
            String extension = Utils.getExtension(this.file);
            if (extension != null) {
                if (extension.equals("dem") || extension.equals("grd")) {
                    this.radioButtonIn.setSelected(true);
                    this.comboBoxIn.setEnabled(true);
                    this.comboBoxIn.setSelectedIndex(0);
                } else if (extension.equals("lus")) {
                    this.radioButtonIn.setSelected(true);
                    this.comboBoxIn.setEnabled(true);
                    this.comboBoxIn.setSelectedIndex(1);
                } else if (extension.equals("tss")) {
                    this.radioButtonOut.setSelected(true);
                    this.comboBoxOut.setEnabled(true);
                    this.comboBoxOut.setSelectedIndex(0);
                } else if (extension.equals("swr")) {
                    this.radioButtonOut.setSelected(true);
                    this.comboBoxOut.setEnabled(true);
                    this.comboBoxOut.setSelectedIndex(1);
                } else if (extension.equals("lwr")) {
                    this.radioButtonOut.setSelected(true);
                    this.comboBoxOut.setEnabled(true);
                    this.comboBoxOut.setSelectedIndex(2);
                } else if (extension.equals("alb")) {
                    this.radioButtonOut.setSelected(true);
                    this.comboBoxOut.setEnabled(true);
                    this.comboBoxOut.setSelectedIndex(3);
                } else if (extension.equals("swe")) {
                    this.radioButtonOut.setSelected(true);
                    this.comboBoxOut.setEnabled(true);
                    this.comboBoxOut.setSelectedIndex(4);
                } else if (extension.equals("wet")) {
                    this.radioButtonOut.setSelected(true);
                    this.comboBoxOut.setEnabled(true);
                    this.comboBoxOut.setSelectedIndex(5);
                } else if (extension.equals("sdp")) {
                    this.radioButtonOut.setSelected(true);
                    this.comboBoxOut.setEnabled(true);
                    this.comboBoxOut.setSelectedIndex(6);
                } else if (Utils.isGoodFormat(this.file.getAbsolutePath())) {
                    this.radioButtonOut.setSelected(true);
                    this.comboBoxOut.setEnabled(true);
                    this.comboBoxOut.setSelectedIndex(7);
                } else if (Utils.isImage(this.file)) {
                    this.radioButtonAdd.setSelected(true);
                    this.comboBoxAdd.setEnabled(true);
                    this.comboBoxAdd.setSelectedIndex(0);
                } else if (Utils.isSNOWPACKFile(this.file)) {
                    this.radioButtonAdd.setSelected(true);
                    this.comboBoxAdd.setEnabled(true);
                    this.comboBoxAdd.setSelectedIndex(2);
                } else if (extension.equals("txt")) {
                    this.radioButtonAdd.setSelected(true);
                    this.comboBoxAdd.setEnabled(true);
                    this.comboBoxAdd.setSelectedIndex(1);
                } else {
                    this.radioButtonBuffer.setSelected(true);
                    this.comboBoxAdd.setEnabled(false);
                    this.comboBoxIn.setEnabled(false);
                    this.comboBoxOut.setEnabled(false);
                }
            }
        }
        this.enableBox();
    }

    void radioButtonAdd_actionPerformed(ActionEvent e) {
        this.comboBoxAdd.setEnabled(true);
        this.comboBoxIn.setEnabled(false);
        this.comboBoxOut.setEnabled(false);
        this.openButton.setEnabled(true);
    }

    void radioButtonIn_actionPerformed(ActionEvent e) {
        this.comboBoxIn.setEnabled(true);
        this.comboBoxOut.setEnabled(false);
        this.comboBoxAdd.setEnabled(false);
        this.openButton.setEnabled(true);
    }

    void radioButtonOut_actionPerformed(ActionEvent e) {
        this.comboBoxOut.setEnabled(true);
        this.comboBoxIn.setEnabled(false);
        this.comboBoxAdd.setEnabled(false);
        this.openButton.setEnabled(true);
    }
}

