/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.MapImage;
import alpine3d.RasterImage;
import alpine3d.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;

public class DrawingArea
extends JComponent {
    private ArrayList SNOWPACKPointList = new ArrayList();
    private double adjustRasX = 1.0;
    private double adjustRasY = 1.0;
    private final float[] dash1 = new float[]{10.0f};
    private final BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, this.dash1, 0.0f);
    private Line2D.Double dashedLine;
    private float diffX;
    private float diffY;
    private ArrayList editPointList;
    private ArrayList gpsTrackList;
    private ArrayList gpsWayPointList;
    private int mImageHeight = 0;
    private boolean mImageHidden = false;
    private boolean mImageToFront = false;
    private int mImageWidth = 0;
    private MapImage mapImage;
    private int rDrawHeight;
    private int rDrawWidth;
    private int rImageHeight = 0;
    private boolean rImageHidden = false;
    private int rImageWidth = 0;
    private RasterImage rasImage;
    private Rectangle rectangle;
    private final BasicStroke stroke = new BasicStroke(2.0f);
    private float xulGrid;
    private int xulMCoord;
    private int xulRCoord = 0;
    private float yulGrid;
    private int yulMCoord;
    private int yulRCoord = 0;
    private double zoom;
    private boolean zoomChanged = false;

    public DrawingArea() {
        this.editPointList = new ArrayList();
        this.gpsWayPointList = new ArrayList();
        this.gpsTrackList = new ArrayList();
    }

    public void deleteRectangle() {
        this.rectangle = null;
    }

    public void georeferenceImages(MapImage mImage, RasterImage rImage) {
        if (mImage != null && mImage.isGeoreferenced() && rImage != null) {
            int prefSizeY;
            int prefSizeX;
            this.mapImage = mImage;
            this.mImageHeight = this.mapImage.getImage().getHeight(null);
            this.mImageWidth = this.mapImage.getImage().getWidth(null);
            this.rasImage = rImage;
            this.rImageHeight = this.rasImage.getImage().getHeight(null);
            this.rImageWidth = this.rasImage.getImage().getWidth(null);
            this.adjustRasX = (double)mImage.getXCellsize() / (double)rImage.getSurfaceArea().getCellsize();
            this.adjustRasY = (double)mImage.getYCellsize() / (double)rImage.getSurfaceArea().getCellsize();
            this.rDrawWidth = (int)((double)this.rImageWidth / this.adjustRasX);
            this.rDrawHeight = (int)((double)this.rImageHeight / this.adjustRasY);
            this.diffX = mImage.getXulCorner() - rImage.getXulCorner();
            if (this.diffX < 0.0f) {
                this.xulMCoord = 0;
                this.xulRCoord = Math.round(Math.abs(this.diffX) / mImage.getXCellsize());
                prefSizeX = (int)(Math.max((double)this.xulRCoord + (double)this.rImageWidth / this.adjustRasX, (double)this.mImageWidth) * this.zoom);
            } else {
                this.xulMCoord = Math.round(Math.abs(this.diffX) / mImage.getXCellsize());
                this.xulRCoord = 0;
                prefSizeX = (int)(Math.max((double)(this.xulMCoord + this.mImageWidth), (double)this.rImageWidth / this.adjustRasX) * this.zoom);
            }
            this.diffY = mImage.getYulCorner() - rImage.getYulCorner();
            if (this.diffY < 0.0f) {
                this.yulMCoord = Math.round(Math.abs(this.diffY) / mImage.getYCellsize());
                this.yulRCoord = 0;
                prefSizeY = (int)(Math.max((double)(this.yulMCoord + this.mImageHeight), (double)this.rImageHeight / this.adjustRasY) * this.zoom);
            } else {
                this.yulMCoord = 0;
                this.yulRCoord = Math.round(Math.abs(this.diffY) / mImage.getYCellsize());
                prefSizeY = (int)(Math.max((double)this.yulRCoord + (double)this.rImageHeight / this.adjustRasY, (double)this.mImageHeight) * this.zoom);
            }
            this.setPreferredSize(new Dimension(prefSizeX, prefSizeY));
            this.xulGrid = Math.min(mImage.getXulCorner(), rImage.getXulCorner());
            this.yulGrid = Math.max(mImage.getYulCorner(), rImage.getYulCorner());
        } else if (rImage != null) {
            this.mapImage = null;
            this.rasImage = rImage;
            this.rImageHeight = this.rasImage.getImage().getHeight(null);
            this.rImageWidth = this.rasImage.getImage().getWidth(null);
            if (!this.zoomChanged) {
                this.zoom = 822.0 / (double)this.rImageWidth;
            }
            this.setPreferredSize(new Dimension((int)((double)this.rImageWidth * this.zoom), (int)((double)this.rImageHeight * this.zoom)));
            this.xulGrid = rImage.getXulCorner();
            this.yulGrid = rImage.getYulCorner();
        } else if (mImage != null) {
            this.rasImage = null;
            this.mapImage = mImage;
            this.mImageHeight = this.mapImage.getImage().getHeight(null);
            this.mImageWidth = this.mapImage.getImage().getWidth(null);
            if (!this.zoomChanged) {
                this.zoom = 1000.0 / (double)this.mImageWidth;
            }
            this.setPreferredSize(new Dimension((int)((double)this.mImageWidth * this.zoom), (int)((double)this.mImageHeight * this.zoom)));
            this.xulGrid = mImage.getXulCorner();
            this.yulGrid = mImage.getYulCorner();
        } else {
            this.rasImage = null;
            this.mapImage = null;
            this.setPreferredSize(new Dimension(0, 0));
        }
    }

    public double getAdjustRasX() {
        return this.adjustRasX;
    }

    public Line2D.Double getDashedLine() {
        return this.dashedLine;
    }

    public ArrayList getEditPointList() {
        return this.editPointList;
    }

    public ArrayList getGpsTrackList() {
        return this.gpsTrackList;
    }

    public ArrayList getGpsWayPointList() {
        return this.gpsWayPointList;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public ArrayList getSNOWPACKPointList() {
        return this.SNOWPACKPointList;
    }

    public float getXulGrid() {
        return this.xulGrid;
    }

    public int getXulMCoord() {
        return this.xulMCoord;
    }

    public int getXulRCoord() {
        return this.xulRCoord;
    }

    public float getYulGrid() {
        return this.yulGrid;
    }

    public int getYulMCoord() {
        return this.yulMCoord;
    }

    public int getYulRCoord() {
        return this.yulRCoord;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void initRectangle(Point p) {
        this.rectangle = new Rectangle(p);
    }

    public boolean isMImageHidden() {
        return this.mImageHidden;
    }

    public boolean isMImageToFront() {
        return this.mImageToFront;
    }

    public boolean isRImageHidden() {
        return this.rImageHidden;
    }

    public boolean isZoomChanged() {
        return this.zoomChanged;
    }

    public void paint(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        if (this.mapImage != null && !this.mImageHidden && this.rasImage != null) {
            if (this.mImageToFront) {
                if (!this.rImageHidden) {
                    g2.drawImage(this.rasImage.getImage(), (int)((double)this.xulRCoord * this.zoom), (int)((double)this.yulRCoord * this.zoom), (int)((double)this.rDrawWidth * this.zoom), (int)((double)this.rDrawHeight * this.zoom), null);
                }
                g2.drawImage(this.mapImage.getImage(), (int)((double)this.xulMCoord * this.zoom), (int)((double)this.yulMCoord * this.zoom), (int)((double)this.mImageWidth * this.zoom), (int)((double)this.mImageHeight * this.zoom), null);
            } else {
                g2.drawImage(this.mapImage.getImage(), (int)((double)this.xulMCoord * this.zoom), (int)((double)this.yulMCoord * this.zoom), (int)((double)this.mImageWidth * this.zoom), (int)((double)this.mImageHeight * this.zoom), null);
                if (!this.rImageHidden) {
                    g2.drawImage(this.rasImage.getImage(), (int)((double)this.xulRCoord * this.zoom), (int)((double)this.yulRCoord * this.zoom), (int)((double)this.rDrawWidth * this.zoom), (int)((double)this.rDrawHeight * this.zoom), null);
                }
            }
        } else if (this.mImageHidden && this.rasImage != null && !this.rImageHidden) {
            g2.drawImage(this.rasImage.getImage(), (int)((double)this.xulRCoord * this.zoom), (int)((double)this.yulRCoord * this.zoom), (int)((double)this.rDrawWidth * this.zoom), (int)((double)this.rDrawHeight * this.zoom), null);
        } else if (this.mapImage != null && !this.mImageHidden) {
            g2.drawImage(this.mapImage.getImage(), 0, 0, (int)((double)this.mImageWidth * this.zoom), (int)((double)this.mImageHeight * this.zoom), null);
        } else if (this.rasImage != null && !this.rImageHidden) {
            g2.drawImage(this.rasImage.getImage(), 0, 0, (int)((double)this.rImageWidth * this.zoom), (int)((double)this.rImageHeight * this.zoom), null);
        }
        if (!this.editPointList.isEmpty()) {
            i = 0;
            while (i < this.editPointList.size() - 1) {
                Point p1 = Utils.transformRasterToDrawingAreaPixel((Point2D.Float)this.editPointList.get(i), this);
                Point p2 = Utils.transformRasterToDrawingAreaPixel((Point2D.Float)this.editPointList.get(i + 1), this);
                Line2D.Float line = new Line2D.Float(p1, p2);
                g2.setColor(Color.red);
                g2.setStroke(this.stroke);
                g2.draw(line);
                ++i;
            }
        }
        if (this.dashedLine != null) {
            g2.setStroke(this.dashed);
            g2.setColor(Color.red);
            g2.draw(this.dashedLine);
        }
        if (!this.SNOWPACKPointList.isEmpty()) {
            i = 0;
            while (i < this.SNOWPACKPointList.size()) {
                g2.setStroke(this.stroke);
                g2.setColor(Color.white);
                Point snPoint = (Point)this.SNOWPACKPointList.get(i);
                Rectangle2D.Double rec = new Rectangle2D.Double(snPoint.getX() * this.zoom / this.adjustRasX + (double)this.xulRCoord * this.zoom, snPoint.getY() * this.zoom / this.adjustRasX + (double)this.yulRCoord * this.zoom, this.zoom / this.adjustRasX, this.zoom / this.adjustRasX);
                Ellipse2D.Double ell = this.zoom / this.adjustRasX < 10.0 ? new Ellipse2D.Double((snPoint.getX() - 2.0) * this.zoom / this.adjustRasX + (double)this.xulRCoord * this.zoom, (snPoint.getY() - 2.0) * this.zoom / this.adjustRasX + (double)this.yulRCoord * this.zoom, this.zoom / this.adjustRasX * 5.0, this.zoom / this.adjustRasX * 5.0) : new Ellipse2D.Double((snPoint.getX() - 1.0) * this.zoom / this.adjustRasX + (double)this.xulRCoord * this.zoom, (snPoint.getY() - 1.0) * this.zoom / this.adjustRasX + (double)this.yulRCoord * this.zoom, this.zoom / this.adjustRasX * 3.0, this.zoom / this.adjustRasX * 3.0);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2.draw(rec);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.draw(ell);
                ++i;
            }
        }
        if (!this.gpsWayPointList.isEmpty()) {
            i = 0;
            while (i < this.gpsWayPointList.size()) {
                Point p = Utils.transformGridToDrawingAreaPixel((Point2D.Float)this.gpsWayPointList.get(i), this.mapImage, this.rasImage, this);
                Ellipse2D.Double ell = new Ellipse2D.Double();
                if (this.mapImage != null || this.rasImage != null) {
                    ell.setFrameFromCenter(p.getLocation(), new Point((int)(p.getX() - 5.0), (int)(p.getY() - 5.0)));
                }
                if (this.rasImage == null || this.rImageHidden) {
                    g2.setColor(Color.red);
                } else {
                    g2.setColor(Color.magenta);
                }
                g2.fill(ell);
                ++i;
            }
        }
        if (!(this.gpsTrackList.isEmpty() || this.mapImage == null && this.rasImage == null)) {
            i = 0;
            while (i < this.gpsTrackList.size()) {
                ArrayList trPList = (ArrayList)this.gpsTrackList.get(i);
                int j = 0;
                while (j < trPList.size() - 1) {
                    Point p1 = Utils.transformGridToDrawingAreaPixel((Point2D.Float)trPList.get(j), this.mapImage, this.rasImage, this);
                    Point p2 = Utils.transformGridToDrawingAreaPixel((Point2D.Float)trPList.get(j + 1), this.mapImage, this.rasImage, this);
                    Line2D.Double line = new Line2D.Double(p1, p2);
                    if (this.rasImage == null || this.rImageHidden) {
                        g2.setColor(Color.red);
                    } else {
                        g2.setColor(Color.magenta);
                    }
                    g2.setStroke(this.stroke);
                    g2.draw(line);
                    ++j;
                }
                ++i;
            }
        }
        if (this.rectangle != null) {
            g2.setStroke(this.stroke);
            g2.setColor(new Color(0, 255, 0, 120));
            g2.draw(this.rectangle);
            g2.fill(this.rectangle);
        }
    }

    public void resetAdjustRaster() {
        this.adjustRasX = 1.0;
        this.adjustRasY = 1.0;
        this.xulRCoord = 0;
        this.yulRCoord = 0;
    }

    public void setDashedLine(Line2D.Double line) {
        this.dashedLine = line;
    }

    public void setGpsTrackList(ArrayList aL) {
        this.gpsTrackList = (ArrayList)aL.clone();
    }

    public void setGpsWayPointList(ArrayList aL) {
        this.gpsWayPointList = (ArrayList)aL.clone();
    }

    public void setMImageHidden(boolean value) {
        this.mImageHidden = value;
    }

    public void setMImageToFront(boolean value) {
        this.mImageToFront = value;
    }

    public void setRImageHidden(boolean value) {
        this.rImageHidden = value;
    }

    public void setSNOWPACKPointList(ArrayList list) {
        this.SNOWPACKPointList = list;
    }

    public void setZoom(double value) {
        this.zoom = value;
    }

    public void setZoomChanged(boolean value) {
        this.zoomChanged = value;
    }
}

