/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.BoundedChangeListener;
import ProWin.ColorTab;
import ProWin.DataEntry;
import ProWin.DataFile;
import ProWin.IniFile;
import ProWin.MenuFrame;
import ProWin.ModelDialog;
import ProWin.Setup;
import ProWin.SnowPackFrame;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

public class SnowPackDoc {
    int DAY = 86400;
    int HOUR = 3600;
    int[] IdCode;
    float MAX_Y_ZOOM_VALUE;
    int MINUTE = 60;
    float MIN_Y_ZOOM_DIFFERENCE;
    String[] Name2;
    int NrOfParameters;
    String PARDATA_Filename = "";
    boolean activeSliderMovement = true;
    ChangeListener changeListener;
    DataFile dataFile;
    DataEntry datafile_m_ActDataEntry;
    int datafile_m_ActDataEntryIndex;
    GregorianCalendar datafile_m_ActEndTime;
    int datafile_m_ActEndTimeIndex;
    GregorianCalendar datafile_m_ActStartTime;
    int datafile_m_ActStartTimeIndex;
    int datafile_m_GetEndTimeIndex;
    int datafile_m_GetStartTimeIndex;
    float datafile_m_IdMaxValue;
    float datafile_m_IdMinValue;
    boolean datafile_m_IdSoilDataExist;
    boolean datafile_m_SoilDataExist;
    int datafile_m_TimeStepsWithoutData;
    JButton jButton_Down;
    JButton jButton_End;
    JButton jButton_Home;
    JButton jButton_Next;
    JButton jButton_Prev;
    JButton jButton_Remove;
    JButton jButton_Up;
    JSlider jSlider;
    MenuFrame mFrame;
    DataEntry m_ActDataEntry = null;
    GregorianCalendar m_ActTime = null;
    GregorianCalendar m_AnimationEndTime = null;
    GregorianCalendar m_AnimationStartTime = null;
    Color m_Background;
    float m_ColorEndValue = 0.0f;
    float m_ColorStartValue = 0.0f;
    int m_ColorTab = 7;
    Color m_CurrentColor;
    float m_EndValue = 0.0f;
    boolean m_EvenTime = true;
    Color m_Foreground;
    DataEntry m_MarkerDataEntry = null;
    float m_MaxValue;
    int m_MinCatchTime;
    int m_MinTimeStep = 0;
    int m_MinTimeStepInData = 0;
    float m_MinValue;
    int m_NrOfGrids;
    float m_SoilEndValue = 0.0f;
    float m_SoilStartValue = 0.0f;
    GregorianCalendar m_StartTime = null;
    float m_StartValue = 0.0f;
    String m_StationAltStr = null;
    String m_StationAspectStr = null;
    String m_StationFileName = null;
    String m_StationFilePath = null;
    String m_StationLatStr = null;
    String m_StationLonStr = null;
    String m_StationName = null;
    String m_StationSlopeStr = null;
    GregorianCalendar m_Time = null;
    int m_TimeGrid = 6;
    int m_TimeRange = 3 * this.DAY;
    int m_TimeRange1 = 0;
    int m_TimeStep = 0;
    float m_XMaxValue = 0.0f;
    float m_XMinValue = 0.0f;
    float m_YMaxValue;
    float m_YMaxValue_org;
    float m_YMinValue;
    float m_YMinValue_org;
    int m_xNrOfGrids = 4;
    int m_yNrOfGrids;
    SnowPackFrame spframe;

    public SnowPackDoc(File FileName, DataFile dataFile, MenuFrame mFrame, SnowPackFrame spframe) throws IOException {
        this.m_MinCatchTime = 15 * this.MINUTE;
        this.jSlider = new JSlider();
        this.jButton_Prev = new JButton("<");
        this.jButton_Next = new JButton(">");
        this.jButton_Home = new JButton("<<");
        this.jButton_End = new JButton(">>");
        this.jButton_Remove = new JButton("X");
        this.jButton_Up = new JButton(" Up ");
        this.jButton_Down = new JButton(" Dn ");
        this.m_Background = new Color(255, 255, 255);
        this.m_Foreground = new Color(0, 0, 0);
        this.m_CurrentColor = new Color(0, 0, 0);
        this.IdCode = new int[6];
        this.Name2 = new String[6];
        this.dataFile = dataFile;
        this.mFrame = mFrame;
        this.spframe = spframe;
        this.m_StationFileName = FileName.getName();
        this.m_StationFilePath = FileName.getPath();
        this.m_MinTimeStepInData = dataFile.GetTimeResolution(0);
        this.CalculateTimeSteps();
        this.m_TimeRange = dataFile.GetTimeRange();
        if (this.m_TimeRange < 4 * this.DAY) {
            this.OnTimeRange3();
        } else if (this.m_TimeRange < 8 * this.DAY) {
            this.OnTimeRange7();
        } else if (this.m_TimeRange < 15 * this.DAY) {
            this.OnTimeRange14();
        } else if (this.m_TimeRange < 32 * this.DAY) {
            this.OnTimeRange30();
        } else if (this.m_TimeRange < 64 * this.DAY) {
            this.OnTimeRange60();
        } else {
            this.OnTimeRangeAll();
        }
        if (dataFile.GetIdCode() >= 500) {
            this.PARDATA_Filename = "PARDATA.INI";
        } else {
            Integer Id = new Integer(dataFile.GetIdCode());
            this.PARDATA_Filename = "PARDATA" + Id.toString() + ".INI";
        }
        this.AddListeners();
    }

    void AddListeners() {
        this.jButton_Prev.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Next.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Home.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_End.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Remove.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Up.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Down.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Prev.setToolTipText("Move to previous date (= PageUp-button)");
        this.jButton_Next.setToolTipText("Move to following date (= PageDown-button)");
        this.jButton_Home.setToolTipText("Move to start or to previous time interval (= HOME-button)");
        this.jButton_End.setToolTipText("Move to end or to next time interval (= END-button)");
        this.jButton_Remove.setToolTipText("Remove the Slider");
        this.jButton_Up.setToolTipText("Move to higher value range");
        this.jButton_Down.setToolTipText("Move to lower value range");
        this.jSlider.setToolTipText("Drag the pointer to the desired date");
        this.changeListener = new BoundedChangeListener(this);
        this.jSlider.addChangeListener(this.changeListener);
        this.jButton_Prev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnowPackDoc.this.mFrame.MarkerMovement("Left", 0);
            }
        });
        this.jButton_Next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnowPackDoc.this.mFrame.MarkerMovement("Right", 0);
            }
        });
        this.jButton_Home.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnowPackDoc.this.mFrame.MarkerMovement("Home", 0);
            }
        });
        this.jButton_End.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnowPackDoc.this.mFrame.MarkerMovement("End", 0);
            }
        });
        this.jButton_Up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnowPackDoc.this.mFrame.menu_ChangeZoomY_actionPerformed("Move Higher");
            }
        });
        this.jButton_Down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnowPackDoc.this.mFrame.menu_ChangeZoomY_actionPerformed("Move Lower");
            }
        });
        this.jButton_Remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnowPackFrame spframe = SnowPackDoc.this.GetSnowPackFrame();
                if (spframe == null) {
                    return;
                }
                spframe.snowPackView.removeAll();
                spframe.repaint();
            }
        });
    }

    void Adjust(float Min, float Max) {
        int intervals;
        block20: {
            if (Max == Min) {
                this.m_MinValue = Min - 1.0f;
                this.m_MaxValue = Max + 1.0f;
                this.m_NrOfGrids = 2;
                return;
            }
            int Mag = 0;
            int i = -10;
            while (i <= 10) {
                if ((double)(Max - Min) >= Math.pow(10.0, i) && (double)(Max - Min) < Math.pow(10.0, i + 1)) {
                    Mag = i;
                    break;
                }
                ++i;
            }
            if (Min >= 0.0f) {
                Min = (float)((int)((double)Min / Math.pow(10.0, Mag))) * (float)Math.pow(10.0, Mag);
            } else if ((double)Min / Math.pow(10.0, Mag) != (double)((int)((double)Min / Math.pow(10.0, Mag)))) {
                Min = (float)((int)((double)Min / Math.pow(10.0, Mag)) - 1) * (float)Math.pow(10.0, Mag);
            }
            float NewMax = Min;
            intervals = 0;
            do {
                if (++intervals != 11) continue;
                intervals = 12;
                Max = NewMax += (float)Math.pow(10.0, Mag) * 2.0f;
                break block20;
            } while (!((NewMax += (float)Math.pow(10.0, Mag)) >= Max));
            Max = NewMax;
        }
        this.m_MinValue = Min;
        this.m_MaxValue = Max;
        switch (intervals) {
            case 1: {
                this.m_NrOfGrids = 5;
                break;
            }
            case 2: {
                this.m_NrOfGrids = 4;
                break;
            }
            case 3: {
                this.m_NrOfGrids = 6;
                break;
            }
            case 4: {
                this.m_NrOfGrids = 4;
                break;
            }
            case 5: {
                this.m_NrOfGrids = 5;
                break;
            }
            case 6: {
                this.m_NrOfGrids = 6;
                break;
            }
            case 7: {
                this.m_NrOfGrids = 7;
                break;
            }
            case 8: {
                this.m_NrOfGrids = 4;
                break;
            }
            case 9: {
                this.m_NrOfGrids = 6;
                break;
            }
            case 10: {
                this.m_NrOfGrids = 5;
                break;
            }
            case 11: 
            case 12: {
                this.m_NrOfGrids = 6;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void AssociatedIdCodes(int IdCode0) {
        this.NrOfParameters = 1;
        this.IdCode[0] = IdCode0;
        this.Name2[0] = "Param. info missing!";
        try {
            IniFile ParDataIni = new IniFile(Setup.m_IniFilePath + this.PARDATA_Filename);
            String IdCodeStr = new Integer(IdCode0).toString();
            String PrintedWith = ParDataIni.getEntry(IdCodeStr, "PrintedWith", "");
            StringTokenizer st = new StringTokenizer(PrintedWith, ",");
            this.Name2[0] = ParDataIni.getEntry(IdCodeStr, "Name2", "Param. info missing!");
            while (st.hasMoreTokens()) {
                if (this.NrOfParameters > 6) {
                    return;
                }
                this.IdCode[this.NrOfParameters] = Integer.parseInt(st.nextToken());
                this.Name2[this.NrOfParameters] = ParDataIni.getEntry(new Integer(this.IdCode[this.NrOfParameters]).toString(), "Name2", "Param. info missing!");
                ++this.NrOfParameters;
            }
            return;
        }
        catch (IOException e) {
        }
    }

    boolean CalculateTimeRange() {
        if (this.dataFile != null) {
            GregorianCalendar TimeRangeEndTime = this.dataFile.GetActDataTime();
            GregorianCalendar DataFileStartTime = this.dataFile.GetStartTime();
            GregorianCalendar TimeClone = (GregorianCalendar)TimeRangeEndTime.clone();
            TimeClone.add(13, -this.m_TimeRange);
            if (TimeClone.before(DataFileStartTime)) {
                this.dataFile.SetTimeRange(DataFileStartTime, this.m_TimeRange);
            } else {
                this.dataFile.SetTimeRange(this.m_TimeRange, TimeRangeEndTime);
            }
            return true;
        }
        return false;
    }

    boolean CalculateTimeSteps() {
        if (this.m_TimeRange <= 7 * this.DAY) {
            this.m_MinTimeStep = this.HOUR;
            this.m_MinCatchTime = 5 * this.MINUTE;
        } else if (this.m_TimeRange <= 14 * this.DAY) {
            this.m_MinTimeStep = 3 * this.HOUR;
            this.m_MinCatchTime = 15 * this.MINUTE;
        } else if (this.m_TimeRange <= 30 * this.DAY) {
            this.m_MinTimeStep = 6 * this.HOUR;
            this.m_MinCatchTime = 15 * this.MINUTE;
        } else if (this.m_TimeRange <= 60 * this.DAY) {
            this.m_MinTimeStep = 12 * this.HOUR;
            this.m_MinCatchTime = 15 * this.MINUTE;
        } else {
            this.m_MinTimeStep = this.DAY;
            this.m_MinCatchTime = 15 * this.MINUTE;
        }
        if (Setup.m_AlwaysBestResolution) {
            this.m_MinTimeStep = 1;
        }
        return true;
    }

    void DefinedTimeRange(int days, int grids) {
        this.m_EvenTime = true;
        this.m_TimeRange = days * this.DAY;
        this.m_TimeGrid = grids;
        this.CalculateTimeRange();
        this.CalculateTimeSteps();
        this.m_AnimationStartTime = this.GetAnimationStartTime();
        this.m_AnimationEndTime = (GregorianCalendar)this.dataFile.m_ActEndTime.clone();
    }

    GregorianCalendar GetAnimationStartTime() {
        int resolution = this.dataFile.GetTimeResolution(this.spframe.IdCode);
        GregorianCalendar TempTime = (GregorianCalendar)this.dataFile.m_ActEndTime.clone();
        GregorianCalendar StartTime = (GregorianCalendar)this.dataFile.m_ActStartTime.clone();
        TempTime.add(13, -1 * Math.max(this.m_MinTimeStepInData, this.m_MinTimeStep) * Setup.m_DefaultAnimationSteps);
        if (StartTime.after(TempTime)) {
            return (GregorianCalendar)StartTime.clone();
        }
        return TempTime;
    }

    String GetAxisText(int IdCode) {
        String ParameterName;
        block15: {
            try {
                IniFile ParDataIni = new IniFile(Setup.m_IniFilePath + this.PARDATA_Filename);
                Integer IdInteger = new Integer(IdCode);
                String IdCodeStr = IdInteger.toString();
                ParameterName = ParDataIni.getEntry(IdCodeStr, "NameE", "ParameterNameError");
            }
            catch (IOException e) {
                if (!Setup.m_FileDialogActive) {
                    System.out.println("SnowPackDoc.GetAxisText: Catch 1: " + e);
                }
                return "ParameterNameError";
            }
            try {
                if (IdCode != 40 && IdCode != 42 && IdCode != 44 && IdCode != 46 && IdCode != 48) break block15;
                String ActCompleteFilename = this.spframe.getInputFile().getPath();
                String ActFilename = this.spframe.getInputFile().getName();
                String ActPath = ActCompleteFilename.substring(0, ActCompleteFilename.length() - ActFilename.length());
                String SnowHeightsFile = ModelDialog.SlashConverted(ActPath).equals(ModelDialog.SlashConverted(Setup.m_DataFilePath)) ? Setup.m_DataFilePath + "CONSTANTS_User.INI" : ActCompleteFilename.substring(0, ActCompleteFilename.length() - 4) + ".ini";
                IniFile ConstantsIni = new IniFile(SnowHeightsFile);
                String Depth = "??";
                if (IdCode == 40) {
                    Depth = ConstantsIni.getEntry("Parameters", "DEPTH_1", "??");
                } else if (IdCode == 42) {
                    Depth = ConstantsIni.getEntry("Parameters", "DEPTH_2", "??");
                } else if (IdCode == 44) {
                    Depth = ConstantsIni.getEntry("Parameters", "DEPTH_3", "??");
                } else if (IdCode == 46) {
                    Depth = ConstantsIni.getEntry("Parameters", "DEPTH_4", "??");
                } else if (IdCode == 48) {
                    Depth = ConstantsIni.getEntry("Parameters", "DEPTH_5", "??");
                }
                if (Depth.startsWith("-")) {
                    ParameterName = ParameterName + " (Soil, " + Depth + " m)";
                    break block15;
                }
                ParameterName = ParameterName + " (Snow, " + Depth + " m)";
            }
            catch (IOException e) {
            }
        }
        return ParameterName;
    }

    String GetAxisUnit(int IdCode) {
        String Unit;
        try {
            IniFile ParDataIni = new IniFile(Setup.m_IniFilePath + this.PARDATA_Filename);
            Integer IdInteger = new Integer(IdCode);
            String IdCodeStr = IdInteger.toString();
            Unit = ParDataIni.getEntry(IdCodeStr, "Einheit", "UnitError");
        }
        catch (IOException e) {
            if (!Setup.m_FileDialogActive) {
                System.out.println("SnowPackDoc.GetAxisUnit: Catch 1: " + e);
            }
            return "UnitError";
        }
        return Unit;
    }

    int GetColorTab() {
        return this.m_ColorTab;
    }

    boolean GetDefaultIdParameters(int IdCode) {
        try {
            IniFile ParDataIni = new IniFile(Setup.m_IniFilePath + this.PARDATA_Filename);
            Integer IdInteger = new Integer(IdCode);
            String IdCodeStr = IdInteger.toString();
            String ColorTabStr = ParDataIni.getEntry(IdCodeStr, "ColorTab", "ColorTabError");
            try {
                this.m_ColorTab = Integer.parseInt(ColorTabStr);
            }
            catch (NumberFormatException e) {
                this.m_ColorTab = 7;
            }
            String StartValueStr = ParDataIni.getEntry(IdCodeStr, "StartWert", "StartValueError");
            this.m_ColorStartValue = this.m_StartValue = this.StringToFloat(StartValueStr);
            String EndValueStr = ParDataIni.getEntry(IdCodeStr, "EndWert", "EndValueError");
            this.m_ColorEndValue = this.m_EndValue = this.StringToFloat(EndValueStr);
            String SoilStartValueStr = ParDataIni.getEntry(IdCodeStr, "SoilStartWert", "SoilStartValueError");
            this.m_SoilStartValue = this.StringToFloat(SoilStartValueStr);
            String SoilEndValueStr = ParDataIni.getEntry(IdCodeStr, "SoilEndWert", "SoilEndValueError");
            this.m_SoilEndValue = this.StringToFloat(SoilEndValueStr);
        }
        catch (IOException e) {
            System.out.println("SnowPackDoc.GetDefaultIdParameters: Catch 1: " + e);
            return false;
        }
        return true;
    }

    float GetEndValue() {
        return this.m_EndValue;
    }

    boolean GetFirstValue(int IdCode) {
        if (this.dataFile == null) {
            return false;
        }
        this.dataFile.MoveToFirstDataEntry();
        while (!this.dataFile.CheckActDataValid(IdCode)) {
            if (this.dataFile.MoveToNextDataEntry() == 0) continue;
            return false;
        }
        this.m_ActDataEntry = this.dataFile.GetActDataEntry();
        if (this.m_ActDataEntry != null) {
            this.m_ActTime = this.dataFile.GetActDataTime();
            return true;
        }
        return false;
    }

    boolean GetMarkerValue(int IdCode) {
        if (this.dataFile == null) {
            return false;
        }
        if (this.m_MarkerDataEntry == null) {
            return this.GetNewMarkerValue(IdCode);
        }
        this.m_ActTime = this.m_MarkerDataEntry.GetTime();
        this.m_ActDataEntry = this.m_MarkerDataEntry;
        return true;
    }

    boolean GetNewMarkerValue(int IdCode) {
        if (this.dataFile == null) {
            return false;
        }
        this.m_MarkerDataEntry = this.dataFile.GetActDataEntry();
        if (this.m_MarkerDataEntry != null && this.dataFile.CheckActDataValid(IdCode)) {
            this.m_ActTime = this.m_MarkerDataEntry.GetTime();
            this.m_ActDataEntry = this.m_MarkerDataEntry;
            return true;
        }
        return false;
    }

    boolean GetNextValue(int IdCode) {
        if (this.dataFile == null) {
            return false;
        }
        do {
            if (this.dataFile.MoveToNextDataEntry(this.m_TimeStep, this.m_MinCatchTime, this.m_MinCatchTime) == 0) continue;
            return false;
        } while (!this.dataFile.CheckActDataValid(IdCode));
        this.m_ActDataEntry = this.dataFile.GetActDataEntry();
        if (this.m_ActDataEntry != null) {
            this.m_ActTime = this.dataFile.GetActDataTime();
            return true;
        }
        return false;
    }

    Color GetParameterColor(int IdCode) {
        Color ParameterColor;
        block9: {
            ParameterColor = new Color(0, 0, 0);
            try {
                IniFile ParDataIni = new IniFile(Setup.m_IniFilePath + this.PARDATA_Filename);
                Integer IdInteger = new Integer(IdCode);
                String IdCodeStr = IdInteger.toString();
                String ColorStr = ParDataIni.getEntry(IdCodeStr, "Color", "ColorError");
                if (ColorStr.equals("black")) {
                    ParameterColor = ColorTab.BLK;
                } else if (ColorStr.equals("blue")) {
                    ParameterColor = ColorTab.BLU;
                } else if (ColorStr.equals("darkGreen")) {
                    ParameterColor = ColorTab.D_GRN;
                } else if (ColorStr.equals("red")) {
                    ParameterColor = ColorTab.RED;
                }
            }
            catch (IOException e) {
                if (Setup.m_FileDialogActive) break block9;
                System.out.println("SnowPackDoc.GetParameterColor: Catch 1: " + e);
            }
        }
        return ParameterColor;
    }

    SnowPackFrame GetSnowPackFrame() {
        return this.spframe;
    }

    float GetStartValue() {
        return this.m_StartValue;
    }

    boolean GetStationParameters() {
        String ActCompleteFilename = this.spframe.getInputFile().getPath();
        String ActFilename = this.spframe.getInputFile().getName();
        String ActPath = ActCompleteFilename.substring(0, ActCompleteFilename.length() - ActFilename.length());
        String StationDataFile = ModelDialog.SlashConverted(ActPath).equals(ModelDialog.SlashConverted(Setup.m_DataFilePath)) ? Setup.m_SnowFilePath + ActFilename.substring(0, ActFilename.length() - 4) + ".sno" : ActCompleteFilename.substring(0, ActCompleteFilename.length() - 4) + ".sno";
        try {
            IniFile StationDataIni = new IniFile(StationDataFile);
            this.m_StationName = StationDataIni.getEntry("SNOWPACK_INITIALIZATION", "StationName", "Undefined Station");
            this.m_StationAltStr = StationDataIni.getEntry("SNOWPACK_INITIALIZATION", "Altitude", "?");
            this.m_StationAspectStr = StationDataIni.getEntry("SNOWPACK_INITIALIZATION", "SlopeAzi", "?");
            this.m_StationSlopeStr = StationDataIni.getEntry("SNOWPACK_INITIALIZATION", "SlopeAngle", "?");
            this.m_StationLatStr = StationDataIni.getEntry("SNOWPACK_INITIALIZATION", "Latitude", "?");
            this.m_StationLonStr = StationDataIni.getEntry("SNOWPACK_INITIALIZATION", "Longitude", "?");
            if (!(this.m_StationName.equals("Undefined Station") || this.m_StationAltStr.equals("?") || this.m_StationAspectStr.equals("?") || this.m_StationSlopeStr.equals("?"))) {
                return true;
            }
        }
        catch (IOException e) {
            System.out.println("File containing station data not found: " + e);
            this.m_StationName = "Undefined Station";
            this.m_StationAltStr = "?";
            this.m_StationAspectStr = "?";
            this.m_StationSlopeStr = "?";
            this.m_StationLatStr = "?";
            this.m_StationLonStr = "?";
        }
        return true;
    }

    boolean GetXAxisRange(int IdCode) throws IOException {
        this.m_TimeStep = 0;
        this.m_TimeRange1 = this.m_TimeRange;
        if (this.dataFile == null) {
            return false;
        }
        if (this.dataFile.GetTimeRange() > this.m_TimeRange) {
            this.m_TimeRange1 = this.m_TimeRange = this.dataFile.GetTimeRange();
        }
        if (this.m_EvenTime) {
            this.GetMarkerValue(IdCode);
            this.m_Time = (GregorianCalendar)this.m_ActTime.clone();
            if (this.m_Time.get(11) < 12 || this.m_Time.get(11) == 12 && this.m_Time.get(12) == 0) {
                this.m_Time.set(11, 12);
                this.m_Time.set(12, 0);
                this.m_Time.set(13, 0);
            } else {
                this.m_Time.set(11, 0);
                this.m_Time.set(12, 0);
                this.m_Time.set(13, 0);
                this.m_Time.add(5, 1);
            }
            this.m_StartTime = (GregorianCalendar)this.m_Time.clone();
            this.m_StartTime.add(13, -this.m_TimeRange);
            this.dataFile.SetTimeRange(this.m_StartTime, this.m_Time);
        } else {
            this.m_StartTime = this.dataFile.GetTimeRangeStartTime();
        }
        if (this.dataFile.GetTimeResolution(IdCode) == 0) {
            return false;
        }
        int MinTimeStep = this.dataFile.GetTimeResolution(IdCode);
        int MinTimeStepRounded = this.dataFile.RoundTime(MinTimeStep, (int)(Setup.m_MaxTimeResolution * (float)this.MINUTE));
        this.m_TimeStep = Math.max(MinTimeStepRounded, this.m_MinTimeStep);
        if (!this.m_EvenTime) {
            this.m_TimeRange1 += this.m_TimeStep;
        }
        return true;
    }

    boolean GetYAxisRange(int IdCode) {
        this.m_yNrOfGrids = 4;
        if (IdCode >= 500) {
            this.m_YMinValue = 0.0f;
            this.m_YMaxValue = Setup.m_YMaxValue;
            this.m_XMinValue = this.m_StartValue;
            this.m_XMaxValue = this.m_EndValue;
        } else {
            this.m_YMinValue = this.m_StartValue;
            this.m_YMaxValue = this.m_EndValue;
        }
        this.m_YMinValue_org = this.m_YMinValue;
        this.m_YMaxValue_org = this.m_YMaxValue;
        if (IdCode < 500) {
            this.AssociatedIdCodes(IdCode);
        } else {
            this.NrOfParameters = 1;
        }
        if (Setup.m_ResearchMode && this.NrOfParameters == 1 && this.dataFile.CalculateMinMaxValue(IdCode)) {
            this.m_YMaxValue = this.dataFile.m_MaxValue;
            this.m_YMinValue = Setup.m_SoilDataDisplay && this.dataFile.m_IdSoilDataExist || IdCode < 500 ? this.dataFile.m_MinValue : 0.0f;
            this.m_YMinValue_org = this.m_YMinValue;
            this.m_YMaxValue_org = this.m_YMaxValue;
            if (this.GetAxisText(IdCode).indexOf("Wind Direction") >= 0) {
                this.m_YMinValue = 0.0f;
                this.m_YMaxValue = 360.0f;
                this.m_yNrOfGrids = 4;
            } else {
                this.Adjust(this.m_YMinValue, this.m_YMaxValue);
                this.m_YMinValue = this.m_MinValue;
                this.m_YMaxValue = this.m_MaxValue;
                this.m_yNrOfGrids = this.m_NrOfGrids;
            }
            if (IdCode >= 500) {
                this.m_XMinValue = this.dataFile.m_IdMinValue;
                this.m_XMaxValue = this.dataFile.m_IdMaxValue;
                this.Adjust(this.m_XMinValue, this.m_XMaxValue);
                this.m_XMinValue = this.m_MinValue;
                this.m_XMaxValue = this.m_MaxValue;
            }
        }
        this.MAX_Y_ZOOM_VALUE = this.m_YMinValue + 8.0f * (this.m_YMaxValue - this.m_YMinValue);
        this.MIN_Y_ZOOM_DIFFERENCE = (this.m_YMaxValue - this.m_YMinValue) / 8.0f;
        return true;
    }

    boolean IdCodeExists(int IdCode) {
        if (this.dataFile == null) {
            return false;
        }
        return this.dataFile.IdCodeExists(IdCode);
    }

    boolean OnMarkerBackward(String button) {
        if (this.dataFile != null) {
            GregorianCalendar TimeRangeStartTime = this.dataFile.GetTimeRangeStartTime();
            GregorianCalendar DataFileStartTime = this.dataFile.GetStartTime();
            this.dataFile.SetActDataEntry(this.m_MarkerDataEntry);
            GregorianCalendar ActDataTimeClone = this.dataFile.GetActDataTime();
            ActDataTimeClone.add(13, -this.m_TimeStep);
            if (!ActDataTimeClone.before(TimeRangeStartTime)) {
                if (button == "Home") {
                    if (this.dataFile.MoveToFirstDataEntry() == 0) {
                        return false;
                    }
                } else if (button == "LeftArrow") {
                    int StepsBackward = 1;
                    do {
                        int SavActDataEntryIndex = this.dataFile.m_ActDataEntryIndex;
                        if (this.dataFile.MoveToPrevDataEntry(StepsBackward * this.m_TimeStep, this.m_MinCatchTime, this.m_MinCatchTime) == 0) {
                            return false;
                        }
                        this.dataFile.m_ActDataEntryIndex = SavActDataEntryIndex;
                        this.dataFile.m_ActDataEntry = (DataEntry)this.dataFile.m_DataEntries.elementAt(SavActDataEntryIndex);
                        ActDataTimeClone.add(13, -this.m_TimeStep);
                        ++StepsBackward;
                    } while (!ActDataTimeClone.before(TimeRangeStartTime));
                }
            } else if (TimeRangeStartTime.after(DataFileStartTime)) {
                if (button == "Home") {
                    TimeRangeStartTime.add(13, -this.m_TimeRange);
                } else if (button == "LeftArrow") {
                    TimeRangeStartTime.add(13, -this.m_TimeStep);
                }
                TimeRangeStartTime.add(13, -this.m_TimeStep);
                DataFileStartTime.add(13, -this.m_TimeStep);
                if (TimeRangeStartTime.before(DataFileStartTime)) {
                    this.dataFile.SetTimeRange(DataFileStartTime, this.m_TimeRange);
                } else {
                    this.dataFile.SetTimeRange(TimeRangeStartTime, this.m_TimeRange);
                }
                this.m_AnimationStartTime = this.GetAnimationStartTime();
                this.m_AnimationEndTime = (GregorianCalendar)this.dataFile.m_ActEndTime.clone();
                this.m_MarkerDataEntry = null;
                return true;
            }
        }
        return false;
    }

    boolean OnMarkerForward(String button) {
        if (this.dataFile != null) {
            GregorianCalendar TimeRangeEndTime = this.dataFile.GetTimeRangeEndTime();
            GregorianCalendar DataFileEndTime = this.dataFile.GetEndTime();
            this.dataFile.SetActDataEntry(this.m_MarkerDataEntry);
            GregorianCalendar ActDataTimeClone = this.dataFile.GetActDataTime();
            ActDataTimeClone.add(13, this.m_TimeStep);
            if (!ActDataTimeClone.after(TimeRangeEndTime)) {
                if (button == "End") {
                    if (this.dataFile.MoveToLastDataEntry() == 0) {
                        return false;
                    }
                } else if (button == "RightArrow") {
                    int StepsForward = 1;
                    do {
                        if (this.dataFile.MoveToNextDataEntry(StepsForward * this.m_TimeStep, this.m_MinCatchTime, this.m_MinCatchTime) == 0) {
                            return false;
                        }
                        ActDataTimeClone.add(13, this.m_TimeStep);
                        ++StepsForward;
                    } while (!ActDataTimeClone.after(TimeRangeEndTime));
                }
            } else if (TimeRangeEndTime.before(DataFileEndTime)) {
                if (button == "End") {
                    TimeRangeEndTime.add(13, this.m_TimeRange);
                } else if (button == "RightArrow") {
                    TimeRangeEndTime.add(13, this.m_TimeStep);
                }
                if (TimeRangeEndTime.after(DataFileEndTime)) {
                    this.dataFile.SetTimeRange(this.m_TimeRange, DataFileEndTime);
                } else {
                    this.dataFile.SetTimeRange(this.m_TimeRange, TimeRangeEndTime);
                }
                this.m_AnimationStartTime = this.GetAnimationStartTime();
                this.m_AnimationEndTime = (GregorianCalendar)this.dataFile.m_ActEndTime.clone();
                this.m_MarkerDataEntry = null;
                return true;
            }
        }
        return false;
    }

    void OnMoveHigher() {
        float YAxisDiff = this.m_YMaxValue - this.m_YMinValue;
        if (this.m_YMaxValue > this.m_YMaxValue_org) {
            return;
        }
        this.m_YMaxValue += YAxisDiff;
        this.m_YMinValue += YAxisDiff;
    }

    void OnMoveLower() {
        float YAxisDiff = this.m_YMaxValue - this.m_YMinValue;
        if (!Setup.m_SoilDataDisplay && this.m_YMinValue < YAxisDiff && this.dataFile.GetIdCode() >= 500) {
            this.m_YMinValue = 0.0f;
            this.m_YMaxValue = YAxisDiff;
        } else {
            if (this.m_YMinValue < this.m_YMinValue_org) {
                return;
            }
            this.m_YMaxValue -= YAxisDiff;
            this.m_YMinValue -= YAxisDiff;
        }
    }

    void OnSetBackGrnd(String color) {
        if (color.equals("white")) {
            this.m_Background = Color.white;
            this.m_Foreground = Color.black;
        } else if (color.equals("lightGray")) {
            this.m_Background = new Color(230, 230, 230);
            this.m_Foreground = Color.black;
        } else if (color.equals("black")) {
            this.m_Background = Color.black;
            this.m_Foreground = Color.white;
        }
    }

    void OnSetColorParameters(float StartValue, float EndValue, int ColorTab2) {
        this.m_ColorStartValue = StartValue;
        this.m_ColorEndValue = EndValue;
        this.m_ColorTab = ColorTab2;
    }

    void OnSetXAxis(float XMinValue, float XMaxValue, int xNrOfGrids) {
        this.m_StartValue = this.m_SoilStartValue = XMinValue;
        this.m_EndValue = this.m_SoilEndValue = XMaxValue;
        this.m_xNrOfGrids = xNrOfGrids;
    }

    void OnSetYAxis(float YMinValue, float YMaxValue, int yNrOfGrids) {
        this.m_YMinValue = YMinValue;
        this.m_YMaxValue = YMaxValue;
        this.m_yNrOfGrids = yNrOfGrids;
    }

    void OnTimeRange(GregorianCalendar StartTime, GregorianCalendar EndTime) {
        this.m_EvenTime = false;
        this.dataFile.SetTimeRange(StartTime, EndTime);
        this.m_TimeRange = this.dataFile.GetTimeRange();
        this.m_TimeGrid = 8;
        this.CalculateTimeSteps();
        this.m_AnimationStartTime = this.GetAnimationStartTime();
        this.m_AnimationEndTime = (GregorianCalendar)this.dataFile.m_ActEndTime.clone();
    }

    void OnTimeRange14() {
        this.DefinedTimeRange(14, 7);
    }

    void OnTimeRange3() {
        this.DefinedTimeRange(3, 6);
    }

    void OnTimeRange30() {
        this.DefinedTimeRange(30, 6);
    }

    void OnTimeRange60() {
        this.DefinedTimeRange(60, 6);
    }

    void OnTimeRange7() {
        this.DefinedTimeRange(7, 7);
    }

    void OnTimeRangeAll() {
        this.m_EvenTime = false;
        this.dataFile.SetTimeRangeAll();
        this.m_TimeRange = this.dataFile.GetTimeRange();
        this.m_TimeGrid = 8;
        this.CalculateTimeSteps();
        this.m_AnimationStartTime = this.GetAnimationStartTime();
        this.m_AnimationEndTime = (GregorianCalendar)this.dataFile.m_ActEndTime.clone();
    }

    void OnZoomIn() {
        float YAxisDiff = this.m_YMaxValue - this.m_YMinValue;
        if (this.m_YMinValue == 0.0f) {
            this.m_YMaxValue -= YAxisDiff / 2.0f;
        } else {
            this.m_YMaxValue -= YAxisDiff / 4.0f;
            this.m_YMinValue += YAxisDiff / 4.0f;
        }
    }

    void OnZoomOut() {
        float YAxisDiff = this.m_YMaxValue - this.m_YMinValue;
        if (this.m_YMinValue == 0.0f) {
            this.m_YMaxValue = this.m_YMinValue + 2.0f * YAxisDiff;
        } else {
            this.m_YMaxValue += YAxisDiff / 2.0f;
            this.m_YMinValue -= YAxisDiff / 2.0f;
        }
    }

    void RetrieveDataFile() {
        this.dataFile.m_GetStartTimeIndex = this.datafile_m_GetStartTimeIndex;
        this.dataFile.m_GetEndTimeIndex = this.datafile_m_GetEndTimeIndex;
        this.dataFile.m_ActDataEntryIndex = this.datafile_m_ActDataEntryIndex;
        this.dataFile.m_ActDataEntry = (DataEntry)this.dataFile.m_DataEntries.elementAt(this.datafile_m_ActDataEntryIndex);
        this.dataFile.m_ActStartTimeIndex = this.datafile_m_ActStartTimeIndex;
        this.dataFile.m_ActEndTimeIndex = this.datafile_m_ActEndTimeIndex;
        if (this.datafile_m_ActStartTime != null) {
            this.dataFile.m_ActStartTime = (GregorianCalendar)this.datafile_m_ActStartTime.clone();
        }
        if (this.datafile_m_ActEndTime != null) {
            this.dataFile.m_ActEndTime = (GregorianCalendar)this.datafile_m_ActEndTime.clone();
        }
        this.dataFile.m_TimeStepsWithoutData = this.datafile_m_TimeStepsWithoutData;
        this.dataFile.m_IdMinValue = this.datafile_m_IdMinValue;
        this.dataFile.m_IdMaxValue = this.datafile_m_IdMaxValue;
        this.dataFile.m_IdSoilDataExist = this.datafile_m_IdSoilDataExist;
        this.dataFile.m_SoilDataExist = this.datafile_m_SoilDataExist;
    }

    void SaveDataFile() {
        this.datafile_m_GetStartTimeIndex = this.dataFile.m_GetStartTimeIndex;
        this.datafile_m_GetEndTimeIndex = this.dataFile.m_GetEndTimeIndex;
        this.datafile_m_ActDataEntryIndex = this.dataFile.m_ActDataEntryIndex;
        this.datafile_m_ActDataEntry = (DataEntry)this.dataFile.m_DataEntries.elementAt(this.dataFile.m_ActDataEntryIndex);
        this.datafile_m_ActStartTimeIndex = this.dataFile.m_ActStartTimeIndex;
        this.datafile_m_ActEndTimeIndex = this.dataFile.m_ActEndTimeIndex;
        this.datafile_m_ActStartTime = (GregorianCalendar)this.dataFile.m_ActStartTime.clone();
        this.datafile_m_ActEndTime = (GregorianCalendar)this.dataFile.m_ActEndTime.clone();
        this.datafile_m_TimeStepsWithoutData = this.dataFile.m_TimeStepsWithoutData;
        this.datafile_m_IdMinValue = this.dataFile.m_IdMinValue;
        this.datafile_m_IdMaxValue = this.dataFile.m_IdMaxValue;
        this.datafile_m_IdSoilDataExist = this.dataFile.m_IdSoilDataExist;
        this.datafile_m_SoilDataExist = this.dataFile.m_SoilDataExist;
    }

    public float StringToFloat(String string) {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException e) {
            f = -999.9f;
        }
        return f;
    }

    public int StringToInt(String string) {
        int i;
        try {
            i = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            i = -999;
        }
        return i;
    }
}

