/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import java.awt.Color;

public class ColorRange {
    float m_MaxValue;
    float m_MinValue;
    float m_MulBlue;
    float m_MulGreen;
    float m_MulRed;
    int m_StartBlue;
    int m_StartGreen;
    int m_StartRed;
    float m_StartValue;
    float m_ValueRange;

    ColorRange(Color StartRGB, Color EndRGB, float StartValue, float EndValue) {
        this.m_StartValue = StartValue;
        this.m_ValueRange = EndValue - StartValue;
        this.m_MinValue = StartValue < EndValue ? StartValue : EndValue;
        this.m_MaxValue = EndValue > StartValue ? EndValue : StartValue;
        this.m_StartRed = StartRGB.getRed();
        this.m_StartGreen = StartRGB.getGreen();
        this.m_StartBlue = StartRGB.getBlue();
        if (this.m_ValueRange != 0.0f) {
            this.m_MulRed = (float)(EndRGB.getRed() - this.m_StartRed) / this.m_ValueRange;
            this.m_MulGreen = (float)(EndRGB.getGreen() - this.m_StartGreen) / this.m_ValueRange;
            this.m_MulBlue = (float)(EndRGB.getBlue() - this.m_StartBlue) / this.m_ValueRange;
        } else {
            this.m_MulRed = 0.0f;
            this.m_MulGreen = 0.0f;
            this.m_MulBlue = 0.0f;
        }
    }

    public Color GetColor(float Value) {
        float NormValue = Value - this.m_StartValue;
        int RValue = (int)((float)this.m_StartRed + NormValue * this.m_MulRed);
        int GValue = (int)((float)this.m_StartGreen + NormValue * this.m_MulGreen);
        int BValue = (int)((float)this.m_StartBlue + NormValue * this.m_MulBlue);
        return new Color(RValue, GValue, BValue);
    }

    boolean IsInRange(float Value) {
        return Value >= this.m_MinValue && Value <= this.m_MaxValue;
    }
}

