/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;

public class SerializableImage
implements Serializable {
    protected transient Image image;
    protected int[] imageData;
    protected int imageWidth;
    protected int imageHeight;

    public SerializableImage() {
    }

    public SerializableImage(Image image) throws InterruptedException {
        this.setImage(image);
    }

    public void setImage(Image image) throws InterruptedException {
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        grabber.grabPixels();
        this.imageData = (int[])grabber.getPixels();
        this.imageWidth = grabber.getWidth();
        this.imageHeight = grabber.getHeight();
        this.image = image;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, this.imageData, 0, this.imageWidth));
        }
        return this.image;
    }

    public static final SerializableImage create(Image source) {
        if (source == null) {
            return null;
        }
        try {
            SerializableImage newImage;
            SerializableImage serializableImage = newImage = new SerializableImage(source);
            return serializableImage;
        }
        catch (InterruptedException e) {
            SerializableImage serializableImage = null;
            return serializableImage;
        }
    }
}

