/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.Alpine3D;
import alpine3d.FileSpecIF;
import alpine3d.RasterImage;
import alpine3d.SurfaceArea;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DEMStrategy
implements FileSpecIF {
    DecimalFormat formatter0 = new DecimalFormat("###");

    public String checkBoxLabel() {
        return "DEM";
    }

    public int getEditIndex(Alpine3D a3d) {
        return -1;
    }

    public String getFiletype() {
        return "Height";
    }

    public Object[] getLegendColors(RasterImage rasImage) {
        Object[] panelArr = new JPanel[rasImage.getNumOfColors()];
        int i = 0;
        while (i < rasImage.getNumOfColors()) {
            panelArr[i] = new JPanel();
            ((JComponent)panelArr[i]).setBackground(rasImage.getColor(i));
            ++i;
        }
        return panelArr;
    }

    public Object[] getLegendText(RasterImage rasImage) {
        Object[] labelArr = new JLabel[rasImage.getNumOfColors()];
        labelArr[0] = new JLabel("No Data");
        labelArr[1] = new JLabel("< " + rasImage.getLimit(0));
        labelArr[rasImage.getNumOfColors() - 1] = new JLabel("> " + rasImage.getLimit(rasImage.getNumOfColors() - 3));
        int i = 2;
        while (i < rasImage.getNumOfColors() - 1) {
            labelArr[i] = new JLabel(rasImage.getLimit(i - 2) + "  -  " + rasImage.getLimit(i - 1));
            ++i;
        }
        int i2 = 0;
        while (i2 < rasImage.getNumOfColors()) {
            ((JLabel)labelArr[i2]).setHorizontalAlignment(0);
            ((JComponent)labelArr[i2]).setFont(new Font("Dialog", 0, 11));
            ++i2;
        }
        return labelArr;
    }

    public ArrayList getPointList(Alpine3D a3d) {
        return null;
    }

    public Map getPointMap(Alpine3D a3d) {
        return null;
    }

    public Map getUndoIndexMap(Alpine3D a3d) {
        return null;
    }

    public String getUnit() {
        return "[m]";
    }

    public float getValue(SurfaceArea sArea, int i, int j) {
        return sArea.sPoint[i][j].getValue();
    }

    public float retransformeValue(float value) {
        return value;
    }

    public byte[][] setColorArrays() {
        byte[][] colorMatrix = new byte[3][32];
        byte[] r = new byte[32];
        byte[] g = new byte[32];
        byte[] b = new byte[32];
        int i = 0;
        while (i < 16) {
            r[i] = (byte)(0 + i * 255 / 16);
            r[i + 16] = -1;
            g[i] = (byte)(100 + i * 155 / 16);
            g[i + 16] = (byte)(255 - i * 255 / 15);
            ++i;
        }
        b[16] = 20;
        r[0] = -1;
        g[0] = -1;
        b[0] = -1;
        colorMatrix[0] = r;
        colorMatrix[1] = g;
        colorMatrix[2] = b;
        return colorMatrix;
    }

    public byte[] setDataBuffer(SurfaceArea sArea, int nColors, float lowerLimit, float upperLimit) {
        byte[] pixels = new byte[sArea.getNRows() * sArea.getNCols()];
        double mult = (upperLimit - lowerLimit) / (float)(nColors - 3);
        float top = 0.0f;
        int k = 0;
        int i = 0;
        while (i < sArea.getNRows()) {
            int j = 0;
            while (j < sArea.getNCols()) {
                if (this.getValue(sArea, i, j) == (float)sArea.getNoDataValue()) {
                    pixels[k] = 0;
                    ++k;
                } else if (this.getValue(sArea, i, j) == upperLimit) {
                    pixels[k] = (byte)(nColors - 2);
                    ++k;
                } else if (this.getValue(sArea, i, j) > upperLimit) {
                    pixels[k] = (byte)(nColors - 1);
                    ++k;
                } else if (this.getValue(sArea, i, j) < lowerLimit) {
                    pixels[k] = 1;
                    ++k;
                } else {
                    int color = 0;
                    while (color < nColors - 3) {
                        float bottom = lowerLimit + (float)((double)color * mult);
                        top = lowerLimit + (float)((double)(color + 1) * mult);
                        if (bottom <= this.getValue(sArea, i, j) && this.getValue(sArea, i, j) < top) {
                            pixels[k] = (byte)(color + 2);
                            ++k;
                        }
                        color = (byte)(color + 1);
                    }
                }
                ++j;
            }
            ++i;
        }
        return pixels;
    }

    public void setEditIndex(Alpine3D a3d, int value) {
    }

    public String[] setLimits(int nColors, float lowerLimit, float upperLimit) {
        double mult = (upperLimit - lowerLimit) / (float)(nColors - 3);
        String[] limits = new String[nColors - 2];
        float top = 0.0f;
        int color = 0;
        while (color < nColors - 3) {
            float bottom = lowerLimit + (float)((double)color * mult);
            top = bottom + (float)mult;
            limits[color] = this.formatter0.format(bottom);
            color = (byte)(color + 1);
        }
        limits[nColors - 3] = this.formatter0.format(top);
        return limits;
    }

    public void setValue(float value, SurfaceArea sArea, int i, int j) {
        sArea.sPoint[i][j].setValue(value);
    }

    public float transformeValue(float value) {
        return value;
    }

    public String valueToString(float value) {
        return String.valueOf(value);
    }
}

