/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.DataEntry;
import ProWin.DataLine;
import ProWin.ErrorFile;
import ProWin.FileStatus;
import ProWin.MetDataEntry;
import ProWin.ProDataEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.Vector;

public abstract class DataFile
implements C_DataFile {
    int LineNr;
    protected static String ModulName = "DataFile";
    protected DataEntry m_ActDataEntry = null;
    protected int m_ActDataEntryIndex = 0;
    GregorianCalendar m_ActEndTime;
    protected int m_ActEndTimeIndex = 0;
    GregorianCalendar m_ActStartTime;
    protected int m_ActStartTimeIndex = 0;
    Vector m_DataEntries = null;
    static GregorianCalendar m_EmptyTime = new GregorianCalendar(1990, 0, 1, 0, 0, 0);
    protected int m_GetEndTimeIndex = 0;
    protected int m_GetStartTimeIndex = 0;
    Vector m_IdCodeEntries = null;
    float m_IdMaxValue = 0.0f;
    float m_IdMinValue = 0.0f;
    boolean m_IdSoilDataExist;
    float m_MaxValue = 0.0f;
    float m_MinValue = 0.0f;
    protected int m_NrOfDataEntries = 0;
    boolean m_SoilDataExist;
    int m_TimeStepsWithoutData = 0;

    DataFile(int NrOfDataEntries, Vector DataEntries, Vector IdCodeEntries) {
        this();
        this.m_NrOfDataEntries = NrOfDataEntries;
        this.m_DataEntries = DataEntries;
        this.m_IdCodeEntries = IdCodeEntries;
        this.SetTimeRangeAll();
    }

    DataFile() {
        m_EmptyTime.setTimeZone(new SimpleTimeZone(3600000, "MEZ"));
        this.m_ActStartTime = (GregorianCalendar)m_EmptyTime.clone();
        this.m_ActEndTime = (GregorianCalendar)m_EmptyTime.clone();
        this.LineNr = 0;
    }

    public boolean CalculateMinMaxValue(int IdCode) {
        boolean valueExists = false;
        this.m_IdSoilDataExist = false;
        this.m_SoilDataExist = false;
        int i = 0;
        while (i < this.m_NrOfDataEntries) {
            DataEntry dataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
            if (dataEntry != null && dataEntry.GetTime() != null) {
                float Value;
                if (IdCode >= 500) {
                    int j;
                    if (!valueExists) {
                        if (((ProDataEntry)dataEntry).CheckDataValid(IdCode)) {
                            this.m_MinValue = ((ProDataEntry)dataEntry).GetZData(501, 0);
                            this.m_MaxValue = ((ProDataEntry)dataEntry).GetNrOfSnowLayers() == ((ProDataEntry)dataEntry).GetTotalNrOfLayers() ? ((ProDataEntry)dataEntry).GetZData(501, ((ProDataEntry)dataEntry).GetTotalNrOfLayers() - 1) : ((ProDataEntry)dataEntry).GetZData(501, ((ProDataEntry)dataEntry).GetTotalNrOfLayers());
                            j = 0;
                            while (j < ((ProDataEntry)dataEntry).GetNrOfLayers(IdCode)) {
                                if (j == 0) {
                                    this.m_IdMaxValue = this.m_IdMinValue = ((ProDataEntry)dataEntry).GetZData(IdCode, 0);
                                } else {
                                    Value = ((ProDataEntry)dataEntry).GetZData(IdCode, j);
                                    this.m_IdMinValue = Math.min(this.m_IdMinValue, Value);
                                    this.m_IdMaxValue = Math.max(this.m_IdMaxValue, Value);
                                }
                                ++j;
                            }
                            valueExists = true;
                            if (((ProDataEntry)dataEntry).SoilDataExist(IdCode)) {
                                this.m_IdSoilDataExist = true;
                            }
                            if (((ProDataEntry)dataEntry).SoilDataExist()) {
                                this.m_SoilDataExist = true;
                            }
                        }
                    } else if (((ProDataEntry)dataEntry).CheckDataValid(IdCode)) {
                        Value = ((ProDataEntry)dataEntry).GetZData(501, 0);
                        this.m_MinValue = Math.min(this.m_MinValue, Value);
                        if (this.m_MinValue > 0.0f) {
                            this.m_MinValue = 0.0f;
                        }
                        Value = ((ProDataEntry)dataEntry).GetNrOfSnowLayers() == ((ProDataEntry)dataEntry).GetTotalNrOfLayers() ? ((ProDataEntry)dataEntry).GetZData(501, ((ProDataEntry)dataEntry).GetTotalNrOfLayers() - 1) : ((ProDataEntry)dataEntry).GetZData(501, ((ProDataEntry)dataEntry).GetTotalNrOfLayers());
                        this.m_MaxValue = Math.max(this.m_MaxValue, Value);
                        j = 0;
                        while (j < ((ProDataEntry)dataEntry).GetNrOfLayers(IdCode)) {
                            Value = ((ProDataEntry)dataEntry).GetZData(IdCode, j);
                            this.m_IdMinValue = Math.min(this.m_IdMinValue, Value);
                            this.m_IdMaxValue = Math.max(this.m_IdMaxValue, Value);
                            ++j;
                        }
                        if (((ProDataEntry)dataEntry).SoilDataExist(IdCode)) {
                            this.m_IdSoilDataExist = true;
                        }
                        if (((ProDataEntry)dataEntry).SoilDataExist()) {
                            this.m_SoilDataExist = true;
                        }
                    }
                } else if (!valueExists) {
                    if (((MetDataEntry)dataEntry).CheckDataValid(IdCode)) {
                        this.m_MinValue = Value = ((MetDataEntry)dataEntry).GetMetData(IdCode);
                        this.m_MaxValue = Value;
                        valueExists = true;
                    }
                } else if (((MetDataEntry)dataEntry).CheckDataValid(IdCode)) {
                    Value = ((MetDataEntry)dataEntry).GetMetData(IdCode);
                    this.m_MinValue = Math.min(this.m_MinValue, Value);
                    this.m_MaxValue = Math.max(this.m_MaxValue, Value);
                }
            }
            ++i;
        }
        return valueExists;
    }

    public boolean CheckActDataValid(int IdCode) {
        if (this.m_ActDataEntry == null) {
            System.out.println("Warning: DataFile, method CheckActDataValid: m_ActDataEntry == null\n");
            return false;
        }
        if (this.m_ActDataEntry.GetTime() == null) {
            System.out.println("Warning: DataFile, method CheckActDataValid: m_ActDataEntry.GetTime() == null\n");
            return false;
        }
        if (!this.m_ActDataEntry.CheckDataValid(IdCode)) {
            System.out.println("Warning: DataFile, method CheckActDataValid: m_ActDataEntry.CheckDataValid(IdCode) == false\n");
            return false;
        }
        return true;
    }

    public abstract boolean CheckIfNewDataEntry(String var1) throws IOException;

    public DataEntry GetActDataEntry() {
        return this.m_ActDataEntry;
    }

    public GregorianCalendar GetActDataTime() {
        return (GregorianCalendar)this.m_ActDataEntry.GetTime().clone();
    }

    public GregorianCalendar GetEmptyTime() {
        return (GregorianCalendar)m_EmptyTime.clone();
    }

    public GregorianCalendar GetEndTime(int IdCode) {
        GregorianCalendar endTime = null;
        this.m_GetEndTimeIndex = 0;
        int i = this.m_NrOfDataEntries - 1;
        while (endTime == null && i >= 0) {
            DataEntry dataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
            if (dataEntry.GetDataLine(IdCode) != null) {
                endTime = dataEntry.GetTime();
                this.m_GetEndTimeIndex = i;
            }
            --i;
        }
        if (endTime == null) {
            return (GregorianCalendar)m_EmptyTime.clone();
        }
        return (GregorianCalendar)endTime.clone();
    }

    public GregorianCalendar GetEndTime() {
        return this.GetEndTime(500);
    }

    public abstract int GetIdCode();

    public abstract String GetSnowStatID();

    public GregorianCalendar GetStartTime(int IdCode) {
        GregorianCalendar startTime = null;
        this.m_GetStartTimeIndex = 0;
        int i = 0;
        while (startTime == null && i < this.m_NrOfDataEntries) {
            DataEntry dataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
            if (dataEntry.GetDataLine(IdCode) != null) {
                startTime = dataEntry.GetTime();
                this.m_GetStartTimeIndex = i;
            }
            ++i;
        }
        if (startTime == null) {
            return (GregorianCalendar)m_EmptyTime.clone();
        }
        return (GregorianCalendar)startTime.clone();
    }

    public GregorianCalendar GetStartTime() {
        return this.GetStartTime(500);
    }

    public abstract String GetStatAbbrev();

    public int GetTimeRange() {
        int ts = (int)((this.m_ActEndTime.getTime().getTime() - this.m_ActStartTime.getTime().getTime()) / 1000L);
        return ts;
    }

    public GregorianCalendar GetTimeRangeEndTime() {
        return (GregorianCalendar)this.m_ActEndTime.clone();
    }

    public GregorianCalendar GetTimeRangeStartTime() {
        return (GregorianCalendar)this.m_ActStartTime.clone();
    }

    /*
     * Unable to fully structure code
     */
    public int GetTimeResolution(int IdCode) {
        MinTimeStep = 0;
        i = 0;
        pLastTime = null;
        pNextTime = null;
        i = 0;
        while (pLastTime == null && i < this.m_NrOfDataEntries) {
            dataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
            pLastTime = dataEntry.GetTime();
            ++i;
        }
        if (pLastTime != null) ** GOTO lbl25
        return MinTimeStep;
lbl-1000:
        // 1 sources

        {
            dataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
            pNextTime = dataEntry.GetTime();
            if (pNextTime != null && pNextTime.after(pLastTime) && dataEntry.GetDataLine(IdCode) != null) {
                DiffTime = (int)((pNextTime.getTime().getTime() - pLastTime.getTime().getTime()) / 1000L);
                if (MinTimeStep == 0 || MinTimeStep > DiffTime) {
                    MinTimeStep = DiffTime;
                }
                pLastTime = pNextTime;
            }
            ++i;
lbl25:
            // 2 sources

            ** while (i < this.m_NrOfDataEntries)
        }
lbl26:
        // 1 sources

        return MinTimeStep;
    }

    public boolean IdCodeExists(int IdCode) {
        int i = 0;
        while (i < this.m_IdCodeEntries.size()) {
            if (IdCode == (Integer)this.m_IdCodeEntries.elementAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int MoveToFirstDataEntry() {
        if (this.m_ActStartTimeIndex < 0 || this.m_ActStartTimeIndex >= this.m_NrOfDataEntries) {
            return -1;
        }
        DataEntry dataEntry = (DataEntry)this.m_DataEntries.elementAt(this.m_ActStartTimeIndex);
        if (dataEntry == null || dataEntry.GetTime() == null) {
            return -1;
        }
        if (!dataEntry.GetTime().after(this.m_ActEndTime) && !dataEntry.GetTime().before(this.m_ActStartTime)) {
            this.m_ActDataEntryIndex = this.m_ActStartTimeIndex;
            this.m_ActDataEntry = dataEntry;
            return 0;
        }
        return 1;
    }

    public int MoveToLastDataEntry() {
        if (this.m_ActEndTimeIndex < 0 || this.m_ActEndTimeIndex >= this.m_NrOfDataEntries) {
            return -1;
        }
        DataEntry dataEntry = (DataEntry)this.m_DataEntries.elementAt(this.m_ActEndTimeIndex);
        if (dataEntry == null || dataEntry.GetTime() == null) {
            return -1;
        }
        if (!dataEntry.GetTime().after(this.m_ActEndTime) && !dataEntry.GetTime().before(this.m_ActStartTime)) {
            this.m_ActDataEntryIndex = this.m_ActEndTimeIndex;
            this.m_ActDataEntry = dataEntry;
            return 0;
        }
        return 1;
    }

    public int MoveToNextDataEntry(int TimeStep, int MinCatchTime, int MaxCatchTime) {
        int RetVal;
        if (this.m_ActDataEntry.GetTime() == null) {
            return -1;
        }
        int SavDataEntryIndex = this.m_ActDataEntryIndex;
        GregorianCalendar MinNextTime = (GregorianCalendar)this.m_ActDataEntry.GetTime().clone();
        MinNextTime.add(13, TimeStep * (1 + this.m_TimeStepsWithoutData) - MinCatchTime);
        GregorianCalendar MaxNextTime = (GregorianCalendar)this.m_ActDataEntry.GetTime().clone();
        MaxNextTime.add(13, TimeStep * (1 + this.m_TimeStepsWithoutData) + MaxCatchTime);
        GregorianCalendar ActTime = this.m_ActDataEntry.GetTime();
        do {
            if ((RetVal = this.MoveToNextDataEntry()) != 0 || MaxCatchTime < 0 || !this.m_ActDataEntry.GetTime().after(MaxNextTime)) continue;
            this.m_ActDataEntryIndex = SavDataEntryIndex;
            this.m_ActDataEntry = (DataEntry)this.m_DataEntries.elementAt(SavDataEntryIndex);
            ++this.m_TimeStepsWithoutData;
            return 1;
        } while (RetVal == 0 && this.m_ActDataEntry.GetTime().before(MinNextTime));
        this.m_TimeStepsWithoutData = 0;
        if (RetVal == 1 && this.m_ActDataEntry.GetTime().before(MinNextTime)) {
            this.m_ActEndTimeIndex = SavDataEntryIndex;
            this.MoveToLastDataEntry();
        }
        return RetVal;
    }

    public int MoveToNextDataEntry() {
        DataEntry dataEntry;
        int DataEntryIndex = this.m_ActDataEntryIndex;
        if (DataEntryIndex >= this.m_NrOfDataEntries) {
            return -1;
        }
        do {
            if (DataEntryIndex + 1 >= this.m_NrOfDataEntries) {
                return 1;
            }
            if ((dataEntry = (DataEntry)this.m_DataEntries.elementAt(++DataEntryIndex)) != null) continue;
            return -1;
        } while (dataEntry.GetTime() == null);
        if (!dataEntry.GetTime().after(this.m_ActEndTime) && !dataEntry.GetTime().before(this.m_ActStartTime)) {
            this.m_ActDataEntry = dataEntry;
            this.m_ActDataEntryIndex = DataEntryIndex;
            return 0;
        }
        return 1;
    }

    public int MoveToPrevDataEntry(int TimeStep, int MinCatchTime, int MaxCatchTime) {
        int RetVal;
        if (this.m_ActDataEntry.GetTime() == null) {
            return -1;
        }
        GregorianCalendar MinNextTime = (GregorianCalendar)this.m_ActDataEntry.GetTime().clone();
        MinNextTime.add(13, -(TimeStep + MinCatchTime));
        GregorianCalendar MaxNextTime = (GregorianCalendar)this.m_ActDataEntry.GetTime().clone();
        MaxNextTime.add(13, -(TimeStep - MaxCatchTime));
        do {
            if ((RetVal = this.MoveToPrevDataEntry()) != 0 || MaxCatchTime < 0 || !this.m_ActDataEntry.GetTime().before(MinNextTime)) continue;
            return 1;
        } while (RetVal == 0 && this.m_ActDataEntry.GetTime().after(MaxNextTime));
        return RetVal;
    }

    public int MoveToPrevDataEntry() {
        DataEntry dataEntry;
        int DataEntryIndex = this.m_ActDataEntryIndex;
        if (DataEntryIndex < 0) {
            return -1;
        }
        do {
            if (DataEntryIndex == 0) {
                return 1;
            }
            if ((dataEntry = (DataEntry)this.m_DataEntries.elementAt(--DataEntryIndex)) != null) continue;
            return -1;
        } while (dataEntry.GetTime() == null);
        if (!dataEntry.GetTime().after(this.m_ActEndTime) && !dataEntry.GetTime().before(this.m_ActStartTime)) {
            this.m_ActDataEntry = dataEntry;
            this.m_ActDataEntryIndex = DataEntryIndex;
            return 0;
        }
        return 1;
    }

    public abstract DataEntry NewDataEntry();

    public boolean ReadDataFile(File file) throws IOException {
        String ProcName = ModulName + ".ReadDataFile ";
        int LineNr = 0;
        int NrOfErrors = 0;
        String LineBuf = null;
        this.m_NrOfDataEntries = 0;
        this.m_ActDataEntryIndex = 0;
        this.m_IdCodeEntries = new Vector(10, 10);
        this.m_DataEntries = new Vector(24, 24);
        BufferedReader DataFile2 = new BufferedReader(new FileReader(file.getPath()));
        while (true) {
            try {
                LineBuf = DataFile2.readLine();
            }
            catch (RuntimeException e) {
                System.out.println("DataFile: out of memory; " + e);
                break;
            }
            if (LineBuf == null || NrOfErrors >= 300000) break;
            ErrorFile.SetLineNr(++LineNr);
            if (this.CheckIfNewDataEntry(LineBuf)) {
                this.m_ActDataEntry = this.NewDataEntry();
                if (this.m_ActDataEntry == null) {
                    ErrorFile.write("ERR_MEMORY", 1, ProcName);
                    return false;
                }
                this.m_DataEntries.insertElementAt(this.m_ActDataEntry, this.m_NrOfDataEntries++);
                if (this.m_ActDataEntry.ParseDataLine(LineBuf) != null) continue;
                ++NrOfErrors;
                continue;
            }
            if (this.m_ActDataEntry == null) continue;
            DataLine pDataLine = this.m_ActDataEntry.ParseDataLine(LineBuf);
            if (pDataLine == null) {
                ++NrOfErrors;
                continue;
            }
            if (this.IdCodeExists(pDataLine.GetIdCode())) continue;
            this.m_IdCodeEntries.addElement(new Integer(pDataLine.GetIdCode()));
        }
        System.out.println(ProcName + ">>>finished: number of lines = " + LineNr + " / number of errors = " + NrOfErrors);
        FileStatus.writeError(NrOfErrors);
        DataFile2.close();
        this.SetTimeRangeAll();
        if (this.m_NrOfDataEntries == 0 || NrOfErrors >= 300000) {
            ErrorFile.write("ERR_READ_INPUT_FILE", 2, ProcName);
            return false;
        }
        return true;
    }

    public int RoundTime(int TimeStep, int TimeDivision) throws IOException {
        String ProcName = ModulName + ".RoundTime";
        try {
            int roundedTime = (int)((double)TimeStep / (double)TimeDivision + 0.5) * TimeDivision;
            if (roundedTime == 0) {
                roundedTime = TimeDivision;
            }
            return roundedTime;
        }
        catch (ArithmeticException e) {
            ErrorFile.write("ERR_DIV_BY_ZERO", 1, ProcName);
            return 0;
        }
    }

    public boolean SetActDataEntry(GregorianCalendar NewTime, int MinCatchTime, int MaxCatchTime) {
        if (NewTime == null || this.m_ActDataEntry.GetTime() == null) {
            return false;
        }
        GregorianCalendar MinNextTime = (GregorianCalendar)NewTime.clone();
        MinNextTime.add(13, -MinCatchTime);
        GregorianCalendar MaxNextTime = (GregorianCalendar)NewTime.clone();
        MaxNextTime.add(13, MaxCatchTime);
        if (!MinNextTime.after(this.m_ActDataEntry.GetTime()) && !MaxNextTime.before(this.m_ActDataEntry.GetTime())) {
            return true;
        }
        int Index = this.m_ActDataEntry.GetTime().before(MinNextTime) ? this.m_ActDataEntryIndex : this.m_ActStartTimeIndex;
        while (Index < this.m_NrOfDataEntries && Index <= this.m_ActEndTimeIndex) {
            DataEntry dataEntry = (DataEntry)this.m_DataEntries.elementAt(Index);
            if (!MinNextTime.after(dataEntry.GetTime()) && !MaxNextTime.before(dataEntry.GetTime())) {
                this.m_ActDataEntryIndex = Index;
                this.m_ActDataEntry = dataEntry;
                return true;
            }
            ++Index;
        }
        return false;
    }

    public boolean SetActDataEntry(DataEntry NewDataEntry) {
        if (NewDataEntry == null) {
            return false;
        }
        if (NewDataEntry == this.m_ActDataEntry) {
            return true;
        }
        int Index = 0;
        while (Index < this.m_NrOfDataEntries) {
            if ((DataEntry)this.m_DataEntries.elementAt(Index) == NewDataEntry) break;
            ++Index;
        }
        if (Index == this.m_NrOfDataEntries) {
            return false;
        }
        if (Index < this.m_ActStartTimeIndex) {
            Index = this.m_ActStartTimeIndex;
        } else if (Index > this.m_ActEndTimeIndex) {
            Index = this.m_ActEndTimeIndex;
        }
        this.m_ActDataEntryIndex = Index;
        this.m_ActDataEntry = (DataEntry)this.m_DataEntries.elementAt(Index);
        return true;
    }

    public int SetTimeRange(int TimeRange, GregorianCalendar EndTime) {
        GregorianCalendar StartTime = (GregorianCalendar)EndTime.clone();
        StartTime.add(13, -TimeRange);
        return this.SetTimeRange(StartTime, EndTime);
    }

    public int SetTimeRange(GregorianCalendar StartTime, int TimeRange) {
        GregorianCalendar EndTime = (GregorianCalendar)StartTime.clone();
        EndTime.add(13, TimeRange);
        return this.SetTimeRange(StartTime, EndTime);
    }

    public int SetTimeRange(GregorianCalendar StartTime, GregorianCalendar EndTime) {
        DataEntry dataEntry;
        GregorianCalendar pTime = null;
        if (StartTime == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_NrOfDataEntries) {
            dataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
            if (dataEntry != null && (pTime = dataEntry.GetTime()) != null && (pTime.after(StartTime) || pTime.equals(StartTime))) {
                this.m_ActStartTime = pTime;
                this.m_ActStartTimeIndex = i;
                break;
            }
            ++i;
        }
        if (i == this.m_NrOfDataEntries) {
            this.SetTimeRangeAll();
            return 1;
        }
        if (EndTime == null) {
            this.m_ActEndTime = this.GetEndTime();
            this.m_ActEndTimeIndex = this.m_GetEndTimeIndex;
            this.m_ActDataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
            this.m_ActDataEntryIndex = i;
        } else {
            this.m_ActEndTime = EndTime;
            this.m_ActEndTimeIndex = 0;
            GregorianCalendar endTime = null;
            i = this.m_NrOfDataEntries - 1;
            while (i >= 0) {
                dataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
                if (dataEntry != null && (endTime = dataEntry.GetTime()) != null && !endTime.after(this.m_ActEndTime) && !endTime.before(this.m_ActStartTime)) {
                    this.m_ActEndTimeIndex = i;
                    this.m_ActEndTime = endTime;
                    this.m_ActDataEntry = (DataEntry)this.m_DataEntries.elementAt(i);
                    this.m_ActDataEntryIndex = i;
                    break;
                }
                --i;
            }
        }
        return 0;
    }

    public void SetTimeRangeAll() {
        this.m_ActStartTime = this.GetStartTime();
        this.m_ActEndTime = this.GetEndTime();
        this.m_ActDataEntry = (DataEntry)this.m_DataEntries.elementAt(this.m_GetEndTimeIndex);
        this.m_ActDataEntryIndex = this.m_GetEndTimeIndex;
        this.m_ActStartTimeIndex = this.m_GetStartTimeIndex;
        this.m_ActEndTimeIndex = this.m_GetEndTimeIndex;
    }
}

