/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.DataLine;
import ProWin.DateTimeDataLine;
import ProWin.ErrorFile;
import ProWin.IniFile;
import ProWin.MenuFrame;
import ProWin.Setup;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;

public class MetValuesDataLine
extends DataLine
implements C_DataFile {
    protected static String ModulName = "MetValuesDataLine";
    int m_IdCode = 200;
    int m_NrOfValues = 0;
    String m_SnowStat;
    String m_StatAbbrev = "";
    GregorianCalendar m_Time = new GregorianCalendar(new SimpleTimeZone(3600000, "MEZ"));
    String m_ValString = "";
    protected float[] m_ValueArray;
    String m_WindStat;

    public int GetDataType() {
        return 4;
    }

    public int GetIdCode() {
        return this.m_IdCode;
    }

    public float GetMetValue(int Index) {
        return this.m_ValueArray[Index];
    }

    public String GetMetValueString(int Index) {
        float Value = this.GetMetValue(Index);
        Float FloatValue = new Float(Value);
        this.m_ValString = FloatValue.toString();
        return this.m_ValString;
    }

    public int GetNrOfValues() {
        return this.m_NrOfValues;
    }

    public String GetSnowStatID() {
        return this.m_SnowStat;
    }

    public String GetStatAbbrev() {
        return this.m_StatAbbrev;
    }

    public GregorianCalendar GetTime() {
        return (GregorianCalendar)this.m_Time.clone();
    }

    public String GetWindStatID() {
        return this.m_WindStat;
    }

    public boolean HasDate() {
        return true;
    }

    public boolean ParseLine(String Line) throws IOException {
        String ProcName = ModulName + ".ParseLine";
        if (Line == null) {
            ErrorFile.write("ERR_PAR_FUNCTION", 1, ProcName);
            return false;
        }
        StringTokenizer st = new StringTokenizer(Line, ",", true);
        if (!st.hasMoreTokens()) {
            ErrorFile.write("ERR_LINE_SYNTAX", 2, ProcName);
            return false;
        }
        try {
            this.m_IdCode = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            ErrorFile.write("ERR_LINE_SYNTAX", 3, ProcName);
            return false;
        }
        if (!st.hasMoreTokens()) {
            ErrorFile.write("Comma missing", 4, ProcName);
            return false;
        }
        st.nextToken();
        if (!st.hasMoreTokens()) {
            ErrorFile.write("ERR_LINE_SYNTAX", 14, ProcName);
            return false;
        }
        String DateLine = st.nextToken();
        GregorianCalendar xTime = DateTimeDataLine.ScanDate(DateLine);
        if (xTime.equals(this.m_Time)) {
            ErrorFile.write("ERR_LINE_SYNTAX", 15, ProcName);
            return false;
        }
        this.m_Time = (GregorianCalendar)xTime.clone();
        MenuFrame.statusBar.setText("File reading: Current input date: " + DateLine);
        if (!st.hasMoreTokens()) {
            ErrorFile.write("Comma missing", 16, ProcName);
            return false;
        }
        st.nextToken();
        boolean prevWasComma = true;
        try {
            IniFile ParDataIni = new IniFile(Setup.m_IniFilePath + "PARDATA" + new Integer(this.m_IdCode).toString() + ".INI");
            this.m_NrOfValues = ParDataIni.getSectionSize();
        }
        catch (IOException e) {
            System.out.println("MetValuesDataLine.ParseLine: " + e);
        }
        this.m_ValueArray = new float[this.m_NrOfValues];
        int i = 0;
        while (st.hasMoreTokens() && i < this.m_NrOfValues) {
            String NextToken = st.nextToken();
            if (NextToken.equals(",")) {
                if (prevWasComma) {
                    this.m_ValueArray[i] = -999.9f;
                    ++i;
                    continue;
                }
                prevWasComma = true;
                continue;
            }
            try {
                this.m_ValueArray[i] = Float.valueOf(NextToken).floatValue();
            }
            catch (NumberFormatException e) {
                ErrorFile.write("ERR_LINE_SYNTAX", 17, ProcName);
                this.m_ValueArray[i] = -999.9f;
            }
            ++i;
            prevWasComma = false;
        }
        if (prevWasComma && i == this.m_NrOfValues - 1) {
            this.m_ValueArray[i] = -999.9f;
            ++i;
        }
        if (st.hasMoreTokens() || i < this.m_NrOfValues) {
            ErrorFile.write("ERR_LINE_SYNTAX", 18, ProcName);
            return false;
        }
        return true;
    }
}

