/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.ColorRange;
import java.awt.Color;
import java.util.Vector;

public class ColorTab {
    static Color BLK = new Color(0, 0, 0);
    static Color BLU;
    static Color CYA;
    static Color D_BLU;
    static Color D_GRN;
    static Color GRN;
    static int LAST_TABLE_INDEX;
    static Color L_BLK;
    static Color L_WHT;
    static Color MAG;
    static int[] NrOfColors;
    static Color RED;
    static Color[][] TableColors;
    static String[] TableNames;
    static Color WHT;
    static Color YEL;
    Vector m_ColorRangeList;
    float m_MaxValue = -3.4E38f;
    Color m_MaxValueColor;
    float m_MinValue = 3.4E38f;
    Color m_MinValueColor = new Color(0, 0, 0);

    static {
        L_BLK = new Color(64, 64, 64);
        WHT = new Color(255, 255, 255);
        L_WHT = new Color(240, 240, 240);
        RED = new Color(255, 0, 0);
        GRN = new Color(0, 255, 0);
        D_GRN = new Color(0, 127, 0);
        BLU = new Color(0, 0, 255);
        D_BLU = new Color(0, 0, 127);
        YEL = new Color(255, 255, 0);
        MAG = new Color(255, 0, 255);
        CYA = new Color(0, 255, 255);
        TableColors = new Color[][]{{L_BLK, L_WHT}, {L_WHT, BLU}, {L_WHT, RED}, {BLU, RED}, {GRN, MAG}, {BLU, GRN, YEL, RED}, {L_BLK, BLU, GRN, YEL, RED, MAG}, {D_BLU, BLU, CYA, L_WHT, RED}, {L_WHT, CYA, BLU, D_BLU}, {GRN, YEL, RED, MAG, BLU}, {D_GRN, YEL, RED, BLU, L_WHT}, {L_BLK, RED, YEL, L_WHT}, {RED, RED, YEL, GRN, GRN, BLU, BLU}};
        NrOfColors = new int[]{2, 2, 2, 2, 2, 4, 6, 5, 4, 5, 5, 4, 7};
        TableNames = new String[]{"Black - White", "White - Blue", "White - Red", "Blue - Red", "Green - Magenta", "Blue - Green - Yellow - Red", "Black - Blue - Green - Yellow - Red - Magenta", "Snow Temperature: Blue - White - Red", "White - Cyan - Dark-blue", "Green - Yellow - Red - Magenta - Blue", "Snow density: Green - Yellow - Red - Blue - White", "Black - Red - Yellow - White", "Red - Red - Yellow - Green - Green - Blue - Blue"};
        LAST_TABLE_INDEX = 12;
    }

    ColorTab() {
        this.m_MaxValueColor = new Color(0, 0, 0);
        this.m_ColorRangeList = new Vector(6, 6);
    }

    public boolean AddColorRange(Color StartRGB, Color EndRGB, float StartValue, float EndValue) {
        this.m_ColorRangeList.addElement(new ColorRange(StartRGB, EndRGB, StartValue, EndValue));
        if (StartValue < EndValue) {
            if (StartValue < this.m_MinValue) {
                this.m_MinValue = StartValue;
                this.m_MinValueColor = StartRGB;
            }
            if (EndValue > this.m_MaxValue) {
                this.m_MaxValue = EndValue;
                this.m_MaxValueColor = EndRGB;
            }
        } else {
            if (EndValue < this.m_MinValue) {
                this.m_MinValue = EndValue;
                this.m_MinValueColor = EndRGB;
            }
            if (StartValue > this.m_MaxValue) {
                this.m_MaxValue = StartValue;
                this.m_MaxValueColor = StartRGB;
            }
        }
        return true;
    }

    public Color GetColor(float Value, int TableIndex) {
        int i = 0;
        while (i < NrOfColors[TableIndex] - 1) {
            if (((ColorRange)this.m_ColorRangeList.elementAt(i)).IsInRange(Value)) {
                return ((ColorRange)this.m_ColorRangeList.elementAt(i)).GetColor(Value);
            }
            ++i;
        }
        if (Value < this.m_MinValue) {
            return this.m_MinValueColor;
        }
        if (Value > this.m_MaxValue) {
            return this.m_MaxValueColor;
        }
        return new Color(0, 0, 0);
    }

    public boolean LoadPredefinedColorTable(int TableIndex, float StartValue, float EndValue) {
        if (TableIndex > LAST_TABLE_INDEX) {
            return false;
        }
        if (NrOfColors[TableIndex] < 2) {
            return false;
        }
        float Offset = (EndValue - StartValue) / (float)(NrOfColors[TableIndex] - 1);
        this.m_ColorRangeList.removeAllElements();
        int i = 0;
        while (i < NrOfColors[TableIndex] - 1) {
            if (this.AddColorRange(TableColors[TableIndex][i], TableColors[TableIndex][i + 1], StartValue, StartValue + Offset)) {
                StartValue += Offset;
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }
}

