### This code creates a plot seperatly for each PA of the distribution of cloud forest within the PA and the change in cover spatially and over time

library(RColorBrewer)
library(rasterVis)
library(raster)
library(viridis)
library(gridExtra)
library(maptools)
library(grid)
library(ggplotify)
library(multcompView)
library(viridis)


years<-c(2001:2018)
xvect<-years

st1_mean<-stack(paste0("/mnt/storage/karger/cloudforest/Hansen_treecover_2020/tcf_ensemble_mn_",years,"_v16.tif"))
st1_sd  <-stack(paste0("/mnt/storage/karger/cloudforest/Hansen_treecover_2020/tcf_ensemble_sd_",years,"_v16.tif"))

data(wrld_simpl)
shp1<-shapefile("/mnt/lud11/karger/cloudforest_loss/WDPA_Dec2016-shapefile-polygons_TCF_v16.shp")
shp2<-shp1[!is.na(shp1$tcf_ensembl),]
shp2<-shp2[shp2$tcf_ensembl!=0,]
e2001<-raster("/mnt/storage/karger/cloudforest/Hansen_treecover_2020/tcf_ensemble_mn_2001_v16.tif")
e2016<-raster("/mnt/storage/karger/cloudforest/Hansen_treecover_2020/tcf_ensemble_mn_2018_v16.tif")
esd2001<-raster("/mnt/storage/karger/cloudforest/Hansen_treecover_2020/tcf_ensemble_sd_2001_v16.tif")
esd2016<-raster("/mnt/storage/karger/cloudforest/Hansen_treecover_2020/tcf_ensemble_sd_2018_v16.tif")

pdf("/mnt/storage/karger/cloudforest/cf_pa_areas_v16.pdf",height=20,width=14)
for (n in 1:2244)

{

shpx<-shp2[n,]
if(shpx@data$MARINE=="1"){next()}
  
c2001<-crop(e2001,extent(shpx))
c2016<-crop(e2016,shpx)
csd2001<-crop(esd2001,shpx)
csd2016<-crop(esd2016,shpx)


shpx_proj<-spTransform(shpx, crs("+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs"))


st1_mean_c<-crop(st1_mean,shpx_proj)
st1_sd_c  <-crop(st1_sd,shpx_proj)

st1_plussd  <- st1_mean_c+st1_sd_c
st1_minussd <- st1_mean_c-st1_sd_c


st1_mean_c  <- st1_mean_c/10000
st1_plussd  <- st1_plussd/10000
st1_minussd <- st1_minussd/10000


ex_st1_mean     <- extract(st1_mean_c,  shpx_proj, fun=sum, na.rm=TRUE, df=TRUE)
ex_st1_plussd   <- extract(st1_plussd,  shpx_proj, fun=sum, na.rm=TRUE, df=TRUE)
ex_st1_minussd  <- extract(st1_minussd, shpx_proj, fun=sum, na.rm=TRUE, df=TRUE)


mn<-unlist(ex_st1_minussd)[2:length(ex_st1_minussd)]
mp<-unlist(ex_st1_plussd)[2:length(ex_st1_plussd)]
mm<-unlist(ex_st1_mean)[2:length(ex_st1_mean)]
mn<-100*mn/(max(mn))
mp<-100*mp/(max(mp))
mm<-100*mm/(max(mm))


ymin<-min(mn,mp,mm)
ymax<-max(mn,mp,mm)

pp1 <- ggplot(as.data.frame(cbind(xvect,mn,mp,mm)), aes(xvect,mn))+
                theme_classic() +
                scale_colour_manual(values = c("green")) +
                geom_line(aes(xvect,mm))+
                xlab("year") +
                ylab("percent cf area") +
                geom_ribbon(data=as.data.frame(cbind(xvect,mn,mp,mm)),aes(ymin=mn,ymax=mp),alpha=0.3,fill="green")


breaks<-c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1)
breaks2<-c(-0.05,-0.04,-0.03,-0.02,-0.01,0,0.01,0.02,0.03,0.04,0.05)
breakssd<-c(0.01,0.02,0.03,0.04,0.05,0.06,0.07,0.08,0.09,0.1)
colors_1<-viridis(11)
colors_2<-c("#a50026",
  "#d73027",
  "#f46d43",
  "#fdae61",
  "#fee090",
  "#ffffbf",
  "#e0f3f8",
  "#abd9e9",
  "#74add1",
  "#4575b4",
  "#313695")

c2001<-c2001*0.0001
c2016<-c2016*0.0001
csd2001<-csd2001*0.0001
csd2016<-csd2016*0.0001

lp1<-levelplot(c2001,col.regions=colors_1,main="ensemble mean tcf cover 2001",colorkey=list(space="bottom"),at=breaks,margin=FALSE,ylab="",xlab="fraction tcf cover",par.settings = list(layout.heights=list(xlab.key.padding=1)))+latticeExtra::layer(sp.polygons(shpx), packets = 1)
lp2<-levelplot(c2016,col.regions=colors_1,main="ensemble mean tcf cover 2018",colorkey=list(space="bottom"),at=breaks,margin=FALSE,ylab="",xlab="fraction tcf cover",par.settings = list(layout.heights=list(xlab.key.padding=1)))+latticeExtra::layer(sp.polygons(shpx), packets = 1)

ranges<-max(abs(max(na.omit(values(csd2001)))),abs(min(na.omit(values(csd2001)))))
if(ranges==0){ranges<-0.01}
breaks_adjsd<-seq(0,ranges,ranges/11)

lp1sd<-levelplot(csd2016,col.regions=inferno(11),main="ensemble sd tcf cover 2001",colorkey=list(space="bottom"),at=breaks_adjsd,margin=FALSE,ylab="",xlab="fraction tcf cover",par.settings = list(layout.heights=list(xlab.key.padding=1)))+latticeExtra::layer(sp.polygons(shpx), packets = 1)
lp2sd<-levelplot(csd2016,col.regions=inferno(11),main="ensemble sd tcf cover 2018",colorkey=list(space="bottom"),at=breaks_adjsd,margin=FALSE,ylab="",xlab="fraction tcf cover",par.settings = list(layout.heights=list(xlab.key.padding=1)))+latticeExtra::layer(sp.polygons(shpx), packets = 1)

cc<-(c2016-c2001)

ccsd<-c2016-csd2016-c2001+csd2001


ranges<-max(abs(max(na.omit(values(cc)))),abs(min(na.omit(values(cc)))))
breaks_adj1<-seq((ranges*-1),ranges,ranges*2/11)
ranges<-max(abs(max(na.omit(values(ccsd)))),abs(min(na.omit(values(ccsd)))))
breaks_adj2<-seq((ranges*-1),ranges,ranges*2/11)

lpcc  <-levelplot(cc,col.regions=colors_2,main="mean cf cover change",colorkey=list(space="bottom"),at=breaks_adj2,margin=FALSE,ylab="",xlab="fraction tcf cover",par.settings = list(layout.heights=list(xlab.key.padding=1)))+latticeExtra::layer(sp.polygons(shpx), packets = 1)
lpccsd<-levelplot(ccsd,col.regions=colors_2,main="mean+sd cf cover change",colorkey=list(space="bottom"),at=breaks_adj2,margin=FALSE,ylab="",xlab="fraction tcf cover",par.settings = list(layout.heights=list(xlab.key.padding=1)))+latticeExtra::layer(sp.polygons(shpx), packets = 1)

rdummy <- raster(xmn=-180, xmx=180, ymn=-40, ymx=40)
rdummy <- init(rdummy, runif)

x<-mean(coordinates(shpx)[,1])
y<-mean(coordinates(shpx)[,2])
xy<-data.frame(x,y)
xy$z<-1
coordinates(xy)<-~x+y
crs(xy)<-"+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs"
xy<-spTransform(xy,crs("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs"))

wwp<-rasterVis::levelplot(rdummy,col.regions="white",main="Location of protected area",margin=FALSE,ylab="",xlab="", colorkey=FALSE)+
  latticeExtra::layer(sp.polygons(wrld_simpl),packets=1)+
  latticeExtra::layer(sp.points(xy, pch=16, cex=1, col="red"),columns=1) 


c2001proj<-projectRaster(c2001,res=1000,crs= "+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs", method="bilinear")
c2016proj<-projectRaster(c2016,res=1000,crs= "+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs", method="bilinear")



ex2001 <- extract(c2001proj, shpx_proj, fun=sum, na.rm=TRUE, df=TRUE)
ex2016 <- extract(c2016proj, shpx_proj, fun=sum, na.rm=TRUE, df=TRUE)
exC    <- ex2016[2]-ex2001[2]
tgrob<-grid.text(paste0("WDPA_PID: ",shpx@data$WDPA_PID,"\n",
                        "ORIG_NAME: ",shpx@data$ORIG_NAME,"\n",
                        "NAME: ",shpx@data$NAME,"\n",
                        "DESIG_ENG: ",shpx@data$DESIG_ENG,"\n",
                        "COUNTRY: ",shpx@data$ISO3,"\n",
                        "IUCN_CAT: ",shpx@data$IUCN_CAT,"\n",
                        "REP_AREA: ",round(shpx@data$REP_AREA,2),"km_sqr\n",
                        "GIS_AREA: ",round(shpx@data$GIS_AREA,2),"km_sqr\n",
                        "%_TCF_AREA_2001_OF_GIS_AREA: ",round(100*(ex2001[2])/(shpx@data$GIS_AREA),2),"\n",
                        "%_tCF_AREA_2018_OF_GIS_AREA: ",round(100*(ex2016[2])/(shpx@data$GIS_AREA),2),"\n",
                        "tcf_area_2001: ",round(ex2001[2],2),"km_sqr\n",
                        "tcf_area_2018: ",round(ex2016[2],2),"km_sqr\n",
                        "cf_area_change: ",round(exC,2),"km_sqr\n"),
                        
                 just="center",draw=FALSE)

lay<-rbind(c(1,2),
           c(3,3),
           c(4,5),
           c(6,7),
           c(8,9))
gs<-list(tgrob,pp1,wwp,lp1,lp1sd,lp2,lp2sd,lpcc,lpccsd)

grid.arrange(grobs=gs,layout_matrix=lay)
}
dev.off()



