# EnviDat General Policies v. 1.0

<br />

### Preamble

 The EnviDat policies are subject to change by EnviDat at any time and without notice. The updated policies will be posted on the www.envidat.ch website. For any questions, please contact EnviDat support at [envidat-support@wsl.ch](mailto:envidat-support@wsl.ch).

<br />

## EnviDat Privacy Policy

**For information collected from users.**

-   EnviDat does not track, collect or retain personal information from users, except as otherwise provided herein. 
-   Depositors gain access with a passwordless login procedure, which ensures that there is no need to store user passwords. 
-   Non-personal information such as IP addresses and cookies may be tracked and retained in order to monitor traffic and aggregated to provide various usage statistics as requested by the depositors. These usage statistics may also be made public. 
-   Server log files containing non-personal information such as IP addresses and requested URLs may be retained. These server logs may be shared with third parties for the purpose of security auditing. 
-   EnviDat will take all reasonable measures to protect the privacy of its users and to resist service interruptions, intentional attacks, or other events that may compromise the security of the EnviDat website.

<br />

## EnviDat Metadata Policy

**For information describing content items in the repository.**

-   All metadata is in English.
-   Access to the published metadata is open and free of charge.
    -   All information is provided â€œas-isâ€, EnviDat disclaims all warranties, express or implied.
    -   The validity, authenticity, quality and respecting copyright of the metadata is the sole responsibility of the depositor.
    -   The metadata may be re-used in any medium for any purposes without prior permission.
    -   If technically feasable, we kindly ask that a link to the original metadata record is provided and is kept up-to-date.

<br />

## EnviDat Content Policy

**For all content items in the repository, incl. data, software and other resources**

-   EnviDat is an institutional data portal and repository of the Swiss Federal Institute for Forest, Snow and Landscape Research WSL.
-   Subject: environmental research data and software, including but not limited to the terrestrial environment, incl. forests, biodiversity, landscape, natural hazards, snow and ice.
-   All formats are allowed, including formats not optimized for preservation. However, preservation friendly formats such as CSV are actively encouraged.
-   The EnviDat repository is restricted to:
    -   datasets,
    -   software (including but not limited to scripts, plugins or libraries),
    -   additional resources (e.g., documentations, images, videos, links to publications) that improve the understanding and reuse of the datasets and software that are provided through EnviDat.
-   The Terms of Use or License for the content have to be actively chosen by the depositor:
    -   The WSL Data Policy kindly asks data users to attribute and precludes data redistribution unless otherwise agreed with data originators.
        **Users may not share WSL research data or place them in data repositories that are accessible to third parties without the prior consent of the WSL data producers. Exclusive rights to reuse or publish WSL research data may not be transferred to commercial publishers or their agents. WSL reserves the right to use its research data itself or make it accessible to third parties for reuse.**
    -   The Open Database License (ODC-ODbL) kindly asks data users to attribute, share-alike and keep open (see <https://opendatacommons.org/licenses/odbl/>) for details.
    -   Content items may, however, be individually tagged by the depositors with their "Other" license or terms of use, thus defining different rights, permissions and restrictions of use.
    -   Content items may be restricted, asking data users to contact the data originator in order to receive access.
    -   When in doubt about the terms of use for content items, we kindly ask data users to contact the data originator.
-   The validity, authenticity, quality and respecting copyright of the content of submissions is the sole responsibility of the depositor.

<br />

## EnviDat Submission Policy

**Concerning depositors, quality & copyright**

-   Metadata and content items may only be deposited by accredited members of WSL, or their delegated collaborators. 
-   All metadata information must be provided in English
-   Depositors may only submit metadata and content items for which they have the necessary permissions and rights for distribution and publication.
-   The EnviDat administrator only vets metadata and content items for the eligibility of depositors, relevance to the scope of EnviDat, valid layout & format, and the exclusion of spam
-   The validity, authenticity and quality of the content of submissions is the sole responsibility of the depositor.
-   Metadata and content items can be deposited at any time, but the depositors have the option to restrict them until any publishers' or funders' embargo period has expired. The responsibility for complying with publisherâ€™s or funderâ€™s embargo policies and for respecting specified embargo period lies with the depositors. The timely lifting of restrictions is also incumbent on depositors.
-   Any copyright violations related to the submission of metadata and content items to EnviDat are the responsibility of the depositors. 
-   If EnviDat receives proof of copyright violation, the relevant item will be removed immediately and the depositors informed.
-   Copyright violations can be reported [envidat-support@wsl.ch](mailto:envidat-support@wsl.ch).

<br />

## EnviDat Preservation Policy

**Concerning continued readability and accessibility of metadata and content items**

-   Metadata and content items will be retained for the entire duration of EnviDat existence.
-   In the event of EnviDat having to close down, best efforts will be made to integrate all metadata and content items into a suitable alternative repository.
-   EnviDat has regular backups of all information (metadata and content items) according to best practices if the WSL IT department.
-   Metadata and content items may be removed at the request of the depositor. Possible reasons for withdrawal include, but are not limited to:
    -   violations of WSL research integrity guidelines,
    -   proven copyright violation or plagiarism,
    -   legal requirements and proven violations,
    -   journal publishers' rules.
-   Withdrawing metadata and content items means:
    -   permanent identifiers (DOIs) and permanent (DOI) URLs are retained for the entire duration of EnviDat existence,
    -   DOI URLs will continue to point totombstone' records, to avoid broken links from scientific citations, with a modified description explaining the reasons for withdrawal,
    -   the content items are not deleted per se, but are restricted, and therefore, no longer accessible.
-   Updated versions of the content items may be deposited at any time, as long as the most recent version is clearly identified.

<br />

## Acknowledgments

We would like to thank OpenDOAR and Zenodo for serving as inspiration for the current EnviDat policy.
