/* eslint-disable */
export default {
    "help": "https://www.envidat.ch/api/3/action/help_show?name=group_list",
    "success": true,
    "result": [
        {
            "display_name": "Aerosols",
            "description": "During the [RACLETS](https://www.envidat.ch/group/about/raclets-field-campaign) campaign aerosol properties were measured in Davos Wolfang, at an elevation of 1630 m above sea level (a.s.l.), which is in a valley between lake Davos in the South and Laret in the North. The second measurement site for aerosol particles was on a mountain site, called Weissfluhjoch, at an elevation of 2700 m a.s.l. The instruments were owned and operated by ETH Zurich and University of Basel. \r\n\r\nThe aerosol size spectra from 15 nm to 40 &#956; m were recorded with a combination of SMPS (model 3310, TSI Inc.), APS (model 3321, TSI Inc.), and OPCs (OPC-N3, Alphasense ; GT-526S Met One Instruments, Inc.).\r\nIn-situ measurements of Cloud Condensation Nuclei (CCN) were carried out with a CCN chamber (CCNC, Droplet Measurement Technologies). LINDA (LED based Ice Nucleation Detection Aparatus, University of Basel), DRINCZ (Droplet Ice Nuclei Counter Zurich, ETH Zurich), and a cold stage were used to investigate ice nucleating particle (INP) concentrations by drop freezing experiments. Information about the secondary ice fraction was gained by melting and re-freezing single dendrites. For further chemical analysis, particles larger than 0.5 um were collected with an air sampler (Coriolis micro, Bertin instruments) using a cyclone technology to separate particles from the air into the sample liquid. \r\n\r\nInformation on [precipitation](https://www.envidat.ch/group/precipitation), [wind](https://www.envidat.ch/group/remote-sensing-raclets), [meteorological parameters](https://www.envidat.ch/group/meteorology), [cloud properties](https://www.envidat.ch/group/remote-sensing-raclets) and [cloud composition](https://www.envidat.ch/group/clouds-in-situ-raclets) were gained at the valley station. [Snowflake](https://www.envidat.ch/group/about/snow) properties were investigated at the mountaintop station. \r\n\r\n[HoloBalloon](https://www.envidat.ch/group/clouds-in-situ-raclets) and [radiosondes](https://www.envidat.ch/group/meteorology) were launched close to the aerosol measurement station in Davos Wolfgang. The OceaNet container hosting [remote sensing](https://www.envidat.ch/group/remote-sensing-raclets) instruments and a disdrometer to measure [precipitation](https://www.envidat.ch/group/precipitation) were placed in the same area.\r\n\r\n![pic not found](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Jan/IMG_20190209_103151_scale.jpg)\r\n\r\n\r\n![pic not found](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Claudia/IMG_8970_scale.JPG)\r\n\r\nImages: Claudia Mignani, Jan Henneberger",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-08-21-115852.482765RACLETSaerosolslogo.png",
            "package_count": 0,
            "created": "2019-07-11T14:03:37.443395",
            "name": "aerosols-raclets",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "RACLETS Field Campaign",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "d5f5974d-b407-464b-9b20-d6b37a8653c5",
                    "group_id": "7e071c09-4ec0-4ebf-bf3c-a41755cd566d",
                    "id": "a816750b-efce-4d9b-876a-f692732ea212"
                }
            ],
            "image_url": "2019-08-21-115852.482765RACLETSaerosolslogo.png",
            "groups": [],
            "type": "group",
            "title": "Aerosols",
            "revision_id": "95f9c699-fc66-47fc-9412-e85d2eb466a8",
            "packages": [],
            "num_followers": 0,
            "id": "7e071c09-4ec0-4ebf-bf3c-a41755cd566d",
            "approval_status": "approved"
        },
        {
            "display_name": "Amphibian breeding sites module (WBS)",
            "description": "Amphibians are one of the most threatened groups of animals in Switzerland. Preserving their breeding sites is an essential part of amphibian conservation. 70 % of the indigenous amphibian species are now on the Red List of Endangered Swiss amphibians. The amphibian breeding sites module is coordinated by info fauna karch (the Swiss Amphibian and Reptile Coordination Centre) while local experts conduct field surveys.\r\nThe WBS sub-sample comprises 258 amphibian breeding sites. These include 124 objects already examined for the 2005 Red List update as well as 18 additional objects, integrated after the inventory update of 2017. The sample encompasses all amphibian species and biogeographic regions of Switzerland. The national inventory distinguishes between fixed objects (ponds and other permanent wetlands) and ‘mobile’ objects (mainly gravel pits). The 258 objects of the WBS sample are composed of 218 fixed and 40 mobile objects.\r\nLow-elevation sites are surveyed four times and high-elevation sites twice between March and June. During the field surveys, all detected amphibian species are recorded. The data is stored at info fauna karch and enables the tracking of trends in amphibian populations nationwide and in each of the biogeographical regions. Cantons have access to the data via the virtual database VDC.\r\n",
            "image_display_url": "https://biotopschutz.wsl.ch/fileadmin//user_upload/WSL/Microsite/Wirkungskontrolle-Biotopschutz-Schweiz/kreuzkroete.jpg",
            "package_count": 0,
            "created": "2019-09-02T15:43:00.414545",
            "name": "wbs-amphibian-breeding-sites-module",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "Monitoring the Effectiveness of Habitat Conservation in Switzerland (WBS)",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "e75b4006-c804-4dba-862d-d44d81369f7b",
                    "group_id": "6bf045d9-d81d-4109-8265-5c8ff03ade77",
                    "id": "05ae8e5a-2db6-417e-aa3e-911e5b090e9c"
                }
            ],
            "image_url": "https://biotopschutz.wsl.ch/fileadmin//user_upload/WSL/Microsite/Wirkungskontrolle-Biotopschutz-Schweiz/kreuzkroete.jpg",
            "groups": [],
            "type": "group",
            "title": "Amphibian breeding sites module (WBS)",
            "revision_id": "a6fcbea6-8872-48ed-8d64-63aa50ec95db",
            "packages": [],
            "num_followers": 0,
            "id": "6bf045d9-d81d-4109-8265-5c8ff03ade77",
            "approval_status": "approved"
        },
        {
            "display_name": "Clouds in-situ",
            "description": "During the [RACLETS](https://www.envidat.ch/group/edit/raclets-field-campaign) campaign, in-situ measurements of clouds were conducted using two measurement platforms owned by ETH Zurich: HoloBalloon and HoloGondel. HoloBalloon, a tethered balloon system, was launched at Davos Wolfgang at an elevation of 1630 m above sea level (a.s.l.) and ascended up to 800 m above ground. HoloGondel was mount on the upper section of the Gotschnabahn cable car, running between Gotschnaboden (1779 m a.s.l.) and Gotschnagrat (2285 m a.s.l.). \r\n\r\nBoth platforms were equipped with a holographic imager HOLIMO to measure the cloud microphysics. HOLIMO was used to image cloud particles in a size range between 6 um and 2 mm in a three-dimensional sample volume. Cloud droplets and ice crystals were discriminated above 25 µm based on the shape of their 2D shadowgraph. The products are phase resolved particle size distributions, concentrations, water contents and spatial distribution of the cloud particles. In addition to HOLIMO, the size distribution between 0.3 and 20 um was measured by an optical particle counter covering the larger aerosol particles and smallest cloud droplets in addition to [meteorological parameters](https://www.envidat.ch/group/meteorology) (temperature, relative humidity, atmospheric pressure). \r\n\r\nInstruments to measure [aerosol concentrations](https://www.envidat.ch/group/aerosols-raclets), [meteorological parameters](https://www.envidat.ch/group/meteorology), [wind profiles/velocities](https://www.envidat.ch/group/remote-sensing-raclets), [precipitation](https://www.envidat.ch/group/precipitation) and the [CloudNet station](https://www.envidat.ch/group/remote-sensing-raclets) were close to the location where HoloBalloon and [radiosondes](https://www.envidat.ch/group/meteorology) were launched. \r\n\r\n![image missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Annika/DSC_4601-2_Scale.jpg)\r\n\r\n![image missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Annika/DSC_4605-2_Scale.jpg)\r\n\r\n![image missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Annika/DSC_4674_Scale.jpg)\r\n\r\n![image missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Annika/DSC_4704_scale.jpg)\r\n\r\nImages: Annika Lauber",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-08-21-115947.993386RACLETScloudlogo.png",
            "package_count": 0,
            "created": "2019-07-11T14:04:00.259360",
            "name": "clouds-in-situ-raclets",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "RACLETS Field Campaign",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "d30267cb-a19f-457c-aaee-23037c7a9d66",
                    "group_id": "0bb4f4d3-5d71-4fe0-829a-b63d5c76020b",
                    "id": "f3471b54-e412-41a8-9cf7-1adfb1636768"
                }
            ],
            "image_url": "2019-08-21-115947.993386RACLETScloudlogo.png",
            "groups": [],
            "type": "group",
            "title": "Clouds in-situ",
            "revision_id": "2d91e0bb-ca8b-4ae9-ae92-394c051969b1",
            "packages": [],
            "num_followers": 0,
            "id": "0bb4f4d3-5d71-4fe0-829a-b63d5c76020b",
            "approval_status": "approved"
        },
        {
            "display_name": "Global Cryosphere Watch",
            "description": "The World Meteorological Organization's Global Cryosphere Watch (GCW) is an international mechanism for supporting all key cryospheric in-situ and remote sensing observations. To meet the needs of WMO Members and partners in delivering services to users, the media, public, decision and policy makers, GCW provides authoritative, clear, and useable data, information, and analyses on the past, current and future state of the cryosphere. GCW includes observation, monitoring, assessment, product development, prediction, and research. It provides the framework for reliable, comprehensive, sustained observing of the cryosphere through a coordinated and integrated approach on national to global scales to deliver quality-assured global and regional products and services. GCW organizes analyses and assessments of the cryosphere to support science, decision-making and environmental policy.\r\n\r\nMore Information: http://globalcryospherewatch.org/",
            "image_display_url": "http://globalcryospherewatch.org/about/images/gcw_logo.png",
            "package_count": 5,
            "created": "2017-01-11T17:04:00.315493",
            "name": "gcw",
            "is_organization": false,
            "state": "active",
            "extras": [],
            "image_url": "http://globalcryospherewatch.org/about/images/gcw_logo.png",
            "groups": [],
            "type": "group",
            "title": "Global Cryosphere Watch",
            "revision_id": "bf7e62b3-c5ee-4e43-b63a-1db2ea43f301",
            "packages": [
                {
                    "owner_org": "a17b145f-2191-4c21-aabf-55661d5cb140",
                    "maintainer": "{\"affiliation\": \"WSL Institute for Snow and Avalanche Research SLF\", \"email\": \"bebi@slf.ch\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Bebi\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "938e0cc0-0f75-41da-a358-679f27c254d4",
                    "metadata_created": "2016-11-04T12:32:20.196813",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"WSL Institute for Snow and Avalanche Research SLF\", \"publication_year\": \"2016\"}",
                    "metadata_modified": "2019-12-16T08:55:30.238947",
                    "author": "[{\"name\": \"Bebi\", \"affiliation\": \"WSL Institute for Snow and Avalanche Research SLF\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"bebi@slf.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.867160,46.773573]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 8,
                    "title": "Long-term meteorological and snow station at 2090 m a.s.l., Stillberg, Davos, Switzerland (1975 - present)",
                    "spatial_info": "Switzerland, Davos ",
                    "creator_user_id": "fe7fa798-2f5c-4ad3-b865-50260d7322cf",
                    "date": "[{\"date\": \"1975-01-01\", \"date_type\": \"collected\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "stillberg-climate",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.43",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Longterm meteorological and snow station on a steep (c. 40 degrees) North-East exposed slope at 2090 m a.s.l above  Davos, Switzerland. Established 1975 and ongoing measurements made, although instruments have changed during this period. The station is located within a experimental plantation that serves as avalanche protection to downslope communities as well as a unique site for treeline dynamics research.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The WSL Institute for Snow and Avalanche Research SLF is an interdisciplinary research and service centre located in Davos Dorf. It forms part of the WSL – the Swiss Federal Institute for Forest, Snow and Landscape Research – and thus belongs to the domain of the ETH (Swiss Federal Institutes of Technology). Its scientists conduct research on snow, the atmosphere, natural hazards, permafrost and mountain ecological systems, and develop innovative products that translate their knowledge into practical applications. The SLF seeks to engage in top-level research while contributing to the resolution of urgent societal issues, for example in the fields of natural hazard warning systems and the analysis of climate and environmental change. \r\n\r\n__Further information__: https://www.slf.ch",
                        "created": "2016-05-24T16:15:21.861195",
                        "title": "SLF",
                        "name": "slf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2016-05-24-141521.837240logoslf.png",
                        "revision_id": "9018b3a8-6928-4cc0-b5ed-64091418ffd2",
                        "type": "organization",
                        "id": "a17b145f-2191-4c21-aabf-55661d5cb140",
                        "approval_status": "approved"
                    },
                    "revision_id": "a54f669f-4ec3-46e6-ab64-1e5d470f8534",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "72a2ca75-fa5c-411c-bfa9-1edbbbede2ae",
                    "maintainer": "{\"affiliation\": \"SLF\", \"email\": \"nander.wever@slf.ch\", \"identifier\": \"\", \"given_name\": \"Nander\", \"name\": \"Wever \"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "0b294122-015c-46bf-b5c5-cc6d0a6f67c1",
                    "metadata_created": "2016-10-16T21:39:20.449911",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"WSL Institute for Snow and Avalanche Research SLF\", \"publication_year\": \"2016\"}",
                    "metadata_modified": "2019-10-31T22:57:38.264353",
                    "author": "[{\"name\": \"WSL Institute for Snow and Avalanche Research SLF\", \"affiliation\": \"SLF\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"nander.wever@slf.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1",
                    "spatial": "{\"type\":\"Point\", \"coordinates\":[ 9.809568, 46.829598]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "Manual bi-weekly snow profiles from Weissfluhjoch, Davos, Switzerland",
                    "spatial_info": "[46.829598 9.809568]",
                    "creator_user_id": "334cee1e-6afa-4639-88a2-f980e6ff42c3",
                    "date": "[{\"date\": \"2018-07-06\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "10-16904-2",
                    "publication_state": "published",
                    "doi": "10.16904/2",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Dataset of manual bi-weekly snow profiles from Weissfluhjoch, Davos, Switzerland. Typical snow profile measurements and observations are included (temperature, density, grain size, grain type, hardness, wetness), following the guidelines of the The International Classification for Seasonal Snow on the Ground (ICSSG) [Fierz, C., Armstrong, R.L., Durand, Y., Etchevers, P., Greene, E., McClung, D.M., Nishimura, K., Satyawali, P.K. and Sokratov, S.A. 2009. The International Classification for Seasonal Snow on the Ground. IHP-VII Technical Documents in Hydrology N°83, IACS Contribution N°1, UNESCO-IHP, Paris]. \r\n\r\n",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The meteorological conditions governing winter sports are influenced by both the natural variability of the climate and the climatic changes induced by mankind. We need data and models in order to visualise the current and future snow situation, and to show the potential of possible intervention strategies. For this reason, the group’s principal fields of activity encompass snow management, including piste preparation and snow farming, snowpack modelling (SNOWPACK and A3D), as well as snow climatological analyses and scenarios.",
                        "created": "2018-11-15T15:29:17.561586",
                        "title": "Winter Sports and Climate",
                        "name": "snow-sports",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.envidat.ch/uploads/group/2016-05-24-141521.837240logoslf.png",
                        "revision_id": "74274931-f3b3-4268-a522-ed90c47c764b",
                        "type": "organization",
                        "id": "72a2ca75-fa5c-411c-bfa9-1edbbbede2ae",
                        "approval_status": "approved"
                    },
                    "revision_id": "99ca6b2d-ac44-4462-848c-9440bafaab4d",
                    "resource_type": "Snow Profile Measurements"
                },
                {
                    "owner_org": "a17b145f-2191-4c21-aabf-55661d5cb140",
                    "maintainer": "{\"affiliation\": \"WSL Institute for Snow and Avalanche Research SLF \", \"email\": \"marty@slf.ch\", \"identifier\": \"\", \"given_name\": \"Christoph\", \"name\": \"Marty\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "74417a94-f434-4a7c-a05b-c1f71af4a7f4",
                    "metadata_created": "2017-03-03T11:48:30.356102",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"WSL Institute for Snow and Avalanche Research SLF \", \"publication_year\": \"2017\"}",
                    "metadata_modified": "2019-10-25T12:29:49.121357",
                    "author": "[{\"name\": \"Marty\", \"affiliation\": \"WSL Institute for Snow and Avalanche Research SLF \", \"affiliation_03\": \"\", \"given_name\": \"Christoph\", \"identifier\": \"\", \"email\": \"marty@slf.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{         \"type\": \"Point\",         \"coordinates\": [           9.84827,           46.81277         ]       }",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 4,
                    "title": "ASRB_DAV: Shortwave and longwave radiation measurements (2 min) in Davos Dorf",
                    "spatial_info": "Davos, Switzerland",
                    "creator_user_id": "fe7fa798-2f5c-4ad3-b865-50260d7322cf",
                    "date": "[{\"date\": \"1996-01-01\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "",
                    "relationships_as_subject": [],
                    "name": "asrb-dav",
                    "publication_state": "",
                    "doi": "",
                    "isopen": true,
                    "language": "",
                    "url": null,
                    "notes": "Incoming and outgoing  shortwave and longwave 2 min radiation measurements in Davos Dorf, CH. \r\n\r\n### References\r\n1. Marty, C., Philipona, R., Frohlich, C., Ohmura, A.. Altitude dependence of surface radiation fluxes and cloud forcing in the alps: results from the alpine surface radiation budget network. 2002. Theoretical and Applied Climatology. Volume 72. Issue 3-4. 137-155. http://dx.doi.org/10.1007/s007040200019. 10.1007/s007040200019.\r\n2. Christoph Marty. Surface Radiation, Cloud Forcing and Greenhouse Effect in the Alps. 2000. Institute fuer Klimaforschung ETH. Zuercher Klima-Schriften. Volume 79. http://e-collection.library.ethz.ch/eserv/eth:23491/eth-23491-01.pdf.\r\n",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The WSL Institute for Snow and Avalanche Research SLF is an interdisciplinary research and service centre located in Davos Dorf. It forms part of the WSL – the Swiss Federal Institute for Forest, Snow and Landscape Research – and thus belongs to the domain of the ETH (Swiss Federal Institutes of Technology). Its scientists conduct research on snow, the atmosphere, natural hazards, permafrost and mountain ecological systems, and develop innovative products that translate their knowledge into practical applications. The SLF seeks to engage in top-level research while contributing to the resolution of urgent societal issues, for example in the fields of natural hazard warning systems and the analysis of climate and environmental change. \r\n\r\n__Further information__: https://www.slf.ch",
                        "created": "2016-05-24T16:15:21.861195",
                        "title": "SLF",
                        "name": "slf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2016-05-24-141521.837240logoslf.png",
                        "revision_id": "9018b3a8-6928-4cc0-b5ed-64091418ffd2",
                        "type": "organization",
                        "id": "a17b145f-2191-4c21-aabf-55661d5cb140",
                        "approval_status": "approved"
                    },
                    "revision_id": "592e657f-104e-4993-bd84-fd017040e956",
                    "resource_type": ""
                },
                {
                    "owner_org": "a17b145f-2191-4c21-aabf-55661d5cb140",
                    "maintainer": "{\"affiliation\": \"WSL Institute for Snow and Avalanche Research SLF \", \"email\": \"marty@slf.ch\", \"identifier\": \"\", \"given_name\": \"Christoph\", \"name\": \"Marty\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "99a619e2-5c9e-48c5-bcc6-6d8bab8b5709",
                    "metadata_created": "2016-12-02T14:54:17.544330",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"WSL Institute for Snow and Avalanche Research SLF \", \"publication_year\": \"2016\"}",
                    "metadata_modified": "2019-10-25T02:07:45.728597",
                    "author": "[{\"name\": \"Marty\", \"affiliation\": \"WSL Institute for Snow and Avalanche Research SLF \", \"affiliation_03\": \"\", \"given_name\": \"Christoph\", \"identifier\": \"\", \"email\": \"marty@slf.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.809204,46.829631]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 4,
                    "title": "ASRB_WFJVF: Shortwave and longwave radiation measurements (2 min) at the Weissfluhjoch research site, Davos",
                    "spatial_info": "",
                    "creator_user_id": "fe7fa798-2f5c-4ad3-b865-50260d7322cf",
                    "date": "[{\"date\": \"1996-01-01\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "asrb-vf",
                    "publication_state": "",
                    "doi": "",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Incoming and outgoing  shortwave and longwave 2 min radiation measurements at the Weissfluhjoch research site, Davos, CH. The experimental site at the Weissfluhjoch (WFJ, 46.83 N, 9.81 E) is located at an altitude of 2540 m in the Swiss Alps near Davos. During the winter months, almost all precipitation falls as snow at this altitude. As a consequence, a continuous seasonal snow cover builds up every winter, with a maximum snow height ranging from 153–366 cm over the period 1934–2012. The measurement site is located in an almost flat part of a southeast oriented slope.\r\n\r\n### References\r\n1. Marty, C., Philipona, R., Frohlich, C., Ohmura, A.. Altitude dependence of surface radiation fluxes and cloud forcing in the alps: results from the alpine surface radiation budget network. 2002. Theoretical and Applied Climatology. Volume 72. Issue 3-4. 137-155. http://dx.doi.org/10.1007/s007040200019. 10.1007/s007040200019.\r\n2. Christoph Marty. Surface Radiation, Cloud Forcing and Greenhouse Effect in the Alps. 2000. Institute fuer Klimaforschung ETH. Zuercher Klima-Schriften. Volume 79. http://e-collection.library.ethz.ch/eserv/eth:23491/eth-23491-01.pdf.\r\n",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The WSL Institute for Snow and Avalanche Research SLF is an interdisciplinary research and service centre located in Davos Dorf. It forms part of the WSL – the Swiss Federal Institute for Forest, Snow and Landscape Research – and thus belongs to the domain of the ETH (Swiss Federal Institutes of Technology). Its scientists conduct research on snow, the atmosphere, natural hazards, permafrost and mountain ecological systems, and develop innovative products that translate their knowledge into practical applications. The SLF seeks to engage in top-level research while contributing to the resolution of urgent societal issues, for example in the fields of natural hazard warning systems and the analysis of climate and environmental change. \r\n\r\n__Further information__: https://www.slf.ch",
                        "created": "2016-05-24T16:15:21.861195",
                        "title": "SLF",
                        "name": "slf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2016-05-24-141521.837240logoslf.png",
                        "revision_id": "9018b3a8-6928-4cc0-b5ed-64091418ffd2",
                        "type": "organization",
                        "id": "a17b145f-2191-4c21-aabf-55661d5cb140",
                        "approval_status": "approved"
                    },
                    "revision_id": "ed91b1ba-11b5-417d-9fc3-f218ca0bea52",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "e961ac74-4328-44c9-9c6e-93373a48464d",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"email\": \"phillips@slf.ch\", \"identifier\": \"\", \"given_name\": \"Marcia\", \"name\": \"Phillips\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "0c21a308-e1c8-488b-a410-57f31577f80d",
                    "metadata_created": "2016-11-07T13:01:06.135914",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"PERMOS\", \"publication_year\": \"2016\"}",
                    "metadata_modified": "2019-10-24T13:35:58.606055",
                    "author": "[{\"name\": \"Phillips\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Marcia\", \"identifier\": \"\", \"email\": \"phillips@slf.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.9451,46.7479]}",
                    "license_id": "other-undefined",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 3,
                    "title": "Processed permafrost borehole data (2394 m asl), Fluelapass A, Switzerland",
                    "spatial_info": "Fluela Pass, Graubunden, Switzerland",
                    "creator_user_id": "fe7fa798-2f5c-4ad3-b865-50260d7322cf",
                    "date": "[{\"date\": \"2002-10-01\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "flu-a-bh",
                    "publication_state": "",
                    "doi": "10.13093/permos-2016-01 ",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "Processed ground temperature measurements at the Fluelapass permafrost borehole A (FLU_0102) in canton Graubunden, Switzerland. The borehole is located at 2394 m asl on a moderate (26°) North-east slope (45°). The surface material is talus and borehole depth is 23 m. Thermistors used YSI 44006. Year of drilling 2002. This borehole is part of the Swiss Permafrost network, PERMOS (www.permos.ch). Contact phillips@slf.ch for details of processing applied.",
                    "license_title": "Other (Specified in the description)",
                    "organization": {
                        "description": "Permanently frozen ground (so called permafrost) is widespread in the Alps above around 2500 m asl . Climate change can influence permafrost occurrence in several ways. The study of slope stability in ice-bearing permafrost features (e.g. rock glaciers, moraines) and of debris flows and rockfall in permafrost areas is becoming increasingly relevant due to the growing use of mountain areas for human activities. We investigate the interactions between permafrost, mountain infrastructure and the snow cover.",
                        "created": "2018-11-15T15:28:01.425181",
                        "title": "Permafrost",
                        "name": "permafrost-and-snow-climatology",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.envidat.ch/uploads/group/2016-05-24-141521.837240logoslf.png",
                        "revision_id": "ccd02cb9-a136-4043-971c-58b0011526d9",
                        "type": "organization",
                        "id": "e961ac74-4328-44c9-9c6e-93373a48464d",
                        "approval_status": "approved"
                    },
                    "revision_id": "4454e1cb-fa0f-46b1-af63-95f850fb1aad",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "fe88bd8e-2e6f-4c2d-8b49-41fa224d5e00",
            "approval_status": "approved"
        },
        {
            "display_name": "Meteorology",
            "description": "Meteorological parameters and present weather were measured for the duration of the [RACLETS](https://www.envidat.ch/group/about/raclets-field-campaign) campaign at the Weissfluhjoch at an elevation of 2700 m above sea level (a.s.l.), and in Davos Wolfgang and Kloster, two villages which are in the valley at 1600 m a.s.l. and 1170 m a.s.l., respectively. The mountain ridge Gotschna separates Davos Wolfgang in the South from Klosters in the North.  The deployed instruments were owned by ETH Zurich, Meteoswiss and TROPOS. \r\n\r\nAmbient temperature (°C), humidity (%), atmospheric pressure (hPa), solar radiation (W m-1) and wind direction (°) and speed (m s-1) were recorded at standard weather stations from Meteoswiss at Weissfluhjoch and Davos Wolfgang, and from TROPOS at Davos Wolfgang. Additionally, a present weather detector (PWD22, Vaisala) was installed at Klosters to measure the weather type, ambient ligth as well as intensity and amount of both liquid and solid precipitation (mm). \r\n\r\nRadiosondes were started in Davos Wolfgang to report height profiles of pressure, relative humidity and temperature.\r\nFurther profiles of meteorological measures were recorded at [HoloGondel](https://www.envidat.ch/group/about/clouds-in-situ-raclets), which was installed at the gondola moving between Gotschnaboden and Gotschnagrat at 2285 m a.s.l.\r\n\r\n![image is missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Claudia/P2121953_Scale.JPG)\r\n\r\nImage: Claudia Mignani",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-08-21-120017.589162RACLETSmeteologo.png",
            "package_count": 5,
            "created": "2019-07-11T14:04:31.578927",
            "name": "meteorology",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "RACLETS Field Campaign",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "e0e66916-a877-4cf9-93e3-9b4174d131bb",
                    "group_id": "14176f90-0058-4679-b328-0c14b513cf22",
                    "id": "fd9ad5ba-b9b0-48f8-a519-761863bc04aa"
                }
            ],
            "image_url": "2019-08-21-120017.589162RACLETSmeteologo.png",
            "groups": [],
            "type": "group",
            "title": "Meteorology",
            "revision_id": "55c29072-413c-49b3-8230-a1ec4577b432",
            "packages": [
                {
                    "owner_org": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                    "maintainer": "{\"affiliation\": \"MeteoSwiss\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"identifier\": \"\", \"given_name\": \"Maxime\", \"name\": \"Hervo\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "f14e4d77-4be6-4123-a525-e0e50e0d89a1",
                    "metadata_created": "2019-04-17T13:29:14.148924",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"MeteoSwiss\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2020-01-20T14:45:12.092659",
                    "author": "[{\"name\": \"Hervo\", \"data_credit\": \"collection\", \"affiliation\": \"MeteoSwiss\", \"affiliation_03\": \"\", \"given_name\": \"Maxime\", \"identifier\": \"\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.880413,46.869019]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Weather Station Klosters",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-01\", \"date_type\": \"collected\", \"end_date\": \"2019-03-29\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "weather_station_klosters",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.129",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A weather station (Lufft WS600) measured meteorological parameters at Klosters. ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "related_datasets": "",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "MeteoSwiss is the Federal Office for Meteorology and Climatology. We operate the national surface and radar measurement network and collect, manage and analyse weather and climate data. We produce forecasts, inform, warn and advise, and are engaged in researching and developing tailor-made products and services. \r\n\r\nThe Atmospheric Measurement and Data division is specialized in upper air measurements.\r\n\r\nMore information on: https://www.meteosuisse.admin.ch/home.html",
                        "created": "2020-01-16T12:55:40.341488",
                        "title": "Atmospheric Measurement and Data Division",
                        "name": "atmospheric-measurement-and-data-division",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2020-01-16-115540.320888meteoschweiz.png",
                        "revision_id": "373f17a9-bec5-4428-b309-745fddfcb74e",
                        "type": "organization",
                        "id": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                        "approval_status": "approved"
                    },
                    "revision_id": "1cea4c40-ed66-4aa5-8212-1e2a636d4c36",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                    "maintainer": "{\"affiliation\": \"MeteoSwiss\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"identifier\": \"\", \"given_name\": \"Maxime\", \"name\": \"Hervo\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "45bb3cf1-2ab7-4757-92b2-b5f8fc09bfe9",
                    "metadata_created": "2020-01-17T14:40:37.491060",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"MeteoSwiss\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2020\"}",
                    "metadata_modified": "2020-01-20T10:59:35.125708",
                    "author": "[{\"name\": \"Hervo\", \"data_credit\": \"collection\", \"affiliation\": \"MeteoSwiss\", \"affiliation_03\": \"\", \"given_name\": \"Maxime\", \"identifier\": \"\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.880413, 46.869019]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Present Weather Sensor Klosters",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-06\", \"date_type\": \"collected\", \"end_date\": \"2019-03-31\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "present-weather-sensor-klosters",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.128",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A present weather sensor (Vaisala PWD22) was deployed in Klosters for weather observation, combining the functions of  a forwardscatter visibility meter and a present weather sensor. Besides measuring ambient light, it detects the intensity as well as the amount of both liquid and solid precipitation. More information can be found in the [User's Manual](ftp://ftp.cmdl.noaa.gov/aerosol/doc/manuals/PWD22_Manual.pdf).",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "related_datasets": "",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "MeteoSwiss is the Federal Office for Meteorology and Climatology. We operate the national surface and radar measurement network and collect, manage and analyse weather and climate data. We produce forecasts, inform, warn and advise, and are engaged in researching and developing tailor-made products and services. \r\n\r\nThe Atmospheric Measurement and Data division is specialized in upper air measurements.\r\n\r\nMore information on: https://www.meteosuisse.admin.ch/home.html",
                        "created": "2020-01-16T12:55:40.341488",
                        "title": "Atmospheric Measurement and Data Division",
                        "name": "atmospheric-measurement-and-data-division",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2020-01-16-115540.320888meteoschweiz.png",
                        "revision_id": "373f17a9-bec5-4428-b309-745fddfcb74e",
                        "type": "organization",
                        "id": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                        "approval_status": "approved"
                    },
                    "revision_id": "e95ffab3-4464-463a-b8aa-8413d496a47f",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                    "maintainer": "{\"affiliation\": \"MeteoSwiss\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"identifier\": \"\", \"given_name\": \"Maxime\", \"name\": \"Hervo\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "b938e2eb-20fc-4886-8329-9c8f20b0336b",
                    "metadata_created": "2020-01-14T12:33:17.785064",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"MeteoSwiss\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2020\"}",
                    "metadata_modified": "2020-01-20T10:59:21.141226",
                    "author": "[{\"name\": \"Hervo\", \"affiliation\": \"MeteoSwiss\", \"affiliation_03\": \"\", \"given_name\": \"Maxime\", \"identifier\": \"\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\", \"coordinates\": [9.880413, 46.869019]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Ceilometer Klosters",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-06\", \"date_type\": \"collected\", \"end_date\": \"2019-03-31\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "ceilometer-klosters",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.127",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Cloud base height (m) and vertical visibility (m) are measured with the VAISALA Ceilometer CL31, an instrument with constant reliability for all weather conditions and simultaneous detection of three cloud layers in heights up to 7.6 km. ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "related_datasets": "",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "MeteoSwiss is the Federal Office for Meteorology and Climatology. We operate the national surface and radar measurement network and collect, manage and analyse weather and climate data. We produce forecasts, inform, warn and advise, and are engaged in researching and developing tailor-made products and services. \r\n\r\nThe Atmospheric Measurement and Data division is specialized in upper air measurements.\r\n\r\nMore information on: https://www.meteosuisse.admin.ch/home.html",
                        "created": "2020-01-16T12:55:40.341488",
                        "title": "Atmospheric Measurement and Data Division",
                        "name": "atmospheric-measurement-and-data-division",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2020-01-16-115540.320888meteoschweiz.png",
                        "revision_id": "373f17a9-bec5-4428-b309-745fddfcb74e",
                        "type": "organization",
                        "id": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                        "approval_status": "approved"
                    },
                    "revision_id": "e43a8701-80bc-42da-a405-ddc516a873e0",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "677814d4-baab-47c2-ba03-8f34882de3cc",
                    "maintainer": "{\"affiliation\": \"ETH Zürich\", \"identifier\": \"\", \"given_name\": \"\", \"name\": \"Jörg Wieder\", \"email\": \"joerg.wieder@env.ethz.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 8,
                    "subtitle": "",
                    "id": "f6c38c8c-ab20-43a6-ae37-82117733df96",
                    "metadata_created": "2019-10-15T12:10:50.529170",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"SNF\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-22T08:06:40.353928",
                    "author": "[{\"name\": \"Jörg Wieder\", \"data_credit\": \"collection\", \"affiliation\": \"ETH Zürich\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"joerg.wieder@env.ethz.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Carolin Rösch\", \"data_credit\": \"curation\", \"affiliation\": \"ETH Zürich\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"carolin.roesch@env.ethz.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.853594,46.835577]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "Radiosondes",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-10\", \"date_type\": \"collected\", \"end_date\": \"2019-03-26\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "radiosondes",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.121",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Radiosondes (Windsond, Sparv Embedded AB) were started in Davos Wolfgang to report height profiles of pressure, relative humidity and temperature at specific days. In addition to regular launches of radiosondes, sondes were attached to [HoloBalloon](https://www.envidat.ch/group/clouds-in-situ-raclets) to report the ambient conditions of the in-situ measurements. Further profiles of meteorological measures were recorded at [HoloGondel](https://www.envidat.ch/group/clouds-in-situ-raclets) which was installed at the gondola moving between Gotschnaboden and Gotschnagrat at 2285 m a.s.l.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The Institute for Atmospheric and Climate Science (IAC) is part of the Department of Environmental Systems Science (D-USYS) of the Swiss Federal Institute of Technology Zurich (ETH Zurich). The IAC focuses on atmospheric and climate processes, including links to the hydrosphere, cryosphere, and biosphere. Research is directed at understanding how human activities alter these processes via changes in greenhouse gases, aerosols, chemical constituents, and land surfaces and how this impacts upon climate, ozone, UV radiation, pollutant exposure, ecosystems, water resources and extreme events. Emphasisis placed on the improvement of the predictive capabilities on weather and climate time scales and on knowledge transfer between basic sciences, applied sciences, and society. ",
                        "created": "2019-04-16T12:35:23.279710",
                        "title": "IAC",
                        "name": "iac",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-04-16-114039.307713image.imageformat.lightbox.404647511.jpg",
                        "revision_id": "b2837ec2-da4d-4eaf-a932-3dbbc72ea96f",
                        "type": "organization",
                        "id": "677814d4-baab-47c2-ba03-8f34882de3cc",
                        "approval_status": "approved"
                    },
                    "revision_id": "4a61747f-5195-498a-9214-ed4ac8edea82",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "efa1aa57-2aef-41de-8d36-d5847445a2dc",
                    "metadata_created": "2019-11-05T14:30:30.346894",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:15:42.200034",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch\", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "Walter B., H. Huwald, J. Gehring, Y. Bühler, and M. Lehning, Radar measurements of blowing snow off a mountain ridge, submitted",
                    "num_resources": 5,
                    "title": "Snow Drift Station - 3D Ultrasonic",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-11\", \"date_type\": \"collected\", \"end_date\": \"2019-03-21\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-3d-ultrasonic",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.116",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A Young 81000 sonic anemomenter was deployed to record three components of the wind velocity (u, v, w in [m s&#8254; &#185;]) and air temperature (Ts in [°C]). The anemomenter was mounted in direction North at a height of 1.5 m above snow surface at the beginning. The time within each data set is given in UTC+1. Instrument specifications can be found [here](http://www.youngusa.com/Manuals/81000-90(I).pdf) . ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "b3210d87-d153-4221-a105-ef8311e71d91",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "14176f90-0058-4679-b328-0c14b513cf22",
            "approval_status": "approved"
        },
        {
            "display_name": "MiSO",
            "description": "Microscale Distribution of Impurities in SnOw and Glacier Ice (MiSo)\r\n\r\nThe impact of the physical micro-environment of impurities in snow on their re-distribution during metamorphism, chemical reactivity, and transfer to ice core archives.\r\n\r\nLink to Funding Agency: http://p3.snf.ch/project-155999\r\n\r\nLink to Project Page: https://www.psi.ch/luc/miso ",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-10-10-060132.252109SnowImpurities.PNG",
            "package_count": 1,
            "created": "2019-10-10T08:01:32.268821",
            "name": "miso",
            "is_organization": false,
            "state": "active",
            "extras": [],
            "image_url": "2019-10-10-060132.252109SnowImpurities.PNG",
            "groups": [],
            "type": "group",
            "title": "MiSO",
            "revision_id": "fd734b22-e24b-476a-97fb-29bd79cd555f",
            "packages": [
                {
                    "owner_org": "b4199ab3-9251-4062-bd69-4e193a31541c",
                    "maintainer": "{\"affiliation\": \"PSI\", \"identifier\": \"0000-0002-7548-2572\", \"given_name\": \"Thorsten\", \"name\": \"Bartels-Rausch\", \"email\": \"thorsten.bartels-rausch@psi.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "8c77d71e-155b-40ab-a446-ae2dccac9740",
                    "metadata_created": "2019-10-09T12:04:37.436918",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:06:58.910514",
                    "author": "[{\"name\": \"Edebeli\", \"data_credit\": [\"collection\", \"validation\", \"publication\"], \"affiliation\": \"PSI\", \"affiliation_03\": \"\", \"given_name\": \"Jacinta\", \"identifier\": \"\", \"email\": \"jacinta.edebeli@psi.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Ammann\", \"data_credit\": \"publication\", \"affiliation\": \"PSI\", \"affiliation_03\": \"\", \"given_name\": \"Markus\", \"identifier\": \"0000-0001-5922-9000\", \"email\": \"markus.ammann@psi.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Bartels-Rausch\", \"data_credit\": [\"validation\", \"curation\", \"software\", \"publication\", \"supervision\"], \"affiliation\": \"PSI\", \"affiliation_03\": \"\", \"given_name\": \"Thorsten\", \"identifier\": \"0000-0002-7548-2572\", \"email\": \"thorsten.bartels-rausch@psi.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Polygon\",\"coordinates\":[[[8.20404052734375,47.52230157865766],[8.20404052734375,47.53713768492089],[8.261032104492188,47.53713768492089],[8.261032104492188,47.52230157865766],[8.20404052734375,47.52230157865766]]]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* Jacinta Edebeli, Ammann, M., and Bartels-Rausch, T. (2019). Microphysics of the aqueous bulk counters the water activity driven rate acceleration of bromide oxidation by ozone from 289–245 K. Environmental Science: Processes & Impacts, 21, 63-73, [https://doi.org/10.1039/c8em00417j](https://doi.org/10.1039/c8em00417j).\r\n* psi:24720",
                    "num_resources": 2,
                    "title": "Kinetic experiments on the oxidation of bromide by ozone from 289-245 K.",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7856a99c-b015-402e-84ac-e394981f6492",
                    "date": "[{\"date\": \"2016-01-01\", \"date_type\": \"collected\", \"end_date\": \"2018-12-31\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "kinetic-experiments-on-the-oxidation-of-bromide-by-ozone-from-289-245-k",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.88",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The reaction of ozone with bromide in polar regions results in the formation of reactive bromide species with impacts on ozone budget and the oxidative capacity of the lower atmosphere. Here, we present a data investigating the temperature dependence of bromide oxidation by ozone using a coated wall flow tube reactor coated with an aqueous mixture of citric acid and sodium bromide, a proxy for sea salt aerosol in snow or the free troposphere. Thus study shows the effect of of organic species at relatively mild temperatures between the freezing point and eutectic temperature as typical for Earth's cryosphere. ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The Laboratory of Environmental Chemistry (LUC) focuses on fundamental research and education for assessing the impact of human activities and natural processes on human health, environment and climate.\r\nThe surface chemistry research group investigates multi-phase chemical processes relevant for atmospheric chemistry and the analytical chemistry research group reconstructs environmental and climatic conditions from high-altitude glaciers.\r\n\r\nMore information: https://www.psi.ch/en/luc",
                        "created": "2019-10-04T11:01:58.059845",
                        "title": "LUC",
                        "name": "laboratory-of-environmental-chemistry",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.psi.ch/themes/custom/design/psi.svg",
                        "revision_id": "a9d55769-9855-4339-a27d-4eca7dc3566d",
                        "type": "organization",
                        "id": "b4199ab3-9251-4062-bd69-4e193a31541c",
                        "approval_status": "approved"
                    },
                    "revision_id": "4058be86-e6ac-47c1-80e1-6b9d9f1b8763",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "0e0fd1ee-3dc9-41b4-a1a7-3a4441f2584c",
            "approval_status": "approved"
        },
        {
            "display_name": "Modelling",
            "description": "The regional numerical weather predicton model COSMO was used to simulate certain periods of the [RACLETS](https://www.envidat.ch/group/about/raclets-field-campaign) campaign. The one-moment scheme which described cloud microphysical processes with prognostic variables was replaced by a two-moment scheme which considered a higher number of hydrometeor classes and used prescribed CCN and INP concentrations. \r\n\r\nThe results of the two-moment scheme were compared to both, the operationally used one-moment scheme and the in-situ cloud microphysical data and precipitation measurements of the campaign. In addition to tuning of parameterizations of cloud microphysical processes, which are important prerequisites for the stabilization of orographic MPCs and therewith orographic precipitation in the model, the influence of anthropogenic aerosol on precipitation was assesd. The simulations were conducted with various CCN and INP concentrations under the same meteorological conditions to represent clean and polluted scenarios.    \r\n",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-08-21-120058.853032RACLETSmodellogo.png",
            "package_count": 1,
            "created": "2019-07-11T14:05:04.589082",
            "name": "modeling",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "RACLETS Field Campaign",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "401b3229-f1f2-4167-82be-ac14eda062c0",
                    "group_id": "5e515677-99b1-4de2-bc51-4750069c6aeb",
                    "id": "4101a784-8d4c-43ab-ad31-2168f6717b1e"
                }
            ],
            "image_url": "2019-08-21-120058.853032RACLETSmodellogo.png",
            "groups": [],
            "type": "group",
            "title": "Modelling",
            "revision_id": "10a70b08-bcac-40f8-9fb1-d0d81c4141f6",
            "packages": [
                {
                    "owner_org": "677814d4-baab-47c2-ba03-8f34882de3cc",
                    "maintainer": "{\"affiliation\": \"ETH\", \"email\": \"michael.sprenger@env.ethz.ch\", \"identifier\": \"\", \"given_name\": \"Michael\", \"name\": \"Sprenger\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "dcbfd36f-3b67-49c1-be77-0f5b75810fab",
                    "metadata_created": "2019-11-14T07:40:56.031574",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"ETH \", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-22T08:05:39.494227",
                    "author": "[{\"name\": \"Sprenger\", \"affiliation\": \"ETH\", \"affiliation_03\": \"\", \"given_name\": \"Michael\", \"identifier\": \"\", \"email\": \"michael.sprenger@env.ethz.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.853594,46.835577]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Backward  Trajectories",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-02\", \"date_type\": \"collected\", \"end_date\": \"2019-03-27\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "raclets-backward-trajectories",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.120",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Backward trajectories were calculated from two positions: Davos Wolfgang (9.85361 E 46.83551 N) and Weissfluhjoch (9.80646 E 46.83304 N) for the time period February 2 until March 27 2019 using COSMO or ECMWF, respectively.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The Institute for Atmospheric and Climate Science (IAC) is part of the Department of Environmental Systems Science (D-USYS) of the Swiss Federal Institute of Technology Zurich (ETH Zurich). The IAC focuses on atmospheric and climate processes, including links to the hydrosphere, cryosphere, and biosphere. Research is directed at understanding how human activities alter these processes via changes in greenhouse gases, aerosols, chemical constituents, and land surfaces and how this impacts upon climate, ozone, UV radiation, pollutant exposure, ecosystems, water resources and extreme events. Emphasisis placed on the improvement of the predictive capabilities on weather and climate time scales and on knowledge transfer between basic sciences, applied sciences, and society. ",
                        "created": "2019-04-16T12:35:23.279710",
                        "title": "IAC",
                        "name": "iac",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-04-16-114039.307713image.imageformat.lightbox.404647511.jpg",
                        "revision_id": "b2837ec2-da4d-4eaf-a932-3dbbc72ea96f",
                        "type": "organization",
                        "id": "677814d4-baab-47c2-ba03-8f34882de3cc",
                        "approval_status": "approved"
                    },
                    "revision_id": "7aa98954-2084-4a10-943b-1842c8de7a11",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "5e515677-99b1-4de2-bc51-4750069c6aeb",
            "approval_status": "approved"
        },
        {
            "display_name": "Monitoring the Effectiveness of Habitat Conservation in Switzerland (WBS)",
            "description": "To protect its biodiversity and to prevent further habitat loss and the extinction of endangered species, Switzerland designated about 7000 sites of national importance since the early 1990s. These nationally important sites are legally protected and include fens, bogs, dry grasslands, riparian areas, flood plains and amphibian breeding sites. They now are a crucial element of the network of protected sites in Switzerland. In 2011, the WSL Swiss Federal Research Institute and the Federal Office for the Environment (FOEN) launched the joint project, \"Monitoring the Effectiveness of Habitat Conservation in Switzerland (WBS)\". Using remote sensing approaches as well as floristic and faunistic field surveys, we monitor whether the sites of national importance are developing along with their conservation targets and whether their area and habitat quality is maintained. \r\nThe remote-sensing module monitors all sites of national importance on a regular basis. Based on these data, an online color-coded warning system has been established to ensure early detection of negative changes and to conduct prompt conservation measures. This tool can be assessed by the responsible federal and cantonal conservation authorities.\r\nThe very laborious field surveys are conducted in a subsample of all sites. Vegetation changes in fens, bogs, dry grasslands, riparian areas and flood plains are interpreted using diversity and compositional measures. The regular sampling of amphibian species and their population-size classes reflect temporal changes in amphibian breeding sites.\r\n\r\nThe project is composed of the following three modules:\r\n\r\n- [_Vegetation module_](https://www.envidat.ch/group/about/wbs-vegetation-module)\r\n- [_Amphibian breeding sites module_](https://www.envidat.ch/group/about/wbs-amphibian-breeding-sites-module)\r\n- [_Remote-sensing module_](https://www.envidat.ch/group/about/wbs-remote-sensing-module) \r\n",
            "image_display_url": "https://biotopschutz.wsl.ch/fileadmin//user_upload/WSL/Microsite/Wirkungskontrolle-Biotopschutz-Schweiz/HM-Habkern.jpg",
            "package_count": 0,
            "created": "2019-08-19T14:23:30.929422",
            "name": "wbs",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "Amphibian breeding sites module, Vegetation module, Remote-sensing module",
                    "state": "active",
                    "key": "subprojects",
                    "revision_id": "324cb559-cd60-4839-9219-624c7b0b38c3",
                    "group_id": "895b34a8-add7-4a47-8940-91be28806a5d",
                    "id": "3f783ead-f387-4948-aff0-6389214a9a17"
                }
            ],
            "image_url": "https://biotopschutz.wsl.ch/fileadmin//user_upload/WSL/Microsite/Wirkungskontrolle-Biotopschutz-Schweiz/HM-Habkern.jpg",
            "groups": [],
            "type": "group",
            "title": "Monitoring the Effectiveness of Habitat Conservation in Switzerland (WBS)",
            "revision_id": "9cbbe829-6288-42a6-8b80-08bfe37a2647",
            "packages": [],
            "num_followers": 0,
            "id": "895b34a8-add7-4a47-8940-91be28806a5d",
            "approval_status": "approved"
        },
        {
            "display_name": "Precipitation",
            "description": "Rain or snow reaching the ground as precipitation were measured at a high elevation site and at two locations in the valley over the course of the [RACLETS](https://www.envidat.ch/group/about/raclets-field-campaign) campaign: Gotschnagrat (2285 m above sea level - a.s.l.), as well as Laret (1522 m a.s.l.), and Davos Wolfang (1630 m a.s.l.). The applied instruments were owned and operated by ETH Zurich, EPFL and TROPOS.\r\n\r\nThe fall velocity and size of hydrometeors were measured with disdrometers (Parsivel, OTT HydroMet), that are laser based optical systems to measure all types of precipitation, e.g. drizzle, rain, snow, hail and hybrid forms of these classes. The disdrotemer data was continously recording liquid precipitation in a particle size range of 0.2 to 8 mm, solid precipitation in a particle size range of 0.2 to 25 mm, with particle fall velocities between 0.2 and 20 m s-1. Precipitation was dicriminated into 32 size classes and corresponded to 32 particle velocity classes.  \r\n\r\nThe precipitation measurements were accompanied by [snow measurements](https://www.envidat.ch/group/about/snow) at Gotschnagrat and in Davos Wolfgang.   Instruments to measure [aerosol concentrations](https://www.envidat.ch/group/about/aerosols-raclets), [meteorological parameters](https://www.envidat.ch/group/about/meteorology), [wind profiles/velocities](https://www.envidat.ch/group/about/remote-sensing-raclets), and the [CloudNet station](https://www.envidat.ch/group/about/remote-sensing-raclets) were also located in Davos Wolfgang. \r\n\r\n![image is missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Claudia/IMG_8893_Scale.JPG)\r\n\r\n![image is missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Claudia/IMG_8012_Scale.JPG)\r\n\r\nImages: Claudia Mignani\r\n",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-08-21-120313.061012RACLETSpreciplogo.png",
            "package_count": 2,
            "created": "2019-07-11T14:05:23.424465",
            "name": "precipitation",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "RACLETS Field Campaign",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "062ae3c4-e0f8-43e9-9ef8-e08ad5ea249c",
                    "group_id": "487c2713-7754-41b9-bf54-226c35c0a6ea",
                    "id": "029f3107-36d2-4bd9-968b-2c5b11148d1a"
                }
            ],
            "image_url": "2019-08-21-120313.061012RACLETSpreciplogo.png",
            "groups": [],
            "type": "group",
            "title": "Precipitation",
            "revision_id": "8f3c46c2-f692-4d59-91dd-523d4b2d85eb",
            "packages": [
                {
                    "owner_org": "59289253-6fa8-4fe9-a1a2-9d07cc39dcae",
                    "maintainer": "{\"affiliation\": \"Leibnitz Institute for Tropospheric Research (TROPOS)\", \"identifier\": \"\", \"given_name\": \"\", \"name\": \"Patric Seifert\", \"email\": \"seifert@tropos.de\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "9267d575-29d8-4a23-8a24-13df224b5ee5",
                    "metadata_created": "2019-10-09T10:39:41.058361",
                    "funding": "[{\"grant_number\": \"200021_175824\", \"institution\": \"SNF\", \"institution_url\": \"http://p3.snf.ch/project-175824\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2020-01-06T09:40:25.737369",
                    "author": "[{\"name\": \"Seifert\", \"data_credit\": [\"collection\", \"validation\", \"curation\"], \"affiliation\": \"Leibnitz Institute for Tropospheric Research (TROPOS)\", \"affiliation_03\": \"\", \"given_name\": \"Patric\", \"identifier\": \"\", \"email\": \"seifert@tropos.de\", \"affiliation_02\": \"\"}, {\"name\": \"Wieder\", \"data_credit\": \"collection\", \"affiliation\": \"IAC\", \"affiliation_03\": \"\", \"given_name\": \"Jörg\", \"identifier\": \"\", \"email\": \"joerg.wieder@env.ethz.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.853594,46.835577]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Disdrometer Data Davos Wolfgang",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-08\", \"date_type\": \"collected\", \"end_date\": \"2019-03-19\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "disdrometer-data-davos-wolfgang",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.117",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The dataset contains information on precipitation amount and type for Davos Wolfgang from February 8 to March 19 2019. It includes:\r\n\r\n- characteristics of hydrometeors (e.g. diameter, fall velocity, amount per diameter class,...)\r\n- precipitation rate\r\n- radar reflectivity\r\n- visibility range \r\n- weather codes \r\n- instrument performance ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "related_datasets": "",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The experimental and theoretical work of our research group is dedicated to the developement and application of measuring instruments for remote sensing of atmospheric processes. Our activities are aimed at the determination of optical and physical properties of aerosols and clouds as well as at the assesment of the general atmospheric state parameters (temperature, wind, moisture).\r\nThe working group has conducted more than 15 field experiments in key regions of climate research where it applies its techniques to understand the role of aerosols and clouds in the climate system. During RACLETS, the ground-based remote sensing working group participated with observations of the mobile Oceanet platform, which is usually deployed during cruises of the research vessel Polarstern. Oceanet carries a multiwavelength Raman polarization lidar and a microwave radiometer as well as standard meteorological sensors. During RACLETS, a 35-GHz cloud radar and a disdrometer were deployed in addition. This equipment was used to process synergies of the remote sensing observations via Cloudnet (http://cloudnet.fmi.fi).\r\n\r\nMore information on: https://www.tropos.de/en/institute/departments/remote-sensing-of-atmospheric-processes-new/ground-based-remote-sensing",
                        "created": "2019-07-05T06:24:50.849528",
                        "title": "Ground-based Remote Sensing",
                        "name": "ground-based-remote-sensing",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.envidat.ch/uploads/group/2019-07-05-041925.066827TROPOS-LogoENG.png",
                        "revision_id": "7421586d-a0f1-4436-84a3-aad05c6eecda",
                        "type": "organization",
                        "id": "59289253-6fa8-4fe9-a1a2-9d07cc39dcae",
                        "approval_status": "approved"
                    },
                    "revision_id": "ad9954af-3d65-4511-a80d-837ec26aa442",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "898d94a9-7a48-4fdc-9eda-43f536e39285",
                    "metadata_created": "2019-11-06T12:22:23.566981",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-18T15:41:40.079192",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch, \", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}, {\"name\": \"Josuè\", \"data_credit\": \"collection\", \"affiliation\": \"School of Architecture, Civil and Environmental Engineering, EPFL\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"Gehring\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "Walter B., H. Huwald, J. Gehring, Y. Bühler, and M. Lehning, Radar measurements of blowing snow off a mountain ridge, submitted",
                    "num_resources": 5,
                    "title": "Snow Drift Station - Micro Rain Radar",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-03-01\", \"date_type\": \"collected\", \"end_date\": \"2019-03-22\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-micro-rain-radar",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.113",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The instrument (MRR, Metek) was mounted at a height of 1 m above snow surface (at the beginning of the campaign) with an orientation of 22° with respect to North and a horizontal viewing direction. The sampling time was either 5 s or 10 s, depending on the settings at the specific period.  The MRR produces standard outputs like radar reflectivity, doppler velocity, etc., and additional information can be found [here](https://metek.de/de/product/mrr-2/).",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "4c7ab74c-9a81-4793-835a-d8f27b1ed5d6",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "487c2713-7754-41b9-bf54-226c35c0a6ea",
            "approval_status": "approved"
        },
        {
            "display_name": "RACLETS Field Campaign",
            "description": "### Campaign Overview\r\n\r\nThe __RACLETS__ - _Role of Aerosols and CLouds Enhanced by Topography on Snow_ - campaign uniquely combines cloud and snow research to improve the understanding of precipitation formation in clouds and snow deposition on the ground.  \r\n\r\n\r\nDuring the RACLETS campaign in February and March 2019, an extensive set of instruments was deployed in the Davos regions including aerosol, cloud, precipitation and snow measurements. In a unique cooperation between cloud and snow research groups, this study aimed to observe the complete life cycle of ice crystals:\r\n\r\n- Cloud droplet formation and ice nucleation on aerosol particles\r\n- Growth of cloud droplets and ice crystals to precipitation\r\n- Ice crystal enhancement by ice multiplication\r\n- Precipitation location and amount on the ground\r\n- Redistribution of snow on the ground\r\n\r\n\r\nThe measurements were contextualized by using regional numerical weather models for the atmosphere and high-resolution models for snow deposition.\r\n\r\nTo cover the spatial differences of the topography, instruments were deployed at five different locations and on a cable car. The main measurement site was located in __Davos Wolfang__, 1630 m above sea level (a.s.l.). Here, [clouds](https://www.envidat.ch/group/about/clouds-in-situ-raclets) were probed in-situ by a tethered balloon system (HoloBalloon), [radiosondes](https://www.envidat.ch/group/about/meteorology) were launched, [precipitation](https://www.envidat.ch/group/about/precipitation) was measured (disdrometer), [remote sensing instruments](https://www.envidat.ch/group/about/remote-sensing-raclets) were deployed (OceaNet station, Wind Profiler and Wind LIDAR) and [aerosol and INP measurements](https://www.envidat.ch/group/about/aerosols-raclets) were carried out to study the atmosphere. The mountain ridge __Gotschna__ separates Davos Wolfgang in the south from Klosters in the north. In __Klosters__ (1170 m a.s.l.), a [ceilometer](https://www.envidat.ch/group/about/remote-sensing-raclets) was applied to measure the cloud base. On a cable car, running on the north side of the ridge towards __Gotschnagrat__ (2285 m a.s.l.), HoloGondel was attached, which took in-situ images of ice crystals and droplets in [clouds](https://www.envidat.ch/group/about/clouds-in-situ-raclets). A [snow drift station](https://www.envidat.ch/group/about/snow) and a [disdrometer](https://www.envidat.ch/group/about/precipitation) were located at __Gotschnagrat__. At the mountain site __Weissfluhjoch__ (2700 m a.s.l.), south of __Gotschna__, [Aerosols, INPs, CCNs](https://www.envidat.ch/group/about/aerosols-raclets) were measured in addition to analysing [snowflakes](https://www.envidat.ch/group/about/snow) and performing [snow measurements](https://www.envidat.ch/group/about/snow). [Snow](https://www.envidat.ch/group/about/snow) and [precipitation](https://www.envidat.ch/group/about/precipitation) measurements were performed in __Laret__, which is located in the valley at an elevation of 1522 m a.s.l. and in a distance of about 1 km north of Davos Wolfgang.\r\n\r\n\r\n\r\n![An image is missing, e.g. picture Gotschnagrat, cablecar, Weissfluhjoch, etc.](https://iacweb.ethz.ch/data/holimo/images/RACLETS-OverviewMap_Scale.png) \r\n\r\n\r\n### Data Files\r\nThe data recorded during the campaign can be accessed via the following subprojects (as link): \r\n\r\n- [_Aerosols_](https://www.envidat.ch/group/aerosols-raclets)\r\n- [_Clouds in-situ_](https://www.envidat.ch/group/clouds-in-situ-raclets)\r\n- [_Meteorology_](https://www.envidat.ch/group/meteorology) \r\n- [_Modelling_](https://www.envidat.ch/group/modeling) \r\n- [_Precipitation_](https://www.envidat.ch/group/precipitation) \r\n- [_Remote Sensing_](https://www.envidat.ch/group/remote-sensing-raclets)\r\n- [_Snow_](https://www.envidat.ch/group/snow) \r\n\r\n  \r\n### __Project Partners__\r\nMore information about participating insitutes can be found here: \r\n\r\n- https://duw.unibas.ch/de/home/\r\n- https://www.epfl.ch/en/home/\r\n- http://www.iac.ethz.ch/group/atmospheric-physics.html\r\n- https://www.meteoswiss.admin.ch/home.html?tab=overview\r\n- https://www.slf.ch/\r\n- https://www.tropos.de/institut/ueber-uns/das-institut/\r\n- https://www.wsl.ch/de/schnee-und-eis.html  \r\n\r\n",
            "image_display_url": "https://iacweb.ethz.ch/data/holimo/images/RACLETS_logo.jpg",
            "package_count": 11,
            "created": "2019-04-16T12:38:10.473219",
            "name": "raclets-field-campaign",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "Aerosols, Clouds in-situ, Meteorology, Modelling, Precipitation, Remote Sensing, Snow",
                    "state": "active",
                    "key": "subprojects",
                    "revision_id": "86e546b9-0866-4321-b1c2-77bae51c6bbe",
                    "group_id": "ab759699-d40a-44c9-995f-c0e5aad1c2b5",
                    "id": "69f1a454-3679-43a3-9b65-bdf93254b235"
                }
            ],
            "image_url": "https://iacweb.ethz.ch/data/holimo/images/RACLETS_logo.jpg",
            "groups": [],
            "type": "group",
            "title": "RACLETS Field Campaign",
            "revision_id": "3a599fc6-6bad-4616-aeee-f2b5766d04fa",
            "packages": [
                {
                    "owner_org": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                    "maintainer": "{\"affiliation\": \"MeteoSwiss\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"identifier\": \"\", \"given_name\": \"Maxime\", \"name\": \"Hervo\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "f14e4d77-4be6-4123-a525-e0e50e0d89a1",
                    "metadata_created": "2019-04-17T13:29:14.148924",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"MeteoSwiss\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2020-01-20T14:45:12.092659",
                    "author": "[{\"name\": \"Hervo\", \"data_credit\": \"collection\", \"affiliation\": \"MeteoSwiss\", \"affiliation_03\": \"\", \"given_name\": \"Maxime\", \"identifier\": \"\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.880413,46.869019]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Weather Station Klosters",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-01\", \"date_type\": \"collected\", \"end_date\": \"2019-03-29\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "weather_station_klosters",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.129",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A weather station (Lufft WS600) measured meteorological parameters at Klosters. ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "related_datasets": "",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "MeteoSwiss is the Federal Office for Meteorology and Climatology. We operate the national surface and radar measurement network and collect, manage and analyse weather and climate data. We produce forecasts, inform, warn and advise, and are engaged in researching and developing tailor-made products and services. \r\n\r\nThe Atmospheric Measurement and Data division is specialized in upper air measurements.\r\n\r\nMore information on: https://www.meteosuisse.admin.ch/home.html",
                        "created": "2020-01-16T12:55:40.341488",
                        "title": "Atmospheric Measurement and Data Division",
                        "name": "atmospheric-measurement-and-data-division",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2020-01-16-115540.320888meteoschweiz.png",
                        "revision_id": "373f17a9-bec5-4428-b309-745fddfcb74e",
                        "type": "organization",
                        "id": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                        "approval_status": "approved"
                    },
                    "revision_id": "1cea4c40-ed66-4aa5-8212-1e2a636d4c36",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                    "maintainer": "{\"affiliation\": \"MeteoSwiss\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"identifier\": \"\", \"given_name\": \"Maxime\", \"name\": \"Hervo\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "45bb3cf1-2ab7-4757-92b2-b5f8fc09bfe9",
                    "metadata_created": "2020-01-17T14:40:37.491060",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"MeteoSwiss\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2020\"}",
                    "metadata_modified": "2020-01-20T10:59:35.125708",
                    "author": "[{\"name\": \"Hervo\", \"data_credit\": \"collection\", \"affiliation\": \"MeteoSwiss\", \"affiliation_03\": \"\", \"given_name\": \"Maxime\", \"identifier\": \"\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.880413, 46.869019]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Present Weather Sensor Klosters",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-06\", \"date_type\": \"collected\", \"end_date\": \"2019-03-31\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "present-weather-sensor-klosters",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.128",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A present weather sensor (Vaisala PWD22) was deployed in Klosters for weather observation, combining the functions of  a forwardscatter visibility meter and a present weather sensor. Besides measuring ambient light, it detects the intensity as well as the amount of both liquid and solid precipitation. More information can be found in the [User's Manual](ftp://ftp.cmdl.noaa.gov/aerosol/doc/manuals/PWD22_Manual.pdf).",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "related_datasets": "",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "MeteoSwiss is the Federal Office for Meteorology and Climatology. We operate the national surface and radar measurement network and collect, manage and analyse weather and climate data. We produce forecasts, inform, warn and advise, and are engaged in researching and developing tailor-made products and services. \r\n\r\nThe Atmospheric Measurement and Data division is specialized in upper air measurements.\r\n\r\nMore information on: https://www.meteosuisse.admin.ch/home.html",
                        "created": "2020-01-16T12:55:40.341488",
                        "title": "Atmospheric Measurement and Data Division",
                        "name": "atmospheric-measurement-and-data-division",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2020-01-16-115540.320888meteoschweiz.png",
                        "revision_id": "373f17a9-bec5-4428-b309-745fddfcb74e",
                        "type": "organization",
                        "id": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                        "approval_status": "approved"
                    },
                    "revision_id": "e95ffab3-4464-463a-b8aa-8413d496a47f",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                    "maintainer": "{\"affiliation\": \"MeteoSwiss\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"identifier\": \"\", \"given_name\": \"Maxime\", \"name\": \"Hervo\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "b938e2eb-20fc-4886-8329-9c8f20b0336b",
                    "metadata_created": "2020-01-14T12:33:17.785064",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"MeteoSwiss\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2020\"}",
                    "metadata_modified": "2020-01-20T10:59:21.141226",
                    "author": "[{\"name\": \"Hervo\", \"affiliation\": \"MeteoSwiss\", \"affiliation_03\": \"\", \"given_name\": \"Maxime\", \"identifier\": \"\", \"email\": \"maxime.hervo@meteoswiss.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\", \"coordinates\": [9.880413, 46.869019]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Ceilometer Klosters",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-06\", \"date_type\": \"collected\", \"end_date\": \"2019-03-31\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "ceilometer-klosters",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.127",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Cloud base height (m) and vertical visibility (m) are measured with the VAISALA Ceilometer CL31, an instrument with constant reliability for all weather conditions and simultaneous detection of three cloud layers in heights up to 7.6 km. ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "related_datasets": "",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "MeteoSwiss is the Federal Office for Meteorology and Climatology. We operate the national surface and radar measurement network and collect, manage and analyse weather and climate data. We produce forecasts, inform, warn and advise, and are engaged in researching and developing tailor-made products and services. \r\n\r\nThe Atmospheric Measurement and Data division is specialized in upper air measurements.\r\n\r\nMore information on: https://www.meteosuisse.admin.ch/home.html",
                        "created": "2020-01-16T12:55:40.341488",
                        "title": "Atmospheric Measurement and Data Division",
                        "name": "atmospheric-measurement-and-data-division",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2020-01-16-115540.320888meteoschweiz.png",
                        "revision_id": "373f17a9-bec5-4428-b309-745fddfcb74e",
                        "type": "organization",
                        "id": "b1e29434-1f21-4eb6-bfa9-1ecfe1d59fc7",
                        "approval_status": "approved"
                    },
                    "revision_id": "e43a8701-80bc-42da-a405-ddc516a873e0",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "59289253-6fa8-4fe9-a1a2-9d07cc39dcae",
                    "maintainer": "{\"affiliation\": \"Leibnitz Institute for Tropospheric Research (TROPOS)\", \"identifier\": \"\", \"given_name\": \"\", \"name\": \"Patric Seifert\", \"email\": \"seifert@tropos.de\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "9267d575-29d8-4a23-8a24-13df224b5ee5",
                    "metadata_created": "2019-10-09T10:39:41.058361",
                    "funding": "[{\"grant_number\": \"200021_175824\", \"institution\": \"SNF\", \"institution_url\": \"http://p3.snf.ch/project-175824\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2020-01-06T09:40:25.737369",
                    "author": "[{\"name\": \"Seifert\", \"data_credit\": [\"collection\", \"validation\", \"curation\"], \"affiliation\": \"Leibnitz Institute for Tropospheric Research (TROPOS)\", \"affiliation_03\": \"\", \"given_name\": \"Patric\", \"identifier\": \"\", \"email\": \"seifert@tropos.de\", \"affiliation_02\": \"\"}, {\"name\": \"Wieder\", \"data_credit\": \"collection\", \"affiliation\": \"IAC\", \"affiliation_03\": \"\", \"given_name\": \"Jörg\", \"identifier\": \"\", \"email\": \"joerg.wieder@env.ethz.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.853594,46.835577]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Disdrometer Data Davos Wolfgang",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-08\", \"date_type\": \"collected\", \"end_date\": \"2019-03-19\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "disdrometer-data-davos-wolfgang",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.117",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The dataset contains information on precipitation amount and type for Davos Wolfgang from February 8 to March 19 2019. It includes:\r\n\r\n- characteristics of hydrometeors (e.g. diameter, fall velocity, amount per diameter class,...)\r\n- precipitation rate\r\n- radar reflectivity\r\n- visibility range \r\n- weather codes \r\n- instrument performance ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "related_datasets": "",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The experimental and theoretical work of our research group is dedicated to the developement and application of measuring instruments for remote sensing of atmospheric processes. Our activities are aimed at the determination of optical and physical properties of aerosols and clouds as well as at the assesment of the general atmospheric state parameters (temperature, wind, moisture).\r\nThe working group has conducted more than 15 field experiments in key regions of climate research where it applies its techniques to understand the role of aerosols and clouds in the climate system. During RACLETS, the ground-based remote sensing working group participated with observations of the mobile Oceanet platform, which is usually deployed during cruises of the research vessel Polarstern. Oceanet carries a multiwavelength Raman polarization lidar and a microwave radiometer as well as standard meteorological sensors. During RACLETS, a 35-GHz cloud radar and a disdrometer were deployed in addition. This equipment was used to process synergies of the remote sensing observations via Cloudnet (http://cloudnet.fmi.fi).\r\n\r\nMore information on: https://www.tropos.de/en/institute/departments/remote-sensing-of-atmospheric-processes-new/ground-based-remote-sensing",
                        "created": "2019-07-05T06:24:50.849528",
                        "title": "Ground-based Remote Sensing",
                        "name": "ground-based-remote-sensing",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.envidat.ch/uploads/group/2019-07-05-041925.066827TROPOS-LogoENG.png",
                        "revision_id": "7421586d-a0f1-4436-84a3-aad05c6eecda",
                        "type": "organization",
                        "id": "59289253-6fa8-4fe9-a1a2-9d07cc39dcae",
                        "approval_status": "approved"
                    },
                    "revision_id": "ad9954af-3d65-4511-a80d-837ec26aa442",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "677814d4-baab-47c2-ba03-8f34882de3cc",
                    "maintainer": "{\"affiliation\": \"ETH Zürich\", \"identifier\": \"\", \"given_name\": \"\", \"name\": \"Jörg Wieder\", \"email\": \"joerg.wieder@env.ethz.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 8,
                    "subtitle": "",
                    "id": "f6c38c8c-ab20-43a6-ae37-82117733df96",
                    "metadata_created": "2019-10-15T12:10:50.529170",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"SNF\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-22T08:06:40.353928",
                    "author": "[{\"name\": \"Jörg Wieder\", \"data_credit\": \"collection\", \"affiliation\": \"ETH Zürich\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"joerg.wieder@env.ethz.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Carolin Rösch\", \"data_credit\": \"curation\", \"affiliation\": \"ETH Zürich\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"carolin.roesch@env.ethz.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.853594,46.835577]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "Radiosondes",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-10\", \"date_type\": \"collected\", \"end_date\": \"2019-03-26\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "radiosondes",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.121",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Radiosondes (Windsond, Sparv Embedded AB) were started in Davos Wolfgang to report height profiles of pressure, relative humidity and temperature at specific days. In addition to regular launches of radiosondes, sondes were attached to [HoloBalloon](https://www.envidat.ch/group/clouds-in-situ-raclets) to report the ambient conditions of the in-situ measurements. Further profiles of meteorological measures were recorded at [HoloGondel](https://www.envidat.ch/group/clouds-in-situ-raclets) which was installed at the gondola moving between Gotschnaboden and Gotschnagrat at 2285 m a.s.l.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The Institute for Atmospheric and Climate Science (IAC) is part of the Department of Environmental Systems Science (D-USYS) of the Swiss Federal Institute of Technology Zurich (ETH Zurich). The IAC focuses on atmospheric and climate processes, including links to the hydrosphere, cryosphere, and biosphere. Research is directed at understanding how human activities alter these processes via changes in greenhouse gases, aerosols, chemical constituents, and land surfaces and how this impacts upon climate, ozone, UV radiation, pollutant exposure, ecosystems, water resources and extreme events. Emphasisis placed on the improvement of the predictive capabilities on weather and climate time scales and on knowledge transfer between basic sciences, applied sciences, and society. ",
                        "created": "2019-04-16T12:35:23.279710",
                        "title": "IAC",
                        "name": "iac",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-04-16-114039.307713image.imageformat.lightbox.404647511.jpg",
                        "revision_id": "b2837ec2-da4d-4eaf-a932-3dbbc72ea96f",
                        "type": "organization",
                        "id": "677814d4-baab-47c2-ba03-8f34882de3cc",
                        "approval_status": "approved"
                    },
                    "revision_id": "4a61747f-5195-498a-9214-ed4ac8edea82",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "677814d4-baab-47c2-ba03-8f34882de3cc",
                    "maintainer": "{\"affiliation\": \"ETH\", \"email\": \"michael.sprenger@env.ethz.ch\", \"identifier\": \"\", \"given_name\": \"Michael\", \"name\": \"Sprenger\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "dcbfd36f-3b67-49c1-be77-0f5b75810fab",
                    "metadata_created": "2019-11-14T07:40:56.031574",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"ETH \", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-22T08:05:39.494227",
                    "author": "[{\"name\": \"Sprenger\", \"affiliation\": \"ETH\", \"affiliation_03\": \"\", \"given_name\": \"Michael\", \"identifier\": \"\", \"email\": \"michael.sprenger@env.ethz.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.853594,46.835577]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "Backward  Trajectories",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-02\", \"date_type\": \"collected\", \"end_date\": \"2019-03-27\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "raclets-backward-trajectories",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.120",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Backward trajectories were calculated from two positions: Davos Wolfgang (9.85361 E 46.83551 N) and Weissfluhjoch (9.80646 E 46.83304 N) for the time period February 2 until March 27 2019 using COSMO or ECMWF, respectively.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The Institute for Atmospheric and Climate Science (IAC) is part of the Department of Environmental Systems Science (D-USYS) of the Swiss Federal Institute of Technology Zurich (ETH Zurich). The IAC focuses on atmospheric and climate processes, including links to the hydrosphere, cryosphere, and biosphere. Research is directed at understanding how human activities alter these processes via changes in greenhouse gases, aerosols, chemical constituents, and land surfaces and how this impacts upon climate, ozone, UV radiation, pollutant exposure, ecosystems, water resources and extreme events. Emphasisis placed on the improvement of the predictive capabilities on weather and climate time scales and on knowledge transfer between basic sciences, applied sciences, and society. ",
                        "created": "2019-04-16T12:35:23.279710",
                        "title": "IAC",
                        "name": "iac",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-04-16-114039.307713image.imageformat.lightbox.404647511.jpg",
                        "revision_id": "b2837ec2-da4d-4eaf-a932-3dbbc72ea96f",
                        "type": "organization",
                        "id": "677814d4-baab-47c2-ba03-8f34882de3cc",
                        "approval_status": "approved"
                    },
                    "revision_id": "7aa98954-2084-4a10-943b-1842c8de7a11",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "898d94a9-7a48-4fdc-9eda-43f536e39285",
                    "metadata_created": "2019-11-06T12:22:23.566981",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-18T15:41:40.079192",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch, \", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}, {\"name\": \"Josuè\", \"data_credit\": \"collection\", \"affiliation\": \"School of Architecture, Civil and Environmental Engineering, EPFL\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"Gehring\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "Walter B., H. Huwald, J. Gehring, Y. Bühler, and M. Lehning, Radar measurements of blowing snow off a mountain ridge, submitted",
                    "num_resources": 5,
                    "title": "Snow Drift Station - Micro Rain Radar",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-03-01\", \"date_type\": \"collected\", \"end_date\": \"2019-03-22\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-micro-rain-radar",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.113",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The instrument (MRR, Metek) was mounted at a height of 1 m above snow surface (at the beginning of the campaign) with an orientation of 22° with respect to North and a horizontal viewing direction. The sampling time was either 5 s or 10 s, depending on the settings at the specific period.  The MRR produces standard outputs like radar reflectivity, doppler velocity, etc., and additional information can be found [here](https://metek.de/de/product/mrr-2/).",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "4c7ab74c-9a81-4793-835a-d8f27b1ed5d6",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "59289253-6fa8-4fe9-a1a2-9d07cc39dcae",
                    "maintainer": "{\"affiliation\": \"TROPOS \", \"email\": \"seifert@tropos.de\", \"identifier\": \"\", \"given_name\": \"Patric\", \"name\": \"Seifert\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "e3bf11a1-7a77-44ac-ba5a-b6e96502894f",
                    "metadata_created": "2019-11-11T15:17:07.984566",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"TROPOS\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:16:32.604619",
                    "author": "[{\"name\": \"Seifert\", \"data_credit\": \"collection\", \"affiliation\": \"TROPOS \", \"affiliation_03\": \"\", \"given_name\": \"Patric\", \"identifier\": \"\", \"email\": \"seifert@tropos.de\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.853594,46.835577]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "LIDAR Davos Wolfgang",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-07\", \"date_type\": \"collected\", \"end_date\": \"2019-03-19\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lidar-davos-wolfgang",
                    "publication_state": "",
                    "doi": "",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A portable Raman lidar system (Polly) from Leibnitz Institute for Tropospheric Research (Tropos) was deployed at Davos Wolfgang. Please use this [link](http://polly.tropos.de/?p=lidarzeit&Ort=39), to be directly forwarded to the Davos location and select the date of interest from the calendar (bold numbers). The data can be requested directly at the Polly team.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The experimental and theoretical work of our research group is dedicated to the developement and application of measuring instruments for remote sensing of atmospheric processes. Our activities are aimed at the determination of optical and physical properties of aerosols and clouds as well as at the assesment of the general atmospheric state parameters (temperature, wind, moisture).\r\nThe working group has conducted more than 15 field experiments in key regions of climate research where it applies its techniques to understand the role of aerosols and clouds in the climate system. During RACLETS, the ground-based remote sensing working group participated with observations of the mobile Oceanet platform, which is usually deployed during cruises of the research vessel Polarstern. Oceanet carries a multiwavelength Raman polarization lidar and a microwave radiometer as well as standard meteorological sensors. During RACLETS, a 35-GHz cloud radar and a disdrometer were deployed in addition. This equipment was used to process synergies of the remote sensing observations via Cloudnet (http://cloudnet.fmi.fi).\r\n\r\nMore information on: https://www.tropos.de/en/institute/departments/remote-sensing-of-atmospheric-processes-new/ground-based-remote-sensing",
                        "created": "2019-07-05T06:24:50.849528",
                        "title": "Ground-based Remote Sensing",
                        "name": "ground-based-remote-sensing",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.envidat.ch/uploads/group/2019-07-05-041925.066827TROPOS-LogoENG.png",
                        "revision_id": "7421586d-a0f1-4436-84a3-aad05c6eecda",
                        "type": "organization",
                        "id": "59289253-6fa8-4fe9-a1a2-9d07cc39dcae",
                        "approval_status": "approved"
                    },
                    "revision_id": "74f0fe0c-4049-432e-9353-8ba850f66250",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "dad6d388-e76d-4f27-8b1e-0028aa9f3d23",
                    "metadata_created": "2019-11-05T12:26:59.787411",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:16:10.432240",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch\", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 6,
                    "title": "Snow Drift Station - Flowcapt",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-10\", \"date_type\": \"collected\", \"end_date\": \"2019-03-21\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-flowcapt",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.115",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The FlowCapt is an ultra-robust instrument measuring solid particle acoustic mass - flux intensities [g m&#8254; &#178; s&#8254; &#185;] and wind speeds [m s&#8254; &#185;]. The vertical tube with a length of 1 m monitors snowdrift and snow-blowing; and is mounted at a height between 0.1 an 1.1 m above snow surface. The time within each data set is given in UTC+1. ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "23dff180-04af-4239-af76-386d2d99573d",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "efa1aa57-2aef-41de-8d36-d5847445a2dc",
                    "metadata_created": "2019-11-05T14:30:30.346894",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:15:42.200034",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch\", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "Walter B., H. Huwald, J. Gehring, Y. Bühler, and M. Lehning, Radar measurements of blowing snow off a mountain ridge, submitted",
                    "num_resources": 5,
                    "title": "Snow Drift Station - 3D Ultrasonic",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-11\", \"date_type\": \"collected\", \"end_date\": \"2019-03-21\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-3d-ultrasonic",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.116",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A Young 81000 sonic anemomenter was deployed to record three components of the wind velocity (u, v, w in [m s&#8254; &#185;]) and air temperature (Ts in [°C]). The anemomenter was mounted in direction North at a height of 1.5 m above snow surface at the beginning. The time within each data set is given in UTC+1. Instrument specifications can be found [here](http://www.youngusa.com/Manuals/81000-90(I).pdf) . ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "b3210d87-d153-4221-a105-ef8311e71d91",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "c589c4cf-9f53-4d76-b1df-bae465ddda1f",
                    "metadata_created": "2019-11-05T15:25:56.707970",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:15:17.434323",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch\", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 4,
                    "title": "Snow Drift Station - Snow and Air Data",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2020-02-11\", \"date_type\": \"collected\", \"end_date\": \"2019-03-21\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-snow-and-air-data",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.114",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Snow and air data was monitored by an infrarot radiometer (Campbell SI-111) for snow temperature (°C), a snow height sensor (Lufft SHM-31) for snow height change (cm) and a temperature and humidity sensor (Campbell CS-215) for air temperature (°C) and relative humidity (%). No filter was applied to the sensors and the smapling frequency was 1 Hz.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "68867fb0-214c-40cc-894f-78b9115c2caf",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "ab759699-d40a-44c9-995f-c0e5aad1c2b5",
            "approval_status": "approved"
        },
        {
            "display_name": "Remote Sensing",
            "description": "Remote sensing instruments providing information on aerosols, radiation, and clouds were deployed in Davos Wolfgang, 1630 m above sea level (a.s.l), and Kloster, 1150 m a.s.l for the duration of the [RACLETS](https://www.envidat.ch/group/about/raclets-field-campaign) campaign. The instruments were owned and supervised by ETH Zürich, Meteoswiss, and TROPOS Leipzig. \r\n\r\nAt Davos Wolfgang, a CloudNet station combined a Raman Lidar (Polly-XT), a Doppler Cloud Radar (Mira-36, METEK GmbH) and a Microwave Radiometer (RPG-HATPRO, Radiometer Physics GmbH) to measure aerosol and cloud properties. In addition, a Doppler Lidar (Windcube 100S, Leosphere) and a Radar Wind Profiler were deployed to get information on wind properties like direction (°), speed (m s-1) and vertical profile (up to 5000 m above ground). The tethered balloon system carrying a holographic imager, named [HoloBalloon](https://www.envidat.ch/group/about/clouds-in-situ-raclets) to measure cloud microphysics, was launched close to the CloudNet station. \r\nA Ceilometer (CL31, Vaisala), which was deployed in Kloster, reported the cloud base height (m a.s.l.) and vertical visibility (m).\r\nQuicklooks of the measurements and more information on the instruments can be found here: http://data.iac.ethz.ch/holodavos2019/\r\n\r\n![imahge is missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Annika/DSC_4599_Scale.jpg)\r\n\r\n![image is missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Jan/IMG_20190210_201419_Scale.jpg)\r\n\r\n![image is missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Jan/IMG_20190209_103309_Scale.jpg)\r\n\r\nImages: Jan Hennerbger, Annika Lauber\r\n",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-08-21-120138.007368RACLETSremotelogo.png",
            "package_count": 2,
            "created": "2019-07-11T14:05:54.911019",
            "name": "remote-sensing-raclets",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "RACLETS Field Campaign",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "b088efe3-ec86-4e55-9725-9cb2628b7850",
                    "group_id": "6c2fd969-d2ef-4e5a-939b-1a6e42c7bbe7",
                    "id": "5fc77534-556d-4069-9266-a43b12f8d7fe"
                }
            ],
            "image_url": "2019-08-21-120138.007368RACLETSremotelogo.png",
            "groups": [],
            "type": "group",
            "title": "Remote Sensing",
            "revision_id": "47feca2e-c48f-45e9-a7ff-5fcd08d11946",
            "packages": [
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "898d94a9-7a48-4fdc-9eda-43f536e39285",
                    "metadata_created": "2019-11-06T12:22:23.566981",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-18T15:41:40.079192",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch, \", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}, {\"name\": \"Josuè\", \"data_credit\": \"collection\", \"affiliation\": \"School of Architecture, Civil and Environmental Engineering, EPFL\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"Gehring\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "Walter B., H. Huwald, J. Gehring, Y. Bühler, and M. Lehning, Radar measurements of blowing snow off a mountain ridge, submitted",
                    "num_resources": 5,
                    "title": "Snow Drift Station - Micro Rain Radar",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-03-01\", \"date_type\": \"collected\", \"end_date\": \"2019-03-22\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-micro-rain-radar",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.113",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The instrument (MRR, Metek) was mounted at a height of 1 m above snow surface (at the beginning of the campaign) with an orientation of 22° with respect to North and a horizontal viewing direction. The sampling time was either 5 s or 10 s, depending on the settings at the specific period.  The MRR produces standard outputs like radar reflectivity, doppler velocity, etc., and additional information can be found [here](https://metek.de/de/product/mrr-2/).",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "4c7ab74c-9a81-4793-835a-d8f27b1ed5d6",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "59289253-6fa8-4fe9-a1a2-9d07cc39dcae",
                    "maintainer": "{\"affiliation\": \"TROPOS \", \"email\": \"seifert@tropos.de\", \"identifier\": \"\", \"given_name\": \"Patric\", \"name\": \"Seifert\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "e3bf11a1-7a77-44ac-ba5a-b6e96502894f",
                    "metadata_created": "2019-11-11T15:17:07.984566",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"TROPOS\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:16:32.604619",
                    "author": "[{\"name\": \"Seifert\", \"data_credit\": \"collection\", \"affiliation\": \"TROPOS \", \"affiliation_03\": \"\", \"given_name\": \"Patric\", \"identifier\": \"\", \"email\": \"seifert@tropos.de\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.853594,46.835577]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "LIDAR Davos Wolfgang",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-07\", \"date_type\": \"collected\", \"end_date\": \"2019-03-19\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lidar-davos-wolfgang",
                    "publication_state": "",
                    "doi": "",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A portable Raman lidar system (Polly) from Leibnitz Institute for Tropospheric Research (Tropos) was deployed at Davos Wolfgang. Please use this [link](http://polly.tropos.de/?p=lidarzeit&Ort=39), to be directly forwarded to the Davos location and select the date of interest from the calendar (bold numbers). The data can be requested directly at the Polly team.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The experimental and theoretical work of our research group is dedicated to the developement and application of measuring instruments for remote sensing of atmospheric processes. Our activities are aimed at the determination of optical and physical properties of aerosols and clouds as well as at the assesment of the general atmospheric state parameters (temperature, wind, moisture).\r\nThe working group has conducted more than 15 field experiments in key regions of climate research where it applies its techniques to understand the role of aerosols and clouds in the climate system. During RACLETS, the ground-based remote sensing working group participated with observations of the mobile Oceanet platform, which is usually deployed during cruises of the research vessel Polarstern. Oceanet carries a multiwavelength Raman polarization lidar and a microwave radiometer as well as standard meteorological sensors. During RACLETS, a 35-GHz cloud radar and a disdrometer were deployed in addition. This equipment was used to process synergies of the remote sensing observations via Cloudnet (http://cloudnet.fmi.fi).\r\n\r\nMore information on: https://www.tropos.de/en/institute/departments/remote-sensing-of-atmospheric-processes-new/ground-based-remote-sensing",
                        "created": "2019-07-05T06:24:50.849528",
                        "title": "Ground-based Remote Sensing",
                        "name": "ground-based-remote-sensing",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.envidat.ch/uploads/group/2019-07-05-041925.066827TROPOS-LogoENG.png",
                        "revision_id": "7421586d-a0f1-4436-84a3-aad05c6eecda",
                        "type": "organization",
                        "id": "59289253-6fa8-4fe9-a1a2-9d07cc39dcae",
                        "approval_status": "approved"
                    },
                    "revision_id": "74f0fe0c-4049-432e-9353-8ba850f66250",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "6c2fd969-d2ef-4e5a-939b-1a6e42c7bbe7",
            "approval_status": "approved"
        },
        {
            "display_name": "Remote-sensing module (WBS)",
            "description": "Comparing aerial images, taken at different time periods, is a quick and cost-effective way to quickly detect landscape changes. This allows monitoring all sites of national importance on a regular basis. During the first phase of the project (2012 to 2017), the state of the habitats at the times the inventories were compiled (1980s and 1990s) has been compared. The interpretation is done manually on a 3D screen. The images from the 1980s and 1990s are in black and white, whereas the contemporary images are false color infrared stereo images.\r\nTo ensure reproducibility of the interpretation and location of changes within the sites, a grid of 50m x 50 m cells was placed over each site. Within each grid cell, simple indicators such as changes in tree and shrub cover or infrastructures such as roads and buildings are recorded using an ordinal scale with 11 classes (1 ≙ <0%, 2 ≙ 1–10%, 3 ≙ 11–20%, 4 ≙ 21–30%, 5 ≙ 31–40%, 6 ≙ 41–50%, 7 ≙ 51–60%, 8 ≙ 61–70%, 9 ≙ 71–80%, 10 ≙ 81–90%, 11 ≙ 91–100% cover). This allows a quick interpretation of changes, e.g., abandonment (by shrub encroachment). The centers of the grid cells correspond to the interpreted points of the Swiss Land-Use and Land-Cover Statistics and the Swiss National Forest Inventory (NFI). \r\nBased on these data, an online color-coded warning system has been established to ensure early detection of negative changes and to conduct prompt conservation measures. This tool can be assessed by the responsible federal and cantonal conservation authorities.\r\nThe very laborious field surveys are conducted in a subsample of all sites. Vegetation changes in fens, bogs, dry grasslands, riparian areas and flood plains are interpreted using diversity and compositional measures. The regular sampling of amphibian species and their population-size classes reflect temporal changes in amphibian breeding sites.\r\nIn addition, remote-sensing methods are developed to automatically calculate as many features as possible that are important for the quality of habitats of national importance. One example is shrub encroachment, which is calculated from the canopy height models obtained from the 3D aerial image data.\r\n",
            "image_display_url": "https://biotopschutz.wsl.ch/fileadmin//user_upload/WSL/Microsite/Wirkungskontrolle-Biotopschutz-Schweiz/stereo.jpg",
            "package_count": 0,
            "created": "2019-09-02T15:44:33.164468",
            "name": "wbs-remote-sensing-module",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "Monitoring the Effectiveness of Habitat Conservation in Switzerland (WBS)",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "dfaa5dff-7fed-44a6-acc3-31060340d6b0",
                    "group_id": "dcce3fd2-4144-474a-bfd2-e831f6459f4f",
                    "id": "b836bf56-baed-414f-b589-fd3cc254ecf4"
                }
            ],
            "image_url": "https://biotopschutz.wsl.ch/fileadmin//user_upload/WSL/Microsite/Wirkungskontrolle-Biotopschutz-Schweiz/stereo.jpg",
            "groups": [],
            "type": "group",
            "title": "Remote-sensing module (WBS)",
            "revision_id": "d7482ed2-f2e2-47d5-886c-c6848a2dfdde",
            "packages": [],
            "num_followers": 0,
            "id": "dcce3fd2-4144-474a-bfd2-e831f6459f4f",
            "approval_status": "approved"
        },
        {
            "display_name": "SCCER BIOSWEET",
            "description": "The SCCER BIOSWEET aims at providing solutions to problems arising from the energy transition. In order to do so, the best partners along the innovation chain are involved and the potentially most effective ideas along the whole technology readiness level scale are promoted. Another crucial investment of the SCCER BIOSWEETT is the development of capacity at higher education institutions.\r\n\r\nMore Information: http://www.sccer-biosweet.ch/",
            "image_display_url": "https://pbs.twimg.com/profile_images/727404702753771520/QXt6zs8d_400x400.jpg",
            "package_count": 1,
            "created": "2017-04-25T15:05:56.939735",
            "name": "sccer-biosweet",
            "is_organization": false,
            "state": "active",
            "extras": [],
            "image_url": "https://pbs.twimg.com/profile_images/727404702753771520/QXt6zs8d_400x400.jpg",
            "groups": [],
            "type": "group",
            "title": "SCCER BIOSWEET",
            "revision_id": "743a55af-233d-41cf-855e-5dc21e42f8a4",
            "packages": [
                {
                    "owner_org": "f2be36b2-6e95-42f1-af29-19f56a8f306d",
                    "maintainer": "{\"affiliation\": \"WSL\", \"email\": \"vanessa.burg@wsl.ch\", \"identifier\": \"\", \"given_name\": \"Vanessa\", \"name\": \"Burg\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "21599a72-b714-4d11-a748-644d0016fae9",
                    "metadata_created": "2017-04-25T12:52:55.593251",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"Swiss Federal Institute for Forest, Snow and Landscape Research WSL / Swiss Competence Center for Energy Research - Biomass for Swiss Energy Transition SCCER-BIOSWEET\", \"publication_year\": \"2017\"}",
                    "metadata_modified": "2019-10-31T23:44:40.016150",
                    "author": "[{\"name\": \"Thees\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Oliver\", \"identifier\": \"\", \"email\": \"oliver.thees@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Burg\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Vanessa\", \"identifier\": \"\", \"email\": \"vanessa.burg@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Erni\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.erni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Bowman\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"gillianne.bowman@wsl.ch\", \"given_name\": \"Gillianne\"}, {\"name\": \"Lemm\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"renato.lemm@wsl.ch\", \"given_name\": \"Renato\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Polygon\", \"coordinates\": [[[5.95587, 45.81802],[5.95587, 47.80838],[10.49203, 47.80838],[10.49203, 45.81802],[5.95587, 45.81802]]]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 3,
                    "title": "Potentials of domestic biomass resources for the energy transition in Switzerland",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "165c2eb8-be20-4300-81e8-2e0dd2ac704c",
                    "date": "[{\"date\": \"2018-12-06\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "swiss-biomass-potentials",
                    "publication_state": "published",
                    "doi": "10.16904/18",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "Switzerland has a reliable and cost efficient energy system. Due to phase  out of nuclear energy it is necessary to find new options to maintain this powerful energy system. The Swiss energy strategy 2050 aims to reduce CO2-emissions, increase efficiency and promote renewable energies. The Swiss Federal Institute for Forest, Snow and Landscape Research (WSL) examined relevant woody and non-woody biomass quantities (cubic meters, fresh-, dry weight) and their energy potentials (in Petajoules: primary energy and biomethane) with a similar methodological approach. The work was done within the frame of the Swiss Competence Centers for Energy Research (SCCER) especially in line with the SCCER Biomass for Swiss energy future (Biosweet). With a uniform and consistent approach for the current potentials ten biomass categories were estimated and aggregated for the whole of Switzerland. In this context solutions for the technical, social and political challenges are promoted. First, considering the different biomass resources characteristics and available data, appropriate methods at the finest scale possible were elaborated to estimate the annual quantities which could theoretically be collected (theoretical potential). Then, explicit and rational restrictions for sustainable bio-energy production were defined according to the current state of the art and subtracted from the theoretical potential to obtain the sustainable potential. The main restrictions are competing material utilizations, environmental factors and supply costs. Finally, the additional sustainable potential was estimated considering the current bioenergy production. Our main purpose was to provide potentials for developing conversion technologies as well as a detailed and comprehensive basis of the Swiss biomass potentials for energy use for economic and political decision makers. The complete report is available under https://www.dora.lib4ri.ch/wsl/islandora/object/wsl%3A13277/datastream/PDF/view",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "The Research Unit (RU) Forest Resources and Management is principally engaged in four research themes:\r\n\r\n* Monitoring, analysis, assessment and prognosis of forest resources\r\n* Silvicultural interventions to ensure the provision of forest products and services\r\n* Availability and optimized utilisation of forest resources, especially timber\r\n* Development of methods and models related to the three research themes mentioned previously\r\n\r\nAmong the forest resources, the RU focuses its research on timber and carbon sequestration. Moreover, it provides contributions to protection from natural hazards and to the forest as habitat and recreational area, by covering forest structures and their development.\r\n\r\nAlthough the RU focuses on forests, it also deals with the interaction between forests and other landscape elements. The RU handles its research themes on different spatial levels: from the stand, to the forest enterprise, to the region and up to the national level. Its research has a strong international reach, especially regarding the methods.\r\n\r\nThe RU administers the major project Swiss National Forest Inventory LFI and executes it by statutory mandate and in co-operation with the Federal Office of the Environment FOEN. Substantial parts of the LFI are carried out within the RU, while other parts are processed in co-operation with other RUs.\r\n\r\nThe RU is active in knowledge transfer. Its research projects are usually application-relevant and have an implementation component.\r\n\r\n__Further information__: https://www.wsl.ch/en/about-wsl/organization/research-units/forest-resources-and-management.html",
                        "created": "2016-08-10T09:44:59.305912",
                        "title": "FoReMa",
                        "name": "forema",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2018-07-10-090748.186777LogoWSL.svg",
                        "revision_id": "261452d6-9e1c-45c1-8b6b-ebaa75b9b8ab",
                        "type": "organization",
                        "id": "f2be36b2-6e95-42f1-af29-19f56a8f306d",
                        "approval_status": "approved"
                    },
                    "revision_id": "ceb386fd-4b86-42b5-b647-1efb9d3855a6",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "9f8de21f-6f70-4d1f-b303-963d199f17d5",
            "approval_status": "approved"
        },
        {
            "display_name": "Snow",
            "description": "During the [RACLETS](https://www.envidat.ch/group/about/raclets-field-campaign) campaign, snow measurements were conducted at the mountain top site Gotschnagrat at 2285 m above sea level (a.s.l.) and hosted by WSL/SLF. \r\nThe shape and morphology of single ice crystals were recorded at Weissfluhjoch at an elevation of 2700 m a.s.l. and in Laret (1522 m a.s.l.). The University of Basel collected and analyzed the ice crystal pictures.\r\n\r\nThe snow observation at Gotschnagrat included snow mass-flux (Snow Particle Counter, SPC-7, Nigaata; Flowcapt, FC4, ISAW) in kg m-2 s-1, snow surface temperature (SI-111, Campbell) in °C, snow height (SHM31, Lufft) in m and measurements of meteorological parameters like air temperature in °C, humidity in % (CS215, Campbell), and three dimensional wind speed (81000, Young) in m s-1 for every wind direction.\r\nThe data contains information on the amount of fresh snow, bonding of the snowpack, the formation of surface hoar and snowdrift accumulations. \r\n\r\nAt Weissfluhjoch, there is the chance to directly sample ice crystals within the cloud if the cloud touches the mountain or after falling through the atmosphere when the cloud base is higher than the mountaintop. At Laret, ice crystals and snowflakes can be observed which were atmospherically processed while falling. \r\n\r\nIce crystals and water droplets were additionally recorded in-situ with a holographic imager ([HoloGondel](https://www.envidat.ch/group/about/clouds-in-situ-raclets), mounted on a cable car, operating between Gotschnaboden (1779 m a.s.l.) and Gotschnagrat (2285 m a.s.l.).\r\nOther parameters measured at Weissfluhjoch included [precipitation](https://www.envidat.ch/group/about/precipitation), [aerosol, INP and CCN concentrations](https://www.envidat.ch/group/about/aerosols-raclets).\r\n\r\n\r\n\r\n![image is missing](https://iacweb.ethz.ch/data/holimo/images/notUploaded/Claudia/P2121970_Scale.JPG)\r\n\r\nImage: Claudia Mignani",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-08-21-120220.421222RACLETSsnowlogo.png",
            "package_count": 4,
            "created": "2019-07-11T14:06:09.290756",
            "name": "snow",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "RACLETS Field Campaign",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "a87610d8-0aa4-488a-83bc-c3707e350ce3",
                    "group_id": "323fdb70-959b-4bfc-bff4-e16b6907161e",
                    "id": "6e537540-5d9e-4ddc-93a2-ee1e47aee6f1"
                }
            ],
            "image_url": "2019-08-21-120220.421222RACLETSsnowlogo.png",
            "groups": [],
            "type": "group",
            "title": "Snow",
            "revision_id": "790dc675-349a-4fd4-a07a-a31e1d9c893a",
            "packages": [
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "898d94a9-7a48-4fdc-9eda-43f536e39285",
                    "metadata_created": "2019-11-06T12:22:23.566981",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-18T15:41:40.079192",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch, \", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}, {\"name\": \"Josuè\", \"data_credit\": \"collection\", \"affiliation\": \"School of Architecture, Civil and Environmental Engineering, EPFL\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"Gehring\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "Walter B., H. Huwald, J. Gehring, Y. Bühler, and M. Lehning, Radar measurements of blowing snow off a mountain ridge, submitted",
                    "num_resources": 5,
                    "title": "Snow Drift Station - Micro Rain Radar",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-03-01\", \"date_type\": \"collected\", \"end_date\": \"2019-03-22\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-micro-rain-radar",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.113",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The instrument (MRR, Metek) was mounted at a height of 1 m above snow surface (at the beginning of the campaign) with an orientation of 22° with respect to North and a horizontal viewing direction. The sampling time was either 5 s or 10 s, depending on the settings at the specific period.  The MRR produces standard outputs like radar reflectivity, doppler velocity, etc., and additional information can be found [here](https://metek.de/de/product/mrr-2/).",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "4c7ab74c-9a81-4793-835a-d8f27b1ed5d6",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "dad6d388-e76d-4f27-8b1e-0028aa9f3d23",
                    "metadata_created": "2019-11-05T12:26:59.787411",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:16:10.432240",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch\", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 6,
                    "title": "Snow Drift Station - Flowcapt",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-10\", \"date_type\": \"collected\", \"end_date\": \"2019-03-21\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-flowcapt",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.115",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "The FlowCapt is an ultra-robust instrument measuring solid particle acoustic mass - flux intensities [g m&#8254; &#178; s&#8254; &#185;] and wind speeds [m s&#8254; &#185;]. The vertical tube with a length of 1 m monitors snowdrift and snow-blowing; and is mounted at a height between 0.1 an 1.1 m above snow surface. The time within each data set is given in UTC+1. ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "23dff180-04af-4239-af76-386d2d99573d",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "efa1aa57-2aef-41de-8d36-d5847445a2dc",
                    "metadata_created": "2019-11-05T14:30:30.346894",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:15:42.200034",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": \"software\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch\", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "Walter B., H. Huwald, J. Gehring, Y. Bühler, and M. Lehning, Radar measurements of blowing snow off a mountain ridge, submitted",
                    "num_resources": 5,
                    "title": "Snow Drift Station - 3D Ultrasonic",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2019-02-11\", \"date_type\": \"collected\", \"end_date\": \"2019-03-21\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-3d-ultrasonic",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.116",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "A Young 81000 sonic anemomenter was deployed to record three components of the wind velocity (u, v, w in [m s&#8254; &#185;]) and air temperature (Ts in [°C]). The anemomenter was mounted in direction North at a height of 1.5 m above snow surface at the beginning. The time within each data set is given in UTC+1. Instrument specifications can be found [here](http://www.youngusa.com/Manuals/81000-90(I).pdf) . ",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "b3210d87-d153-4221-a105-ef8311e71d91",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Benjamin\", \"name\": \"Walter\", \"email\": \"walter@slf.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 6,
                    "subtitle": "",
                    "id": "c589c4cf-9f53-4d76-b1df-bae465ddda1f",
                    "metadata_created": "2019-11-05T15:25:56.707970",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-14T09:15:17.434323",
                    "author": "[{\"name\": \"Walter\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Benjamin\", \"identifier\": \"\", \"email\": \"walter@slf.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Huwald\", \"data_credit\": [\"collection\", \"software\", \"publication\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Hendrik\", \"identifier\": \"\", \"email\": \"hendrik.huwald@epfl.ch\", \"affiliation_02\": \"School of Architecture, Civil and Environmental Engineering, EPFL\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\":\"Point\",\"coordinates\":[9.847919, 46.859004]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 4,
                    "title": "Snow Drift Station - Snow and Air Data",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "b19d31fd-dc57-44f6-8e71-5fb3bd827318",
                    "date": "[{\"date\": \"2020-02-11\", \"date_type\": \"collected\", \"end_date\": \"2019-03-21\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "snow-drift-station-snow-and-air-data",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.114",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Snow and air data was monitored by an infrarot radiometer (Campbell SI-111) for snow temperature (°C), a snow height sensor (Lufft SHM-31) for snow height change (cm) and a temperature and humidity sensor (Campbell CS-215) for air temperature (°C) and relative humidity (%). No filter was applied to the sensors and the smapling frequency was 1 Hz.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "",
                        "created": "2018-11-15T15:30:05.707541",
                        "title": "Snow Processes",
                        "name": "snow-processes",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "",
                        "revision_id": "d8abd5c0-84bd-4a30-8131-47f98700e1ad",
                        "type": "organization",
                        "id": "f2a8afe5-e84e-454b-b5d9-6c1bf682eabd",
                        "approval_status": "approved"
                    },
                    "revision_id": "68867fb0-214c-40cc-894f-78b9115c2caf",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "323fdb70-959b-4bfc-bff4-e16b6907161e",
            "approval_status": "approved"
        },
        {
            "display_name": "SwissForestLab",
            "description": "The SwissForestLab will be established as a worldwide unique research platform and infrastructural network to assess the effects of a dynamically changing environment on forests and trees worldwide. \r\n\r\n### Key Topics of the Network Research: \r\nThe SwissForestLab will work on the most pressing and challenging topics in forest research: \r\n\r\n1.  Climate Change effects on forest ecosystems\r\n2.  Biodiversity and ecosystem functioning\r\n3.  Land-use change and its long-term legacy\r\n\r\nPresentation: http://www.wsl.ch/fe/walddynamik/projekte/irrigationpfynwald/Metadata/2015LWFPfynWorkshop/Gessler\r\n\r\nMore Information: http://intra.wsl.ch/forschung/swissforestlab/Information_SwissForestLab_EN\r\n",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-08-20-145343.943547Swiss-Forest-Lab.png",
            "package_count": 39,
            "created": "2017-01-10T17:49:52.812571",
            "name": "swissforestlab",
            "is_organization": false,
            "state": "active",
            "extras": [],
            "image_url": "2019-08-20-145343.943547Swiss-Forest-Lab.png",
            "groups": [],
            "type": "group",
            "title": "SwissForestLab",
            "revision_id": "0a85a3ee-c0c3-4de2-b21d-c826394651eb",
            "packages": [
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "29e5645c-8572-4fb3-ada6-d63fb0f4a1f2",
                    "metadata_created": "2016-11-09T13:01:02.486959",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2020-01-16T10:22:56.012764",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.768,46.700]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Beatenberg, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Beatenberg, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-beatenberg",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.95",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Beatenberg in Switzerland where one station is located within a natural coniferous forest (BAB) with Norway spruce (_Picea abies_; 190-210 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, BAF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Beatenberg is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the\r\nSwiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "d68a3592-4f6b-40a0-8afb-65920c7ecd90",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "eb7f96b4-7d02-4bf1-87c4-68fc8ced4453",
                    "metadata_created": "2016-11-09T13:36:50.555024",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:45:02.800329",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.882,46.499]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Celerina, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Celerina, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-celerina",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.97",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Celerina in Switzerland where one station is located within a natural coniferous forest stand (CLB) with Swiss pine (_Pinus cembra_; 210-250 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, CLF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Celerina is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "64ed55fd-14d8-4546-94ab-95104c4169a0",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "936684d9-ba55-49bb-b098-9ffbaf08261f",
                    "metadata_created": "2016-11-09T14:14:49.412237",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:44:29.887467",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [6.290,46.230]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Jussy, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Jussy, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-jussy",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.100",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Jussy in Switzerland where one station is located within a natural broad-leaved forest stand (JUB) with sessile oak (_Quercus petrea_; 90 yrs), aspen (_Populus tremula_; 60 yrs) and European hornbeam (_Carpinus betulus_; 60 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, JUF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Jussy is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "6b3a250f-e5ff-4d2f-9ff3-6c7b1f18f6ea",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "b48da3b5-35c1-4aba-beba-cc1f925d9c86",
                    "metadata_created": "2016-11-09T14:06:40.511920",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:43:57.245343",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.007,46.126]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Isone, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Isone, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-isone",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.99",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Isone in Switzerland where one station is located within a natural broad-leaved forest stand (ISB) with European beech (_Fagus sylvatica_; 70-100 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, ISF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Isone is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "90193cc4-e354-4321-a022-a98a2fcc024b",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "0f38b063-ae05-4dbb-8bcb-412742322356",
                    "metadata_created": "2016-11-09T13:24:42.638620",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:43:28.594789",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.415,47.223]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Bettlachstock, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Bettlachstock, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-bettlachstock",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.96",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Bettlachstock in Switzerland where one station is located within a natural mixed forest stand (BTB) with European beech (_Fagus sylvatica_; 170-190 yrs), European silver fir (_Abies alba_; 190 yrs) and Norway spruce (_Picea abies_; 200 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, BTF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Bettlachstock is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "f1e47bd1-fd54-4255-af99-bfa759f481b3",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "aa85a779-49cb-4d55-bcaf-e957a48d0771",
                    "metadata_created": "2016-11-09T13:51:50.782997",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:42:58.611464",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.816,46.444]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Chironico, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 2000 onwards",
                    "spatial_info": "Chironico, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-chironico",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.98",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Chironico in Switzerland where one station is located within a natural coniferous forest stand (CIB) with Norway spruce (_Picea abies_; 160-180 yrs) and European silver fir (_Abies alba_; 140-160 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, CIF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Chironico is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "564f3228-f803-414c-88a0-740d2e7f9b68",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "fea7c28b-0a5b-4f38-b3df-c1ce66c2cf43",
                    "metadata_created": "2016-11-09T14:31:50.918276",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:42:31.513043",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.435198,46.268368]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 3,
                    "title": "Lens, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Lens, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-lens",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.102",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for one meteorological station in Lens in Switzerland which is located within a natural coniferous forest with Scots pine (_Pinus sylvestris_; 150-170 yrs)) as dominant tree species. The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Lens is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "37117a14-919a-4da8-a4ae-c5202bed7bc7",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "8d87a8ef-9db6-4803-a157-4b987ac831ea",
                    "metadata_created": "2016-11-15T08:50:36.452649",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:42:02.387628",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [10.236,46.661]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Nationalpark, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Nationalpark, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-nationalpark",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.103",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Nationalpark in Switzerland where one station is located within a natural coniferous forest stand (NAB) with mountain pine (_Pinus mugo_; 210 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, NAF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Nationalpark is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.\r\n",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "7a9e46da-44cc-402f-a518-23eb970dff1e",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "213b7b1b-f8a8-4cef-ae22-8b2db10f2655",
                    "metadata_created": "2016-11-15T09:31:27.684210",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:41:26.487417",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.858,46.298]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Visp, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Visp, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-visp",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.108",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Visp in Switzerland where one station is located within a natural mixed forest stand (VSB) with Scots pine (_Pinus sylvestris_; 40-80 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, VSF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Visp is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "a0210640-a715-444e-ad0b-b0be64a77709",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "f55c13c3-3b46-4b54-a5c4-fe401b877c64",
                    "metadata_created": "2016-11-09T14:23:49.981330",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:40:53.208177",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [6.653,46.571]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Lausanne, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1996 onwards",
                    "spatial_info": "Lausanne, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-lausanne",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.101",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Lausanne in Switzerland where one station is located within a natural mixed forest stand (LAB) with European beech (_Fagus sylvatica_; 160-170 yrs), European silver fir (_Abies alba_; 160-170 yrs) and Norway spruce (_Picea abies_; 160-170 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, LAF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Lausanne is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "046d0189-1d30-47f4-bdc5-90a569816ce8",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "1913b44e-2466-4f42-8e77-ea905b1a742e",
                    "metadata_created": "2016-11-15T09:19:56.006727",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:40:21.218540",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.899,47.271]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Vordemwald, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1996 onwards",
                    "spatial_info": "Vordemwald, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-vordemwald",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.109",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Vordemwald in Switzerland where one station is located within a natural mixed forest stand (VOB) with European silver fir (_Abies alba_; 110 yrs) and oak trees (_Quercus sp._; 190-210 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, VOF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Vordemwald is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "883c6365-a4ba-4b46-b113-927080a8fd77",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "20934806-9510-4de8-b2a6-acb1f9831de3",
                    "metadata_created": "2016-11-15T08:38:26.995243",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:39:49.107512",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.530,47.687]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Neunkirch, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Neunkirch",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-neunkirch",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.104",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Neunkirch in Switzerland where one station is located within a natural deciduous forest stand (NEB) with European beech (_Fagus sylvatica_; 160 yrs), sycamore maple (_Acer pseudoplatanus_; 160 yrs) and lime trees (_Tilia sp._; 110 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, NEF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Neunkirch is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "9ab343fe-74a7-4444-a372-f33707301165",
                    "resource_type": ""
                },
                {
                    "owner_org": "49192b11-adac-4e68-ad64-be15a4321347",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"https://orcid.org/0000-0001-6466-0161\", \"given_name\": \"Golo\", \"name\": \"Stadelmann\", \"email\": \"golo.stadelmann@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 9,
                    "subtitle": "",
                    "id": "8fd996d1-aa7e-41b1-ae6d-1192582c62cc",
                    "metadata_created": "2019-10-29T14:48:09.250475",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-03T18:34:13.474209",
                    "author": "[{\"name\": \"Stadelmann\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Golo\", \"identifier\": \"https://orcid.org/0000-0001-6466-0161\", \"email\": \"golo.stadelmann@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Zell\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"https://orcid.org/0000-0002-2035-2789\", \"email\": \"juergen.zell@wsl.ch\", \"given_name\": \"Jürgen\"}, {\"name\": \"Rohner\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Brigitte\", \"identifier\": \"https://orcid.org/0000-0003-3768-092X\", \"email\": \"brigitte.rohner@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Schneider\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Barbara\", \"identifier\": \"\", \"email\": \"barbara.schneider@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Temperli\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"https://orcid.org/0000-0003-1161-9864\", \"email\": \"christian.temperli@wsl.ch\", \"given_name\": \"Christian\"}, {\"name\": \"Portier\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"jeanne.portier@wsl.ch\", \"given_name\": \"Jeanne\"}, {\"name\": \"Didion\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"https://orcid.org/0000-0003-0346-0646\", \"email\": \"markus.didion@wsl.ch\", \"given_name\": \"Markus\"}, {\"name\": \"Bischof\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"sandro.bischof@wsl.ch\", \"given_name\": \"Sandro\"}, {\"name\": \"Thürig\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Esther\", \"identifier\": \"\", \"email\": \"esther.thuerig@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Polygon\", \"coordinates\": [[[5.95587, 45.81802],[5.95587, 47.80838],[10.49203, 47.80838],[10.49203, 45.81802],[5.95587, 45.81802]]]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "* wsl:5362 \r\n* wsl:5560  \r\n* wsl:14085  \r\n* wsl:12846  \r\n* wsl:19228  \r\n* wsl:21600  \r\n* wsl:19354  \r\n* wsl:21606",
                    "num_resources": 1,
                    "title": "MASSIMO",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "83a45c68-da80-40fa-aa1c-7d015fee8cca",
                    "date": "[{\"date\": \"2019-10-30\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "massimo",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "MASSIMO is a distance-independent individual-tree simulator that represents demographic processes (regeneration, growth and mortality) with empirical models that have been parameterized with data from the Swiss NFI. Tree regeneration, growth and mortality are simulated on the regular grid of sample plots of the Swiss NFI, which allows for statistically representative simulations of forest development.\r\n\r\n![alt text](https://www.envidat.ch/dataset/8fd996d1-aa7e-41b1-ae6d-1192582c62cc/resource/a12e2cfd-da45-4faf-8291-446c5763ac3c/download/massimo2__swissforlab.png)\r\n\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "The Swiss National Forest Inventory records the current state and the changes of the Swiss forest. The survey obtains data about trees, stands, sample plots and through enquiries at the local forest service.\r\n\r\nThe NFI carried out by the Swiss Federal Institute for Forest, Snow and Landscape Research (WSL) in collaboration with the Forest Division at Federal Office for the Environment (FOEN ). The WSL is responsible for the planning, survey and analysis, as well as the scientific interpretation and publication of the NFI. The political interpretation and implementation is done by the Forest Division.\r\n\r\nThe first survey (LFI1) took place from 1983–85, the second survey followed in 1993–95 and the third inventory was carried out 2004–2006. Since 2009, the continuous survey of the fourth NFI (2009–2017) has been in progress.\r\n\r\nMore information: https://www.lfi.ch/lfi/lfi-en.php",
                        "created": "2016-07-05T13:46:14.456454",
                        "title": "NFI",
                        "name": "nfi",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.lfi.ch/layout/images/logo.gif",
                        "revision_id": "57729ab8-3744-438f-959a-aed2a9f4d900",
                        "type": "organization",
                        "id": "49192b11-adac-4e68-ad64-be15a4321347",
                        "approval_status": "approved"
                    },
                    "revision_id": "ce76ee9c-6c5f-4acf-8cd1-7c1406844213",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "cee2fefc-daa6-424a-b78c-3e324e6138ac",
                    "metadata_created": "2016-11-15T08:06:36.020678",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-02T22:42:04.868553",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.835,46.023]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Novaggio, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1996 onwards",
                    "spatial_info": "Novaggio, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-novaggio",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.105",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Novaggio in Switzerland where one station is located within a natural deciduous forest stand (NOB) with Turkey oak (_Quercus cerris_; 70 yrs), sweet chestnut (_Castanea sativa_; 90 yrs) and silver birch (_Betula pendula_; 70 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, NOF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Novaggio is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "1a2a6ea3-2c92-40cc-b6ce-78c7aa5bfa3c",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "70a7c0f0-0ab9-4d31-b80c-c656c9fca7d9",
                    "metadata_created": "2016-11-15T09:08:59.112314",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-02T22:41:25.678644",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.225,47.399]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 7,
                    "title": "Othmarsingen, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1996 onwards",
                    "spatial_info": "Othmarsingen, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-othmarsingen",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.106",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Othmarsingen in Switzerland where one station is located within a natural deciduous forest stand (OTB) with European beech (_Fagus sylvatica_; 120-140 yrs) and lime trees (_Tilia sp._; 120-140 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, OTF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Othmarsingen is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "efa4bb74-47e1-4132-ad0b-486e400304bc",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "3bb25386-f2d8-4fda-b7fa-86ea4be16535",
                    "metadata_created": "2016-11-09T12:42:44.809970",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-02T22:40:45.512333",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.713054,47.04872]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 3,
                    "title": "Alpthal, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1997 onwards",
                    "spatial_info": "Alpthal, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-alpthal",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.94",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for one meteorological station in Alpthal in Switzerland which is located within a natural coniferous forest (ALB) with Norway spruce (_Picea abies_; 180-230 yrs) as dominant tree species. The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Alpthal is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "6e2d8e66-a4ff-4493-879b-c974ac9b1481",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"WSL\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "49729a45-f5bf-4bc0-afdd-77123894d3bb",
                    "metadata_created": "2019-10-01T09:20:00.414650",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-12-02T22:38:59.177661",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": \"publication\", \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.713054,47.04872]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "* wsl:16555",
                    "num_resources": 3,
                    "title": "LWF Alptal long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "334cee1e-6afa-4639-88a2-f980e6ff42c3",
                    "date": "[{\"date\": \"1995-05-31\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-alptal-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/49729a45-f5bf-4bc0-afdd-77123894d3bb/resource/aa505753-198c-49dc-a33e-c4c8e4fcb611/download/lwf_alptal.jpg \"LWF Alptal\")\r\n\r\nLWF plot Alptal\r\n\r\n- Community: Alpthal / canton SZ\r\n- Date of installation: 31 May 1995\r\n- Size of the plot: 0.6 ha\r\n- Altitude: 1149-1170 m\r\n- Mean slope: 23%\r\n- Geology (in German): Nordpenninikum; obere Kreide-unteres Eozän, Wägitaler Flysch\r\n- Soil types (WSL) : Mollic Gleysols, Gleyic Cambisols\r\n- Woodland association after EK72: 49: Equiseto-Abietetum\r\n- Main tree species: Picea abies\r\n- Management system: high forest\r\n- Silvicultural system: selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 39.3 cm\r\n- Number of trees BHD >= 12 cm (2011): 321\r\n- Maximum tree age: Picea abies 180-230 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/alptal.html\r\n\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "878ab181-6046-4524-bb37-d1e7d8692844",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Marcus\", \"name\": \"Schaub\", \"email\": \"marcus.schaub@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 11,
                    "subtitle": "",
                    "id": "0e18a914-f2e4-47df-a86c-a44a1b0055e4",
                    "metadata_created": "2016-11-04T13:48:21.520445",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"Swiss Federal Research Institute WSL / SwissForestLab\", \"publication_year\": \"2016\"}",
                    "metadata_modified": "2019-12-02T10:58:01.963915",
                    "author": "[{\"name\": \"Schaub\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Marcus\", \"identifier\": \"\", \"email\": \"marcus.schaub@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"﻿matthias.haeni@wsl.ch\", \"given_name\": \"Matthias\"}, {\"name\": \"Hug\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Christian\", \"identifier\": \"\", \"email\": \"christian.hug@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rigling\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"andreas.rigling@wsl.ch\", \"given_name\": \"Andreas\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "2016",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.61192,46.30284]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 7,
                    "title": "Tree\tmeasurements 2002-2016 from the long-term irrigation experiment Pfynwald, Switzerland",
                    "spatial_info": "Pfynwald, Valais, Switzerland",
                    "creator_user_id": "fe7fa798-2f5c-4ad3-b865-50260d7322cf",
                    "date": "[{\"date\": \"2018-07-06\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "pfynwald",
                    "publication_state": "published",
                    "doi": "10.16904/11",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "To study the performance of mature Scots pine (_Pinus sylvestris_ L.) under chronic drought conditions in comparison to their immediate physiological response to drought release, a controlled long-term and large-scale irrigation experiment has been set up in 2003. The experiment is located in a xeric mature Scots pine forest in the Pfynwald (46° 18' N, 7° 36' E, 615 m a.s.l.) in one of the driest inner-Alpine valleys of the European Alps, the Valais (mean annual temperature: 9.2°C, annual precipitation sum: 657 mm, both 1961-1990). Tree age is on average 100 years, the top height is 10.8 m and the stand density is 730 stems ha-1 with a basal area of 27.3 m2 ha-1. The forest is described as _Erico Pinetum sylvestris_ and the soil is a shallow pararendzina characterized by low water retention. The experimental site (1.2 ha; 800 trees) is split up into eight plots of 1'000 m2 each. During April-October, irrigation is applied on four randomly selected plots with sprinklers of 1 m height at night using water from an adjacent water channel. The amount of irrigation corresponds to a supplementary rainfall of 700 mm year-1. Trees in the other four plots grow under naturally dry conditions. Soil moisture has been monitored since the beginning of the project at 3 soil depths (10, 20 and 60 cm). The crown condition of each tree is being assessed each year since 2003. Tree measurement data such as diameter at breast height, tree height, and social status were assessed in 2002, 2009 and 2014. The duration of the irrigation experiment is planned for 20 years.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "9d467c61-2818-41bb-a174-5164b59edfb2",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Research Institute WSL\", \"identifier\": \"\", \"given_name\": \"Matthias\", \"name\": \"Haeni\", \"email\": \"matthias.haeni@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 10,
                    "subtitle": "",
                    "id": "7e6a34bc-3c2c-45f2-8e3b-1b58f1ba5074",
                    "metadata_created": "2016-11-09T11:48:20.514018",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-25T12:48:32.524756",
                    "author": "[{\"name\": \"Haeni\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Matthias\", \"identifier\": \"\", \"email\": \"matthias.haeni@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Rebetez\", \"affiliation\": \"Swiss Federal Research Institute WSL\", \"affiliation_03\": \"\", \"given_name\": \"Martine\", \"identifier\": \"\", \"email\": \"martine.rebetez@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.063,47.159]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 8,
                    "title": "Schänis, Switzerland: Long-term forest meteorological data from the Long-term Forest Ecosystem Research Programme (LWF), from 1998 onwards",
                    "spatial_info": "Schänis, Switzerland",
                    "creator_user_id": "11dc6637-cf6e-4c83-ab01-c708cc742b27",
                    "date": "[{\"date\": \"2018-05-25\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwfmeteo-schaenis",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.107",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "High quality meteorological data are needed for long-term forest ecosystem research, particularly in the light of global change. The long-term data series published here comprises almost 20 years of measurements for two meteorological stations in Schänis in Switzerland where one station is located within a natural mixed forest stand (SCB) with European beech (_Fagus sylvatica_; 130-150 yrs), European silver fir (_Abies alba_; 130-150 yrs) and European ash (_Fraxinus excelsior_; 130-150 yrs) as dominant tree species. A second station is situated in the very vicinity outside of the forest (field station, SCF). The meteorological time series are presented in hourly time resolution of air temperature, relative humidity, precipitation, photosynthetically active radiation (PAR) and wind speed. Schänis is part of the Long-term Forest Ecosystem Research Programme (LWF) established and maintained by the Swiss Federal Research Institute WSL.",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "98905987-0e3b-48ca-aacc-c967d3021a82",
                    "resource_type": ""
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Marcus\", \"name\": \"Schaub\", \"email\": \"marcus.schaub@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "39a232b5-c50e-490c-9bee-f04c2f697e14",
                    "metadata_created": "2019-11-08T13:50:45.945630",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-08T15:02:03.721196",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Schaub\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Marcus\", \"identifier\": \"\", \"email\": \"marcus.schaub@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.6121082,46.3027884]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF long-term experimental irrigation site Pfynwald",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"2003-01-01\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-long-term-experimental-irrigation-site-pfynwald",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/39a232b5-c50e-490c-9bee-f04c2f697e14/resource/6d38da33-adc3-498e-aa48-7faf60a50a02/download/lwf_irrigation_experiment-pfynwald_2013.jpg \"LWF experimental irrigatino site Pfynwald\")\r\n\r\n\r\nAs the largest contiguous pine forest in Switzerland, the Pfyn forest in Canton Valais (46° 18' N, 7° 36' E, 615 m ASL) offers the best conditions for such measurements.  In light of this, a WSL research team installed a long-term experiment of 20 years duration in the Pfyn forest.  The average temperature here is 9.2°C, the yearly accumulated precipitation is 657 mm (average 1961-1990). The pines in the middle of the forest are about 100 years old and 10.8 m high. The test area has 876 trees covering 1.2 ha divided into 8 plots of 1'000 m2 each (Image 4). Between the months of April and October four of these plots are irrigated by a sprinkler system providing an additional 700 mm of water, annually. In the other four plots, the trees grow under natural, hence relatively dry conditions.",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "73d0eb04-759e-4927-bdeb-26e7832540b8",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "b763c4e1-2de3-4e8f-9bb7-2ca533624060",
                    "metadata_created": "2019-10-31T11:39:14.371625",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-07T13:11:32.673058",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.3645212,47.4783603]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "LWF Laegeren long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"2012-05-01\", \"date_type\": \"collected\", \"end_date\": \"2044-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-laegeren-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/b763c4e1-2de3-4e8f-9bb7-2ca533624060/resource/b6e747c6-7a85-43e0-958b-3522f370bbad/download/lwf_laegeren.jpg \"LWF Lägeren\")\r\n\r\nLWF Plot Lägeren\r\n\r\n- Community: Wettingen / canton AG\r\n- Date of installation: 1.05.2012\r\n- Size of the plot: 1.34 ha\r\n- Altitude: 643 - 718 m\r\n- Mean slope: 37 %\r\n- Geology (in German): Kettenjura; Jura: Malm, Molassehangschutt\r\n- Soil types (WSL) : calcareous brown soil, chromic luvisol, mixed rendzina\r\n- Woodland association after Ellenberg and Klötzli's classification (1972): Galio odoratio-Fagetum typicum bis - Pulmonario-Fagetum typicum\r\n- Main tree species: fagus sylvatica\r\n- Management system: high forest\r\n- Silvicultural system: forest reserve\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 72.18 cm\r\n- Number of trees BHD >= 12 cm (2011): 503\r\n- Maximum tree age: picea abies: 120-170 years, fagus sylvatica: ca. 150 years\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/laegeren.html\r\n\r\nCollaboration with the groups Grassland Sciences and Land-Climate Dynamics from the ETHZ, the NABEL from the EMPA and the unit Soil Science & Biogeochemistry from the University of Zurich.",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "18eff5c0-d5e0-424f-920b-3db0d08431e2",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "bffc768d-e3b2-41b2-9b5f-3c1ecbc3ce74",
                    "metadata_created": "2019-11-01T08:45:01.316975",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-07T13:11:02.793321",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.8867633,47.2740627]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Vordemwald long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1995-08-18\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-vordemwald-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/bffc768d-e3b2-41b2-9b5f-3c1ecbc3ce74/resource/e129ebc8-ef61-4e19-8e89-e18d591ed8c5/download/lwf_vordemwald.jpg \"LWF Vordemwald\")\r\n\r\nLWF Plot Vordemwald\r\n\r\n- Community: Vordemwald / canton AG\r\n- Date of installation: 18 August 1995\r\n- Size of the plot: 2 ha\r\n- Altitude: 473-487 m\r\n- Mean slope: 14%\r\n- Geology (in German): Untergrund: Oligozän, Aquitanien, untere Süsswassermolasse, bunte Mergel - Oberfläche: Rissgrundmoräne\r\n- Soil types (WSL): Distric Gleysols\r\n- Woodland association after EK72: 46: Bazzanio-Abietetum\r\n- Main tree species: Abies alba\r\n- Management system: high forest\r\n- Silvicultural system: group selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 53.9 cm\r\n- Number of trees BHD >= 12 cm (2011): 1084\r\n- Maximum tree age: Abies alba 110 yr - Quercus sp. 190-210 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/vordemwald.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "575d203d-5a67-4dba-9247-da653a54624a",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "801cdd7e-f5b0-4998-bb8a-bd6d2ae8baa2",
                    "metadata_created": "2019-10-31T09:38:31.405462",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-07T09:27:38.892215",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.8552112,46.8153458]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "LWF Davos long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"2006-06-15\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-davos-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/801cdd7e-f5b0-4998-bb8a-bd6d2ae8baa2/resource/f2ef5505-e0ea-493d-8b86-4f27dd556da8/download/lwf_davos.jpg \"LWF Davos\")\r\n\r\nLWF Plot Davos\r\n\r\n- Community: Davos / canton GR\r\n- Date of installation: 15.06.2006\r\n- Size of the plot: 0.6 ha\r\n- Altitude: : 1635-1665\r\n- Mean slope: xx%\r\n- Geology (in German): Untergrund:  - Oberfläche: \r\n- Provisional soil type (WSL): \r\n- Woodland association after EK72: 58: Larici-Piceetum\r\n- Main tree species: Picea abies\r\n- Management system: high forest\r\n- Silvicultural system: group selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 47.0 cm\r\n- Number of trees BHD >= 12 cm (2006): 498\r\n- Maximum tree age: Picea abies: 200 - 390 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/davos.html\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "19e1588b-4241-4b2a-afc7-be66fe6c1d19",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "8f67193b-12cf-4871-9a9e-750b816e9d10",
                    "metadata_created": "2019-10-29T11:42:05.960709",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:15:09.905882",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.4166536,47.2251551]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Bettlachstock long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1995-06-06\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-bettlachstock-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/8f67193b-12cf-4871-9a9e-750b816e9d10/resource/b05db334-5bf6-42d6-a985-a5253366259d/download/lwf_bettlachstock.jpg \"LWF Bettlachstock\")\r\n\r\nLWF Plot Bettlachstock\r\n\r\n- Community: Bettlachstock / canton SO\r\n- Date of installation: 6 June 1995\r\n- Size of the plot: 1.28 ha\r\n- Altitude: 1101-1196 m\r\n- Mean slope: 66%\r\n- Geology (in German): Kettenjura; Jura: Dogger, oberer Hauptrogenstein\r\n- Soil types (WSL) : Rendzic Leptosols; Calcaric Cambisols\r\n- Woodland association after EK72: 13 h: Cardamino-Fagetum tilietosum\r\n- Main tree species: Fagus sylvatica\r\n- Management system: high forest\r\n- Silvicultural system: forest reserve\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 49.5 cm\r\n- Number of trees BHD >= 12 cm (2011): 632\r\n- Maximum tree age: Fagus sylvatica 170-190 yr - Picea abies 200 yr - Fraxinus excelsior 170 yr - Ulmus glabra 160 yr - Abies alba 190 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/bettlachstock.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "1d0f9f88-f055-4f21-87fa-d1d237b1f459",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "7310b935-757f-4f27-b202-9f433c9882ab",
                    "metadata_created": "2019-10-29T11:42:48.738236",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:15:00.253816",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.7623374,46.7003438]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Beatenberg long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1996-09-25\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-beatenberg-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/7310b935-757f-4f27-b202-9f433c9882ab/resource/555b1a19-aff3-40be-9d6d-fea9967d5691/download/lwf_beatenberg.jpg \"LWF Beatenberg\")\r\n\r\nLWF plot Beatenberg\r\n\r\n- Community: Beatenberg / canton BE\r\n- Date of installation: 25 September 1996\r\n- Size of the plot: 2 ha\r\n- Altitude: 1490-1532 m\r\n- Mean slope: 66%\r\n- Geology (in German): Helvetikum, Tertiär, Eozän; Hohgantsandstein\r\n- Provisional soil type (WSL) : Gleyic Podzols\r\n- Woodland association after EK72: 57: Sphagno-Piceetum calamagrostietosum villosae\r\n- Main tree species: Picea abies\r\n- Management system: high forest\r\n- Silvicultural system: selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 46.4 cm\r\n- Number of trees BHD >= 12 cm (2011): 851\r\n- Maximum tree age: Picea abies 190-210 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/beatenberg.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "c1d648d2-500a-4c66-86ff-b03e6ea82bb5",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "9e5d6c82-26ac-4818-9458-1ac7c8574bb0",
                    "metadata_created": "2019-11-04T15:57:46.065724",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:14:36.853527",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.5646678,46.6980544]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "LWF Lantsch long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1997-09-15\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-lantsch-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/9e5d6c82-26ac-4818-9458-1ac7c8574bb0/resource/c26169dc-db58-4e69-bc74-9513dbf7bccc/download/lwf_lantsch.jpg \"LWF Lantsch\")\r\n\r\nLWF Plot Lantsch\r\n\r\n- Community: Lantsch / canton GR\r\n- Date of installation: 15 September 1997\r\n- Size of the plot: n.d.\r\n- Altitude: 1458-1490 m\r\n- Mean slope: 16%\r\n- Geology (in German): Ostalpin. Gehängeschutt aus mesozoischen Schiefern, Dolomiten und Kalken\r\n- Soil types (WSL) : n.d.\r\n- Woodland association after EK72: 65: Erico-Pinetum silvestris\r\n- Main tree species: Picea abies\r\n- Management system: high forest\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 40.1 cm\r\n- Number of trees BHD >= 12 cm (2011): 709\r\n- Maximum tree age: n.d.\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/lantsch.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "26f0dae2-8410-4a1b-a0c8-5256bbab972c",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "0c244fe7-886a-4a1c-add5-5f706e995a29",
                    "metadata_created": "2019-10-31T07:15:17.844082",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:14:31.429372",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": \"publication\", \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": \"publication\", \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.8888024,46.4921451]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Celerina long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1996-07-03\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-celerina-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/0c244fe7-886a-4a1c-add5-5f706e995a29/resource/28e97caa-65fc-4396-8bca-860721eddfa2/download/lwf_celerina.jpg \"LWF Celerina\")\r\n\r\nLWF Plot Celerina\r\n\r\n- Community: Celerina / canton GR\r\n- Date of installation: 3 July 1996\r\n- Size of the plot: 2 ha\r\n- Altitude (m): 1846-1896\r\n- Mean slope: 34%\r\n- Geology (in German): Untergrund: ostalpin; prätriadische Tiefengesteine - Oberfläche: Quartär; karbonatfreie Moräne\r\n- Soil types (WSL): n.d.\r\n- Woodland association after EK72: 59: Larici-Pinetum cembrae\r\n- Main tree species: Pinus cembra\r\n- Management system: high forest\r\n- Silvicultural system: group selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 48.6 cm\r\n- Number of trees BHD >= 12 cm (2011): 469\r\n- Maximum tree age: Pinus cembra uneven-aged - 210-250 years\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/celerina.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "ab5dd400-b0b6-445e-b410-4e6f24c64300",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "67e14643-c7f2-4190-ae6e-c8c94f1c5f01",
                    "metadata_created": "2019-11-04T15:27:40.555736",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:14:25.560162",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.8121720,46.4468172]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Chironico long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1995-08-29\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-chironico-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/67e14643-c7f2-4190-ae6e-c8c94f1c5f01/resource/1d23d53f-8572-47eb-b466-88dd8ad244c9/download/lwf_chironico.jpg \"LWF Chironico\")\r\n\r\nLWF Plot Chironico\r\n\r\n- Community: Chironico / canton TI\r\n- Date of installation: 29 August 1995\r\n- Size of the plot: 2 ha\r\n- Altitude: 1342-1387 m\r\n- Mean slope: 35%\r\n- Geology (in German): Untergrund: Penninikum; Paragneisse u. Glimmerschiefer - Oberfläche: Quartär; karbonatfreie Moräne, Hängeschutt\r\n- Provisional soil type (WSL) : Distric Cambisol\r\n- Woodland association after EK72: 47: Calamagrostio villosae-Abietetum\r\n- Main tree species: Picea abies\r\n- Management system: high forest\r\n- Silvicultural system: group selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 54.1 cm\r\n- Number of trees BHD >= 12 cm (2011): 750\r\n- Maximum tree age: Picea abies: 160-180 yr - Abies alba: 140-160 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/chironico.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "ce703b94-98cb-48ad-92d3-448b79ea07f7",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "f4b44f60-4eed-471f-a09e-749a0f5f0683",
                    "metadata_created": "2019-10-31T10:20:11.471507",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:14:19.630769",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.0080555,46.1248982]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Isone long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1995-09-05\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-isone-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/f4b44f60-4eed-471f-a09e-749a0f5f0683/resource/cb8e84ea-ad8b-476e-be32-e02a927d2449/download/lwf_isone.jpg \"LWF Isone\")\r\n\r\nLWF Plot Isone\r\n\r\n- Community: Isone / canton TI\r\n- Date of installation: 5 September 1995\r\n- Size of the plot: 2 ha\r\n- Altitude (m): 1181-1259\r\n- Mean slope: 58%\r\n- Geology (in German): Untergrund: Südalpin, präpermisches Grundgebirge, Ceneri Zone; schiefriger Biotitplagioklasgneis - Oberfläche: Quartär; Moräne, Hängeschutt-.\r\n- Provisional soil type (WSL) : Humic Cambisol\r\n- Woodland association after EK72: 4: Luzulo niveae-Fagetum dryopteridetosum\r\n- Main tree species: Fagus sylvatica\r\n- Management system: former coppice\r\n- Silvicultural system: unmanaged\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 37.4 cm\r\n- Number of trees BHD >= 12 cm (2011): 1254\r\n- Maximum tree age: Fagus sylvatica uneven-aged - 70-85-100 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/isone.html\r\n\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "44e5b5a5-a9ea-4282-a229-4e75960dcce3",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "465d852d-af24-415f-9db2-48fe31d6dc20",
                    "metadata_created": "2019-10-31T10:37:30.907810",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:14:13.459498",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [6.2908547,46.2298528]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Jussy long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1995-05-31\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-jussy-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/465d852d-af24-415f-9db2-48fe31d6dc20/resource/a39a0e35-efdf-4bef-bab1-4b0532442b34/download/lwf_jussy.jpg \"LWF Jussy\")\r\n\r\nLWF Plot Jussy\r\n\r\n- Community: Jussy / canton GE\r\n- Date of installation: 31 May 1995\r\n- Size of the plot: 1.99 ha\r\n- Altitude: 496-506 m\r\n- Mean slope: 3%\r\n- Geology (in German): Quartär; tonreiche würmeiszeitliche Grundmoräne\r\n- Soil types (WSL) : Stagnic Luvisols\r\n- Woodland association after EK72: 35: Galio silvatici-Carpinetum\r\n- Main tree species: Quercus species\r\n- Management system: former coppices w. standards\r\n- Silvicultural system: unmanaged / group selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 36.6 cm\r\n- Number of trees BHD >= 12 cm (2011): 1278\r\n- Maximum tree age: Carpinus betulus 60 yr - Populus tremula 60 yr - Quercus petrea 90 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/jussy.html\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "c4ebb92a-fb59-4d15-97c7-894aa94f9b43",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "9f35f697-a226-4719-aefd-b8c96fe5ae7c",
                    "metadata_created": "2019-10-31T12:38:51.445017",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:14:08.032043",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [6.6580421,46.5837664]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Lausanne long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1994-09-05\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-lausanne-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/9f35f697-a226-4719-aefd-b8c96fe5ae7c/resource/d6a48c12-62e6-4c04-9f63-a84d5964bc55/download/lwf_lausanne.jpg \"LWF Lausanne\")\r\n\r\nLWF Plot Lausanne\r\n\r\n- Community: Lausanne / canton VD\r\n- Date of installation: 5 September 1994\r\n- Size of the plot: 2 ha\r\n- Altitude: 800-814 m\r\n- Mean slope: 7%\r\n- Geology (in German): Untergrund: Tertiär, Miozän, Burdigalien, obere Meeresmolasse; Sandstein - Oberfläche: Quartär, Würm; würmeiszeitliche Moräne\r\n- Soil types (WSL) : Distric Cambisols\r\n- Woodland association after EK72: 8: Milio-Fagetum\r\n- Main tree species: Fagus sylvatica\r\n- Management system: high forest\r\n- Silvicultural system: group selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 59.9 cm\r\n- Number of trees BHD >= 12 cm (2011): 650\r\n- Maximum tree age: Abies alba 160-170 yr - Picea abies 160-170 yr - Fagus sylvatica 160-170 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/lausanne.html\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "0a1425e7-ac73-449f-9eb1-23ea54ebf27a",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "87d3ea5a-8d50-446b-9c33-cbe56057f7d3",
                    "metadata_created": "2019-10-31T12:59:18.911198",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:14:00.241957",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.4359392,46.2685558]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Lens long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1996-03-15\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-lens-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/87d3ea5a-8d50-446b-9c33-cbe56057f7d3/resource/bf459948-da5a-4b05-9372-83ca5454aeca/download/lwf_lens.jpg \"LWF Lens\")\r\n\r\nLWF Plot Lens\r\n\r\n- Community: Lens / canton VS\r\n- Date of installation: 15 March 1996\r\n- Size of the plot: 2 ha\r\n- Altitude: 1033-1093 m\r\n- Mean slope: 75%\r\n- Geology (in German): Untergrund: Penninikum, Ferret-Zone, Trias; sandiger Kalkstein - Oberfläche: Hängeschutt\r\n- Provisional soil type (WSL): Calcaric Cambisol\r\n- Woodland association after EK72: +- 64: Cytiso-Pinetum silvestris\r\n- Main tree species: Pinus sylvestris\r\n- Management system: high forest\r\n- Silvicultural system: unmanaged\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 31.8 cm\r\n- Number of trees BHD >= 12 cm (2011): 2304\r\n- Maximum tree age:150-170 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/lens.html\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "747c40fe-b81e-4114-b3d7-539ca14a6754",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "4a0ff376-83d2-4ae4-bf2e-c361eb050778",
                    "metadata_created": "2019-10-31T13:19:50.469388",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:13:54.733525",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [10.2300874,46.6625010]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Nationalpark long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1995-10-10\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-nationalpark-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/4a0ff376-83d2-4ae4-bf2e-c361eb050778/resource/51e98f2d-5524-4ea6-babb-9df0b9aba8f1/download/lwf_nationalpark.jpg \"LWF Nationalpark\")\r\n\r\nLWF Plot Nationalpark\r\n\r\n- Community: Zernez / canton GR\r\n- Date of installation: 10 October 1995\r\n- Size of the plot: 2 ha\r\n- Altitude: 1890-1907 m\r\n- Mean slope: 11%\r\n- Geology (in German): Nacheiszeitlicher Schwemmfächer; kalkhaltige Moräne, Dolomite, Kalke, Tonschiefer, Rauhwacken\r\n- Provisional soil types (WSL): Rendzic Leptosol\r\n- Woodland association after EK72: 67: Erico-Pinetum montanae\r\n- Main tree species: Pinus mugo\r\n- Management system: high forest\r\n- Silvicultural system: forest reserve\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 23.7 cm\r\n- Number of trees BHD >= 12 cm (2011): 2450\r\n- Maximum tree age: Pinus mugo 210 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/nationalpark.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "1170f7f7-fe75-4bea-ab8a-f57db211a42f",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "86603cf3-979c-4b28-a63e-9852bfb969bd",
                    "metadata_created": "2019-10-31T14:02:31.881967",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:13:48.248418",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.5356830,47.6837031]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Neunkirch long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1995-07-14\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-neunkirch-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/86603cf3-979c-4b28-a63e-9852bfb969bd/resource/69a58300-d372-4487-8596-5403254d539d/download/lwf_neunkirch.jpg \"LWF Neunkirch\")\r\n\r\n\r\nLWF Plot Neunkirch\r\n\r\n- Community: Neunkirch / canton SH\r\n- Date of installation: 14 July 1995\r\n- Size of the plot: 2 ha\r\n- Altitude (m): 554-609\r\n- Mean slope: 58%\r\n- Geology (in German): Tafeljura, oberer Malmkalk; Malmhängeschutt\r\n- Soil types (WSL) : Rendzic Leptosols\r\n- Woodland association after EK72: 13: Cardamino-Fagetum tilietosum\r\n- Main tree species: Fagus sylvatica\r\n- Management system: former coppices w. standards\r\n- Silvicultural system: reserve\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 56.5 cm\r\n- Number of trees BHD >= 12 cm (2011): 442\r\n- Maximum tree age: Fagus sylvatica 160 yr - Acer pseudoplatanus 160 yr - Tilia sp. 110 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/neunkirch.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "0633a2e6-f7aa-4bf5-aa89-b5a08a2154c1",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "e87358e9-4beb-487e-af68-66633e9cfc96",
                    "metadata_created": "2019-10-31T15:02:24.459461",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:13:42.212459",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.8341613,46.0226119]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Novaggio long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1995-03-08\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-novaggio-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/e87358e9-4beb-487e-af68-66633e9cfc96/resource/91bd053a-61c4-4b20-b0d3-a572c983e647/download/lwf_novaggio.jpg \"LWF Novaggio\")\r\n\r\nLWF Plot Novaggio\r\n\r\n- Community: Novaggio / canton TI\r\n- Date of installation: 8.3.95\r\n- Size of the plot: 1.5 ha\r\n- Altitude (m): 902-997\r\n- Mean slope: 68%\r\n- Geology (in German): Untergrund: Südalpin, präpermisches Grundgebirge; Orthogneis, schiefriger Biotitplagioklasgneis - Oberfläche: Quartär; karbonatfreie würmeiszeitliche Moräne\r\n- Provisional soil type (WSL): Kryptopodzole\r\n- Woodland association after EK72: 42: Phyteumo betonicifoliae-Quercetum castanosum\r\n- Main tree species: Quercus cerris\r\n- Management system: former coppice\r\n- Silvicultural system: unmanaged\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 27.0 cm\r\n- Number of trees BHD >= 12 cm (2011): 1130\r\n- Maximum tree age: Castanea sativa 90 yr- Betula pendula 70 yr - Quercus cerris 70 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/novaggio.html\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "6391becd-e201-41bb-93e5-3e50b1b50c83",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "ebb37e73-1280-4a06-81d8-e18bc5d9c1cf",
                    "metadata_created": "2019-10-31T15:28:32.397915",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:13:36.026288",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [8.2267566,47.3995354]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Othmarsingen long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1994-09-09\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-othmarsingen-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/ebb37e73-1280-4a06-81d8-e18bc5d9c1cf/resource/64291bfd-37d4-4f88-b505-81fc85a109c2/download/lwf_othmarsingen.jpg \"LWF Othmarsingen\")\r\n\r\nLWF Plot Othmarsingen\r\n\r\n- Community: Othmarsingen / canton AG\r\n- Date of installation: 9 September 1994\r\n- Size of the plot: 1 ha\r\n- Altitude (m): 467-500\r\n- Mean slope: 27%\r\n- Soil types (WSL): Stagnic Luvisols, Haplic Luvisols\r\n- Woodland association after EK72: 7: Galio odorati-Fagetum typicum\r\n- Main tree species: Fagus sylvatica\r\n- Management system: former coppices w. standards\r\n- Silvicultural system: group selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 62.8 cm\r\n- Number of trees BHD >= 12 cm (2011): 167\r\n- Maximum tree age: Fagus sylvatica 120-140 yr - Tilia sp. 120-140 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/othmarsingen.html",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "c4e8b896-9390-4a8d-ac5e-fc14ad9bbfde",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "b21e7c90-7d1f-4940-82ab-d29c0dcf5fcf",
                    "metadata_created": "2019-10-31T15:53:13.253450",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:13:30.087895",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.0670726,47.1650464]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Schänis long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1997-09-17\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-schanis-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/b21e7c90-7d1f-4940-82ab-d29c0dcf5fcf/resource/5b41f2a1-847f-4a0f-aa48-cd530ace3827/download/lwf_schaenis.jpg \"LWF Schänis\")\r\n\r\nLWF Plot Schänis\r\n\r\n- Community: Schänis / canton SG\r\n- Date of installation: 17 September 1997\r\n- Size of the plot: 2 ha\r\n- Altitude: 693-773 m\r\n- Mean slope: 60%\r\n- Geology (in German): Tertiär. Subalpine Molasse, Oligocaen, Chattien, Kalknagelfluh\r\n- Soil types (WSL) : n.d.\r\n- Woodland association after EK72: 13: Cardamino-Fagetum tilietosum\r\n- Main tree species: Fagus sylvatica\r\n- Management system: high forest\r\n- Silvicultural system: group selection\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 55.8 cm\r\n- Number of trees BHD >= 12 cm (2011): 611\r\n- Maximum tree age: Abies alba130-150 yr - Fraxinus excelsior 130-150 yr - Fagus sylvatica 130-150 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/schaenis.html\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "39c3700b-c9ea-4918-806c-e774cbff2dba",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"identifier\": \"\", \"given_name\": \"Peter\", \"name\": \"Waldner\", \"email\": \"peter.waldner@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 7,
                    "subtitle": "",
                    "id": "1a43f9fa-e36c-46b9-a409-367fce3ce48b",
                    "metadata_created": "2019-11-01T07:38:38.647481",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"EnviDat\", \"publication_year\": \"2019\"}",
                    "metadata_modified": "2019-11-05T12:13:23.543841",
                    "author": "[{\"name\": \"Sutter\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Flurin\", \"identifier\": \"0000-0001-6201-5791\", \"email\": \"flurin.sutter@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"data_credit\": [\"publication\", \"supervision\"], \"affiliation\": \"Swiss Federal Institute for Forest Snow and Landscape Research WSL, Zuercherstrasse 111, 8903 Birmensdorf, Switzerland\", \"affiliation_03\": \"\", \"given_name\": \"Peter\", \"identifier\": \"\", \"email\": \"peter.waldner@wsl.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [7.8583245,46.2968789]}",
                    "license_id": "wsl-data",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "LWF Visp long-term research site",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "7572b438-f502-4e11-b221-cb5f95d75d7c",
                    "date": "[{\"date\": \"1996-05-13\", \"date_type\": \"collected\", \"end_date\": \"2045-01-01\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-visp-long-term-research-site",
                    "publication_state": "",
                    "doi": "",
                    "isopen": false,
                    "language": "en",
                    "url": null,
                    "notes": "![alt text](https://www.envidat.ch/dataset/1a43f9fa-e36c-46b9-a409-367fce3ce48b/resource/757c846b-c266-4fd4-b6ad-5f5f327ffcb4/download/lwf_visp.jpg \"LWF Visp\")\r\n\r\nLWF Plot Visp\r\n\r\n- Community: Visp / canton VS\r\n- Date of installation: 13 March 1996\r\n- Size of the plot: 2 ha\r\n- Altitude: 657-733 m\r\n- Mean slope: 80%\r\n- Geology (in German): Penninikum, Jura, Bündnerschiefer; Kalkphyllite, Hängeschutt\r\n- Provisional soil type (WSL): Calcaric Cambisol\r\n- Woodland association after EK72: =~= 38: Arabidi turritae-Quercetum pubescentis\r\n- Main tree species: Pinus sylvestris\r\n- Management system: high forest\r\n- Silvicultural system: unmanaged\r\n- Top-height diameter (quadratic average diameter of the 100 thickest trees per ha): 53.9 cm\r\n- Number of trees BHD >= 12 cm (2011): 650\r\n- Maximum tree age: Pinus sylvestris uneven-aged 40-80 yr\r\n\r\nMore Information: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf/sites/visp.html\r\n",
                    "license_title": "WSL Data Policy",
                    "license_url": "https://www.wsl.ch/en/about-wsl/programmes-and-initiatives/envidat.html",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "9a149886-e291-49ae-b3a0-5b7e7a75125c",
                    "resource_type": "Dataset"
                },
                {
                    "owner_org": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                    "maintainer": "{\"affiliation\": \"LTER national representative\", \"identifier\": \"\", \"given_name\": \"Marcus\", \"name\": \"Schaub\", \"email\": \"marcus.schaub@wsl.ch\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 9,
                    "subtitle": "",
                    "id": "4039ffb0-bd4b-4e15-ab00-dca5ae5b2b37",
                    "metadata_created": "2018-03-29T13:23:37.454737",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"WSL\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"Swiss Federal Research Institute WSL\", \"publication_year\": \"2018\"}",
                    "metadata_modified": "2019-11-03T16:51:19.237384",
                    "author": "[{\"name\": \"Didion\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Markus\", \"identifier\": \"0000-0003-0346-0646\", \"email\": \"markus.didion@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Sutter\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"flurin.sutter@wsl.ch\", \"given_name\": \"Flurin\"}, {\"name\": \"Vollenweider\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Pierre\", \"identifier\": \"\", \"email\": \"pierre.vollenweider@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Gessler\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"given_name\": \"Arthur\", \"identifier\": \"\", \"email\": \"arthur.gessler@wsl.ch\", \"affiliation_02\": \"\"}, {\"name\": \"Waldner\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"pater.waldner@wsl.ch\", \"given_name\": \"Peter\"}, {\"name\": \"Schaub\", \"affiliation\": \"WSL\", \"affiliation_03\": \"\", \"affiliation_02\": \"\", \"identifier\": \"\", \"email\": \"marcus.schaub@wsl.ch\", \"given_name\": \"Marcus\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{  \"type\": \"MultiPoint\",  \"coordinates\": [       [7.886764,47.274064],[7.416653,47.225156],[7.612108,46.302789],[8.834161,46.022611],[7.762336,46.700344],[9.067072,47.165047],[8.454444,47.361944],[7.584333,46.318667]    ]      }",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 1,
                    "title": "LWF-Tea bag sites",
                    "spatial_info": "Switzerland",
                    "creator_user_id": "ca5540f3-3bdd-430c-99d0-681dcf2abbae",
                    "date": "[{\"date\": \"2016-01-06\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "lwf-tea-bag-sites",
                    "publication_state": "published",
                    "doi": "10.16904/envidat.36",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Decomposition of plant litter is a key process for the transfer of carbon and nutrients in ecosystems. Carbon contained in the decaying biomass is released to the atmosphere as respired CO2, and may contribute to global warming. Litterbag studies have been used to improve our knowledge of the drivers of litter decomposition, but they lack comparability because litter quality is plant species-specific. The use of commercial tea bags as a standard substrate was suggested in order to harmonize studies, where green tea and rooibos represent more labile and more recalcitrant C compounds as surrogates of local litter.\r\nThe tea bag approach was implemented on eight sites of the Swiss long-term Forest Ecosystem Research (LWF) network (https://www.wsl.ch/LWF). This allowed us to take advantage from the existing infrastructure and data from a previous litterbag study with local litter. In Beatenberg and Schaenis, additional elevation transects were established (1200-1800 m and 540-1150 m, respectively) to examine particularly the effect of temperature on decomposition. In Pfynwald (https://www.wsl.ch/de/ueber-die-wsl/versuchsanlagen-und-labors/flaechen-im-wald/pfynwald.html) and Salgesch, infrastructure of running projects was used to examine the effect of drought and understory removal, respectively. In Novaggio, tea bags were incubated in summer and winter to study the effect of seasonality particularly precipitation. Tea bags are collected after 3, 12, 24, and 36 months; for the two time-shifted experiments additionally after 6 and 9 months.\r\nThe study has two primary objectives. Firstly, it contributes to TeaComposition initiative (http://teacomposition.org/) which aims at investigating long-term litter decomposition and its key drivers at present as well as under different future climate scenarios using a common protocol and standard litter (tea) across nine terrestrial biomes. Secondly, the data are used to further develop decomposition models such as Yasso (http://en.ilmatieteenlaitos.fi/yasso) which is used by several countries, including Switzerland to estimate the annual carbon fluxes in dead wood, litter, and soil for reporting in National Greenhouse Gas Inventories under the United Nations Framework Convention on Climate Change and the Kyoto Protocol.\r\n",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "__Air pollution and climate change have an effect on the forest. We examine these effects as part of the Long-Term Forest Ecosystem Research (LWF) programme.__\r\n\r\nWe need reliable information in order to record the condition of the forest on an ongoing basis and to understand precisely what happens in the forest when the environment changes. An important source of data here is the Long-Term Forest Ecosystem Research (LWF) programme. It consists of 19 permanent monitoring sites on which we have regularly carried out numerous measurements since 1994. We have also been recording the health of trees on the monitoring sites of the Sanasilva Inventory, which is part of the LWF programme (see Sites), since 1985.\r\n\r\nWe disclose the gathered data, as well as the scientific interpretation of this data, to national and international decision-makers.\r\n\r\nWith the legally enshrined functions of the LWF programme, Switzerland participates in international research programmes such as the \"International Co-operative Programme on Assessment and Monitoring of Air Pollution Effects on Forests\" ICP Forests and the LTER-Europe Network (Long-Term Ecosystem Research in Europe).\r\n\r\nThe Long-term Forest Ecosystem Research (LWF) programme is run and financed by the WSL.\r\n \r\n### Objectives of the programme\r\n\r\n *   Early detection and a representative assessment of changes in forest condition\r\n *   Determination of external influences, both from anthropogenic and natural sources and their effect on the forest ecosystem (element inputs, climate)\r\n *    Determination of changes in important components within the forest ecosystem\r\n *   Development of indicators to assess the condition of the forest\r\n *   Integrated risk assessment based on different stress scenarios\r\n *   Extended platform for internal and external research projects\r\n\r\n__Further information__: https://www.wsl.ch/en/forest/forest-development-and-monitoring/long-term-forest-ecosystem-research-lwf.html",
                        "created": "2016-11-09T11:47:45.334341",
                        "title": "LWF",
                        "name": "lwf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2019-08-20-143501.216961lwflogo.png",
                        "revision_id": "09495596-1079-42b1-867c-024c79293353",
                        "type": "organization",
                        "id": "0763c98e-6fba-4f5f-bf83-c4d37f19bd6e",
                        "approval_status": "approved"
                    },
                    "revision_id": "e7cf96be-ec30-486a-94d3-cea90fe4a07f",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "18c1d406-c1a6-47de-909a-2f69948fb2af",
            "approval_status": "approved"
        },
        {
            "display_name": "Vegetation module (WBS)",
            "description": "The sub-sample of all sites of national importance was selected using a stratified random sampling design, weighting rare vegetation types higher than common ones to ensure a more evenly representation of vegetation types among bio-geographical regions and along elevational gradients. The sample includes approximately 400 dry grassland sites, 260 bogs and fens, and 125 riparian areas and flood plains of national importance. In total, more than 7000 permanently marked circular 10 m2 plots were established in the first sampling period from (2011 to 2017). In all these plots all vascular plants are sampled every six years. In addition, in riparian areas and flood plains, shrubs and trees are sampled in a second 200 m2 plot (concentric with the 10 m2 plot). In fens and bogs, beside vascular plants soil-dwelling bryophytes (i.e. mosses, liverworts, hornworts) are recorded. \r\nThe floristic data is also transferred to the national data centers, i.e. Info Flora (National data center of the Swiss flora) and Swiss Bryophytes (National data center of Swiss bryophytes) and used for other national projects, such as the national Red List of Endangered species programs. In addition, data are available for specific research projects on request. \r\nUsing the same sampling methods in all habitat types allows the comparison among vegetation types. Moreover, these methods correspond to the ones of other national monitoring programs, i.e., the Swiss Biodiversity Monitoring (BDM) and the agro-environmental monitoring (ALL-EMA). The three monitoring projects complement each other perfectly. While BDM reflects a random picture of the ‘normal landscape’ of Switzerland (including settlements) and ALL-EMA covers a wide range of (mesic) agriculturally used grasslands with different land-use intensities, WBS mirrors rare vegetation types with diverse ecological conditions, i.e. protected areas from dry steppe habitat types in the inner-alpine dry valleys over dry to mesic agriculturally used grasslands to wetlands, fens and bogs. Thus, the whole ecological and land-use intensity gradient of various habitat types in Switzerland is covered, allowing synthesis analyses to answer more general questions.\r\n",
            "image_display_url": "https://www.envidat.ch/uploads/group/2019-09-04-114151.02183520190710w1977.jpg",
            "package_count": 0,
            "created": "2019-09-02T15:42:02.975326",
            "name": "wbs-vegetation-module",
            "is_organization": false,
            "state": "active",
            "extras": [
                {
                    "value": "Monitoring the Effectiveness of Habitat Conservation in Switzerland (WBS)",
                    "state": "active",
                    "key": "parent",
                    "revision_id": "744ca754-aec9-4e3c-ad51-f83f2a8bb5c1",
                    "group_id": "3508550d-58a6-4d2f-b2fc-e5d15685e5ae",
                    "id": "f96274ce-b3b0-4cc2-b404-a40e6b9175cc"
                }
            ],
            "image_url": "2019-09-04-114151.02183520190710w1977.jpg",
            "groups": [],
            "type": "group",
            "title": "Vegetation module (WBS)",
            "revision_id": "d4b6a4fd-1aa6-4f4e-a714-23a6e25606db",
            "packages": [],
            "num_followers": 0,
            "id": "3508550d-58a6-4d2f-b2fc-e5d15685e5ae",
            "approval_status": "approved"
        },
        {
            "display_name": "Weissfluhjoch Research Site",
            "description": "The institute's former main building on the Weissfluhjoch remains at its disposal for research purposes. The test site below the building is the [SLF's](http://www.envidat.ch/organization/slf) oldest and equipped with numerous measuring instruments.\r\n\r\n## Globally unrivalled serial measurements\r\nIn autumn 1936, the Expert Commission for Snow and Avalanche Research (now the SLF) in Switzerland built the first snow laboratory on the Weissfluhjoch. Since these early days, SLF employees have been observing the weather and snow conditions on the adjacent test site daily. The site is located on a flat area of the Dorftälli, approximately 150 m below the Weissfluhjoch towards Davos, at an altitude of 2540 m. In view of the good accessibility and the numerous avalanche-prone slopes in the vicinity, researchers have conducted countless major experiments and studies here in the fields of snow mechanics, snow metamorphism, snow characterisation and measuring methodology. They have also tested the prototypes of various instruments, calibrated remote sensing products, and used the data collected at the test site to compare their snowpack models with those of other scholars.\r\nThe Weissfluhjoch test site is now the only one in the world at this altitude that has a daily record of snow depths and snowfall dating back more than 70 years.\r\n\r\n__More information:__ http://www.slf.ch/ueber/standorte/weissfluhjoch/index_EN",
            "image_display_url": "https://www.envidat.ch/uploads/group/2017-03-03-100909.757321VersuchsfeldWeissfluhjoch.png",
            "package_count": 3,
            "created": "2017-03-03T09:55:05.962249",
            "name": "weissfluhjoch-research-site",
            "is_organization": false,
            "state": "active",
            "extras": [],
            "image_url": "2017-03-03-100909.757321VersuchsfeldWeissfluhjoch.png",
            "groups": [],
            "type": "group",
            "title": "Weissfluhjoch Research Site",
            "revision_id": "8baae23f-6acc-479a-becc-1daea2c5f80e",
            "packages": [
                {
                    "owner_org": "a17b145f-2191-4c21-aabf-55661d5cb140",
                    "maintainer": "{\"affiliation\": \"SLF\", \"email\": \"wever@slf.ch\", \"identifier\": \"\", \"given_name\": \"Nander\", \"name\": \"Wever\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": "joel@slf.ch",
                    "num_tags": 9,
                    "subtitle": "",
                    "id": "38112bee-f865-4b29-ba19-47a99ba78833",
                    "metadata_created": "2016-05-25T15:07:58.297238",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"WSL Institute for Snow and Avalanche Research SLF\", \"publication_year\": \"2017\"}",
                    "metadata_modified": "2019-11-14T08:25:47.332210",
                    "author": "[{\"name\": \"Weber\", \"affiliation\": \"SLF\", \"affiliation_03\": \"\", \"given_name\": \"Nander\", \"identifier\": \"\", \"email\": \"nander.wever@slf.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": "info@slf.ch",
                    "state": "active",
                    "version": "1",
                    "spatial": "{\"type\":\"Point\", \"coordinates\":[ 9.809568, 46.829598]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 12,
                    "title": "WFJ_MOD: Meteorological and snowpack measurements from Weissfluhjoch, Davos, Switzerland",
                    "spatial_info": "[46.829598 9.809568]",
                    "creator_user_id": "334cee1e-6afa-4639-88a2-f980e6ff42c3",
                    "date": "[{\"date\": \"1996-09-01\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "10-16904-1",
                    "publication_state": "published",
                    "doi": "10.16904/1",
                    "isopen": true,
                    "language": "en",
                    "url": "http://www.envidat.ch/catalogue/10.16904/1",
                    "notes": "Dataset of meteorological and snowpack measurements from the automatic weather station at Weissfluhjoch, Davos, Switzerland, suitable for driving snowpack models. The dataset contains standard meteorological measurements, and additionally snowpack runoff data from a snow lysimeter. Where possible, data is quality checked and missing data are replaced from backup sensors from the measurement site itself, or (in only a few cases) from the MeteoSwiss weather station at 470 m distance and 150 m above the measurement site. \r\n\r\n__Publication__\r\nWever, N., Schmid, L., Heilig, A., Eisen, O., Fierz, C., and Lehning, M. Verification of the multi-layer SNOWPACK model with different water transport schemes. 2015. The Cryosphere. Volume 9. 2271-2293. http://dx.doi.org/10.5194/tc-9-2271-2015. 10.5194/tc-9-2271-2015\r\n",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The WSL Institute for Snow and Avalanche Research SLF is an interdisciplinary research and service centre located in Davos Dorf. It forms part of the WSL – the Swiss Federal Institute for Forest, Snow and Landscape Research – and thus belongs to the domain of the ETH (Swiss Federal Institutes of Technology). Its scientists conduct research on snow, the atmosphere, natural hazards, permafrost and mountain ecological systems, and develop innovative products that translate their knowledge into practical applications. The SLF seeks to engage in top-level research while contributing to the resolution of urgent societal issues, for example in the fields of natural hazard warning systems and the analysis of climate and environmental change. \r\n\r\n__Further information__: https://www.slf.ch",
                        "created": "2016-05-24T16:15:21.861195",
                        "title": "SLF",
                        "name": "slf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2016-05-24-141521.837240logoslf.png",
                        "revision_id": "9018b3a8-6928-4cc0-b5ed-64091418ffd2",
                        "type": "organization",
                        "id": "a17b145f-2191-4c21-aabf-55661d5cb140",
                        "approval_status": "approved"
                    },
                    "revision_id": "7369cadb-3b2a-408c-b477-431425a0c097",
                    "resource_type": "Measurements"
                },
                {
                    "owner_org": "72a2ca75-fa5c-411c-bfa9-1edbbbede2ae",
                    "maintainer": "{\"affiliation\": \"SLF\", \"email\": \"nander.wever@slf.ch\", \"identifier\": \"\", \"given_name\": \"Nander\", \"name\": \"Wever \"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "0b294122-015c-46bf-b5c5-cc6d0a6f67c1",
                    "metadata_created": "2016-10-16T21:39:20.449911",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"WSL Institute for Snow and Avalanche Research SLF\", \"publication_year\": \"2016\"}",
                    "metadata_modified": "2019-10-31T22:57:38.264353",
                    "author": "[{\"name\": \"WSL Institute for Snow and Avalanche Research SLF\", \"affiliation\": \"SLF\", \"affiliation_03\": \"\", \"given_name\": \"\", \"identifier\": \"\", \"email\": \"nander.wever@slf.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1",
                    "spatial": "{\"type\":\"Point\", \"coordinates\":[ 9.809568, 46.829598]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 2,
                    "title": "Manual bi-weekly snow profiles from Weissfluhjoch, Davos, Switzerland",
                    "spatial_info": "[46.829598 9.809568]",
                    "creator_user_id": "334cee1e-6afa-4639-88a2-f980e6ff42c3",
                    "date": "[{\"date\": \"2018-07-06\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "10-16904-2",
                    "publication_state": "published",
                    "doi": "10.16904/2",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Dataset of manual bi-weekly snow profiles from Weissfluhjoch, Davos, Switzerland. Typical snow profile measurements and observations are included (temperature, density, grain size, grain type, hardness, wetness), following the guidelines of the The International Classification for Seasonal Snow on the Ground (ICSSG) [Fierz, C., Armstrong, R.L., Durand, Y., Etchevers, P., Greene, E., McClung, D.M., Nishimura, K., Satyawali, P.K. and Sokratov, S.A. 2009. The International Classification for Seasonal Snow on the Ground. IHP-VII Technical Documents in Hydrology N°83, IACS Contribution N°1, UNESCO-IHP, Paris]. \r\n\r\n",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The meteorological conditions governing winter sports are influenced by both the natural variability of the climate and the climatic changes induced by mankind. We need data and models in order to visualise the current and future snow situation, and to show the potential of possible intervention strategies. For this reason, the group’s principal fields of activity encompass snow management, including piste preparation and snow farming, snowpack modelling (SNOWPACK and A3D), as well as snow climatological analyses and scenarios.",
                        "created": "2018-11-15T15:29:17.561586",
                        "title": "Winter Sports and Climate",
                        "name": "snow-sports",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "https://www.envidat.ch/uploads/group/2016-05-24-141521.837240logoslf.png",
                        "revision_id": "74274931-f3b3-4268-a522-ed90c47c764b",
                        "type": "organization",
                        "id": "72a2ca75-fa5c-411c-bfa9-1edbbbede2ae",
                        "approval_status": "approved"
                    },
                    "revision_id": "99ca6b2d-ac44-4462-848c-9440bafaab4d",
                    "resource_type": "Snow Profile Measurements"
                },
                {
                    "owner_org": "a17b145f-2191-4c21-aabf-55661d5cb140",
                    "maintainer": "{\"affiliation\": \"WSL Institute for Snow and Avalanche Research SLF \", \"email\": \"marty@slf.ch\", \"identifier\": \"\", \"given_name\": \"Christoph\", \"name\": \"Marty\"}",
                    "relationships_as_object": [],
                    "private": false,
                    "maintainer_email": null,
                    "num_tags": 5,
                    "subtitle": "",
                    "id": "99a619e2-5c9e-48c5-bcc6-6d8bab8b5709",
                    "metadata_created": "2016-12-02T14:54:17.544330",
                    "funding": "[{\"grant_number\": \"\", \"institution\": \"Funding information not available.\", \"institution_url\": \"\"}]",
                    "publication": "{\"publisher\": \"WSL Institute for Snow and Avalanche Research SLF \", \"publication_year\": \"2016\"}",
                    "metadata_modified": "2019-10-25T02:07:45.728597",
                    "author": "[{\"name\": \"Marty\", \"affiliation\": \"WSL Institute for Snow and Avalanche Research SLF \", \"affiliation_03\": \"\", \"given_name\": \"Christoph\", \"identifier\": \"\", \"email\": \"marty@slf.ch\", \"affiliation_02\": \"\"}]",
                    "author_email": null,
                    "state": "active",
                    "version": "1.0",
                    "spatial": "{\"type\": \"Point\", \"coordinates\": [9.809204,46.829631]}",
                    "license_id": "odc-odbl",
                    "type": "dataset",
                    "related_publications": "",
                    "num_resources": 4,
                    "title": "ASRB_WFJVF: Shortwave and longwave radiation measurements (2 min) at the Weissfluhjoch research site, Davos",
                    "spatial_info": "",
                    "creator_user_id": "fe7fa798-2f5c-4ad3-b865-50260d7322cf",
                    "date": "[{\"date\": \"1996-01-01\", \"date_type\": \"created\", \"end_date\": \"\"}]",
                    "resource_type_general": "dataset",
                    "relationships_as_subject": [],
                    "name": "asrb-vf",
                    "publication_state": "",
                    "doi": "",
                    "isopen": true,
                    "language": "en",
                    "url": null,
                    "notes": "Incoming and outgoing  shortwave and longwave 2 min radiation measurements at the Weissfluhjoch research site, Davos, CH. The experimental site at the Weissfluhjoch (WFJ, 46.83 N, 9.81 E) is located at an altitude of 2540 m in the Swiss Alps near Davos. During the winter months, almost all precipitation falls as snow at this altitude. As a consequence, a continuous seasonal snow cover builds up every winter, with a maximum snow height ranging from 153–366 cm over the period 1934–2012. The measurement site is located in an almost flat part of a southeast oriented slope.\r\n\r\n### References\r\n1. Marty, C., Philipona, R., Frohlich, C., Ohmura, A.. Altitude dependence of surface radiation fluxes and cloud forcing in the alps: results from the alpine surface radiation budget network. 2002. Theoretical and Applied Climatology. Volume 72. Issue 3-4. 137-155. http://dx.doi.org/10.1007/s007040200019. 10.1007/s007040200019.\r\n2. Christoph Marty. Surface Radiation, Cloud Forcing and Greenhouse Effect in the Alps. 2000. Institute fuer Klimaforschung ETH. Zuercher Klima-Schriften. Volume 79. http://e-collection.library.ethz.ch/eserv/eth:23491/eth-23491-01.pdf.\r\n",
                    "license_title": "ODbL with Database Contents License (DbCL)",
                    "license_url": "https://opendefinition.org/licenses/odc-odbl",
                    "organization": {
                        "description": "The WSL Institute for Snow and Avalanche Research SLF is an interdisciplinary research and service centre located in Davos Dorf. It forms part of the WSL – the Swiss Federal Institute for Forest, Snow and Landscape Research – and thus belongs to the domain of the ETH (Swiss Federal Institutes of Technology). Its scientists conduct research on snow, the atmosphere, natural hazards, permafrost and mountain ecological systems, and develop innovative products that translate their knowledge into practical applications. The SLF seeks to engage in top-level research while contributing to the resolution of urgent societal issues, for example in the fields of natural hazard warning systems and the analysis of climate and environmental change. \r\n\r\n__Further information__: https://www.slf.ch",
                        "created": "2016-05-24T16:15:21.861195",
                        "title": "SLF",
                        "name": "slf",
                        "is_organization": true,
                        "state": "active",
                        "image_url": "2016-05-24-141521.837240logoslf.png",
                        "revision_id": "9018b3a8-6928-4cc0-b5ed-64091418ffd2",
                        "type": "organization",
                        "id": "a17b145f-2191-4c21-aabf-55661d5cb140",
                        "approval_status": "approved"
                    },
                    "revision_id": "ed91b1ba-11b5-417d-9fc3-f218ca0bea52",
                    "resource_type": "Dataset"
                }
            ],
            "num_followers": 0,
            "id": "cd62b669-a153-4caa-bbf3-a167f8f1a83d",
            "approval_status": "approved"
        }
    ]
};