	SUBROUTINE GETTBH ( LUNS, LUNL, TAB, IMT, IMTV, IOGCE, ILTV )

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    GETTBH
C   PRGMMR: ATOR            ORG: NP12       DATE: 2007-01-19
C
C ABSTRACT:  THIS SUBROUTINE READS AND PARSES THE HEADER LINES FROM TWO
C   SEPARATE (I.E. ONE STANDARD AND ONE LOCAL) ASCII FILES CONTAINING
C   EITHER MASTER TABLE B OR MASTER TABLE D INFORMATION.
C
C PROGRAM HISTORY LOG:
C 2007-01-19  J. ATOR    -- ORIGINAL AUTHOR
C
C USAGE:    CALL GETTBH ( LUNS, LUNL, TAB, IMT, IMTV, IOGCE, ILTV )
C
C   INPUT ARGUMENT LIST:
C     LUNS     - INTEGER: FORTRAN LOGICAL UNIT NUMBER OF ASCII FILE
C                CONTAINING STANDARD TABLE INFORMATION
C     LUNL     - INTEGER: FORTRAN LOGICAL UNIT NUMBER OF ASCII FILE
C                CONTAINING LOCAL TABLE INFORMATION
C     TAB      - CHARACTER*1: TABLE TYPE ('B' OR 'D')
C
C   OUTPUT ARGUMENT LIST:
C     IMT      - INTEGER: MASTER TABLE, READ FROM EACH ASCII FILE
C                (NOTE: THESE VALUES MUST BE THE SAME IN EACH FILE!)
C     IMTV     - INTEGER: VERSION NUMBER OF MASTER TABLE, READ FROM
C                STANDARD ASCII FILE
C     IOGCE    - INTEGER: ORIGINATING CENTER, READ FROM LOCAL ASCII FILE
C     ILTV     - INTEGER: VERSION NUMBER OF LOCAL TABLE, READ FROM
C                LOCAL ASCII FILE
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT     IGETNTBL PARSTR   VALX
C    THIS ROUTINE IS CALLED BY: RDMTBB   RDMTBD
C                               Also called by application programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

	CHARACTER*128	BORT_STR
	CHARACTER*40	HEADER
	CHARACTER*30	TAGS(5), LABEL
	CHARACTER*3	CFTYP
	CHARACTER*2	CTTYP
	CHARACTER*1	TAB

	LOGICAL	BADLABEL

C-----------------------------------------------------------------------
C	Statement function to check for bad header line label:

	BADLABEL ( LABEL ) = ( ( INDEX ( LABEL, CTTYP ) .EQ. 0 ) .OR.
     .			       ( INDEX ( LABEL, CFTYP ) .EQ. 0 ) )
C-----------------------------------------------------------------------

	CTTYP = TAB // ' '

C	Read and parse the header line of the standard file.

	CFTYP = 'STD'
	IF ( IGETNTBL ( LUNS, HEADER ) .NE. 0 ) GOTO 900
	CALL PARSTR ( HEADER, TAGS, 5, NTAG, '|', .FALSE. )
	IF ( NTAG .LT. 3 ) GOTO 900
	IF ( BADLABEL ( TAGS(1) ) ) GOTO 900
	IMT = VALX ( TAGS(2) )
	IMTV = VALX ( TAGS(3) )
	
C	Read and parse the header line of the local file.

	CFTYP = 'LOC'
	IF ( IGETNTBL ( LUNL, HEADER ) .NE. 0 ) GOTO 900
	CALL PARSTR ( HEADER, TAGS, 5, NTAG, '|', .FALSE. )
	IF ( NTAG .LT. 4 ) GOTO 900
	IF ( BADLABEL ( TAGS(1) ) ) GOTO 900
	IMT2 = VALX ( TAGS(2) )
	IOGCE = VALX ( TAGS(3) )
	ILTV = VALX ( TAGS(4) )
	
C	Verify that both files are for the same master table.

	IF ( IMT .NE. IMT2 ) GOTO 901

	RETURN

 900	WRITE(BORT_STR,'("BUFRLIB: GETTBH - BAD OR MISSING HEADER '//
     .    'WITHIN ",A," TABLE ",A)') CFTYP, TAB
	CALL BORT(BORT_STR)
 901	WRITE(BORT_STR,'("BUFRLIB: GETTBH - MASTER TABLE NUMBER '//
     .    'MISMATCH BETWEEN STD AND LOC TABLE ",A)') TAB
	CALL BORT(BORT_STR)
	END
