!#include <define.h>
#ifdef WRF_CHEM
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
 module module_gocart_coupling

 implicit none

!---------------------------------------------------------------------
!              = Goddard Satellite Data Simulator Unit =
!
! 
! NASA GSFC makes no representations about the suitability of software for any purpose. 
! It is provided as is without express or implied warranty. Neither NASA GSFC (the US 
! government) nor Principal Developers (their organizations) shall be liable for any 
! damages suffered by the user of this software. In addition, please do not distribute 
! the software to third party.
!
!
! Comments; This module is an interface that bridge GOCART  & GCE or WRF to account for 
!      aerosol direct and indirect effect.
!
! 0. Change directory parameter gocart_dir = 'your directory'
!  
! a) Aerosol Direct Effect (this must call every radiation time step)
!
! aero_opt ( convert aerosol mass into aerosol single-scattering properties. )
!
!
! b) Aerosol Indirect Effect (initialize. Call just only once at the beggining.)
!
! * makelut_ccn_icn (Create CCN and IN candidate look-up table.)
!    |-ccn_estimate( estimate total number concentrations of CCN, IN )
!      |-convert_mass2number( Convert aerosol mass mixing ratio to number mixing ratio )
!      |-opac_log_normal_pdf( compute probability density per width )
!     
! 
!   Aerosol Indirect Effect (call every microphysics time step)
!
! * mass2ccn ( convert aerosol mass into the concentrations of cloud condensation nuclei )
!    |-interp(Interpolate CCN LUT for a given temperature and super saturation rate )
!
! * mass2icn ( convert aerosol mass into the concentrations of ice nuclei )
!
!
! History;
! 11/2017  Toshi Matsui@NASA GSFC : Removed GOCART read routines. 
! 11/2010  Toshi Matsui@NASA GSFC : Developed IN routine. 
! 10/2010  Toshi Matsui@NASA GSFC : Developed CCN routine.  
! 10/2008  Toshi Matsui@NASA GSFC ; Now it reads binary direct acess data with subset domain allocation
! 08/2008  Toshi Matsui@NASA GSFC ; Modified for 3hourly instantenous GOCART data  
! 06/2007  Toshi Matsui@NASA GSFC : add LW aerosol optical proproperties 
! 02/2007  Toshi Matsui@NASA GSFC ; initial, significant revision from code from H.Yu and M. Chin 
!----------------------------------------------------------------------

!
! Encapsulation control 
!
  private   ! encapsulate module parameters and subourtines.

!
! public (accessible) subroutine
!
  public ::  & 
                aero_opt, & ! compute spectrum aerosol optical depths
                mass2ccn, & ! convert GOCART aerosol mass into CCN #. 
                mass2icn, & ! convert GOCART aerosol mass into IN #.
         makelut_ccn_icn    ! make CCN look-up tables
! ##############################################################################

 logical,parameter :: gocart_verbose = .true.   !if true, it provides alot of run-time comments. 

! ##############################################################################

 integer   i,j,k,n,t,h  !local looping variables
 logical,save :: master !if true, this is master thread. 

!
! Mie table parameters
!
  integer :: nrs     !# of RH or sizes
  integer :: nh      !RH loop index
  integer :: nsize   !# of size for dust aerosols
  integer :: ai      !aerosol index
  integer,parameter :: nwl    = 11       !# of band in SW radiative transfer
  integer,parameter :: nwl_lw = 10       !# of band in LW radiative transfer
  integer,parameter,public :: tgmx = 14  !maximum # for aerosol type
  integer,parameter :: nrmx = 99         !maximu RH
  integer,parameter :: waven(nwl_lw) = (/250, 340, 540, 800, 980, 1100, &
                       1215, 1380, 1900, 3000/) ! Wavenumber intervals for goddard LW scheme
                                                ! It actually starts from 0 but adjusted for smallest value 
                                                ! in mie table (wn=250).  

  real,save :: Bex(tgmx,nwl,0:nrmx) ! SW Mass extinction coefficient [m2/g]
  real,save :: w0(tgmx,nwl,0:nrmx)  ! SW single scattering albedo [-]
  real,save :: g(tgmx,nwl,0:nrmx)   ! SW asymetry factor [-]

  real,save :: Bex_temp(tgmx,nwl,0:nrmx) ! temporary SW Mass extinction coefficient [m2/g]
  real,save :: w0_temp(tgmx,nwl,0:nrmx)  ! temporary SW single scattering albedo [-]
  real,save :: g_temp(tgmx,nwl,0:nrmx)   ! temporary SW asymetry factor [-]

  real,save :: Bex_lw(tgmx,nwl_lw,0:nrmx) ! LW Mass extinction coefficient [m2/g]
  real,save :: w0_lw(tgmx,nwl_lw,0:nrmx)  ! LW single scattering albedo [-]
  real,save :: g_lw(tgmx,nwl_lw,0:nrmx)   ! LW asymetry factor [-] 

  real,save :: Bex_lw_temp(tgmx,nwl_lw,0:nrmx) ! temporary LW Mass extinction coefficient [m2/g]
  real,save :: w0_lw_temp(tgmx,nwl_lw,0:nrmx)  ! temporary LW single scattering albedo [-]
  real,save :: g_lw_temp(tgmx,nwl_lw,0:nrmx)   ! temporary LW asymetry factor [-] 

  character :: aa*39   ! dummy character
  character :: at*4    ! aerosol types
  character*4,dimension(6),parameter :: mie_tbl = &
       (/'suso', 'waso', 'soot',  'ssam', 'sscm', 'dust'/)

!
! OPAC aerosol microphysics parameters
!
 type particle_opac !OPAC paticle type
    real :: inso,waso, soot, ssam, sscm, minm, miam, micm, mitr, suso
 end type particle_opac

 type ( particle_opac) :: & !
     std      ,&  ! standard deviation []
     r_mode   ,&  ! mode radius [micron]
     r_min    ,&  ! minmum radius [micron]
     r_max    ,&  ! maximum radius [micron]
     rho          ! density [g/cm3]


 real,parameter :: pi_const = 3.1415926535e0

!CCN IN LUT parameter

 integer, parameter :: mxpts_s  = 46  ! LUT dimension for super saturation 
 real, parameter :: pts_s(mxpts_s) = & ! LUT super saturation vector [%]
              (/ 1e-4, 2e-4, 3e-4, 4e-4, 5e-4, 6e-4, 7e-4, 8e-4, 9e-4,&
                 1e-3, 2e-3, 3e-3, 4e-3, 5e-3, 6e-3, 7e-3, 8e-3, 9e-3,&
                 1e-2, 2e-2, 3e-2, 4e-2, 5e-2, 6e-2, 7e-2, 8e-2, 9e-2,&
                 1e-1, 2e-1, 3e-1, 4e-1, 5e-1, 6e-1, 7e-1, 8e-1, 9e-1,&
                 1e-0, 2e-0, 3e-0, 4e-0, 5e-0, 6e-0, 7e-0, 8e-0, 9e-0,&
                 1e+1 /)

 integer, parameter :: mxpts_t  = 12  ! LUT dimension for temperature
 real, parameter :: pts_t(mxpts_t) = & ! LUT temperature vector [K] for frozen hydrometeors
                        (/ 140., 160., 180., 200., 220., 240., 260., 280., &
                           300., 320., 340., 360./)


 real :: lut_ccn(1:mxpts_t,1:mxpts_s,1:tgmx)  ! LUT for CCN # per unit mass mixing ratio
 real :: lut_in_025(1:tgmx) ! LUT for aerosol # per unit mass mixing ratio [#/cm3 per 1g/m3]


!
! gocart variables
!
  character(len=10)  :: varname   !gocart aerosol type
  character(len=100) :: fname_in  !gocart directly & input name

 real,parameter,public :: dust_frac(4)=(/ 0.01053,0.08421,0.25263,0.65263 /) !fraction for fine dust

 character*(*),parameter :: dir_direct = '/Users/matsui/Work/RADIATION/SDSU/GOCART/DIRECT/' !direct GOCART input


!
! Aerosol Optiocal Properties
! ai-> aerosol type index
!  1 = SO4      !sulfur and its precure
!  2 = BC1+BC2  !black carbon (soot)
!  3 = OC1      !non hygroscopic OC
!  4 = OC2      !hygroscopic OC
!  5 = SS1      !sea-salt accumulation mode
!  6 = SS2+SS3+SS4 !sea-salt coarse mode
!  7 = DU1      ! dust mode 1
!  8 = DU1      ! dust mode 2
!  9 = DU1      ! dust mode 3
! 10 = DU1      ! dust mode 4
! 11 = DU2      ! dust mode 5
! 12 = DU3      ! dust mode 6
! 13 = DU4      ! dust mode 7
! 14 = DU5      ! dust mode 8
!
 data (((Bex(ai,k,nh),ai= 1, 1),k=1,11),nh=0,99)/ &
 .5144E+01,.5144E+01,.5144E+01,.5081E+01,.4901E+01,.4655E+01,.4549E+01,.3187E+01,.1517E+01,.4026E+00,.2845E+00,&
 .5227E+01,.5227E+01,.5227E+01,.5165E+01,.4988E+01,.4739E+01,.4632E+01,.3251E+01,.1552E+01,.4136E+00,.2877E+00,&
 .5310E+01,.5310E+01,.5310E+01,.5249E+01,.5074E+01,.4823E+01,.4715E+01,.3315E+01,.1587E+01,.4246E+00,.2909E+00,&
 .5393E+01,.5393E+01,.5393E+01,.5332E+01,.5161E+01,.4906E+01,.4797E+01,.3379E+01,.1622E+01,.4357E+00,.2940E+00,&
 .5476E+01,.5476E+01,.5476E+01,.5416E+01,.5247E+01,.4990E+01,.4880E+01,.3443E+01,.1657E+01,.4467E+00,.2972E+00,&
 .5559E+01,.5559E+01,.5559E+01,.5500E+01,.5334E+01,.5074E+01,.4963E+01,.3507E+01,.1692E+01,.4577E+00,.3004E+00,&
 .5657E+01,.5657E+01,.5657E+01,.5595E+01,.5418E+01,.5157E+01,.5045E+01,.3577E+01,.1730E+01,.4700E+00,.3038E+00,&
 .5755E+01,.5755E+01,.5755E+01,.5689E+01,.5502E+01,.5239E+01,.5127E+01,.3647E+01,.1769E+01,.4824E+00,.3072E+00,&
 .5854E+01,.5854E+01,.5854E+01,.5784E+01,.5587E+01,.5322E+01,.5208E+01,.3716E+01,.1807E+01,.4947E+00,.3106E+00,&
 .5952E+01,.5952E+01,.5952E+01,.5878E+01,.5671E+01,.5404E+01,.5290E+01,.3786E+01,.1846E+01,.5071E+00,.3140E+00,&
 .6050E+01,.6050E+01,.6050E+01,.5973E+01,.5755E+01,.5487E+01,.5372E+01,.3856E+01,.1884E+01,.5194E+00,.3174E+00,&
 .6137E+01,.6137E+01,.6137E+01,.6063E+01,.5855E+01,.5584E+01,.5468E+01,.3926E+01,.1924E+01,.5326E+00,.3209E+00,&
 .6224E+01,.6224E+01,.6224E+01,.6154E+01,.5955E+01,.5681E+01,.5564E+01,.3996E+01,.1964E+01,.5458E+00,.3244E+00,&
 .6311E+01,.6311E+01,.6311E+01,.6244E+01,.6056E+01,.5778E+01,.5659E+01,.4067E+01,.2005E+01,.5590E+00,.3278E+00,&
 .6398E+01,.6398E+01,.6398E+01,.6335E+01,.6156E+01,.5875E+01,.5755E+01,.4137E+01,.2045E+01,.5722E+00,.3313E+00,&
 .6485E+01,.6485E+01,.6485E+01,.6425E+01,.6256E+01,.5972E+01,.5851E+01,.4207E+01,.2085E+01,.5854E+00,.3348E+00,&
 .6572E+01,.6572E+01,.6572E+01,.6512E+01,.6345E+01,.6060E+01,.5939E+01,.4286E+01,.2130E+01,.6005E+00,.3387E+00,&
 .6659E+01,.6659E+01,.6659E+01,.6600E+01,.6433E+01,.6148E+01,.6027E+01,.4366E+01,.2176E+01,.6156E+00,.3426E+00,&
 .6745E+01,.6745E+01,.6745E+01,.6687E+01,.6522E+01,.6237E+01,.6114E+01,.4445E+01,.2221E+01,.6307E+00,.3464E+00,&
 .6832E+01,.6832E+01,.6832E+01,.6775E+01,.6610E+01,.6325E+01,.6202E+01,.4525E+01,.2267E+01,.6458E+00,.3503E+00,&
 .6919E+01,.6919E+01,.6919E+01,.6862E+01,.6699E+01,.6413E+01,.6290E+01,.4604E+01,.2312E+01,.6609E+00,.3542E+00,&
 .7036E+01,.7036E+01,.7036E+01,.6974E+01,.6796E+01,.6512E+01,.6391E+01,.4687E+01,.2361E+01,.6776E+00,.3584E+00,&
 .7153E+01,.7153E+01,.7153E+01,.7085E+01,.6893E+01,.6612E+01,.6491E+01,.4771E+01,.2410E+01,.6943E+00,.3625E+00,&
 .7269E+01,.7269E+01,.7269E+01,.7197E+01,.6989E+01,.6711E+01,.6592E+01,.4854E+01,.2459E+01,.7110E+00,.3667E+00,&
 .7386E+01,.7386E+01,.7386E+01,.7308E+01,.7086E+01,.6811E+01,.6692E+01,.4938E+01,.2508E+01,.7277E+00,.3708E+00,&
 .7503E+01,.7503E+01,.7503E+01,.7420E+01,.7183E+01,.6910E+01,.6793E+01,.5021E+01,.2557E+01,.7444E+00,.3750E+00,&
 .7593E+01,.7593E+01,.7593E+01,.7518E+01,.7301E+01,.7023E+01,.6904E+01,.5109E+01,.2610E+01,.7627E+00,.3795E+00,&
 .7684E+01,.7684E+01,.7684E+01,.7615E+01,.7419E+01,.7136E+01,.7015E+01,.5196E+01,.2663E+01,.7810E+00,.3840E+00,&
 .7774E+01,.7774E+01,.7774E+01,.7713E+01,.7537E+01,.7250E+01,.7126E+01,.5284E+01,.2715E+01,.7994E+00,.3885E+00,&
 .7865E+01,.7865E+01,.7865E+01,.7810E+01,.7655E+01,.7363E+01,.7237E+01,.5371E+01,.2768E+01,.8177E+00,.3930E+00,&
 .7955E+01,.7955E+01,.7955E+01,.7908E+01,.7773E+01,.7476E+01,.7348E+01,.5459E+01,.2821E+01,.8360E+00,.3975E+00,&
 .8057E+01,.8057E+01,.8057E+01,.8008E+01,.7868E+01,.7573E+01,.7447E+01,.5555E+01,.2878E+01,.8560E+00,.4023E+00,&
 .8159E+01,.8159E+01,.8159E+01,.8108E+01,.7963E+01,.7671E+01,.7545E+01,.5650E+01,.2935E+01,.8761E+00,.4072E+00,&
 .8260E+01,.8260E+01,.8260E+01,.8208E+01,.8058E+01,.7768E+01,.7644E+01,.5746E+01,.2992E+01,.8961E+00,.4120E+00,&
 .8362E+01,.8362E+01,.8362E+01,.8308E+01,.8153E+01,.7866E+01,.7742E+01,.5841E+01,.3049E+01,.9162E+00,.4169E+00,&
 .8464E+01,.8464E+01,.8464E+01,.8408E+01,.8248E+01,.7963E+01,.7841E+01,.5937E+01,.3106E+01,.9362E+00,.4217E+00,&
 .8591E+01,.8591E+01,.8591E+01,.8531E+01,.8360E+01,.8079E+01,.7958E+01,.6030E+01,.3165E+01,.9574E+00,.4267E+00,&
 .8718E+01,.8718E+01,.8718E+01,.8654E+01,.8473E+01,.8195E+01,.8076E+01,.6123E+01,.3224E+01,.9785E+00,.4318E+00,&
 .8845E+01,.8845E+01,.8845E+01,.8778E+01,.8585E+01,.8311E+01,.8193E+01,.6217E+01,.3282E+01,.9997E+00,.4368E+00,&
 .8972E+01,.8972E+01,.8972E+01,.8901E+01,.8698E+01,.8427E+01,.8311E+01,.6310E+01,.3341E+01,.1021E+01,.4419E+00,&
 .9099E+01,.9099E+01,.9099E+01,.9024E+01,.8810E+01,.8543E+01,.8428E+01,.6403E+01,.3400E+01,.1042E+01,.4469E+00,&
 .9194E+01,.9194E+01,.9194E+01,.9128E+01,.8939E+01,.8665E+01,.8547E+01,.6506E+01,.3465E+01,.1066E+01,.4525E+00,&
 .9289E+01,.9289E+01,.9289E+01,.9232E+01,.9068E+01,.8787E+01,.8667E+01,.6609E+01,.3530E+01,.1089E+01,.4581E+00,&
 .9385E+01,.9385E+01,.9385E+01,.9336E+01,.9196E+01,.8910E+01,.8786E+01,.6712E+01,.3595E+01,.1113E+01,.4637E+00,&
 .9480E+01,.9480E+01,.9480E+01,.9440E+01,.9325E+01,.9032E+01,.8906E+01,.6815E+01,.3660E+01,.1136E+01,.4693E+00,&
 .9575E+01,.9575E+01,.9575E+01,.9544E+01,.9454E+01,.9154E+01,.9025E+01,.6918E+01,.3725E+01,.1160E+01,.4749E+00,&
 .9688E+01,.9688E+01,.9688E+01,.9655E+01,.9557E+01,.9261E+01,.9134E+01,.7029E+01,.3795E+01,.1186E+01,.4809E+00,&
 .9801E+01,.9801E+01,.9801E+01,.9766E+01,.9659E+01,.9368E+01,.9242E+01,.7140E+01,.3864E+01,.1212E+01,.4870E+00,&
 .9914E+01,.9914E+01,.9914E+01,.9878E+01,.9762E+01,.9474E+01,.9351E+01,.7251E+01,.3934E+01,.1237E+01,.4930E+00,&
 .1003E+02,.1003E+02,.1003E+02,.9989E+01,.9864E+01,.9581E+01,.9459E+01,.7362E+01,.4003E+01,.1263E+01,.4991E+00,&
 .1014E+02,.1014E+02,.1014E+02,.1010E+02,.9967E+01,.9688E+01,.9568E+01,.7473E+01,.4073E+01,.1289E+01,.5051E+00,&
 .1028E+02,.1028E+02,.1028E+02,.1023E+02,.1008E+02,.9812E+01,.9694E+01,.7576E+01,.4141E+01,.1315E+01,.5111E+00,&
 .1042E+02,.1042E+02,.1042E+02,.1036E+02,.1020E+02,.9937E+01,.9821E+01,.7679E+01,.4209E+01,.1341E+01,.5172E+00,&
 .1056E+02,.1056E+02,.1056E+02,.1050E+02,.1032E+02,.1006E+02,.9947E+01,.7781E+01,.4278E+01,.1366E+01,.5232E+00,&
 .1070E+02,.1070E+02,.1070E+02,.1063E+02,.1043E+02,.1019E+02,.1007E+02,.7884E+01,.4346E+01,.1392E+01,.5293E+00,&
 .1084E+02,.1084E+02,.1084E+02,.1076E+02,.1055E+02,.1031E+02,.1020E+02,.7987E+01,.4414E+01,.1418E+01,.5353E+00,&
 .1093E+02,.1093E+02,.1093E+02,.1086E+02,.1069E+02,.1044E+02,.1032E+02,.8091E+01,.4484E+01,.1445E+01,.5415E+00,&
 .1102E+02,.1102E+02,.1102E+02,.1097E+02,.1083E+02,.1057E+02,.1045E+02,.8196E+01,.4553E+01,.1472E+01,.5477E+00,&
 .1111E+02,.1111E+02,.1111E+02,.1107E+02,.1096E+02,.1069E+02,.1057E+02,.8300E+01,.4623E+01,.1498E+01,.5539E+00,&
 .1120E+02,.1120E+02,.1120E+02,.1118E+02,.1110E+02,.1082E+02,.1070E+02,.8405E+01,.4692E+01,.1525E+01,.5601E+00,&
 .1129E+02,.1129E+02,.1129E+02,.1128E+02,.1124E+02,.1095E+02,.1082E+02,.8509E+01,.4762E+01,.1552E+01,.5663E+00,&
 .1140E+02,.1140E+02,.1140E+02,.1139E+02,.1134E+02,.1105E+02,.1093E+02,.8625E+01,.4838E+01,.1582E+01,.5732E+00,&
 .1151E+02,.1151E+02,.1151E+02,.1149E+02,.1144E+02,.1116E+02,.1103E+02,.8741E+01,.4915E+01,.1612E+01,.5801E+00,&
 .1161E+02,.1161E+02,.1161E+02,.1160E+02,.1154E+02,.1126E+02,.1114E+02,.8858E+01,.4991E+01,.1641E+01,.5869E+00,&
 .1172E+02,.1172E+02,.1172E+02,.1170E+02,.1164E+02,.1137E+02,.1124E+02,.8974E+01,.5068E+01,.1671E+01,.5938E+00,&
 .1183E+02,.1183E+02,.1183E+02,.1181E+02,.1174E+02,.1147E+02,.1135E+02,.9090E+01,.5144E+01,.1701E+01,.6007E+00,&
 .1198E+02,.1198E+02,.1198E+02,.1195E+02,.1186E+02,.1159E+02,.1147E+02,.9208E+01,.5224E+01,.1733E+01,.6080E+00,&
 .1213E+02,.1213E+02,.1213E+02,.1209E+02,.1198E+02,.1171E+02,.1160E+02,.9327E+01,.5304E+01,.1764E+01,.6153E+00,&
 .1229E+02,.1229E+02,.1229E+02,.1224E+02,.1209E+02,.1184E+02,.1172E+02,.9445E+01,.5384E+01,.1796E+01,.6227E+00,&
 .1244E+02,.1244E+02,.1244E+02,.1238E+02,.1221E+02,.1196E+02,.1185E+02,.9564E+01,.5464E+01,.1827E+01,.6300E+00,&
 .1259E+02,.1259E+02,.1259E+02,.1252E+02,.1233E+02,.1208E+02,.1197E+02,.9682E+01,.5544E+01,.1859E+01,.6373E+00,&
 .1277E+02,.1277E+02,.1277E+02,.1271E+02,.1257E+02,.1232E+02,.1221E+02,.9884E+01,.5686E+01,.1916E+01,.6506E+00,&
 .1294E+02,.1294E+02,.1294E+02,.1291E+02,.1281E+02,.1256E+02,.1245E+02,.1009E+02,.5829E+01,.1974E+01,.6639E+00,&
 .1312E+02,.1312E+02,.1312E+02,.1310E+02,.1306E+02,.1279E+02,.1268E+02,.1029E+02,.5971E+01,.2031E+01,.6772E+00,&
 .1329E+02,.1329E+02,.1329E+02,.1330E+02,.1330E+02,.1303E+02,.1292E+02,.1049E+02,.6114E+01,.2089E+01,.6905E+00,&
 .1347E+02,.1347E+02,.1347E+02,.1349E+02,.1354E+02,.1327E+02,.1316E+02,.1069E+02,.6256E+01,.2146E+01,.7038E+00,&
 .1369E+02,.1369E+02,.1369E+02,.1370E+02,.1372E+02,.1347E+02,.1336E+02,.1091E+02,.6410E+01,.2210E+01,.7185E+00,&
 .1390E+02,.1390E+02,.1390E+02,.1391E+02,.1391E+02,.1367E+02,.1357E+02,.1114E+02,.6564E+01,.2274E+01,.7333E+00,&
 .1412E+02,.1412E+02,.1412E+02,.1411E+02,.1409E+02,.1386E+02,.1377E+02,.1136E+02,.6719E+01,.2337E+01,.7480E+00,&
 .1433E+02,.1433E+02,.1433E+02,.1432E+02,.1428E+02,.1406E+02,.1398E+02,.1159E+02,.6873E+01,.2401E+01,.7628E+00,&
 .1455E+02,.1455E+02,.1455E+02,.1453E+02,.1446E+02,.1426E+02,.1418E+02,.1181E+02,.7027E+01,.2465E+01,.7775E+00,&
 .1493E+02,.1493E+02,.1493E+02,.1488E+02,.1473E+02,.1452E+02,.1443E+02,.1205E+02,.7206E+01,.2540E+01,.7949E+00,&
 .1516E+02,.1516E+02,.1516E+02,.1511E+02,.1496E+02,.1480E+02,.1473E+02,.1228E+02,.7386E+01,.2617E+01,.8126E+00,&
 .1537E+02,.1537E+02,.1537E+02,.1535E+02,.1530E+02,.1515E+02,.1508E+02,.1253E+02,.7570E+01,.2695E+01,.8308E+00,&
 .1568E+02,.1568E+02,.1568E+02,.1571E+02,.1580E+02,.1560E+02,.1552E+02,.1291E+02,.7852E+01,.2815E+01,.8588E+00,&
 .1597E+02,.1597E+02,.1597E+02,.1602E+02,.1618E+02,.1596E+02,.1587E+02,.1331E+02,.8141E+01,.2939E+01,.8876E+00,&
 .1626E+02,.1626E+02,.1626E+02,.1632E+02,.1650E+02,.1628E+02,.1619E+02,.1372E+02,.8437E+01,.3068E+01,.9174E+00,&
 .1675E+02,.1675E+02,.1675E+02,.1680E+02,.1693E+02,.1675E+02,.1667E+02,.1428E+02,.8843E+01,.3245E+01,.9586E+00,&
 .1751E+02,.1751E+02,.1751E+02,.1749E+02,.1744E+02,.1730E+02,.1724E+02,.1483E+02,.9259E+01,.3430E+01,.1002E+01,&
 .1815E+02,.1815E+02,.1815E+02,.1817E+02,.1821E+02,.1814E+02,.1811E+02,.1550E+02,.9791E+01,.3668E+01,.1058E+01,&
 .1877E+02,.1877E+02,.1877E+02,.1888E+02,.1918E+02,.1902E+02,.1895E+02,.1636E+02,.1046E+02,.3971E+01,.1129E+01,&
 .1953E+02,.1953E+02,.1953E+02,.1960E+02,.1980E+02,.1972E+02,.1968E+02,.1729E+02,.1116E+02,.4291E+01,.1204E+01,&
 .2088E+02,.2088E+02,.2088E+02,.2089E+02,.2090E+02,.2086E+02,.2085E+02,.1850E+02,.1212E+02,.4746E+01,.1311E+01,&
 .2176E+02,.2176E+02,.2176E+02,.2191E+02,.2235E+02,.2232E+02,.2231E+02,.1972E+02,.1314E+02,.5228E+01,.1427E+01,&
 .2305E+02,.2305E+02,.2305E+02,.2320E+02,.2361E+02,.2360E+02,.2360E+02,.2143E+02,.1448E+02,.5881E+01,.1583E+01,&
 .2530E+02,.2530E+02,.2530E+02,.2549E+02,.2604E+02,.2612E+02,.2616E+02,.2372E+02,.1646E+02,.6878E+01,.1825E+01,&
 .2764E+02,.2764E+02,.2764E+02,.2777E+02,.2815E+02,.2840E+02,.2851E+02,.2667E+02,.1893E+02,.8158E+01,.2138E+01,&
 .3096E+02,.3096E+02,.3096E+02,.3124E+02,.3203E+02,.3225E+02,.3235E+02,.3079E+02,.2262E+02,.1014E+02,.2637E+01,&
 .3690E+02,.3690E+02,.3690E+02,.3726E+02,.3828E+02,.3867E+02,.3883E+02,.3821E+02,.2943E+02,.1403E+02,.3640E+01,&
 .5038E+02,.5038E+02,.5038E+02,.5089E+02,.5234E+02,.5310E+02,.5343E+02,.5475E+02,.4573E+02,.2429E+02,.6466E+01/
 data (((Bex(ai,k,nh),ai= 2, 2),k=1,11),nh=0,99)/ &
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2268E+02,.2268E+02,.2268E+02,.2205E+02,.2027E+02,.1800E+02,.1702E+02,.9712E+01,.4476E+01,.2143E+01,.6938E+00,&
 .2273E+02,.2273E+02,.2273E+02,.2210E+02,.2031E+02,.1804E+02,.1706E+02,.9732E+01,.4485E+01,.2148E+01,.6964E+00,&
 .2278E+02,.2278E+02,.2278E+02,.2215E+02,.2036E+02,.1808E+02,.1709E+02,.9752E+01,.4494E+01,.2153E+01,.6989E+00,&
 .2282E+02,.2282E+02,.2282E+02,.2219E+02,.2040E+02,.1811E+02,.1713E+02,.9772E+01,.4504E+01,.2158E+01,.7015E+00,&
 .2287E+02,.2287E+02,.2287E+02,.2224E+02,.2045E+02,.1815E+02,.1716E+02,.9792E+01,.4513E+01,.2163E+01,.7040E+00,&
 .2292E+02,.2292E+02,.2292E+02,.2229E+02,.2049E+02,.1819E+02,.1720E+02,.9812E+01,.4522E+01,.2168E+01,.7066E+00,&
 .2292E+02,.2292E+02,.2292E+02,.2229E+02,.2049E+02,.1819E+02,.1720E+02,.9812E+01,.4522E+01,.2168E+01,.7066E+00,&
 .2292E+02,.2292E+02,.2292E+02,.2229E+02,.2049E+02,.1819E+02,.1720E+02,.9812E+01,.4522E+01,.2168E+01,.7066E+00,&
 .2292E+02,.2292E+02,.2292E+02,.2229E+02,.2049E+02,.1819E+02,.1720E+02,.9812E+01,.4522E+01,.2168E+01,.7066E+00,&
 .2292E+02,.2292E+02,.2292E+02,.2229E+02,.2049E+02,.1819E+02,.1720E+02,.9812E+01,.4522E+01,.2168E+01,.7066E+00,&
 .2292E+02,.2292E+02,.2292E+02,.2229E+02,.2049E+02,.1819E+02,.1720E+02,.9812E+01,.4522E+01,.2168E+01,.7066E+00,&
 .2307E+02,.2307E+02,.2307E+02,.2243E+02,.2062E+02,.1831E+02,.1731E+02,.9870E+01,.4548E+01,.2182E+01,.7140E+00,&
 .2321E+02,.2321E+02,.2321E+02,.2257E+02,.2076E+02,.1842E+02,.1742E+02,.9927E+01,.4574E+01,.2196E+01,.7215E+00,&
 .2336E+02,.2336E+02,.2336E+02,.2272E+02,.2089E+02,.1854E+02,.1752E+02,.9985E+01,.4601E+01,.2209E+01,.7289E+00,&
 .2350E+02,.2350E+02,.2350E+02,.2286E+02,.2103E+02,.1865E+02,.1763E+02,.1004E+02,.4627E+01,.2223E+01,.7364E+00,&
 .2365E+02,.2365E+02,.2365E+02,.2300E+02,.2116E+02,.1877E+02,.1774E+02,.1010E+02,.4653E+01,.2237E+01,.7438E+00,&
 .2406E+02,.2406E+02,.2406E+02,.2340E+02,.2152E+02,.1908E+02,.1803E+02,.1025E+02,.4717E+01,.2270E+01,.7623E+00,&
 .2447E+02,.2447E+02,.2447E+02,.2379E+02,.2188E+02,.1939E+02,.1832E+02,.1040E+02,.4782E+01,.2302E+01,.7808E+00,&
 .2487E+02,.2487E+02,.2487E+02,.2419E+02,.2224E+02,.1970E+02,.1861E+02,.1056E+02,.4846E+01,.2335E+01,.7993E+00,&
 .2528E+02,.2528E+02,.2528E+02,.2458E+02,.2260E+02,.2001E+02,.1890E+02,.1071E+02,.4911E+01,.2367E+01,.8178E+00,&
 .2569E+02,.2569E+02,.2569E+02,.2498E+02,.2296E+02,.2032E+02,.1919E+02,.1086E+02,.4975E+01,.2400E+01,.8363E+00,&
 .2626E+02,.2626E+02,.2626E+02,.2552E+02,.2343E+02,.2073E+02,.1957E+02,.1105E+02,.5047E+01,.2433E+01,.8570E+00,&
 .2683E+02,.2683E+02,.2683E+02,.2607E+02,.2391E+02,.2113E+02,.1994E+02,.1124E+02,.5119E+01,.2466E+01,.8778E+00,&
 .2739E+02,.2739E+02,.2739E+02,.2661E+02,.2438E+02,.2154E+02,.2032E+02,.1142E+02,.5192E+01,.2499E+01,.8985E+00,&
 .2796E+02,.2796E+02,.2796E+02,.2716E+02,.2486E+02,.2194E+02,.2069E+02,.1161E+02,.5264E+01,.2532E+01,.9193E+00,&
 .2853E+02,.2853E+02,.2853E+02,.2770E+02,.2533E+02,.2235E+02,.2107E+02,.1180E+02,.5336E+01,.2565E+01,.9400E+00,&
 .2946E+02,.2946E+02,.2946E+02,.2858E+02,.2609E+02,.2299E+02,.2166E+02,.1208E+02,.5439E+01,.2608E+01,.9691E+00,&
 .3009E+02,.3009E+02,.3009E+02,.2918E+02,.2660E+02,.2342E+02,.2206E+02,.1227E+02,.5507E+01,.2636E+01,.9881E+00,&
 .3109E+02,.3109E+02,.3109E+02,.3013E+02,.2740E+02,.2410E+02,.2268E+02,.1257E+02,.5609E+01,.2676E+01,.1016E+01,&
 .3177E+02,.3177E+02,.3177E+02,.3077E+02,.2794E+02,.2455E+02,.2310E+02,.1276E+02,.5676E+01,.2702E+01,.1034E+01,&
 .3283E+02,.3283E+02,.3283E+02,.3178E+02,.2879E+02,.2526E+02,.2375E+02,.1307E+02,.5778E+01,.2739E+01,.1061E+01,&
 .3394E+02,.3394E+02,.3394E+02,.3283E+02,.2966E+02,.2600E+02,.2443E+02,.1338E+02,.5880E+01,.2774E+01,.1088E+01,&
 .3471E+02,.3471E+02,.3471E+02,.3355E+02,.3026E+02,.2650E+02,.2489E+02,.1359E+02,.5948E+01,.2797E+01,.1105E+01,&
 .3590E+02,.3590E+02,.3590E+02,.3467E+02,.3118E+02,.2727E+02,.2560E+02,.1392E+02,.6051E+01,.2831E+01,.1131E+01,&
 .3672E+02,.3672E+02,.3672E+02,.3545E+02,.3182E+02,.2781E+02,.2609E+02,.1415E+02,.6121E+01,.2853E+01,.1148E+01,&
 .3799E+02,.3799E+02,.3799E+02,.3664E+02,.3280E+02,.2863E+02,.2685E+02,.1449E+02,.6228E+01,.2885E+01,.1174E+01,&
 .3932E+02,.3932E+02,.3932E+02,.3789E+02,.3383E+02,.2950E+02,.2764E+02,.1485E+02,.6337E+01,.2918E+01,.1199E+01,&
 .4071E+02,.4071E+02,.4071E+02,.3920E+02,.3489E+02,.3038E+02,.2845E+02,.1522E+02,.6448E+01,.2949E+01,.1225E+01,&
 .4215E+02,.4215E+02,.4215E+02,.4055E+02,.3600E+02,.3131E+02,.2930E+02,.1561E+02,.6562E+01,.2980E+01,.1250E+01,&
 .4417E+02,.4417E+02,.4417E+02,.4245E+02,.3754E+02,.3260E+02,.3049E+02,.1615E+02,.6720E+01,.3021E+01,.1285E+01,&
 .4629E+02,.4629E+02,.4629E+02,.4444E+02,.3916E+02,.3396E+02,.3173E+02,.1671E+02,.6884E+01,.3062E+01,.1319E+01,&
 .4911E+02,.4911E+02,.4911E+02,.4708E+02,.4131E+02,.3576E+02,.3338E+02,.1745E+02,.7099E+01,.3114E+01,.1363E+01,&
 .5337E+02,.5337E+02,.5337E+02,.5107E+02,.4454E+02,.3847E+02,.3587E+02,.1858E+02,.7422E+01,.3188E+01,.1426E+01,&
 .5871E+02,.5871E+02,.5871E+02,.5608E+02,.4860E+02,.4188E+02,.3900E+02,.2001E+02,.7827E+01,.3276E+01,.1500E+01,&
 .7441E+02,.7441E+02,.7441E+02,.7081E+02,.6056E+02,.5196E+02,.4827E+02,.2427E+02,.9036E+01,.3523E+01,.1703E+01/
 data (((Bex(ai,k,nh),ai= 3, 3),k=1,11),nh=0,99)/ &
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01/
 data (((Bex(ai,k,nh),ai= 4, 4),k=1,11),nh=0,99)/ &
 .7325E+01,.7325E+01,.7325E+01,.7033E+01,.6201E+01,.5528E+01,.5240E+01,.2922E+01,.1058E+01,.2350E+00,.5156E-01,&
 .7397E+01,.7397E+01,.7397E+01,.7102E+01,.6263E+01,.5582E+01,.5291E+01,.2952E+01,.1069E+01,.2376E+00,.5267E-01,&
 .7469E+01,.7469E+01,.7469E+01,.7172E+01,.6325E+01,.5636E+01,.5342E+01,.2982E+01,.1080E+01,.2402E+00,.5378E-01,&
 .7542E+01,.7542E+01,.7542E+01,.7241E+01,.6386E+01,.5691E+01,.5392E+01,.3011E+01,.1092E+01,.2427E+00,.5489E-01,&
 .7614E+01,.7614E+01,.7614E+01,.7311E+01,.6448E+01,.5745E+01,.5443E+01,.3041E+01,.1103E+01,.2453E+00,.5600E-01,&
 .7686E+01,.7686E+01,.7686E+01,.7380E+01,.6510E+01,.5799E+01,.5494E+01,.3071E+01,.1114E+01,.2479E+00,.5711E-01,&
 .7763E+01,.7763E+01,.7763E+01,.7453E+01,.6573E+01,.5856E+01,.5548E+01,.3102E+01,.1126E+01,.2507E+00,.5827E-01,&
 .7840E+01,.7840E+01,.7840E+01,.7526E+01,.6635E+01,.5913E+01,.5603E+01,.3133E+01,.1138E+01,.2534E+00,.5943E-01,&
 .7916E+01,.7916E+01,.7916E+01,.7600E+01,.6698E+01,.5969E+01,.5657E+01,.3165E+01,.1150E+01,.2562E+00,.6058E-01,&
 .7993E+01,.7993E+01,.7993E+01,.7673E+01,.6760E+01,.6026E+01,.5712E+01,.3196E+01,.1162E+01,.2589E+00,.6174E-01,&
 .8070E+01,.8070E+01,.8070E+01,.7746E+01,.6823E+01,.6083E+01,.5766E+01,.3227E+01,.1174E+01,.2617E+00,.6290E-01,&
 .8150E+01,.8150E+01,.8150E+01,.7823E+01,.6891E+01,.6145E+01,.5825E+01,.3260E+01,.1186E+01,.2646E+00,.6411E-01,&
 .8230E+01,.8230E+01,.8230E+01,.7900E+01,.6959E+01,.6206E+01,.5884E+01,.3293E+01,.1199E+01,.2675E+00,.6532E-01,&
 .8311E+01,.8311E+01,.8311E+01,.7977E+01,.7027E+01,.6268E+01,.5942E+01,.3325E+01,.1211E+01,.2705E+00,.6654E-01,&
 .8391E+01,.8391E+01,.8391E+01,.8054E+01,.7095E+01,.6329E+01,.6001E+01,.3358E+01,.1224E+01,.2734E+00,.6775E-01,&
 .8471E+01,.8471E+01,.8471E+01,.8131E+01,.7163E+01,.6391E+01,.6060E+01,.3391E+01,.1236E+01,.2763E+00,.6896E-01,&
 .8553E+01,.8553E+01,.8553E+01,.8210E+01,.7235E+01,.6454E+01,.6119E+01,.3425E+01,.1249E+01,.2794E+00,.7023E-01,&
 .8635E+01,.8635E+01,.8635E+01,.8290E+01,.7307E+01,.6517E+01,.6178E+01,.3460E+01,.1263E+01,.2825E+00,.7149E-01,&
 .8718E+01,.8718E+01,.8718E+01,.8369E+01,.7378E+01,.6579E+01,.6237E+01,.3494E+01,.1276E+01,.2857E+00,.7276E-01,&
 .8800E+01,.8800E+01,.8800E+01,.8449E+01,.7450E+01,.6642E+01,.6296E+01,.3529E+01,.1290E+01,.2888E+00,.7402E-01,&
 .8882E+01,.8882E+01,.8882E+01,.8528E+01,.7522E+01,.6705E+01,.6355E+01,.3563E+01,.1303E+01,.2919E+00,.7529E-01,&
 .8966E+01,.8966E+01,.8966E+01,.8609E+01,.7594E+01,.6770E+01,.6417E+01,.3599E+01,.1317E+01,.2952E+00,.7661E-01,&
 .9050E+01,.9050E+01,.9050E+01,.8690E+01,.7666E+01,.6835E+01,.6479E+01,.3636E+01,.1331E+01,.2985E+00,.7793E-01,&
 .9134E+01,.9134E+01,.9134E+01,.8771E+01,.7738E+01,.6899E+01,.6540E+01,.3672E+01,.1345E+01,.3018E+00,.7926E-01,&
 .9218E+01,.9218E+01,.9218E+01,.8852E+01,.7810E+01,.6964E+01,.6602E+01,.3709E+01,.1359E+01,.3051E+00,.8058E-01,&
 .9302E+01,.9302E+01,.9302E+01,.8933E+01,.7882E+01,.7029E+01,.6664E+01,.3745E+01,.1373E+01,.3084E+00,.8190E-01,&
 .9389E+01,.9389E+01,.9389E+01,.9017E+01,.7957E+01,.7096E+01,.6728E+01,.3783E+01,.1388E+01,.3119E+00,.8328E-01,&
 .9477E+01,.9477E+01,.9477E+01,.9101E+01,.8031E+01,.7163E+01,.6791E+01,.3821E+01,.1403E+01,.3154E+00,.8466E-01,&
 .9564E+01,.9564E+01,.9564E+01,.9185E+01,.8106E+01,.7230E+01,.6855E+01,.3859E+01,.1417E+01,.3189E+00,.8603E-01,&
 .9652E+01,.9652E+01,.9652E+01,.9269E+01,.8180E+01,.7297E+01,.6918E+01,.3897E+01,.1432E+01,.3224E+00,.8741E-01,&
 .9739E+01,.9739E+01,.9739E+01,.9353E+01,.8255E+01,.7364E+01,.6982E+01,.3935E+01,.1447E+01,.3259E+00,.8879E-01,&
 .9833E+01,.9833E+01,.9833E+01,.9443E+01,.8332E+01,.7434E+01,.7049E+01,.3975E+01,.1463E+01,.3296E+00,.9023E-01,&
 .9927E+01,.9927E+01,.9927E+01,.9533E+01,.8409E+01,.7504E+01,.7116E+01,.4014E+01,.1478E+01,.3333E+00,.9166E-01,&
 .1002E+02,.1002E+02,.1002E+02,.9622E+01,.8487E+01,.7575E+01,.7184E+01,.4054E+01,.1494E+01,.3371E+00,.9310E-01,&
 .1012E+02,.1012E+02,.1012E+02,.9712E+01,.8564E+01,.7645E+01,.7251E+01,.4093E+01,.1509E+01,.3408E+00,.9453E-01,&
 .1021E+02,.1021E+02,.1021E+02,.9802E+01,.8641E+01,.7715E+01,.7318E+01,.4133E+01,.1525E+01,.3445E+00,.9597E-01,&
 .1031E+02,.1031E+02,.1031E+02,.9896E+01,.8724E+01,.7791E+01,.7391E+01,.4175E+01,.1541E+01,.3484E+00,.9748E-01,&
 .1040E+02,.1040E+02,.1040E+02,.9989E+01,.8807E+01,.7867E+01,.7464E+01,.4216E+01,.1558E+01,.3524E+00,.9898E-01,&
 .1050E+02,.1050E+02,.1050E+02,.1008E+02,.8891E+01,.7943E+01,.7537E+01,.4258E+01,.1574E+01,.3563E+00,.1005E+00,&
 .1059E+02,.1059E+02,.1059E+02,.1018E+02,.8974E+01,.8019E+01,.7610E+01,.4299E+01,.1591E+01,.3603E+00,.1020E+00,&
 .1069E+02,.1069E+02,.1069E+02,.1027E+02,.9057E+01,.8095E+01,.7683E+01,.4341E+01,.1607E+01,.3642E+00,.1035E+00,&
 .1079E+02,.1079E+02,.1079E+02,.1036E+02,.9145E+01,.8172E+01,.7755E+01,.4384E+01,.1624E+01,.3684E+00,.1051E+00,&
 .1088E+02,.1088E+02,.1088E+02,.1045E+02,.9232E+01,.8249E+01,.7827E+01,.4428E+01,.1642E+01,.3725E+00,.1066E+00,&
 .1098E+02,.1098E+02,.1098E+02,.1055E+02,.9320E+01,.8325E+01,.7900E+01,.4471E+01,.1659E+01,.3767E+00,.1082E+00,&
 .1107E+02,.1107E+02,.1107E+02,.1064E+02,.9407E+01,.8402E+01,.7972E+01,.4515E+01,.1677E+01,.3808E+00,.1097E+00,&
 .1117E+02,.1117E+02,.1117E+02,.1073E+02,.9495E+01,.8479E+01,.8044E+01,.4558E+01,.1694E+01,.3850E+00,.1113E+00,&
 .1127E+02,.1127E+02,.1127E+02,.1083E+02,.9581E+01,.8557E+01,.8119E+01,.4604E+01,.1712E+01,.3894E+00,.1129E+00,&
 .1137E+02,.1137E+02,.1137E+02,.1093E+02,.9667E+01,.8636E+01,.8194E+01,.4650E+01,.1730E+01,.3939E+00,.1145E+00,&
 .1147E+02,.1147E+02,.1147E+02,.1102E+02,.9754E+01,.8714E+01,.8269E+01,.4695E+01,.1749E+01,.3983E+00,.1162E+00,&
 .1157E+02,.1157E+02,.1157E+02,.1112E+02,.9840E+01,.8793E+01,.8344E+01,.4741E+01,.1767E+01,.4028E+00,.1178E+00,&
 .1167E+02,.1167E+02,.1167E+02,.1122E+02,.9926E+01,.8871E+01,.8419E+01,.4787E+01,.1785E+01,.4072E+00,.1194E+00,&
 .1179E+02,.1179E+02,.1179E+02,.1134E+02,.1003E+02,.8966E+01,.8510E+01,.4843E+01,.1808E+01,.4128E+00,.1214E+00,&
 .1191E+02,.1191E+02,.1191E+02,.1145E+02,.1014E+02,.9062E+01,.8602E+01,.4900E+01,.1831E+01,.4183E+00,.1234E+00,&
 .1204E+02,.1204E+02,.1204E+02,.1157E+02,.1024E+02,.9157E+01,.8693E+01,.4956E+01,.1853E+01,.4239E+00,.1255E+00,&
 .1216E+02,.1216E+02,.1216E+02,.1168E+02,.1035E+02,.9253E+01,.8785E+01,.5013E+01,.1876E+01,.4294E+00,.1275E+00,&
 .1228E+02,.1228E+02,.1228E+02,.1180E+02,.1045E+02,.9348E+01,.8876E+01,.5069E+01,.1899E+01,.4350E+00,.1295E+00,&
 .1241E+02,.1241E+02,.1241E+02,.1193E+02,.1056E+02,.9450E+01,.8974E+01,.5128E+01,.1923E+01,.4410E+00,.1316E+00,&
 .1255E+02,.1255E+02,.1255E+02,.1206E+02,.1067E+02,.9552E+01,.9072E+01,.5187E+01,.1947E+01,.4470E+00,.1337E+00,&
 .1268E+02,.1268E+02,.1268E+02,.1218E+02,.1078E+02,.9653E+01,.9171E+01,.5246E+01,.1971E+01,.4529E+00,.1359E+00,&
 .1282E+02,.1282E+02,.1282E+02,.1231E+02,.1089E+02,.9755E+01,.9269E+01,.5305E+01,.1995E+01,.4589E+00,.1380E+00,&
 .1295E+02,.1295E+02,.1295E+02,.1244E+02,.1100E+02,.9857E+01,.9367E+01,.5364E+01,.2019E+01,.4649E+00,.1401E+00,&
 .1307E+02,.1307E+02,.1307E+02,.1256E+02,.1111E+02,.9956E+01,.9461E+01,.5419E+01,.2041E+01,.4704E+00,.1420E+00,&
 .1319E+02,.1319E+02,.1319E+02,.1268E+02,.1122E+02,.1005E+02,.9555E+01,.5473E+01,.2064E+01,.4759E+00,.1439E+00,&
 .1331E+02,.1331E+02,.1331E+02,.1279E+02,.1132E+02,.1015E+02,.9648E+01,.5528E+01,.2086E+01,.4815E+00,.1459E+00,&
 .1343E+02,.1343E+02,.1343E+02,.1291E+02,.1143E+02,.1025E+02,.9742E+01,.5582E+01,.2109E+01,.4870E+00,.1478E+00,&
 .1355E+02,.1355E+02,.1355E+02,.1303E+02,.1154E+02,.1035E+02,.9836E+01,.5637E+01,.2131E+01,.4925E+00,.1497E+00,&
 .1368E+02,.1368E+02,.1368E+02,.1316E+02,.1166E+02,.1046E+02,.9939E+01,.5702E+01,.2158E+01,.4992E+00,.1520E+00,&
 .1382E+02,.1382E+02,.1382E+02,.1329E+02,.1179E+02,.1057E+02,.1004E+02,.5767E+01,.2185E+01,.5059E+00,.1543E+00,&
 .1395E+02,.1395E+02,.1395E+02,.1342E+02,.1191E+02,.1067E+02,.1014E+02,.5831E+01,.2211E+01,.5126E+00,.1567E+00,&
 .1409E+02,.1409E+02,.1409E+02,.1355E+02,.1204E+02,.1078E+02,.1025E+02,.5896E+01,.2238E+01,.5193E+00,.1590E+00,&
 .1422E+02,.1422E+02,.1422E+02,.1368E+02,.1216E+02,.1089E+02,.1035E+02,.5961E+01,.2265E+01,.5260E+00,.1613E+00,&
 .1443E+02,.1443E+02,.1443E+02,.1389E+02,.1235E+02,.1106E+02,.1052E+02,.6066E+01,.2308E+01,.5370E+00,.1650E+00,&
 .1465E+02,.1465E+02,.1465E+02,.1410E+02,.1253E+02,.1123E+02,.1068E+02,.6171E+01,.2352E+01,.5480E+00,.1687E+00,&
 .1486E+02,.1486E+02,.1486E+02,.1430E+02,.1272E+02,.1141E+02,.1085E+02,.6276E+01,.2395E+01,.5590E+00,.1724E+00,&
 .1508E+02,.1508E+02,.1508E+02,.1451E+02,.1290E+02,.1158E+02,.1101E+02,.6381E+01,.2439E+01,.5700E+00,.1761E+00,&
 .1529E+02,.1529E+02,.1529E+02,.1472E+02,.1309E+02,.1175E+02,.1118E+02,.6486E+01,.2482E+01,.5810E+00,.1798E+00,&
 .1561E+02,.1561E+02,.1561E+02,.1503E+02,.1337E+02,.1201E+02,.1143E+02,.6636E+01,.2546E+01,.5973E+00,.1852E+00,&
 .1593E+02,.1593E+02,.1593E+02,.1533E+02,.1364E+02,.1226E+02,.1167E+02,.6786E+01,.2609E+01,.6137E+00,.1906E+00,&
 .1624E+02,.1624E+02,.1624E+02,.1564E+02,.1392E+02,.1252E+02,.1192E+02,.6935E+01,.2673E+01,.6300E+00,.1959E+00,&
 .1656E+02,.1656E+02,.1656E+02,.1594E+02,.1419E+02,.1277E+02,.1216E+02,.7085E+01,.2736E+01,.6464E+00,.2013E+00,&
 .1688E+02,.1688E+02,.1688E+02,.1625E+02,.1447E+02,.1303E+02,.1241E+02,.7235E+01,.2800E+01,.6627E+00,.2067E+00,&
 .1727E+02,.1727E+02,.1727E+02,.1664E+02,.1485E+02,.1336E+02,.1272E+02,.7433E+01,.2885E+01,.6846E+00,.2138E+00,&
 .1766E+02,.1766E+02,.1766E+02,.1702E+02,.1521E+02,.1369E+02,.1304E+02,.7636E+01,.2972E+01,.7072E+00,.2210E+00,&
 .1805E+02,.1805E+02,.1805E+02,.1741E+02,.1557E+02,.1402E+02,.1336E+02,.7844E+01,.3061E+01,.7305E+00,.2284E+00,&
 .1845E+02,.1845E+02,.1845E+02,.1779E+02,.1593E+02,.1435E+02,.1367E+02,.8057E+01,.3153E+01,.7545E+00,.2361E+00,&
 .1902E+02,.1902E+02,.1902E+02,.1834E+02,.1641E+02,.1480E+02,.1411E+02,.8348E+01,.3278E+01,.7874E+00,.2464E+00,&
 .1962E+02,.1962E+02,.1962E+02,.1892E+02,.1692E+02,.1527E+02,.1457E+02,.8644E+01,.3407E+01,.8218E+00,.2571E+00,&
 .2041E+02,.2041E+02,.2041E+02,.1967E+02,.1758E+02,.1589E+02,.1517E+02,.9022E+01,.3574E+01,.8664E+00,.2709E+00,&
 .2116E+02,.2116E+02,.2116E+02,.2042E+02,.1830E+02,.1656E+02,.1582E+02,.9415E+01,.3749E+01,.9129E+00,.2852E+00,&
 .2204E+02,.2204E+02,.2204E+02,.2129E+02,.1917E+02,.1734E+02,.1656E+02,.9903E+01,.3966E+01,.9718E+00,.3031E+00,&
 .2295E+02,.2295E+02,.2295E+02,.2218E+02,.2000E+02,.1811E+02,.1730E+02,.1042E+02,.4194E+01,.1034E+01,.3217E+00,&
 .2409E+02,.2409E+02,.2409E+02,.2328E+02,.2098E+02,.1904E+02,.1821E+02,.1104E+02,.4473E+01,.1110E+01,.3444E+00,&
 .2554E+02,.2554E+02,.2554E+02,.2467E+02,.2220E+02,.2020E+02,.1934E+02,.1177E+02,.4809E+01,.1204E+01,.3718E+00,&
 .2721E+02,.2721E+02,.2721E+02,.2635E+02,.2390E+02,.2174E+02,.2082E+02,.1273E+02,.5257E+01,.1329E+01,.4081E+00,&
 .2912E+02,.2912E+02,.2912E+02,.2821E+02,.2563E+02,.2338E+02,.2241E+02,.1387E+02,.5786E+01,.1480E+01,.4510E+00,&
 .3212E+02,.3212E+02,.3212E+02,.3112E+02,.2826E+02,.2589E+02,.2487E+02,.1551E+02,.6569E+01,.1706E+01,.5144E+00,&
 .3570E+02,.3570E+02,.3570E+02,.3468E+02,.3179E+02,.2917E+02,.2804E+02,.1780E+02,.7673E+01,.2031E+01,.6039E+00,&
 .4053E+02,.4053E+02,.4053E+02,.3943E+02,.3630E+02,.3346E+02,.3224E+02,.2068E+02,.9112E+01,.2467E+01,.7211E+00,&
 .4887E+02,.4887E+02,.4887E+02,.4762E+02,.4407E+02,.4094E+02,.3960E+02,.2605E+02,.1187E+02,.3330E+01,.9477E+00,&
 .6332E+02,.6332E+02,.6332E+02,.6207E+02,.5852E+02,.5476E+02,.5315E+02,.3643E+02,.1748E+02,.5174E+01,.1417E+01/
 data (((Bex(ai,k,nh),ai= 5, 5),k=1,11),nh=0,99)/ &
 .1033E+01,.1033E+01,.1033E+01,.1038E+01,.1054E+01,.1075E+01,.1084E+01,.1151E+01,.1115E+01,.7503E+00,.1815E+00,&
 .1056E+01,.1056E+01,.1056E+01,.1061E+01,.1078E+01,.1099E+01,.1108E+01,.1179E+01,.1142E+01,.7701E+00,.1880E+00,&
 .1079E+01,.1079E+01,.1079E+01,.1084E+01,.1101E+01,.1123E+01,.1132E+01,.1207E+01,.1170E+01,.7899E+00,.1945E+00,&
 .1101E+01,.1101E+01,.1101E+01,.1108E+01,.1125E+01,.1146E+01,.1156E+01,.1234E+01,.1197E+01,.8097E+00,.2010E+00,&
 .1124E+01,.1124E+01,.1124E+01,.1131E+01,.1148E+01,.1170E+01,.1180E+01,.1262E+01,.1225E+01,.8295E+00,.2075E+00,&
 .1147E+01,.1147E+01,.1147E+01,.1154E+01,.1172E+01,.1194E+01,.1204E+01,.1290E+01,.1252E+01,.8493E+00,.2140E+00,&
 .1172E+01,.1172E+01,.1172E+01,.1179E+01,.1198E+01,.1223E+01,.1234E+01,.1318E+01,.1281E+01,.8707E+00,.2214E+00,&
 .1197E+01,.1197E+01,.1197E+01,.1204E+01,.1225E+01,.1252E+01,.1264E+01,.1346E+01,.1310E+01,.8921E+00,.2288E+00,&
 .1221E+01,.1221E+01,.1221E+01,.1230E+01,.1251E+01,.1281E+01,.1294E+01,.1375E+01,.1339E+01,.9136E+00,.2362E+00,&
 .1246E+01,.1246E+01,.1246E+01,.1255E+01,.1278E+01,.1310E+01,.1324E+01,.1403E+01,.1368E+01,.9350E+00,.2436E+00,&
 .1271E+01,.1271E+01,.1271E+01,.1280E+01,.1304E+01,.1339E+01,.1354E+01,.1431E+01,.1397E+01,.9564E+00,.2510E+00,&
 .1301E+01,.1301E+01,.1301E+01,.1308E+01,.1329E+01,.1364E+01,.1380E+01,.1461E+01,.1429E+01,.9805E+00,.2594E+00,&
 .1331E+01,.1331E+01,.1331E+01,.1337E+01,.1354E+01,.1390E+01,.1405E+01,.1492E+01,.1461E+01,.1005E+01,.2677E+00,&
 .1360E+01,.1360E+01,.1360E+01,.1365E+01,.1379E+01,.1415E+01,.1431E+01,.1522E+01,.1493E+01,.1029E+01,.2761E+00,&
 .1390E+01,.1390E+01,.1390E+01,.1394E+01,.1404E+01,.1441E+01,.1456E+01,.1553E+01,.1525E+01,.1053E+01,.2844E+00,&
 .1420E+01,.1420E+01,.1420E+01,.1422E+01,.1429E+01,.1466E+01,.1482E+01,.1583E+01,.1557E+01,.1077E+01,.2928E+00,&
 .1443E+01,.1443E+01,.1443E+01,.1447E+01,.1459E+01,.1497E+01,.1513E+01,.1614E+01,.1589E+01,.1103E+01,.3022E+00,&
 .1467E+01,.1467E+01,.1467E+01,.1472E+01,.1490E+01,.1528E+01,.1544E+01,.1646E+01,.1621E+01,.1128E+01,.3115E+00,&
 .1490E+01,.1490E+01,.1490E+01,.1498E+01,.1520E+01,.1559E+01,.1576E+01,.1677E+01,.1654E+01,.1154E+01,.3209E+00,&
 .1514E+01,.1514E+01,.1514E+01,.1523E+01,.1551E+01,.1590E+01,.1607E+01,.1709E+01,.1686E+01,.1179E+01,.3302E+00,&
 .1537E+01,.1537E+01,.1537E+01,.1548E+01,.1581E+01,.1621E+01,.1638E+01,.1740E+01,.1718E+01,.1205E+01,.3396E+00,&
 .1571E+01,.1571E+01,.1571E+01,.1581E+01,.1609E+01,.1649E+01,.1666E+01,.1773E+01,.1754E+01,.1234E+01,.3500E+00,&
 .1605E+01,.1605E+01,.1605E+01,.1613E+01,.1637E+01,.1677E+01,.1694E+01,.1806E+01,.1790E+01,.1263E+01,.3604E+00,&
 .1639E+01,.1639E+01,.1639E+01,.1646E+01,.1665E+01,.1704E+01,.1721E+01,.1838E+01,.1826E+01,.1292E+01,.3709E+00,&
 .1673E+01,.1673E+01,.1673E+01,.1678E+01,.1693E+01,.1732E+01,.1749E+01,.1871E+01,.1862E+01,.1321E+01,.3813E+00,&
 .1707E+01,.1707E+01,.1707E+01,.1711E+01,.1721E+01,.1760E+01,.1777E+01,.1904E+01,.1898E+01,.1350E+01,.3917E+00,&
 .1734E+01,.1734E+01,.1734E+01,.1740E+01,.1756E+01,.1793E+01,.1810E+01,.1938E+01,.1934E+01,.1380E+01,.4032E+00,&
 .1761E+01,.1761E+01,.1761E+01,.1769E+01,.1790E+01,.1826E+01,.1842E+01,.1972E+01,.1970E+01,.1410E+01,.4147E+00,&
 .1787E+01,.1787E+01,.1787E+01,.1797E+01,.1825E+01,.1860E+01,.1875E+01,.2007E+01,.2006E+01,.1439E+01,.4262E+00,&
 .1814E+01,.1814E+01,.1814E+01,.1826E+01,.1859E+01,.1893E+01,.1907E+01,.2041E+01,.2042E+01,.1469E+01,.4377E+00,&
 .1841E+01,.1841E+01,.1841E+01,.1855E+01,.1894E+01,.1926E+01,.1940E+01,.2075E+01,.2078E+01,.1499E+01,.4492E+00,&
 .1878E+01,.1878E+01,.1878E+01,.1891E+01,.1926E+01,.1956E+01,.1969E+01,.2112E+01,.2118E+01,.1533E+01,.4619E+00,&
 .1915E+01,.1915E+01,.1915E+01,.1926E+01,.1957E+01,.1985E+01,.1998E+01,.2149E+01,.2158E+01,.1566E+01,.4746E+00,&
 .1953E+01,.1953E+01,.1953E+01,.1962E+01,.1989E+01,.2015E+01,.2026E+01,.2186E+01,.2198E+01,.1600E+01,.4872E+00,&
 .1990E+01,.1990E+01,.1990E+01,.1997E+01,.2020E+01,.2044E+01,.2055E+01,.2223E+01,.2238E+01,.1633E+01,.4999E+00,&
 .2027E+01,.2027E+01,.2027E+01,.2033E+01,.2052E+01,.2074E+01,.2084E+01,.2260E+01,.2278E+01,.1667E+01,.5126E+00,&
 .2058E+01,.2058E+01,.2058E+01,.2065E+01,.2088E+01,.2111E+01,.2121E+01,.2295E+01,.2317E+01,.1701E+01,.5264E+00,&
 .2089E+01,.2089E+01,.2089E+01,.2097E+01,.2123E+01,.2147E+01,.2158E+01,.2330E+01,.2356E+01,.1735E+01,.5403E+00,&
 .2119E+01,.2119E+01,.2119E+01,.2130E+01,.2159E+01,.2184E+01,.2195E+01,.2365E+01,.2395E+01,.1770E+01,.5541E+00,&
 .2150E+01,.2150E+01,.2150E+01,.2162E+01,.2194E+01,.2220E+01,.2232E+01,.2400E+01,.2434E+01,.1804E+01,.5680E+00,&
 .2181E+01,.2181E+01,.2181E+01,.2194E+01,.2230E+01,.2257E+01,.2269E+01,.2435E+01,.2473E+01,.1838E+01,.5818E+00,&
 .2212E+01,.2212E+01,.2212E+01,.2225E+01,.2259E+01,.2291E+01,.2305E+01,.2476E+01,.2516E+01,.1876E+01,.5970E+00,&
 .2243E+01,.2243E+01,.2243E+01,.2255E+01,.2288E+01,.2325E+01,.2341E+01,.2517E+01,.2560E+01,.1915E+01,.6121E+00,&
 .2275E+01,.2275E+01,.2275E+01,.2286E+01,.2317E+01,.2360E+01,.2378E+01,.2559E+01,.2603E+01,.1953E+01,.6273E+00,&
 .2306E+01,.2306E+01,.2306E+01,.2316E+01,.2346E+01,.2394E+01,.2414E+01,.2600E+01,.2647E+01,.1992E+01,.6424E+00,&
 .2337E+01,.2337E+01,.2337E+01,.2347E+01,.2375E+01,.2428E+01,.2450E+01,.2641E+01,.2690E+01,.2030E+01,.6576E+00,&
 .2372E+01,.2372E+01,.2372E+01,.2384E+01,.2418E+01,.2470E+01,.2492E+01,.2676E+01,.2732E+01,.2068E+01,.6740E+00,&
 .2407E+01,.2407E+01,.2407E+01,.2421E+01,.2461E+01,.2512E+01,.2534E+01,.2710E+01,.2775E+01,.2107E+01,.6903E+00,&
 .2441E+01,.2441E+01,.2441E+01,.2458E+01,.2505E+01,.2555E+01,.2575E+01,.2745E+01,.2817E+01,.2145E+01,.7067E+00,&
 .2476E+01,.2476E+01,.2476E+01,.2495E+01,.2548E+01,.2597E+01,.2617E+01,.2779E+01,.2860E+01,.2184E+01,.7230E+00,&
 .2511E+01,.2511E+01,.2511E+01,.2532E+01,.2591E+01,.2639E+01,.2659E+01,.2814E+01,.2902E+01,.2222E+01,.7394E+00,&
 .2543E+01,.2543E+01,.2543E+01,.2562E+01,.2616E+01,.2665E+01,.2686E+01,.2852E+01,.2941E+01,.2257E+01,.7540E+00,&
 .2575E+01,.2575E+01,.2575E+01,.2592E+01,.2641E+01,.2692E+01,.2713E+01,.2890E+01,.2980E+01,.2292E+01,.7687E+00,&
 .2606E+01,.2606E+01,.2606E+01,.2622E+01,.2667E+01,.2718E+01,.2740E+01,.2927E+01,.3018E+01,.2328E+01,.7833E+00,&
 .2638E+01,.2638E+01,.2638E+01,.2652E+01,.2692E+01,.2745E+01,.2767E+01,.2965E+01,.3057E+01,.2363E+01,.7980E+00,&
 .2670E+01,.2670E+01,.2670E+01,.2682E+01,.2717E+01,.2771E+01,.2794E+01,.3003E+01,.3096E+01,.2398E+01,.8126E+00,&
 .2706E+01,.2706E+01,.2706E+01,.2718E+01,.2753E+01,.2800E+01,.2821E+01,.3037E+01,.3135E+01,.2435E+01,.8281E+00,&
 .2743E+01,.2743E+01,.2743E+01,.2754E+01,.2788E+01,.2829E+01,.2847E+01,.3070E+01,.3174E+01,.2471E+01,.8436E+00,&
 .2779E+01,.2779E+01,.2779E+01,.2791E+01,.2824E+01,.2859E+01,.2874E+01,.3104E+01,.3214E+01,.2508E+01,.8592E+00,&
 .2816E+01,.2816E+01,.2816E+01,.2827E+01,.2859E+01,.2888E+01,.2900E+01,.3137E+01,.3253E+01,.2544E+01,.8747E+00,&
 .2852E+01,.2852E+01,.2852E+01,.2863E+01,.2895E+01,.2917E+01,.2927E+01,.3171E+01,.3292E+01,.2581E+01,.8902E+00,&
 .2877E+01,.2877E+01,.2877E+01,.2890E+01,.2929E+01,.2960E+01,.2973E+01,.3202E+01,.3329E+01,.2617E+01,.9066E+00,&
 .2901E+01,.2901E+01,.2901E+01,.2917E+01,.2963E+01,.3002E+01,.3019E+01,.3233E+01,.3367E+01,.2653E+01,.9230E+00,&
 .2926E+01,.2926E+01,.2926E+01,.2945E+01,.2998E+01,.3045E+01,.3066E+01,.3264E+01,.3404E+01,.2688E+01,.9394E+00,&
 .2950E+01,.2950E+01,.2950E+01,.2972E+01,.3032E+01,.3087E+01,.3112E+01,.3295E+01,.3442E+01,.2724E+01,.9558E+00,&
 .2975E+01,.2975E+01,.2975E+01,.2999E+01,.3066E+01,.3130E+01,.3158E+01,.3326E+01,.3479E+01,.2760E+01,.9722E+00,&
 .3010E+01,.3010E+01,.3010E+01,.3031E+01,.3092E+01,.3157E+01,.3186E+01,.3367E+01,.3521E+01,.2800E+01,.9898E+00,&
 .3044E+01,.3044E+01,.3044E+01,.3063E+01,.3118E+01,.3185E+01,.3214E+01,.3408E+01,.3563E+01,.2840E+01,.1007E+01,&
 .3079E+01,.3079E+01,.3079E+01,.3096E+01,.3144E+01,.3212E+01,.3241E+01,.3448E+01,.3606E+01,.2881E+01,.1025E+01,&
 .3113E+01,.3113E+01,.3113E+01,.3128E+01,.3170E+01,.3240E+01,.3269E+01,.3489E+01,.3648E+01,.2921E+01,.1042E+01,&
 .3148E+01,.3148E+01,.3148E+01,.3160E+01,.3196E+01,.3267E+01,.3297E+01,.3530E+01,.3690E+01,.2961E+01,.1060E+01,&
 .3209E+01,.3209E+01,.3209E+01,.3221E+01,.3255E+01,.3327E+01,.3358E+01,.3585E+01,.3758E+01,.3027E+01,.1090E+01,&
 .3270E+01,.3270E+01,.3270E+01,.3281E+01,.3315E+01,.3388E+01,.3419E+01,.3641E+01,.3825E+01,.3093E+01,.1120E+01,&
 .3331E+01,.3331E+01,.3331E+01,.3342E+01,.3374E+01,.3448E+01,.3480E+01,.3696E+01,.3893E+01,.3158E+01,.1151E+01,&
 .3392E+01,.3392E+01,.3392E+01,.3402E+01,.3434E+01,.3509E+01,.3541E+01,.3752E+01,.3960E+01,.3224E+01,.1181E+01,&
 .3453E+01,.3453E+01,.3453E+01,.3463E+01,.3493E+01,.3569E+01,.3602E+01,.3807E+01,.4028E+01,.3290E+01,.1211E+01,&
 .3519E+01,.3519E+01,.3519E+01,.3532E+01,.3572E+01,.3635E+01,.3662E+01,.3892E+01,.4116E+01,.3378E+01,.1252E+01,&
 .3585E+01,.3585E+01,.3585E+01,.3601E+01,.3650E+01,.3701E+01,.3723E+01,.3978E+01,.4203E+01,.3466E+01,.1294E+01,&
 .3650E+01,.3650E+01,.3650E+01,.3671E+01,.3729E+01,.3767E+01,.3783E+01,.4063E+01,.4291E+01,.3554E+01,.1335E+01,&
 .3716E+01,.3716E+01,.3716E+01,.3740E+01,.3807E+01,.3833E+01,.3844E+01,.4149E+01,.4378E+01,.3642E+01,.1377E+01,&
 .3782E+01,.3782E+01,.3782E+01,.3809E+01,.3886E+01,.3899E+01,.3904E+01,.4234E+01,.4466E+01,.3730E+01,.1418E+01,&
 .3887E+01,.3887E+01,.3887E+01,.3893E+01,.3911E+01,.3989E+01,.4022E+01,.4318E+01,.4576E+01,.3843E+01,.1470E+01,&
 .4014E+01,.4014E+01,.4014E+01,.4022E+01,.4044E+01,.4121E+01,.4154E+01,.4424E+01,.4717E+01,.3990E+01,.1545E+01,&
 .4110E+01,.4110E+01,.4110E+01,.4135E+01,.4208E+01,.4251E+01,.4270E+01,.4550E+01,.4846E+01,.4118E+01,.1612E+01,&
 .4230E+01,.4230E+01,.4230E+01,.4253E+01,.4317E+01,.4367E+01,.4389E+01,.4657E+01,.4974E+01,.4254E+01,.1680E+01,&
 .4365E+01,.4365E+01,.4365E+01,.4381E+01,.4428E+01,.4529E+01,.4572E+01,.4851E+01,.5188E+01,.4470E+01,.1786E+01,&
 .4504E+01,.4504E+01,.4504E+01,.4530E+01,.4604E+01,.4649E+01,.4669E+01,.5015E+01,.5349E+01,.4645E+01,.1871E+01,&
 .4700E+01,.4700E+01,.4700E+01,.4709E+01,.4733E+01,.4806E+01,.4838E+01,.5165E+01,.5549E+01,.4857E+01,.1983E+01,&
 .4850E+01,.4850E+01,.4850E+01,.4881E+01,.4971E+01,.5034E+01,.5061E+01,.5355E+01,.5749E+01,.5067E+01,.2101E+01,&
 .5072E+01,.5072E+01,.5072E+01,.5094E+01,.5156E+01,.5204E+01,.5224E+01,.5561E+01,.5983E+01,.5325E+01,.2237E+01,&
 .5331E+01,.5331E+01,.5331E+01,.5348E+01,.5398E+01,.5469E+01,.5500E+01,.5874E+01,.6317E+01,.5681E+01,.2420E+01,&
 .5667E+01,.5667E+01,.5667E+01,.5669E+01,.5674E+01,.5758E+01,.5794E+01,.6108E+01,.6640E+01,.6015E+01,.2612E+01,&
 .5964E+01,.5964E+01,.5964E+01,.5991E+01,.6068E+01,.6104E+01,.6120E+01,.6533E+01,.7073E+01,.6511E+01,.2896E+01,&
 .6438E+01,.6438E+01,.6438E+01,.6458E+01,.6515E+01,.6548E+01,.6562E+01,.7003E+01,.7599E+01,.7071E+01,.3211E+01,&
 .7017E+01,.7017E+01,.7017E+01,.7041E+01,.7109E+01,.7145E+01,.7161E+01,.7586E+01,.8233E+01,.7799E+01,.3661E+01,&
 .7828E+01,.7828E+01,.7828E+01,.7845E+01,.7895E+01,.8007E+01,.8055E+01,.8414E+01,.9188E+01,.8838E+01,.4305E+01,&
 .8792E+01,.8792E+01,.8792E+01,.8832E+01,.8944E+01,.9022E+01,.9056E+01,.9506E+01,.1034E+02,.1016E+02,.5150E+01,&
 .1065E+02,.1065E+02,.1065E+02,.1067E+02,.1073E+02,.1086E+02,.1091E+02,.1136E+02,.1235E+02,.1250E+02,.6784E+01,&
 .1355E+02,.1355E+02,.1355E+02,.1357E+02,.1361E+02,.1368E+02,.1371E+02,.1427E+02,.1541E+02,.1607E+02,.9475E+01,&
 .2060E+02,.2060E+02,.2060E+02,.2068E+02,.2089E+02,.2093E+02,.2095E+02,.2152E+02,.2316E+02,.2485E+02,.1687E+02/
 data (((Bex(ai,k,nh),ai= 6, 6),k=1,11),nh=0,99)/ &
 .1250E+00,.1250E+00,.1250E+00,.1254E+00,.1264E+00,.1254E+00,.1250E+00,.1282E+00,.1335E+00,.1444E+00,.1543E+00,&
 .1282E+00,.1282E+00,.1282E+00,.1286E+00,.1296E+00,.1285E+00,.1281E+00,.1313E+00,.1368E+00,.1478E+00,.1578E+00,&
 .1313E+00,.1313E+00,.1313E+00,.1317E+00,.1328E+00,.1317E+00,.1312E+00,.1344E+00,.1400E+00,.1512E+00,.1612E+00,&
 .1345E+00,.1345E+00,.1345E+00,.1349E+00,.1359E+00,.1348E+00,.1344E+00,.1375E+00,.1433E+00,.1547E+00,.1647E+00,&
 .1376E+00,.1376E+00,.1376E+00,.1380E+00,.1391E+00,.1380E+00,.1375E+00,.1406E+00,.1465E+00,.1581E+00,.1681E+00,&
 .1408E+00,.1408E+00,.1408E+00,.1412E+00,.1423E+00,.1411E+00,.1406E+00,.1437E+00,.1498E+00,.1615E+00,.1716E+00,&
 .1440E+00,.1440E+00,.1440E+00,.1444E+00,.1454E+00,.1443E+00,.1438E+00,.1471E+00,.1533E+00,.1653E+00,.1754E+00,&
 .1472E+00,.1472E+00,.1472E+00,.1476E+00,.1485E+00,.1474E+00,.1470E+00,.1505E+00,.1568E+00,.1690E+00,.1792E+00,&
 .1505E+00,.1505E+00,.1505E+00,.1507E+00,.1516E+00,.1506E+00,.1501E+00,.1540E+00,.1603E+00,.1728E+00,.1831E+00,&
 .1537E+00,.1537E+00,.1537E+00,.1539E+00,.1547E+00,.1537E+00,.1533E+00,.1574E+00,.1638E+00,.1765E+00,.1869E+00,&
 .1569E+00,.1569E+00,.1569E+00,.1571E+00,.1578E+00,.1569E+00,.1565E+00,.1608E+00,.1673E+00,.1803E+00,.1907E+00,&
 .1600E+00,.1600E+00,.1600E+00,.1602E+00,.1608E+00,.1604E+00,.1601E+00,.1643E+00,.1707E+00,.1839E+00,.1946E+00,&
 .1631E+00,.1631E+00,.1631E+00,.1633E+00,.1638E+00,.1638E+00,.1638E+00,.1678E+00,.1741E+00,.1875E+00,.1986E+00,&
 .1661E+00,.1661E+00,.1661E+00,.1663E+00,.1669E+00,.1673E+00,.1674E+00,.1712E+00,.1776E+00,.1912E+00,.2025E+00,&
 .1692E+00,.1692E+00,.1692E+00,.1694E+00,.1699E+00,.1707E+00,.1711E+00,.1747E+00,.1810E+00,.1948E+00,.2065E+00,&
 .1723E+00,.1723E+00,.1723E+00,.1725E+00,.1729E+00,.1742E+00,.1747E+00,.1782E+00,.1844E+00,.1984E+00,.2104E+00,&
 .1761E+00,.1761E+00,.1761E+00,.1764E+00,.1769E+00,.1779E+00,.1782E+00,.1820E+00,.1883E+00,.2024E+00,.2147E+00,&
 .1800E+00,.1800E+00,.1800E+00,.1802E+00,.1809E+00,.1815E+00,.1817E+00,.1857E+00,.1922E+00,.2065E+00,.2190E+00,&
 .1838E+00,.1838E+00,.1838E+00,.1841E+00,.1848E+00,.1852E+00,.1853E+00,.1895E+00,.1961E+00,.2105E+00,.2233E+00,&
 .1877E+00,.1877E+00,.1877E+00,.1879E+00,.1888E+00,.1888E+00,.1888E+00,.1932E+00,.2000E+00,.2146E+00,.2276E+00,&
 .1915E+00,.1915E+00,.1915E+00,.1918E+00,.1928E+00,.1925E+00,.1923E+00,.1970E+00,.2039E+00,.2186E+00,.2319E+00,&
 .1953E+00,.1953E+00,.1953E+00,.1956E+00,.1964E+00,.1966E+00,.1966E+00,.2012E+00,.2079E+00,.2228E+00,.2363E+00,&
 .1991E+00,.1991E+00,.1991E+00,.1993E+00,.2001E+00,.2007E+00,.2010E+00,.2054E+00,.2119E+00,.2270E+00,.2407E+00,&
 .2028E+00,.2028E+00,.2028E+00,.2031E+00,.2037E+00,.2049E+00,.2053E+00,.2095E+00,.2159E+00,.2313E+00,.2450E+00,&
 .2066E+00,.2066E+00,.2066E+00,.2068E+00,.2074E+00,.2090E+00,.2097E+00,.2137E+00,.2199E+00,.2355E+00,.2494E+00,&
 .2104E+00,.2104E+00,.2104E+00,.2106E+00,.2110E+00,.2131E+00,.2140E+00,.2179E+00,.2239E+00,.2397E+00,.2538E+00,&
 .2146E+00,.2146E+00,.2146E+00,.2149E+00,.2154E+00,.2170E+00,.2176E+00,.2216E+00,.2280E+00,.2441E+00,.2586E+00,&
 .2188E+00,.2188E+00,.2188E+00,.2191E+00,.2199E+00,.2209E+00,.2213E+00,.2252E+00,.2321E+00,.2485E+00,.2634E+00,&
 .2230E+00,.2230E+00,.2230E+00,.2234E+00,.2243E+00,.2247E+00,.2249E+00,.2289E+00,.2362E+00,.2530E+00,.2681E+00,&
 .2272E+00,.2272E+00,.2272E+00,.2276E+00,.2288E+00,.2286E+00,.2286E+00,.2325E+00,.2403E+00,.2574E+00,.2729E+00,&
 .2314E+00,.2314E+00,.2314E+00,.2319E+00,.2332E+00,.2325E+00,.2322E+00,.2362E+00,.2444E+00,.2618E+00,.2777E+00,&
 .2351E+00,.2351E+00,.2351E+00,.2356E+00,.2370E+00,.2364E+00,.2362E+00,.2405E+00,.2487E+00,.2662E+00,.2825E+00,&
 .2389E+00,.2389E+00,.2389E+00,.2394E+00,.2408E+00,.2403E+00,.2401E+00,.2448E+00,.2530E+00,.2706E+00,.2873E+00,&
 .2426E+00,.2426E+00,.2426E+00,.2431E+00,.2445E+00,.2442E+00,.2441E+00,.2491E+00,.2573E+00,.2750E+00,.2922E+00,&
 .2464E+00,.2464E+00,.2464E+00,.2469E+00,.2483E+00,.2481E+00,.2480E+00,.2534E+00,.2616E+00,.2794E+00,.2970E+00,&
 .2501E+00,.2501E+00,.2501E+00,.2506E+00,.2521E+00,.2520E+00,.2520E+00,.2577E+00,.2659E+00,.2838E+00,.3018E+00,&
 .2545E+00,.2545E+00,.2545E+00,.2550E+00,.2564E+00,.2564E+00,.2565E+00,.2623E+00,.2705E+00,.2882E+00,.3070E+00,&
 .2589E+00,.2589E+00,.2589E+00,.2594E+00,.2607E+00,.2608E+00,.2610E+00,.2669E+00,.2750E+00,.2926E+00,.3122E+00,&
 .2634E+00,.2634E+00,.2634E+00,.2637E+00,.2649E+00,.2653E+00,.2654E+00,.2715E+00,.2796E+00,.2971E+00,.3175E+00,&
 .2678E+00,.2678E+00,.2678E+00,.2681E+00,.2692E+00,.2697E+00,.2699E+00,.2761E+00,.2841E+00,.3015E+00,.3227E+00,&
 .2722E+00,.2722E+00,.2722E+00,.2725E+00,.2735E+00,.2741E+00,.2744E+00,.2807E+00,.2887E+00,.3059E+00,.3279E+00,&
 .2774E+00,.2774E+00,.2774E+00,.2776E+00,.2785E+00,.2792E+00,.2796E+00,.2854E+00,.2932E+00,.3110E+00,.3333E+00,&
 .2826E+00,.2826E+00,.2826E+00,.2828E+00,.2834E+00,.2843E+00,.2848E+00,.2901E+00,.2977E+00,.3162E+00,.3386E+00,&
 .2877E+00,.2877E+00,.2877E+00,.2879E+00,.2884E+00,.2895E+00,.2899E+00,.2948E+00,.3023E+00,.3213E+00,.3440E+00,&
 .2929E+00,.2929E+00,.2929E+00,.2931E+00,.2933E+00,.2946E+00,.2951E+00,.2995E+00,.3068E+00,.3265E+00,.3493E+00,&
 .2981E+00,.2981E+00,.2981E+00,.2982E+00,.2983E+00,.2997E+00,.3003E+00,.3042E+00,.3113E+00,.3316E+00,.3547E+00,&
 .3021E+00,.3021E+00,.3021E+00,.3024E+00,.3029E+00,.3039E+00,.3043E+00,.3086E+00,.3164E+00,.3368E+00,.3602E+00,&
 .3061E+00,.3061E+00,.3061E+00,.3065E+00,.3075E+00,.3081E+00,.3083E+00,.3130E+00,.3215E+00,.3419E+00,.3658E+00,&
 .3102E+00,.3102E+00,.3102E+00,.3107E+00,.3121E+00,.3122E+00,.3123E+00,.3175E+00,.3265E+00,.3471E+00,.3713E+00,&
 .3142E+00,.3142E+00,.3142E+00,.3148E+00,.3167E+00,.3164E+00,.3163E+00,.3219E+00,.3316E+00,.3522E+00,.3769E+00,&
 .3182E+00,.3182E+00,.3182E+00,.3190E+00,.3213E+00,.3206E+00,.3203E+00,.3263E+00,.3367E+00,.3574E+00,.3824E+00,&
 .3225E+00,.3225E+00,.3225E+00,.3232E+00,.3250E+00,.3248E+00,.3247E+00,.3302E+00,.3409E+00,.3614E+00,.3872E+00,&
 .3268E+00,.3268E+00,.3268E+00,.3273E+00,.3287E+00,.3289E+00,.3290E+00,.3340E+00,.3452E+00,.3654E+00,.3920E+00,&
 .3312E+00,.3312E+00,.3312E+00,.3315E+00,.3324E+00,.3331E+00,.3334E+00,.3379E+00,.3494E+00,.3695E+00,.3968E+00,&
 .3355E+00,.3355E+00,.3355E+00,.3356E+00,.3361E+00,.3372E+00,.3377E+00,.3417E+00,.3537E+00,.3735E+00,.4016E+00,&
 .3398E+00,.3398E+00,.3398E+00,.3398E+00,.3398E+00,.3414E+00,.3421E+00,.3456E+00,.3579E+00,.3775E+00,.4064E+00,&
 .3438E+00,.3438E+00,.3438E+00,.3438E+00,.3440E+00,.3454E+00,.3460E+00,.3501E+00,.3619E+00,.3819E+00,.4113E+00,&
 .3477E+00,.3477E+00,.3477E+00,.3478E+00,.3482E+00,.3494E+00,.3499E+00,.3546E+00,.3659E+00,.3863E+00,.4162E+00,&
 .3517E+00,.3517E+00,.3517E+00,.3519E+00,.3524E+00,.3533E+00,.3537E+00,.3591E+00,.3700E+00,.3907E+00,.4210E+00,&
 .3556E+00,.3556E+00,.3556E+00,.3559E+00,.3566E+00,.3573E+00,.3576E+00,.3636E+00,.3740E+00,.3951E+00,.4259E+00,&
 .3596E+00,.3596E+00,.3596E+00,.3599E+00,.3608E+00,.3613E+00,.3615E+00,.3681E+00,.3780E+00,.3995E+00,.4308E+00,&
 .3642E+00,.3642E+00,.3642E+00,.3645E+00,.3652E+00,.3663E+00,.3668E+00,.3727E+00,.3823E+00,.4042E+00,.4357E+00,&
 .3689E+00,.3689E+00,.3689E+00,.3691E+00,.3697E+00,.3713E+00,.3720E+00,.3774E+00,.3866E+00,.4090E+00,.4407E+00,&
 .3735E+00,.3735E+00,.3735E+00,.3737E+00,.3741E+00,.3764E+00,.3773E+00,.3820E+00,.3910E+00,.4137E+00,.4456E+00,&
 .3782E+00,.3782E+00,.3782E+00,.3783E+00,.3786E+00,.3814E+00,.3825E+00,.3867E+00,.3953E+00,.4185E+00,.4506E+00,&
 .3828E+00,.3828E+00,.3828E+00,.3829E+00,.3830E+00,.3864E+00,.3878E+00,.3913E+00,.3996E+00,.4232E+00,.4555E+00,&
 .3867E+00,.3867E+00,.3867E+00,.3870E+00,.3877E+00,.3903E+00,.3914E+00,.3952E+00,.4041E+00,.4276E+00,.4607E+00,&
 .3906E+00,.3906E+00,.3906E+00,.3911E+00,.3924E+00,.3942E+00,.3950E+00,.3991E+00,.4087E+00,.4319E+00,.4660E+00,&
 .3944E+00,.3944E+00,.3944E+00,.3951E+00,.3972E+00,.3982E+00,.3986E+00,.4031E+00,.4132E+00,.4363E+00,.4712E+00,&
 .3983E+00,.3983E+00,.3983E+00,.3992E+00,.4019E+00,.4021E+00,.4022E+00,.4070E+00,.4178E+00,.4406E+00,.4765E+00,&
 .4022E+00,.4022E+00,.4022E+00,.4033E+00,.4066E+00,.4060E+00,.4058E+00,.4109E+00,.4223E+00,.4450E+00,.4817E+00,&
 .4090E+00,.4090E+00,.4090E+00,.4098E+00,.4123E+00,.4125E+00,.4126E+00,.4174E+00,.4292E+00,.4520E+00,.4896E+00,&
 .4158E+00,.4158E+00,.4158E+00,.4164E+00,.4181E+00,.4189E+00,.4193E+00,.4239E+00,.4361E+00,.4591E+00,.4976E+00,&
 .4227E+00,.4227E+00,.4227E+00,.4229E+00,.4238E+00,.4254E+00,.4261E+00,.4305E+00,.4430E+00,.4661E+00,.5055E+00,&
 .4295E+00,.4295E+00,.4295E+00,.4295E+00,.4296E+00,.4318E+00,.4328E+00,.4370E+00,.4499E+00,.4732E+00,.5135E+00,&
 .4363E+00,.4363E+00,.4363E+00,.4360E+00,.4353E+00,.4383E+00,.4396E+00,.4435E+00,.4568E+00,.4802E+00,.5214E+00,&
 .4464E+00,.4464E+00,.4464E+00,.4463E+00,.4462E+00,.4493E+00,.4506E+00,.4546E+00,.4671E+00,.4911E+00,.5335E+00,&
 .4564E+00,.4564E+00,.4564E+00,.4566E+00,.4571E+00,.4603E+00,.4617E+00,.4658E+00,.4774E+00,.5020E+00,.5457E+00,&
 .4665E+00,.4665E+00,.4665E+00,.4668E+00,.4679E+00,.4713E+00,.4727E+00,.4769E+00,.4878E+00,.5129E+00,.5578E+00,&
 .4765E+00,.4765E+00,.4765E+00,.4771E+00,.4788E+00,.4823E+00,.4838E+00,.4881E+00,.4981E+00,.5238E+00,.5700E+00,&
 .4866E+00,.4866E+00,.4866E+00,.4874E+00,.4897E+00,.4933E+00,.4948E+00,.4992E+00,.5084E+00,.5347E+00,.5821E+00,&
 .5001E+00,.5001E+00,.5001E+00,.5006E+00,.5020E+00,.5028E+00,.5032E+00,.5097E+00,.5201E+00,.5463E+00,.5952E+00,&
 .5118E+00,.5118E+00,.5118E+00,.5134E+00,.5179E+00,.5172E+00,.5169E+00,.5240E+00,.5383E+00,.5651E+00,.6156E+00,&
 .5327E+00,.5327E+00,.5327E+00,.5327E+00,.5328E+00,.5327E+00,.5327E+00,.5405E+00,.5558E+00,.5826E+00,.6358E+00,&
 .5484E+00,.5484E+00,.5484E+00,.5485E+00,.5489E+00,.5523E+00,.5537E+00,.5590E+00,.5738E+00,.6008E+00,.6560E+00,&
 .5711E+00,.5711E+00,.5711E+00,.5717E+00,.5734E+00,.5745E+00,.5749E+00,.5823E+00,.5960E+00,.6240E+00,.6806E+00,&
 .5949E+00,.5949E+00,.5949E+00,.5941E+00,.5920E+00,.5977E+00,.6002E+00,.6055E+00,.6164E+00,.6447E+00,.7059E+00,&
 .6140E+00,.6140E+00,.6140E+00,.6149E+00,.6176E+00,.6184E+00,.6188E+00,.6275E+00,.6377E+00,.6695E+00,.7314E+00,&
 .6340E+00,.6340E+00,.6340E+00,.6354E+00,.6393E+00,.6387E+00,.6385E+00,.6474E+00,.6617E+00,.6926E+00,.7589E+00,&
 .6647E+00,.6647E+00,.6647E+00,.6646E+00,.6642E+00,.6646E+00,.6648E+00,.6732E+00,.6910E+00,.7195E+00,.7902E+00,&
 .6957E+00,.6957E+00,.6957E+00,.6965E+00,.6986E+00,.6992E+00,.6995E+00,.7092E+00,.7245E+00,.7540E+00,.8286E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7375E+00,.7396E+00,.7441E+00,.7460E+00,.7526E+00,.7662E+00,.7986E+00,.8761E+00,&
 .7789E+00,.7789E+00,.7789E+00,.7803E+00,.7844E+00,.7839E+00,.7837E+00,.7936E+00,.8110E+00,.8456E+00,.9284E+00,&
 .8471E+00,.8471E+00,.8471E+00,.8487E+00,.8533E+00,.8532E+00,.8532E+00,.8632E+00,.8805E+00,.9144E+00,.1007E+01,&
 .9305E+00,.9305E+00,.9305E+00,.9328E+00,.9393E+00,.9387E+00,.9384E+00,.9495E+00,.9626E+00,.1002E+01,.1103E+01,&
 .1036E+01,.1036E+01,.1036E+01,.1038E+01,.1043E+01,.1042E+01,.1041E+01,.1053E+01,.1076E+01,.1110E+01,.1225E+01,&
 .1203E+01,.1203E+01,.1203E+01,.1203E+01,.1203E+01,.1203E+01,.1203E+01,.1214E+01,.1241E+01,.1280E+01,.1410E+01,&
 .1427E+01,.1427E+01,.1427E+01,.1428E+01,.1432E+01,.1431E+01,.1431E+01,.1444E+01,.1470E+01,.1518E+01,.1667E+01,&
 .1851E+01,.1851E+01,.1851E+01,.1853E+01,.1858E+01,.1857E+01,.1857E+01,.1874E+01,.1906E+01,.1951E+01,.2142E+01,&
 .2917E+01,.2917E+01,.2917E+01,.2918E+01,.2919E+01,.2926E+01,.2929E+01,.2953E+01,.2977E+01,.3058E+01,.3309E+01/
 data (((Bex(ai,k,nh),ai= 7, 7),k=1,11),nh=0,99)/ &
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01,&
 .5168E+01,.5168E+01,.5168E+01,.5028E+01,.4631E+01,.4257E+01,.4097E+01,.2503E+01,.9626E+00,.2219E+00,.2345E-01/
 data (((Bex(ai,k,nh),ai= 8, 8),k=1,11),nh=0,99)/ &
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01,&
 .3468E+01,.3468E+01,.3468E+01,.3455E+01,.3419E+01,.3331E+01,.3294E+01,.2580E+01,.1402E+01,.4594E+00,.4618E-01/
 data (((Bex(ai,k,nh),ai= 9, 9),k=1,11),nh=0,99)/ &
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00,&
 .1745E+01,.1745E+01,.1745E+01,.1758E+01,.1796E+01,.1823E+01,.1835E+01,.1819E+01,.1434E+01,.7302E+00,.1065E+00/
 data (((Bex(ai,k,nh),ai=10,10),k=1,11),nh=0,99)/ &
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00,&
 .8926E+00,.8926E+00,.8926E+00,.8984E+00,.9149E+00,.9305E+00,.9372E+00,.1013E+01,.1022E+01,.7607E+00,.1857E+00/
 data (((Bex(ai,k,nh),ai=11,11),k=1,11),nh=0,99)/ &
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00,&
 .4546E+00,.4546E+00,.4546E+00,.4563E+00,.4613E+00,.4670E+00,.4695E+00,.4994E+00,.5457E+00,.5381E+00,.2239E+00/
 data (((Bex(ai,k,nh),ai=12,12),k=1,11),nh=0,99)/ &
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00,&
 .2560E+00,.2560E+00,.2560E+00,.2566E+00,.2584E+00,.2601E+00,.2609E+00,.2714E+00,.2913E+00,.3227E+00,.2124E+00/
 data (((Bex(ai,k,nh),ai=13,13),k=1,11),nh=0,99)/ &
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00,&
 .1329E+00,.1329E+00,.1329E+00,.1331E+00,.1335E+00,.1340E+00,.1342E+00,.1374E+00,.1435E+00,.1567E+00,.1466E+00/
 data (((Bex(ai,k,nh),ai=14,14),k=1,11),nh=0,99)/ &
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01,&
 .7336E-01,.7336E-01,.7336E-01,.7346E-01,.7376E-01,.7401E-01,.7412E-01,.7527E-01,.7740E-01,.8163E-01,.8616E-01/
 data (((w0(ai,k,nh),ai= 1, 1),k=1,11),nh=0,99)/ &
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9766E+00,.1023E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9768E+00,.1038E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9771E+00,.1053E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9773E+00,.1069E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9776E+00,.1084E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9778E+00,.1099E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9780E+00,.1116E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9782E+00,.1133E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9785E+00,.1151E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9787E+00,.1168E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9789E+00,.1185E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9791E+00,.1203E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9793E+00,.1221E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9794E+00,.1239E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9796E+00,.1257E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9798E+00,.1275E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9800E+00,.1295E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9802E+00,.1315E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9804E+00,.1334E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9806E+00,.1354E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9808E+00,.1374E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9810E+00,.1395E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9811E+00,.1416E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9813E+00,.1437E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9814E+00,.1458E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9816E+00,.1479E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9818E+00,.1501E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9819E+00,.1523E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9821E+00,.1544E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9822E+00,.1566E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9824E+00,.1588E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9825E+00,.1611E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9827E+00,.1633E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9828E+00,.1656E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9830E+00,.1678E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9831E+00,.1701E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9832E+00,.1723E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9833E+00,.1745E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9835E+00,.1768E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9836E+00,.1790E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9837E+00,.1812E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9838E+00,.1835E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9839E+00,.1859E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9841E+00,.1882E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9842E+00,.1906E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9843E+00,.1929E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9844E+00,.1953E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9845E+00,.1976E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9846E+00,.2000E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9847E+00,.2023E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9848E+00,.2047E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9849E+00,.2069E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9850E+00,.2091E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9851E+00,.2113E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9852E+00,.2135E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9853E+00,.2157E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9854E+00,.2178E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9855E+00,.2199E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9855E+00,.2220E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9856E+00,.2241E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9857E+00,.2262E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9858E+00,.2284E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9859E+00,.2306E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9859E+00,.2327E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9860E+00,.2349E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9861E+00,.2371E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9862E+00,.2393E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9863E+00,.2414E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9863E+00,.2436E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9864E+00,.2457E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9865E+00,.2479E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9866E+00,.2514E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9867E+00,.2550E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9869E+00,.2585E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9870E+00,.2621E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9871E+00,.2656E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9872E+00,.2691E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9873E+00,.2725E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9874E+00,.2760E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9875E+00,.2794E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9876E+00,.2829E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9877E+00,.2866E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9878E+00,.2903E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9879E+00,.2940E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9881E+00,.2995E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9882E+00,.3050E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9883E+00,.3103E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9886E+00,.3174E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9887E+00,.3243E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9889E+00,.3328E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9891E+00,.3427E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9893E+00,.3524E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9896E+00,.3648E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9898E+00,.3768E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9901E+00,.3911E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9904E+00,.4101E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9908E+00,.4302E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9912E+00,.4555E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9917E+00,.4916E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9923E+00,.5487E+00/
 data (((w0(ai,k,nh),ai= 2, 2),k=1,11),nh=0,99)/ &
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3081E+00,.3081E+00,.3081E+00,.3093E+00,.3128E+00,.2973E+00,.2906E+00,.2103E+00,.1049E+00,.3129E-01,.2656E-02,&
 .3085E+00,.3085E+00,.3085E+00,.3097E+00,.3131E+00,.2976E+00,.2909E+00,.2106E+00,.1051E+00,.3133E-01,.2660E-02,&
 .3089E+00,.3089E+00,.3089E+00,.3100E+00,.3134E+00,.2979E+00,.2912E+00,.2108E+00,.1052E+00,.3138E-01,.2663E-02,&
 .3092E+00,.3092E+00,.3092E+00,.3104E+00,.3137E+00,.2981E+00,.2914E+00,.2111E+00,.1054E+00,.3142E-01,.2667E-02,&
 .3096E+00,.3096E+00,.3096E+00,.3107E+00,.3140E+00,.2984E+00,.2917E+00,.2113E+00,.1055E+00,.3147E-01,.2670E-02,&
 .3100E+00,.3100E+00,.3100E+00,.3111E+00,.3143E+00,.2987E+00,.2920E+00,.2116E+00,.1057E+00,.3151E-01,.2674E-02,&
 .3100E+00,.3100E+00,.3100E+00,.3111E+00,.3143E+00,.2987E+00,.2920E+00,.2116E+00,.1057E+00,.3151E-01,.2674E-02,&
 .3100E+00,.3100E+00,.3100E+00,.3111E+00,.3143E+00,.2987E+00,.2920E+00,.2116E+00,.1057E+00,.3151E-01,.2674E-02,&
 .3100E+00,.3100E+00,.3100E+00,.3111E+00,.3143E+00,.2987E+00,.2920E+00,.2116E+00,.1057E+00,.3151E-01,.2674E-02,&
 .3100E+00,.3100E+00,.3100E+00,.3111E+00,.3143E+00,.2987E+00,.2920E+00,.2116E+00,.1057E+00,.3151E-01,.2674E-02,&
 .3100E+00,.3100E+00,.3100E+00,.3111E+00,.3143E+00,.2987E+00,.2920E+00,.2116E+00,.1057E+00,.3151E-01,.2674E-02,&
 .3112E+00,.3112E+00,.3112E+00,.3123E+00,.3153E+00,.2996E+00,.2929E+00,.2124E+00,.1062E+00,.3166E-01,.2686E-02,&
 .3124E+00,.3124E+00,.3124E+00,.3134E+00,.3163E+00,.3006E+00,.2939E+00,.2132E+00,.1067E+00,.3181E-01,.2698E-02,&
 .3137E+00,.3137E+00,.3137E+00,.3146E+00,.3172E+00,.3015E+00,.2948E+00,.2139E+00,.1071E+00,.3196E-01,.2711E-02,&
 .3149E+00,.3149E+00,.3149E+00,.3157E+00,.3182E+00,.3025E+00,.2958E+00,.2147E+00,.1076E+00,.3211E-01,.2723E-02,&
 .3161E+00,.3161E+00,.3161E+00,.3169E+00,.3192E+00,.3034E+00,.2967E+00,.2155E+00,.1081E+00,.3226E-01,.2735E-02,&
 .3200E+00,.3200E+00,.3200E+00,.3206E+00,.3224E+00,.3065E+00,.2998E+00,.2181E+00,.1097E+00,.3276E-01,.2775E-02,&
 .3238E+00,.3238E+00,.3238E+00,.3243E+00,.3256E+00,.3096E+00,.3028E+00,.2207E+00,.1113E+00,.3326E-01,.2815E-02,&
 .3277E+00,.3277E+00,.3277E+00,.3279E+00,.3288E+00,.3128E+00,.3059E+00,.2234E+00,.1129E+00,.3376E-01,.2856E-02,&
 .3315E+00,.3315E+00,.3315E+00,.3316E+00,.3320E+00,.3159E+00,.3089E+00,.2260E+00,.1145E+00,.3426E-01,.2896E-02,&
 .3354E+00,.3354E+00,.3354E+00,.3353E+00,.3352E+00,.3190E+00,.3120E+00,.2286E+00,.1161E+00,.3476E-01,.2936E-02,&
 .3413E+00,.3413E+00,.3413E+00,.3410E+00,.3402E+00,.3238E+00,.3168E+00,.2328E+00,.1187E+00,.3561E-01,.3003E-02,&
 .3472E+00,.3472E+00,.3472E+00,.3466E+00,.3452E+00,.3287E+00,.3216E+00,.2370E+00,.1214E+00,.3646E-01,.3070E-02,&
 .3530E+00,.3530E+00,.3530E+00,.3523E+00,.3501E+00,.3335E+00,.3264E+00,.2411E+00,.1240E+00,.3731E-01,.3138E-02,&
 .3589E+00,.3589E+00,.3589E+00,.3579E+00,.3551E+00,.3384E+00,.3312E+00,.2453E+00,.1267E+00,.3816E-01,.3205E-02,&
 .3648E+00,.3648E+00,.3648E+00,.3636E+00,.3601E+00,.3432E+00,.3360E+00,.2495E+00,.1293E+00,.3901E-01,.3272E-02,&
 .3746E+00,.3746E+00,.3746E+00,.3730E+00,.3685E+00,.3514E+00,.3441E+00,.2567E+00,.1339E+00,.4053E-01,.3392E-02,&
 .3813E+00,.3813E+00,.3813E+00,.3795E+00,.3743E+00,.3571E+00,.3497E+00,.2617E+00,.1372E+00,.4161E-01,.3477E-02,&
 .3916E+00,.3916E+00,.3916E+00,.3894E+00,.3833E+00,.3659E+00,.3585E+00,.2695E+00,.1423E+00,.4333E-01,.3612E-02,&
 .3987E+00,.3987E+00,.3987E+00,.3963E+00,.3895E+00,.3720E+00,.3645E+00,.2750E+00,.1459E+00,.4455E-01,.3708E-02,&
 .4095E+00,.4095E+00,.4095E+00,.4068E+00,.3990E+00,.3814E+00,.3738E+00,.2834E+00,.1516E+00,.4649E-01,.3860E-02,&
 .4205E+00,.4205E+00,.4205E+00,.4175E+00,.4088E+00,.3910E+00,.3834E+00,.2922E+00,.1575E+00,.4856E-01,.4023E-02,&
 .4280E+00,.4280E+00,.4280E+00,.4247E+00,.4154E+00,.3975E+00,.3899E+00,.2982E+00,.1617E+00,.5001E-01,.4137E-02,&
 .4393E+00,.4393E+00,.4393E+00,.4357E+00,.4256E+00,.4077E+00,.4000E+00,.3075E+00,.1681E+00,.5231E-01,.4318E-02,&
 .4470E+00,.4470E+00,.4470E+00,.4432E+00,.4325E+00,.4145E+00,.4068E+00,.3139E+00,.1726E+00,.5392E-01,.4444E-02,&
 .4585E+00,.4585E+00,.4585E+00,.4544E+00,.4429E+00,.4248E+00,.4171E+00,.3237E+00,.1796E+00,.5646E-01,.4644E-02,&
 .4701E+00,.4701E+00,.4701E+00,.4658E+00,.4535E+00,.4354E+00,.4277E+00,.3338E+00,.1869E+00,.5915E-01,.4856E-02,&
 .4818E+00,.4818E+00,.4818E+00,.4772E+00,.4642E+00,.4461E+00,.4383E+00,.3440E+00,.1944E+00,.6198E-01,.5080E-02,&
 .4935E+00,.4935E+00,.4935E+00,.4887E+00,.4750E+00,.4569E+00,.4491E+00,.3545E+00,.2023E+00,.6498E-01,.5317E-02,&
 .5091E+00,.5091E+00,.5091E+00,.5040E+00,.4894E+00,.4714E+00,.4637E+00,.3689E+00,.2133E+00,.6923E-01,.5655E-02,&
 .5245E+00,.5245E+00,.5245E+00,.5192E+00,.5040E+00,.4861E+00,.4784E+00,.3835E+00,.2247E+00,.7377E-01,.6017E-02,&
 .5437E+00,.5437E+00,.5437E+00,.5381E+00,.5221E+00,.5044E+00,.4968E+00,.4021E+00,.2396E+00,.7989E-01,.6507E-02,&
 .5699E+00,.5699E+00,.5699E+00,.5640E+00,.5472E+00,.5298E+00,.5224E+00,.4287E+00,.2616E+00,.8925E-01,.7266E-02,&
 .5987E+00,.5987E+00,.5987E+00,.5926E+00,.5754E+00,.5586E+00,.5514E+00,.4595E+00,.2883E+00,.1012E+00,.8247E-02,&
 .6646E+00,.6646E+00,.6646E+00,.6585E+00,.6413E+00,.6265E+00,.6202E+00,.5355E+00,.3600E+00,.1368E+00,.1128E-01/
 data (((w0(ai,k,nh),ai= 3, 3),k=1,11),nh=0,99)/ &
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00/
 data (((w0(ai,k,nh),ai= 4, 4),k=1,11),nh=0,99)/ &
 .8395E+00,.8395E+00,.8395E+00,.8684E+00,.9505E+00,.9634E+00,.9689E+00,.9616E+00,.8776E+00,.7338E+00,.2193E+00,&
 .8409E+00,.8409E+00,.8409E+00,.8696E+00,.9510E+00,.9638E+00,.9692E+00,.9620E+00,.8787E+00,.7359E+00,.2176E+00,&
 .8423E+00,.8423E+00,.8423E+00,.8707E+00,.9516E+00,.9642E+00,.9695E+00,.9624E+00,.8798E+00,.7381E+00,.2158E+00,&
 .8436E+00,.8436E+00,.8436E+00,.8719E+00,.9521E+00,.9645E+00,.9699E+00,.9627E+00,.8810E+00,.7402E+00,.2141E+00,&
 .8450E+00,.8450E+00,.8450E+00,.8730E+00,.9527E+00,.9649E+00,.9702E+00,.9631E+00,.8821E+00,.7424E+00,.2123E+00,&
 .8464E+00,.8464E+00,.8464E+00,.8742E+00,.9532E+00,.9653E+00,.9705E+00,.9635E+00,.8832E+00,.7445E+00,.2106E+00,&
 .8476E+00,.8476E+00,.8476E+00,.8752E+00,.9537E+00,.9656E+00,.9708E+00,.9639E+00,.8843E+00,.7466E+00,.2098E+00,&
 .8489E+00,.8489E+00,.8489E+00,.8763E+00,.9541E+00,.9660E+00,.9711E+00,.9642E+00,.8853E+00,.7487E+00,.2091E+00,&
 .8501E+00,.8501E+00,.8501E+00,.8773E+00,.9546E+00,.9663E+00,.9713E+00,.9646E+00,.8864E+00,.7508E+00,.2083E+00,&
 .8514E+00,.8514E+00,.8514E+00,.8784E+00,.9550E+00,.9667E+00,.9716E+00,.9649E+00,.8874E+00,.7529E+00,.2076E+00,&
 .8526E+00,.8526E+00,.8526E+00,.8794E+00,.9555E+00,.9670E+00,.9719E+00,.9653E+00,.8885E+00,.7550E+00,.2068E+00,&
 .8538E+00,.8538E+00,.8538E+00,.8804E+00,.9559E+00,.9673E+00,.9721E+00,.9656E+00,.8895E+00,.7570E+00,.2065E+00,&
 .8550E+00,.8550E+00,.8550E+00,.8814E+00,.9563E+00,.9676E+00,.9724E+00,.9660E+00,.8905E+00,.7591E+00,.2062E+00,&
 .8563E+00,.8563E+00,.8563E+00,.8824E+00,.9566E+00,.9678E+00,.9726E+00,.9663E+00,.8916E+00,.7611E+00,.2059E+00,&
 .8575E+00,.8575E+00,.8575E+00,.8834E+00,.9570E+00,.9681E+00,.9729E+00,.9667E+00,.8926E+00,.7632E+00,.2056E+00,&
 .8587E+00,.8587E+00,.8587E+00,.8844E+00,.9574E+00,.9684E+00,.9731E+00,.9670E+00,.8936E+00,.7652E+00,.2053E+00,&
 .8599E+00,.8599E+00,.8599E+00,.8854E+00,.9578E+00,.9687E+00,.9734E+00,.9673E+00,.8946E+00,.7672E+00,.2052E+00,&
 .8612E+00,.8612E+00,.8612E+00,.8864E+00,.9582E+00,.9690E+00,.9737E+00,.9676E+00,.8956E+00,.7691E+00,.2052E+00,&
 .8624E+00,.8624E+00,.8624E+00,.8875E+00,.9586E+00,.9694E+00,.9740E+00,.9680E+00,.8965E+00,.7711E+00,.2051E+00,&
 .8637E+00,.8637E+00,.8637E+00,.8885E+00,.9590E+00,.9697E+00,.9743E+00,.9683E+00,.8975E+00,.7730E+00,.2051E+00,&
 .8649E+00,.8649E+00,.8649E+00,.8895E+00,.9594E+00,.9700E+00,.9746E+00,.9686E+00,.8985E+00,.7750E+00,.2050E+00,&
 .8661E+00,.8661E+00,.8661E+00,.8905E+00,.9598E+00,.9703E+00,.9749E+00,.9689E+00,.8995E+00,.7769E+00,.2051E+00,&
 .8673E+00,.8673E+00,.8673E+00,.8915E+00,.9602E+00,.9706E+00,.9751E+00,.9692E+00,.9004E+00,.7788E+00,.2052E+00,&
 .8684E+00,.8684E+00,.8684E+00,.8924E+00,.9607E+00,.9710E+00,.9754E+00,.9695E+00,.9014E+00,.7807E+00,.2052E+00,&
 .8696E+00,.8696E+00,.8696E+00,.8934E+00,.9611E+00,.9713E+00,.9756E+00,.9698E+00,.9023E+00,.7826E+00,.2053E+00,&
 .8708E+00,.8708E+00,.8708E+00,.8944E+00,.9615E+00,.9716E+00,.9759E+00,.9701E+00,.9033E+00,.7845E+00,.2054E+00,&
 .8719E+00,.8719E+00,.8719E+00,.8953E+00,.9619E+00,.9719E+00,.9761E+00,.9704E+00,.9042E+00,.7864E+00,.2056E+00,&
 .8729E+00,.8729E+00,.8729E+00,.8962E+00,.9623E+00,.9722E+00,.9764E+00,.9707E+00,.9051E+00,.7882E+00,.2058E+00,&
 .8740E+00,.8740E+00,.8740E+00,.8970E+00,.9627E+00,.9724E+00,.9766E+00,.9710E+00,.9060E+00,.7901E+00,.2060E+00,&
 .8750E+00,.8750E+00,.8750E+00,.8979E+00,.9631E+00,.9727E+00,.9769E+00,.9713E+00,.9069E+00,.7919E+00,.2062E+00,&
 .8761E+00,.8761E+00,.8761E+00,.8988E+00,.9635E+00,.9730E+00,.9771E+00,.9716E+00,.9078E+00,.7938E+00,.2064E+00,&
 .8770E+00,.8770E+00,.8770E+00,.8996E+00,.9638E+00,.9732E+00,.9773E+00,.9719E+00,.9087E+00,.7956E+00,.2067E+00,&
 .8780E+00,.8780E+00,.8780E+00,.9004E+00,.9641E+00,.9735E+00,.9775E+00,.9722E+00,.9096E+00,.7973E+00,.2069E+00,&
 .8789E+00,.8789E+00,.8789E+00,.9011E+00,.9645E+00,.9737E+00,.9777E+00,.9724E+00,.9104E+00,.7991E+00,.2072E+00,&
 .8799E+00,.8799E+00,.8799E+00,.9019E+00,.9648E+00,.9740E+00,.9779E+00,.9727E+00,.9113E+00,.8008E+00,.2074E+00,&
 .8808E+00,.8808E+00,.8808E+00,.9027E+00,.9651E+00,.9742E+00,.9781E+00,.9730E+00,.9122E+00,.8026E+00,.2077E+00,&
 .8818E+00,.8818E+00,.8818E+00,.9035E+00,.9654E+00,.9744E+00,.9783E+00,.9733E+00,.9130E+00,.8043E+00,.2080E+00,&
 .8827E+00,.8827E+00,.8827E+00,.9043E+00,.9657E+00,.9746E+00,.9785E+00,.9735E+00,.9138E+00,.8060E+00,.2083E+00,&
 .8837E+00,.8837E+00,.8837E+00,.9051E+00,.9660E+00,.9749E+00,.9786E+00,.9738E+00,.9147E+00,.8077E+00,.2087E+00,&
 .8846E+00,.8846E+00,.8846E+00,.9059E+00,.9663E+00,.9751E+00,.9788E+00,.9740E+00,.9155E+00,.8094E+00,.2090E+00,&
 .8856E+00,.8856E+00,.8856E+00,.9067E+00,.9666E+00,.9753E+00,.9790E+00,.9743E+00,.9163E+00,.8111E+00,.2093E+00,&
 .8866E+00,.8866E+00,.8866E+00,.9075E+00,.9669E+00,.9755E+00,.9792E+00,.9745E+00,.9171E+00,.8127E+00,.2097E+00,&
 .8875E+00,.8875E+00,.8875E+00,.9083E+00,.9672E+00,.9758E+00,.9794E+00,.9747E+00,.9179E+00,.8144E+00,.2101E+00,&
 .8885E+00,.8885E+00,.8885E+00,.9090E+00,.9674E+00,.9760E+00,.9797E+00,.9750E+00,.9187E+00,.8160E+00,.2104E+00,&
 .8894E+00,.8894E+00,.8894E+00,.9098E+00,.9677E+00,.9763E+00,.9799E+00,.9752E+00,.9195E+00,.8177E+00,.2108E+00,&
 .8904E+00,.8904E+00,.8904E+00,.9106E+00,.9680E+00,.9765E+00,.9801E+00,.9754E+00,.9203E+00,.8193E+00,.2112E+00,&
 .8913E+00,.8913E+00,.8913E+00,.9114E+00,.9683E+00,.9767E+00,.9803E+00,.9756E+00,.9210E+00,.8209E+00,.2116E+00,&
 .8923E+00,.8923E+00,.8923E+00,.9122E+00,.9686E+00,.9770E+00,.9805E+00,.9759E+00,.9218E+00,.8224E+00,.2120E+00,&
 .8932E+00,.8932E+00,.8932E+00,.9129E+00,.9690E+00,.9772E+00,.9807E+00,.9761E+00,.9225E+00,.8240E+00,.2124E+00,&
 .8942E+00,.8942E+00,.8942E+00,.9137E+00,.9693E+00,.9775E+00,.9809E+00,.9764E+00,.9233E+00,.8255E+00,.2128E+00,&
 .8951E+00,.8951E+00,.8951E+00,.9145E+00,.9696E+00,.9777E+00,.9811E+00,.9766E+00,.9240E+00,.8271E+00,.2132E+00,&
 .8961E+00,.8961E+00,.8961E+00,.9153E+00,.9700E+00,.9779E+00,.9813E+00,.9769E+00,.9249E+00,.8289E+00,.2137E+00,&
 .8970E+00,.8970E+00,.8970E+00,.9161E+00,.9703E+00,.9782E+00,.9815E+00,.9771E+00,.9258E+00,.8307E+00,.2142E+00,&
 .8980E+00,.8980E+00,.8980E+00,.9169E+00,.9707E+00,.9784E+00,.9817E+00,.9774E+00,.9266E+00,.8325E+00,.2147E+00,&
 .8989E+00,.8989E+00,.8989E+00,.9177E+00,.9710E+00,.9787E+00,.9819E+00,.9776E+00,.9275E+00,.8343E+00,.2152E+00,&
 .8999E+00,.8999E+00,.8999E+00,.9185E+00,.9714E+00,.9789E+00,.9821E+00,.9779E+00,.9284E+00,.8361E+00,.2157E+00,&
 .9007E+00,.9007E+00,.9007E+00,.9192E+00,.9717E+00,.9791E+00,.9823E+00,.9782E+00,.9292E+00,.8378E+00,.2162E+00,&
 .9015E+00,.9015E+00,.9015E+00,.9199E+00,.9719E+00,.9793E+00,.9825E+00,.9784E+00,.9300E+00,.8395E+00,.2168E+00,&
 .9024E+00,.9024E+00,.9024E+00,.9205E+00,.9722E+00,.9795E+00,.9826E+00,.9787E+00,.9308E+00,.8411E+00,.2173E+00,&
 .9032E+00,.9032E+00,.9032E+00,.9212E+00,.9724E+00,.9797E+00,.9828E+00,.9789E+00,.9316E+00,.8428E+00,.2179E+00,&
 .9040E+00,.9040E+00,.9040E+00,.9219E+00,.9727E+00,.9799E+00,.9830E+00,.9792E+00,.9324E+00,.8445E+00,.2184E+00,&
 .9048E+00,.9048E+00,.9048E+00,.9225E+00,.9729E+00,.9801E+00,.9831E+00,.9794E+00,.9331E+00,.8458E+00,.2189E+00,&
 .9056E+00,.9056E+00,.9056E+00,.9231E+00,.9731E+00,.9802E+00,.9833E+00,.9796E+00,.9337E+00,.8472E+00,.2194E+00,&
 .9063E+00,.9063E+00,.9063E+00,.9238E+00,.9733E+00,.9804E+00,.9834E+00,.9797E+00,.9344E+00,.8485E+00,.2198E+00,&
 .9071E+00,.9071E+00,.9071E+00,.9244E+00,.9735E+00,.9805E+00,.9836E+00,.9799E+00,.9350E+00,.8499E+00,.2203E+00,&
 .9079E+00,.9079E+00,.9079E+00,.9250E+00,.9737E+00,.9807E+00,.9837E+00,.9801E+00,.9357E+00,.8512E+00,.2208E+00,&
 .9088E+00,.9088E+00,.9088E+00,.9257E+00,.9740E+00,.9809E+00,.9839E+00,.9803E+00,.9364E+00,.8527E+00,.2214E+00,&
 .9097E+00,.9097E+00,.9097E+00,.9265E+00,.9743E+00,.9811E+00,.9841E+00,.9805E+00,.9371E+00,.8542E+00,.2220E+00,&
 .9106E+00,.9106E+00,.9106E+00,.9272E+00,.9745E+00,.9814E+00,.9842E+00,.9808E+00,.9379E+00,.8558E+00,.2225E+00,&
 .9115E+00,.9115E+00,.9115E+00,.9280E+00,.9748E+00,.9816E+00,.9844E+00,.9810E+00,.9386E+00,.8573E+00,.2231E+00,&
 .9124E+00,.9124E+00,.9124E+00,.9287E+00,.9751E+00,.9818E+00,.9846E+00,.9812E+00,.9393E+00,.8588E+00,.2237E+00,&
 .9136E+00,.9136E+00,.9136E+00,.9297E+00,.9755E+00,.9821E+00,.9848E+00,.9815E+00,.9403E+00,.8609E+00,.2246E+00,&
 .9147E+00,.9147E+00,.9147E+00,.9306E+00,.9759E+00,.9824E+00,.9851E+00,.9818E+00,.9413E+00,.8630E+00,.2255E+00,&
 .9159E+00,.9159E+00,.9159E+00,.9316E+00,.9763E+00,.9826E+00,.9853E+00,.9821E+00,.9423E+00,.8652E+00,.2264E+00,&
 .9170E+00,.9170E+00,.9170E+00,.9325E+00,.9767E+00,.9829E+00,.9856E+00,.9824E+00,.9433E+00,.8673E+00,.2273E+00,&
 .9182E+00,.9182E+00,.9182E+00,.9335E+00,.9771E+00,.9832E+00,.9858E+00,.9827E+00,.9443E+00,.8694E+00,.2282E+00,&
 .9195E+00,.9195E+00,.9195E+00,.9346E+00,.9775E+00,.9835E+00,.9861E+00,.9831E+00,.9455E+00,.8719E+00,.2294E+00,&
 .9208E+00,.9208E+00,.9208E+00,.9357E+00,.9779E+00,.9838E+00,.9863E+00,.9834E+00,.9467E+00,.8745E+00,.2307E+00,&
 .9222E+00,.9222E+00,.9222E+00,.9367E+00,.9783E+00,.9841E+00,.9866E+00,.9838E+00,.9479E+00,.8770E+00,.2319E+00,&
 .9235E+00,.9235E+00,.9235E+00,.9378E+00,.9787E+00,.9844E+00,.9868E+00,.9841E+00,.9491E+00,.8796E+00,.2332E+00,&
 .9248E+00,.9248E+00,.9248E+00,.9389E+00,.9791E+00,.9847E+00,.9871E+00,.9845E+00,.9503E+00,.8821E+00,.2344E+00,&
 .9266E+00,.9266E+00,.9266E+00,.9404E+00,.9795E+00,.9850E+00,.9874E+00,.9849E+00,.9517E+00,.8851E+00,.2360E+00,&
 .9283E+00,.9283E+00,.9283E+00,.9418E+00,.9801E+00,.9855E+00,.9878E+00,.9852E+00,.9530E+00,.8879E+00,.2376E+00,&
 .9300E+00,.9300E+00,.9300E+00,.9432E+00,.9806E+00,.9858E+00,.9881E+00,.9856E+00,.9543E+00,.8907E+00,.2391E+00,&
 .9315E+00,.9315E+00,.9315E+00,.9444E+00,.9811E+00,.9862E+00,.9884E+00,.9860E+00,.9556E+00,.8934E+00,.2408E+00,&
 .9332E+00,.9332E+00,.9332E+00,.9458E+00,.9817E+00,.9867E+00,.9888E+00,.9864E+00,.9572E+00,.8969E+00,.2429E+00,&
 .9348E+00,.9348E+00,.9348E+00,.9471E+00,.9823E+00,.9871E+00,.9891E+00,.9869E+00,.9588E+00,.9001E+00,.2450E+00,&
 .9367E+00,.9367E+00,.9367E+00,.9487E+00,.9829E+00,.9875E+00,.9895E+00,.9875E+00,.9606E+00,.9041E+00,.2477E+00,&
 .9391E+00,.9391E+00,.9391E+00,.9506E+00,.9834E+00,.9879E+00,.9898E+00,.9880E+00,.9623E+00,.9078E+00,.2504E+00,&
 .9417E+00,.9417E+00,.9417E+00,.9527E+00,.9841E+00,.9885E+00,.9904E+00,.9886E+00,.9643E+00,.9121E+00,.2536E+00,&
 .9441E+00,.9441E+00,.9441E+00,.9547E+00,.9849E+00,.9890E+00,.9908E+00,.9891E+00,.9662E+00,.9160E+00,.2568E+00,&
 .9464E+00,.9464E+00,.9464E+00,.9566E+00,.9857E+00,.9896E+00,.9913E+00,.9897E+00,.9682E+00,.9204E+00,.2606E+00,&
 .9487E+00,.9487E+00,.9487E+00,.9585E+00,.9864E+00,.9901E+00,.9917E+00,.9903E+00,.9703E+00,.9250E+00,.2648E+00,&
 .9521E+00,.9521E+00,.9521E+00,.9612E+00,.9872E+00,.9908E+00,.9923E+00,.9911E+00,.9728E+00,.9302E+00,.2701E+00,&
 .9551E+00,.9551E+00,.9551E+00,.9637E+00,.9882E+00,.9915E+00,.9929E+00,.9918E+00,.9751E+00,.9354E+00,.2760E+00,&
 .9587E+00,.9587E+00,.9587E+00,.9667E+00,.9893E+00,.9922E+00,.9935E+00,.9926E+00,.9780E+00,.9416E+00,.2838E+00,&
 .9630E+00,.9630E+00,.9630E+00,.9701E+00,.9905E+00,.9932E+00,.9943E+00,.9935E+00,.9811E+00,.9482E+00,.2936E+00,&
 .9670E+00,.9670E+00,.9670E+00,.9733E+00,.9914E+00,.9939E+00,.9950E+00,.9944E+00,.9840E+00,.9546E+00,.3047E+00,&
 .9723E+00,.9723E+00,.9723E+00,.9777E+00,.9930E+00,.9950E+00,.9958E+00,.9956E+00,.9876E+00,.9625E+00,.3222E+00,&
 .9786E+00,.9786E+00,.9786E+00,.9828E+00,.9947E+00,.9962E+00,.9969E+00,.9968E+00,.9914E+00,.9712E+00,.3489E+00/
 data (((w0(ai,k,nh),ai= 5, 5),k=1,11),nh=0,99)/ &
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9988E+00,.9902E+00,.9046E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9988E+00,.9903E+00,.8962E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9989E+00,.9903E+00,.8877E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9989E+00,.9904E+00,.8793E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9990E+00,.9904E+00,.8708E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9990E+00,.9905E+00,.8624E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9990E+00,.9906E+00,.8564E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9990E+00,.9906E+00,.8504E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9991E+00,.9907E+00,.8444E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9991E+00,.9907E+00,.8384E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9991E+00,.9908E+00,.8324E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9991E+00,.9909E+00,.8279E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9991E+00,.9909E+00,.8234E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9992E+00,.9910E+00,.8190E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9992E+00,.9910E+00,.8145E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9992E+00,.9911E+00,.8100E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9992E+00,.9911E+00,.8066E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9992E+00,.9912E+00,.8033E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9912E+00,.7999E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9913E+00,.7966E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9913E+00,.7932E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9913E+00,.7906E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9914E+00,.7881E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9914E+00,.7855E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9915E+00,.7830E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9915E+00,.7804E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9915E+00,.7784E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9993E+00,.9915E+00,.7765E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9916E+00,.7745E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9916E+00,.7726E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9916E+00,.7706E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9916E+00,.7691E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9916E+00,.7676E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9917E+00,.7661E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9917E+00,.7646E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9917E+00,.7631E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9917E+00,.7620E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9994E+00,.9917E+00,.7608E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9918E+00,.7597E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9918E+00,.7585E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9918E+00,.7574E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9918E+00,.7565E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9918E+00,.7557E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9919E+00,.7548E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9919E+00,.7540E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9919E+00,.7531E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9919E+00,.7525E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9995E+00,.9919E+00,.7518E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7512E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7505E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7499E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7495E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7491E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7487E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7483E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7479E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7476E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7473E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7471E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7468E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7465E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7463E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7461E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7458E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7456E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7454E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7452E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7451E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7449E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7448E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7446E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7445E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9996E+00,.9920E+00,.7444E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7442E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7441E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7440E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7440E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7440E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7440E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7440E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7440E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9920E+00,.7440E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9919E+00,.7442E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9919E+00,.7444E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9919E+00,.7446E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9918E+00,.7449E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9918E+00,.7452E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9918E+00,.7457E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9918E+00,.7462E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9917E+00,.7468E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9997E+00,.9916E+00,.7476E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9916E+00,.7484E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9915E+00,.7496E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9913E+00,.7508E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9911E+00,.7524E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9909E+00,.7545E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9906E+00,.7569E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9901E+00,.7602E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9891E+00,.7637E+00,&
 .1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9998E+00,.9871E+00,.7676E+00/
 data (((w0(ai,k,nh),ai= 6, 6),k=1,11),nh=0,99)/ &
 .9986E+00,.9986E+00,.9986E+00,.9988E+00,.9995E+00,.9998E+00,.9999E+00,.1000E+01,.9918E+00,.9603E+00,.9159E+00,&
 .9986E+00,.9986E+00,.9986E+00,.9988E+00,.9995E+00,.9998E+00,.9999E+00,.1000E+01,.9919E+00,.9604E+00,.9077E+00,&
 .9987E+00,.9987E+00,.9987E+00,.9989E+00,.9995E+00,.9998E+00,.9999E+00,.1000E+01,.9921E+00,.9606E+00,.8995E+00,&
 .9987E+00,.9987E+00,.9987E+00,.9989E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.9922E+00,.9607E+00,.8913E+00,&
 .9988E+00,.9988E+00,.9988E+00,.9990E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.9924E+00,.9609E+00,.8831E+00,&
 .9988E+00,.9988E+00,.9988E+00,.9990E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.9925E+00,.9610E+00,.8749E+00,&
 .9988E+00,.9988E+00,.9988E+00,.9990E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.9927E+00,.9613E+00,.8701E+00,&
 .9988E+00,.9988E+00,.9988E+00,.9990E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.9928E+00,.9615E+00,.8652E+00,&
 .9989E+00,.9989E+00,.9989E+00,.9991E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.9930E+00,.9618E+00,.8604E+00,&
 .9989E+00,.9989E+00,.9989E+00,.9991E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.9931E+00,.9620E+00,.8555E+00,&
 .9989E+00,.9989E+00,.9989E+00,.9991E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.9933E+00,.9623E+00,.8507E+00,&
 .9989E+00,.9989E+00,.9989E+00,.9991E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.9935E+00,.9625E+00,.8471E+00,&
 .9989E+00,.9989E+00,.9989E+00,.9991E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.9937E+00,.9627E+00,.8434E+00,&
 .9990E+00,.9990E+00,.9990E+00,.9992E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9939E+00,.9628E+00,.8398E+00,&
 .9990E+00,.9990E+00,.9990E+00,.9992E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9941E+00,.9630E+00,.8361E+00,&
 .9990E+00,.9990E+00,.9990E+00,.9992E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9943E+00,.9632E+00,.8325E+00,&
 .9990E+00,.9990E+00,.9990E+00,.9992E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9944E+00,.9632E+00,.8296E+00,&
 .9990E+00,.9990E+00,.9990E+00,.9992E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9945E+00,.9631E+00,.8268E+00,&
 .9991E+00,.9991E+00,.9991E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9946E+00,.9631E+00,.8239E+00,&
 .9991E+00,.9991E+00,.9991E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9947E+00,.9630E+00,.8211E+00,&
 .9991E+00,.9991E+00,.9991E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9948E+00,.9630E+00,.8182E+00,&
 .9991E+00,.9991E+00,.9991E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9949E+00,.9631E+00,.8158E+00,&
 .9991E+00,.9991E+00,.9991E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9949E+00,.9631E+00,.8134E+00,&
 .9992E+00,.9992E+00,.9992E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9950E+00,.9632E+00,.8111E+00,&
 .9992E+00,.9992E+00,.9992E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9950E+00,.9632E+00,.8087E+00,&
 .9992E+00,.9992E+00,.9992E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9951E+00,.9633E+00,.8063E+00,&
 .9992E+00,.9992E+00,.9992E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9952E+00,.9633E+00,.8042E+00,&
 .9992E+00,.9992E+00,.9992E+00,.9993E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.9953E+00,.9633E+00,.8022E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9954E+00,.9632E+00,.8001E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9955E+00,.9632E+00,.7981E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9956E+00,.9632E+00,.7960E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9956E+00,.9631E+00,.7943E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9957E+00,.9630E+00,.7926E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9957E+00,.9629E+00,.7908E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9958E+00,.9628E+00,.7891E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9958E+00,.9627E+00,.7874E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9959E+00,.9628E+00,.7858E+00,&
 .9993E+00,.9993E+00,.9993E+00,.9994E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9960E+00,.9629E+00,.7842E+00,&
 .9994E+00,.9994E+00,.9994E+00,.9995E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9960E+00,.9629E+00,.7825E+00,&
 .9994E+00,.9994E+00,.9994E+00,.9995E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9961E+00,.9630E+00,.7809E+00,&
 .9994E+00,.9994E+00,.9994E+00,.9995E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9962E+00,.9631E+00,.7793E+00,&
 .9994E+00,.9994E+00,.9994E+00,.9995E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9963E+00,.9629E+00,.7779E+00,&
 .9994E+00,.9994E+00,.9994E+00,.9995E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9963E+00,.9628E+00,.7765E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9964E+00,.9626E+00,.7751E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9964E+00,.9625E+00,.7737E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9965E+00,.9623E+00,.7723E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9965E+00,.9622E+00,.7710E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9966E+00,.9621E+00,.7697E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9966E+00,.9619E+00,.7684E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9967E+00,.9618E+00,.7671E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9967E+00,.9617E+00,.7658E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9967E+00,.9616E+00,.7648E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9968E+00,.9615E+00,.7639E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9968E+00,.9613E+00,.7629E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9969E+00,.9612E+00,.7620E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9969E+00,.9611E+00,.7610E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9969E+00,.9611E+00,.7601E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9969E+00,.9611E+00,.7592E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9970E+00,.9611E+00,.7584E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9970E+00,.9611E+00,.7575E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9970E+00,.9611E+00,.7566E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9971E+00,.9610E+00,.7557E+00,&
 .9995E+00,.9995E+00,.9995E+00,.9996E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9971E+00,.9610E+00,.7549E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9972E+00,.9609E+00,.7540E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9972E+00,.9609E+00,.7532E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9973E+00,.9608E+00,.7523E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9973E+00,.9606E+00,.7515E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.9973E+00,.9605E+00,.7507E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9973E+00,.9603E+00,.7498E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9973E+00,.9602E+00,.7490E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9973E+00,.9600E+00,.7482E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9974E+00,.9599E+00,.7471E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9974E+00,.9598E+00,.7460E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9975E+00,.9597E+00,.7449E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9975E+00,.9596E+00,.7438E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9976E+00,.9595E+00,.7427E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9976E+00,.9591E+00,.7412E+00,&
 .9996E+00,.9996E+00,.9996E+00,.9997E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9976E+00,.9588E+00,.7396E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9976E+00,.9584E+00,.7381E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9976E+00,.9581E+00,.7365E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9976E+00,.9577E+00,.7350E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9976E+00,.9574E+00,.7336E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9979E+00,.9570E+00,.7313E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9979E+00,.9564E+00,.7292E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9979E+00,.9557E+00,.7272E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9979E+00,.9554E+00,.7246E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9980E+00,.9551E+00,.7223E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9980E+00,.9544E+00,.7200E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9981E+00,.9541E+00,.7178E+00,&
 .9997E+00,.9997E+00,.9997E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9983E+00,.9531E+00,.7152E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9983E+00,.9530E+00,.7121E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9982E+00,.9514E+00,.7086E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9984E+00,.9505E+00,.7050E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9985E+00,.9493E+00,.6998E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9985E+00,.9475E+00,.6943E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9986E+00,.9454E+00,.6877E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.9987E+00,.9425E+00,.6790E+00,&
 .9998E+00,.9998E+00,.9998E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9988E+00,.9382E+00,.6688E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9988E+00,.9321E+00,.6536E+00,&
 .9999E+00,.9999E+00,.9999E+00,.9999E+00,.1000E+01,.1000E+01,.1000E+01,.1000E+01,.9988E+00,.9191E+00,.6286E+00/
 data (((w0(ai,k,nh),ai= 7, 7),k=1,11),nh=0,99)/ &
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00,&
 .9486E+00,.9486E+00,.9486E+00,.9515E+00,.9599E+00,.9695E+00,.9736E+00,.9900E+00,.9919E+00,.9666E+00,.3748E+00/
 data (((w0(ai,k,nh),ai= 8, 8),k=1,11),nh=0,99)/ &
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00,&
 .9265E+00,.9265E+00,.9265E+00,.9314E+00,.9452E+00,.9594E+00,.9655E+00,.9888E+00,.9934E+00,.9823E+00,.5308E+00/
 data (((w0(ai,k,nh),ai= 9, 9),k=1,11),nh=0,99)/ &
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00,&
 .8742E+00,.8742E+00,.8742E+00,.8831E+00,.9086E+00,.9327E+00,.9430E+00,.9827E+00,.9927E+00,.9874E+00,.6754E+00/
 data (((w0(ai,k,nh),ai=10,10),k=1,11),nh=0,99)/ &
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00,&
 .8106E+00,.8106E+00,.8106E+00,.8216E+00,.8530E+00,.8887E+00,.9040E+00,.9707E+00,.9893E+00,.9869E+00,.7531E+00/
 data (((w0(ai,k,nh),ai=11,11),k=1,11),nh=0,99)/ &
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00,&
 .7368E+00,.7368E+00,.7368E+00,.7498E+00,.7869E+00,.8322E+00,.8516E+00,.9507E+00,.9818E+00,.9823E+00,.7944E+00/
 data (((w0(ai,k,nh),ai=12,12),k=1,11),nh=0,99)/ &
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00,&
 .6696E+00,.6696E+00,.6696E+00,.6818E+00,.7165E+00,.7670E+00,.7886E+00,.9227E+00,.9689E+00,.9717E+00,.8124E+00/
 data (((w0(ai,k,nh),ai=13,13),k=1,11),nh=0,99)/ &
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00,&
 .6056E+00,.6056E+00,.6056E+00,.6148E+00,.6411E+00,.6883E+00,.7085E+00,.8768E+00,.9458E+00,.9475E+00,.8099E+00/
 data (((w0(ai,k,nh),ai=14,14),k=1,11),nh=0,99)/ &
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00,&
 .5693E+00,.5693E+00,.5693E+00,.5748E+00,.5906E+00,.6253E+00,.6402E+00,.8208E+00,.9129E+00,.9156E+00,.7860E+00/
 data (((g(ai,k,nh),ai= 1, 1),k=1,11),nh=0,99)/ &
 .7011E+00,.7011E+00,.7011E+00,.7029E+00,.7082E+00,.7144E+00,.7171E+00,.7149E+00,.6665E+00,.5632E+00,.2436E+00,&
 .7031E+00,.7031E+00,.7031E+00,.7049E+00,.7103E+00,.7165E+00,.7192E+00,.7165E+00,.6684E+00,.5654E+00,.2458E+00,&
 .7051E+00,.7051E+00,.7051E+00,.7069E+00,.7124E+00,.7186E+00,.7213E+00,.7182E+00,.6704E+00,.5675E+00,.2479E+00,&
 .7070E+00,.7070E+00,.7070E+00,.7090E+00,.7144E+00,.7206E+00,.7233E+00,.7198E+00,.6723E+00,.5697E+00,.2501E+00,&
 .7090E+00,.7090E+00,.7090E+00,.7110E+00,.7165E+00,.7227E+00,.7254E+00,.7215E+00,.6743E+00,.5718E+00,.2522E+00,&
 .7110E+00,.7110E+00,.7110E+00,.7130E+00,.7186E+00,.7248E+00,.7275E+00,.7231E+00,.6762E+00,.5740E+00,.2544E+00,&
 .7112E+00,.7112E+00,.7112E+00,.7136E+00,.7202E+00,.7263E+00,.7290E+00,.7246E+00,.6780E+00,.5760E+00,.2565E+00,&
 .7114E+00,.7114E+00,.7114E+00,.7142E+00,.7219E+00,.7279E+00,.7305E+00,.7261E+00,.6798E+00,.5780E+00,.2586E+00,&
 .7117E+00,.7117E+00,.7117E+00,.7147E+00,.7235E+00,.7294E+00,.7319E+00,.7277E+00,.6815E+00,.5801E+00,.2607E+00,&
 .7119E+00,.7119E+00,.7119E+00,.7153E+00,.7252E+00,.7310E+00,.7334E+00,.7292E+00,.6833E+00,.5821E+00,.2628E+00,&
 .7121E+00,.7121E+00,.7121E+00,.7159E+00,.7268E+00,.7325E+00,.7349E+00,.7307E+00,.6851E+00,.5841E+00,.2649E+00,&
 .7143E+00,.7143E+00,.7143E+00,.7177E+00,.7274E+00,.7333E+00,.7358E+00,.7321E+00,.6867E+00,.5860E+00,.2669E+00,&
 .7166E+00,.7166E+00,.7166E+00,.7195E+00,.7280E+00,.7342E+00,.7368E+00,.7335E+00,.6883E+00,.5879E+00,.2688E+00,&
 .7188E+00,.7188E+00,.7188E+00,.7214E+00,.7286E+00,.7350E+00,.7377E+00,.7348E+00,.6898E+00,.5897E+00,.2708E+00,&
 .7211E+00,.7211E+00,.7211E+00,.7232E+00,.7292E+00,.7359E+00,.7387E+00,.7362E+00,.6914E+00,.5916E+00,.2727E+00,&
 .7233E+00,.7233E+00,.7233E+00,.7250E+00,.7298E+00,.7367E+00,.7396E+00,.7376E+00,.6930E+00,.5935E+00,.2747E+00,&
 .7245E+00,.7245E+00,.7245E+00,.7265E+00,.7320E+00,.7386E+00,.7414E+00,.7387E+00,.6945E+00,.5953E+00,.2767E+00,&
 .7258E+00,.7258E+00,.7258E+00,.7280E+00,.7342E+00,.7405E+00,.7432E+00,.7397E+00,.6959E+00,.5971E+00,.2786E+00,&
 .7270E+00,.7270E+00,.7270E+00,.7294E+00,.7363E+00,.7424E+00,.7450E+00,.7408E+00,.6974E+00,.5990E+00,.2806E+00,&
 .7283E+00,.7283E+00,.7283E+00,.7309E+00,.7385E+00,.7443E+00,.7468E+00,.7418E+00,.6988E+00,.6008E+00,.2825E+00,&
 .7295E+00,.7295E+00,.7295E+00,.7324E+00,.7407E+00,.7462E+00,.7486E+00,.7429E+00,.7003E+00,.6026E+00,.2845E+00,&
 .7300E+00,.7300E+00,.7300E+00,.7329E+00,.7412E+00,.7465E+00,.7489E+00,.7441E+00,.7017E+00,.6043E+00,.2864E+00,&
 .7305E+00,.7305E+00,.7305E+00,.7334E+00,.7416E+00,.7469E+00,.7492E+00,.7454E+00,.7031E+00,.6061E+00,.2883E+00,&
 .7310E+00,.7310E+00,.7310E+00,.7339E+00,.7421E+00,.7472E+00,.7494E+00,.7466E+00,.7045E+00,.6078E+00,.2903E+00,&
 .7315E+00,.7315E+00,.7315E+00,.7344E+00,.7425E+00,.7476E+00,.7497E+00,.7479E+00,.7059E+00,.6096E+00,.2922E+00,&
 .7320E+00,.7320E+00,.7320E+00,.7349E+00,.7430E+00,.7479E+00,.7500E+00,.7491E+00,.7073E+00,.6113E+00,.2941E+00,&
 .7340E+00,.7340E+00,.7340E+00,.7366E+00,.7439E+00,.7490E+00,.7512E+00,.7500E+00,.7085E+00,.6129E+00,.2960E+00,&
 .7359E+00,.7359E+00,.7359E+00,.7383E+00,.7449E+00,.7501E+00,.7524E+00,.7509E+00,.7098E+00,.6146E+00,.2978E+00,&
 .7379E+00,.7379E+00,.7379E+00,.7399E+00,.7458E+00,.7513E+00,.7536E+00,.7517E+00,.7110E+00,.6162E+00,.2997E+00,&
 .7398E+00,.7398E+00,.7398E+00,.7416E+00,.7468E+00,.7524E+00,.7548E+00,.7526E+00,.7123E+00,.6179E+00,.3015E+00,&
 .7418E+00,.7418E+00,.7418E+00,.7433E+00,.7477E+00,.7535E+00,.7560E+00,.7535E+00,.7135E+00,.6195E+00,.3034E+00,&
 .7417E+00,.7417E+00,.7417E+00,.7436E+00,.7491E+00,.7546E+00,.7569E+00,.7543E+00,.7147E+00,.6210E+00,.3052E+00,&
 .7416E+00,.7416E+00,.7416E+00,.7439E+00,.7505E+00,.7557E+00,.7579E+00,.7550E+00,.7158E+00,.6226E+00,.3070E+00,&
 .7416E+00,.7416E+00,.7416E+00,.7442E+00,.7518E+00,.7567E+00,.7588E+00,.7558E+00,.7170E+00,.6241E+00,.3088E+00,&
 .7415E+00,.7415E+00,.7415E+00,.7445E+00,.7532E+00,.7578E+00,.7598E+00,.7565E+00,.7181E+00,.6257E+00,.3106E+00,&
 .7414E+00,.7414E+00,.7414E+00,.7448E+00,.7546E+00,.7589E+00,.7607E+00,.7573E+00,.7193E+00,.6272E+00,.3124E+00,&
 .7420E+00,.7420E+00,.7420E+00,.7452E+00,.7543E+00,.7587E+00,.7605E+00,.7582E+00,.7204E+00,.6286E+00,.3141E+00,&
 .7427E+00,.7427E+00,.7427E+00,.7456E+00,.7540E+00,.7584E+00,.7603E+00,.7592E+00,.7214E+00,.6301E+00,.3158E+00,&
 .7433E+00,.7433E+00,.7433E+00,.7460E+00,.7536E+00,.7582E+00,.7601E+00,.7601E+00,.7225E+00,.6315E+00,.3175E+00,&
 .7440E+00,.7440E+00,.7440E+00,.7464E+00,.7533E+00,.7579E+00,.7599E+00,.7611E+00,.7235E+00,.6330E+00,.3192E+00,&
 .7446E+00,.7446E+00,.7446E+00,.7468E+00,.7530E+00,.7577E+00,.7597E+00,.7620E+00,.7246E+00,.6344E+00,.3209E+00,&
 .7460E+00,.7460E+00,.7460E+00,.7481E+00,.7541E+00,.7590E+00,.7610E+00,.7626E+00,.7256E+00,.6358E+00,.3226E+00,&
 .7474E+00,.7474E+00,.7474E+00,.7494E+00,.7551E+00,.7602E+00,.7624E+00,.7631E+00,.7266E+00,.6372E+00,.3243E+00,&
 .7489E+00,.7489E+00,.7489E+00,.7508E+00,.7562E+00,.7615E+00,.7637E+00,.7637E+00,.7275E+00,.6386E+00,.3261E+00,&
 .7503E+00,.7503E+00,.7503E+00,.7521E+00,.7572E+00,.7627E+00,.7651E+00,.7642E+00,.7285E+00,.6400E+00,.3278E+00,&
 .7517E+00,.7517E+00,.7517E+00,.7534E+00,.7583E+00,.7640E+00,.7664E+00,.7648E+00,.7295E+00,.6414E+00,.3295E+00,&
 .7513E+00,.7513E+00,.7513E+00,.7533E+00,.7593E+00,.7647E+00,.7670E+00,.7654E+00,.7304E+00,.6427E+00,.3312E+00,&
 .7509E+00,.7509E+00,.7509E+00,.7533E+00,.7603E+00,.7654E+00,.7675E+00,.7660E+00,.7313E+00,.6440E+00,.3328E+00,&
 .7504E+00,.7504E+00,.7504E+00,.7532E+00,.7612E+00,.7660E+00,.7681E+00,.7665E+00,.7323E+00,.6454E+00,.3345E+00,&
 .7500E+00,.7500E+00,.7500E+00,.7532E+00,.7622E+00,.7667E+00,.7686E+00,.7671E+00,.7332E+00,.6467E+00,.3361E+00,&
 .7496E+00,.7496E+00,.7496E+00,.7531E+00,.7632E+00,.7674E+00,.7692E+00,.7677E+00,.7341E+00,.6480E+00,.3378E+00,&
 .7499E+00,.7499E+00,.7499E+00,.7532E+00,.7628E+00,.7670E+00,.7688E+00,.7684E+00,.7349E+00,.6492E+00,.3393E+00,&
 .7502E+00,.7502E+00,.7502E+00,.7533E+00,.7624E+00,.7666E+00,.7684E+00,.7691E+00,.7357E+00,.6504E+00,.3408E+00,&
 .7504E+00,.7504E+00,.7504E+00,.7535E+00,.7621E+00,.7663E+00,.7681E+00,.7699E+00,.7366E+00,.6516E+00,.3423E+00,&
 .7507E+00,.7507E+00,.7507E+00,.7536E+00,.7617E+00,.7659E+00,.7677E+00,.7706E+00,.7374E+00,.6528E+00,.3438E+00,&
 .7510E+00,.7510E+00,.7510E+00,.7537E+00,.7613E+00,.7655E+00,.7673E+00,.7713E+00,.7382E+00,.6540E+00,.3453E+00,&
 .7524E+00,.7524E+00,.7524E+00,.7548E+00,.7616E+00,.7663E+00,.7683E+00,.7717E+00,.7389E+00,.6551E+00,.3467E+00,&
 .7538E+00,.7538E+00,.7538E+00,.7560E+00,.7620E+00,.7671E+00,.7693E+00,.7720E+00,.7396E+00,.6562E+00,.3481E+00,&
 .7553E+00,.7553E+00,.7553E+00,.7571E+00,.7623E+00,.7679E+00,.7703E+00,.7724E+00,.7403E+00,.6572E+00,.3496E+00,&
 .7567E+00,.7567E+00,.7567E+00,.7583E+00,.7627E+00,.7687E+00,.7713E+00,.7727E+00,.7410E+00,.6583E+00,.3510E+00,&
 .7581E+00,.7581E+00,.7581E+00,.7594E+00,.7630E+00,.7695E+00,.7723E+00,.7731E+00,.7417E+00,.6594E+00,.3524E+00,&
 .7575E+00,.7575E+00,.7575E+00,.7592E+00,.7642E+00,.7703E+00,.7729E+00,.7734E+00,.7424E+00,.6605E+00,.3538E+00,&
 .7568E+00,.7568E+00,.7568E+00,.7591E+00,.7655E+00,.7711E+00,.7736E+00,.7738E+00,.7431E+00,.6616E+00,.3553E+00,&
 .7562E+00,.7562E+00,.7562E+00,.7589E+00,.7667E+00,.7720E+00,.7742E+00,.7741E+00,.7437E+00,.6626E+00,.3567E+00,&
 .7555E+00,.7555E+00,.7555E+00,.7588E+00,.7680E+00,.7728E+00,.7749E+00,.7745E+00,.7444E+00,.6637E+00,.3582E+00,&
 .7549E+00,.7549E+00,.7549E+00,.7586E+00,.7692E+00,.7736E+00,.7755E+00,.7748E+00,.7451E+00,.6648E+00,.3596E+00,&
 .7541E+00,.7541E+00,.7541E+00,.7579E+00,.7687E+00,.7733E+00,.7752E+00,.7754E+00,.7458E+00,.6658E+00,.3610E+00,&
 .7533E+00,.7533E+00,.7533E+00,.7572E+00,.7682E+00,.7730E+00,.7750E+00,.7760E+00,.7465E+00,.6669E+00,.3624E+00,&
 .7526E+00,.7526E+00,.7526E+00,.7565E+00,.7677E+00,.7726E+00,.7747E+00,.7765E+00,.7471E+00,.6679E+00,.3638E+00,&
 .7518E+00,.7518E+00,.7518E+00,.7558E+00,.7672E+00,.7723E+00,.7745E+00,.7771E+00,.7478E+00,.6690E+00,.3652E+00,&
 .7510E+00,.7510E+00,.7510E+00,.7551E+00,.7667E+00,.7720E+00,.7742E+00,.7777E+00,.7485E+00,.6700E+00,.3666E+00,&
 .7534E+00,.7534E+00,.7534E+00,.7570E+00,.7672E+00,.7727E+00,.7750E+00,.7782E+00,.7495E+00,.6716E+00,.3688E+00,&
 .7559E+00,.7559E+00,.7559E+00,.7590E+00,.7678E+00,.7734E+00,.7757E+00,.7787E+00,.7505E+00,.6732E+00,.3711E+00,&
 .7583E+00,.7583E+00,.7583E+00,.7609E+00,.7683E+00,.7740E+00,.7765E+00,.7792E+00,.7515E+00,.6749E+00,.3733E+00,&
 .7608E+00,.7608E+00,.7608E+00,.7629E+00,.7689E+00,.7747E+00,.7772E+00,.7797E+00,.7525E+00,.6765E+00,.3756E+00,&
 .7632E+00,.7632E+00,.7632E+00,.7648E+00,.7694E+00,.7754E+00,.7780E+00,.7802E+00,.7535E+00,.6781E+00,.3778E+00,&
 .7620E+00,.7620E+00,.7620E+00,.7641E+00,.7702E+00,.7757E+00,.7781E+00,.7807E+00,.7544E+00,.6796E+00,.3800E+00,&
 .7608E+00,.7608E+00,.7608E+00,.7634E+00,.7710E+00,.7760E+00,.7781E+00,.7813E+00,.7553E+00,.6811E+00,.3822E+00,&
 .7596E+00,.7596E+00,.7596E+00,.7628E+00,.7717E+00,.7762E+00,.7782E+00,.7818E+00,.7563E+00,.6827E+00,.3843E+00,&
 .7584E+00,.7584E+00,.7584E+00,.7621E+00,.7725E+00,.7765E+00,.7782E+00,.7824E+00,.7572E+00,.6842E+00,.3865E+00,&
 .7572E+00,.7572E+00,.7572E+00,.7614E+00,.7733E+00,.7768E+00,.7783E+00,.7829E+00,.7581E+00,.6857E+00,.3887E+00,&
 .7552E+00,.7552E+00,.7552E+00,.7592E+00,.7706E+00,.7761E+00,.7784E+00,.7838E+00,.7591E+00,.6874E+00,.3911E+00,&
 .7606E+00,.7606E+00,.7606E+00,.7634E+00,.7715E+00,.7757E+00,.7775E+00,.7845E+00,.7601E+00,.6890E+00,.3934E+00,&
 .7636E+00,.7636E+00,.7636E+00,.7650E+00,.7691E+00,.7743E+00,.7765E+00,.7851E+00,.7610E+00,.6906E+00,.3957E+00,&
 .7645E+00,.7645E+00,.7645E+00,.7659E+00,.7699E+00,.7765E+00,.7793E+00,.7852E+00,.7622E+00,.6928E+00,.3992E+00,&
 .7663E+00,.7663E+00,.7663E+00,.7683E+00,.7739E+00,.7798E+00,.7823E+00,.7855E+00,.7635E+00,.6951E+00,.4025E+00,&
 .7665E+00,.7665E+00,.7665E+00,.7688E+00,.7755E+00,.7815E+00,.7841E+00,.7858E+00,.7647E+00,.6972E+00,.4059E+00,&
 .7644E+00,.7644E+00,.7644E+00,.7676E+00,.7768E+00,.7815E+00,.7835E+00,.7867E+00,.7663E+00,.7001E+00,.4103E+00,&
 .7592E+00,.7592E+00,.7592E+00,.7629E+00,.7736E+00,.7788E+00,.7810E+00,.7884E+00,.7680E+00,.7029E+00,.4146E+00,&
 .7668E+00,.7668E+00,.7668E+00,.7680E+00,.7713E+00,.7766E+00,.7789E+00,.7895E+00,.7698E+00,.7063E+00,.4199E+00,&
 .7693E+00,.7693E+00,.7693E+00,.7709E+00,.7755E+00,.7820E+00,.7848E+00,.7896E+00,.7718E+00,.7102E+00,.4262E+00,&
 .7647E+00,.7647E+00,.7647E+00,.7687E+00,.7799E+00,.7838E+00,.7855E+00,.7901E+00,.7736E+00,.7138E+00,.4323E+00,&
 .7652E+00,.7652E+00,.7652E+00,.7679E+00,.7755E+00,.7807E+00,.7829E+00,.7924E+00,.7763E+00,.7186E+00,.4401E+00,&
 .7724E+00,.7724E+00,.7724E+00,.7734E+00,.7764E+00,.7821E+00,.7846E+00,.7927E+00,.7784E+00,.7231E+00,.4478E+00,&
 .7688E+00,.7688E+00,.7688E+00,.7717E+00,.7798E+00,.7846E+00,.7867E+00,.7929E+00,.7808E+00,.7283E+00,.4570E+00,&
 .7733E+00,.7733E+00,.7733E+00,.7736E+00,.7745E+00,.7816E+00,.7847E+00,.7948E+00,.7842E+00,.7352E+00,.4693E+00,&
 .7681E+00,.7681E+00,.7681E+00,.7717E+00,.7821E+00,.7839E+00,.7846E+00,.7960E+00,.7873E+00,.7421E+00,.4827E+00,&
 .7732E+00,.7732E+00,.7732E+00,.7757E+00,.7829E+00,.7870E+00,.7888E+00,.7958E+00,.7906E+00,.7507E+00,.4999E+00,&
 .7765E+00,.7765E+00,.7765E+00,.7782E+00,.7832E+00,.7873E+00,.7890E+00,.7969E+00,.7954E+00,.7626E+00,.5253E+00,&
 .7815E+00,.7815E+00,.7815E+00,.7826E+00,.7857E+00,.7877E+00,.7886E+00,.7974E+00,.8010E+00,.7804E+00,.5681E+00/
 data (((g(ai,k,nh),ai= 2, 2),k=1,11),nh=0,99)/ &
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5026E+00,.5026E+00,.5026E+00,.4899E+00,.4537E+00,.4320E+00,.4227E+00,.3389E+00,.2333E+00,.1307E+00,.3326E-01,&
 .5035E+00,.5035E+00,.5035E+00,.4908E+00,.4546E+00,.4329E+00,.4235E+00,.3396E+00,.2338E+00,.1310E+00,.3332E-01,&
 .5044E+00,.5044E+00,.5044E+00,.4917E+00,.4555E+00,.4337E+00,.4244E+00,.3403E+00,.2343E+00,.1312E+00,.3338E-01,&
 .5053E+00,.5053E+00,.5053E+00,.4926E+00,.4563E+00,.4346E+00,.4252E+00,.3410E+00,.2347E+00,.1315E+00,.3343E-01,&
 .5062E+00,.5062E+00,.5062E+00,.4935E+00,.4572E+00,.4354E+00,.4261E+00,.3417E+00,.2352E+00,.1317E+00,.3349E-01,&
 .5071E+00,.5071E+00,.5071E+00,.4944E+00,.4581E+00,.4363E+00,.4269E+00,.3424E+00,.2357E+00,.1320E+00,.3355E-01,&
 .5071E+00,.5071E+00,.5071E+00,.4944E+00,.4581E+00,.4363E+00,.4269E+00,.3424E+00,.2357E+00,.1320E+00,.3355E-01,&
 .5071E+00,.5071E+00,.5071E+00,.4944E+00,.4581E+00,.4363E+00,.4269E+00,.3424E+00,.2357E+00,.1320E+00,.3355E-01,&
 .5071E+00,.5071E+00,.5071E+00,.4944E+00,.4581E+00,.4363E+00,.4269E+00,.3424E+00,.2357E+00,.1320E+00,.3355E-01,&
 .5071E+00,.5071E+00,.5071E+00,.4944E+00,.4581E+00,.4363E+00,.4269E+00,.3424E+00,.2357E+00,.1320E+00,.3355E-01,&
 .5071E+00,.5071E+00,.5071E+00,.4944E+00,.4581E+00,.4363E+00,.4269E+00,.3424E+00,.2357E+00,.1320E+00,.3355E-01,&
 .5097E+00,.5097E+00,.5097E+00,.4970E+00,.4607E+00,.4388E+00,.4294E+00,.3445E+00,.2371E+00,.1328E+00,.3373E-01,&
 .5123E+00,.5123E+00,.5123E+00,.4996E+00,.4633E+00,.4413E+00,.4319E+00,.3465E+00,.2385E+00,.1336E+00,.3390E-01,&
 .5149E+00,.5149E+00,.5149E+00,.5021E+00,.4658E+00,.4438E+00,.4343E+00,.3486E+00,.2400E+00,.1343E+00,.3408E-01,&
 .5175E+00,.5175E+00,.5175E+00,.5047E+00,.4684E+00,.4463E+00,.4368E+00,.3506E+00,.2414E+00,.1351E+00,.3425E-01,&
 .5201E+00,.5201E+00,.5201E+00,.5073E+00,.4710E+00,.4488E+00,.4393E+00,.3527E+00,.2428E+00,.1359E+00,.3443E-01,&
 .5263E+00,.5263E+00,.5263E+00,.5136E+00,.4773E+00,.4550E+00,.4454E+00,.3579E+00,.2465E+00,.1379E+00,.3492E-01,&
 .5326E+00,.5326E+00,.5326E+00,.5198E+00,.4836E+00,.4611E+00,.4515E+00,.3631E+00,.2502E+00,.1400E+00,.3540E-01,&
 .5388E+00,.5388E+00,.5388E+00,.5261E+00,.4898E+00,.4673E+00,.4576E+00,.3682E+00,.2538E+00,.1420E+00,.3589E-01,&
 .5451E+00,.5451E+00,.5451E+00,.5323E+00,.4961E+00,.4734E+00,.4637E+00,.3734E+00,.2575E+00,.1441E+00,.3637E-01,&
 .5513E+00,.5513E+00,.5513E+00,.5386E+00,.5024E+00,.4796E+00,.4698E+00,.3786E+00,.2612E+00,.1461E+00,.3686E-01,&
 .5579E+00,.5579E+00,.5579E+00,.5453E+00,.5092E+00,.4863E+00,.4765E+00,.3845E+00,.2656E+00,.1487E+00,.3751E-01,&
 .5645E+00,.5645E+00,.5645E+00,.5519E+00,.5160E+00,.4930E+00,.4832E+00,.3904E+00,.2699E+00,.1513E+00,.3815E-01,&
 .5712E+00,.5712E+00,.5712E+00,.5586E+00,.5227E+00,.4998E+00,.4899E+00,.3962E+00,.2743E+00,.1538E+00,.3880E-01,&
 .5778E+00,.5778E+00,.5778E+00,.5652E+00,.5295E+00,.5065E+00,.4966E+00,.4021E+00,.2786E+00,.1564E+00,.3944E-01,&
 .5844E+00,.5844E+00,.5844E+00,.5719E+00,.5363E+00,.5132E+00,.5033E+00,.4080E+00,.2830E+00,.1590E+00,.4009E-01,&
 .5932E+00,.5932E+00,.5932E+00,.5808E+00,.5455E+00,.5224E+00,.5125E+00,.4162E+00,.2893E+00,.1628E+00,.4109E-01,&
 .5988E+00,.5988E+00,.5988E+00,.5865E+00,.5514E+00,.5282E+00,.5183E+00,.4216E+00,.2935E+00,.1653E+00,.4178E-01,&
 .6069E+00,.6069E+00,.6069E+00,.5947E+00,.5599E+00,.5368E+00,.5269E+00,.4294E+00,.2997E+00,.1691E+00,.4281E-01,&
 .6120E+00,.6120E+00,.6120E+00,.5999E+00,.5653E+00,.5423E+00,.5324E+00,.4346E+00,.3037E+00,.1717E+00,.4352E-01,&
 .6193E+00,.6193E+00,.6193E+00,.6073E+00,.5732E+00,.5502E+00,.5403E+00,.4421E+00,.3097E+00,.1755E+00,.4458E-01,&
 .6262E+00,.6262E+00,.6262E+00,.6144E+00,.5807E+00,.5577E+00,.5479E+00,.4493E+00,.3156E+00,.1793E+00,.4565E-01,&
 .6307E+00,.6307E+00,.6307E+00,.6189E+00,.5855E+00,.5627E+00,.5529E+00,.4540E+00,.3195E+00,.1818E+00,.4638E-01,&
 .6370E+00,.6370E+00,.6370E+00,.6254E+00,.5924E+00,.5697E+00,.5600E+00,.4610E+00,.3253E+00,.1856E+00,.4749E-01,&
 .6411E+00,.6411E+00,.6411E+00,.6296E+00,.5969E+00,.5743E+00,.5646E+00,.4655E+00,.3290E+00,.1881E+00,.4823E-01,&
 .6469E+00,.6469E+00,.6469E+00,.6356E+00,.6034E+00,.5809E+00,.5713E+00,.4720E+00,.3347E+00,.1919E+00,.4935E-01,&
 .6524E+00,.6524E+00,.6524E+00,.6412E+00,.6095E+00,.5872E+00,.5777E+00,.4785E+00,.3402E+00,.1956E+00,.5049E-01,&
 .6577E+00,.6577E+00,.6577E+00,.6467E+00,.6154E+00,.5933E+00,.5838E+00,.4847E+00,.3456E+00,.1994E+00,.5163E-01,&
 .6627E+00,.6627E+00,.6627E+00,.6519E+00,.6211E+00,.5991E+00,.5897E+00,.4907E+00,.3510E+00,.2031E+00,.5279E-01,&
 .6689E+00,.6689E+00,.6689E+00,.6583E+00,.6282E+00,.6066E+00,.5973E+00,.4986E+00,.3580E+00,.2080E+00,.5434E-01,&
 .6748E+00,.6748E+00,.6748E+00,.6645E+00,.6350E+00,.6136E+00,.6045E+00,.5061E+00,.3648E+00,.2129E+00,.5592E-01,&
 .6816E+00,.6816E+00,.6816E+00,.6716E+00,.6430E+00,.6219E+00,.6129E+00,.5151E+00,.3732E+00,.2190E+00,.5791E-01,&
 .6903E+00,.6903E+00,.6903E+00,.6807E+00,.6532E+00,.6327E+00,.6239E+00,.5271E+00,.3845E+00,.2273E+00,.6073E-01,&
 .6991E+00,.6991E+00,.6991E+00,.6899E+00,.6638E+00,.6439E+00,.6354E+00,.5399E+00,.3969E+00,.2368E+00,.6400E-01,&
 .7171E+00,.7171E+00,.7171E+00,.7090E+00,.6860E+00,.6677E+00,.6599E+00,.5683E+00,.4258E+00,.2598E+00,.7234E-01/
 data (((g(ai,k,nh),ai= 3, 3),k=1,11),nh=0,99)/ &
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00/
 data (((g(ai,k,nh),ai= 4, 4),k=1,11),nh=0,99)/ &
 .6863E+00,.6863E+00,.6863E+00,.6784E+00,.6558E+00,.6469E+00,.6431E+00,.6051E+00,.5364E+00,.4244E+00,.1937E+00,&
 .6873E+00,.6873E+00,.6873E+00,.6795E+00,.6572E+00,.6484E+00,.6446E+00,.6066E+00,.5377E+00,.4255E+00,.1943E+00,&
 .6884E+00,.6884E+00,.6884E+00,.6806E+00,.6586E+00,.6498E+00,.6461E+00,.6081E+00,.5390E+00,.4266E+00,.1949E+00,&
 .6894E+00,.6894E+00,.6894E+00,.6818E+00,.6599E+00,.6513E+00,.6475E+00,.6095E+00,.5404E+00,.4278E+00,.1955E+00,&
 .6905E+00,.6905E+00,.6905E+00,.6829E+00,.6613E+00,.6527E+00,.6490E+00,.6110E+00,.5417E+00,.4289E+00,.1961E+00,&
 .6915E+00,.6915E+00,.6915E+00,.6840E+00,.6627E+00,.6542E+00,.6505E+00,.6125E+00,.5430E+00,.4300E+00,.1967E+00,&
 .6925E+00,.6925E+00,.6925E+00,.6850E+00,.6640E+00,.6555E+00,.6518E+00,.6139E+00,.5443E+00,.4311E+00,.1973E+00,&
 .6934E+00,.6934E+00,.6934E+00,.6861E+00,.6652E+00,.6567E+00,.6530E+00,.6153E+00,.5456E+00,.4322E+00,.1979E+00,&
 .6944E+00,.6944E+00,.6944E+00,.6871E+00,.6665E+00,.6580E+00,.6543E+00,.6166E+00,.5468E+00,.4334E+00,.1986E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6882E+00,.6677E+00,.6592E+00,.6555E+00,.6180E+00,.5481E+00,.4345E+00,.1992E+00,&
 .6963E+00,.6963E+00,.6963E+00,.6892E+00,.6690E+00,.6605E+00,.6568E+00,.6194E+00,.5494E+00,.4356E+00,.1998E+00,&
 .6973E+00,.6973E+00,.6973E+00,.6902E+00,.6701E+00,.6617E+00,.6580E+00,.6207E+00,.5506E+00,.4367E+00,.2004E+00,&
 .6982E+00,.6982E+00,.6982E+00,.6912E+00,.6712E+00,.6628E+00,.6592E+00,.6220E+00,.5518E+00,.4378E+00,.2010E+00,&
 .6992E+00,.6992E+00,.6992E+00,.6922E+00,.6722E+00,.6640E+00,.6605E+00,.6233E+00,.5531E+00,.4388E+00,.2016E+00,&
 .7001E+00,.7001E+00,.7001E+00,.6932E+00,.6733E+00,.6651E+00,.6617E+00,.6246E+00,.5543E+00,.4399E+00,.2022E+00,&
 .7011E+00,.7011E+00,.7011E+00,.6942E+00,.6744E+00,.6663E+00,.6629E+00,.6259E+00,.5555E+00,.4410E+00,.2028E+00,&
 .7020E+00,.7020E+00,.7020E+00,.6952E+00,.6756E+00,.6676E+00,.6642E+00,.6271E+00,.5567E+00,.4421E+00,.2034E+00,&
 .7029E+00,.7029E+00,.7029E+00,.6961E+00,.6767E+00,.6689E+00,.6655E+00,.6283E+00,.5578E+00,.4431E+00,.2040E+00,&
 .7038E+00,.7038E+00,.7038E+00,.6971E+00,.6779E+00,.6701E+00,.6669E+00,.6296E+00,.5590E+00,.4442E+00,.2047E+00,&
 .7047E+00,.7047E+00,.7047E+00,.6980E+00,.6790E+00,.6714E+00,.6682E+00,.6308E+00,.5601E+00,.4452E+00,.2053E+00,&
 .7056E+00,.7056E+00,.7056E+00,.6990E+00,.6802E+00,.6727E+00,.6695E+00,.6320E+00,.5613E+00,.4463E+00,.2059E+00,&
 .7064E+00,.7064E+00,.7064E+00,.6999E+00,.6813E+00,.6739E+00,.6707E+00,.6332E+00,.5624E+00,.4473E+00,.2065E+00,&
 .7072E+00,.7072E+00,.7072E+00,.7008E+00,.6825E+00,.6750E+00,.6718E+00,.6343E+00,.5636E+00,.4484E+00,.2071E+00,&
 .7081E+00,.7081E+00,.7081E+00,.7017E+00,.6836E+00,.6762E+00,.6730E+00,.6355E+00,.5647E+00,.4494E+00,.2077E+00,&
 .7089E+00,.7089E+00,.7089E+00,.7026E+00,.6848E+00,.6773E+00,.6741E+00,.6366E+00,.5659E+00,.4505E+00,.2083E+00,&
 .7097E+00,.7097E+00,.7097E+00,.7035E+00,.6859E+00,.6785E+00,.6753E+00,.6378E+00,.5670E+00,.4515E+00,.2089E+00,&
 .7104E+00,.7104E+00,.7104E+00,.7043E+00,.6869E+00,.6795E+00,.6764E+00,.6389E+00,.5681E+00,.4525E+00,.2095E+00,&
 .7111E+00,.7111E+00,.7111E+00,.7051E+00,.6880E+00,.6806E+00,.6774E+00,.6401E+00,.5692E+00,.4535E+00,.2101E+00,&
 .7119E+00,.7119E+00,.7119E+00,.7059E+00,.6890E+00,.6816E+00,.6785E+00,.6412E+00,.5703E+00,.4546E+00,.2108E+00,&
 .7126E+00,.7126E+00,.7126E+00,.7067E+00,.6901E+00,.6827E+00,.6795E+00,.6424E+00,.5714E+00,.4556E+00,.2114E+00,&
 .7133E+00,.7133E+00,.7133E+00,.7075E+00,.6911E+00,.6837E+00,.6806E+00,.6435E+00,.5725E+00,.4566E+00,.2120E+00,&
 .7140E+00,.7140E+00,.7140E+00,.7082E+00,.6920E+00,.6846E+00,.6815E+00,.6446E+00,.5736E+00,.4576E+00,.2126E+00,&
 .7147E+00,.7147E+00,.7147E+00,.7090E+00,.6929E+00,.6855E+00,.6824E+00,.6457E+00,.5746E+00,.4586E+00,.2132E+00,&
 .7153E+00,.7153E+00,.7153E+00,.7097E+00,.6937E+00,.6864E+00,.6833E+00,.6468E+00,.5757E+00,.4597E+00,.2139E+00,&
 .7160E+00,.7160E+00,.7160E+00,.7105E+00,.6946E+00,.6873E+00,.6842E+00,.6479E+00,.5767E+00,.4607E+00,.2145E+00,&
 .7167E+00,.7167E+00,.7167E+00,.7112E+00,.6955E+00,.6882E+00,.6851E+00,.6490E+00,.5778E+00,.4617E+00,.2151E+00,&
 .7174E+00,.7174E+00,.7174E+00,.7119E+00,.6962E+00,.6890E+00,.6860E+00,.6500E+00,.5788E+00,.4627E+00,.2157E+00,&
 .7181E+00,.7181E+00,.7181E+00,.7126E+00,.6970E+00,.6898E+00,.6868E+00,.6510E+00,.5798E+00,.4637E+00,.2163E+00,&
 .7189E+00,.7189E+00,.7189E+00,.7134E+00,.6977E+00,.6907E+00,.6877E+00,.6520E+00,.5809E+00,.4646E+00,.2170E+00,&
 .7196E+00,.7196E+00,.7196E+00,.7141E+00,.6985E+00,.6915E+00,.6885E+00,.6530E+00,.5819E+00,.4656E+00,.2176E+00,&
 .7203E+00,.7203E+00,.7203E+00,.7148E+00,.6992E+00,.6923E+00,.6894E+00,.6540E+00,.5829E+00,.4666E+00,.2182E+00,&
 .7210E+00,.7210E+00,.7210E+00,.7155E+00,.7000E+00,.6933E+00,.6904E+00,.6549E+00,.5839E+00,.4676E+00,.2188E+00,&
 .7217E+00,.7217E+00,.7217E+00,.7162E+00,.7009E+00,.6943E+00,.6915E+00,.6559E+00,.5849E+00,.4685E+00,.2194E+00,&
 .7223E+00,.7223E+00,.7223E+00,.7170E+00,.7017E+00,.6952E+00,.6925E+00,.6568E+00,.5858E+00,.4695E+00,.2200E+00,&
 .7230E+00,.7230E+00,.7230E+00,.7177E+00,.7026E+00,.6962E+00,.6936E+00,.6578E+00,.5868E+00,.4704E+00,.2206E+00,&
 .7237E+00,.7237E+00,.7237E+00,.7184E+00,.7034E+00,.6972E+00,.6946E+00,.6587E+00,.5878E+00,.4714E+00,.2212E+00,&
 .7243E+00,.7243E+00,.7243E+00,.7191E+00,.7043E+00,.6981E+00,.6955E+00,.6596E+00,.5888E+00,.4723E+00,.2218E+00,&
 .7249E+00,.7249E+00,.7249E+00,.7198E+00,.7052E+00,.6990E+00,.6964E+00,.6605E+00,.5897E+00,.4733E+00,.2224E+00,&
 .7255E+00,.7255E+00,.7255E+00,.7204E+00,.7062E+00,.7000E+00,.6973E+00,.6614E+00,.5907E+00,.4742E+00,.2231E+00,&
 .7261E+00,.7261E+00,.7261E+00,.7211E+00,.7071E+00,.7009E+00,.6982E+00,.6623E+00,.5916E+00,.4752E+00,.2237E+00,&
 .7267E+00,.7267E+00,.7267E+00,.7218E+00,.7080E+00,.7018E+00,.6991E+00,.6632E+00,.5926E+00,.4761E+00,.2243E+00,&
 .7273E+00,.7273E+00,.7273E+00,.7225E+00,.7089E+00,.7027E+00,.7000E+00,.6643E+00,.5937E+00,.4772E+00,.2250E+00,&
 .7279E+00,.7279E+00,.7279E+00,.7232E+00,.7099E+00,.7036E+00,.7009E+00,.6654E+00,.5948E+00,.4783E+00,.2258E+00,&
 .7284E+00,.7284E+00,.7284E+00,.7238E+00,.7108E+00,.7046E+00,.7019E+00,.6664E+00,.5960E+00,.4795E+00,.2265E+00,&
 .7290E+00,.7290E+00,.7290E+00,.7245E+00,.7118E+00,.7055E+00,.7028E+00,.6675E+00,.5971E+00,.4806E+00,.2273E+00,&
 .7296E+00,.7296E+00,.7296E+00,.7252E+00,.7127E+00,.7064E+00,.7037E+00,.6686E+00,.5982E+00,.4817E+00,.2280E+00,&
 .7302E+00,.7302E+00,.7302E+00,.7258E+00,.7134E+00,.7071E+00,.7045E+00,.6696E+00,.5993E+00,.4828E+00,.2287E+00,&
 .7307E+00,.7307E+00,.7307E+00,.7264E+00,.7141E+00,.7079E+00,.7052E+00,.6706E+00,.6003E+00,.4839E+00,.2295E+00,&
 .7313E+00,.7313E+00,.7313E+00,.7270E+00,.7148E+00,.7086E+00,.7060E+00,.6717E+00,.6014E+00,.4849E+00,.2302E+00,&
 .7318E+00,.7318E+00,.7318E+00,.7276E+00,.7155E+00,.7094E+00,.7067E+00,.6727E+00,.6024E+00,.4860E+00,.2310E+00,&
 .7324E+00,.7324E+00,.7324E+00,.7282E+00,.7162E+00,.7101E+00,.7075E+00,.6737E+00,.6035E+00,.4871E+00,.2317E+00,&
 .7330E+00,.7330E+00,.7330E+00,.7287E+00,.7167E+00,.7107E+00,.7081E+00,.6745E+00,.6043E+00,.4880E+00,.2323E+00,&
 .7336E+00,.7336E+00,.7336E+00,.7293E+00,.7171E+00,.7113E+00,.7088E+00,.6753E+00,.6052E+00,.4889E+00,.2329E+00,&
 .7341E+00,.7341E+00,.7341E+00,.7298E+00,.7176E+00,.7118E+00,.7094E+00,.6760E+00,.6060E+00,.4897E+00,.2335E+00,&
 .7347E+00,.7347E+00,.7347E+00,.7304E+00,.7180E+00,.7124E+00,.7101E+00,.6768E+00,.6069E+00,.4906E+00,.2341E+00,&
 .7353E+00,.7353E+00,.7353E+00,.7309E+00,.7185E+00,.7130E+00,.7107E+00,.6776E+00,.6077E+00,.4915E+00,.2347E+00,&
 .7359E+00,.7359E+00,.7359E+00,.7316E+00,.7194E+00,.7140E+00,.7117E+00,.6785E+00,.6087E+00,.4925E+00,.2354E+00,&
 .7366E+00,.7366E+00,.7366E+00,.7323E+00,.7202E+00,.7149E+00,.7127E+00,.6793E+00,.6097E+00,.4936E+00,.2362E+00,&
 .7372E+00,.7372E+00,.7372E+00,.7330E+00,.7211E+00,.7159E+00,.7136E+00,.6802E+00,.6106E+00,.4946E+00,.2369E+00,&
 .7379E+00,.7379E+00,.7379E+00,.7337E+00,.7219E+00,.7168E+00,.7146E+00,.6810E+00,.6116E+00,.4957E+00,.2377E+00,&
 .7385E+00,.7385E+00,.7385E+00,.7344E+00,.7228E+00,.7178E+00,.7156E+00,.6819E+00,.6126E+00,.4967E+00,.2384E+00,&
 .7391E+00,.7391E+00,.7391E+00,.7352E+00,.7240E+00,.7189E+00,.7167E+00,.6832E+00,.6140E+00,.4982E+00,.2395E+00,&
 .7397E+00,.7397E+00,.7397E+00,.7360E+00,.7252E+00,.7201E+00,.7178E+00,.6845E+00,.6154E+00,.4997E+00,.2406E+00,&
 .7404E+00,.7404E+00,.7404E+00,.7367E+00,.7264E+00,.7212E+00,.7190E+00,.6857E+00,.6169E+00,.5012E+00,.2416E+00,&
 .7410E+00,.7410E+00,.7410E+00,.7375E+00,.7276E+00,.7224E+00,.7201E+00,.6870E+00,.6183E+00,.5027E+00,.2427E+00,&
 .7416E+00,.7416E+00,.7416E+00,.7383E+00,.7288E+00,.7235E+00,.7212E+00,.6883E+00,.6197E+00,.5042E+00,.2438E+00,&
 .7425E+00,.7425E+00,.7425E+00,.7392E+00,.7296E+00,.7245E+00,.7223E+00,.6899E+00,.6215E+00,.5061E+00,.2452E+00,&
 .7434E+00,.7434E+00,.7434E+00,.7401E+00,.7305E+00,.7255E+00,.7234E+00,.6915E+00,.6232E+00,.5080E+00,.2467E+00,&
 .7443E+00,.7443E+00,.7443E+00,.7409E+00,.7313E+00,.7265E+00,.7244E+00,.6930E+00,.6250E+00,.5100E+00,.2481E+00,&
 .7452E+00,.7452E+00,.7452E+00,.7418E+00,.7322E+00,.7275E+00,.7255E+00,.6946E+00,.6267E+00,.5119E+00,.2496E+00,&
 .7461E+00,.7461E+00,.7461E+00,.7427E+00,.7330E+00,.7285E+00,.7266E+00,.6962E+00,.6285E+00,.5138E+00,.2510E+00,&
 .7475E+00,.7475E+00,.7475E+00,.7440E+00,.7342E+00,.7304E+00,.7287E+00,.6979E+00,.6306E+00,.5161E+00,.2528E+00,&
 .7487E+00,.7487E+00,.7487E+00,.7455E+00,.7362E+00,.7323E+00,.7307E+00,.6996E+00,.6327E+00,.5185E+00,.2546E+00,&
 .7498E+00,.7498E+00,.7498E+00,.7468E+00,.7381E+00,.7340E+00,.7323E+00,.7013E+00,.6347E+00,.5208E+00,.2563E+00,&
 .7504E+00,.7504E+00,.7504E+00,.7476E+00,.7396E+00,.7358E+00,.7341E+00,.7029E+00,.6367E+00,.5230E+00,.2581E+00,&
 .7511E+00,.7511E+00,.7511E+00,.7487E+00,.7417E+00,.7374E+00,.7356E+00,.7052E+00,.6393E+00,.5260E+00,.2604E+00,&
 .7516E+00,.7516E+00,.7516E+00,.7493E+00,.7428E+00,.7386E+00,.7368E+00,.7074E+00,.6419E+00,.5289E+00,.2627E+00,&
 .7528E+00,.7528E+00,.7528E+00,.7505E+00,.7439E+00,.7399E+00,.7382E+00,.7101E+00,.6450E+00,.5325E+00,.2656E+00,&
 .7550E+00,.7550E+00,.7550E+00,.7523E+00,.7447E+00,.7414E+00,.7400E+00,.7125E+00,.6480E+00,.5360E+00,.2685E+00,&
 .7572E+00,.7572E+00,.7572E+00,.7547E+00,.7476E+00,.7447E+00,.7434E+00,.7152E+00,.6515E+00,.5401E+00,.2719E+00,&
 .7582E+00,.7582E+00,.7582E+00,.7562E+00,.7504E+00,.7475E+00,.7462E+00,.7178E+00,.6548E+00,.5442E+00,.2753E+00,&
 .7585E+00,.7585E+00,.7585E+00,.7570E+00,.7528E+00,.7494E+00,.7479E+00,.7210E+00,.6587E+00,.5488E+00,.2792E+00,&
 .7599E+00,.7599E+00,.7599E+00,.7583E+00,.7537E+00,.7505E+00,.7492E+00,.7245E+00,.6629E+00,.5540E+00,.2837E+00,&
 .7634E+00,.7634E+00,.7634E+00,.7615E+00,.7561E+00,.7542E+00,.7534E+00,.7280E+00,.6678E+00,.5601E+00,.2891E+00,&
 .7641E+00,.7641E+00,.7641E+00,.7632E+00,.7605E+00,.7580E+00,.7569E+00,.7319E+00,.6731E+00,.5667E+00,.2950E+00,&
 .7661E+00,.7661E+00,.7661E+00,.7648E+00,.7612E+00,.7593E+00,.7585E+00,.7372E+00,.6797E+00,.5753E+00,.3029E+00,&
 .7685E+00,.7685E+00,.7685E+00,.7681E+00,.7671E+00,.7653E+00,.7646E+00,.7424E+00,.6874E+00,.5854E+00,.3127E+00,&
 .7715E+00,.7715E+00,.7715E+00,.7704E+00,.7673E+00,.7672E+00,.7672E+00,.7483E+00,.6956E+00,.5964E+00,.3236E+00,&
 .7737E+00,.7737E+00,.7737E+00,.7731E+00,.7715E+00,.7715E+00,.7715E+00,.7564E+00,.7073E+00,.6128E+00,.3406E+00,&
 .7776E+00,.7776E+00,.7776E+00,.7780E+00,.7792E+00,.7799E+00,.7802E+00,.7657E+00,.7227E+00,.6356E+00,.3661E+00/
 data (((g(ai,k,nh),ai= 5, 5),k=1,11),nh=0,99)/ &
 .7187E+00,.7187E+00,.7187E+00,.7166E+00,.7105E+00,.7031E+00,.6999E+00,.6976E+00,.7051E+00,.7042E+00,.5544E+00,&
 .7215E+00,.7215E+00,.7215E+00,.7195E+00,.7137E+00,.7062E+00,.7030E+00,.7007E+00,.7082E+00,.7074E+00,.5579E+00,&
 .7243E+00,.7243E+00,.7243E+00,.7224E+00,.7169E+00,.7094E+00,.7062E+00,.7038E+00,.7112E+00,.7106E+00,.5615E+00,&
 .7270E+00,.7270E+00,.7270E+00,.7252E+00,.7200E+00,.7125E+00,.7093E+00,.7070E+00,.7143E+00,.7137E+00,.5650E+00,&
 .7298E+00,.7298E+00,.7298E+00,.7281E+00,.7232E+00,.7157E+00,.7125E+00,.7101E+00,.7173E+00,.7169E+00,.5686E+00,&
 .7326E+00,.7326E+00,.7326E+00,.7310E+00,.7264E+00,.7188E+00,.7156E+00,.7132E+00,.7204E+00,.7201E+00,.5721E+00,&
 .7360E+00,.7360E+00,.7360E+00,.7340E+00,.7283E+00,.7209E+00,.7177E+00,.7153E+00,.7230E+00,.7229E+00,.5752E+00,&
 .7393E+00,.7393E+00,.7393E+00,.7370E+00,.7302E+00,.7229E+00,.7198E+00,.7174E+00,.7256E+00,.7257E+00,.5782E+00,&
 .7427E+00,.7427E+00,.7427E+00,.7399E+00,.7322E+00,.7250E+00,.7219E+00,.7194E+00,.7283E+00,.7284E+00,.5813E+00,&
 .7460E+00,.7460E+00,.7460E+00,.7429E+00,.7341E+00,.7270E+00,.7240E+00,.7215E+00,.7309E+00,.7312E+00,.5843E+00,&
 .7494E+00,.7494E+00,.7494E+00,.7459E+00,.7360E+00,.7291E+00,.7261E+00,.7236E+00,.7335E+00,.7340E+00,.5874E+00,&
 .7493E+00,.7493E+00,.7493E+00,.7465E+00,.7385E+00,.7310E+00,.7277E+00,.7262E+00,.7354E+00,.7363E+00,.5902E+00,&
 .7492E+00,.7492E+00,.7492E+00,.7470E+00,.7410E+00,.7328E+00,.7293E+00,.7289E+00,.7372E+00,.7386E+00,.5929E+00,&
 .7490E+00,.7490E+00,.7490E+00,.7476E+00,.7436E+00,.7347E+00,.7308E+00,.7315E+00,.7391E+00,.7408E+00,.5957E+00,&
 .7489E+00,.7489E+00,.7489E+00,.7481E+00,.7461E+00,.7365E+00,.7324E+00,.7342E+00,.7409E+00,.7431E+00,.5984E+00,&
 .7488E+00,.7488E+00,.7488E+00,.7487E+00,.7486E+00,.7384E+00,.7340E+00,.7368E+00,.7428E+00,.7454E+00,.6012E+00,&
 .7525E+00,.7525E+00,.7525E+00,.7518E+00,.7497E+00,.7405E+00,.7366E+00,.7377E+00,.7446E+00,.7473E+00,.6037E+00,&
 .7563E+00,.7563E+00,.7563E+00,.7548E+00,.7507E+00,.7427E+00,.7392E+00,.7387E+00,.7464E+00,.7492E+00,.6062E+00,&
 .7600E+00,.7600E+00,.7600E+00,.7579E+00,.7518E+00,.7448E+00,.7419E+00,.7396E+00,.7483E+00,.7511E+00,.6087E+00,&
 .7638E+00,.7638E+00,.7638E+00,.7609E+00,.7528E+00,.7470E+00,.7445E+00,.7406E+00,.7501E+00,.7530E+00,.6112E+00,&
 .7675E+00,.7675E+00,.7675E+00,.7640E+00,.7539E+00,.7491E+00,.7471E+00,.7415E+00,.7519E+00,.7549E+00,.6137E+00,&
 .7670E+00,.7670E+00,.7670E+00,.7640E+00,.7554E+00,.7500E+00,.7477E+00,.7437E+00,.7532E+00,.7566E+00,.6160E+00,&
 .7664E+00,.7664E+00,.7664E+00,.7640E+00,.7569E+00,.7508E+00,.7483E+00,.7459E+00,.7545E+00,.7583E+00,.6183E+00,&
 .7659E+00,.7659E+00,.7659E+00,.7639E+00,.7583E+00,.7517E+00,.7488E+00,.7481E+00,.7559E+00,.7601E+00,.6207E+00,&
 .7653E+00,.7653E+00,.7653E+00,.7639E+00,.7598E+00,.7525E+00,.7494E+00,.7503E+00,.7572E+00,.7618E+00,.6230E+00,&
 .7648E+00,.7648E+00,.7648E+00,.7639E+00,.7613E+00,.7534E+00,.7500E+00,.7525E+00,.7585E+00,.7635E+00,.6253E+00,&
 .7672E+00,.7672E+00,.7672E+00,.7659E+00,.7623E+00,.7552E+00,.7521E+00,.7528E+00,.7597E+00,.7649E+00,.6274E+00,&
 .7696E+00,.7696E+00,.7696E+00,.7679E+00,.7633E+00,.7570E+00,.7543E+00,.7531E+00,.7609E+00,.7662E+00,.6295E+00,&
 .7719E+00,.7719E+00,.7719E+00,.7700E+00,.7642E+00,.7588E+00,.7564E+00,.7535E+00,.7621E+00,.7676E+00,.6316E+00,&
 .7743E+00,.7743E+00,.7743E+00,.7720E+00,.7652E+00,.7606E+00,.7586E+00,.7538E+00,.7633E+00,.7689E+00,.6337E+00,&
 .7767E+00,.7767E+00,.7767E+00,.7740E+00,.7662E+00,.7624E+00,.7607E+00,.7541E+00,.7645E+00,.7703E+00,.6358E+00,&
 .7752E+00,.7752E+00,.7752E+00,.7730E+00,.7665E+00,.7633E+00,.7618E+00,.7557E+00,.7654E+00,.7716E+00,.6378E+00,&
 .7738E+00,.7738E+00,.7738E+00,.7720E+00,.7669E+00,.7642E+00,.7630E+00,.7573E+00,.7662E+00,.7728E+00,.6398E+00,&
 .7723E+00,.7723E+00,.7723E+00,.7710E+00,.7672E+00,.7650E+00,.7641E+00,.7590E+00,.7671E+00,.7741E+00,.6418E+00,&
 .7709E+00,.7709E+00,.7709E+00,.7700E+00,.7676E+00,.7659E+00,.7653E+00,.7606E+00,.7679E+00,.7753E+00,.6438E+00,&
 .7694E+00,.7694E+00,.7694E+00,.7690E+00,.7679E+00,.7668E+00,.7664E+00,.7622E+00,.7688E+00,.7766E+00,.6458E+00,&
 .7724E+00,.7724E+00,.7724E+00,.7717E+00,.7699E+00,.7683E+00,.7677E+00,.7625E+00,.7697E+00,.7776E+00,.6476E+00,&
 .7754E+00,.7754E+00,.7754E+00,.7745E+00,.7718E+00,.7698E+00,.7690E+00,.7629E+00,.7706E+00,.7787E+00,.6494E+00,&
 .7785E+00,.7785E+00,.7785E+00,.7772E+00,.7738E+00,.7713E+00,.7703E+00,.7632E+00,.7714E+00,.7797E+00,.6513E+00,&
 .7815E+00,.7815E+00,.7815E+00,.7800E+00,.7757E+00,.7728E+00,.7716E+00,.7636E+00,.7723E+00,.7808E+00,.6531E+00,&
 .7845E+00,.7845E+00,.7845E+00,.7827E+00,.7777E+00,.7743E+00,.7729E+00,.7639E+00,.7732E+00,.7818E+00,.6549E+00,&
 .7844E+00,.7844E+00,.7844E+00,.7829E+00,.7788E+00,.7744E+00,.7725E+00,.7651E+00,.7739E+00,.7827E+00,.6566E+00,&
 .7843E+00,.7843E+00,.7843E+00,.7831E+00,.7799E+00,.7745E+00,.7721E+00,.7663E+00,.7746E+00,.7836E+00,.6584E+00,&
 .7842E+00,.7842E+00,.7842E+00,.7834E+00,.7811E+00,.7745E+00,.7718E+00,.7675E+00,.7752E+00,.7844E+00,.6601E+00,&
 .7841E+00,.7841E+00,.7841E+00,.7836E+00,.7822E+00,.7746E+00,.7714E+00,.7687E+00,.7759E+00,.7853E+00,.6619E+00,&
 .7840E+00,.7840E+00,.7840E+00,.7838E+00,.7833E+00,.7747E+00,.7710E+00,.7699E+00,.7766E+00,.7862E+00,.6636E+00,&
 .7850E+00,.7850E+00,.7850E+00,.7845E+00,.7832E+00,.7755E+00,.7722E+00,.7707E+00,.7773E+00,.7871E+00,.6652E+00,&
 .7859E+00,.7859E+00,.7859E+00,.7852E+00,.7831E+00,.7763E+00,.7734E+00,.7715E+00,.7780E+00,.7880E+00,.6668E+00,&
 .7869E+00,.7869E+00,.7869E+00,.7859E+00,.7831E+00,.7772E+00,.7747E+00,.7723E+00,.7786E+00,.7890E+00,.6683E+00,&
 .7878E+00,.7878E+00,.7878E+00,.7866E+00,.7830E+00,.7780E+00,.7759E+00,.7731E+00,.7793E+00,.7899E+00,.6699E+00,&
 .7888E+00,.7888E+00,.7888E+00,.7873E+00,.7829E+00,.7788E+00,.7771E+00,.7739E+00,.7800E+00,.7908E+00,.6715E+00,&
 .7892E+00,.7892E+00,.7892E+00,.7878E+00,.7838E+00,.7799E+00,.7783E+00,.7736E+00,.7801E+00,.7912E+00,.6728E+00,&
 .7895E+00,.7895E+00,.7895E+00,.7883E+00,.7847E+00,.7810E+00,.7795E+00,.7733E+00,.7801E+00,.7916E+00,.6740E+00,&
 .7899E+00,.7899E+00,.7899E+00,.7888E+00,.7856E+00,.7822E+00,.7807E+00,.7731E+00,.7802E+00,.7921E+00,.6753E+00,&
 .7902E+00,.7902E+00,.7902E+00,.7893E+00,.7865E+00,.7833E+00,.7819E+00,.7728E+00,.7802E+00,.7925E+00,.6765E+00,&
 .7906E+00,.7906E+00,.7906E+00,.7898E+00,.7874E+00,.7844E+00,.7831E+00,.7725E+00,.7803E+00,.7929E+00,.6778E+00,&
 .7902E+00,.7902E+00,.7902E+00,.7894E+00,.7868E+00,.7844E+00,.7834E+00,.7737E+00,.7809E+00,.7936E+00,.6790E+00,&
 .7898E+00,.7898E+00,.7898E+00,.7889E+00,.7862E+00,.7845E+00,.7837E+00,.7749E+00,.7815E+00,.7943E+00,.6802E+00,&
 .7895E+00,.7895E+00,.7895E+00,.7885E+00,.7856E+00,.7845E+00,.7841E+00,.7761E+00,.7820E+00,.7949E+00,.6814E+00,&
 .7891E+00,.7891E+00,.7891E+00,.7880E+00,.7850E+00,.7846E+00,.7844E+00,.7773E+00,.7826E+00,.7956E+00,.6826E+00,&
 .7887E+00,.7887E+00,.7887E+00,.7876E+00,.7844E+00,.7846E+00,.7847E+00,.7785E+00,.7832E+00,.7963E+00,.6838E+00,&
 .7903E+00,.7903E+00,.7903E+00,.7891E+00,.7858E+00,.7846E+00,.7841E+00,.7789E+00,.7836E+00,.7968E+00,.6849E+00,&
 .7918E+00,.7918E+00,.7918E+00,.7906E+00,.7873E+00,.7847E+00,.7836E+00,.7793E+00,.7840E+00,.7973E+00,.6860E+00,&
 .7934E+00,.7934E+00,.7934E+00,.7922E+00,.7887E+00,.7847E+00,.7830E+00,.7798E+00,.7844E+00,.7977E+00,.6872E+00,&
 .7949E+00,.7949E+00,.7949E+00,.7937E+00,.7902E+00,.7848E+00,.7825E+00,.7802E+00,.7848E+00,.7982E+00,.6883E+00,&
 .7965E+00,.7965E+00,.7965E+00,.7952E+00,.7916E+00,.7848E+00,.7819E+00,.7806E+00,.7852E+00,.7987E+00,.6894E+00,&
 .7966E+00,.7966E+00,.7966E+00,.7955E+00,.7924E+00,.7860E+00,.7832E+00,.7802E+00,.7852E+00,.7990E+00,.6905E+00,&
 .7968E+00,.7968E+00,.7968E+00,.7958E+00,.7933E+00,.7871E+00,.7845E+00,.7798E+00,.7851E+00,.7993E+00,.6916E+00,&
 .7969E+00,.7969E+00,.7969E+00,.7962E+00,.7941E+00,.7883E+00,.7858E+00,.7793E+00,.7851E+00,.7995E+00,.6926E+00,&
 .7971E+00,.7971E+00,.7971E+00,.7965E+00,.7950E+00,.7894E+00,.7871E+00,.7789E+00,.7850E+00,.7998E+00,.6937E+00,&
 .7972E+00,.7972E+00,.7972E+00,.7968E+00,.7958E+00,.7906E+00,.7884E+00,.7785E+00,.7850E+00,.8001E+00,.6948E+00,&
 .7978E+00,.7978E+00,.7978E+00,.7973E+00,.7958E+00,.7899E+00,.7874E+00,.7798E+00,.7856E+00,.8009E+00,.6964E+00,&
 .7984E+00,.7984E+00,.7984E+00,.7977E+00,.7958E+00,.7892E+00,.7864E+00,.7811E+00,.7862E+00,.8017E+00,.6981E+00,&
 .7991E+00,.7991E+00,.7991E+00,.7982E+00,.7957E+00,.7884E+00,.7853E+00,.7825E+00,.7869E+00,.8025E+00,.6997E+00,&
 .7997E+00,.7997E+00,.7997E+00,.7986E+00,.7957E+00,.7877E+00,.7843E+00,.7838E+00,.7875E+00,.8033E+00,.7014E+00,&
 .8003E+00,.8003E+00,.8003E+00,.7991E+00,.7957E+00,.7870E+00,.7833E+00,.7851E+00,.7881E+00,.8041E+00,.7030E+00,&
 .8014E+00,.8014E+00,.8014E+00,.8000E+00,.7963E+00,.7896E+00,.7868E+00,.7850E+00,.7884E+00,.8046E+00,.7049E+00,&
 .8024E+00,.8024E+00,.8024E+00,.8010E+00,.7969E+00,.7923E+00,.7903E+00,.7848E+00,.7887E+00,.8050E+00,.7067E+00,&
 .8035E+00,.8035E+00,.8035E+00,.8019E+00,.7974E+00,.7949E+00,.7939E+00,.7847E+00,.7889E+00,.8055E+00,.7086E+00,&
 .8045E+00,.8045E+00,.8045E+00,.8029E+00,.7980E+00,.7976E+00,.7974E+00,.7845E+00,.7892E+00,.8059E+00,.7104E+00,&
 .8056E+00,.8056E+00,.8056E+00,.8038E+00,.7986E+00,.8002E+00,.8009E+00,.7844E+00,.7895E+00,.8064E+00,.7123E+00,&
 .8054E+00,.8054E+00,.8054E+00,.8052E+00,.8047E+00,.7964E+00,.7928E+00,.7879E+00,.7901E+00,.8073E+00,.7144E+00,&
 .8082E+00,.8082E+00,.8082E+00,.8068E+00,.8028E+00,.7968E+00,.7943E+00,.7902E+00,.7920E+00,.8089E+00,.7172E+00,&
 .8115E+00,.8115E+00,.8115E+00,.8077E+00,.7968E+00,.7989E+00,.7998E+00,.7874E+00,.7920E+00,.8095E+00,.7196E+00,&
 .8037E+00,.8037E+00,.8037E+00,.8036E+00,.8035E+00,.8021E+00,.8015E+00,.7885E+00,.7914E+00,.8094E+00,.7219E+00,&
 .8088E+00,.8088E+00,.8088E+00,.8089E+00,.8091E+00,.8006E+00,.7970E+00,.7886E+00,.7905E+00,.8100E+00,.7253E+00,&
 .8108E+00,.8108E+00,.8108E+00,.8100E+00,.8079E+00,.8016E+00,.7989E+00,.7911E+00,.7927E+00,.8108E+00,.7279E+00,&
 .8149E+00,.8149E+00,.8149E+00,.8139E+00,.8109E+00,.8047E+00,.8021E+00,.7944E+00,.7943E+00,.8127E+00,.7310E+00,&
 .8175E+00,.8175E+00,.8175E+00,.8140E+00,.8042E+00,.8027E+00,.8021E+00,.7922E+00,.7944E+00,.8133E+00,.7340E+00,&
 .8158E+00,.8158E+00,.8158E+00,.8153E+00,.8140E+00,.8079E+00,.8053E+00,.7930E+00,.7942E+00,.8131E+00,.7373E+00,&
 .8139E+00,.8139E+00,.8139E+00,.8147E+00,.8171E+00,.8079E+00,.8040E+00,.7960E+00,.7948E+00,.8140E+00,.7414E+00,&
 .8127E+00,.8127E+00,.8127E+00,.8128E+00,.8132E+00,.8073E+00,.8048E+00,.7986E+00,.7946E+00,.8159E+00,.7453E+00,&
 .8233E+00,.8233E+00,.8233E+00,.8223E+00,.8196E+00,.8158E+00,.8142E+00,.7974E+00,.7954E+00,.8155E+00,.7503E+00,&
 .8162E+00,.8162E+00,.8162E+00,.8158E+00,.8148E+00,.8160E+00,.8165E+00,.8004E+00,.7956E+00,.8173E+00,.7554E+00,&
 .8250E+00,.8250E+00,.8250E+00,.8239E+00,.8209E+00,.8182E+00,.8170E+00,.8006E+00,.7969E+00,.8173E+00,.7614E+00,&
 .8261E+00,.8261E+00,.8261E+00,.8251E+00,.8222E+00,.8148E+00,.8117E+00,.8035E+00,.7967E+00,.8193E+00,.7688E+00,&
 .8290E+00,.8290E+00,.8290E+00,.8269E+00,.8208E+00,.8184E+00,.8173E+00,.8068E+00,.7975E+00,.8194E+00,.7766E+00,&
 .8321E+00,.8321E+00,.8321E+00,.8319E+00,.8315E+00,.8273E+00,.8255E+00,.8128E+00,.8012E+00,.8211E+00,.7877E+00,&
 .8365E+00,.8365E+00,.8365E+00,.8361E+00,.8350E+00,.8308E+00,.8290E+00,.8160E+00,.8033E+00,.8199E+00,.7998E+00,&
 .8394E+00,.8394E+00,.8394E+00,.8392E+00,.8388E+00,.8404E+00,.8411E+00,.8269E+00,.8056E+00,.8214E+00,.8187E+00/
 data (((g(ai,k,nh),ai= 6, 6),k=1,11),nh=0,99)/ &
 .8058E+00,.8058E+00,.8058E+00,.8052E+00,.8034E+00,.8012E+00,.8003E+00,.7904E+00,.7734E+00,.7542E+00,.7236E+00,&
 .8078E+00,.8078E+00,.8078E+00,.8072E+00,.8055E+00,.8030E+00,.8019E+00,.7924E+00,.7752E+00,.7568E+00,.7293E+00,&
 .8098E+00,.8098E+00,.8098E+00,.8093E+00,.8077E+00,.8047E+00,.8035E+00,.7944E+00,.7770E+00,.7594E+00,.7349E+00,&
 .8119E+00,.8119E+00,.8119E+00,.8113E+00,.8098E+00,.8065E+00,.8050E+00,.7964E+00,.7787E+00,.7621E+00,.7406E+00,&
 .8139E+00,.8139E+00,.8139E+00,.8134E+00,.8120E+00,.8082E+00,.8066E+00,.7984E+00,.7805E+00,.7647E+00,.7462E+00,&
 .8159E+00,.8159E+00,.8159E+00,.8154E+00,.8141E+00,.8100E+00,.8082E+00,.8004E+00,.7823E+00,.7673E+00,.7519E+00,&
 .8170E+00,.8170E+00,.8170E+00,.8164E+00,.8149E+00,.8114E+00,.8099E+00,.8015E+00,.7840E+00,.7688E+00,.7560E+00,&
 .8180E+00,.8180E+00,.8180E+00,.8174E+00,.8157E+00,.8128E+00,.8115E+00,.8026E+00,.7858E+00,.7704E+00,.7601E+00,&
 .8191E+00,.8191E+00,.8191E+00,.8184E+00,.8164E+00,.8141E+00,.8132E+00,.8036E+00,.7875E+00,.7719E+00,.7643E+00,&
 .8201E+00,.8201E+00,.8201E+00,.8194E+00,.8172E+00,.8155E+00,.8148E+00,.8047E+00,.7893E+00,.7735E+00,.7684E+00,&
 .8212E+00,.8212E+00,.8212E+00,.8204E+00,.8180E+00,.8169E+00,.8165E+00,.8058E+00,.7910E+00,.7750E+00,.7725E+00,&
 .8222E+00,.8222E+00,.8222E+00,.8215E+00,.8192E+00,.8182E+00,.8179E+00,.8076E+00,.7928E+00,.7774E+00,.7754E+00,&
 .8233E+00,.8233E+00,.8233E+00,.8226E+00,.8205E+00,.8196E+00,.8192E+00,.8093E+00,.7946E+00,.7798E+00,.7784E+00,&
 .8243E+00,.8243E+00,.8243E+00,.8236E+00,.8217E+00,.8209E+00,.8206E+00,.8111E+00,.7963E+00,.7822E+00,.7813E+00,&
 .8254E+00,.8254E+00,.8254E+00,.8247E+00,.8230E+00,.8223E+00,.8219E+00,.8128E+00,.7981E+00,.7846E+00,.7843E+00,&
 .8264E+00,.8264E+00,.8264E+00,.8258E+00,.8242E+00,.8236E+00,.8233E+00,.8146E+00,.7999E+00,.7870E+00,.7872E+00,&
 .8272E+00,.8272E+00,.8272E+00,.8267E+00,.8254E+00,.8248E+00,.8245E+00,.8158E+00,.8010E+00,.7881E+00,.7898E+00,&
 .8280E+00,.8280E+00,.8280E+00,.8276E+00,.8265E+00,.8260E+00,.8257E+00,.8171E+00,.8020E+00,.7892E+00,.7924E+00,&
 .8288E+00,.8288E+00,.8288E+00,.8285E+00,.8277E+00,.8271E+00,.8269E+00,.8183E+00,.8031E+00,.7902E+00,.7949E+00,&
 .8296E+00,.8296E+00,.8296E+00,.8294E+00,.8288E+00,.8283E+00,.8281E+00,.8196E+00,.8041E+00,.7913E+00,.7975E+00,&
 .8304E+00,.8304E+00,.8304E+00,.8303E+00,.8300E+00,.8295E+00,.8293E+00,.8208E+00,.8052E+00,.7924E+00,.8001E+00,&
 .8316E+00,.8316E+00,.8316E+00,.8314E+00,.8307E+00,.8306E+00,.8305E+00,.8219E+00,.8062E+00,.7939E+00,.8020E+00,&
 .8328E+00,.8328E+00,.8328E+00,.8325E+00,.8315E+00,.8316E+00,.8317E+00,.8230E+00,.8071E+00,.7955E+00,.8039E+00,&
 .8340E+00,.8340E+00,.8340E+00,.8335E+00,.8322E+00,.8327E+00,.8329E+00,.8242E+00,.8081E+00,.7970E+00,.8058E+00,&
 .8352E+00,.8352E+00,.8352E+00,.8346E+00,.8330E+00,.8337E+00,.8341E+00,.8253E+00,.8090E+00,.7986E+00,.8077E+00,&
 .8364E+00,.8364E+00,.8364E+00,.8357E+00,.8337E+00,.8348E+00,.8353E+00,.8264E+00,.8100E+00,.8001E+00,.8096E+00,&
 .8369E+00,.8369E+00,.8369E+00,.8365E+00,.8352E+00,.8357E+00,.8359E+00,.8273E+00,.8108E+00,.8008E+00,.8113E+00,&
 .8374E+00,.8374E+00,.8374E+00,.8372E+00,.8367E+00,.8365E+00,.8365E+00,.8282E+00,.8116E+00,.8016E+00,.8130E+00,&
 .8379E+00,.8379E+00,.8379E+00,.8380E+00,.8381E+00,.8374E+00,.8370E+00,.8291E+00,.8124E+00,.8023E+00,.8147E+00,&
 .8384E+00,.8384E+00,.8384E+00,.8387E+00,.8396E+00,.8382E+00,.8376E+00,.8300E+00,.8132E+00,.8031E+00,.8164E+00,&
 .8389E+00,.8389E+00,.8389E+00,.8395E+00,.8411E+00,.8391E+00,.8382E+00,.8309E+00,.8140E+00,.8038E+00,.8181E+00,&
 .8393E+00,.8393E+00,.8393E+00,.8397E+00,.8410E+00,.8390E+00,.8381E+00,.8313E+00,.8149E+00,.8047E+00,.8196E+00,&
 .8396E+00,.8396E+00,.8396E+00,.8399E+00,.8408E+00,.8388E+00,.8380E+00,.8318E+00,.8159E+00,.8056E+00,.8212E+00,&
 .8400E+00,.8400E+00,.8400E+00,.8402E+00,.8407E+00,.8387E+00,.8378E+00,.8322E+00,.8168E+00,.8064E+00,.8227E+00,&
 .8403E+00,.8403E+00,.8403E+00,.8404E+00,.8405E+00,.8385E+00,.8377E+00,.8327E+00,.8178E+00,.8073E+00,.8243E+00,&
 .8407E+00,.8407E+00,.8407E+00,.8406E+00,.8404E+00,.8384E+00,.8376E+00,.8331E+00,.8187E+00,.8082E+00,.8258E+00,&
 .8411E+00,.8411E+00,.8411E+00,.8411E+00,.8410E+00,.8396E+00,.8390E+00,.8337E+00,.8196E+00,.8094E+00,.8269E+00,&
 .8415E+00,.8415E+00,.8415E+00,.8416E+00,.8416E+00,.8407E+00,.8404E+00,.8343E+00,.8204E+00,.8106E+00,.8280E+00,&
 .8420E+00,.8420E+00,.8420E+00,.8420E+00,.8423E+00,.8419E+00,.8417E+00,.8348E+00,.8213E+00,.8119E+00,.8290E+00,&
 .8424E+00,.8424E+00,.8424E+00,.8425E+00,.8429E+00,.8430E+00,.8431E+00,.8354E+00,.8221E+00,.8131E+00,.8301E+00,&
 .8428E+00,.8428E+00,.8428E+00,.8430E+00,.8435E+00,.8442E+00,.8445E+00,.8360E+00,.8230E+00,.8143E+00,.8312E+00,&
 .8437E+00,.8437E+00,.8437E+00,.8438E+00,.8440E+00,.8446E+00,.8448E+00,.8368E+00,.8237E+00,.8149E+00,.8324E+00,&
 .8446E+00,.8446E+00,.8446E+00,.8446E+00,.8446E+00,.8449E+00,.8451E+00,.8377E+00,.8244E+00,.8155E+00,.8335E+00,&
 .8455E+00,.8455E+00,.8455E+00,.8454E+00,.8451E+00,.8453E+00,.8453E+00,.8385E+00,.8252E+00,.8160E+00,.8347E+00,&
 .8464E+00,.8464E+00,.8464E+00,.8462E+00,.8457E+00,.8456E+00,.8456E+00,.8394E+00,.8259E+00,.8166E+00,.8358E+00,&
 .8473E+00,.8473E+00,.8473E+00,.8470E+00,.8462E+00,.8460E+00,.8459E+00,.8402E+00,.8266E+00,.8172E+00,.8370E+00,&
 .8475E+00,.8475E+00,.8475E+00,.8473E+00,.8470E+00,.8468E+00,.8468E+00,.8404E+00,.8271E+00,.8178E+00,.8378E+00,&
 .8477E+00,.8477E+00,.8477E+00,.8477E+00,.8477E+00,.8477E+00,.8477E+00,.8407E+00,.8276E+00,.8185E+00,.8386E+00,&
 .8479E+00,.8479E+00,.8479E+00,.8480E+00,.8485E+00,.8485E+00,.8485E+00,.8409E+00,.8282E+00,.8191E+00,.8395E+00,&
 .8481E+00,.8481E+00,.8481E+00,.8484E+00,.8492E+00,.8494E+00,.8494E+00,.8412E+00,.8287E+00,.8198E+00,.8403E+00,&
 .8483E+00,.8483E+00,.8483E+00,.8487E+00,.8500E+00,.8502E+00,.8503E+00,.8414E+00,.8292E+00,.8204E+00,.8411E+00,&
 .8488E+00,.8488E+00,.8488E+00,.8491E+00,.8500E+00,.8498E+00,.8497E+00,.8420E+00,.8294E+00,.8207E+00,.8418E+00,&
 .8493E+00,.8493E+00,.8493E+00,.8494E+00,.8499E+00,.8493E+00,.8491E+00,.8426E+00,.8297E+00,.8211E+00,.8426E+00,&
 .8497E+00,.8497E+00,.8497E+00,.8498E+00,.8499E+00,.8489E+00,.8484E+00,.8433E+00,.8299E+00,.8214E+00,.8433E+00,&
 .8502E+00,.8502E+00,.8502E+00,.8501E+00,.8498E+00,.8484E+00,.8478E+00,.8439E+00,.8302E+00,.8218E+00,.8441E+00,&
 .8507E+00,.8507E+00,.8507E+00,.8505E+00,.8498E+00,.8480E+00,.8472E+00,.8445E+00,.8304E+00,.8221E+00,.8448E+00,&
 .8503E+00,.8503E+00,.8503E+00,.8504E+00,.8504E+00,.8489E+00,.8482E+00,.8445E+00,.8310E+00,.8228E+00,.8455E+00,&
 .8499E+00,.8499E+00,.8499E+00,.8502E+00,.8510E+00,.8498E+00,.8492E+00,.8446E+00,.8316E+00,.8235E+00,.8461E+00,&
 .8495E+00,.8495E+00,.8495E+00,.8501E+00,.8517E+00,.8506E+00,.8502E+00,.8446E+00,.8323E+00,.8242E+00,.8468E+00,&
 .8491E+00,.8491E+00,.8491E+00,.8499E+00,.8523E+00,.8515E+00,.8512E+00,.8447E+00,.8329E+00,.8249E+00,.8474E+00,&
 .8487E+00,.8487E+00,.8487E+00,.8498E+00,.8529E+00,.8524E+00,.8522E+00,.8447E+00,.8335E+00,.8256E+00,.8481E+00,&
 .8498E+00,.8498E+00,.8498E+00,.8506E+00,.8530E+00,.8525E+00,.8524E+00,.8455E+00,.8338E+00,.8257E+00,.8486E+00,&
 .8508E+00,.8508E+00,.8508E+00,.8514E+00,.8530E+00,.8527E+00,.8525E+00,.8463E+00,.8340E+00,.8258E+00,.8491E+00,&
 .8519E+00,.8519E+00,.8519E+00,.8522E+00,.8531E+00,.8528E+00,.8527E+00,.8470E+00,.8343E+00,.8260E+00,.8496E+00,&
 .8529E+00,.8529E+00,.8529E+00,.8530E+00,.8531E+00,.8530E+00,.8528E+00,.8478E+00,.8345E+00,.8261E+00,.8501E+00,&
 .8540E+00,.8540E+00,.8540E+00,.8538E+00,.8532E+00,.8531E+00,.8530E+00,.8486E+00,.8348E+00,.8262E+00,.8506E+00,&
 .8532E+00,.8532E+00,.8532E+00,.8532E+00,.8533E+00,.8535E+00,.8535E+00,.8487E+00,.8350E+00,.8269E+00,.8511E+00,&
 .8523E+00,.8523E+00,.8523E+00,.8526E+00,.8534E+00,.8538E+00,.8540E+00,.8488E+00,.8352E+00,.8275E+00,.8516E+00,&
 .8515E+00,.8515E+00,.8515E+00,.8520E+00,.8534E+00,.8542E+00,.8544E+00,.8488E+00,.8355E+00,.8282E+00,.8522E+00,&
 .8506E+00,.8506E+00,.8506E+00,.8514E+00,.8535E+00,.8545E+00,.8549E+00,.8489E+00,.8357E+00,.8288E+00,.8527E+00,&
 .8498E+00,.8498E+00,.8498E+00,.8508E+00,.8536E+00,.8549E+00,.8554E+00,.8490E+00,.8359E+00,.8295E+00,.8532E+00,&
 .8510E+00,.8510E+00,.8510E+00,.8515E+00,.8531E+00,.8547E+00,.8554E+00,.8494E+00,.8366E+00,.8301E+00,.8540E+00,&
 .8521E+00,.8521E+00,.8521E+00,.8522E+00,.8526E+00,.8546E+00,.8554E+00,.8498E+00,.8372E+00,.8307E+00,.8548E+00,&
 .8533E+00,.8533E+00,.8533E+00,.8530E+00,.8520E+00,.8544E+00,.8554E+00,.8501E+00,.8379E+00,.8313E+00,.8555E+00,&
 .8544E+00,.8544E+00,.8544E+00,.8537E+00,.8515E+00,.8543E+00,.8554E+00,.8505E+00,.8385E+00,.8319E+00,.8563E+00,&
 .8556E+00,.8556E+00,.8556E+00,.8544E+00,.8510E+00,.8541E+00,.8554E+00,.8509E+00,.8392E+00,.8325E+00,.8571E+00,&
 .8560E+00,.8560E+00,.8560E+00,.8551E+00,.8524E+00,.8543E+00,.8551E+00,.8515E+00,.8395E+00,.8331E+00,.8579E+00,&
 .8565E+00,.8565E+00,.8565E+00,.8558E+00,.8538E+00,.8546E+00,.8549E+00,.8521E+00,.8398E+00,.8337E+00,.8588E+00,&
 .8569E+00,.8569E+00,.8569E+00,.8565E+00,.8552E+00,.8548E+00,.8546E+00,.8527E+00,.8401E+00,.8344E+00,.8596E+00,&
 .8574E+00,.8574E+00,.8574E+00,.8572E+00,.8566E+00,.8551E+00,.8544E+00,.8533E+00,.8404E+00,.8350E+00,.8605E+00,&
 .8578E+00,.8578E+00,.8578E+00,.8579E+00,.8580E+00,.8553E+00,.8541E+00,.8539E+00,.8407E+00,.8356E+00,.8613E+00,&
 .8505E+00,.8505E+00,.8505E+00,.8530E+00,.8600E+00,.8570E+00,.8557E+00,.8537E+00,.8415E+00,.8363E+00,.8624E+00,&
 .8563E+00,.8563E+00,.8563E+00,.8571E+00,.8592E+00,.8577E+00,.8571E+00,.8538E+00,.8423E+00,.8370E+00,.8636E+00,&
 .8561E+00,.8561E+00,.8561E+00,.8570E+00,.8597E+00,.8600E+00,.8601E+00,.8532E+00,.8447E+00,.8380E+00,.8650E+00,&
 .8571E+00,.8571E+00,.8571E+00,.8579E+00,.8602E+00,.8576E+00,.8565E+00,.8549E+00,.8457E+00,.8377E+00,.8662E+00,&
 .8596E+00,.8596E+00,.8596E+00,.8590E+00,.8574E+00,.8552E+00,.8542E+00,.8548E+00,.8448E+00,.8393E+00,.8670E+00,&
 .8578E+00,.8578E+00,.8578E+00,.8587E+00,.8612E+00,.8587E+00,.8577E+00,.8569E+00,.8449E+00,.8413E+00,.8684E+00,&
 .8598E+00,.8598E+00,.8598E+00,.8601E+00,.8608E+00,.8619E+00,.8623E+00,.8568E+00,.8478E+00,.8405E+00,.8698E+00,&
 .8596E+00,.8596E+00,.8596E+00,.8598E+00,.8603E+00,.8618E+00,.8625E+00,.8574E+00,.8495E+00,.8444E+00,.8712E+00,&
 .8590E+00,.8590E+00,.8590E+00,.8593E+00,.8601E+00,.8627E+00,.8638E+00,.8579E+00,.8501E+00,.8445E+00,.8726E+00,&
 .8596E+00,.8596E+00,.8596E+00,.8606E+00,.8634E+00,.8633E+00,.8633E+00,.8585E+00,.8510E+00,.8465E+00,.8737E+00,&
 .8616E+00,.8616E+00,.8616E+00,.8621E+00,.8637E+00,.8642E+00,.8644E+00,.8607E+00,.8489E+00,.8452E+00,.8757E+00,&
 .8604E+00,.8604E+00,.8604E+00,.8613E+00,.8640E+00,.8646E+00,.8649E+00,.8598E+00,.8523E+00,.8481E+00,.8776E+00,&
 .8635E+00,.8635E+00,.8635E+00,.8635E+00,.8634E+00,.8635E+00,.8635E+00,.8614E+00,.8541E+00,.8509E+00,.8798E+00,&
 .8641E+00,.8641E+00,.8641E+00,.8642E+00,.8644E+00,.8657E+00,.8662E+00,.8633E+00,.8555E+00,.8543E+00,.8828E+00,&
 .8640E+00,.8640E+00,.8640E+00,.8641E+00,.8644E+00,.8655E+00,.8659E+00,.8638E+00,.8554E+00,.8557E+00,.8856E+00,&
 .8650E+00,.8650E+00,.8650E+00,.8653E+00,.8663E+00,.8658E+00,.8656E+00,.8655E+00,.8586E+00,.8593E+00,.8897E+00,&
 .8634E+00,.8634E+00,.8634E+00,.8644E+00,.8674E+00,.8673E+00,.8672E+00,.8665E+00,.8606E+00,.8616E+00,.8945E+00,&
 .8667E+00,.8667E+00,.8667E+00,.8672E+00,.8688E+00,.8705E+00,.8712E+00,.8693E+00,.8631E+00,.8689E+00,.9015E+00,&
 .8681E+00,.8681E+00,.8681E+00,.8689E+00,.8712E+00,.8727E+00,.8733E+00,.8724E+00,.8678E+00,.8764E+00,.9133E+00/
 data (((g(ai,k,nh),ai= 7, 7),k=1,11),nh=0,99)/ &
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00,&
 .6825E+00,.6825E+00,.6825E+00,.6800E+00,.6730E+00,.6662E+00,.6633E+00,.6279E+00,.5549E+00,.4291E+00,.1782E+00/
 data (((g(ai,k,nh),ai= 8, 8),k=1,11),nh=0,99)/ &
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00,&
 .6953E+00,.6953E+00,.6953E+00,.6932E+00,.6872E+00,.6824E+00,.6803E+00,.6639E+00,.6242E+00,.5365E+00,.2860E+00/
 data (((g(ai,k,nh),ai= 9, 9),k=1,11),nh=0,99)/ &
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00,&
 .7212E+00,.7212E+00,.7212E+00,.7176E+00,.7075E+00,.6986E+00,.6948E+00,.6772E+00,.6651E+00,.6228E+00,.4221E+00/
 data (((g(ai,k,nh),ai=10,10),k=1,11),nh=0,99)/ &
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00,&
 .7755E+00,.7755E+00,.7755E+00,.7689E+00,.7501E+00,.7333E+00,.7261E+00,.6877E+00,.6751E+00,.6633E+00,.5350E+00/
 data (((g(ai,k,nh),ai=11,11),k=1,11),nh=0,99)/ &
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00,&
 .8317E+00,.8317E+00,.8317E+00,.8253E+00,.8070E+00,.7861E+00,.7772E+00,.7191E+00,.6857E+00,.6780E+00,.6206E+00/
 data (((g(ai,k,nh),ai=12,12),k=1,11),nh=0,99)/ &
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00,&
 .8782E+00,.8782E+00,.8782E+00,.8721E+00,.8548E+00,.8341E+00,.8252E+00,.7619E+00,.7130E+00,.6868E+00,.6776E+00/
 data (((g(ai,k,nh),ai=13,13),k=1,11),nh=0,99)/ &
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00,&
 .9167E+00,.9167E+00,.9167E+00,.9122E+00,.8994E+00,.8806E+00,.8725E+00,.8078E+00,.7602E+00,.7160E+00,.7239E+00/
 data (((g(ai,k,nh),ai=14,14),k=1,11),nh=0,99)/ &
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00,&
 .9366E+00,.9366E+00,.9366E+00,.9340E+00,.9266E+00,.9120E+00,.9058E+00,.8411E+00,.7960E+00,.7643E+00,.7644E+00/

 data (((Bex_lw(ai,k,nh),ai= 1, 1),k=1,nwl_lw),nh=0,99)/ &
 .2252E-01,.2261E-01,.8372E-01,.1441E+00,.2880E+00,.4679E+00,.3723E+00,.1729E+00,.2097E+00,.9603E-01,&
 .2373E-01,.2456E-01,.8750E-01,.1471E+00,.2917E+00,.4703E+00,.3718E+00,.1742E+00,.2103E+00,.9952E-01,&
 .2495E-01,.2652E-01,.9128E-01,.1502E+00,.2954E+00,.4726E+00,.3714E+00,.1755E+00,.2108E+00,.1030E+00,&
 .2617E-01,.2847E-01,.9506E-01,.1532E+00,.2991E+00,.4749E+00,.3709E+00,.1768E+00,.2114E+00,.1065E+00,&
 .2738E-01,.3042E-01,.9884E-01,.1563E+00,.3028E+00,.4772E+00,.3704E+00,.1781E+00,.2120E+00,.1100E+00,&
 .2860E-01,.3238E-01,.1026E+00,.1594E+00,.3065E+00,.4796E+00,.3700E+00,.1794E+00,.2125E+00,.1135E+00,&
 .2994E-01,.3456E-01,.1068E+00,.1625E+00,.3098E+00,.4815E+00,.3697E+00,.1808E+00,.2132E+00,.1173E+00,&
 .3129E-01,.3674E-01,.1109E+00,.1655E+00,.3132E+00,.4834E+00,.3695E+00,.1822E+00,.2138E+00,.1212E+00,&
 .3263E-01,.3892E-01,.1151E+00,.1686E+00,.3165E+00,.4853E+00,.3692E+00,.1835E+00,.2144E+00,.1250E+00,&
 .3397E-01,.4110E-01,.1193E+00,.1717E+00,.3198E+00,.4872E+00,.3690E+00,.1849E+00,.2150E+00,.1288E+00,&
 .3531E-01,.4328E-01,.1234E+00,.1748E+00,.3231E+00,.4892E+00,.3687E+00,.1863E+00,.2157E+00,.1326E+00,&
 .3674E-01,.4561E-01,.1278E+00,.1779E+00,.3260E+00,.4909E+00,.3688E+00,.1878E+00,.2164E+00,.1367E+00,&
 .3817E-01,.4795E-01,.1322E+00,.1810E+00,.3290E+00,.4926E+00,.3688E+00,.1893E+00,.2171E+00,.1407E+00,&
 .3959E-01,.5028E-01,.1366E+00,.1840E+00,.3320E+00,.4944E+00,.3689E+00,.1908E+00,.2179E+00,.1447E+00,&
 .4102E-01,.5261E-01,.1410E+00,.1871E+00,.3349E+00,.4961E+00,.3689E+00,.1923E+00,.2186E+00,.1488E+00,&
 .4245E-01,.5494E-01,.1454E+00,.1902E+00,.3379E+00,.4979E+00,.3690E+00,.1938E+00,.2193E+00,.1528E+00,&
 .4404E-01,.5757E-01,.1503E+00,.1934E+00,.3406E+00,.4994E+00,.3691E+00,.1954E+00,.2201E+00,.1573E+00,&
 .4563E-01,.6019E-01,.1552E+00,.1966E+00,.3433E+00,.5009E+00,.3692E+00,.1969E+00,.2209E+00,.1617E+00,&
 .4723E-01,.6282E-01,.1601E+00,.1998E+00,.3460E+00,.5023E+00,.3693E+00,.1985E+00,.2217E+00,.1662E+00,&
 .4882E-01,.6545E-01,.1650E+00,.2030E+00,.3487E+00,.5038E+00,.3694E+00,.2001E+00,.2225E+00,.1707E+00,&
 .5041E-01,.6807E-01,.1699E+00,.2062E+00,.3515E+00,.5053E+00,.3695E+00,.2017E+00,.2232E+00,.1751E+00,&
 .5213E-01,.7092E-01,.1752E+00,.2094E+00,.3540E+00,.5067E+00,.3698E+00,.2034E+00,.2241E+00,.1800E+00,&
 .5385E-01,.7376E-01,.1805E+00,.2127E+00,.3565E+00,.5081E+00,.3701E+00,.2051E+00,.2250E+00,.1848E+00,&
 .5556E-01,.7661E-01,.1858E+00,.2160E+00,.3590E+00,.5095E+00,.3703E+00,.2069E+00,.2259E+00,.1896E+00,&
 .5728E-01,.7946E-01,.1910E+00,.2192E+00,.3615E+00,.5109E+00,.3706E+00,.2086E+00,.2268E+00,.1944E+00,&
 .5900E-01,.8230E-01,.1963E+00,.2225E+00,.3640E+00,.5123E+00,.3709E+00,.2103E+00,.2277E+00,.1992E+00,&
 .6085E-01,.8537E-01,.2020E+00,.2259E+00,.3663E+00,.5136E+00,.3713E+00,.2121E+00,.2287E+00,.2044E+00,&
 .6270E-01,.8845E-01,.2077E+00,.2292E+00,.3686E+00,.5149E+00,.3717E+00,.2140E+00,.2296E+00,.2095E+00,&
 .6455E-01,.9152E-01,.2133E+00,.2326E+00,.3710E+00,.5162E+00,.3721E+00,.2158E+00,.2306E+00,.2147E+00,&
 .6639E-01,.9459E-01,.2190E+00,.2359E+00,.3733E+00,.5175E+00,.3725E+00,.2176E+00,.2316E+00,.2198E+00,&
 .6824E-01,.9766E-01,.2246E+00,.2393E+00,.3757E+00,.5188E+00,.3729E+00,.2194E+00,.2326E+00,.2250E+00,&
 .7022E-01,.1010E+00,.2307E+00,.2428E+00,.3779E+00,.5201E+00,.3734E+00,.2214E+00,.2337E+00,.2305E+00,&
 .7220E-01,.1043E+00,.2367E+00,.2462E+00,.3801E+00,.5214E+00,.3739E+00,.2234E+00,.2347E+00,.2360E+00,&
 .7417E-01,.1076E+00,.2428E+00,.2497E+00,.3823E+00,.5226E+00,.3745E+00,.2254E+00,.2358E+00,.2415E+00,&
 .7615E-01,.1108E+00,.2489E+00,.2532E+00,.3845E+00,.5239E+00,.3750E+00,.2273E+00,.2369E+00,.2470E+00,&
 .7813E-01,.1141E+00,.2549E+00,.2566E+00,.3867E+00,.5252E+00,.3755E+00,.2293E+00,.2380E+00,.2525E+00,&
 .8019E-01,.1176E+00,.2612E+00,.2602E+00,.3889E+00,.5266E+00,.3763E+00,.2314E+00,.2393E+00,.2582E+00,&
 .8225E-01,.1210E+00,.2675E+00,.2637E+00,.3911E+00,.5280E+00,.3770E+00,.2335E+00,.2405E+00,.2640E+00,&
 .8430E-01,.1245E+00,.2738E+00,.2673E+00,.3932E+00,.5293E+00,.3778E+00,.2356E+00,.2418E+00,.2697E+00,&
 .8636E-01,.1279E+00,.2801E+00,.2708E+00,.3954E+00,.5307E+00,.3785E+00,.2376E+00,.2430E+00,.2754E+00,&
 .8842E-01,.1313E+00,.2864E+00,.2744E+00,.3976E+00,.5321E+00,.3792E+00,.2397E+00,.2443E+00,.2812E+00,&
 .9066E-01,.1351E+00,.2933E+00,.2781E+00,.3996E+00,.5334E+00,.3800E+00,.2420E+00,.2456E+00,.2874E+00,&
 .9291E-01,.1389E+00,.3001E+00,.2818E+00,.4017E+00,.5347E+00,.3808E+00,.2442E+00,.2470E+00,.2936E+00,&
 .9515E-01,.1426E+00,.3070E+00,.2856E+00,.4038E+00,.5360E+00,.3815E+00,.2464E+00,.2483E+00,.2999E+00,&
 .9739E-01,.1464E+00,.3139E+00,.2893E+00,.4059E+00,.5373E+00,.3823E+00,.2487E+00,.2497E+00,.3061E+00,&
 .9964E-01,.1501E+00,.3207E+00,.2930E+00,.4079E+00,.5386E+00,.3831E+00,.2509E+00,.2510E+00,.3123E+00,&
 .1020E+00,.1541E+00,.3280E+00,.2969E+00,.4100E+00,.5399E+00,.3840E+00,.2533E+00,.2525E+00,.3189E+00,&
 .1044E+00,.1581E+00,.3353E+00,.3008E+00,.4120E+00,.5412E+00,.3848E+00,.2557E+00,.2540E+00,.3255E+00,&
 .1068E+00,.1621E+00,.3425E+00,.3046E+00,.4141E+00,.5425E+00,.3857E+00,.2580E+00,.2555E+00,.3321E+00,&
 .1091E+00,.1661E+00,.3498E+00,.3085E+00,.4161E+00,.5438E+00,.3866E+00,.2604E+00,.2570E+00,.3387E+00,&
 .1115E+00,.1701E+00,.3571E+00,.3124E+00,.4182E+00,.5452E+00,.3875E+00,.2628E+00,.2585E+00,.3453E+00,&
 .1139E+00,.1741E+00,.3644E+00,.3163E+00,.4203E+00,.5467E+00,.3886E+00,.2653E+00,.2602E+00,.3520E+00,&
 .1164E+00,.1782E+00,.3718E+00,.3202E+00,.4224E+00,.5483E+00,.3898E+00,.2678E+00,.2619E+00,.3587E+00,&
 .1188E+00,.1822E+00,.3791E+00,.3242E+00,.4245E+00,.5498E+00,.3909E+00,.2703E+00,.2636E+00,.3654E+00,&
 .1212E+00,.1862E+00,.3865E+00,.3281E+00,.4266E+00,.5514E+00,.3920E+00,.2728E+00,.2653E+00,.3721E+00,&
 .1236E+00,.1903E+00,.3938E+00,.3320E+00,.4288E+00,.5530E+00,.3932E+00,.2753E+00,.2670E+00,.3788E+00,&
 .1261E+00,.1944E+00,.4014E+00,.3361E+00,.4309E+00,.5547E+00,.3945E+00,.2779E+00,.2689E+00,.3857E+00,&
 .1285E+00,.1986E+00,.4090E+00,.3401E+00,.4331E+00,.5564E+00,.3957E+00,.2806E+00,.2708E+00,.3926E+00,&
 .1310E+00,.2028E+00,.4166E+00,.3442E+00,.4353E+00,.5581E+00,.3970E+00,.2832E+00,.2727E+00,.3995E+00,&
 .1335E+00,.2069E+00,.4242E+00,.3482E+00,.4374E+00,.5598E+00,.3983E+00,.2858E+00,.2746E+00,.4064E+00,&
 .1360E+00,.2111E+00,.4318E+00,.3523E+00,.4396E+00,.5615E+00,.3996E+00,.2885E+00,.2765E+00,.4133E+00,&
 .1387E+00,.2156E+00,.4400E+00,.3565E+00,.4418E+00,.5632E+00,.4010E+00,.2913E+00,.2785E+00,.4208E+00,&
 .1413E+00,.2201E+00,.4481E+00,.3608E+00,.4439E+00,.5648E+00,.4023E+00,.2941E+00,.2806E+00,.4282E+00,&
 .1440E+00,.2246E+00,.4563E+00,.3651E+00,.4460E+00,.5665E+00,.4036E+00,.2969E+00,.2826E+00,.4357E+00,&
 .1467E+00,.2291E+00,.4645E+00,.3693E+00,.4482E+00,.5681E+00,.4049E+00,.2997E+00,.2846E+00,.4431E+00,&
 .1493E+00,.2336E+00,.4727E+00,.3736E+00,.4503E+00,.5698E+00,.4063E+00,.3025E+00,.2867E+00,.4505E+00,&
 .1522E+00,.2383E+00,.4813E+00,.3781E+00,.4525E+00,.5715E+00,.4077E+00,.3055E+00,.2889E+00,.4584E+00,&
 .1550E+00,.2431E+00,.4899E+00,.3825E+00,.4547E+00,.5732E+00,.4091E+00,.3085E+00,.2911E+00,.4662E+00,&
 .1578E+00,.2478E+00,.4985E+00,.3870E+00,.4569E+00,.5749E+00,.4105E+00,.3114E+00,.2933E+00,.4740E+00,&
 .1607E+00,.2525E+00,.5071E+00,.3914E+00,.4591E+00,.5766E+00,.4119E+00,.3144E+00,.2956E+00,.4819E+00,&
 .1635E+00,.2573E+00,.5157E+00,.3958E+00,.4613E+00,.5784E+00,.4133E+00,.3173E+00,.2978E+00,.4897E+00,&
 .1676E+00,.2644E+00,.5283E+00,.4017E+00,.4627E+00,.5786E+00,.4139E+00,.3210E+00,.3000E+00,.5010E+00,&
 .1718E+00,.2714E+00,.5409E+00,.4075E+00,.4642E+00,.5788E+00,.4145E+00,.3246E+00,.3023E+00,.5124E+00,&
 .1759E+00,.2785E+00,.5535E+00,.4133E+00,.4657E+00,.5790E+00,.4151E+00,.3282E+00,.3045E+00,.5238E+00,&
 .1801E+00,.2856E+00,.5661E+00,.4192E+00,.4672E+00,.5793E+00,.4157E+00,.3318E+00,.3067E+00,.5351E+00,&
 .1843E+00,.2926E+00,.5787E+00,.4250E+00,.4687E+00,.5795E+00,.4163E+00,.3355E+00,.3090E+00,.5465E+00,&
 .1886E+00,.3001E+00,.5920E+00,.4311E+00,.4703E+00,.5799E+00,.4171E+00,.3394E+00,.3115E+00,.5584E+00,&
 .1930E+00,.3075E+00,.6052E+00,.4372E+00,.4718E+00,.5803E+00,.4179E+00,.3433E+00,.3141E+00,.5704E+00,&
 .1973E+00,.3149E+00,.6184E+00,.4433E+00,.4734E+00,.5807E+00,.4187E+00,.3472E+00,.3167E+00,.5823E+00,&
 .2017E+00,.3224E+00,.6317E+00,.4494E+00,.4749E+00,.5811E+00,.4195E+00,.3511E+00,.3193E+00,.5943E+00,&
 .2061E+00,.3298E+00,.6449E+00,.4555E+00,.4765E+00,.5815E+00,.4203E+00,.3550E+00,.3219E+00,.6062E+00,&
 .2109E+00,.3380E+00,.6595E+00,.4622E+00,.4779E+00,.5816E+00,.4211E+00,.3592E+00,.3247E+00,.6194E+00,&
 .2158E+00,.3464E+00,.6743E+00,.4688E+00,.4793E+00,.5818E+00,.4219E+00,.3635E+00,.3275E+00,.6327E+00,&
 .2207E+00,.3547E+00,.6892E+00,.4756E+00,.4809E+00,.5820E+00,.4227E+00,.3678E+00,.3305E+00,.6462E+00,&
 .2274E+00,.3662E+00,.7093E+00,.4841E+00,.4814E+00,.5803E+00,.4225E+00,.3731E+00,.3335E+00,.6643E+00,&
 .2341E+00,.3777E+00,.7295E+00,.4927E+00,.4819E+00,.5787E+00,.4224E+00,.3784E+00,.3366E+00,.6825E+00,&
 .2409E+00,.3893E+00,.7500E+00,.5014E+00,.4826E+00,.5773E+00,.4225E+00,.3838E+00,.3399E+00,.7008E+00,&
 .2494E+00,.4039E+00,.7756E+00,.5119E+00,.4824E+00,.5741E+00,.4217E+00,.3902E+00,.3433E+00,.7238E+00,&
 .2580E+00,.4187E+00,.8014E+00,.5224E+00,.4823E+00,.5711E+00,.4210E+00,.3967E+00,.3470E+00,.7470E+00,&
 .2682E+00,.4364E+00,.8323E+00,.5348E+00,.4814E+00,.5666E+00,.4197E+00,.4042E+00,.3509E+00,.7746E+00,&
 .2802E+00,.4571E+00,.8683E+00,.5490E+00,.4799E+00,.5608E+00,.4179E+00,.4128E+00,.3553E+00,.8069E+00,&
 .2922E+00,.4777E+00,.9044E+00,.5633E+00,.4787E+00,.5555E+00,.4164E+00,.4215E+00,.3601E+00,.8392E+00,&
 .3074E+00,.5040E+00,.9500E+00,.5810E+00,.4762E+00,.5476E+00,.4138E+00,.4323E+00,.3656E+00,.8800E+00,&
 .3225E+00,.5301E+00,.9955E+00,.5988E+00,.4743E+00,.5406E+00,.4119E+00,.4433E+00,.3717E+00,.9208E+00,&
 .3407E+00,.5615E+00,.1050E+01,.6200E+00,.4715E+00,.5318E+00,.4095E+00,.4565E+00,.3790E+00,.9696E+00,&
 .3647E+00,.6029E+00,.1122E+01,.6478E+00,.4673E+00,.5196E+00,.4061E+00,.4737E+00,.3885E+00,.1034E+01,&
 .3910E+00,.6484E+00,.1201E+01,.6785E+00,.4635E+00,.5077E+00,.4032E+00,.4931E+00,.3999E+00,.1105E+01,&
 .4247E+00,.7066E+00,.1303E+01,.7180E+00,.4593E+00,.4934E+00,.4006E+00,.5185E+00,.4155E+00,.1196E+01,&
 .4744E+00,.7923E+00,.1452E+01,.7771E+00,.4550E+00,.4755E+00,.3989E+00,.5567E+00,.4407E+00,.1330E+01,&
 .5577E+00,.9357E+00,.1703E+01,.8795E+00,.4557E+00,.4561E+00,.4035E+00,.6251E+00,.4905E+00,.1556E+01/
 data (((Bex_lw(ai,k,nh),ai= 2, 2),k=1,nwl_lw),nh=0,99)/ &
 .9514E-01,.1469E+00,.2331E+00,.3161E+00,.3718E+00,.4177E+00,.4740E+00,.6076E+00,.9329E+00,.1995E+00,&
 .9518E-01,.1469E+00,.2332E+00,.3162E+00,.3719E+00,.4178E+00,.4741E+00,.6078E+00,.9333E+00,.1995E+00,&
 .9521E-01,.1470E+00,.2333E+00,.3163E+00,.3721E+00,.4180E+00,.4743E+00,.6081E+00,.9336E+00,.1996E+00,&
 .9525E-01,.1470E+00,.2334E+00,.3164E+00,.3722E+00,.4181E+00,.4745E+00,.6083E+00,.9340E+00,.1997E+00,&
 .9528E-01,.1471E+00,.2335E+00,.3165E+00,.3724E+00,.4183E+00,.4747E+00,.6085E+00,.9344E+00,.1998E+00,&
 .9532E-01,.1471E+00,.2335E+00,.3167E+00,.3725E+00,.4184E+00,.4748E+00,.6088E+00,.9347E+00,.1999E+00,&
 .9535E-01,.1472E+00,.2336E+00,.3168E+00,.3726E+00,.4186E+00,.4750E+00,.6090E+00,.9350E+00,.1999E+00,&
 .9538E-01,.1472E+00,.2337E+00,.3169E+00,.3727E+00,.4187E+00,.4751E+00,.6092E+00,.9354E+00,.2000E+00,&
 .9541E-01,.1473E+00,.2337E+00,.3170E+00,.3728E+00,.4188E+00,.4753E+00,.6094E+00,.9357E+00,.2000E+00,&
 .9544E-01,.1473E+00,.2338E+00,.3170E+00,.3730E+00,.4190E+00,.4754E+00,.6096E+00,.9360E+00,.2001E+00,&
 .9547E-01,.1473E+00,.2339E+00,.3171E+00,.3731E+00,.4191E+00,.4756E+00,.6098E+00,.9364E+00,.2001E+00,&
 .9550E-01,.1474E+00,.2339E+00,.3172E+00,.3732E+00,.4192E+00,.4757E+00,.6099E+00,.9367E+00,.2002E+00,&
 .9552E-01,.1474E+00,.2340E+00,.3173E+00,.3733E+00,.4193E+00,.4758E+00,.6101E+00,.9370E+00,.2002E+00,&
 .9554E-01,.1475E+00,.2341E+00,.3174E+00,.3734E+00,.4194E+00,.4760E+00,.6103E+00,.9373E+00,.2003E+00,&
 .9556E-01,.1475E+00,.2341E+00,.3175E+00,.3735E+00,.4195E+00,.4761E+00,.6104E+00,.9376E+00,.2003E+00,&
 .9558E-01,.1476E+00,.2342E+00,.3175E+00,.3736E+00,.4197E+00,.4762E+00,.6106E+00,.9379E+00,.2004E+00,&
 .9561E-01,.1476E+00,.2342E+00,.3176E+00,.3737E+00,.4198E+00,.4764E+00,.6107E+00,.9381E+00,.2004E+00,&
 .9564E-01,.1476E+00,.2343E+00,.3177E+00,.3738E+00,.4199E+00,.4765E+00,.6109E+00,.9383E+00,.2005E+00,&
 .9566E-01,.1477E+00,.2344E+00,.3178E+00,.3739E+00,.4199E+00,.4766E+00,.6110E+00,.9385E+00,.2005E+00,&
 .9569E-01,.1477E+00,.2344E+00,.3179E+00,.3739E+00,.4200E+00,.4767E+00,.6112E+00,.9387E+00,.2006E+00,&
 .9571E-01,.1477E+00,.2345E+00,.3179E+00,.3740E+00,.4201E+00,.4768E+00,.6113E+00,.9389E+00,.2006E+00,&
 .9573E-01,.1477E+00,.2345E+00,.3180E+00,.3741E+00,.4202E+00,.4769E+00,.6114E+00,.9392E+00,.2007E+00,&
 .9575E-01,.1478E+00,.2346E+00,.3181E+00,.3742E+00,.4203E+00,.4770E+00,.6116E+00,.9394E+00,.2007E+00,&
 .9577E-01,.1478E+00,.2346E+00,.3181E+00,.3742E+00,.4204E+00,.4770E+00,.6117E+00,.9396E+00,.2007E+00,&
 .9578E-01,.1478E+00,.2346E+00,.3182E+00,.3743E+00,.4205E+00,.4771E+00,.6118E+00,.9399E+00,.2008E+00,&
 .9580E-01,.1478E+00,.2347E+00,.3182E+00,.3744E+00,.4205E+00,.4772E+00,.6119E+00,.9401E+00,.2008E+00,&
 .9582E-01,.1479E+00,.2347E+00,.3183E+00,.3744E+00,.4206E+00,.4773E+00,.6120E+00,.9403E+00,.2008E+00,&
 .9583E-01,.1479E+00,.2348E+00,.3183E+00,.3745E+00,.4207E+00,.4774E+00,.6121E+00,.9404E+00,.2009E+00,&
 .9585E-01,.1479E+00,.2348E+00,.3184E+00,.3746E+00,.4207E+00,.4775E+00,.6122E+00,.9406E+00,.2009E+00,&
 .9587E-01,.1479E+00,.2348E+00,.3184E+00,.3746E+00,.4208E+00,.4775E+00,.6124E+00,.9408E+00,.2009E+00,&
 .9588E-01,.1480E+00,.2349E+00,.3185E+00,.3747E+00,.4209E+00,.4776E+00,.6125E+00,.9410E+00,.2010E+00,&
 .9589E-01,.1480E+00,.2349E+00,.3185E+00,.3747E+00,.4209E+00,.4777E+00,.6125E+00,.9411E+00,.2010E+00,&
 .9590E-01,.1480E+00,.2349E+00,.3186E+00,.3748E+00,.4210E+00,.4778E+00,.6126E+00,.9413E+00,.2010E+00,&
 .9591E-01,.1480E+00,.2350E+00,.3186E+00,.3748E+00,.4211E+00,.4778E+00,.6127E+00,.9414E+00,.2011E+00,&
 .9592E-01,.1480E+00,.2350E+00,.3187E+00,.3749E+00,.4211E+00,.4779E+00,.6128E+00,.9416E+00,.2011E+00,&
 .9592E-01,.1481E+00,.2351E+00,.3187E+00,.3750E+00,.4212E+00,.4780E+00,.6129E+00,.9418E+00,.2011E+00,&
 .9594E-01,.1481E+00,.2351E+00,.3188E+00,.3750E+00,.4212E+00,.4780E+00,.6130E+00,.9419E+00,.2011E+00,&
 .9595E-01,.1481E+00,.2351E+00,.3188E+00,.3750E+00,.4213E+00,.4781E+00,.6131E+00,.9420E+00,.2012E+00,&
 .9597E-01,.1481E+00,.2351E+00,.3188E+00,.3751E+00,.4213E+00,.4781E+00,.6132E+00,.9421E+00,.2012E+00,&
 .9598E-01,.1482E+00,.2352E+00,.3189E+00,.3751E+00,.4214E+00,.4782E+00,.6133E+00,.9423E+00,.2012E+00,&
 .9599E-01,.1482E+00,.2352E+00,.3189E+00,.3752E+00,.4214E+00,.4782E+00,.6133E+00,.9424E+00,.2012E+00,&
 .9600E-01,.1482E+00,.2352E+00,.3189E+00,.3752E+00,.4215E+00,.4783E+00,.6134E+00,.9425E+00,.2013E+00,&
 .9601E-01,.1482E+00,.2352E+00,.3190E+00,.3752E+00,.4215E+00,.4784E+00,.6135E+00,.9426E+00,.2013E+00,&
 .9601E-01,.1482E+00,.2353E+00,.3190E+00,.3753E+00,.4216E+00,.4784E+00,.6135E+00,.9427E+00,.2013E+00,&
 .9602E-01,.1482E+00,.2353E+00,.3190E+00,.3753E+00,.4216E+00,.4785E+00,.6136E+00,.9427E+00,.2013E+00,&
 .9603E-01,.1482E+00,.2353E+00,.3190E+00,.3754E+00,.4216E+00,.4785E+00,.6137E+00,.9428E+00,.2013E+00,&
 .9604E-01,.1482E+00,.2353E+00,.3191E+00,.3754E+00,.4217E+00,.4786E+00,.6137E+00,.9430E+00,.2014E+00,&
 .9605E-01,.1483E+00,.2354E+00,.3191E+00,.3754E+00,.4217E+00,.4786E+00,.6138E+00,.9431E+00,.2014E+00,&
 .9606E-01,.1483E+00,.2354E+00,.3192E+00,.3755E+00,.4218E+00,.4787E+00,.6138E+00,.9432E+00,.2014E+00,&
 .9607E-01,.1483E+00,.2354E+00,.3192E+00,.3755E+00,.4218E+00,.4787E+00,.6139E+00,.9434E+00,.2014E+00,&
 .9608E-01,.1483E+00,.2354E+00,.3192E+00,.3755E+00,.4219E+00,.4788E+00,.6140E+00,.9435E+00,.2014E+00,&
 .9609E-01,.1483E+00,.2354E+00,.3193E+00,.3756E+00,.4219E+00,.4788E+00,.6140E+00,.9436E+00,.2015E+00,&
 .9609E-01,.1483E+00,.2354E+00,.3193E+00,.3756E+00,.4219E+00,.4788E+00,.6141E+00,.9437E+00,.2015E+00,&
 .9610E-01,.1483E+00,.2355E+00,.3193E+00,.3757E+00,.4220E+00,.4789E+00,.6141E+00,.9438E+00,.2015E+00,&
 .9610E-01,.1483E+00,.2355E+00,.3193E+00,.3757E+00,.4220E+00,.4789E+00,.6142E+00,.9439E+00,.2015E+00,&
 .9610E-01,.1484E+00,.2355E+00,.3193E+00,.3757E+00,.4220E+00,.4790E+00,.6142E+00,.9440E+00,.2015E+00,&
 .9677E-01,.1494E+00,.2373E+00,.3213E+00,.3776E+00,.4240E+00,.4810E+00,.6167E+00,.9467E+00,.2030E+00,&
 .9744E-01,.1504E+00,.2390E+00,.3233E+00,.3796E+00,.4260E+00,.4831E+00,.6191E+00,.9495E+00,.2045E+00,&
 .9812E-01,.1514E+00,.2408E+00,.3253E+00,.3815E+00,.4280E+00,.4851E+00,.6215E+00,.9523E+00,.2059E+00,&
 .9879E-01,.1524E+00,.2425E+00,.3272E+00,.3834E+00,.4300E+00,.4872E+00,.6239E+00,.9551E+00,.2074E+00,&
 .9946E-01,.1534E+00,.2443E+00,.3292E+00,.3853E+00,.4319E+00,.4892E+00,.6264E+00,.9579E+00,.2089E+00,&
 .9947E-01,.1535E+00,.2443E+00,.3292E+00,.3853E+00,.4320E+00,.4893E+00,.6264E+00,.9579E+00,.2089E+00,&
 .9948E-01,.1535E+00,.2443E+00,.3292E+00,.3853E+00,.4320E+00,.4893E+00,.6265E+00,.9580E+00,.2089E+00,&
 .9949E-01,.1535E+00,.2443E+00,.3293E+00,.3854E+00,.4320E+00,.4894E+00,.6265E+00,.9580E+00,.2089E+00,&
 .9950E-01,.1535E+00,.2443E+00,.3293E+00,.3854E+00,.4321E+00,.4894E+00,.6265E+00,.9581E+00,.2089E+00,&
 .9951E-01,.1535E+00,.2443E+00,.3293E+00,.3854E+00,.4321E+00,.4894E+00,.6266E+00,.9581E+00,.2089E+00,&
 .1016E+00,.1566E+00,.2498E+00,.3352E+00,.3910E+00,.4379E+00,.4954E+00,.6336E+00,.9659E+00,.2135E+00,&
 .1036E+00,.1598E+00,.2552E+00,.3411E+00,.3966E+00,.4436E+00,.5013E+00,.6406E+00,.9737E+00,.2181E+00,&
 .1056E+00,.1629E+00,.2606E+00,.3470E+00,.4022E+00,.4494E+00,.5073E+00,.6476E+00,.9815E+00,.2226E+00,&
 .1077E+00,.1660E+00,.2660E+00,.3528E+00,.4078E+00,.4552E+00,.5132E+00,.6547E+00,.9893E+00,.2272E+00,&
 .1097E+00,.1691E+00,.2714E+00,.3587E+00,.4134E+00,.4609E+00,.5192E+00,.6617E+00,.9971E+00,.2318E+00,&
 .1156E+00,.1780E+00,.2871E+00,.3745E+00,.4276E+00,.4753E+00,.5338E+00,.6790E+00,.1015E+01,.2450E+00,&
 .1214E+00,.1870E+00,.3027E+00,.3902E+00,.4418E+00,.4896E+00,.5484E+00,.6963E+00,.1033E+01,.2583E+00,&
 .1272E+00,.1959E+00,.3183E+00,.4060E+00,.4560E+00,.5040E+00,.5630E+00,.7136E+00,.1052E+01,.2715E+00,&
 .1330E+00,.2048E+00,.3340E+00,.4217E+00,.4702E+00,.5183E+00,.5776E+00,.7309E+00,.1070E+01,.2848E+00,&
 .1389E+00,.2137E+00,.3496E+00,.4375E+00,.4843E+00,.5327E+00,.5922E+00,.7482E+00,.1088E+01,.2980E+00,&
 .1469E+00,.2261E+00,.3716E+00,.4570E+00,.5003E+00,.5485E+00,.6081E+00,.7674E+00,.1106E+01,.3168E+00,&
 .1549E+00,.2385E+00,.3936E+00,.4766E+00,.5163E+00,.5643E+00,.6240E+00,.7865E+00,.1125E+01,.3356E+00,&
 .1628E+00,.2508E+00,.4155E+00,.4961E+00,.5322E+00,.5802E+00,.6399E+00,.8057E+00,.1143E+01,.3544E+00,&
 .1708E+00,.2632E+00,.4375E+00,.5156E+00,.5482E+00,.5960E+00,.6558E+00,.8249E+00,.1162E+01,.3732E+00,&
 .1788E+00,.2756E+00,.4595E+00,.5351E+00,.5642E+00,.6118E+00,.6717E+00,.8441E+00,.1180E+01,.3920E+00,&
 .1915E+00,.2955E+00,.4950E+00,.5642E+00,.5863E+00,.6335E+00,.6933E+00,.8707E+00,.1204E+01,.4226E+00,&
 .2002E+00,.3090E+00,.5193E+00,.5834E+00,.6006E+00,.6474E+00,.7072E+00,.8879E+00,.1219E+01,.4436E+00,&
 .2134E+00,.3299E+00,.5568E+00,.6122E+00,.6214E+00,.6677E+00,.7273E+00,.9132E+00,.1241E+01,.4760E+00,&
 .2225E+00,.3443E+00,.5824E+00,.6313E+00,.6350E+00,.6808E+00,.7402E+00,.9296E+00,.1255E+01,.4984E+00,&
 .2364E+00,.3662E+00,.6219E+00,.6600E+00,.6547E+00,.6998E+00,.7590E+00,.9537E+00,.1274E+01,.5328E+00,&
 .2506E+00,.3888E+00,.6626E+00,.6887E+00,.6738E+00,.7181E+00,.7771E+00,.9775E+00,.1293E+01,.5683E+00,&
 .2603E+00,.4043E+00,.6904E+00,.7078E+00,.6863E+00,.7300E+00,.7889E+00,.9929E+00,.1305E+01,.5927E+00,&
 .2751E+00,.4280E+00,.7332E+00,.7365E+00,.7045E+00,.7474E+00,.8060E+00,.1016E+01,.1322E+01,.6302E+00,&
 .2852E+00,.4443E+00,.7625E+00,.7557E+00,.7165E+00,.7588E+00,.8172E+00,.1031E+01,.1333E+01,.6560E+00,&
 .3007E+00,.4692E+00,.8074E+00,.7846E+00,.7340E+00,.7754E+00,.8335E+00,.1053E+01,.1349E+01,.6956E+00,&
 .3165E+00,.4949E+00,.8536E+00,.8137E+00,.7512E+00,.7916E+00,.8495E+00,.1076E+01,.1364E+01,.7365E+00,&
 .3328E+00,.5213E+00,.9012E+00,.8429E+00,.7681E+00,.8075E+00,.8651E+00,.1098E+01,.1379E+01,.7786E+00,&
 .3495E+00,.5484E+00,.9503E+00,.8724E+00,.7847E+00,.8231E+00,.8805E+00,.1120E+01,.1393E+01,.8221E+00,&
 .3725E+00,.5858E+00,.1018E+01,.9123E+00,.8065E+00,.8434E+00,.9004E+00,.1149E+01,.1412E+01,.8821E+00,&
 .3962E+00,.6246E+00,.1088E+01,.9527E+00,.8280E+00,.8634E+00,.9201E+00,.1178E+01,.1429E+01,.9445E+00,&
 .4270E+00,.6751E+00,.1179E+01,.1004E+01,.8546E+00,.8880E+00,.9443E+00,.1215E+01,.1451E+01,.1026E+01,&
 .4722E+00,.7496E+00,.1313E+01,.1078E+01,.8915E+00,.9219E+00,.9776E+00,.1267E+01,.1479E+01,.1146E+01,&
 .5273E+00,.8407E+00,.1477E+01,.1167E+01,.9337E+00,.9605E+00,.1016E+01,.1327E+01,.1511E+01,.1294E+01,&
 .6812E+00,.1097E+01,.1939E+01,.1406E+01,.1042E+01,.1058E+01,.1111E+01,.1488E+01,.1588E+01,.1710E+01/
 data (((Bex_lw(ai,k,nh),ai= 3, 3),k=1,nwl_lw),nh=0,99)/ &
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01/
 data (((Bex_lw(ai,k,nh),ai= 4, 4),k=1,nwl_lw),nh=0,99)/ &
 .4255E-01,.3839E-01,.3750E-01,.2284E-01,.6699E-01,.1081E+00,.5913E-01,.2771E-01,.1284E-01,.4138E-01,&
 .4334E-01,.3951E-01,.3943E-01,.2379E-01,.6799E-01,.1091E+00,.5958E-01,.2844E-01,.1315E-01,.4306E-01,&
 .4413E-01,.4063E-01,.4135E-01,.2474E-01,.6898E-01,.1102E+00,.6002E-01,.2916E-01,.1346E-01,.4475E-01,&
 .4492E-01,.4174E-01,.4327E-01,.2569E-01,.6998E-01,.1113E+00,.6046E-01,.2989E-01,.1377E-01,.4644E-01,&
 .4572E-01,.4286E-01,.4520E-01,.2664E-01,.7098E-01,.1124E+00,.6091E-01,.3061E-01,.1407E-01,.4813E-01,&
 .4651E-01,.4398E-01,.4712E-01,.2759E-01,.7198E-01,.1134E+00,.6135E-01,.3133E-01,.1438E-01,.4982E-01,&
 .4734E-01,.4518E-01,.4920E-01,.2861E-01,.7299E-01,.1145E+00,.6182E-01,.3210E-01,.1471E-01,.5165E-01,&
 .4818E-01,.4639E-01,.5128E-01,.2964E-01,.7400E-01,.1156E+00,.6229E-01,.3287E-01,.1505E-01,.5348E-01,&
 .4901E-01,.4759E-01,.5336E-01,.3067E-01,.7502E-01,.1167E+00,.6275E-01,.3364E-01,.1538E-01,.5532E-01,&
 .4985E-01,.4879E-01,.5545E-01,.3170E-01,.7603E-01,.1178E+00,.6322E-01,.3441E-01,.1571E-01,.5715E-01,&
 .5069E-01,.4999E-01,.5753E-01,.3273E-01,.7705E-01,.1189E+00,.6369E-01,.3518E-01,.1604E-01,.5899E-01,&
 .5157E-01,.5128E-01,.5977E-01,.3384E-01,.7807E-01,.1200E+00,.6418E-01,.3599E-01,.1640E-01,.6096E-01,&
 .5245E-01,.5257E-01,.6201E-01,.3495E-01,.7910E-01,.1211E+00,.6467E-01,.3680E-01,.1675E-01,.6294E-01,&
 .5333E-01,.5386E-01,.6425E-01,.3606E-01,.8012E-01,.1223E+00,.6516E-01,.3762E-01,.1711E-01,.6492E-01,&
 .5421E-01,.5514E-01,.6649E-01,.3717E-01,.8115E-01,.1234E+00,.6565E-01,.3843E-01,.1746E-01,.6690E-01,&
 .5509E-01,.5643E-01,.6873E-01,.3828E-01,.8217E-01,.1245E+00,.6614E-01,.3924E-01,.1782E-01,.6888E-01,&
 .5602E-01,.5781E-01,.7113E-01,.3947E-01,.8321E-01,.1256E+00,.6666E-01,.4010E-01,.1820E-01,.7101E-01,&
 .5695E-01,.5918E-01,.7353E-01,.4066E-01,.8425E-01,.1267E+00,.6717E-01,.4097E-01,.1858E-01,.7314E-01,&
 .5787E-01,.6056E-01,.7593E-01,.4185E-01,.8528E-01,.1279E+00,.6769E-01,.4183E-01,.1897E-01,.7526E-01,&
 .5880E-01,.6193E-01,.7834E-01,.4304E-01,.8632E-01,.1290E+00,.6820E-01,.4269E-01,.1935E-01,.7739E-01,&
 .5973E-01,.6331E-01,.8074E-01,.4424E-01,.8736E-01,.1301E+00,.6872E-01,.4355E-01,.1973E-01,.7952E-01,&
 .6070E-01,.6477E-01,.8330E-01,.4551E-01,.8841E-01,.1313E+00,.6926E-01,.4446E-01,.2014E-01,.8180E-01,&
 .6168E-01,.6623E-01,.8586E-01,.4678E-01,.8947E-01,.1324E+00,.6980E-01,.4537E-01,.2055E-01,.8407E-01,&
 .6265E-01,.6769E-01,.8843E-01,.4805E-01,.9052E-01,.1336E+00,.7034E-01,.4628E-01,.2096E-01,.8635E-01,&
 .6362E-01,.6916E-01,.9099E-01,.4932E-01,.9157E-01,.1347E+00,.7088E-01,.4719E-01,.2137E-01,.8863E-01,&
 .6460E-01,.7062E-01,.9355E-01,.5059E-01,.9262E-01,.1358E+00,.7142E-01,.4809E-01,.2178E-01,.9091E-01,&
 .6562E-01,.7217E-01,.9628E-01,.5195E-01,.9369E-01,.1370E+00,.7198E-01,.4905E-01,.2222E-01,.9334E-01,&
 .6664E-01,.7372E-01,.9901E-01,.5331E-01,.9475E-01,.1382E+00,.7255E-01,.5001E-01,.2266E-01,.9577E-01,&
 .6766E-01,.7528E-01,.1017E+00,.5466E-01,.9581E-01,.1393E+00,.7311E-01,.5097E-01,.2310E-01,.9820E-01,&
 .6869E-01,.7683E-01,.1045E+00,.5602E-01,.9687E-01,.1405E+00,.7368E-01,.5193E-01,.2354E-01,.1006E+00,&
 .6971E-01,.7838E-01,.1072E+00,.5737E-01,.9793E-01,.1416E+00,.7424E-01,.5289E-01,.2398E-01,.1031E+00,&
 .7078E-01,.8002E-01,.1101E+00,.5881E-01,.9901E-01,.1428E+00,.7483E-01,.5390E-01,.2445E-01,.1057E+00,&
 .7185E-01,.8167E-01,.1130E+00,.6025E-01,.1001E+00,.1440E+00,.7543E-01,.5491E-01,.2492E-01,.1082E+00,&
 .7292E-01,.8331E-01,.1159E+00,.6169E-01,.1012E+00,.1451E+00,.7602E-01,.5592E-01,.2539E-01,.1108E+00,&
 .7399E-01,.8496E-01,.1188E+00,.6313E-01,.1022E+00,.1463E+00,.7661E-01,.5693E-01,.2586E-01,.1134E+00,&
 .7507E-01,.8660E-01,.1217E+00,.6456E-01,.1033E+00,.1475E+00,.7721E-01,.5794E-01,.2633E-01,.1160E+00,&
 .7619E-01,.8833E-01,.1248E+00,.6608E-01,.1044E+00,.1486E+00,.7782E-01,.5900E-01,.2683E-01,.1187E+00,&
 .7731E-01,.9007E-01,.1278E+00,.6761E-01,.1055E+00,.1498E+00,.7844E-01,.6006E-01,.2734E-01,.1215E+00,&
 .7843E-01,.9180E-01,.1309E+00,.6913E-01,.1066E+00,.1510E+00,.7906E-01,.6112E-01,.2784E-01,.1242E+00,&
 .7955E-01,.9353E-01,.1340E+00,.7065E-01,.1077E+00,.1522E+00,.7968E-01,.6218E-01,.2834E-01,.1269E+00,&
 .8067E-01,.9527E-01,.1370E+00,.7217E-01,.1088E+00,.1534E+00,.8030E-01,.6324E-01,.2885E-01,.1297E+00,&
 .8185E-01,.9710E-01,.1402E+00,.7378E-01,.1099E+00,.1546E+00,.8095E-01,.6435E-01,.2939E-01,.1326E+00,&
 .8302E-01,.9893E-01,.1435E+00,.7538E-01,.1110E+00,.1558E+00,.8159E-01,.6547E-01,.2992E-01,.1355E+00,&
 .8419E-01,.1008E+00,.1467E+00,.7699E-01,.1121E+00,.1569E+00,.8223E-01,.6658E-01,.3046E-01,.1384E+00,&
 .8537E-01,.1026E+00,.1500E+00,.7860E-01,.1132E+00,.1581E+00,.8288E-01,.6770E-01,.3100E-01,.1412E+00,&
 .8654E-01,.1044E+00,.1532E+00,.8020E-01,.1143E+00,.1593E+00,.8352E-01,.6881E-01,.3154E-01,.1441E+00,&
 .8777E-01,.1063E+00,.1566E+00,.8190E-01,.1154E+00,.1605E+00,.8420E-01,.6998E-01,.3211E-01,.1472E+00,&
 .8899E-01,.1083E+00,.1600E+00,.8359E-01,.1165E+00,.1617E+00,.8487E-01,.7116E-01,.3269E-01,.1503E+00,&
 .9022E-01,.1102E+00,.1634E+00,.8528E-01,.1176E+00,.1629E+00,.8554E-01,.7233E-01,.3326E-01,.1533E+00,&
 .9145E-01,.1121E+00,.1668E+00,.8698E-01,.1188E+00,.1641E+00,.8621E-01,.7350E-01,.3384E-01,.1564E+00,&
 .9267E-01,.1140E+00,.1703E+00,.8867E-01,.1199E+00,.1653E+00,.8689E-01,.7467E-01,.3441E-01,.1595E+00,&
 .9415E-01,.1164E+00,.1745E+00,.9075E-01,.1212E+00,.1667E+00,.8767E-01,.7609E-01,.3511E-01,.1633E+00,&
 .9563E-01,.1188E+00,.1787E+00,.9283E-01,.1224E+00,.1680E+00,.8846E-01,.7751E-01,.3581E-01,.1670E+00,&
 .9710E-01,.1211E+00,.1829E+00,.9491E-01,.1237E+00,.1694E+00,.8925E-01,.7892E-01,.3650E-01,.1708E+00,&
 .9858E-01,.1235E+00,.1871E+00,.9699E-01,.1250E+00,.1707E+00,.9004E-01,.8034E-01,.3720E-01,.1745E+00,&
 .1001E+00,.1258E+00,.1913E+00,.9907E-01,.1263E+00,.1721E+00,.9082E-01,.8176E-01,.3789E-01,.1783E+00,&
 .1016E+00,.1283E+00,.1957E+00,.1013E+00,.1276E+00,.1734E+00,.9165E-01,.8325E-01,.3864E-01,.1823E+00,&
 .1031E+00,.1308E+00,.2001E+00,.1035E+00,.1289E+00,.1748E+00,.9247E-01,.8474E-01,.3939E-01,.1863E+00,&
 .1047E+00,.1333E+00,.2046E+00,.1057E+00,.1302E+00,.1761E+00,.9329E-01,.8623E-01,.4014E-01,.1903E+00,&
 .1062E+00,.1357E+00,.2090E+00,.1079E+00,.1315E+00,.1775E+00,.9412E-01,.8773E-01,.4089E-01,.1943E+00,&
 .1078E+00,.1382E+00,.2134E+00,.1101E+00,.1327E+00,.1788E+00,.9494E-01,.8922E-01,.4164E-01,.1982E+00,&
 .1092E+00,.1405E+00,.2175E+00,.1121E+00,.1340E+00,.1801E+00,.9575E-01,.9062E-01,.4237E-01,.2019E+00,&
 .1107E+00,.1428E+00,.2216E+00,.1141E+00,.1352E+00,.1815E+00,.9657E-01,.9201E-01,.4309E-01,.2056E+00,&
 .1121E+00,.1452E+00,.2258E+00,.1162E+00,.1365E+00,.1828E+00,.9738E-01,.9341E-01,.4382E-01,.2093E+00,&
 .1136E+00,.1475E+00,.2299E+00,.1182E+00,.1377E+00,.1841E+00,.9819E-01,.9481E-01,.4455E-01,.2130E+00,&
 .1150E+00,.1498E+00,.2340E+00,.1202E+00,.1389E+00,.1854E+00,.9901E-01,.9621E-01,.4528E-01,.2167E+00,&
 .1167E+00,.1525E+00,.2388E+00,.1226E+00,.1403E+00,.1868E+00,.9991E-01,.9785E-01,.4614E-01,.2211E+00,&
 .1184E+00,.1552E+00,.2437E+00,.1251E+00,.1416E+00,.1882E+00,.1008E+00,.9949E-01,.4699E-01,.2255E+00,&
 .1201E+00,.1580E+00,.2486E+00,.1275E+00,.1430E+00,.1896E+00,.1017E+00,.1011E+00,.4785E-01,.2299E+00,&
 .1218E+00,.1607E+00,.2535E+00,.1299E+00,.1443E+00,.1910E+00,.1026E+00,.1028E+00,.4870E-01,.2343E+00,&
 .1235E+00,.1634E+00,.2584E+00,.1323E+00,.1457E+00,.1923E+00,.1035E+00,.1044E+00,.4956E-01,.2387E+00,&
 .1260E+00,.1676E+00,.2659E+00,.1360E+00,.1476E+00,.1942E+00,.1048E+00,.1069E+00,.5083E-01,.2455E+00,&
 .1285E+00,.1717E+00,.2734E+00,.1397E+00,.1495E+00,.1961E+00,.1061E+00,.1094E+00,.5210E-01,.2522E+00,&
 .1311E+00,.1759E+00,.2809E+00,.1434E+00,.1514E+00,.1980E+00,.1074E+00,.1118E+00,.5337E-01,.2590E+00,&
 .1336E+00,.1801E+00,.2884E+00,.1471E+00,.1533E+00,.1999E+00,.1088E+00,.1143E+00,.5464E-01,.2657E+00,&
 .1361E+00,.1843E+00,.2959E+00,.1508E+00,.1552E+00,.2018E+00,.1101E+00,.1168E+00,.5591E-01,.2725E+00,&
 .1396E+00,.1900E+00,.3063E+00,.1559E+00,.1577E+00,.2042E+00,.1118E+00,.1202E+00,.5767E-01,.2819E+00,&
 .1431E+00,.1958E+00,.3168E+00,.1611E+00,.1601E+00,.2066E+00,.1136E+00,.1236E+00,.5943E-01,.2913E+00,&
 .1466E+00,.2016E+00,.3272E+00,.1662E+00,.1626E+00,.2089E+00,.1154E+00,.1271E+00,.6119E-01,.3007E+00,&
 .1501E+00,.2074E+00,.3376E+00,.1714E+00,.1650E+00,.2113E+00,.1172E+00,.1305E+00,.6296E-01,.3102E+00,&
 .1535E+00,.2132E+00,.3481E+00,.1765E+00,.1675E+00,.2137E+00,.1189E+00,.1339E+00,.6472E-01,.3196E+00,&
 .1580E+00,.2206E+00,.3615E+00,.1831E+00,.1705E+00,.2165E+00,.1212E+00,.1383E+00,.6697E-01,.3317E+00,&
 .1624E+00,.2281E+00,.3751E+00,.1898E+00,.1736E+00,.2193E+00,.1235E+00,.1427E+00,.6928E-01,.3440E+00,&
 .1670E+00,.2358E+00,.3890E+00,.1966E+00,.1766E+00,.2222E+00,.1258E+00,.1472E+00,.7165E-01,.3566E+00,&
 .1717E+00,.2436E+00,.4032E+00,.2036E+00,.1797E+00,.2251E+00,.1281E+00,.1518E+00,.7407E-01,.3693E+00,&
 .1778E+00,.2539E+00,.4219E+00,.2128E+00,.1837E+00,.2287E+00,.1312E+00,.1579E+00,.7725E-01,.3863E+00,&
 .1841E+00,.2645E+00,.4410E+00,.2221E+00,.1877E+00,.2324E+00,.1343E+00,.1641E+00,.8051E-01,.4036E+00,&
 .1919E+00,.2777E+00,.4651E+00,.2339E+00,.1926E+00,.2368E+00,.1382E+00,.1718E+00,.8457E-01,.4253E+00,&
 .1999E+00,.2913E+00,.4897E+00,.2460E+00,.1976E+00,.2412E+00,.1422E+00,.1798E+00,.8879E-01,.4476E+00,&
 .2096E+00,.3077E+00,.5195E+00,.2606E+00,.2035E+00,.2464E+00,.1470E+00,.1894E+00,.9389E-01,.4746E+00,&
 .2194E+00,.3245E+00,.5501E+00,.2756E+00,.2095E+00,.2516E+00,.1520E+00,.1993E+00,.9917E-01,.5022E+00,&
 .2311E+00,.3445E+00,.5862E+00,.2933E+00,.2164E+00,.2576E+00,.1577E+00,.2109E+00,.1054E+00,.5350E+00,&
 .2446E+00,.3676E+00,.6284E+00,.3139E+00,.2244E+00,.2644E+00,.1646E+00,.2245E+00,.1128E+00,.5732E+00,&
 .2619E+00,.3971E+00,.6820E+00,.3401E+00,.2343E+00,.2727E+00,.1731E+00,.2417E+00,.1222E+00,.6218E+00,&
 .2813E+00,.4303E+00,.7424E+00,.3696E+00,.2454E+00,.2819E+00,.1828E+00,.2611E+00,.1329E+00,.6766E+00,&
 .3081E+00,.4765E+00,.8264E+00,.4106E+00,.2604E+00,.2943E+00,.1962E+00,.2881E+00,.1480E+00,.7528E+00,&
 .3431E+00,.5366E+00,.9357E+00,.4639E+00,.2797E+00,.3101E+00,.2137E+00,.3233E+00,.1679E+00,.8521E+00,&
 .3848E+00,.6084E+00,.1066E+01,.5275E+00,.3026E+00,.3286E+00,.2347E+00,.3654E+00,.1922E+00,.9706E+00,&
 .4548E+00,.7287E+00,.1285E+01,.6341E+00,.3407E+00,.3592E+00,.2700E+00,.4362E+00,.2340E+00,.1170E+01,&
 .5711E+00,.9289E+00,.1649E+01,.8114E+00,.4040E+00,.4102E+00,.3293E+00,.5544E+00,.3062E+00,.1500E+01/
 data (((Bex_lw(ai,k,nh),ai= 5, 5),k=1,nwl_lw),nh=0,99)/ &
 .5506E-01,.3918E-01,.2796E-01,.3351E-01,.6595E-01,.8195E-01,.6205E-01,.1181E+00,.2768E+00,.4168E-01,&
 .5707E-01,.4229E-01,.3309E-01,.3612E-01,.6796E-01,.8445E-01,.6504E-01,.1233E+00,.2868E+00,.4650E-01,&
 .5908E-01,.4539E-01,.3821E-01,.3872E-01,.6998E-01,.8695E-01,.6803E-01,.1285E+00,.2968E+00,.5133E-01,&
 .6109E-01,.4849E-01,.4334E-01,.4133E-01,.7199E-01,.8944E-01,.7102E-01,.1336E+00,.3068E+00,.5616E-01,&
 .6311E-01,.5160E-01,.4847E-01,.4393E-01,.7400E-01,.9194E-01,.7401E-01,.1388E+00,.3167E+00,.6099E-01,&
 .6512E-01,.5470E-01,.5360E-01,.4654E-01,.7601E-01,.9444E-01,.7700E-01,.1440E+00,.3267E+00,.6582E-01,&
 .6733E-01,.5826E-01,.5943E-01,.4954E-01,.7832E-01,.9730E-01,.8045E-01,.1499E+00,.3380E+00,.7138E-01,&
 .6954E-01,.6183E-01,.6527E-01,.5253E-01,.8062E-01,.1002E+00,.8391E-01,.1559E+00,.3493E+00,.7693E-01,&
 .7176E-01,.6540E-01,.7111E-01,.5553E-01,.8292E-01,.1030E+00,.8736E-01,.1618E+00,.3606E+00,.8249E-01,&
 .7397E-01,.6896E-01,.7695E-01,.5852E-01,.8522E-01,.1059E+00,.9081E-01,.1677E+00,.3719E+00,.8805E-01,&
 .7618E-01,.7253E-01,.8279E-01,.6152E-01,.8753E-01,.1087E+00,.9426E-01,.1737E+00,.3833E+00,.9361E-01,&
 .7864E-01,.7662E-01,.8941E-01,.6493E-01,.9016E-01,.1120E+00,.9826E-01,.1805E+00,.3962E+00,.9996E-01,&
 .8109E-01,.8070E-01,.9604E-01,.6835E-01,.9278E-01,.1153E+00,.1023E+00,.1873E+00,.4090E+00,.1063E+00,&
 .8354E-01,.8479E-01,.1027E+00,.7177E-01,.9541E-01,.1185E+00,.1062E+00,.1941E+00,.4219E+00,.1127E+00,&
 .8600E-01,.8888E-01,.1093E+00,.7518E-01,.9804E-01,.1218E+00,.1102E+00,.2009E+00,.4348E+00,.1190E+00,&
 .8845E-01,.9296E-01,.1159E+00,.7860E-01,.1007E+00,.1250E+00,.1142E+00,.2076E+00,.4477E+00,.1254E+00,&
 .9115E-01,.9755E-01,.1233E+00,.8241E-01,.1036E+00,.1287E+00,.1188E+00,.2153E+00,.4621E+00,.1325E+00,&
 .9386E-01,.1021E+00,.1306E+00,.8622E-01,.1066E+00,.1324E+00,.1233E+00,.2229E+00,.4765E+00,.1396E+00,&
 .9656E-01,.1067E+00,.1380E+00,.9003E-01,.1095E+00,.1361E+00,.1279E+00,.2306E+00,.4909E+00,.1467E+00,&
 .9926E-01,.1113E+00,.1453E+00,.9383E-01,.1125E+00,.1397E+00,.1324E+00,.2382E+00,.5052E+00,.1539E+00,&
 .1020E+00,.1159E+00,.1527E+00,.9764E-01,.1155E+00,.1434E+00,.1369E+00,.2459E+00,.5196E+00,.1610E+00,&
 .1050E+00,.1211E+00,.1609E+00,.1019E+00,.1188E+00,.1476E+00,.1421E+00,.2545E+00,.5358E+00,.1689E+00,&
 .1079E+00,.1262E+00,.1691E+00,.1061E+00,.1221E+00,.1517E+00,.1473E+00,.2631E+00,.5519E+00,.1769E+00,&
 .1109E+00,.1314E+00,.1772E+00,.1104E+00,.1255E+00,.1559E+00,.1525E+00,.2717E+00,.5680E+00,.1849E+00,&
 .1139E+00,.1365E+00,.1854E+00,.1146E+00,.1288E+00,.1600E+00,.1576E+00,.2804E+00,.5842E+00,.1928E+00,&
 .1169E+00,.1417E+00,.1936E+00,.1189E+00,.1321E+00,.1642E+00,.1628E+00,.2890E+00,.6003E+00,.2008E+00,&
 .1202E+00,.1474E+00,.2025E+00,.1236E+00,.1358E+00,.1688E+00,.1686E+00,.2986E+00,.6181E+00,.2096E+00,&
 .1235E+00,.1531E+00,.2115E+00,.1282E+00,.1395E+00,.1735E+00,.1744E+00,.3081E+00,.6359E+00,.2183E+00,&
 .1267E+00,.1588E+00,.2204E+00,.1329E+00,.1432E+00,.1781E+00,.1803E+00,.3177E+00,.6537E+00,.2271E+00,&
 .1300E+00,.1645E+00,.2294E+00,.1375E+00,.1469E+00,.1827E+00,.1861E+00,.3273E+00,.6714E+00,.2358E+00,&
 .1333E+00,.1702E+00,.2383E+00,.1422E+00,.1506E+00,.1874E+00,.1919E+00,.3369E+00,.6892E+00,.2446E+00,&
 .1369E+00,.1766E+00,.2481E+00,.1473E+00,.1548E+00,.1926E+00,.1984E+00,.3476E+00,.7089E+00,.2542E+00,&
 .1405E+00,.1829E+00,.2579E+00,.1524E+00,.1589E+00,.1978E+00,.2050E+00,.3583E+00,.7287E+00,.2639E+00,&
 .1441E+00,.1892E+00,.2678E+00,.1576E+00,.1631E+00,.2030E+00,.2115E+00,.3690E+00,.7484E+00,.2736E+00,&
 .1478E+00,.1956E+00,.2776E+00,.1627E+00,.1672E+00,.2082E+00,.2181E+00,.3797E+00,.7681E+00,.2832E+00,&
 .1514E+00,.2019E+00,.2874E+00,.1678E+00,.1713E+00,.2134E+00,.2246E+00,.3904E+00,.7878E+00,.2929E+00,&
 .1553E+00,.2088E+00,.2980E+00,.1734E+00,.1759E+00,.2191E+00,.2319E+00,.4021E+00,.8092E+00,.3034E+00,&
 .1593E+00,.2158E+00,.3086E+00,.1790E+00,.1804E+00,.2249E+00,.2391E+00,.4139E+00,.8306E+00,.3139E+00,&
 .1632E+00,.2227E+00,.3192E+00,.1845E+00,.1850E+00,.2306E+00,.2464E+00,.4256E+00,.8521E+00,.3244E+00,&
 .1672E+00,.2296E+00,.3298E+00,.1901E+00,.1895E+00,.2364E+00,.2537E+00,.4374E+00,.8735E+00,.3349E+00,&
 .1711E+00,.2366E+00,.3405E+00,.1957E+00,.1941E+00,.2421E+00,.2609E+00,.4491E+00,.8949E+00,.3454E+00,&
 .1755E+00,.2442E+00,.3520E+00,.2017E+00,.1991E+00,.2485E+00,.2690E+00,.4621E+00,.9185E+00,.3568E+00,&
 .1798E+00,.2518E+00,.3636E+00,.2078E+00,.2042E+00,.2549E+00,.2771E+00,.4751E+00,.9421E+00,.3683E+00,&
 .1841E+00,.2594E+00,.3751E+00,.2139E+00,.2092E+00,.2613E+00,.2853E+00,.4881E+00,.9657E+00,.3798E+00,&
 .1885E+00,.2671E+00,.3867E+00,.2199E+00,.2142E+00,.2677E+00,.2934E+00,.5011E+00,.9893E+00,.3913E+00,&
 .1928E+00,.2747E+00,.3983E+00,.2260E+00,.2193E+00,.2741E+00,.3015E+00,.5141E+00,.1013E+01,.4028E+00,&
 .1975E+00,.2830E+00,.4106E+00,.2325E+00,.2248E+00,.2811E+00,.3104E+00,.5282E+00,.1038E+01,.4151E+00,&
 .2022E+00,.2912E+00,.4230E+00,.2391E+00,.2303E+00,.2881E+00,.3193E+00,.5424E+00,.1064E+01,.4275E+00,&
 .2069E+00,.2995E+00,.4354E+00,.2456E+00,.2358E+00,.2951E+00,.3282E+00,.5565E+00,.1089E+01,.4398E+00,&
 .2116E+00,.3078E+00,.4478E+00,.2521E+00,.2413E+00,.3021E+00,.3372E+00,.5706E+00,.1114E+01,.4522E+00,&
 .2163E+00,.3161E+00,.4602E+00,.2587E+00,.2468E+00,.3091E+00,.3461E+00,.5848E+00,.1140E+01,.4645E+00,&
 .2205E+00,.3235E+00,.4712E+00,.2645E+00,.2518E+00,.3154E+00,.3542E+00,.5975E+00,.1162E+01,.4756E+00,&
 .2247E+00,.3309E+00,.4822E+00,.2703E+00,.2567E+00,.3217E+00,.3623E+00,.6103E+00,.1185E+01,.4866E+00,&
 .2290E+00,.3383E+00,.4932E+00,.2761E+00,.2617E+00,.3281E+00,.3704E+00,.6230E+00,.1208E+01,.4976E+00,&
 .2332E+00,.3458E+00,.5043E+00,.2819E+00,.2667E+00,.3344E+00,.3784E+00,.6357E+00,.1231E+01,.5086E+00,&
 .2374E+00,.3532E+00,.5153E+00,.2877E+00,.2716E+00,.3408E+00,.3865E+00,.6485E+00,.1254E+01,.5197E+00,&
 .2419E+00,.3611E+00,.5269E+00,.2939E+00,.2770E+00,.3476E+00,.3953E+00,.6621E+00,.1278E+01,.5314E+00,&
 .2464E+00,.3690E+00,.5386E+00,.3001E+00,.2823E+00,.3544E+00,.4040E+00,.6758E+00,.1302E+01,.5431E+00,&
 .2509E+00,.3770E+00,.5503E+00,.3063E+00,.2876E+00,.3612E+00,.4128E+00,.6894E+00,.1326E+01,.5548E+00,&
 .2554E+00,.3849E+00,.5619E+00,.3125E+00,.2930E+00,.3681E+00,.4215E+00,.7031E+00,.1350E+01,.5665E+00,&
 .2599E+00,.3928E+00,.5736E+00,.3186E+00,.2983E+00,.3749E+00,.4303E+00,.7167E+00,.1374E+01,.5782E+00,&
 .2647E+00,.4012E+00,.5858E+00,.3252E+00,.3040E+00,.3822E+00,.4396E+00,.7312E+00,.1399E+01,.5905E+00,&
 .2695E+00,.4096E+00,.5981E+00,.3317E+00,.3097E+00,.3895E+00,.4490E+00,.7456E+00,.1424E+01,.6028E+00,&
 .2743E+00,.4180E+00,.6103E+00,.3382E+00,.3154E+00,.3968E+00,.4583E+00,.7601E+00,.1450E+01,.6151E+00,&
 .2791E+00,.4264E+00,.6226E+00,.3447E+00,.3211E+00,.4041E+00,.4677E+00,.7746E+00,.1475E+01,.6274E+00,&
 .2839E+00,.4348E+00,.6348E+00,.3512E+00,.3268E+00,.4114E+00,.4770E+00,.7891E+00,.1500E+01,.6398E+00,&
 .2890E+00,.4438E+00,.6478E+00,.3581E+00,.3329E+00,.4193E+00,.4871E+00,.8046E+00,.1528E+01,.6529E+00,&
 .2941E+00,.4528E+00,.6608E+00,.3651E+00,.3390E+00,.4272E+00,.4973E+00,.8202E+00,.1555E+01,.6660E+00,&
 .2992E+00,.4618E+00,.6738E+00,.3720E+00,.3452E+00,.4351E+00,.5074E+00,.8358E+00,.1582E+01,.6792E+00,&
 .3044E+00,.4708E+00,.6868E+00,.3789E+00,.3513E+00,.4430E+00,.5175E+00,.8513E+00,.1609E+01,.6923E+00,&
 .3095E+00,.4798E+00,.6998E+00,.3859E+00,.3574E+00,.4509E+00,.5276E+00,.8669E+00,.1636E+01,.7055E+00,&
 .3185E+00,.4955E+00,.7222E+00,.3979E+00,.3682E+00,.4648E+00,.5454E+00,.8941E+00,.1683E+01,.7281E+00,&
 .3274E+00,.5111E+00,.7446E+00,.4098E+00,.3789E+00,.4786E+00,.5632E+00,.9213E+00,.1729E+01,.7508E+00,&
 .3364E+00,.5268E+00,.7670E+00,.4218E+00,.3897E+00,.4925E+00,.5810E+00,.9484E+00,.1776E+01,.7735E+00,&
 .3453E+00,.5425E+00,.7894E+00,.4338E+00,.4004E+00,.5064E+00,.5989E+00,.9756E+00,.1822E+01,.7962E+00,&
 .3543E+00,.5581E+00,.8118E+00,.4458E+00,.4112E+00,.5202E+00,.6167E+00,.1003E+01,.1869E+01,.8188E+00,&
 .3667E+00,.5796E+00,.8421E+00,.4621E+00,.4261E+00,.5396E+00,.6415E+00,.1040E+01,.1932E+01,.8497E+00,&
 .3790E+00,.6011E+00,.8725E+00,.4784E+00,.4410E+00,.5589E+00,.6663E+00,.1078E+01,.1996E+01,.8805E+00,&
 .3914E+00,.6226E+00,.9028E+00,.4947E+00,.4560E+00,.5782E+00,.6911E+00,.1115E+01,.2059E+01,.9113E+00,&
 .4037E+00,.6441E+00,.9331E+00,.5110E+00,.4709E+00,.5975E+00,.7159E+00,.1152E+01,.2123E+01,.9422E+00,&
 .4161E+00,.6656E+00,.9634E+00,.5274E+00,.4858E+00,.6168E+00,.7407E+00,.1190E+01,.2187E+01,.9730E+00,&
 .4320E+00,.6933E+00,.1002E+01,.5481E+00,.5051E+00,.6419E+00,.7730E+00,.1238E+01,.2267E+01,.1012E+01,&
 .4547E+00,.7327E+00,.1057E+01,.5778E+00,.5328E+00,.6778E+00,.8190E+00,.1306E+01,.2380E+01,.1068E+01,&
 .4751E+00,.7679E+00,.1105E+01,.6043E+00,.5576E+00,.7101E+00,.8605E+00,.1368E+01,.2482E+01,.1118E+01,&
 .4959E+00,.8038E+00,.1155E+01,.6311E+00,.5829E+00,.7430E+00,.9028E+00,.1430E+01,.2585E+01,.1169E+01,&
 .5284E+00,.8597E+00,.1231E+01,.6728E+00,.6227E+00,.7947E+00,.9690E+00,.1527E+01,.2748E+01,.1247E+01,&
 .5549E+00,.9054E+00,.1294E+01,.7069E+00,.6552E+00,.8370E+00,.1024E+01,.1607E+01,.2877E+01,.1311E+01,&
 .5901E+00,.9658E+00,.1375E+01,.7517E+00,.6983E+00,.8933E+00,.1096E+01,.1712E+01,.3046E+01,.1395E+01,&
 .6269E+00,.1028E+01,.1460E+01,.7982E+00,.7436E+00,.9522E+00,.1171E+01,.1821E+01,.3222E+01,.1482E+01,&
 .6697E+00,.1101E+01,.1558E+01,.8521E+00,.7963E+00,.1021E+01,.1259E+01,.1949E+01,.3428E+01,.1583E+01,&
 .7285E+00,.1201E+01,.1690E+01,.9254E+00,.8690E+00,.1116E+01,.1381E+01,.2122E+01,.3703E+01,.1720E+01,&
 .7908E+00,.1307E+01,.1829E+01,.1003E+01,.9462E+00,.1217E+01,.1510E+01,.2305E+01,.3988E+01,.1864E+01,&
 .8831E+00,.1462E+01,.2031E+01,.1116E+01,.1061E+01,.1367E+01,.1701E+01,.2575E+01,.4410E+01,.2074E+01,&
 .9884E+00,.1638E+01,.2259E+01,.1244E+01,.1192E+01,.1538E+01,.1920E+01,.2880E+01,.4873E+01,.2311E+01,&
 .1140E+01,.1890E+01,.2580E+01,.1426E+01,.1382E+01,.1787E+01,.2235E+01,.3315E+01,.5532E+01,.2646E+01,&
 .1365E+01,.2259E+01,.3043E+01,.1691E+01,.1664E+01,.2155E+01,.2701E+01,.3947E+01,.6458E+01,.3131E+01,&
 .1667E+01,.2750E+01,.3647E+01,.2042E+01,.2044E+01,.2652E+01,.3326E+01,.4784E+01,.7665E+01,.3767E+01,&
 .2281E+01,.3727E+01,.4821E+01,.2736E+01,.2819E+01,.3660E+01,.4583E+01,.6425E+01,.9939E+01,.5007E+01,&
 .3357E+01,.5397E+01,.6758E+01,.3914E+01,.4181E+01,.5420E+01,.6748E+01,.9167E+01,.1359E+02,.7068E+01,&
 .6683E+01,.1032E+02,.1219E+02,.7377E+01,.8380E+01,.1077E+02,.1317E+02,.1689E+02,.2304E+02,.1290E+02/
 data (((Bex_lw(ai,k,nh),ai= 6, 6),k=1,nwl_lw),nh=0,99)/ &
 .8507E-01,.1012E+00,.1020E+00,.1242E+00,.1501E+00,.1512E+00,.1408E+00,.1564E+00,.1616E+00,.1167E+00,&
 .8754E-01,.1042E+00,.1045E+00,.1260E+00,.1530E+00,.1546E+00,.1443E+00,.1600E+00,.1653E+00,.1196E+00,&
 .9001E-01,.1072E+00,.1070E+00,.1278E+00,.1559E+00,.1579E+00,.1478E+00,.1636E+00,.1690E+00,.1225E+00,&
 .9247E-01,.1102E+00,.1095E+00,.1295E+00,.1588E+00,.1613E+00,.1513E+00,.1672E+00,.1727E+00,.1254E+00,&
 .9494E-01,.1132E+00,.1120E+00,.1313E+00,.1617E+00,.1647E+00,.1547E+00,.1708E+00,.1765E+00,.1283E+00,&
 .9741E-01,.1162E+00,.1145E+00,.1331E+00,.1646E+00,.1680E+00,.1582E+00,.1744E+00,.1802E+00,.1312E+00,&
 .1001E+00,.1195E+00,.1174E+00,.1352E+00,.1677E+00,.1715E+00,.1621E+00,.1784E+00,.1842E+00,.1344E+00,&
 .1028E+00,.1228E+00,.1203E+00,.1372E+00,.1708E+00,.1750E+00,.1660E+00,.1823E+00,.1883E+00,.1377E+00,&
 .1055E+00,.1261E+00,.1233E+00,.1392E+00,.1740E+00,.1784E+00,.1699E+00,.1863E+00,.1924E+00,.1409E+00,&
 .1082E+00,.1294E+00,.1262E+00,.1413E+00,.1771E+00,.1819E+00,.1738E+00,.1902E+00,.1964E+00,.1442E+00,&
 .1109E+00,.1327E+00,.1291E+00,.1433E+00,.1802E+00,.1854E+00,.1777E+00,.1942E+00,.2005E+00,.1474E+00,&
 .1138E+00,.1363E+00,.1324E+00,.1456E+00,.1835E+00,.1892E+00,.1818E+00,.1983E+00,.2046E+00,.1510E+00,&
 .1168E+00,.1399E+00,.1357E+00,.1479E+00,.1868E+00,.1931E+00,.1858E+00,.2024E+00,.2088E+00,.1545E+00,&
 .1197E+00,.1435E+00,.1389E+00,.1501E+00,.1901E+00,.1970E+00,.1899E+00,.2064E+00,.2129E+00,.1581E+00,&
 .1226E+00,.1471E+00,.1422E+00,.1524E+00,.1934E+00,.2008E+00,.1939E+00,.2105E+00,.2171E+00,.1616E+00,&
 .1256E+00,.1507E+00,.1455E+00,.1546E+00,.1968E+00,.2047E+00,.1980E+00,.2146E+00,.2213E+00,.1652E+00,&
 .1287E+00,.1546E+00,.1491E+00,.1571E+00,.2003E+00,.2087E+00,.2024E+00,.2191E+00,.2258E+00,.1691E+00,&
 .1319E+00,.1585E+00,.1527E+00,.1596E+00,.2038E+00,.2127E+00,.2069E+00,.2235E+00,.2303E+00,.1729E+00,&
 .1351E+00,.1623E+00,.1563E+00,.1621E+00,.2073E+00,.2167E+00,.2114E+00,.2280E+00,.2349E+00,.1768E+00,&
 .1383E+00,.1662E+00,.1599E+00,.1647E+00,.2109E+00,.2207E+00,.2158E+00,.2325E+00,.2394E+00,.1807E+00,&
 .1415E+00,.1701E+00,.1635E+00,.1672E+00,.2144E+00,.2247E+00,.2203E+00,.2369E+00,.2439E+00,.1845E+00,&
 .1449E+00,.1742E+00,.1674E+00,.1699E+00,.2182E+00,.2290E+00,.2249E+00,.2415E+00,.2483E+00,.1887E+00,&
 .1484E+00,.1784E+00,.1712E+00,.1727E+00,.2220E+00,.2333E+00,.2295E+00,.2461E+00,.2528E+00,.1928E+00,&
 .1518E+00,.1825E+00,.1751E+00,.1755E+00,.2257E+00,.2375E+00,.2342E+00,.2508E+00,.2572E+00,.1970E+00,&
 .1553E+00,.1867E+00,.1790E+00,.1783E+00,.2295E+00,.2418E+00,.2388E+00,.2554E+00,.2616E+00,.2011E+00,&
 .1587E+00,.1908E+00,.1829E+00,.1811E+00,.2333E+00,.2461E+00,.2434E+00,.2600E+00,.2660E+00,.2052E+00,&
 .1624E+00,.1953E+00,.1870E+00,.1841E+00,.2373E+00,.2507E+00,.2484E+00,.2649E+00,.2711E+00,.2096E+00,&
 .1661E+00,.1997E+00,.1912E+00,.1871E+00,.2413E+00,.2554E+00,.2534E+00,.2698E+00,.2762E+00,.2141E+00,&
 .1698E+00,.2041E+00,.1953E+00,.1901E+00,.2454E+00,.2600E+00,.2584E+00,.2747E+00,.2812E+00,.2185E+00,&
 .1735E+00,.2086E+00,.1995E+00,.1931E+00,.2494E+00,.2647E+00,.2634E+00,.2796E+00,.2863E+00,.2229E+00,&
 .1772E+00,.2130E+00,.2036E+00,.1961E+00,.2534E+00,.2693E+00,.2684E+00,.2845E+00,.2914E+00,.2273E+00,&
 .1812E+00,.2177E+00,.2080E+00,.1994E+00,.2577E+00,.2741E+00,.2736E+00,.2896E+00,.2960E+00,.2320E+00,&
 .1852E+00,.2224E+00,.2124E+00,.2027E+00,.2620E+00,.2788E+00,.2789E+00,.2948E+00,.3005E+00,.2366E+00,&
 .1892E+00,.2271E+00,.2168E+00,.2059E+00,.2663E+00,.2836E+00,.2842E+00,.3000E+00,.3051E+00,.2413E+00,&
 .1932E+00,.2318E+00,.2212E+00,.2092E+00,.2706E+00,.2883E+00,.2894E+00,.3051E+00,.3097E+00,.2460E+00,&
 .1972E+00,.2365E+00,.2256E+00,.2125E+00,.2749E+00,.2931E+00,.2947E+00,.3103E+00,.3142E+00,.2507E+00,&
 .2014E+00,.2415E+00,.2302E+00,.2160E+00,.2795E+00,.2983E+00,.3001E+00,.3156E+00,.3198E+00,.2556E+00,&
 .2057E+00,.2465E+00,.2349E+00,.2196E+00,.2840E+00,.3034E+00,.3055E+00,.3208E+00,.3253E+00,.2605E+00,&
 .2099E+00,.2514E+00,.2395E+00,.2231E+00,.2886E+00,.3086E+00,.3109E+00,.3261E+00,.3309E+00,.2655E+00,&
 .2142E+00,.2564E+00,.2441E+00,.2266E+00,.2932E+00,.3138E+00,.3163E+00,.3313E+00,.3364E+00,.2704E+00,&
 .2184E+00,.2614E+00,.2488E+00,.2302E+00,.2978E+00,.3189E+00,.3217E+00,.3366E+00,.3420E+00,.2753E+00,&
 .2230E+00,.2666E+00,.2536E+00,.2339E+00,.3026E+00,.3243E+00,.3276E+00,.3423E+00,.3470E+00,.2805E+00,&
 .2275E+00,.2718E+00,.2585E+00,.2377E+00,.3074E+00,.3297E+00,.3335E+00,.3479E+00,.3521E+00,.2857E+00,&
 .2320E+00,.2771E+00,.2634E+00,.2415E+00,.3122E+00,.3350E+00,.3394E+00,.3536E+00,.3571E+00,.2908E+00,&
 .2366E+00,.2823E+00,.2683E+00,.2453E+00,.3170E+00,.3404E+00,.3453E+00,.3592E+00,.3622E+00,.2960E+00,&
 .2411E+00,.2876E+00,.2732E+00,.2490E+00,.3218E+00,.3458E+00,.3512E+00,.3649E+00,.3672E+00,.3012E+00,&
 .2459E+00,.2931E+00,.2783E+00,.2531E+00,.3269E+00,.3514E+00,.3570E+00,.3706E+00,.3728E+00,.3066E+00,&
 .2507E+00,.2986E+00,.2834E+00,.2571E+00,.3321E+00,.3570E+00,.3629E+00,.3762E+00,.3784E+00,.3120E+00,&
 .2555E+00,.3041E+00,.2885E+00,.2611E+00,.3372E+00,.3626E+00,.3687E+00,.3819E+00,.3840E+00,.3174E+00,&
 .2603E+00,.3095E+00,.2936E+00,.2652E+00,.3423E+00,.3683E+00,.3745E+00,.3876E+00,.3896E+00,.3228E+00,&
 .2651E+00,.3150E+00,.2987E+00,.2692E+00,.3474E+00,.3739E+00,.3804E+00,.3933E+00,.3952E+00,.3282E+00,&
 .2692E+00,.3197E+00,.3030E+00,.2727E+00,.3518E+00,.3787E+00,.3855E+00,.3982E+00,.4000E+00,.3328E+00,&
 .2734E+00,.3244E+00,.3073E+00,.2762E+00,.3562E+00,.3836E+00,.3907E+00,.4031E+00,.4048E+00,.3375E+00,&
 .2775E+00,.3291E+00,.3117E+00,.2797E+00,.3606E+00,.3884E+00,.3958E+00,.4081E+00,.4097E+00,.3421E+00,&
 .2817E+00,.3338E+00,.3160E+00,.2831E+00,.3650E+00,.3933E+00,.4009E+00,.4130E+00,.4145E+00,.3467E+00,&
 .2858E+00,.3385E+00,.3204E+00,.2866E+00,.3693E+00,.3981E+00,.4061E+00,.4179E+00,.4193E+00,.3513E+00,&
 .2902E+00,.3434E+00,.3248E+00,.2902E+00,.3739E+00,.4031E+00,.4114E+00,.4230E+00,.4238E+00,.3561E+00,&
 .2945E+00,.3483E+00,.3293E+00,.2939E+00,.3784E+00,.4081E+00,.4168E+00,.4281E+00,.4283E+00,.3608E+00,&
 .2988E+00,.3531E+00,.3338E+00,.2975E+00,.3830E+00,.4131E+00,.4222E+00,.4332E+00,.4328E+00,.3656E+00,&
 .3031E+00,.3580E+00,.3383E+00,.3012E+00,.3875E+00,.4181E+00,.4275E+00,.4383E+00,.4373E+00,.3704E+00,&
 .3075E+00,.3628E+00,.3428E+00,.3048E+00,.3921E+00,.4231E+00,.4329E+00,.4434E+00,.4418E+00,.3751E+00,&
 .3120E+00,.3679E+00,.3475E+00,.3086E+00,.3968E+00,.4283E+00,.4382E+00,.4485E+00,.4467E+00,.3801E+00,&
 .3165E+00,.3729E+00,.3521E+00,.3124E+00,.4016E+00,.4334E+00,.4434E+00,.4536E+00,.4516E+00,.3850E+00,&
 .3210E+00,.3780E+00,.3567E+00,.3162E+00,.4063E+00,.4385E+00,.4487E+00,.4587E+00,.4564E+00,.3899E+00,&
 .3255E+00,.3830E+00,.3614E+00,.3200E+00,.4111E+00,.4437E+00,.4539E+00,.4638E+00,.4613E+00,.3948E+00,&
 .3301E+00,.3880E+00,.3660E+00,.3238E+00,.4158E+00,.4488E+00,.4592E+00,.4689E+00,.4662E+00,.3997E+00,&
 .3348E+00,.3932E+00,.3708E+00,.3278E+00,.4208E+00,.4542E+00,.4647E+00,.4742E+00,.4715E+00,.4048E+00,&
 .3395E+00,.3985E+00,.3756E+00,.3318E+00,.4257E+00,.4595E+00,.4703E+00,.4794E+00,.4769E+00,.4099E+00,&
 .3442E+00,.4037E+00,.3804E+00,.3358E+00,.4307E+00,.4649E+00,.4758E+00,.4847E+00,.4822E+00,.4149E+00,&
 .3489E+00,.4089E+00,.3852E+00,.3397E+00,.4356E+00,.4702E+00,.4813E+00,.4899E+00,.4876E+00,.4200E+00,&
 .3536E+00,.4141E+00,.3900E+00,.3437E+00,.4405E+00,.4756E+00,.4869E+00,.4952E+00,.4929E+00,.4251E+00,&
 .3609E+00,.4221E+00,.3974E+00,.3499E+00,.4482E+00,.4838E+00,.4956E+00,.5034E+00,.5002E+00,.4329E+00,&
 .3683E+00,.4302E+00,.4047E+00,.3561E+00,.4558E+00,.4921E+00,.5043E+00,.5116E+00,.5075E+00,.4407E+00,&
 .3756E+00,.4382E+00,.4121E+00,.3623E+00,.4635E+00,.5004E+00,.5130E+00,.5198E+00,.5148E+00,.4485E+00,&
 .3830E+00,.4463E+00,.4195E+00,.3685E+00,.4711E+00,.5086E+00,.5217E+00,.5280E+00,.5221E+00,.4563E+00,&
 .3903E+00,.4543E+00,.4269E+00,.3747E+00,.4787E+00,.5169E+00,.5304E+00,.5362E+00,.5294E+00,.4641E+00,&
 .4018E+00,.4668E+00,.4382E+00,.3844E+00,.4907E+00,.5296E+00,.5433E+00,.5485E+00,.5414E+00,.4762E+00,&
 .4132E+00,.4792E+00,.4496E+00,.3941E+00,.5026E+00,.5423E+00,.5562E+00,.5608E+00,.5534E+00,.4882E+00,&
 .4247E+00,.4916E+00,.4610E+00,.4038E+00,.5145E+00,.5550E+00,.5690E+00,.5730E+00,.5654E+00,.5002E+00,&
 .4362E+00,.5041E+00,.4723E+00,.4135E+00,.5264E+00,.5677E+00,.5819E+00,.5853E+00,.5774E+00,.5123E+00,&
 .4476E+00,.5165E+00,.4837E+00,.4232E+00,.5383E+00,.5804E+00,.5947E+00,.5976E+00,.5894E+00,.5243E+00,&
 .4603E+00,.5301E+00,.4961E+00,.4339E+00,.5514E+00,.5943E+00,.6091E+00,.6111E+00,.6012E+00,.5374E+00,&
 .4796E+00,.5508E+00,.5149E+00,.4503E+00,.5713E+00,.6154E+00,.6312E+00,.6316E+00,.6205E+00,.5573E+00,&
 .4993E+00,.5719E+00,.5341E+00,.4670E+00,.5916E+00,.6369E+00,.6532E+00,.6526E+00,.6387E+00,.5776E+00,&
 .5195E+00,.5934E+00,.5537E+00,.4841E+00,.6123E+00,.6587E+00,.6748E+00,.6735E+00,.6575E+00,.5984E+00,&
 .5436E+00,.6188E+00,.5769E+00,.5045E+00,.6370E+00,.6846E+00,.7005E+00,.6975E+00,.6822E+00,.6228E+00,&
 .5683E+00,.6449E+00,.6006E+00,.5254E+00,.6623E+00,.7111E+00,.7273E+00,.7229E+00,.7073E+00,.6478E+00,&
 .5936E+00,.6714E+00,.6247E+00,.5468E+00,.6882E+00,.7381E+00,.7550E+00,.7487E+00,.7309E+00,.6732E+00,&
 .6213E+00,.7004E+00,.6510E+00,.5703E+00,.7163E+00,.7675E+00,.7851E+00,.7767E+00,.7555E+00,.7010E+00,&
 .6535E+00,.7340E+00,.6815E+00,.5976E+00,.7490E+00,.8013E+00,.8183E+00,.8090E+00,.7846E+00,.7332E+00,&
 .6925E+00,.7745E+00,.7182E+00,.6307E+00,.7885E+00,.8422E+00,.8585E+00,.8463E+00,.8223E+00,.7719E+00,&
 .7409E+00,.8244E+00,.7634E+00,.6718E+00,.8374E+00,.8925E+00,.9092E+00,.8942E+00,.8675E+00,.8195E+00,&
 .7951E+00,.8801E+00,.8139E+00,.7178E+00,.8917E+00,.9484E+00,.9654E+00,.9471E+00,.9159E+00,.8725E+00,&
 .8780E+00,.9646E+00,.8904E+00,.7883E+00,.9746E+00,.1033E+01,.1048E+01,.1025E+01,.9917E+00,.9530E+00,&
 .9790E+00,.1067E+01,.9831E+00,.8742E+00,.1075E+01,.1135E+01,.1150E+01,.1121E+01,.1080E+01,.1050E+01,&
 .1111E+01,.1199E+01,.1102E+01,.9862E+00,.1205E+01,.1265E+01,.1276E+01,.1241E+01,.1198E+01,.1175E+01,&
 .1314E+01,.1401E+01,.1286E+01,.1160E+01,.1404E+01,.1464E+01,.1471E+01,.1426E+01,.1373E+01,.1367E+01,&
 .1600E+01,.1682E+01,.1542E+01,.1404E+01,.1679E+01,.1738E+01,.1738E+01,.1681E+01,.1614E+01,.1634E+01,&
 .2137E+01,.2204E+01,.2019E+01,.1866E+01,.2190E+01,.2241E+01,.2229E+01,.2151E+01,.2071E+01,.2130E+01,&
 .3477E+01,.3490E+01,.3204E+01,.3029E+01,.3436E+01,.3461E+01,.3423E+01,.3306E+01,.3196E+01,.3354E+01/
 data (((Bex_lw(ai,k,nh),ai= 7, 7),k=1,nwl_lw),nh=0,99)/ &
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01,&
 .8683E-02,.1551E-01,.1820E-01,.2197E-01,.2804E-01,.3277E-01,.1600E-01,.1249E-01,.1821E-01,.1971E-01/
 data (((Bex_lw(ai,k,nh),ai= 8, 8),k=1,nwl_lw),nh=0,99)/ &
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01,&
 .8847E-02,.1629E-01,.1937E-01,.2635E-01,.4616E-01,.3551E-01,.1831E-01,.2085E-01,.5223E-01,.2029E-01/
 data (((Bex_lw(ai,k,nh),ai= 9, 9),k=1,nwl_lw),nh=0,99)/ &
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01,&
 .9779E-02,.2069E-01,.2495E-01,.4592E-01,.1183E+00,.4591E-01,.2685E-01,.5005E-01,.1435E+00,.2304E-01/
 data (((Bex_lw(ai,k,nh),ai=10,10),k=1,nwl_lw),nh=0,99)/ &
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01,&
 .1381E-01,.3649E-01,.4082E-01,.9216E-01,.2424E+00,.6645E-01,.4494E-01,.1051E+00,.2604E+00,.3155E-01/
 data (((Bex_lw(ai,k,nh),ai=11,11),k=1,nwl_lw),nh=0,99)/ &
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01,&
 .2548E-01,.6926E-01,.6668E-01,.1474E+00,.3136E+00,.8431E-01,.6692E-01,.1596E+00,.3098E+00,.4753E-01/
 data (((Bex_lw(ai,k,nh),ai=12,12),k=1,nwl_lw),nh=0,99)/ &
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01,&
 .5039E-01,.1121E+00,.9657E-01,.1828E+00,.2895E+00,.9190E-01,.8718E-01,.1880E+00,.2788E+00,.7151E-01/
 data (((Bex_lw(ai,k,nh),ai=13,13),k=1,nwl_lw),nh=0,99)/ &
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01,&
 .8052E-01,.1282E+00,.1071E+00,.1571E+00,.1802E+00,.7780E-01,.8968E-01,.1550E+00,.1732E+00,.8845E-01/
 data (((Bex_lw(ai,k,nh),ai=14,14),k=1,nwl_lw),nh=0,99)/ &
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01,&
 .8101E-01,.9702E-01,.8537E-01,.9934E-01,.9658E-01,.5640E-01,.7138E-01,.9553E-01,.9179E-01,.7815E-01/
 data (((w0_lw(ai,k,nh),ai= 1, 1),k=1,nwl_lw),nh=0,99)/ &
 .1325E-03,.1713E-02,.1149E-02,.1635E-02,.2001E-02,.1756E-02,.1147E-02,.4354E-02,.1745E-01,.1744E-02,&
 .1309E-03,.1522E-02,.1084E-02,.1627E-02,.2007E-02,.1761E-02,.1167E-02,.4478E-02,.1816E-01,.1573E-02,&
 .1292E-03,.1332E-02,.1018E-02,.1618E-02,.2013E-02,.1767E-02,.1188E-02,.4603E-02,.1887E-01,.1402E-02,&
 .1275E-03,.1141E-02,.9531E-03,.1610E-02,.2019E-02,.1772E-02,.1208E-02,.4728E-02,.1958E-01,.1231E-02,&
 .1258E-03,.9507E-03,.8878E-03,.1602E-02,.2025E-02,.1778E-02,.1228E-02,.4852E-02,.2029E-01,.1060E-02,&
 .1242E-03,.7601E-03,.8225E-03,.1594E-02,.2031E-02,.1784E-02,.1248E-02,.4977E-02,.2100E-01,.8890E-03,&
 .1232E-03,.7190E-03,.8014E-03,.1589E-02,.2039E-02,.1793E-02,.1275E-02,.5120E-02,.2184E-01,.8469E-03,&
 .1223E-03,.6779E-03,.7803E-03,.1584E-02,.2048E-02,.1802E-02,.1301E-02,.5263E-02,.2267E-01,.8049E-03,&
 .1214E-03,.6367E-03,.7592E-03,.1578E-02,.2057E-02,.1811E-02,.1327E-02,.5405E-02,.2351E-01,.7628E-03,&
 .1204E-03,.5956E-03,.7381E-03,.1573E-02,.2066E-02,.1820E-02,.1354E-02,.5548E-02,.2434E-01,.7207E-03,&
 .1195E-03,.5545E-03,.7170E-03,.1568E-02,.2075E-02,.1829E-02,.1380E-02,.5691E-02,.2518E-01,.6787E-03,&
 .1191E-03,.5381E-03,.7072E-03,.1567E-02,.2087E-02,.1842E-02,.1413E-02,.5851E-02,.2613E-01,.6622E-03,&
 .1187E-03,.5217E-03,.6973E-03,.1565E-02,.2099E-02,.1855E-02,.1445E-02,.6012E-02,.2708E-01,.6458E-03,&
 .1184E-03,.5053E-03,.6874E-03,.1563E-02,.2111E-02,.1867E-02,.1478E-02,.6172E-02,.2803E-01,.6294E-03,&
 .1180E-03,.4889E-03,.6776E-03,.1561E-02,.2123E-02,.1880E-02,.1511E-02,.6332E-02,.2898E-01,.6130E-03,&
 .1176E-03,.4726E-03,.6677E-03,.1560E-02,.2135E-02,.1893E-02,.1544E-02,.6493E-02,.2993E-01,.5966E-03,&
 .1175E-03,.4638E-03,.6620E-03,.1559E-02,.2149E-02,.1908E-02,.1583E-02,.6676E-02,.3104E-01,.5887E-03,&
 .1175E-03,.4551E-03,.6564E-03,.1558E-02,.2162E-02,.1924E-02,.1623E-02,.6860E-02,.3216E-01,.5807E-03,&
 .1174E-03,.4464E-03,.6507E-03,.1558E-02,.2176E-02,.1940E-02,.1663E-02,.7044E-02,.3327E-01,.5727E-03,&
 .1173E-03,.4377E-03,.6450E-03,.1557E-02,.2190E-02,.1955E-02,.1703E-02,.7227E-02,.3439E-01,.5647E-03,&
 .1172E-03,.4290E-03,.6394E-03,.1556E-02,.2204E-02,.1971E-02,.1743E-02,.7411E-02,.3550E-01,.5567E-03,&
 .1174E-03,.4246E-03,.6367E-03,.1557E-02,.2220E-02,.1989E-02,.1791E-02,.7618E-02,.3678E-01,.5535E-03,&
 .1176E-03,.4201E-03,.6341E-03,.1558E-02,.2237E-02,.2008E-02,.1839E-02,.7824E-02,.3805E-01,.5502E-03,&
 .1177E-03,.4156E-03,.6315E-03,.1559E-02,.2253E-02,.2027E-02,.1886E-02,.8031E-02,.3932E-01,.5469E-03,&
 .1179E-03,.4111E-03,.6288E-03,.1561E-02,.2270E-02,.2045E-02,.1934E-02,.8238E-02,.4060E-01,.5437E-03,&
 .1181E-03,.4067E-03,.6262E-03,.1562E-02,.2286E-02,.2064E-02,.1982E-02,.8445E-02,.4187E-01,.5404E-03,&
 .1185E-03,.4046E-03,.6257E-03,.1564E-02,.2305E-02,.2087E-02,.2038E-02,.8676E-02,.4331E-01,.5399E-03,&
 .1190E-03,.4026E-03,.6252E-03,.1567E-02,.2324E-02,.2109E-02,.2095E-02,.8908E-02,.4475E-01,.5394E-03,&
 .1194E-03,.4005E-03,.6246E-03,.1570E-02,.2343E-02,.2131E-02,.2151E-02,.9139E-02,.4619E-01,.5389E-03,&
 .1198E-03,.3985E-03,.6241E-03,.1572E-02,.2362E-02,.2153E-02,.2207E-02,.9371E-02,.4763E-01,.5384E-03,&
 .1202E-03,.3964E-03,.6235E-03,.1575E-02,.2381E-02,.2176E-02,.2263E-02,.9603E-02,.4907E-01,.5379E-03,&
 .1208E-03,.3960E-03,.6246E-03,.1579E-02,.2402E-02,.2202E-02,.2329E-02,.9859E-02,.5069E-01,.5392E-03,&
 .1214E-03,.3955E-03,.6256E-03,.1583E-02,.2424E-02,.2228E-02,.2394E-02,.1012E-01,.5231E-01,.5406E-03,&
 .1220E-03,.3950E-03,.6267E-03,.1587E-02,.2445E-02,.2254E-02,.2459E-02,.1037E-01,.5392E-01,.5419E-03,&
 .1226E-03,.3945E-03,.6277E-03,.1591E-02,.2467E-02,.2280E-02,.2525E-02,.1063E-01,.5554E-01,.5432E-03,&
 .1233E-03,.3940E-03,.6287E-03,.1595E-02,.2488E-02,.2306E-02,.2590E-02,.1089E-01,.5716E-01,.5446E-03,&
 .1241E-03,.3948E-03,.6312E-03,.1601E-02,.2513E-02,.2336E-02,.2664E-02,.1117E-01,.5892E-01,.5473E-03,&
 .1248E-03,.3956E-03,.6337E-03,.1607E-02,.2537E-02,.2366E-02,.2737E-02,.1145E-01,.6068E-01,.5501E-03,&
 .1256E-03,.3964E-03,.6362E-03,.1613E-02,.2562E-02,.2396E-02,.2811E-02,.1173E-01,.6244E-01,.5529E-03,&
 .1264E-03,.3971E-03,.6387E-03,.1619E-02,.2586E-02,.2425E-02,.2884E-02,.1201E-01,.6420E-01,.5557E-03,&
 .1272E-03,.3979E-03,.6412E-03,.1625E-02,.2611E-02,.2455E-02,.2958E-02,.1229E-01,.6596E-01,.5585E-03,&
 .1281E-03,.3994E-03,.6445E-03,.1631E-02,.2637E-02,.2489E-02,.3043E-02,.1260E-01,.6794E-01,.5622E-03,&
 .1291E-03,.4008E-03,.6478E-03,.1638E-02,.2664E-02,.2523E-02,.3128E-02,.1292E-01,.6992E-01,.5658E-03,&
 .1300E-03,.4022E-03,.6511E-03,.1644E-02,.2691E-02,.2557E-02,.3213E-02,.1323E-01,.7190E-01,.5694E-03,&
 .1309E-03,.4037E-03,.6544E-03,.1651E-02,.2718E-02,.2591E-02,.3298E-02,.1354E-01,.7388E-01,.5731E-03,&
 .1318E-03,.4051E-03,.6577E-03,.1657E-02,.2745E-02,.2625E-02,.3384E-02,.1385E-01,.7586E-01,.5767E-03,&
 .1329E-03,.4072E-03,.6619E-03,.1665E-02,.2774E-02,.2663E-02,.3480E-02,.1420E-01,.7804E-01,.5812E-03,&
 .1339E-03,.4094E-03,.6661E-03,.1672E-02,.2804E-02,.2701E-02,.3576E-02,.1454E-01,.8021E-01,.5857E-03,&
 .1350E-03,.4115E-03,.6703E-03,.1680E-02,.2833E-02,.2739E-02,.3672E-02,.1489E-01,.8238E-01,.5902E-03,&
 .1360E-03,.4136E-03,.6745E-03,.1688E-02,.2863E-02,.2778E-02,.3768E-02,.1523E-01,.8455E-01,.5947E-03,&
 .1371E-03,.4157E-03,.6787E-03,.1695E-02,.2893E-02,.2816E-02,.3864E-02,.1558E-01,.8672E-01,.5992E-03,&
 .1383E-03,.4186E-03,.6839E-03,.1705E-02,.2925E-02,.2858E-02,.3968E-02,.1594E-01,.8898E-01,.6046E-03,&
 .1395E-03,.4214E-03,.6892E-03,.1715E-02,.2958E-02,.2901E-02,.4072E-02,.1630E-01,.9124E-01,.6100E-03,&
 .1407E-03,.4243E-03,.6944E-03,.1724E-02,.2991E-02,.2943E-02,.4176E-02,.1667E-01,.9350E-01,.6154E-03,&
 .1420E-03,.4271E-03,.6997E-03,.1734E-02,.3024E-02,.2986E-02,.4280E-02,.1703E-01,.9576E-01,.6208E-03,&
 .1432E-03,.4300E-03,.7050E-03,.1744E-02,.3056E-02,.3028E-02,.4383E-02,.1739E-01,.9802E-01,.6262E-03,&
 .1445E-03,.4333E-03,.7110E-03,.1754E-02,.3092E-02,.3075E-02,.4496E-02,.1778E-01,.1004E+00,.6322E-03,&
 .1458E-03,.4367E-03,.7170E-03,.1765E-02,.3128E-02,.3121E-02,.4609E-02,.1817E-01,.1028E+00,.6383E-03,&
 .1472E-03,.4401E-03,.7230E-03,.1776E-02,.3163E-02,.3168E-02,.4722E-02,.1855E-01,.1051E+00,.6443E-03,&
 .1485E-03,.4435E-03,.7290E-03,.1787E-02,.3199E-02,.3214E-02,.4834E-02,.1894E-01,.1075E+00,.6504E-03,&
 .1498E-03,.4468E-03,.7351E-03,.1798E-02,.3234E-02,.3261E-02,.4947E-02,.1933E-01,.1099E+00,.6564E-03,&
 .1513E-03,.4505E-03,.7416E-03,.1809E-02,.3273E-02,.3313E-02,.5074E-02,.1975E-01,.1125E+00,.6630E-03,&
 .1527E-03,.4542E-03,.7481E-03,.1821E-02,.3311E-02,.3365E-02,.5201E-02,.2018E-01,.1151E+00,.6695E-03,&
 .1541E-03,.4579E-03,.7546E-03,.1832E-02,.3349E-02,.3416E-02,.5328E-02,.2060E-01,.1177E+00,.6760E-03,&
 .1556E-03,.4616E-03,.7612E-03,.1844E-02,.3388E-02,.3468E-02,.5454E-02,.2103E-01,.1203E+00,.6826E-03,&
 .1570E-03,.4653E-03,.7677E-03,.1855E-02,.3426E-02,.3520E-02,.5581E-02,.2145E-01,.1229E+00,.6891E-03,&
 .1585E-03,.4694E-03,.7748E-03,.1867E-02,.3467E-02,.3577E-02,.5720E-02,.2191E-01,.1256E+00,.6962E-03,&
 .1601E-03,.4734E-03,.7819E-03,.1880E-02,.3509E-02,.3634E-02,.5859E-02,.2237E-01,.1284E+00,.7032E-03,&
 .1616E-03,.4775E-03,.7890E-03,.1892E-02,.3550E-02,.3691E-02,.5998E-02,.2283E-01,.1311E+00,.7103E-03,&
 .1631E-03,.4816E-03,.7961E-03,.1904E-02,.3591E-02,.3748E-02,.6137E-02,.2329E-01,.1339E+00,.7173E-03,&
 .1647E-03,.4856E-03,.8033E-03,.1916E-02,.3633E-02,.3804E-02,.6276E-02,.2374E-01,.1366E+00,.7244E-03,&
 .1661E-03,.4893E-03,.8100E-03,.1924E-02,.3679E-02,.3880E-02,.6482E-02,.2439E-01,.1406E+00,.7314E-03,&
 .1676E-03,.4929E-03,.8167E-03,.1932E-02,.3725E-02,.3955E-02,.6689E-02,.2503E-01,.1446E+00,.7385E-03,&
 .1690E-03,.4966E-03,.8234E-03,.1939E-02,.3772E-02,.4030E-02,.6895E-02,.2568E-01,.1486E+00,.7455E-03,&
 .1705E-03,.5003E-03,.8301E-03,.1947E-02,.3818E-02,.4106E-02,.7102E-02,.2632E-01,.1527E+00,.7526E-03,&
 .1719E-03,.5039E-03,.8368E-03,.1955E-02,.3864E-02,.4181E-02,.7308E-02,.2696E-01,.1567E+00,.7596E-03,&
 .1735E-03,.5083E-03,.8446E-03,.1964E-02,.3917E-02,.4267E-02,.7537E-02,.2766E-01,.1609E+00,.7676E-03,&
 .1752E-03,.5126E-03,.8524E-03,.1974E-02,.3969E-02,.4354E-02,.7765E-02,.2836E-01,.1651E+00,.7755E-03,&
 .1768E-03,.5170E-03,.8602E-03,.1984E-02,.4022E-02,.4440E-02,.7994E-02,.2906E-01,.1694E+00,.7835E-03,&
 .1785E-03,.5214E-03,.8680E-03,.1993E-02,.4074E-02,.4526E-02,.8222E-02,.2976E-01,.1736E+00,.7914E-03,&
 .1801E-03,.5257E-03,.8757E-03,.2003E-02,.4127E-02,.4613E-02,.8451E-02,.3045E-01,.1779E+00,.7994E-03,&
 .1818E-03,.5303E-03,.8840E-03,.2013E-02,.4184E-02,.4710E-02,.8710E-02,.3123E-01,.1825E+00,.8078E-03,&
 .1836E-03,.5350E-03,.8925E-03,.2023E-02,.4242E-02,.4811E-02,.8976E-02,.3202E-01,.1873E+00,.8164E-03,&
 .1854E-03,.5399E-03,.9012E-03,.2034E-02,.4302E-02,.4914E-02,.9245E-02,.3282E-01,.1920E+00,.8251E-03,&
 .1871E-03,.5444E-03,.9096E-03,.2039E-02,.4371E-02,.5046E-02,.9608E-02,.3387E-01,.1984E+00,.8340E-03,&
 .1889E-03,.5492E-03,.9185E-03,.2045E-02,.4442E-02,.5183E-02,.9980E-02,.3494E-01,.2049E+00,.8431E-03,&
 .1907E-03,.5542E-03,.9276E-03,.2053E-02,.4516E-02,.5325E-02,.1036E-01,.3603E-01,.2114E+00,.8525E-03,&
 .1926E-03,.5591E-03,.9369E-03,.2056E-02,.4601E-02,.5502E-02,.1084E-01,.3738E-01,.2196E+00,.8624E-03,&
 .1945E-03,.5644E-03,.9469E-03,.2062E-02,.4690E-02,.5685E-02,.1133E-01,.3874E-01,.2278E+00,.8726E-03,&
 .1966E-03,.5699E-03,.9572E-03,.2064E-02,.4792E-02,.5909E-02,.1192E-01,.4039E-01,.2376E+00,.8836E-03,&
 .1987E-03,.5757E-03,.9685E-03,.2066E-02,.4912E-02,.6177E-02,.1263E-01,.4230E-01,.2490E+00,.8954E-03,&
 .2010E-03,.5820E-03,.9804E-03,.2070E-02,.5037E-02,.6457E-02,.1334E-01,.4423E-01,.2604E+00,.9077E-03,&
 .2035E-03,.5890E-03,.9939E-03,.2072E-02,.5194E-02,.6825E-02,.1427E-01,.4669E-01,.2747E+00,.9217E-03,&
 .2062E-03,.5966E-03,.1008E-02,.2077E-02,.5359E-02,.7209E-02,.1521E-01,.4917E-01,.2888E+00,.9363E-03,&
 .2093E-03,.6053E-03,.1025E-02,.2083E-02,.5560E-02,.7692E-02,.1635E-01,.5215E-01,.3055E+00,.9529E-03,&
 .2129E-03,.6157E-03,.1045E-02,.2089E-02,.5831E-02,.8365E-02,.1789E-01,.5609E-01,.3271E+00,.9730E-03,&
 .2171E-03,.6277E-03,.1068E-02,.2101E-02,.6145E-02,.9153E-02,.1962E-01,.6045E-01,.3500E+00,.9955E-03,&
 .2223E-03,.6429E-03,.1096E-02,.2118E-02,.6564E-02,.1023E-01,.2186E-01,.6598E-01,.3780E+00,.1023E-02,&
 .2297E-03,.6647E-03,.1137E-02,.2149E-02,.7207E-02,.1193E-01,.2518E-01,.7402E-01,.4161E+00,.1063E-02,&
 .2423E-03,.7019E-03,.1206E-02,.2220E-02,.8325E-02,.1498E-01,.3063E-01,.8678E-01,.4703E+00,.1128E-02/
 data (((w0_lw(ai,k,nh),ai= 2, 2),k=1,nwl_lw),nh=0,99)/ &
 .1078E-04,.3249E-04,.9802E-04,.2051E-03,.3114E-03,.4109E-03,.5443E-03,.1016E-02,.3002E-02,.6508E-04,&
 .1083E-04,.3265E-04,.9852E-04,.2062E-03,.3130E-03,.4130E-03,.5471E-03,.1021E-02,.3018E-02,.6541E-04,&
 .1089E-04,.3282E-04,.9902E-04,.2072E-03,.3146E-03,.4151E-03,.5499E-03,.1026E-02,.3034E-02,.6574E-04,&
 .1094E-04,.3299E-04,.9951E-04,.2083E-03,.3162E-03,.4172E-03,.5527E-03,.1032E-02,.3049E-02,.6608E-04,&
 .1099E-04,.3315E-04,.1000E-03,.2093E-03,.3178E-03,.4193E-03,.5555E-03,.1037E-02,.3065E-02,.6641E-04,&
 .1105E-04,.3332E-04,.1005E-03,.2104E-03,.3194E-03,.4215E-03,.5583E-03,.1042E-02,.3080E-02,.6674E-04,&
 .1110E-04,.3347E-04,.1010E-03,.2114E-03,.3209E-03,.4235E-03,.5609E-03,.1047E-02,.3095E-02,.6705E-04,&
 .1115E-04,.3363E-04,.1015E-03,.2124E-03,.3224E-03,.4254E-03,.5636E-03,.1052E-02,.3110E-02,.6736E-04,&
 .1120E-04,.3378E-04,.1019E-03,.2133E-03,.3239E-03,.4274E-03,.5663E-03,.1057E-02,.3124E-02,.6767E-04,&
 .1126E-04,.3394E-04,.1024E-03,.2143E-03,.3254E-03,.4294E-03,.5689E-03,.1062E-02,.3139E-02,.6799E-04,&
 .1131E-04,.3409E-04,.1029E-03,.2153E-03,.3269E-03,.4314E-03,.5716E-03,.1067E-02,.3154E-02,.6830E-04,&
 .1136E-04,.3424E-04,.1033E-03,.2162E-03,.3283E-03,.4333E-03,.5740E-03,.1071E-02,.3168E-02,.6859E-04,&
 .1140E-04,.3439E-04,.1038E-03,.2172E-03,.3298E-03,.4352E-03,.5765E-03,.1076E-02,.3181E-02,.6888E-04,&
 .1145E-04,.3453E-04,.1042E-03,.2181E-03,.3312E-03,.4370E-03,.5790E-03,.1081E-02,.3195E-02,.6918E-04,&
 .1150E-04,.3468E-04,.1046E-03,.2190E-03,.3326E-03,.4389E-03,.5815E-03,.1085E-02,.3209E-02,.6947E-04,&
 .1155E-04,.3482E-04,.1051E-03,.2199E-03,.3340E-03,.4408E-03,.5839E-03,.1090E-02,.3222E-02,.6977E-04,&
 .1159E-04,.3496E-04,.1055E-03,.2208E-03,.3353E-03,.4425E-03,.5863E-03,.1094E-02,.3235E-02,.7004E-04,&
 .1164E-04,.3510E-04,.1059E-03,.2217E-03,.3367E-03,.4443E-03,.5886E-03,.1099E-02,.3248E-02,.7032E-04,&
 .1168E-04,.3524E-04,.1063E-03,.2226E-03,.3380E-03,.4461E-03,.5910E-03,.1103E-02,.3261E-02,.7059E-04,&
 .1173E-04,.3537E-04,.1067E-03,.2235E-03,.3393E-03,.4478E-03,.5933E-03,.1108E-02,.3274E-02,.7087E-04,&
 .1178E-04,.3551E-04,.1072E-03,.2243E-03,.3407E-03,.4496E-03,.5956E-03,.1112E-02,.3287E-02,.7114E-04,&
 .1182E-04,.3564E-04,.1075E-03,.2252E-03,.3419E-03,.4512E-03,.5978E-03,.1116E-02,.3299E-02,.7140E-04,&
 .1186E-04,.3577E-04,.1079E-03,.2260E-03,.3432E-03,.4529E-03,.6000E-03,.1120E-02,.3311E-02,.7166E-04,&
 .1190E-04,.3590E-04,.1083E-03,.2268E-03,.3444E-03,.4545E-03,.6022E-03,.1124E-02,.3323E-02,.7191E-04,&
 .1195E-04,.3603E-04,.1087E-03,.2276E-03,.3456E-03,.4562E-03,.6044E-03,.1129E-02,.3335E-02,.7217E-04,&
 .1199E-04,.3615E-04,.1091E-03,.2284E-03,.3469E-03,.4578E-03,.6066E-03,.1133E-02,.3347E-02,.7243E-04,&
 .1203E-04,.3627E-04,.1095E-03,.2292E-03,.3481E-03,.4594E-03,.6087E-03,.1137E-02,.3358E-02,.7267E-04,&
 .1207E-04,.3639E-04,.1098E-03,.2300E-03,.3492E-03,.4610E-03,.6108E-03,.1140E-02,.3370E-02,.7292E-04,&
 .1211E-04,.3651E-04,.1102E-03,.2307E-03,.3504E-03,.4625E-03,.6128E-03,.1144E-02,.3381E-02,.7316E-04,&
 .1215E-04,.3663E-04,.1106E-03,.2315E-03,.3516E-03,.4641E-03,.6149E-03,.1148E-02,.3392E-02,.7340E-04,&
 .1219E-04,.3675E-04,.1109E-03,.2323E-03,.3528E-03,.4656E-03,.6170E-03,.1152E-02,.3404E-02,.7365E-04,&
 .1223E-04,.3687E-04,.1113E-03,.2330E-03,.3539E-03,.4671E-03,.6189E-03,.1156E-02,.3414E-02,.7387E-04,&
 .1226E-04,.3698E-04,.1116E-03,.2337E-03,.3550E-03,.4686E-03,.6208E-03,.1159E-02,.3425E-02,.7410E-04,&
 .1230E-04,.3709E-04,.1120E-03,.2345E-03,.3561E-03,.4700E-03,.6228E-03,.1163E-02,.3436E-02,.7433E-04,&
 .1234E-04,.3721E-04,.1123E-03,.2352E-03,.3572E-03,.4715E-03,.6247E-03,.1167E-02,.3446E-02,.7455E-04,&
 .1237E-04,.3732E-04,.1127E-03,.2359E-03,.3583E-03,.4729E-03,.6266E-03,.1170E-02,.3457E-02,.7478E-04,&
 .1241E-04,.3743E-04,.1130E-03,.2366E-03,.3593E-03,.4743E-03,.6285E-03,.1174E-02,.3467E-02,.7499E-04,&
 .1244E-04,.3753E-04,.1133E-03,.2373E-03,.3604E-03,.4757E-03,.6303E-03,.1177E-02,.3477E-02,.7521E-04,&
 .1248E-04,.3764E-04,.1136E-03,.2379E-03,.3614E-03,.4770E-03,.6321E-03,.1181E-02,.3487E-02,.7542E-04,&
 .1251E-04,.3775E-04,.1139E-03,.2386E-03,.3624E-03,.4784E-03,.6339E-03,.1184E-02,.3497E-02,.7563E-04,&
 .1255E-04,.3785E-04,.1142E-03,.2393E-03,.3635E-03,.4798E-03,.6357E-03,.1187E-02,.3507E-02,.7585E-04,&
 .1258E-04,.3795E-04,.1146E-03,.2399E-03,.3644E-03,.4811E-03,.6375E-03,.1191E-02,.3516E-02,.7605E-04,&
 .1262E-04,.3805E-04,.1149E-03,.2406E-03,.3654E-03,.4823E-03,.6392E-03,.1194E-02,.3525E-02,.7625E-04,&
 .1265E-04,.3815E-04,.1152E-03,.2412E-03,.3664E-03,.4836E-03,.6409E-03,.1197E-02,.3534E-02,.7645E-04,&
 .1268E-04,.3825E-04,.1155E-03,.2418E-03,.3674E-03,.4849E-03,.6426E-03,.1200E-02,.3544E-02,.7665E-04,&
 .1272E-04,.3835E-04,.1158E-03,.2425E-03,.3683E-03,.4862E-03,.6444E-03,.1203E-02,.3553E-02,.7685E-04,&
 .1275E-04,.3845E-04,.1161E-03,.2431E-03,.3693E-03,.4874E-03,.6460E-03,.1207E-02,.3562E-02,.7704E-04,&
 .1278E-04,.3854E-04,.1163E-03,.2437E-03,.3702E-03,.4886E-03,.6476E-03,.1210E-02,.3570E-02,.7723E-04,&
 .1281E-04,.3863E-04,.1166E-03,.2443E-03,.3711E-03,.4898E-03,.6492E-03,.1213E-02,.3579E-02,.7741E-04,&
 .1284E-04,.3873E-04,.1169E-03,.2449E-03,.3720E-03,.4911E-03,.6508E-03,.1216E-02,.3588E-02,.7760E-04,&
 .1287E-04,.3882E-04,.1172E-03,.2454E-03,.3729E-03,.4923E-03,.6524E-03,.1219E-02,.3596E-02,.7779E-04,&
 .1290E-04,.3891E-04,.1175E-03,.2460E-03,.3738E-03,.4934E-03,.6539E-03,.1222E-02,.3604E-02,.7797E-04,&
 .1293E-04,.3900E-04,.1177E-03,.2466E-03,.3746E-03,.4946E-03,.6554E-03,.1224E-02,.3613E-02,.7814E-04,&
 .1296E-04,.3908E-04,.1180E-03,.2471E-03,.3755E-03,.4957E-03,.6569E-03,.1227E-02,.3621E-02,.7832E-04,&
 .1299E-04,.3917E-04,.1183E-03,.2477E-03,.3763E-03,.4968E-03,.6584E-03,.1230E-02,.3629E-02,.7850E-04,&
 .1302E-04,.3926E-04,.1185E-03,.2483E-03,.3772E-03,.4980E-03,.6600E-03,.1233E-02,.3637E-02,.7867E-04,&
 .1304E-04,.3933E-04,.1186E-03,.2485E-03,.3778E-03,.4990E-03,.6615E-03,.1236E-02,.3649E-02,.7878E-04,&
 .1307E-04,.3941E-04,.1187E-03,.2487E-03,.3785E-03,.5000E-03,.6631E-03,.1239E-02,.3662E-02,.7888E-04,&
 .1309E-04,.3948E-04,.1188E-03,.2489E-03,.3791E-03,.5010E-03,.6647E-03,.1243E-02,.3674E-02,.7898E-04,&
 .1312E-04,.3956E-04,.1188E-03,.2491E-03,.3797E-03,.5021E-03,.6663E-03,.1246E-02,.3687E-02,.7909E-04,&
 .1314E-04,.3963E-04,.1189E-03,.2493E-03,.3804E-03,.5031E-03,.6679E-03,.1249E-02,.3699E-02,.7919E-04,&
 .1317E-04,.3971E-04,.1191E-03,.2498E-03,.3811E-03,.5041E-03,.6692E-03,.1252E-02,.3707E-02,.7935E-04,&
 .1319E-04,.3979E-04,.1194E-03,.2503E-03,.3819E-03,.5051E-03,.6706E-03,.1254E-02,.3714E-02,.7950E-04,&
 .1322E-04,.3987E-04,.1196E-03,.2508E-03,.3827E-03,.5061E-03,.6719E-03,.1257E-02,.3721E-02,.7966E-04,&
 .1325E-04,.3995E-04,.1199E-03,.2513E-03,.3834E-03,.5072E-03,.6733E-03,.1260E-02,.3728E-02,.7982E-04,&
 .1327E-04,.4003E-04,.1201E-03,.2518E-03,.3842E-03,.5082E-03,.6746E-03,.1262E-02,.3735E-02,.7997E-04,&
 .1330E-04,.4009E-04,.1199E-03,.2514E-03,.3846E-03,.5092E-03,.6767E-03,.1267E-02,.3760E-02,.7997E-04,&
 .1332E-04,.4016E-04,.1196E-03,.2510E-03,.3849E-03,.5103E-03,.6788E-03,.1272E-02,.3784E-02,.7996E-04,&
 .1335E-04,.4023E-04,.1193E-03,.2506E-03,.3853E-03,.5113E-03,.6809E-03,.1276E-02,.3808E-02,.7996E-04,&
 .1337E-04,.4029E-04,.1191E-03,.2502E-03,.3857E-03,.5124E-03,.6830E-03,.1281E-02,.3832E-02,.7995E-04,&
 .1340E-04,.4036E-04,.1188E-03,.2498E-03,.3860E-03,.5134E-03,.6851E-03,.1286E-02,.3856E-02,.7995E-04,&
 .1345E-04,.4049E-04,.1181E-03,.2484E-03,.3866E-03,.5158E-03,.6902E-03,.1298E-02,.3922E-02,.7985E-04,&
 .1350E-04,.4062E-04,.1173E-03,.2470E-03,.3872E-03,.5182E-03,.6953E-03,.1310E-02,.3989E-02,.7976E-04,&
 .1355E-04,.4075E-04,.1165E-03,.2457E-03,.3878E-03,.5206E-03,.7004E-03,.1322E-02,.4055E-02,.7967E-04,&
 .1360E-04,.4088E-04,.1158E-03,.2443E-03,.3884E-03,.5229E-03,.7055E-03,.1334E-02,.4121E-02,.7957E-04,&
 .1365E-04,.4102E-04,.1150E-03,.2429E-03,.3890E-03,.5253E-03,.7106E-03,.1346E-02,.4188E-02,.7948E-04,&
 .1375E-04,.4130E-04,.1145E-03,.2420E-03,.3910E-03,.5302E-03,.7199E-03,.1366E-02,.4297E-02,.7962E-04,&
 .1386E-04,.4158E-04,.1139E-03,.2410E-03,.3930E-03,.5351E-03,.7292E-03,.1387E-02,.4407E-02,.7976E-04,&
 .1396E-04,.4186E-04,.1134E-03,.2400E-03,.3951E-03,.5400E-03,.7384E-03,.1407E-02,.4516E-02,.7990E-04,&
 .1406E-04,.4214E-04,.1129E-03,.2390E-03,.3971E-03,.5449E-03,.7477E-03,.1428E-02,.4626E-02,.8004E-04,&
 .1417E-04,.4242E-04,.1123E-03,.2380E-03,.3991E-03,.5498E-03,.7569E-03,.1448E-02,.4735E-02,.8018E-04,&
 .1435E-04,.4293E-04,.1118E-03,.2370E-03,.4032E-03,.5588E-03,.7733E-03,.1484E-02,.4928E-02,.8058E-04,&
 .1450E-04,.4332E-04,.1116E-03,.2367E-03,.4065E-03,.5658E-03,.7857E-03,.1511E-02,.5069E-02,.8096E-04,&
 .1471E-04,.4392E-04,.1114E-03,.2362E-03,.4116E-03,.5763E-03,.8047E-03,.1552E-02,.5288E-02,.8155E-04,&
 .1487E-04,.4437E-04,.1115E-03,.2362E-03,.4156E-03,.5843E-03,.8188E-03,.1582E-02,.5447E-02,.8205E-04,&
 .1512E-04,.4505E-04,.1115E-03,.2362E-03,.4215E-03,.5965E-03,.8403E-03,.1628E-02,.5695E-02,.8281E-04,&
 .1537E-04,.4577E-04,.1117E-03,.2363E-03,.4281E-03,.6096E-03,.8632E-03,.1677E-02,.5961E-02,.8366E-04,&
 .1556E-04,.4632E-04,.1120E-03,.2368E-03,.4331E-03,.6193E-03,.8803E-03,.1713E-02,.6152E-02,.8435E-04,&
 .1585E-04,.4712E-04,.1124E-03,.2373E-03,.4406E-03,.6340E-03,.9057E-03,.1768E-02,.6449E-02,.8535E-04,&
 .1606E-04,.4771E-04,.1129E-03,.2380E-03,.4462E-03,.6448E-03,.9246E-03,.1808E-02,.6664E-02,.8614E-04,&
 .1637E-04,.4859E-04,.1135E-03,.2389E-03,.4546E-03,.6611E-03,.9529E-03,.1868E-02,.6994E-02,.8729E-04,&
 .1669E-04,.4950E-04,.1142E-03,.2400E-03,.4634E-03,.6783E-03,.9830E-03,.1932E-02,.7347E-02,.8853E-04,&
 .1703E-04,.5046E-04,.1151E-03,.2412E-03,.4728E-03,.6965E-03,.1015E-02,.1999E-02,.7721E-02,.8985E-04,&
 .1738E-04,.5146E-04,.1161E-03,.2427E-03,.4828E-03,.7157E-03,.1048E-02,.2070E-02,.8118E-02,.9125E-04,&
 .1785E-04,.5281E-04,.1174E-03,.2447E-03,.4964E-03,.7422E-03,.1094E-02,.2168E-02,.8679E-02,.9315E-04,&
 .1835E-04,.5422E-04,.1190E-03,.2470E-03,.5109E-03,.7704E-03,.1143E-02,.2273E-02,.9281E-02,.9517E-04,&
 .1898E-04,.5604E-04,.1211E-03,.2500E-03,.5300E-03,.8076E-03,.1208E-02,.2412E-02,.1009E-01,.9782E-04,&
 .1990E-04,.5868E-04,.1242E-03,.2547E-03,.5583E-03,.8632E-03,.1307E-02,.2622E-02,.1134E-01,.1017E-03,&
 .2102E-04,.6187E-04,.1283E-03,.2608E-03,.5936E-03,.9326E-03,.1429E-02,.2886E-02,.1295E-01,.1064E-03,&
 .2396E-04,.7035E-04,.1400E-03,.2783E-03,.6926E-03,.1131E-02,.1783E-02,.3655E-02,.1784E-01,.1193E-03/
 data (((w0_lw(ai,k,nh),ai= 3, 3),k=1,nwl_lw),nh=0,99)/ &
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03/
 data (((w0_lw(ai,k,nh),ai= 4, 4),k=1,nwl_lw),nh=0,99)/ &
 .3446E-04,.2170E-03,.7401E-03,.3198E-02,.3693E-02,.3257E-02,.1315E-02,.1798E-01,.1881E+00,.4705E-03,&
 .3481E-04,.2162E-03,.7142E-03,.3142E-02,.3712E-02,.3279E-02,.1349E-02,.1804E-01,.1893E+00,.4652E-03,&
 .3517E-04,.2153E-03,.6883E-03,.3086E-02,.3731E-02,.3300E-02,.1382E-02,.1809E-01,.1905E+00,.4599E-03,&
 .3552E-04,.2145E-03,.6624E-03,.3031E-02,.3749E-02,.3322E-02,.1416E-02,.1814E-01,.1917E+00,.4546E-03,&
 .3587E-04,.2136E-03,.6365E-03,.2975E-02,.3768E-02,.3343E-02,.1450E-02,.1819E-01,.1929E+00,.4493E-03,&
 .3623E-04,.2128E-03,.6106E-03,.2919E-02,.3787E-02,.3365E-02,.1484E-02,.1825E-01,.1941E+00,.4440E-03,&
 .3660E-04,.2123E-03,.5955E-03,.2880E-02,.3806E-02,.3388E-02,.1521E-02,.1836E-01,.1954E+00,.4402E-03,&
 .3697E-04,.2119E-03,.5803E-03,.2841E-02,.3825E-02,.3411E-02,.1558E-02,.1847E-01,.1968E+00,.4365E-03,&
 .3734E-04,.2114E-03,.5652E-03,.2801E-02,.3844E-02,.3433E-02,.1595E-02,.1858E-01,.1982E+00,.4328E-03,&
 .3772E-04,.2110E-03,.5501E-03,.2762E-02,.3863E-02,.3456E-02,.1632E-02,.1869E-01,.1995E+00,.4290E-03,&
 .3809E-04,.2105E-03,.5350E-03,.2722E-02,.3882E-02,.3479E-02,.1669E-02,.1880E-01,.2009E+00,.4253E-03,&
 .3848E-04,.2104E-03,.5254E-03,.2693E-02,.3902E-02,.3503E-02,.1709E-02,.1894E-01,.2024E+00,.4227E-03,&
 .3887E-04,.2103E-03,.5158E-03,.2663E-02,.3922E-02,.3527E-02,.1750E-02,.1909E-01,.2039E+00,.4202E-03,&
 .3927E-04,.2101E-03,.5061E-03,.2634E-02,.3941E-02,.3551E-02,.1790E-02,.1924E-01,.2054E+00,.4176E-03,&
 .3966E-04,.2100E-03,.4965E-03,.2605E-02,.3961E-02,.3575E-02,.1831E-02,.1938E-01,.2068E+00,.4150E-03,&
 .4005E-04,.2098E-03,.4869E-03,.2575E-02,.3981E-02,.3599E-02,.1871E-02,.1953E-01,.2083E+00,.4124E-03,&
 .4046E-04,.2099E-03,.4805E-03,.2553E-02,.4001E-02,.3624E-02,.1915E-02,.1970E-01,.2099E+00,.4107E-03,&
 .4087E-04,.2101E-03,.4741E-03,.2530E-02,.4021E-02,.3650E-02,.1960E-02,.1987E-01,.2114E+00,.4090E-03,&
 .4129E-04,.2102E-03,.4677E-03,.2507E-02,.4041E-02,.3675E-02,.2004E-02,.2004E-01,.2130E+00,.4073E-03,&
 .4170E-04,.2103E-03,.4613E-03,.2484E-02,.4061E-02,.3701E-02,.2048E-02,.2022E-01,.2146E+00,.4056E-03,&
 .4211E-04,.2104E-03,.4549E-03,.2462E-02,.4082E-02,.3726E-02,.2092E-02,.2039E-01,.2161E+00,.4039E-03,&
 .4254E-04,.2107E-03,.4506E-03,.2444E-02,.4102E-02,.3753E-02,.2140E-02,.2058E-01,.2177E+00,.4028E-03,&
 .4298E-04,.2111E-03,.4463E-03,.2426E-02,.4123E-02,.3780E-02,.2188E-02,.2077E-01,.2194E+00,.4018E-03,&
 .4341E-04,.2114E-03,.4420E-03,.2408E-02,.4144E-02,.3807E-02,.2235E-02,.2096E-01,.2210E+00,.4008E-03,&
 .4384E-04,.2117E-03,.4377E-03,.2390E-02,.4165E-02,.3834E-02,.2283E-02,.2116E-01,.2226E+00,.3998E-03,&
 .4428E-04,.2120E-03,.4334E-03,.2373E-02,.4186E-02,.3860E-02,.2331E-02,.2135E-01,.2242E+00,.3988E-03,&
 .4473E-04,.2126E-03,.4305E-03,.2358E-02,.4207E-02,.3889E-02,.2383E-02,.2156E-01,.2259E+00,.3983E-03,&
 .4519E-04,.2131E-03,.4276E-03,.2344E-02,.4228E-02,.3917E-02,.2435E-02,.2177E-01,.2276E+00,.3978E-03,&
 .4564E-04,.2136E-03,.4248E-03,.2330E-02,.4250E-02,.3946E-02,.2487E-02,.2198E-01,.2292E+00,.3974E-03,&
 .4610E-04,.2141E-03,.4219E-03,.2316E-02,.4271E-02,.3974E-02,.2538E-02,.2219E-01,.2309E+00,.3969E-03,&
 .4655E-04,.2146E-03,.4190E-03,.2302E-02,.4293E-02,.4003E-02,.2590E-02,.2240E-01,.2326E+00,.3964E-03,&
 .4703E-04,.2153E-03,.4172E-03,.2290E-02,.4315E-02,.4033E-02,.2646E-02,.2262E-01,.2343E+00,.3964E-03,&
 .4751E-04,.2160E-03,.4154E-03,.2279E-02,.4337E-02,.4063E-02,.2702E-02,.2284E-01,.2360E+00,.3964E-03,&
 .4798E-04,.2167E-03,.4136E-03,.2268E-02,.4359E-02,.4093E-02,.2758E-02,.2307E-01,.2377E+00,.3964E-03,&
 .4846E-04,.2173E-03,.4118E-03,.2256E-02,.4381E-02,.4123E-02,.2813E-02,.2329E-01,.2394E+00,.3964E-03,&
 .4894E-04,.2180E-03,.4100E-03,.2245E-02,.4404E-02,.4153E-02,.2869E-02,.2352E-01,.2411E+00,.3964E-03,&
 .4943E-04,.2189E-03,.4090E-03,.2236E-02,.4426E-02,.4185E-02,.2929E-02,.2375E-01,.2428E+00,.3968E-03,&
 .4993E-04,.2197E-03,.4081E-03,.2227E-02,.4449E-02,.4217E-02,.2989E-02,.2399E-01,.2446E+00,.3972E-03,&
 .5043E-04,.2205E-03,.4071E-03,.2217E-02,.4472E-02,.4249E-02,.3049E-02,.2423E-01,.2463E+00,.3976E-03,&
 .5093E-04,.2214E-03,.4061E-03,.2208E-02,.4495E-02,.4280E-02,.3109E-02,.2447E-01,.2481E+00,.3980E-03,&
 .5143E-04,.2222E-03,.4051E-03,.2199E-02,.4518E-02,.4312E-02,.3169E-02,.2471E-01,.2498E+00,.3984E-03,&
 .5196E-04,.2232E-03,.4048E-03,.2192E-02,.4542E-02,.4346E-02,.3233E-02,.2496E-01,.2516E+00,.3991E-03,&
 .5248E-04,.2241E-03,.4045E-03,.2185E-02,.4565E-02,.4379E-02,.3297E-02,.2521E-01,.2533E+00,.3999E-03,&
 .5300E-04,.2251E-03,.4041E-03,.2178E-02,.4589E-02,.4413E-02,.3362E-02,.2546E-01,.2551E+00,.4006E-03,&
 .5353E-04,.2261E-03,.4038E-03,.2170E-02,.4613E-02,.4447E-02,.3426E-02,.2571E-01,.2568E+00,.4014E-03,&
 .5405E-04,.2271E-03,.4035E-03,.2163E-02,.4636E-02,.4480E-02,.3490E-02,.2596E-01,.2586E+00,.4021E-03,&
 .5460E-04,.2282E-03,.4037E-03,.2158E-02,.4661E-02,.4516E-02,.3559E-02,.2623E-01,.2604E+00,.4032E-03,&
 .5514E-04,.2293E-03,.4039E-03,.2152E-02,.4685E-02,.4551E-02,.3627E-02,.2649E-01,.2622E+00,.4043E-03,&
 .5569E-04,.2304E-03,.4041E-03,.2146E-02,.4709E-02,.4587E-02,.3696E-02,.2675E-01,.2639E+00,.4053E-03,&
 .5623E-04,.2315E-03,.4043E-03,.2141E-02,.4734E-02,.4622E-02,.3765E-02,.2702E-01,.2657E+00,.4064E-03,&
 .5678E-04,.2326E-03,.4046E-03,.2135E-02,.4758E-02,.4658E-02,.3833E-02,.2728E-01,.2675E+00,.4075E-03,&
 .5735E-04,.2336E-03,.4046E-03,.2126E-02,.4779E-02,.4693E-02,.3913E-02,.2756E-01,.2693E+00,.4083E-03,&
 .5792E-04,.2346E-03,.4047E-03,.2117E-02,.4800E-02,.4729E-02,.3993E-02,.2784E-01,.2711E+00,.4091E-03,&
 .5849E-04,.2356E-03,.4047E-03,.2108E-02,.4821E-02,.4765E-02,.4074E-02,.2812E-01,.2729E+00,.4099E-03,&
 .5906E-04,.2366E-03,.4048E-03,.2099E-02,.4842E-02,.4800E-02,.4154E-02,.2840E-01,.2747E+00,.4107E-03,&
 .5963E-04,.2377E-03,.4048E-03,.2090E-02,.4863E-02,.4836E-02,.4234E-02,.2868E-01,.2765E+00,.4115E-03,&
 .6023E-04,.2388E-03,.4055E-03,.2083E-02,.4885E-02,.4875E-02,.4319E-02,.2897E-01,.2784E+00,.4128E-03,&
 .6084E-04,.2400E-03,.4061E-03,.2076E-02,.4907E-02,.4913E-02,.4405E-02,.2927E-01,.2802E+00,.4140E-03,&
 .6144E-04,.2412E-03,.4068E-03,.2069E-02,.4929E-02,.4951E-02,.4490E-02,.2956E-01,.2821E+00,.4152E-03,&
 .6204E-04,.2424E-03,.4074E-03,.2062E-02,.4952E-02,.4990E-02,.4576E-02,.2985E-01,.2839E+00,.4164E-03,&
 .6264E-04,.2435E-03,.4080E-03,.2055E-02,.4974E-02,.5028E-02,.4662E-02,.3015E-01,.2857E+00,.4176E-03,&
 .6326E-04,.2450E-03,.4096E-03,.2053E-02,.5001E-02,.5071E-02,.4745E-02,.3045E-01,.2876E+00,.4196E-03,&
 .6389E-04,.2465E-03,.4112E-03,.2052E-02,.5028E-02,.5113E-02,.4828E-02,.3075E-01,.2894E+00,.4215E-03,&
 .6452E-04,.2480E-03,.4127E-03,.2051E-02,.5056E-02,.5155E-02,.4911E-02,.3105E-01,.2912E+00,.4235E-03,&
 .6514E-04,.2495E-03,.4143E-03,.2049E-02,.5083E-02,.5197E-02,.4994E-02,.3135E-01,.2930E+00,.4254E-03,&
 .6577E-04,.2510E-03,.4159E-03,.2048E-02,.5111E-02,.5239E-02,.5077E-02,.3165E-01,.2948E+00,.4274E-03,&
 .6643E-04,.2525E-03,.4174E-03,.2044E-02,.5135E-02,.5283E-02,.5174E-02,.3197E-01,.2967E+00,.4292E-03,&
 .6709E-04,.2539E-03,.4189E-03,.2040E-02,.5160E-02,.5326E-02,.5270E-02,.3229E-01,.2985E+00,.4310E-03,&
 .6775E-04,.2554E-03,.4203E-03,.2035E-02,.5185E-02,.5370E-02,.5366E-02,.3262E-01,.3004E+00,.4328E-03,&
 .6841E-04,.2569E-03,.4218E-03,.2031E-02,.5210E-02,.5414E-02,.5463E-02,.3294E-01,.3023E+00,.4347E-03,&
 .6907E-04,.2583E-03,.4233E-03,.2027E-02,.5234E-02,.5457E-02,.5559E-02,.3326E-01,.3041E+00,.4365E-03,&
 .6980E-04,.2596E-03,.4244E-03,.2015E-02,.5250E-02,.5503E-02,.5687E-02,.3362E-01,.3061E+00,.4378E-03,&
 .7053E-04,.2609E-03,.4255E-03,.2002E-02,.5266E-02,.5549E-02,.5815E-02,.3399E-01,.3082E+00,.4391E-03,&
 .7126E-04,.2622E-03,.4265E-03,.1990E-02,.5283E-02,.5595E-02,.5943E-02,.3435E-01,.3102E+00,.4404E-03,&
 .7199E-04,.2635E-03,.4276E-03,.1977E-02,.5299E-02,.5641E-02,.6072E-02,.3472E-01,.3122E+00,.4418E-03,&
 .7272E-04,.2647E-03,.4287E-03,.1965E-02,.5315E-02,.5687E-02,.6200E-02,.3508E-01,.3142E+00,.4431E-03,&
 .7355E-04,.2661E-03,.4300E-03,.1948E-02,.5326E-02,.5740E-02,.6364E-02,.3550E-01,.3164E+00,.4445E-03,&
 .7438E-04,.2675E-03,.4314E-03,.1931E-02,.5337E-02,.5793E-02,.6528E-02,.3593E-01,.3187E+00,.4458E-03,&
 .7521E-04,.2688E-03,.4327E-03,.1914E-02,.5348E-02,.5846E-02,.6693E-02,.3635E-01,.3209E+00,.4472E-03,&
 .7604E-04,.2702E-03,.4340E-03,.1897E-02,.5359E-02,.5898E-02,.6857E-02,.3677E-01,.3231E+00,.4486E-03,&
 .7687E-04,.2715E-03,.4354E-03,.1880E-02,.5370E-02,.5951E-02,.7021E-02,.3719E-01,.3254E+00,.4499E-03,&
 .7777E-04,.2730E-03,.4369E-03,.1859E-02,.5377E-02,.6011E-02,.7221E-02,.3767E-01,.3278E+00,.4514E-03,&
 .7872E-04,.2745E-03,.4388E-03,.1840E-02,.5386E-02,.6073E-02,.7419E-02,.3815E-01,.3303E+00,.4531E-03,&
 .7968E-04,.2762E-03,.4410E-03,.1822E-02,.5396E-02,.6138E-02,.7626E-02,.3864E-01,.3327E+00,.4550E-03,&
 .8068E-04,.2780E-03,.4435E-03,.1805E-02,.5407E-02,.6205E-02,.7830E-02,.3914E-01,.3352E+00,.4572E-03,&
 .8178E-04,.2797E-03,.4458E-03,.1780E-02,.5410E-02,.6281E-02,.8088E-02,.3971E-01,.3380E+00,.4591E-03,&
 .8291E-04,.2816E-03,.4486E-03,.1757E-02,.5415E-02,.6359E-02,.8348E-02,.4030E-01,.3409E+00,.4614E-03,&
 .8419E-04,.2836E-03,.4516E-03,.1728E-02,.5414E-02,.6450E-02,.8656E-02,.4096E-01,.3440E+00,.4636E-03,&
 .8548E-04,.2858E-03,.4552E-03,.1702E-02,.5417E-02,.6545E-02,.8972E-02,.4163E-01,.3472E+00,.4664E-03,&
 .8695E-04,.2883E-03,.4593E-03,.1672E-02,.5416E-02,.6653E-02,.9337E-02,.4239E-01,.3507E+00,.4695E-03,&
 .8844E-04,.2910E-03,.4640E-03,.1646E-02,.5419E-02,.6770E-02,.9703E-02,.4317E-01,.3543E+00,.4731E-03,&
 .9012E-04,.2940E-03,.4694E-03,.1617E-02,.5422E-02,.6902E-02,.1012E-01,.4403E-01,.3582E+00,.4773E-03,&
 .9195E-04,.2975E-03,.4758E-03,.1587E-02,.5426E-02,.7053E-02,.1060E-01,.4498E-01,.3624E+00,.4822E-03,&
 .9415E-04,.3017E-03,.4838E-03,.1553E-02,.5429E-02,.7238E-02,.1116E-01,.4611E-01,.3673E+00,.4882E-03,&
 .9652E-04,.3065E-03,.4931E-03,.1523E-02,.5439E-02,.7449E-02,.1178E-01,.4731E-01,.3725E+00,.4954E-03,&
 .9959E-04,.3128E-03,.5056E-03,.1486E-02,.5453E-02,.7729E-02,.1257E-01,.4885E-01,.3790E+00,.5049E-03,&
 .1033E-03,.3210E-03,.5217E-03,.1451E-02,.5481E-02,.8087E-02,.1354E-01,.5074E-01,.3866E+00,.5176E-03,&
 .1076E-03,.3308E-03,.5412E-03,.1424E-02,.5533E-02,.8509E-02,.1462E-01,.5284E-01,.3949E+00,.5331E-03,&
 .1141E-03,.3463E-03,.5719E-03,.1398E-02,.5634E-02,.9179E-02,.1622E-01,.5596E-01,.4068E+00,.5581E-03,&
 .1239E-03,.3710E-03,.6199E-03,.1390E-02,.5842E-02,.1022E-01,.1853E-01,.6051E-01,.4234E+00,.5982E-03/
 data (((w0_lw(ai,k,nh),ai= 5, 5),k=1,nwl_lw),nh=0,99)/ &
 .4211E-01,.1689E+00,.4530E+00,.7769E+00,.8276E+00,.7723E+00,.8409E+00,.9260E+00,.9872E+00,.3073E+00,&
 .4250E-01,.1642E+00,.4101E+00,.7363E+00,.8168E+00,.7672E+00,.8331E+00,.9147E+00,.9851E+00,.2904E+00,&
 .4289E-01,.1595E+00,.3671E+00,.6958E+00,.8060E+00,.7620E+00,.8254E+00,.9033E+00,.9829E+00,.2736E+00,&
 .4328E-01,.1548E+00,.3242E+00,.6553E+00,.7953E+00,.7569E+00,.8176E+00,.8920E+00,.9808E+00,.2568E+00,&
 .4367E-01,.1501E+00,.2813E+00,.6148E+00,.7845E+00,.7518E+00,.8098E+00,.8806E+00,.9787E+00,.2399E+00,&
 .4406E-01,.1454E+00,.2383E+00,.5743E+00,.7738E+00,.7466E+00,.8021E+00,.8693E+00,.9766E+00,.2231E+00,&
 .4453E-01,.1429E+00,.2255E+00,.5525E+00,.7649E+00,.7424E+00,.7966E+00,.8614E+00,.9749E+00,.2153E+00,&
 .4500E-01,.1405E+00,.2127E+00,.5308E+00,.7560E+00,.7382E+00,.7910E+00,.8535E+00,.9732E+00,.2075E+00,&
 .4546E-01,.1381E+00,.1999E+00,.5090E+00,.7470E+00,.7340E+00,.7855E+00,.8456E+00,.9715E+00,.1997E+00,&
 .4593E-01,.1357E+00,.1870E+00,.4873E+00,.7381E+00,.7298E+00,.7800E+00,.8377E+00,.9698E+00,.1919E+00,&
 .4640E-01,.1333E+00,.1742E+00,.4655E+00,.7292E+00,.7256E+00,.7745E+00,.8298E+00,.9682E+00,.1842E+00,&
 .4693E-01,.1320E+00,.1685E+00,.4516E+00,.7218E+00,.7221E+00,.7704E+00,.8240E+00,.9668E+00,.1800E+00,&
 .4747E-01,.1308E+00,.1628E+00,.4377E+00,.7144E+00,.7187E+00,.7664E+00,.8183E+00,.9655E+00,.1758E+00,&
 .4801E-01,.1295E+00,.1571E+00,.4238E+00,.7070E+00,.7152E+00,.7624E+00,.8126E+00,.9641E+00,.1716E+00,&
 .4854E-01,.1283E+00,.1514E+00,.4099E+00,.6996E+00,.7118E+00,.7584E+00,.8068E+00,.9627E+00,.1674E+00,&
 .4908E-01,.1270E+00,.1457E+00,.3960E+00,.6922E+00,.7083E+00,.7544E+00,.8011E+00,.9614E+00,.1632E+00,&
 .4967E-01,.1264E+00,.1428E+00,.3866E+00,.6861E+00,.7056E+00,.7515E+00,.7969E+00,.9603E+00,.1609E+00,&
 .5025E-01,.1259E+00,.1400E+00,.3773E+00,.6801E+00,.7028E+00,.7486E+00,.7927E+00,.9592E+00,.1586E+00,&
 .5084E-01,.1253E+00,.1371E+00,.3679E+00,.6741E+00,.7001E+00,.7457E+00,.7885E+00,.9581E+00,.1562E+00,&
 .5142E-01,.1247E+00,.1343E+00,.3585E+00,.6681E+00,.6973E+00,.7429E+00,.7843E+00,.9570E+00,.1539E+00,&
 .5201E-01,.1241E+00,.1314E+00,.3491E+00,.6621E+00,.6946E+00,.7400E+00,.7801E+00,.9560E+00,.1516E+00,&
 .5264E-01,.1240E+00,.1299E+00,.3425E+00,.6571E+00,.6924E+00,.7379E+00,.7770E+00,.9551E+00,.1502E+00,&
 .5328E-01,.1238E+00,.1284E+00,.3358E+00,.6522E+00,.6902E+00,.7359E+00,.7739E+00,.9542E+00,.1489E+00,&
 .5391E-01,.1237E+00,.1270E+00,.3291E+00,.6473E+00,.6880E+00,.7338E+00,.7708E+00,.9533E+00,.1476E+00,&
 .5455E-01,.1235E+00,.1255E+00,.3224E+00,.6424E+00,.6858E+00,.7317E+00,.7677E+00,.9524E+00,.1463E+00,&
 .5518E-01,.1234E+00,.1240E+00,.3157E+00,.6374E+00,.6836E+00,.7297E+00,.7645E+00,.9516E+00,.1450E+00,&
 .5585E-01,.1235E+00,.1233E+00,.3109E+00,.6335E+00,.6819E+00,.7282E+00,.7622E+00,.9508E+00,.1443E+00,&
 .5652E-01,.1236E+00,.1226E+00,.3061E+00,.6295E+00,.6802E+00,.7268E+00,.7599E+00,.9501E+00,.1436E+00,&
 .5718E-01,.1238E+00,.1219E+00,.3013E+00,.6255E+00,.6785E+00,.7254E+00,.7576E+00,.9494E+00,.1429E+00,&
 .5785E-01,.1239E+00,.1212E+00,.2964E+00,.6216E+00,.6768E+00,.7240E+00,.7552E+00,.9487E+00,.1422E+00,&
 .5852E-01,.1240E+00,.1204E+00,.2916E+00,.6176E+00,.6751E+00,.7225E+00,.7529E+00,.9480E+00,.1415E+00,&
 .5923E-01,.1244E+00,.1202E+00,.2880E+00,.6144E+00,.6738E+00,.7216E+00,.7512E+00,.9474E+00,.1413E+00,&
 .5993E-01,.1247E+00,.1200E+00,.2845E+00,.6112E+00,.6724E+00,.7206E+00,.7494E+00,.9468E+00,.1410E+00,&
 .6064E-01,.1250E+00,.1197E+00,.2809E+00,.6080E+00,.6711E+00,.7196E+00,.7477E+00,.9462E+00,.1407E+00,&
 .6134E-01,.1253E+00,.1195E+00,.2773E+00,.6048E+00,.6698E+00,.7186E+00,.7459E+00,.9456E+00,.1405E+00,&
 .6205E-01,.1257E+00,.1192E+00,.2738E+00,.6016E+00,.6685E+00,.7176E+00,.7442E+00,.9450E+00,.1402E+00,&
 .6277E-01,.1261E+00,.1193E+00,.2711E+00,.5990E+00,.6675E+00,.7170E+00,.7429E+00,.9445E+00,.1402E+00,&
 .6350E-01,.1266E+00,.1193E+00,.2685E+00,.5965E+00,.6666E+00,.7164E+00,.7416E+00,.9440E+00,.1402E+00,&
 .6423E-01,.1270E+00,.1193E+00,.2658E+00,.5939E+00,.6656E+00,.7158E+00,.7403E+00,.9435E+00,.1402E+00,&
 .6495E-01,.1275E+00,.1194E+00,.2632E+00,.5914E+00,.6646E+00,.7152E+00,.7390E+00,.9431E+00,.1402E+00,&
 .6568E-01,.1279E+00,.1194E+00,.2606E+00,.5889E+00,.6637E+00,.7145E+00,.7377E+00,.9426E+00,.1403E+00,&
 .6643E-01,.1285E+00,.1197E+00,.2586E+00,.5868E+00,.6630E+00,.7142E+00,.7367E+00,.9422E+00,.1405E+00,&
 .6719E-01,.1291E+00,.1199E+00,.2566E+00,.5848E+00,.6623E+00,.7138E+00,.7358E+00,.9418E+00,.1407E+00,&
 .6794E-01,.1297E+00,.1202E+00,.2546E+00,.5828E+00,.6616E+00,.7135E+00,.7348E+00,.9413E+00,.1409E+00,&
 .6869E-01,.1302E+00,.1204E+00,.2527E+00,.5808E+00,.6608E+00,.7131E+00,.7338E+00,.9409E+00,.1411E+00,&
 .6945E-01,.1308E+00,.1207E+00,.2507E+00,.5787E+00,.6601E+00,.7127E+00,.7329E+00,.9405E+00,.1413E+00,&
 .7022E-01,.1314E+00,.1211E+00,.2492E+00,.5772E+00,.6597E+00,.7126E+00,.7322E+00,.9402E+00,.1416E+00,&
 .7098E-01,.1321E+00,.1214E+00,.2478E+00,.5756E+00,.6592E+00,.7124E+00,.7314E+00,.9399E+00,.1420E+00,&
 .7175E-01,.1327E+00,.1218E+00,.2463E+00,.5740E+00,.6587E+00,.7123E+00,.7307E+00,.9395E+00,.1423E+00,&
 .7252E-01,.1333E+00,.1222E+00,.2449E+00,.5724E+00,.6583E+00,.7121E+00,.7300E+00,.9392E+00,.1426E+00,&
 .7328E-01,.1340E+00,.1226E+00,.2434E+00,.5709E+00,.6578E+00,.7120E+00,.7293E+00,.9388E+00,.1430E+00,&
 .7394E-01,.1345E+00,.1230E+00,.2425E+00,.5698E+00,.6576E+00,.7119E+00,.7289E+00,.9386E+00,.1434E+00,&
 .7459E-01,.1351E+00,.1234E+00,.2416E+00,.5688E+00,.6573E+00,.7119E+00,.7284E+00,.9384E+00,.1437E+00,&
 .7525E-01,.1357E+00,.1238E+00,.2407E+00,.5678E+00,.6571E+00,.7119E+00,.7280E+00,.9381E+00,.1441E+00,&
 .7590E-01,.1362E+00,.1242E+00,.2398E+00,.5668E+00,.6568E+00,.7119E+00,.7276E+00,.9379E+00,.1445E+00,&
 .7655E-01,.1368E+00,.1245E+00,.2389E+00,.5657E+00,.6566E+00,.7119E+00,.7272E+00,.9376E+00,.1448E+00,&
 .7721E-01,.1374E+00,.1250E+00,.2382E+00,.5649E+00,.6564E+00,.7119E+00,.7268E+00,.9374E+00,.1452E+00,&
 .7787E-01,.1380E+00,.1254E+00,.2375E+00,.5641E+00,.6563E+00,.7120E+00,.7265E+00,.9372E+00,.1456E+00,&
 .7852E-01,.1386E+00,.1258E+00,.2368E+00,.5633E+00,.6562E+00,.7121E+00,.7262E+00,.9370E+00,.1460E+00,&
 .7918E-01,.1392E+00,.1263E+00,.2361E+00,.5625E+00,.6560E+00,.7122E+00,.7259E+00,.9368E+00,.1464E+00,&
 .7983E-01,.1398E+00,.1267E+00,.2354E+00,.5617E+00,.6559E+00,.7122E+00,.7256E+00,.9366E+00,.1468E+00,&
 .8050E-01,.1404E+00,.1272E+00,.2349E+00,.5611E+00,.6558E+00,.7124E+00,.7253E+00,.9364E+00,.1473E+00,&
 .8116E-01,.1411E+00,.1276E+00,.2344E+00,.5604E+00,.6558E+00,.7125E+00,.7251E+00,.9362E+00,.1477E+00,&
 .8183E-01,.1417E+00,.1281E+00,.2339E+00,.5598E+00,.6558E+00,.7126E+00,.7248E+00,.9360E+00,.1482E+00,&
 .8249E-01,.1423E+00,.1286E+00,.2334E+00,.5592E+00,.6557E+00,.7128E+00,.7246E+00,.9358E+00,.1486E+00,&
 .8316E-01,.1429E+00,.1290E+00,.2329E+00,.5585E+00,.6557E+00,.7129E+00,.7244E+00,.9357E+00,.1491E+00,&
 .8383E-01,.1435E+00,.1296E+00,.2325E+00,.5581E+00,.6557E+00,.7131E+00,.7242E+00,.9355E+00,.1496E+00,&
 .8450E-01,.1442E+00,.1301E+00,.2322E+00,.5576E+00,.6557E+00,.7133E+00,.7240E+00,.9353E+00,.1501E+00,&
 .8517E-01,.1448E+00,.1306E+00,.2318E+00,.5571E+00,.6557E+00,.7135E+00,.7239E+00,.9352E+00,.1506E+00,&
 .8584E-01,.1455E+00,.1311E+00,.2314E+00,.5566E+00,.6558E+00,.7136E+00,.7237E+00,.9350E+00,.1511E+00,&
 .8651E-01,.1461E+00,.1316E+00,.2311E+00,.5562E+00,.6558E+00,.7138E+00,.7235E+00,.9348E+00,.1516E+00,&
 .8761E-01,.1472E+00,.1324E+00,.2307E+00,.5557E+00,.6560E+00,.7142E+00,.7234E+00,.9346E+00,.1524E+00,&
 .8870E-01,.1482E+00,.1332E+00,.2304E+00,.5552E+00,.6562E+00,.7146E+00,.7233E+00,.9344E+00,.1532E+00,&
 .8980E-01,.1493E+00,.1341E+00,.2301E+00,.5547E+00,.6563E+00,.7150E+00,.7232E+00,.9341E+00,.1541E+00,&
 .9089E-01,.1503E+00,.1349E+00,.2297E+00,.5542E+00,.6565E+00,.7154E+00,.7231E+00,.9339E+00,.1549E+00,&
 .9198E-01,.1514E+00,.1358E+00,.2294E+00,.5538E+00,.6567E+00,.7157E+00,.7229E+00,.9337E+00,.1557E+00,&
 .9334E-01,.1527E+00,.1369E+00,.2293E+00,.5535E+00,.6571E+00,.7163E+00,.7229E+00,.9334E+00,.1568E+00,&
 .9470E-01,.1541E+00,.1380E+00,.2292E+00,.5533E+00,.6575E+00,.7169E+00,.7229E+00,.9332E+00,.1579E+00,&
 .9606E-01,.1554E+00,.1390E+00,.2292E+00,.5531E+00,.6579E+00,.7174E+00,.7229E+00,.9330E+00,.1590E+00,&
 .9741E-01,.1568E+00,.1401E+00,.2291E+00,.5529E+00,.6583E+00,.7180E+00,.7229E+00,.9327E+00,.1600E+00,&
 .9877E-01,.1581E+00,.1412E+00,.2290E+00,.5526E+00,.6587E+00,.7185E+00,.7228E+00,.9325E+00,.1611E+00,&
 .1004E+00,.1597E+00,.1426E+00,.2291E+00,.5526E+00,.6593E+00,.7193E+00,.7229E+00,.9322E+00,.1625E+00,&
 .1027E+00,.1619E+00,.1444E+00,.2294E+00,.5527E+00,.6601E+00,.7203E+00,.7231E+00,.9319E+00,.1643E+00,&
 .1046E+00,.1639E+00,.1460E+00,.2297E+00,.5529E+00,.6609E+00,.7212E+00,.7233E+00,.9316E+00,.1660E+00,&
 .1066E+00,.1658E+00,.1476E+00,.2301E+00,.5532E+00,.6617E+00,.7221E+00,.7235E+00,.9313E+00,.1676E+00,&
 .1095E+00,.1686E+00,.1500E+00,.2308E+00,.5538E+00,.6630E+00,.7235E+00,.7238E+00,.9309E+00,.1700E+00,&
 .1118E+00,.1709E+00,.1519E+00,.2316E+00,.5543E+00,.6641E+00,.7246E+00,.7241E+00,.9306E+00,.1719E+00,&
 .1147E+00,.1738E+00,.1543E+00,.2326E+00,.5552E+00,.6655E+00,.7259E+00,.7246E+00,.9303E+00,.1743E+00,&
 .1175E+00,.1766E+00,.1567E+00,.2337E+00,.5562E+00,.6669E+00,.7273E+00,.7251E+00,.9299E+00,.1767E+00,&
 .1208E+00,.1798E+00,.1594E+00,.2350E+00,.5575E+00,.6685E+00,.7289E+00,.7256E+00,.9295E+00,.1795E+00,&
 .1249E+00,.1839E+00,.1628E+00,.2369E+00,.5593E+00,.6707E+00,.7308E+00,.7264E+00,.9291E+00,.1830E+00,&
 .1290E+00,.1879E+00,.1662E+00,.2390E+00,.5613E+00,.6728E+00,.7328E+00,.7272E+00,.9287E+00,.1865E+00,&
 .1346E+00,.1933E+00,.1708E+00,.2420E+00,.5642E+00,.6758E+00,.7354E+00,.7284E+00,.9280E+00,.1912E+00,&
 .1405E+00,.1990E+00,.1756E+00,.2454E+00,.5675E+00,.6790E+00,.7380E+00,.7296E+00,.9274E+00,.1961E+00,&
 .1481E+00,.2063E+00,.1818E+00,.2501E+00,.5720E+00,.6831E+00,.7414E+00,.7311E+00,.9265E+00,.2025E+00,&
 .1578E+00,.2156E+00,.1898E+00,.2565E+00,.5781E+00,.6883E+00,.7454E+00,.7331E+00,.9255E+00,.2106E+00,&
 .1690E+00,.2261E+00,.1988E+00,.2641E+00,.5853E+00,.6941E+00,.7496E+00,.7352E+00,.9242E+00,.2198E+00,&
 .1868E+00,.2426E+00,.2131E+00,.2771E+00,.5969E+00,.7028E+00,.7557E+00,.7383E+00,.9218E+00,.2345E+00,&
 .2092E+00,.2629E+00,.2311E+00,.2941E+00,.6113E+00,.7127E+00,.7621E+00,.7413E+00,.9183E+00,.2527E+00,&
 .2497E+00,.2985E+00,.2634E+00,.3260E+00,.6351E+00,.7271E+00,.7697E+00,.7440E+00,.9103E+00,.2851E+00/
 data (((w0_lw(ai,k,nh),ai= 6, 6),k=1,nwl_lw),nh=0,99)/ &
 .3712E+00,.5599E+00,.7804E+00,.9078E+00,.8815E+00,.8358E+00,.9067E+00,.9278E+00,.9736E+00,.6545E+00,&
 .3711E+00,.5523E+00,.7479E+00,.8880E+00,.8761E+00,.8331E+00,.9016E+00,.9184E+00,.9693E+00,.6377E+00,&
 .3710E+00,.5448E+00,.7154E+00,.8682E+00,.8707E+00,.8305E+00,.8964E+00,.9089E+00,.9651E+00,.6209E+00,&
 .3708E+00,.5372E+00,.6829E+00,.8484E+00,.8654E+00,.8279E+00,.8912E+00,.8994E+00,.9608E+00,.6040E+00,&
 .3707E+00,.5296E+00,.6504E+00,.8286E+00,.8600E+00,.8253E+00,.8860E+00,.8900E+00,.9566E+00,.5872E+00,&
 .3706E+00,.5221E+00,.6180E+00,.8088E+00,.8546E+00,.8226E+00,.8809E+00,.8805E+00,.9523E+00,.5704E+00,&
 .3707E+00,.5170E+00,.6009E+00,.7953E+00,.8501E+00,.8204E+00,.8765E+00,.8739E+00,.9491E+00,.5603E+00,&
 .3708E+00,.5119E+00,.5838E+00,.7818E+00,.8457E+00,.8182E+00,.8722E+00,.8674E+00,.9458E+00,.5502E+00,&
 .3709E+00,.5068E+00,.5668E+00,.7682E+00,.8412E+00,.8160E+00,.8679E+00,.8608E+00,.9425E+00,.5401E+00,&
 .3711E+00,.5017E+00,.5497E+00,.7547E+00,.8367E+00,.8138E+00,.8636E+00,.8542E+00,.9392E+00,.5300E+00,&
 .3712E+00,.4966E+00,.5327E+00,.7412E+00,.8323E+00,.8116E+00,.8593E+00,.8477E+00,.9359E+00,.5199E+00,&
 .3715E+00,.4931E+00,.5227E+00,.7312E+00,.8285E+00,.8094E+00,.8559E+00,.8428E+00,.9331E+00,.5134E+00,&
 .3719E+00,.4895E+00,.5127E+00,.7213E+00,.8248E+00,.8072E+00,.8525E+00,.8379E+00,.9303E+00,.5070E+00,&
 .3722E+00,.4860E+00,.5027E+00,.7113E+00,.8210E+00,.8049E+00,.8492E+00,.8330E+00,.9274E+00,.5005E+00,&
 .3725E+00,.4825E+00,.4928E+00,.7013E+00,.8173E+00,.8027E+00,.8458E+00,.8281E+00,.9246E+00,.4940E+00,&
 .3729E+00,.4789E+00,.4828E+00,.6913E+00,.8136E+00,.8005E+00,.8424E+00,.8232E+00,.9218E+00,.4875E+00,&
 .3733E+00,.4764E+00,.4767E+00,.6836E+00,.8103E+00,.7988E+00,.8395E+00,.8193E+00,.9194E+00,.4832E+00,&
 .3738E+00,.4739E+00,.4705E+00,.6759E+00,.8071E+00,.7971E+00,.8365E+00,.8154E+00,.9171E+00,.4789E+00,&
 .3742E+00,.4715E+00,.4644E+00,.6682E+00,.8038E+00,.7954E+00,.8335E+00,.8115E+00,.9148E+00,.4746E+00,&
 .3747E+00,.4690E+00,.4583E+00,.6605E+00,.8006E+00,.7937E+00,.8305E+00,.8076E+00,.9125E+00,.4703E+00,&
 .3751E+00,.4665E+00,.4522E+00,.6528E+00,.7973E+00,.7920E+00,.8275E+00,.8037E+00,.9102E+00,.4660E+00,&
 .3757E+00,.4647E+00,.4483E+00,.6468E+00,.7945E+00,.7903E+00,.8251E+00,.8006E+00,.9082E+00,.4631E+00,&
 .3762E+00,.4630E+00,.4445E+00,.6407E+00,.7917E+00,.7886E+00,.8228E+00,.7975E+00,.9061E+00,.4602E+00,&
 .3767E+00,.4612E+00,.4407E+00,.6347E+00,.7889E+00,.7869E+00,.8204E+00,.7944E+00,.9040E+00,.4573E+00,&
 .3773E+00,.4595E+00,.4368E+00,.6286E+00,.7861E+00,.7851E+00,.8180E+00,.7913E+00,.9020E+00,.4544E+00,&
 .3778E+00,.4577E+00,.4330E+00,.6226E+00,.7833E+00,.7834E+00,.8156E+00,.7882E+00,.8999E+00,.4515E+00,&
 .3784E+00,.4565E+00,.4306E+00,.6177E+00,.7808E+00,.7819E+00,.8134E+00,.7855E+00,.8981E+00,.4496E+00,&
 .3790E+00,.4552E+00,.4281E+00,.6129E+00,.7784E+00,.7804E+00,.8112E+00,.7828E+00,.8963E+00,.4476E+00,&
 .3796E+00,.4540E+00,.4257E+00,.6081E+00,.7759E+00,.7789E+00,.8089E+00,.7802E+00,.8945E+00,.4456E+00,&
 .3802E+00,.4528E+00,.4233E+00,.6033E+00,.7734E+00,.7774E+00,.8067E+00,.7775E+00,.8927E+00,.4437E+00,&
 .3808E+00,.4515E+00,.4209E+00,.5985E+00,.7710E+00,.7759E+00,.8045E+00,.7748E+00,.8909E+00,.4417E+00,&
 .3815E+00,.4507E+00,.4194E+00,.5946E+00,.7688E+00,.7745E+00,.8027E+00,.7726E+00,.8892E+00,.4404E+00,&
 .3821E+00,.4498E+00,.4179E+00,.5907E+00,.7666E+00,.7732E+00,.8008E+00,.7705E+00,.8876E+00,.4390E+00,&
 .3827E+00,.4489E+00,.4163E+00,.5868E+00,.7644E+00,.7719E+00,.7990E+00,.7683E+00,.8860E+00,.4377E+00,&
 .3834E+00,.4481E+00,.4148E+00,.5829E+00,.7622E+00,.7705E+00,.7972E+00,.7661E+00,.8844E+00,.4364E+00,&
 .3840E+00,.4472E+00,.4133E+00,.5790E+00,.7600E+00,.7692E+00,.7953E+00,.7639E+00,.8828E+00,.4351E+00,&
 .3847E+00,.4466E+00,.4124E+00,.5759E+00,.7581E+00,.7679E+00,.7936E+00,.7619E+00,.8812E+00,.4342E+00,&
 .3853E+00,.4460E+00,.4115E+00,.5728E+00,.7561E+00,.7666E+00,.7919E+00,.7599E+00,.8796E+00,.4333E+00,&
 .3859E+00,.4454E+00,.4106E+00,.5696E+00,.7542E+00,.7653E+00,.7901E+00,.7579E+00,.8781E+00,.4324E+00,&
 .3866E+00,.4448E+00,.4097E+00,.5665E+00,.7523E+00,.7640E+00,.7884E+00,.7559E+00,.8765E+00,.4316E+00,&
 .3872E+00,.4443E+00,.4088E+00,.5634E+00,.7504E+00,.7627E+00,.7867E+00,.7539E+00,.8750E+00,.4307E+00,&
 .3879E+00,.4439E+00,.4083E+00,.5608E+00,.7487E+00,.7616E+00,.7851E+00,.7523E+00,.8736E+00,.4301E+00,&
 .3885E+00,.4435E+00,.4078E+00,.5583E+00,.7469E+00,.7605E+00,.7836E+00,.7506E+00,.8723E+00,.4296E+00,&
 .3892E+00,.4431E+00,.4073E+00,.5557E+00,.7452E+00,.7593E+00,.7820E+00,.7489E+00,.8709E+00,.4290E+00,&
 .3899E+00,.4427E+00,.4068E+00,.5532E+00,.7435E+00,.7582E+00,.7805E+00,.7473E+00,.8696E+00,.4284E+00,&
 .3905E+00,.4424E+00,.4063E+00,.5506E+00,.7418E+00,.7571E+00,.7790E+00,.7456E+00,.8683E+00,.4279E+00,&
 .3912E+00,.4421E+00,.4060E+00,.5485E+00,.7402E+00,.7560E+00,.7776E+00,.7441E+00,.8669E+00,.4275E+00,&
 .3918E+00,.4419E+00,.4058E+00,.5464E+00,.7387E+00,.7549E+00,.7763E+00,.7426E+00,.8655E+00,.4272E+00,&
 .3925E+00,.4416E+00,.4056E+00,.5443E+00,.7371E+00,.7538E+00,.7749E+00,.7411E+00,.8642E+00,.4269E+00,&
 .3931E+00,.4414E+00,.4054E+00,.5422E+00,.7355E+00,.7527E+00,.7736E+00,.7396E+00,.8628E+00,.4266E+00,&
 .3938E+00,.4411E+00,.4051E+00,.5402E+00,.7340E+00,.7516E+00,.7722E+00,.7380E+00,.8614E+00,.4262E+00,&
 .3943E+00,.4410E+00,.4051E+00,.5387E+00,.7329E+00,.7508E+00,.7711E+00,.7369E+00,.8605E+00,.4261E+00,&
 .3948E+00,.4409E+00,.4051E+00,.5373E+00,.7317E+00,.7500E+00,.7700E+00,.7357E+00,.8596E+00,.4260E+00,&
 .3953E+00,.4408E+00,.4050E+00,.5359E+00,.7306E+00,.7491E+00,.7689E+00,.7345E+00,.8587E+00,.4258E+00,&
 .3958E+00,.4407E+00,.4050E+00,.5345E+00,.7294E+00,.7483E+00,.7678E+00,.7333E+00,.8578E+00,.4257E+00,&
 .3963E+00,.4406E+00,.4050E+00,.5331E+00,.7283E+00,.7475E+00,.7667E+00,.7321E+00,.8568E+00,.4255E+00,&
 .3968E+00,.4406E+00,.4050E+00,.5319E+00,.7273E+00,.7467E+00,.7657E+00,.7311E+00,.8559E+00,.4255E+00,&
 .3974E+00,.4405E+00,.4051E+00,.5307E+00,.7262E+00,.7459E+00,.7647E+00,.7301E+00,.8549E+00,.4254E+00,&
 .3979E+00,.4405E+00,.4052E+00,.5295E+00,.7251E+00,.7451E+00,.7638E+00,.7291E+00,.8539E+00,.4254E+00,&
 .3984E+00,.4404E+00,.4052E+00,.5283E+00,.7241E+00,.7444E+00,.7628E+00,.7281E+00,.8529E+00,.4253E+00,&
 .3989E+00,.4404E+00,.4053E+00,.5271E+00,.7230E+00,.7436E+00,.7618E+00,.7271E+00,.8519E+00,.4253E+00,&
 .3994E+00,.4404E+00,.4054E+00,.5260E+00,.7220E+00,.7428E+00,.7609E+00,.7261E+00,.8509E+00,.4253E+00,&
 .3999E+00,.4404E+00,.4056E+00,.5250E+00,.7211E+00,.7421E+00,.7600E+00,.7252E+00,.8500E+00,.4253E+00,&
 .4004E+00,.4404E+00,.4057E+00,.5240E+00,.7201E+00,.7414E+00,.7591E+00,.7242E+00,.8490E+00,.4254E+00,&
 .4009E+00,.4404E+00,.4058E+00,.5229E+00,.7191E+00,.7406E+00,.7582E+00,.7232E+00,.8480E+00,.4254E+00,&
 .4014E+00,.4404E+00,.4060E+00,.5219E+00,.7181E+00,.7399E+00,.7573E+00,.7223E+00,.8471E+00,.4254E+00,&
 .4019E+00,.4405E+00,.4062E+00,.5210E+00,.7172E+00,.7392E+00,.7564E+00,.7213E+00,.8462E+00,.4255E+00,&
 .4024E+00,.4405E+00,.4063E+00,.5202E+00,.7163E+00,.7384E+00,.7554E+00,.7203E+00,.8454E+00,.4256E+00,&
 .4028E+00,.4406E+00,.4065E+00,.5193E+00,.7154E+00,.7377E+00,.7545E+00,.7193E+00,.8445E+00,.4256E+00,&
 .4033E+00,.4406E+00,.4067E+00,.5185E+00,.7145E+00,.7370E+00,.7535E+00,.7183E+00,.8437E+00,.4257E+00,&
 .4038E+00,.4406E+00,.4069E+00,.5176E+00,.7136E+00,.7363E+00,.7525E+00,.7173E+00,.8428E+00,.4258E+00,&
 .4045E+00,.4408E+00,.4072E+00,.5165E+00,.7124E+00,.7352E+00,.7513E+00,.7161E+00,.8416E+00,.4259E+00,&
 .4052E+00,.4409E+00,.4076E+00,.5155E+00,.7112E+00,.7342E+00,.7500E+00,.7149E+00,.8403E+00,.4261E+00,&
 .4059E+00,.4410E+00,.4079E+00,.5144E+00,.7099E+00,.7332E+00,.7488E+00,.7137E+00,.8391E+00,.4263E+00,&
 .4066E+00,.4411E+00,.4083E+00,.5134E+00,.7087E+00,.7322E+00,.7475E+00,.7124E+00,.8379E+00,.4265E+00,&
 .4073E+00,.4412E+00,.4086E+00,.5123E+00,.7075E+00,.7312E+00,.7463E+00,.7112E+00,.8367E+00,.4266E+00,&
 .4083E+00,.4415E+00,.4092E+00,.5112E+00,.7059E+00,.7298E+00,.7445E+00,.7095E+00,.8350E+00,.4270E+00,&
 .4092E+00,.4417E+00,.4098E+00,.5100E+00,.7043E+00,.7285E+00,.7428E+00,.7077E+00,.8332E+00,.4274E+00,&
 .4102E+00,.4420E+00,.4104E+00,.5088E+00,.7027E+00,.7271E+00,.7411E+00,.7060E+00,.8315E+00,.4277E+00,&
 .4111E+00,.4422E+00,.4110E+00,.5077E+00,.7011E+00,.7257E+00,.7394E+00,.7042E+00,.8298E+00,.4281E+00,&
 .4121E+00,.4424E+00,.4116E+00,.5065E+00,.6995E+00,.7243E+00,.7377E+00,.7025E+00,.8281E+00,.4285E+00,&
 .4131E+00,.4428E+00,.4123E+00,.5055E+00,.6979E+00,.7229E+00,.7359E+00,.7009E+00,.8266E+00,.4289E+00,&
 .4145E+00,.4433E+00,.4134E+00,.5042E+00,.6957E+00,.7209E+00,.7334E+00,.6986E+00,.8237E+00,.4296E+00,&
 .4159E+00,.4438E+00,.4144E+00,.5030E+00,.6936E+00,.7189E+00,.7310E+00,.6962E+00,.8213E+00,.4304E+00,&
 .4173E+00,.4443E+00,.4155E+00,.5020E+00,.6915E+00,.7169E+00,.7288E+00,.6940E+00,.8188E+00,.4311E+00,&
 .4188E+00,.4449E+00,.4168E+00,.5009E+00,.6891E+00,.7146E+00,.7258E+00,.6914E+00,.8159E+00,.4320E+00,&
 .4203E+00,.4456E+00,.4180E+00,.4999E+00,.6868E+00,.7124E+00,.7230E+00,.6885E+00,.8134E+00,.4329E+00,&
 .4217E+00,.4462E+00,.4193E+00,.4991E+00,.6847E+00,.7102E+00,.7203E+00,.6862E+00,.8106E+00,.4339E+00,&
 .4232E+00,.4469E+00,.4206E+00,.4984E+00,.6825E+00,.7080E+00,.7176E+00,.6837E+00,.8080E+00,.4349E+00,&
 .4249E+00,.4477E+00,.4222E+00,.4977E+00,.6800E+00,.7055E+00,.7148E+00,.6810E+00,.8048E+00,.4360E+00,&
 .4268E+00,.4487E+00,.4239E+00,.4970E+00,.6772E+00,.7025E+00,.7110E+00,.6777E+00,.8012E+00,.4374E+00,&
 .4290E+00,.4498E+00,.4260E+00,.4964E+00,.6740E+00,.6991E+00,.7068E+00,.6738E+00,.7973E+00,.4390E+00,&
 .4312E+00,.4511E+00,.4283E+00,.4959E+00,.6708E+00,.6955E+00,.7026E+00,.6700E+00,.7928E+00,.4407E+00,&
 .4342E+00,.4528E+00,.4314E+00,.4955E+00,.6662E+00,.6903E+00,.6962E+00,.6646E+00,.7866E+00,.4432E+00,&
 .4375E+00,.4548E+00,.4349E+00,.4954E+00,.6613E+00,.6845E+00,.6895E+00,.6588E+00,.7800E+00,.4460E+00,&
 .4411E+00,.4572E+00,.4390E+00,.4955E+00,.6556E+00,.6778E+00,.6813E+00,.6518E+00,.7724E+00,.4493E+00,&
 .4458E+00,.4604E+00,.4444E+00,.4960E+00,.6479E+00,.6685E+00,.6707E+00,.6432E+00,.7615E+00,.4538E+00,&
 .4508E+00,.4640E+00,.4506E+00,.4970E+00,.6388E+00,.6572E+00,.6580E+00,.6330E+00,.7496E+00,.4590E+00,&
 .4576E+00,.4694E+00,.4595E+00,.4987E+00,.6249E+00,.6401E+00,.6388E+00,.6181E+00,.7317E+00,.4667E+00,&
 .4676E+00,.4782E+00,.4737E+00,.5013E+00,.6004E+00,.6105E+00,.6078E+00,.5954E+00,.7018E+00,.4792E+00/
 data (((w0_lw(ai,k,nh),ai= 7, 7),k=1,nwl_lw),nh=0,99)/ &
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02,&
 .2197E-02,.6746E-02,.1180E-01,.4600E-01,.1326E+00,.1585E-01,.3566E-01,.2440E+00,.8000E+00,.4246E-02/
 data (((w0_lw(ai,k,nh),ai= 8, 8),k=1,nwl_lw),nh=0,99)/ &
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01,&
 .1124E-01,.3363E-01,.5143E-01,.1676E+00,.3616E+00,.5619E-01,.1188E+00,.5075E+00,.9197E+00,.2001E-01/
 data (((w0_lw(ai,k,nh),ai= 9, 9),k=1,nwl_lw),nh=0,99)/ &
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01,&
 .6895E-01,.1656E+00,.1932E+00,.4259E+00,.5864E+00,.1452E+00,.3025E+00,.7524E+00,.9651E+00,.9678E-01/
 data (((w0_lw(ai,k,nh),ai=10,10),k=1,nwl_lw),nh=0,99)/ &
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00,&
 .2483E+00,.3891E+00,.3981E+00,.6198E+00,.6636E+00,.2352E+00,.4878E+00,.8585E+00,.9770E+00,.2650E+00/
 data (((w0_lw(ai,k,nh),ai=11,11),k=1,nwl_lw),nh=0,99)/ &
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00,&
 .4797E+00,.5432E+00,.5688E+00,.7105E+00,.6756E+00,.3210E+00,.6267E+00,.8988E+00,.9792E+00,.4551E+00/
 data (((w0_lw(ai,k,nh),ai=12,12),k=1,nwl_lw),nh=0,99)/ &
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00,&
 .6075E+00,.6016E+00,.6631E+00,.7363E+00,.6573E+00,.3976E+00,.7115E+00,.9084E+00,.9753E+00,.5818E+00/
 data (((w0_lw(ai,k,nh),ai=13,13),k=1,nwl_lw),nh=0,99)/ &
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00,&
 .6516E+00,.6090E+00,.7009E+00,.7181E+00,.6159E+00,.4675E+00,.7582E+00,.8931E+00,.9612E+00,.6491E+00/
 data (((w0_lw(ai,k,nh),ai=14,14),k=1,nwl_lw),nh=0,99)/ &
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00,&
 .6415E+00,.5860E+00,.6866E+00,.6671E+00,.5811E+00,.5067E+00,.7567E+00,.8505E+00,.9340E+00,.6543E+00/
 data (((g_lw(ai,k,nh),ai= 1, 1),k=1,nwl_lw),nh=0,99)/ &
 .4974E-03,.1097E-02,.2259E-02,.4134E-02,.5324E-02,.5525E-02,.6496E-02,.1171E-01,.2654E-01,.1705E-02,&
 .5026E-03,.1108E-02,.2281E-02,.4167E-02,.5384E-02,.5621E-02,.6616E-02,.1188E-01,.2695E-01,.1724E-02,&
 .5078E-03,.1120E-02,.2303E-02,.4201E-02,.5445E-02,.5717E-02,.6735E-02,.1205E-01,.2735E-01,.1743E-02,&
 .5129E-03,.1131E-02,.2326E-02,.4234E-02,.5505E-02,.5813E-02,.6854E-02,.1223E-01,.2775E-01,.1761E-02,&
 .5181E-03,.1142E-02,.2348E-02,.4268E-02,.5566E-02,.5909E-02,.6974E-02,.1240E-01,.2815E-01,.1780E-02,&
 .5233E-03,.1154E-02,.2371E-02,.4302E-02,.5626E-02,.6006E-02,.7093E-02,.1257E-01,.2856E-01,.1799E-02,&
 .5288E-03,.1166E-02,.2395E-02,.4339E-02,.5689E-02,.6102E-02,.7215E-02,.1275E-01,.2897E-01,.1818E-02,&
 .5343E-03,.1178E-02,.2419E-02,.4376E-02,.5753E-02,.6199E-02,.7336E-02,.1293E-01,.2939E-01,.1838E-02,&
 .5398E-03,.1190E-02,.2443E-02,.4414E-02,.5816E-02,.6296E-02,.7458E-02,.1311E-01,.2980E-01,.1858E-02,&
 .5453E-03,.1202E-02,.2467E-02,.4451E-02,.5880E-02,.6393E-02,.7580E-02,.1329E-01,.3022E-01,.1878E-02,&
 .5508E-03,.1214E-02,.2492E-02,.4489E-02,.5943E-02,.6490E-02,.7701E-02,.1347E-01,.3064E-01,.1898E-02,&
 .5567E-03,.1227E-02,.2517E-02,.4530E-02,.6010E-02,.6587E-02,.7825E-02,.1366E-01,.3106E-01,.1919E-02,&
 .5626E-03,.1240E-02,.2543E-02,.4571E-02,.6077E-02,.6685E-02,.7948E-02,.1384E-01,.3149E-01,.1940E-02,&
 .5685E-03,.1253E-02,.2569E-02,.4612E-02,.6143E-02,.6783E-02,.8072E-02,.1403E-01,.3192E-01,.1961E-02,&
 .5743E-03,.1266E-02,.2595E-02,.4653E-02,.6210E-02,.6881E-02,.8195E-02,.1422E-01,.3235E-01,.1982E-02,&
 .5802E-03,.1279E-02,.2621E-02,.4695E-02,.6277E-02,.6978E-02,.8319E-02,.1440E-01,.3278E-01,.2003E-02,&
 .5863E-03,.1292E-02,.2648E-02,.4738E-02,.6346E-02,.7078E-02,.8446E-02,.1459E-01,.3323E-01,.2025E-02,&
 .5925E-03,.1306E-02,.2675E-02,.4782E-02,.6415E-02,.7178E-02,.8573E-02,.1479E-01,.3367E-01,.2047E-02,&
 .5986E-03,.1319E-02,.2703E-02,.4826E-02,.6484E-02,.7278E-02,.8700E-02,.1498E-01,.3412E-01,.2068E-02,&
 .6048E-03,.1333E-02,.2730E-02,.4869E-02,.6554E-02,.7377E-02,.8827E-02,.1517E-01,.3456E-01,.2090E-02,&
 .6109E-03,.1346E-02,.2757E-02,.4913E-02,.6623E-02,.7477E-02,.8954E-02,.1536E-01,.3501E-01,.2112E-02,&
 .6174E-03,.1360E-02,.2786E-02,.4960E-02,.6695E-02,.7579E-02,.9084E-02,.1556E-01,.3546E-01,.2135E-02,&
 .6238E-03,.1374E-02,.2814E-02,.5006E-02,.6767E-02,.7681E-02,.9215E-02,.1576E-01,.3592E-01,.2158E-02,&
 .6303E-03,.1388E-02,.2843E-02,.5053E-02,.6839E-02,.7783E-02,.9345E-02,.1596E-01,.3638E-01,.2181E-02,&
 .6367E-03,.1402E-02,.2871E-02,.5099E-02,.6911E-02,.7885E-02,.9475E-02,.1616E-01,.3684E-01,.2204E-02,&
 .6432E-03,.1417E-02,.2900E-02,.5146E-02,.6983E-02,.7986E-02,.9606E-02,.1636E-01,.3730E-01,.2227E-02,&
 .6499E-03,.1431E-02,.2930E-02,.5195E-02,.7058E-02,.8090E-02,.9739E-02,.1656E-01,.3777E-01,.2251E-02,&
 .6566E-03,.1446E-02,.2960E-02,.5244E-02,.7133E-02,.8194E-02,.9873E-02,.1677E-01,.3824E-01,.2275E-02,&
 .6633E-03,.1461E-02,.2990E-02,.5294E-02,.7208E-02,.8298E-02,.1001E-01,.1698E-01,.3872E-01,.2299E-02,&
 .6701E-03,.1475E-02,.3020E-02,.5343E-02,.7283E-02,.8402E-02,.1014E-01,.1718E-01,.3919E-01,.2323E-02,&
 .6768E-03,.1490E-02,.3050E-02,.5392E-02,.7358E-02,.8506E-02,.1027E-01,.1739E-01,.3966E-01,.2346E-02,&
 .6838E-03,.1505E-02,.3081E-02,.5444E-02,.7436E-02,.8613E-02,.1041E-01,.1760E-01,.4015E-01,.2371E-02,&
 .6908E-03,.1521E-02,.3112E-02,.5496E-02,.7514E-02,.8719E-02,.1055E-01,.1781E-01,.4064E-01,.2396E-02,&
 .6978E-03,.1536E-02,.3143E-02,.5547E-02,.7592E-02,.8826E-02,.1068E-01,.1802E-01,.4113E-01,.2421E-02,&
 .7049E-03,.1551E-02,.3175E-02,.5599E-02,.7669E-02,.8932E-02,.1082E-01,.1823E-01,.4161E-01,.2446E-02,&
 .7119E-03,.1567E-02,.3206E-02,.5651E-02,.7747E-02,.9038E-02,.1096E-01,.1844E-01,.4210E-01,.2471E-02,&
 .7192E-03,.1583E-02,.3239E-02,.5705E-02,.7828E-02,.9147E-02,.1110E-01,.1866E-01,.4260E-01,.2497E-02,&
 .7265E-03,.1599E-02,.3271E-02,.5760E-02,.7908E-02,.9256E-02,.1124E-01,.1888E-01,.4310E-01,.2522E-02,&
 .7338E-03,.1615E-02,.3304E-02,.5814E-02,.7989E-02,.9364E-02,.1137E-01,.1910E-01,.4360E-01,.2548E-02,&
 .7411E-03,.1631E-02,.3336E-02,.5868E-02,.8070E-02,.9473E-02,.1151E-01,.1931E-01,.4410E-01,.2574E-02,&
 .7484E-03,.1647E-02,.3369E-02,.5923E-02,.8151E-02,.9581E-02,.1165E-01,.1953E-01,.4460E-01,.2600E-02,&
 .7559E-03,.1663E-02,.3403E-02,.5979E-02,.8234E-02,.9693E-02,.1180E-01,.1976E-01,.4512E-01,.2627E-02,&
 .7635E-03,.1680E-02,.3436E-02,.6036E-02,.8317E-02,.9804E-02,.1194E-01,.1998E-01,.4564E-01,.2653E-02,&
 .7710E-03,.1696E-02,.3470E-02,.6092E-02,.8400E-02,.9916E-02,.1208E-01,.2021E-01,.4615E-01,.2680E-02,&
 .7786E-03,.1713E-02,.3504E-02,.6149E-02,.8484E-02,.1003E-01,.1223E-01,.2043E-01,.4667E-01,.2707E-02,&
 .7861E-03,.1729E-02,.3538E-02,.6205E-02,.8567E-02,.1014E-01,.1237E-01,.2065E-01,.4718E-01,.2734E-02,&
 .7940E-03,.1746E-02,.3573E-02,.6264E-02,.8653E-02,.1025E-01,.1252E-01,.2088E-01,.4771E-01,.2761E-02,&
 .8018E-03,.1763E-02,.3608E-02,.6322E-02,.8739E-02,.1037E-01,.1267E-01,.2111E-01,.4824E-01,.2789E-02,&
 .8096E-03,.1780E-02,.3643E-02,.6381E-02,.8825E-02,.1048E-01,.1281E-01,.2135E-01,.4878E-01,.2816E-02,&
 .8175E-03,.1797E-02,.3678E-02,.6440E-02,.8911E-02,.1060E-01,.1296E-01,.2158E-01,.4931E-01,.2844E-02,&
 .8253E-03,.1814E-02,.3712E-02,.6498E-02,.8997E-02,.1071E-01,.1311E-01,.2181E-01,.4984E-01,.2871E-02,&
 .8334E-03,.1832E-02,.3749E-02,.6559E-02,.9086E-02,.1083E-01,.1326E-01,.2204E-01,.5038E-01,.2900E-02,&
 .8414E-03,.1850E-02,.3785E-02,.6621E-02,.9174E-02,.1094E-01,.1341E-01,.2228E-01,.5092E-01,.2929E-02,&
 .8495E-03,.1867E-02,.3821E-02,.6682E-02,.9263E-02,.1106E-01,.1356E-01,.2252E-01,.5146E-01,.2957E-02,&
 .8576E-03,.1885E-02,.3858E-02,.6743E-02,.9352E-02,.1118E-01,.1370E-01,.2275E-01,.5200E-01,.2986E-02,&
 .8656E-03,.1903E-02,.3894E-02,.6805E-02,.9441E-02,.1129E-01,.1385E-01,.2299E-01,.5255E-01,.3014E-02,&
 .8740E-03,.1921E-02,.3931E-02,.6868E-02,.9533E-02,.1141E-01,.1401E-01,.2323E-01,.5310E-01,.3044E-02,&
 .8823E-03,.1939E-02,.3969E-02,.6931E-02,.9624E-02,.1153E-01,.1416E-01,.2347E-01,.5366E-01,.3073E-02,&
 .8907E-03,.1957E-02,.4006E-02,.6995E-02,.9715E-02,.1165E-01,.1431E-01,.2371E-01,.5421E-01,.3102E-02,&
 .8990E-03,.1976E-02,.4044E-02,.7058E-02,.9807E-02,.1177E-01,.1447E-01,.2395E-01,.5476E-01,.3132E-02,&
 .9073E-03,.1994E-02,.4081E-02,.7121E-02,.9898E-02,.1189E-01,.1462E-01,.2419E-01,.5532E-01,.3161E-02,&
 .9159E-03,.2013E-02,.4119E-02,.7186E-02,.9992E-02,.1201E-01,.1478E-01,.2444E-01,.5589E-01,.3191E-02,&
 .9245E-03,.2031E-02,.4158E-02,.7252E-02,.1009E-01,.1213E-01,.1493E-01,.2469E-01,.5646E-01,.3221E-02,&
 .9331E-03,.2050E-02,.4196E-02,.7317E-02,.1018E-01,.1226E-01,.1509E-01,.2494E-01,.5703E-01,.3252E-02,&
 .9417E-03,.2069E-02,.4235E-02,.7382E-02,.1027E-01,.1238E-01,.1525E-01,.2519E-01,.5760E-01,.3282E-02,&
 .9503E-03,.2087E-02,.4273E-02,.7447E-02,.1037E-01,.1250E-01,.1541E-01,.2544E-01,.5817E-01,.3312E-02,&
 .9592E-03,.2107E-02,.4313E-02,.7514E-02,.1046E-01,.1263E-01,.1557E-01,.2569E-01,.5876E-01,.3343E-02,&
 .9680E-03,.2126E-02,.4352E-02,.7581E-02,.1056E-01,.1275E-01,.1573E-01,.2595E-01,.5934E-01,.3374E-02,&
 .9768E-03,.2145E-02,.4392E-02,.7648E-02,.1066E-01,.1288E-01,.1589E-01,.2620E-01,.5993E-01,.3405E-02,&
 .9856E-03,.2165E-02,.4431E-02,.7715E-02,.1075E-01,.1300E-01,.1605E-01,.2646E-01,.6051E-01,.3436E-02,&
 .9944E-03,.2184E-02,.4471E-02,.7783E-02,.1085E-01,.1313E-01,.1621E-01,.2671E-01,.6110E-01,.3467E-02,&
 .1004E-02,.2204E-02,.4512E-02,.7851E-02,.1095E-01,.1326E-01,.1638E-01,.2698E-01,.6173E-01,.3500E-02,&
 .1013E-02,.2223E-02,.4552E-02,.7919E-02,.1105E-01,.1339E-01,.1656E-01,.2726E-01,.6236E-01,.3532E-02,&
 .1022E-02,.2243E-02,.4593E-02,.7987E-02,.1115E-01,.1353E-01,.1673E-01,.2753E-01,.6299E-01,.3564E-02,&
 .1031E-02,.2263E-02,.4634E-02,.8056E-02,.1125E-01,.1366E-01,.1691E-01,.2780E-01,.6362E-01,.3596E-02,&
 .1040E-02,.2283E-02,.4674E-02,.8124E-02,.1135E-01,.1380E-01,.1708E-01,.2808E-01,.6424E-01,.3628E-02,&
 .1049E-02,.2303E-02,.4717E-02,.8195E-02,.1145E-01,.1393E-01,.1726E-01,.2836E-01,.6489E-01,.3661E-02,&
 .1059E-02,.2324E-02,.4759E-02,.8266E-02,.1155E-01,.1407E-01,.1744E-01,.2864E-01,.6553E-01,.3695E-02,&
 .1068E-02,.2344E-02,.4801E-02,.8337E-02,.1166E-01,.1421E-01,.1762E-01,.2892E-01,.6618E-01,.3728E-02,&
 .1077E-02,.2365E-02,.4843E-02,.8407E-02,.1176E-01,.1434E-01,.1780E-01,.2920E-01,.6682E-01,.3761E-02,&
 .1087E-02,.2385E-02,.4885E-02,.8478E-02,.1186E-01,.1448E-01,.1798E-01,.2948E-01,.6746E-01,.3794E-02,&
 .1096E-02,.2406E-02,.4928E-02,.8551E-02,.1197E-01,.1462E-01,.1816E-01,.2976E-01,.6813E-01,.3828E-02,&
 .1106E-02,.2427E-02,.4972E-02,.8624E-02,.1207E-01,.1476E-01,.1835E-01,.3005E-01,.6879E-01,.3863E-02,&
 .1116E-02,.2448E-02,.5016E-02,.8697E-02,.1218E-01,.1490E-01,.1853E-01,.3034E-01,.6946E-01,.3897E-02,&
 .1126E-02,.2470E-02,.5060E-02,.8772E-02,.1229E-01,.1505E-01,.1873E-01,.3065E-01,.7017E-01,.3932E-02,&
 .1136E-02,.2492E-02,.5105E-02,.8847E-02,.1240E-01,.1520E-01,.1893E-01,.3096E-01,.7088E-01,.3968E-02,&
 .1146E-02,.2513E-02,.5151E-02,.8923E-02,.1251E-01,.1535E-01,.1913E-01,.3127E-01,.7160E-01,.4004E-02,&
 .1156E-02,.2536E-02,.5198E-02,.9001E-02,.1263E-01,.1551E-01,.1934E-01,.3160E-01,.7236E-01,.4041E-02,&
 .1167E-02,.2559E-02,.5245E-02,.9079E-02,.1274E-01,.1567E-01,.1956E-01,.3193E-01,.7312E-01,.4078E-02,&
 .1178E-02,.2582E-02,.5294E-02,.9159E-02,.1286E-01,.1584E-01,.1978E-01,.3227E-01,.7393E-01,.4118E-02,&
 .1189E-02,.2607E-02,.5344E-02,.9242E-02,.1298E-01,.1601E-01,.2002E-01,.3264E-01,.7476E-01,.4158E-02,&
 .1201E-02,.2631E-02,.5395E-02,.9327E-02,.1311E-01,.1619E-01,.2026E-01,.3300E-01,.7560E-01,.4198E-02,&
 .1212E-02,.2657E-02,.5449E-02,.9415E-02,.1324E-01,.1637E-01,.2052E-01,.3339E-01,.7651E-01,.4241E-02,&
 .1225E-02,.2683E-02,.5504E-02,.9507E-02,.1337E-01,.1656E-01,.2078E-01,.3379E-01,.7742E-01,.4285E-02,&
 .1237E-02,.2711E-02,.5563E-02,.9602E-02,.1351E-01,.1676E-01,.2105E-01,.3421E-01,.7840E-01,.4331E-02,&
 .1252E-02,.2742E-02,.5627E-02,.9706E-02,.1367E-01,.1699E-01,.2136E-01,.3468E-01,.7950E-01,.4383E-02,&
 .1267E-02,.2775E-02,.5695E-02,.9819E-02,.1383E-01,.1722E-01,.2169E-01,.3517E-01,.8063E-01,.4437E-02,&
 .1284E-02,.2811E-02,.5771E-02,.9945E-02,.1402E-01,.1748E-01,.2205E-01,.3573E-01,.8192E-01,.4498E-02,&
 .1305E-02,.2856E-02,.5866E-02,.1010E-01,.1425E-01,.1780E-01,.2250E-01,.3641E-01,.8352E-01,.4573E-02,&
 .1335E-02,.2921E-02,.6002E-02,.1033E-01,.1458E-01,.1826E-01,.2312E-01,.3738E-01,.8575E-01,.4680E-02/
 data (((g_lw(ai,k,nh),ai= 2, 2),k=1,nwl_lw),nh=0,99)/ &
 .3489E-03,.7384E-03,.1593E-02,.2679E-02,.3583E-02,.4361E-02,.5349E-02,.8297E-02,.1781E-01,.1209E-02,&
 .3523E-03,.7457E-03,.1609E-02,.2705E-02,.3619E-02,.4404E-02,.5402E-02,.8380E-02,.1799E-01,.1221E-02,&
 .3558E-03,.7529E-03,.1625E-02,.2732E-02,.3654E-02,.4447E-02,.5455E-02,.8462E-02,.1817E-01,.1233E-02,&
 .3592E-03,.7602E-03,.1640E-02,.2758E-02,.3690E-02,.4490E-02,.5508E-02,.8544E-02,.1835E-01,.1245E-02,&
 .3627E-03,.7675E-03,.1656E-02,.2785E-02,.3725E-02,.4533E-02,.5561E-02,.8627E-02,.1852E-01,.1257E-02,&
 .3661E-03,.7747E-03,.1672E-02,.2811E-02,.3761E-02,.4576E-02,.5614E-02,.8709E-02,.1870E-01,.1269E-02,&
 .3695E-03,.7820E-03,.1687E-02,.2837E-02,.3796E-02,.4619E-02,.5666E-02,.8791E-02,.1888E-01,.1281E-02,&
 .3730E-03,.7892E-03,.1703E-02,.2864E-02,.3831E-02,.4662E-02,.5719E-02,.8873E-02,.1906E-01,.1293E-02,&
 .3764E-03,.7965E-03,.1719E-02,.2890E-02,.3866E-02,.4705E-02,.5772E-02,.8954E-02,.1923E-01,.1305E-02,&
 .3798E-03,.8037E-03,.1734E-02,.2916E-02,.3901E-02,.4748E-02,.5824E-02,.9036E-02,.1941E-01,.1317E-02,&
 .3832E-03,.8110E-03,.1750E-02,.2943E-02,.3937E-02,.4791E-02,.5877E-02,.9118E-02,.1959E-01,.1328E-02,&
 .3866E-03,.8182E-03,.1766E-02,.2969E-02,.3972E-02,.4834E-02,.5930E-02,.9199E-02,.1976E-01,.1340E-02,&
 .3900E-03,.8254E-03,.1781E-02,.2995E-02,.4007E-02,.4876E-02,.5982E-02,.9281E-02,.1994E-01,.1352E-02,&
 .3934E-03,.8326E-03,.1797E-02,.3021E-02,.4042E-02,.4919E-02,.6034E-02,.9362E-02,.2011E-01,.1364E-02,&
 .3968E-03,.8398E-03,.1812E-02,.3048E-02,.4077E-02,.4962E-02,.6087E-02,.9444E-02,.2029E-01,.1376E-02,&
 .4002E-03,.8469E-03,.1828E-02,.3074E-02,.4112E-02,.5004E-02,.6139E-02,.9526E-02,.2047E-01,.1387E-02,&
 .4036E-03,.8541E-03,.1843E-02,.3100E-02,.4147E-02,.5047E-02,.6191E-02,.9607E-02,.2064E-01,.1399E-02,&
 .4070E-03,.8613E-03,.1859E-02,.3126E-02,.4182E-02,.5090E-02,.6243E-02,.9688E-02,.2082E-01,.1411E-02,&
 .4103E-03,.8684E-03,.1874E-02,.3152E-02,.4216E-02,.5132E-02,.6296E-02,.9769E-02,.2099E-01,.1423E-02,&
 .4137E-03,.8756E-03,.1890E-02,.3177E-02,.4251E-02,.5175E-02,.6348E-02,.9851E-02,.2117E-01,.1434E-02,&
 .4171E-03,.8828E-03,.1905E-02,.3203E-02,.4286E-02,.5217E-02,.6400E-02,.9932E-02,.2134E-01,.1446E-02,&
 .4205E-03,.8898E-03,.1920E-02,.3229E-02,.4321E-02,.5259E-02,.6452E-02,.1001E-01,.2152E-01,.1458E-02,&
 .4238E-03,.8969E-03,.1936E-02,.3255E-02,.4355E-02,.5301E-02,.6503E-02,.1009E-01,.2169E-01,.1469E-02,&
 .4271E-03,.9039E-03,.1951E-02,.3281E-02,.4390E-02,.5343E-02,.6555E-02,.1017E-01,.2187E-01,.1481E-02,&
 .4305E-03,.9110E-03,.1966E-02,.3307E-02,.4424E-02,.5385E-02,.6607E-02,.1025E-01,.2204E-01,.1492E-02,&
 .4338E-03,.9181E-03,.1981E-02,.3333E-02,.4459E-02,.5427E-02,.6658E-02,.1034E-01,.2221E-01,.1504E-02,&
 .4372E-03,.9251E-03,.1997E-02,.3358E-02,.4493E-02,.5469E-02,.6710E-02,.1042E-01,.2239E-01,.1516E-02,&
 .4405E-03,.9321E-03,.2012E-02,.3384E-02,.4527E-02,.5511E-02,.6761E-02,.1050E-01,.2256E-01,.1527E-02,&
 .4438E-03,.9391E-03,.2027E-02,.3409E-02,.4562E-02,.5553E-02,.6812E-02,.1058E-01,.2273E-01,.1539E-02,&
 .4471E-03,.9461E-03,.2042E-02,.3435E-02,.4596E-02,.5595E-02,.6864E-02,.1066E-01,.2290E-01,.1550E-02,&
 .4504E-03,.9531E-03,.2057E-02,.3461E-02,.4630E-02,.5636E-02,.6915E-02,.1074E-01,.2308E-01,.1562E-02,&
 .4537E-03,.9601E-03,.2072E-02,.3486E-02,.4664E-02,.5678E-02,.6966E-02,.1081E-01,.2325E-01,.1573E-02,&
 .4570E-03,.9671E-03,.2087E-02,.3511E-02,.4698E-02,.5719E-02,.7017E-02,.1089E-01,.2342E-01,.1584E-02,&
 .4603E-03,.9741E-03,.2103E-02,.3537E-02,.4732E-02,.5761E-02,.7067E-02,.1097E-01,.2359E-01,.1596E-02,&
 .4636E-03,.9811E-03,.2118E-02,.3562E-02,.4766E-02,.5802E-02,.7118E-02,.1105E-01,.2376E-01,.1607E-02,&
 .4669E-03,.9881E-03,.2133E-02,.3588E-02,.4800E-02,.5844E-02,.7169E-02,.1113E-01,.2393E-01,.1619E-02,&
 .4701E-03,.9950E-03,.2148E-02,.3613E-02,.4834E-02,.5885E-02,.7220E-02,.1121E-01,.2410E-01,.1630E-02,&
 .4734E-03,.1002E-02,.2162E-02,.3638E-02,.4867E-02,.5926E-02,.7270E-02,.1129E-01,.2427E-01,.1641E-02,&
 .4766E-03,.1009E-02,.2177E-02,.3663E-02,.4901E-02,.5967E-02,.7320E-02,.1137E-01,.2444E-01,.1653E-02,&
 .4799E-03,.1016E-02,.2192E-02,.3688E-02,.4935E-02,.6008E-02,.7371E-02,.1145E-01,.2461E-01,.1664E-02,&
 .4831E-03,.1022E-02,.2207E-02,.3713E-02,.4968E-02,.6049E-02,.7421E-02,.1152E-01,.2478E-01,.1675E-02,&
 .4863E-03,.1029E-02,.2222E-02,.3738E-02,.5002E-02,.6089E-02,.7471E-02,.1160E-01,.2495E-01,.1686E-02,&
 .4896E-03,.1036E-02,.2237E-02,.3762E-02,.5035E-02,.6129E-02,.7521E-02,.1168E-01,.2512E-01,.1698E-02,&
 .4928E-03,.1043E-02,.2251E-02,.3787E-02,.5068E-02,.6170E-02,.7570E-02,.1176E-01,.2528E-01,.1709E-02,&
 .4960E-03,.1050E-02,.2266E-02,.3812E-02,.5101E-02,.6210E-02,.7620E-02,.1183E-01,.2545E-01,.1720E-02,&
 .4992E-03,.1057E-02,.2281E-02,.3837E-02,.5134E-02,.6251E-02,.7670E-02,.1191E-01,.2562E-01,.1731E-02,&
 .5023E-03,.1063E-02,.2295E-02,.3861E-02,.5167E-02,.6291E-02,.7719E-02,.1199E-01,.2578E-01,.1742E-02,&
 .5055E-03,.1070E-02,.2310E-02,.3886E-02,.5200E-02,.6331E-02,.7769E-02,.1206E-01,.2595E-01,.1753E-02,&
 .5087E-03,.1077E-02,.2324E-02,.3911E-02,.5233E-02,.6371E-02,.7818E-02,.1214E-01,.2611E-01,.1764E-02,&
 .5119E-03,.1083E-02,.2339E-02,.3935E-02,.5266E-02,.6411E-02,.7867E-02,.1222E-01,.2628E-01,.1775E-02,&
 .5151E-03,.1090E-02,.2353E-02,.3960E-02,.5299E-02,.6452E-02,.7916E-02,.1230E-01,.2645E-01,.1786E-02,&
 .5182E-03,.1097E-02,.2368E-02,.3984E-02,.5331E-02,.6491E-02,.7965E-02,.1237E-01,.2661E-01,.1797E-02,&
 .5213E-03,.1103E-02,.2382E-02,.4008E-02,.5364E-02,.6531E-02,.8014E-02,.1245E-01,.2677E-01,.1808E-02,&
 .5244E-03,.1110E-02,.2396E-02,.4032E-02,.5396E-02,.6570E-02,.8062E-02,.1252E-01,.2694E-01,.1819E-02,&
 .5276E-03,.1117E-02,.2411E-02,.4056E-02,.5429E-02,.6610E-02,.8111E-02,.1260E-01,.2710E-01,.1830E-02,&
 .5307E-03,.1123E-02,.2425E-02,.4080E-02,.5461E-02,.6649E-02,.8160E-02,.1268E-01,.2726E-01,.1841E-02,&
 .5334E-03,.1129E-02,.2437E-02,.4101E-02,.5491E-02,.6686E-02,.8207E-02,.1275E-01,.2744E-01,.1850E-02,&
 .5360E-03,.1135E-02,.2448E-02,.4121E-02,.5520E-02,.6723E-02,.8254E-02,.1283E-01,.2761E-01,.1859E-02,&
 .5387E-03,.1141E-02,.2460E-02,.4141E-02,.5549E-02,.6760E-02,.8301E-02,.1290E-01,.2778E-01,.1868E-02,&
 .5413E-03,.1146E-02,.2471E-02,.4161E-02,.5578E-02,.6797E-02,.8348E-02,.1298E-01,.2796E-01,.1877E-02,&
 .5440E-03,.1152E-02,.2483E-02,.4181E-02,.5608E-02,.6834E-02,.8395E-02,.1306E-01,.2813E-01,.1886E-02,&
 .5470E-03,.1159E-02,.2497E-02,.4205E-02,.5639E-02,.6873E-02,.8443E-02,.1313E-01,.2829E-01,.1897E-02,&
 .5501E-03,.1165E-02,.2511E-02,.4229E-02,.5671E-02,.6912E-02,.8491E-02,.1321E-01,.2845E-01,.1907E-02,&
 .5531E-03,.1172E-02,.2525E-02,.4252E-02,.5703E-02,.6951E-02,.8538E-02,.1328E-01,.2861E-01,.1918E-02,&
 .5562E-03,.1178E-02,.2539E-02,.4276E-02,.5735E-02,.6989E-02,.8586E-02,.1335E-01,.2877E-01,.1929E-02,&
 .5592E-03,.1184E-02,.2553E-02,.4300E-02,.5766E-02,.7028E-02,.8634E-02,.1343E-01,.2893E-01,.1939E-02,&
 .5612E-03,.1189E-02,.2560E-02,.4313E-02,.5791E-02,.7062E-02,.8681E-02,.1351E-01,.2914E-01,.1946E-02,&
 .5631E-03,.1193E-02,.2567E-02,.4327E-02,.5816E-02,.7096E-02,.8727E-02,.1359E-01,.2934E-01,.1952E-02,&
 .5650E-03,.1198E-02,.2574E-02,.4341E-02,.5841E-02,.7130E-02,.8774E-02,.1367E-01,.2954E-01,.1959E-02,&
 .5669E-03,.1202E-02,.2581E-02,.4354E-02,.5865E-02,.7164E-02,.8821E-02,.1375E-01,.2975E-01,.1965E-02,&
 .5689E-03,.1207E-02,.2588E-02,.4368E-02,.5890E-02,.7198E-02,.8867E-02,.1383E-01,.2995E-01,.1972E-02,&
 .5700E-03,.1210E-02,.2590E-02,.4375E-02,.5913E-02,.7235E-02,.8923E-02,.1393E-01,.3025E-01,.1975E-02,&
 .5712E-03,.1214E-02,.2591E-02,.4382E-02,.5936E-02,.7272E-02,.8980E-02,.1403E-01,.3054E-01,.1979E-02,&
 .5724E-03,.1217E-02,.2593E-02,.4389E-02,.5960E-02,.7310E-02,.9036E-02,.1414E-01,.3084E-01,.1983E-02,&
 .5736E-03,.1221E-02,.2595E-02,.4396E-02,.5983E-02,.7347E-02,.9092E-02,.1424E-01,.3113E-01,.1987E-02,&
 .5748E-03,.1224E-02,.2597E-02,.4403E-02,.6006E-02,.7384E-02,.9149E-02,.1435E-01,.3143E-01,.1990E-02,&
 .5772E-03,.1231E-02,.2605E-02,.4420E-02,.6042E-02,.7436E-02,.9224E-02,.1448E-01,.3179E-01,.1999E-02,&
 .5796E-03,.1237E-02,.2613E-02,.4437E-02,.6078E-02,.7488E-02,.9300E-02,.1461E-01,.3215E-01,.2007E-02,&
 .5821E-03,.1243E-02,.2621E-02,.4454E-02,.6113E-02,.7540E-02,.9375E-02,.1474E-01,.3251E-01,.2016E-02,&
 .5845E-03,.1250E-02,.2629E-02,.4471E-02,.6149E-02,.7592E-02,.9451E-02,.1488E-01,.3287E-01,.2024E-02,&
 .5869E-03,.1256E-02,.2637E-02,.4488E-02,.6185E-02,.7644E-02,.9526E-02,.1501E-01,.3322E-01,.2032E-02,&
 .5903E-03,.1265E-02,.2649E-02,.4513E-02,.6234E-02,.7715E-02,.9626E-02,.1519E-01,.3370E-01,.2045E-02,&
 .5940E-03,.1273E-02,.2664E-02,.4540E-02,.6281E-02,.7779E-02,.9715E-02,.1534E-01,.3409E-01,.2058E-02,&
 .5983E-03,.1284E-02,.2681E-02,.4572E-02,.6337E-02,.7858E-02,.9824E-02,.1553E-01,.3458E-01,.2073E-02,&
 .6025E-03,.1294E-02,.2698E-02,.4604E-02,.6389E-02,.7927E-02,.9917E-02,.1569E-01,.3498E-01,.2088E-02,&
 .6074E-03,.1306E-02,.2719E-02,.4641E-02,.6452E-02,.8012E-02,.1003E-01,.1589E-01,.3548E-01,.2106E-02,&
 .6128E-03,.1318E-02,.2741E-02,.4682E-02,.6518E-02,.8102E-02,.1016E-01,.1610E-01,.3599E-01,.2125E-02,&
 .6176E-03,.1330E-02,.2762E-02,.4719E-02,.6576E-02,.8177E-02,.1026E-01,.1626E-01,.3641E-01,.2142E-02,&
 .6235E-03,.1343E-02,.2787E-02,.4765E-02,.6646E-02,.8272E-02,.1038E-01,.1648E-01,.3693E-01,.2163E-02,&
 .6287E-03,.1355E-02,.2810E-02,.4805E-02,.6707E-02,.8351E-02,.1049E-01,.1665E-01,.3735E-01,.2182E-02,&
 .6351E-03,.1370E-02,.2838E-02,.4854E-02,.6782E-02,.8450E-02,.1062E-01,.1687E-01,.3789E-01,.2204E-02,&
 .6417E-03,.1385E-02,.2866E-02,.4904E-02,.6860E-02,.8552E-02,.1075E-01,.1709E-01,.3843E-01,.2228E-02,&
 .6484E-03,.1401E-02,.2896E-02,.4957E-02,.6939E-02,.8655E-02,.1089E-01,.1732E-01,.3898E-01,.2252E-02,&
 .6555E-03,.1416E-02,.2928E-02,.5011E-02,.7021E-02,.8761E-02,.1103E-01,.1755E-01,.3954E-01,.2277E-02,&
 .6639E-03,.1436E-02,.2965E-02,.5077E-02,.7119E-02,.8888E-02,.1120E-01,.1783E-01,.4020E-01,.2307E-02,&
 .6725E-03,.1456E-02,.3004E-02,.5144E-02,.7219E-02,.9019E-02,.1137E-01,.1812E-01,.4088E-01,.2338E-02,&
 .6828E-03,.1479E-02,.3049E-02,.5224E-02,.7337E-02,.9171E-02,.1157E-01,.1845E-01,.4168E-01,.2375E-02,&
 .6960E-03,.1509E-02,.3108E-02,.5327E-02,.7489E-02,.9367E-02,.1183E-01,.1888E-01,.4270E-01,.2422E-02,&
 .7109E-03,.1542E-02,.3176E-02,.5444E-02,.7660E-02,.9588E-02,.1212E-01,.1936E-01,.4383E-01,.2476E-02,&
 .7427E-03,.1615E-02,.3320E-02,.5694E-02,.8024E-02,.1006E-01,.1272E-01,.2037E-01,.4624E-01,.2591E-02/
 data (((g_lw(ai,k,nh),ai= 3, 3),k=1,nwl_lw),nh=0,99)/ &
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02/
 data (((g_lw(ai,k,nh),ai= 4, 4),k=1,nwl_lw),nh=0,99)/ &
 .4115E-03,.9877E-03,.1945E-02,.3501E-02,.5463E-02,.6679E-02,.5981E-02,.1042E-01,.2355E-01,.1645E-02,&
 .4165E-03,.9984E-03,.1967E-02,.3538E-02,.5512E-02,.6739E-02,.6069E-02,.1056E-01,.2387E-01,.1662E-02,&
 .4214E-03,.1009E-02,.1989E-02,.3574E-02,.5561E-02,.6799E-02,.6157E-02,.1070E-01,.2419E-01,.1679E-02,&
 .4264E-03,.1020E-02,.2011E-02,.3611E-02,.5611E-02,.6859E-02,.6245E-02,.1085E-01,.2452E-01,.1696E-02,&
 .4313E-03,.1030E-02,.2034E-02,.3648E-02,.5660E-02,.6920E-02,.6333E-02,.1099E-01,.2484E-01,.1713E-02,&
 .4363E-03,.1041E-02,.2056E-02,.3684E-02,.5709E-02,.6980E-02,.6420E-02,.1113E-01,.2517E-01,.1730E-02,&
 .4414E-03,.1052E-02,.2079E-02,.3722E-02,.5761E-02,.7043E-02,.6511E-02,.1128E-01,.2550E-01,.1747E-02,&
 .4466E-03,.1063E-02,.2102E-02,.3760E-02,.5812E-02,.7106E-02,.6602E-02,.1142E-01,.2584E-01,.1765E-02,&
 .4517E-03,.1074E-02,.2125E-02,.3798E-02,.5863E-02,.7169E-02,.6693E-02,.1157E-01,.2617E-01,.1783E-02,&
 .4569E-03,.1085E-02,.2148E-02,.3836E-02,.5915E-02,.7232E-02,.6784E-02,.1172E-01,.2651E-01,.1800E-02,&
 .4620E-03,.1096E-02,.2171E-02,.3874E-02,.5966E-02,.7295E-02,.6875E-02,.1186E-01,.2685E-01,.1818E-02,&
 .4673E-03,.1107E-02,.2194E-02,.3914E-02,.6020E-02,.7361E-02,.6969E-02,.1201E-01,.2719E-01,.1836E-02,&
 .4726E-03,.1119E-02,.2218E-02,.3953E-02,.6073E-02,.7427E-02,.7063E-02,.1216E-01,.2754E-01,.1854E-02,&
 .4779E-03,.1130E-02,.2242E-02,.3992E-02,.6127E-02,.7493E-02,.7157E-02,.1232E-01,.2788E-01,.1872E-02,&
 .4832E-03,.1142E-02,.2266E-02,.4032E-02,.6180E-02,.7558E-02,.7251E-02,.1247E-01,.2823E-01,.1890E-02,&
 .4885E-03,.1153E-02,.2289E-02,.4071E-02,.6234E-02,.7624E-02,.7345E-02,.1262E-01,.2857E-01,.1909E-02,&
 .4940E-03,.1165E-02,.2314E-02,.4112E-02,.6289E-02,.7693E-02,.7442E-02,.1277E-01,.2893E-01,.1927E-02,&
 .4995E-03,.1177E-02,.2338E-02,.4153E-02,.6345E-02,.7762E-02,.7539E-02,.1293E-01,.2929E-01,.1946E-02,&
 .5049E-03,.1188E-02,.2363E-02,.4194E-02,.6401E-02,.7830E-02,.7636E-02,.1309E-01,.2965E-01,.1965E-02,&
 .5104E-03,.1200E-02,.2387E-02,.4235E-02,.6456E-02,.7899E-02,.7733E-02,.1324E-01,.3000E-01,.1984E-02,&
 .5159E-03,.1212E-02,.2412E-02,.4275E-02,.6512E-02,.7968E-02,.7830E-02,.1340E-01,.3036E-01,.2002E-02,&
 .5215E-03,.1224E-02,.2437E-02,.4318E-02,.6569E-02,.8039E-02,.7930E-02,.1356E-01,.3073E-01,.2022E-02,&
 .5272E-03,.1236E-02,.2462E-02,.4360E-02,.6627E-02,.8110E-02,.8030E-02,.1372E-01,.3109E-01,.2041E-02,&
 .5328E-03,.1248E-02,.2488E-02,.4402E-02,.6685E-02,.8182E-02,.8130E-02,.1388E-01,.3146E-01,.2060E-02,&
 .5385E-03,.1261E-02,.2513E-02,.4444E-02,.6742E-02,.8253E-02,.8230E-02,.1404E-01,.3183E-01,.2080E-02,&
 .5441E-03,.1273E-02,.2538E-02,.4486E-02,.6800E-02,.8324E-02,.8330E-02,.1420E-01,.3219E-01,.2099E-02,&
 .5499E-03,.1285E-02,.2564E-02,.4530E-02,.6860E-02,.8399E-02,.8434E-02,.1437E-01,.3257E-01,.2119E-02,&
 .5558E-03,.1298E-02,.2590E-02,.4574E-02,.6920E-02,.8473E-02,.8537E-02,.1453E-01,.3295E-01,.2139E-02,&
 .5616E-03,.1310E-02,.2616E-02,.4617E-02,.6979E-02,.8547E-02,.8640E-02,.1470E-01,.3333E-01,.2159E-02,&
 .5674E-03,.1323E-02,.2642E-02,.4661E-02,.7039E-02,.8622E-02,.8743E-02,.1486E-01,.3371E-01,.2179E-02,&
 .5732E-03,.1335E-02,.2668E-02,.4704E-02,.7099E-02,.8696E-02,.8847E-02,.1503E-01,.3409E-01,.2199E-02,&
 .5792E-03,.1348E-02,.2695E-02,.4749E-02,.7161E-02,.8772E-02,.8952E-02,.1520E-01,.3447E-01,.2219E-02,&
 .5852E-03,.1361E-02,.2721E-02,.4794E-02,.7222E-02,.8849E-02,.9058E-02,.1537E-01,.3486E-01,.2240E-02,&
 .5912E-03,.1374E-02,.2748E-02,.4839E-02,.7284E-02,.8925E-02,.9163E-02,.1554E-01,.3525E-01,.2261E-02,&
 .5971E-03,.1387E-02,.2775E-02,.4884E-02,.7346E-02,.9001E-02,.9269E-02,.1570E-01,.3564E-01,.2281E-02,&
 .6031E-03,.1400E-02,.2801E-02,.4929E-02,.7408E-02,.9078E-02,.9374E-02,.1587E-01,.3603E-01,.2302E-02,&
 .6093E-03,.1413E-02,.2829E-02,.4975E-02,.7471E-02,.9158E-02,.9483E-02,.1605E-01,.3643E-01,.2323E-02,&
 .6154E-03,.1427E-02,.2857E-02,.5022E-02,.7535E-02,.9237E-02,.9593E-02,.1622E-01,.3683E-01,.2344E-02,&
 .6216E-03,.1440E-02,.2884E-02,.5068E-02,.7599E-02,.9317E-02,.9702E-02,.1640E-01,.3723E-01,.2365E-02,&
 .6278E-03,.1453E-02,.2912E-02,.5114E-02,.7663E-02,.9397E-02,.9811E-02,.1658E-01,.3763E-01,.2387E-02,&
 .6339E-03,.1467E-02,.2939E-02,.5161E-02,.7726E-02,.9477E-02,.9920E-02,.1675E-01,.3802E-01,.2408E-02,&
 .6403E-03,.1480E-02,.2968E-02,.5209E-02,.7792E-02,.9559E-02,.1003E-01,.1693E-01,.3844E-01,.2430E-02,&
 .6466E-03,.1494E-02,.2996E-02,.5256E-02,.7858E-02,.9641E-02,.1014E-01,.1711E-01,.3885E-01,.2451E-02,&
 .6529E-03,.1507E-02,.3024E-02,.5304E-02,.7924E-02,.9723E-02,.1026E-01,.1729E-01,.3926E-01,.2473E-02,&
 .6593E-03,.1521E-02,.3053E-02,.5352E-02,.7989E-02,.9805E-02,.1037E-01,.1747E-01,.3967E-01,.2495E-02,&
 .6656E-03,.1535E-02,.3081E-02,.5400E-02,.8055E-02,.9887E-02,.1048E-01,.1765E-01,.4008E-01,.2517E-02,&
 .6721E-03,.1549E-02,.3110E-02,.5449E-02,.8123E-02,.9971E-02,.1059E-01,.1783E-01,.4050E-01,.2539E-02,&
 .6786E-03,.1563E-02,.3139E-02,.5498E-02,.8191E-02,.1006E-01,.1071E-01,.1802E-01,.4092E-01,.2562E-02,&
 .6851E-03,.1577E-02,.3168E-02,.5547E-02,.8259E-02,.1014E-01,.1082E-01,.1820E-01,.4133E-01,.2584E-02,&
 .6916E-03,.1591E-02,.3197E-02,.5596E-02,.8327E-02,.1023E-01,.1094E-01,.1838E-01,.4175E-01,.2607E-02,&
 .6981E-03,.1605E-02,.3226E-02,.5645E-02,.8394E-02,.1031E-01,.1105E-01,.1857E-01,.4217E-01,.2629E-02,&
 .7048E-03,.1619E-02,.3256E-02,.5695E-02,.8462E-02,.1040E-01,.1117E-01,.1876E-01,.4261E-01,.2652E-02,&
 .7114E-03,.1634E-02,.3286E-02,.5744E-02,.8530E-02,.1048E-01,.1129E-01,.1895E-01,.4305E-01,.2674E-02,&
 .7181E-03,.1648E-02,.3315E-02,.5794E-02,.8597E-02,.1056E-01,.1141E-01,.1914E-01,.4349E-01,.2697E-02,&
 .7248E-03,.1662E-02,.3345E-02,.5844E-02,.8665E-02,.1065E-01,.1153E-01,.1933E-01,.4392E-01,.2719E-02,&
 .7314E-03,.1676E-02,.3374E-02,.5894E-02,.8732E-02,.1073E-01,.1165E-01,.1952E-01,.4436E-01,.2742E-02,&
 .7383E-03,.1691E-02,.3405E-02,.5945E-02,.8803E-02,.1082E-01,.1178E-01,.1972E-01,.4481E-01,.2765E-02,&
 .7452E-03,.1706E-02,.3435E-02,.5996E-02,.8873E-02,.1091E-01,.1190E-01,.1991E-01,.4526E-01,.2789E-02,&
 .7520E-03,.1720E-02,.3466E-02,.6047E-02,.8944E-02,.1100E-01,.1202E-01,.2011E-01,.4571E-01,.2812E-02,&
 .7589E-03,.1735E-02,.3496E-02,.6099E-02,.9014E-02,.1109E-01,.1215E-01,.2031E-01,.4615E-01,.2835E-02,&
 .7657E-03,.1750E-02,.3527E-02,.6150E-02,.9085E-02,.1117E-01,.1227E-01,.2050E-01,.4660E-01,.2858E-02,&
 .7728E-03,.1765E-02,.3558E-02,.6203E-02,.9159E-02,.1127E-01,.1239E-01,.2070E-01,.4705E-01,.2883E-02,&
 .7799E-03,.1780E-02,.3590E-02,.6257E-02,.9233E-02,.1136E-01,.1252E-01,.2090E-01,.4751E-01,.2907E-02,&
 .7870E-03,.1795E-02,.3621E-02,.6310E-02,.9307E-02,.1145E-01,.1264E-01,.2110E-01,.4796E-01,.2931E-02,&
 .7940E-03,.1810E-02,.3652E-02,.6364E-02,.9381E-02,.1155E-01,.1277E-01,.2129E-01,.4841E-01,.2956E-02,&
 .8011E-03,.1825E-02,.3684E-02,.6417E-02,.9455E-02,.1164E-01,.1289E-01,.2149E-01,.4886E-01,.2980E-02,&
 .8083E-03,.1841E-02,.3716E-02,.6471E-02,.9529E-02,.1173E-01,.1302E-01,.2170E-01,.4933E-01,.3005E-02,&
 .8155E-03,.1857E-02,.3748E-02,.6526E-02,.9604E-02,.1183E-01,.1315E-01,.2190E-01,.4981E-01,.3029E-02,&
 .8227E-03,.1872E-02,.3780E-02,.6580E-02,.9678E-02,.1192E-01,.1328E-01,.2211E-01,.5028E-01,.3054E-02,&
 .8299E-03,.1888E-02,.3812E-02,.6634E-02,.9753E-02,.1202E-01,.1341E-01,.2232E-01,.5075E-01,.3078E-02,&
 .8371E-03,.1903E-02,.3845E-02,.6688E-02,.9828E-02,.1211E-01,.1354E-01,.2252E-01,.5122E-01,.3103E-02,&
 .8446E-03,.1919E-02,.3878E-02,.6744E-02,.9900E-02,.1220E-01,.1368E-01,.2274E-01,.5172E-01,.3128E-02,&
 .8521E-03,.1935E-02,.3910E-02,.6799E-02,.9973E-02,.1229E-01,.1382E-01,.2296E-01,.5222E-01,.3152E-02,&
 .8596E-03,.1950E-02,.3943E-02,.6854E-02,.1005E-01,.1239E-01,.1396E-01,.2318E-01,.5273E-01,.3177E-02,&
 .8671E-03,.1966E-02,.3976E-02,.6909E-02,.1012E-01,.1248E-01,.1410E-01,.2340E-01,.5323E-01,.3202E-02,&
 .8746E-03,.1982E-02,.4009E-02,.6964E-02,.1019E-01,.1257E-01,.1423E-01,.2362E-01,.5373E-01,.3226E-02,&
 .8825E-03,.1998E-02,.4043E-02,.7021E-02,.1027E-01,.1267E-01,.1439E-01,.2385E-01,.5427E-01,.3251E-02,&
 .8903E-03,.2014E-02,.4077E-02,.7077E-02,.1034E-01,.1277E-01,.1454E-01,.2408E-01,.5481E-01,.3277E-02,&
 .8982E-03,.2030E-02,.4112E-02,.7134E-02,.1042E-01,.1286E-01,.1469E-01,.2432E-01,.5534E-01,.3302E-02,&
 .9061E-03,.2046E-02,.4146E-02,.7191E-02,.1049E-01,.1296E-01,.1484E-01,.2455E-01,.5588E-01,.3327E-02,&
 .9140E-03,.2063E-02,.4180E-02,.7248E-02,.1056E-01,.1305E-01,.1499E-01,.2479E-01,.5642E-01,.3352E-02,&
 .9219E-03,.2079E-02,.4215E-02,.7306E-02,.1064E-01,.1315E-01,.1515E-01,.2503E-01,.5699E-01,.3378E-02,&
 .9303E-03,.2096E-02,.4251E-02,.7365E-02,.1072E-01,.1325E-01,.1531E-01,.2528E-01,.5756E-01,.3404E-02,&
 .9387E-03,.2113E-02,.4287E-02,.7425E-02,.1079E-01,.1335E-01,.1548E-01,.2553E-01,.5813E-01,.3430E-02,&
 .9471E-03,.2130E-02,.4323E-02,.7485E-02,.1087E-01,.1345E-01,.1563E-01,.2578E-01,.5871E-01,.3457E-02,&
 .9557E-03,.2147E-02,.4360E-02,.7546E-02,.1095E-01,.1355E-01,.1581E-01,.2604E-01,.5932E-01,.3484E-02,&
 .9644E-03,.2165E-02,.4398E-02,.7609E-02,.1103E-01,.1366E-01,.1599E-01,.2631E-01,.5994E-01,.3511E-02,&
 .9735E-03,.2183E-02,.4437E-02,.7673E-02,.1111E-01,.1376E-01,.1618E-01,.2659E-01,.6060E-01,.3538E-02,&
 .9828E-03,.2201E-02,.4477E-02,.7738E-02,.1119E-01,.1387E-01,.1636E-01,.2688E-01,.6126E-01,.3567E-02,&
 .9926E-03,.2220E-02,.4518E-02,.7805E-02,.1127E-01,.1398E-01,.1656E-01,.2718E-01,.6196E-01,.3595E-02,&
 .1002E-02,.2240E-02,.4559E-02,.7874E-02,.1136E-01,.1409E-01,.1676E-01,.2749E-01,.6266E-01,.3625E-02,&
 .1013E-02,.2260E-02,.4603E-02,.7945E-02,.1145E-01,.1421E-01,.1697E-01,.2780E-01,.6340E-01,.3655E-02,&
 .1023E-02,.2280E-02,.4647E-02,.8019E-02,.1154E-01,.1434E-01,.1719E-01,.2814E-01,.6417E-01,.3687E-02,&
 .1035E-02,.2303E-02,.4696E-02,.8099E-02,.1164E-01,.1447E-01,.1744E-01,.2850E-01,.6502E-01,.3721E-02,&
 .1047E-02,.2326E-02,.4746E-02,.8182E-02,.1173E-01,.1461E-01,.1769E-01,.2887E-01,.6589E-01,.3756E-02,&
 .1060E-02,.2352E-02,.4802E-02,.8275E-02,.1185E-01,.1476E-01,.1797E-01,.2930E-01,.6689E-01,.3794E-02,&
 .1075E-02,.2380E-02,.4865E-02,.8379E-02,.1198E-01,.1494E-01,.1829E-01,.2978E-01,.6800E-01,.3838E-02,&
 .1091E-02,.2412E-02,.4933E-02,.8492E-02,.1212E-01,.1513E-01,.1863E-01,.3028E-01,.6919E-01,.3886E-02,&
 .1112E-02,.2452E-02,.5021E-02,.8639E-02,.1230E-01,.1538E-01,.1907E-01,.3094E-01,.7072E-01,.3947E-02,&
 .1139E-02,.2506E-02,.5137E-02,.8835E-02,.1255E-01,.1572E-01,.1963E-01,.3179E-01,.7270E-01,.4030E-02/
 data (((g_lw(ai,k,nh),ai= 5, 5),k=1,nwl_lw),nh=0,99)/ &
 .1481E+00,.2519E+00,.3517E+00,.4244E+00,.4530E+00,.4774E+00,.5189E+00,.5612E+00,.6172E+00,.3172E+00,&
 .1497E+00,.2526E+00,.3520E+00,.4269E+00,.4564E+00,.4808E+00,.5221E+00,.5645E+00,.6203E+00,.3173E+00,&
 .1513E+00,.2533E+00,.3523E+00,.4293E+00,.4598E+00,.4842E+00,.5252E+00,.5678E+00,.6234E+00,.3175E+00,&
 .1529E+00,.2541E+00,.3526E+00,.4317E+00,.4632E+00,.4877E+00,.5283E+00,.5711E+00,.6265E+00,.3176E+00,&
 .1545E+00,.2548E+00,.3529E+00,.4342E+00,.4666E+00,.4911E+00,.5315E+00,.5744E+00,.6296E+00,.3177E+00,&
 .1561E+00,.2556E+00,.3532E+00,.4366E+00,.4700E+00,.4946E+00,.5346E+00,.5777E+00,.6326E+00,.3178E+00,&
 .1577E+00,.2565E+00,.3537E+00,.4389E+00,.4732E+00,.4978E+00,.5375E+00,.5807E+00,.6354E+00,.3182E+00,&
 .1593E+00,.2574E+00,.3542E+00,.4412E+00,.4763E+00,.5010E+00,.5404E+00,.5836E+00,.6381E+00,.3186E+00,&
 .1609E+00,.2583E+00,.3547E+00,.4435E+00,.4795E+00,.5042E+00,.5433E+00,.5866E+00,.6408E+00,.3190E+00,&
 .1625E+00,.2593E+00,.3552E+00,.4458E+00,.4827E+00,.5074E+00,.5462E+00,.5895E+00,.6436E+00,.3194E+00,&
 .1641E+00,.2602E+00,.3557E+00,.4481E+00,.4859E+00,.5106E+00,.5491E+00,.5925E+00,.6463E+00,.3198E+00,&
 .1657E+00,.2613E+00,.3564E+00,.4503E+00,.4889E+00,.5136E+00,.5519E+00,.5952E+00,.6487E+00,.3205E+00,&
 .1673E+00,.2623E+00,.3572E+00,.4525E+00,.4919E+00,.5166E+00,.5546E+00,.5979E+00,.6512E+00,.3211E+00,&
 .1689E+00,.2634E+00,.3579E+00,.4547E+00,.4949E+00,.5197E+00,.5574E+00,.6006E+00,.6536E+00,.3218E+00,&
 .1705E+00,.2645E+00,.3586E+00,.4570E+00,.4979E+00,.5227E+00,.5601E+00,.6033E+00,.6560E+00,.3225E+00,&
 .1721E+00,.2656E+00,.3594E+00,.4592E+00,.5010E+00,.5257E+00,.5628E+00,.6060E+00,.6585E+00,.3231E+00,&
 .1737E+00,.2667E+00,.3603E+00,.4613E+00,.5038E+00,.5285E+00,.5654E+00,.6085E+00,.6606E+00,.3240E+00,&
 .1752E+00,.2679E+00,.3613E+00,.4635E+00,.5066E+00,.5314E+00,.5679E+00,.6109E+00,.6628E+00,.3248E+00,&
 .1768E+00,.2690E+00,.3622E+00,.4657E+00,.5095E+00,.5342E+00,.5705E+00,.6134E+00,.6649E+00,.3256E+00,&
 .1784E+00,.2702E+00,.3631E+00,.4678E+00,.5123E+00,.5370E+00,.5730E+00,.6159E+00,.6670E+00,.3265E+00,&
 .1800E+00,.2714E+00,.3641E+00,.4700E+00,.5151E+00,.5398E+00,.5756E+00,.6184E+00,.6692E+00,.3273E+00,&
 .1815E+00,.2726E+00,.3652E+00,.4722E+00,.5178E+00,.5425E+00,.5780E+00,.6207E+00,.6712E+00,.3283E+00,&
 .1831E+00,.2739E+00,.3662E+00,.4743E+00,.5205E+00,.5452E+00,.5804E+00,.6230E+00,.6731E+00,.3293E+00,&
 .1846E+00,.2751E+00,.3673E+00,.4764E+00,.5232E+00,.5479E+00,.5828E+00,.6253E+00,.6751E+00,.3303E+00,&
 .1862E+00,.2763E+00,.3684E+00,.4786E+00,.5259E+00,.5506E+00,.5853E+00,.6276E+00,.6770E+00,.3313E+00,&
 .1877E+00,.2776E+00,.3695E+00,.4807E+00,.5286E+00,.5533E+00,.5877E+00,.6299E+00,.6790E+00,.3323E+00,&
 .1893E+00,.2789E+00,.3707E+00,.4828E+00,.5312E+00,.5558E+00,.5899E+00,.6320E+00,.6807E+00,.3334E+00,&
 .1908E+00,.2801E+00,.3719E+00,.4849E+00,.5338E+00,.5583E+00,.5922E+00,.6341E+00,.6825E+00,.3345E+00,&
 .1923E+00,.2814E+00,.3731E+00,.4870E+00,.5363E+00,.5608E+00,.5944E+00,.6362E+00,.6842E+00,.3356E+00,&
 .1939E+00,.2827E+00,.3743E+00,.4891E+00,.5389E+00,.5633E+00,.5967E+00,.6383E+00,.6860E+00,.3367E+00,&
 .1954E+00,.2840E+00,.3755E+00,.4912E+00,.5414E+00,.5659E+00,.5990E+00,.6405E+00,.6877E+00,.3378E+00,&
 .1969E+00,.2853E+00,.3767E+00,.4933E+00,.5439E+00,.5682E+00,.6011E+00,.6425E+00,.6893E+00,.3389E+00,&
 .1984E+00,.2866E+00,.3780E+00,.4953E+00,.5463E+00,.5706E+00,.6032E+00,.6445E+00,.6909E+00,.3401E+00,&
 .1999E+00,.2879E+00,.3793E+00,.4974E+00,.5487E+00,.5730E+00,.6054E+00,.6464E+00,.6925E+00,.3413E+00,&
 .2014E+00,.2892E+00,.3806E+00,.4995E+00,.5512E+00,.5754E+00,.6075E+00,.6484E+00,.6941E+00,.3425E+00,&
 .2029E+00,.2905E+00,.3819E+00,.5015E+00,.5536E+00,.5778E+00,.6096E+00,.6504E+00,.6957E+00,.3436E+00,&
 .2044E+00,.2918E+00,.3832E+00,.5035E+00,.5559E+00,.5800E+00,.6116E+00,.6523E+00,.6971E+00,.3449E+00,&
 .2058E+00,.2931E+00,.3845E+00,.5055E+00,.5582E+00,.5823E+00,.6136E+00,.6541E+00,.6986E+00,.3461E+00,&
 .2073E+00,.2945E+00,.3858E+00,.5075E+00,.5605E+00,.5845E+00,.6156E+00,.6559E+00,.7000E+00,.3473E+00,&
 .2088E+00,.2958E+00,.3871E+00,.5095E+00,.5628E+00,.5868E+00,.6176E+00,.6578E+00,.7014E+00,.3485E+00,&
 .2103E+00,.2971E+00,.3884E+00,.5115E+00,.5652E+00,.5890E+00,.6196E+00,.6596E+00,.7028E+00,.3497E+00,&
 .2117E+00,.2984E+00,.3898E+00,.5135E+00,.5674E+00,.5912E+00,.6215E+00,.6614E+00,.7042E+00,.3510E+00,&
 .2132E+00,.2998E+00,.3912E+00,.5155E+00,.5696E+00,.5933E+00,.6234E+00,.6631E+00,.7055E+00,.3523E+00,&
 .2146E+00,.3011E+00,.3925E+00,.5174E+00,.5718E+00,.5954E+00,.6253E+00,.6648E+00,.7069E+00,.3535E+00,&
 .2161E+00,.3024E+00,.3939E+00,.5194E+00,.5740E+00,.5976E+00,.6272E+00,.6666E+00,.7082E+00,.3548E+00,&
 .2175E+00,.3038E+00,.3953E+00,.5214E+00,.5763E+00,.5997E+00,.6291E+00,.6683E+00,.7095E+00,.3561E+00,&
 .2189E+00,.3051E+00,.3967E+00,.5233E+00,.5783E+00,.6017E+00,.6309E+00,.6699E+00,.7107E+00,.3573E+00,&
 .2204E+00,.3064E+00,.3980E+00,.5252E+00,.5804E+00,.6038E+00,.6327E+00,.6715E+00,.7119E+00,.3586E+00,&
 .2218E+00,.3077E+00,.3994E+00,.5271E+00,.5825E+00,.6058E+00,.6345E+00,.6731E+00,.7131E+00,.3599E+00,&
 .2232E+00,.3091E+00,.4008E+00,.5290E+00,.5846E+00,.6078E+00,.6363E+00,.6748E+00,.7143E+00,.3612E+00,&
 .2246E+00,.3104E+00,.4022E+00,.5310E+00,.5867E+00,.6098E+00,.6381E+00,.6764E+00,.7155E+00,.3624E+00,&
 .2257E+00,.3115E+00,.4033E+00,.5325E+00,.5884E+00,.6114E+00,.6395E+00,.6776E+00,.7164E+00,.3635E+00,&
 .2269E+00,.3126E+00,.4045E+00,.5341E+00,.5900E+00,.6130E+00,.6409E+00,.6789E+00,.7173E+00,.3646E+00,&
 .2281E+00,.3137E+00,.4056E+00,.5356E+00,.5917E+00,.6146E+00,.6423E+00,.6802E+00,.7182E+00,.3656E+00,&
 .2292E+00,.3148E+00,.4068E+00,.5372E+00,.5934E+00,.6162E+00,.6437E+00,.6815E+00,.7191E+00,.3667E+00,&
 .2304E+00,.3159E+00,.4079E+00,.5387E+00,.5951E+00,.6178E+00,.6451E+00,.6827E+00,.7201E+00,.3678E+00,&
 .2315E+00,.3169E+00,.4091E+00,.5403E+00,.5967E+00,.6193E+00,.6464E+00,.6839E+00,.7210E+00,.3689E+00,&
 .2327E+00,.3180E+00,.4102E+00,.5418E+00,.5983E+00,.6208E+00,.6478E+00,.6851E+00,.7219E+00,.3699E+00,&
 .2338E+00,.3191E+00,.4114E+00,.5433E+00,.5999E+00,.6223E+00,.6491E+00,.6864E+00,.7228E+00,.3710E+00,&
 .2349E+00,.3202E+00,.4126E+00,.5448E+00,.6015E+00,.6239E+00,.6505E+00,.6876E+00,.7237E+00,.3721E+00,&
 .2361E+00,.3213E+00,.4137E+00,.5463E+00,.6031E+00,.6254E+00,.6518E+00,.6888E+00,.7246E+00,.3732E+00,&
 .2372E+00,.3224E+00,.4149E+00,.5478E+00,.6046E+00,.6268E+00,.6531E+00,.6899E+00,.7253E+00,.3742E+00,&
 .2383E+00,.3235E+00,.4160E+00,.5493E+00,.6062E+00,.6283E+00,.6544E+00,.6911E+00,.7261E+00,.3753E+00,&
 .2394E+00,.3245E+00,.4172E+00,.5508E+00,.6077E+00,.6297E+00,.6557E+00,.6922E+00,.7269E+00,.3764E+00,&
 .2405E+00,.3256E+00,.4183E+00,.5522E+00,.6092E+00,.6312E+00,.6569E+00,.6933E+00,.7277E+00,.3775E+00,&
 .2416E+00,.3267E+00,.4195E+00,.5537E+00,.6108E+00,.6326E+00,.6582E+00,.6945E+00,.7284E+00,.3785E+00,&
 .2427E+00,.3277E+00,.4206E+00,.5552E+00,.6123E+00,.6340E+00,.6594E+00,.6956E+00,.7292E+00,.3796E+00,&
 .2438E+00,.3288E+00,.4217E+00,.5566E+00,.6137E+00,.6354E+00,.6607E+00,.6967E+00,.7299E+00,.3807E+00,&
 .2449E+00,.3299E+00,.4229E+00,.5581E+00,.6152E+00,.6368E+00,.6619E+00,.6977E+00,.7307E+00,.3817E+00,&
 .2460E+00,.3309E+00,.4240E+00,.5595E+00,.6167E+00,.6382E+00,.6631E+00,.6988E+00,.7314E+00,.3828E+00,&
 .2471E+00,.3320E+00,.4252E+00,.5609E+00,.6182E+00,.6396E+00,.6643E+00,.6999E+00,.7322E+00,.3839E+00,&
 .2488E+00,.3337E+00,.4270E+00,.5632E+00,.6205E+00,.6417E+00,.6662E+00,.7016E+00,.7333E+00,.3856E+00,&
 .2506E+00,.3354E+00,.4289E+00,.5655E+00,.6228E+00,.6439E+00,.6681E+00,.7032E+00,.7345E+00,.3873E+00,&
 .2523E+00,.3371E+00,.4307E+00,.5677E+00,.6250E+00,.6460E+00,.6700E+00,.7049E+00,.7356E+00,.3890E+00,&
 .2540E+00,.3388E+00,.4325E+00,.5700E+00,.6273E+00,.6481E+00,.6718E+00,.7066E+00,.7368E+00,.3908E+00,&
 .2558E+00,.3405E+00,.4343E+00,.5722E+00,.6296E+00,.6503E+00,.6737E+00,.7082E+00,.7379E+00,.3925E+00,&
 .2578E+00,.3426E+00,.4366E+00,.5749E+00,.6322E+00,.6527E+00,.6759E+00,.7101E+00,.7392E+00,.3946E+00,&
 .2599E+00,.3446E+00,.4388E+00,.5776E+00,.6349E+00,.6551E+00,.6780E+00,.7120E+00,.7404E+00,.3967E+00,&
 .2620E+00,.3467E+00,.4411E+00,.5803E+00,.6375E+00,.6576E+00,.6801E+00,.7139E+00,.7416E+00,.3988E+00,&
 .2640E+00,.3487E+00,.4433E+00,.5829E+00,.6401E+00,.6600E+00,.6823E+00,.7157E+00,.7429E+00,.4008E+00,&
 .2661E+00,.3508E+00,.4455E+00,.5856E+00,.6428E+00,.6625E+00,.6844E+00,.7176E+00,.7441E+00,.4029E+00,&
 .2686E+00,.3532E+00,.4482E+00,.5887E+00,.6458E+00,.6653E+00,.6869E+00,.7198E+00,.7456E+00,.4054E+00,&
 .2719E+00,.3566E+00,.4518E+00,.5930E+00,.6499E+00,.6691E+00,.6902E+00,.7226E+00,.7474E+00,.4088E+00,&
 .2748E+00,.3594E+00,.4549E+00,.5966E+00,.6534E+00,.6723E+00,.6930E+00,.7250E+00,.7488E+00,.4118E+00,&
 .2776E+00,.3622E+00,.4580E+00,.6001E+00,.6568E+00,.6754E+00,.6956E+00,.7274E+00,.7502E+00,.4147E+00,&
 .2817E+00,.3664E+00,.4626E+00,.6053E+00,.6617E+00,.6799E+00,.6996E+00,.7308E+00,.7524E+00,.4190E+00,&
 .2850E+00,.3696E+00,.4661E+00,.6093E+00,.6655E+00,.6833E+00,.7026E+00,.7334E+00,.7542E+00,.4223E+00,&
 .2890E+00,.3737E+00,.4706E+00,.6143E+00,.6702E+00,.6876E+00,.7063E+00,.7366E+00,.7562E+00,.4266E+00,&
 .2930E+00,.3778E+00,.4750E+00,.6192E+00,.6748E+00,.6917E+00,.7099E+00,.7397E+00,.7578E+00,.4308E+00,&
 .2974E+00,.3822E+00,.4798E+00,.6246E+00,.6797E+00,.6962E+00,.7137E+00,.7430E+00,.7597E+00,.4353E+00,&
 .3030E+00,.3879E+00,.4860E+00,.6313E+00,.6858E+00,.7017E+00,.7185E+00,.7471E+00,.7624E+00,.4412E+00,&
 .3085E+00,.3934E+00,.4921E+00,.6378E+00,.6918E+00,.7070E+00,.7231E+00,.7511E+00,.7647E+00,.4470E+00,&
 .3159E+00,.4009E+00,.5003E+00,.6465E+00,.6995E+00,.7140E+00,.7291E+00,.7562E+00,.7673E+00,.4548E+00,&
 .3235E+00,.4086E+00,.5088E+00,.6553E+00,.7073E+00,.7210E+00,.7351E+00,.7613E+00,.7706E+00,.4629E+00,&
 .3332E+00,.4185E+00,.5195E+00,.6663E+00,.7169E+00,.7295E+00,.7424E+00,.7674E+00,.7734E+00,.4732E+00,&
 .3455E+00,.4310E+00,.5330E+00,.6799E+00,.7286E+00,.7398E+00,.7513E+00,.7749E+00,.7778E+00,.4862E+00,&
 .3593E+00,.4449E+00,.5481E+00,.6947E+00,.7410E+00,.7507E+00,.7606E+00,.7828E+00,.7820E+00,.5008E+00,&
 .3811E+00,.4669E+00,.5716E+00,.7169E+00,.7593E+00,.7666E+00,.7742E+00,.7941E+00,.7874E+00,.5236E+00,&
 .4082E+00,.4942E+00,.6004E+00,.7430E+00,.7800E+00,.7845E+00,.7893E+00,.8066E+00,.7923E+00,.5520E+00,&
 .4573E+00,.5429E+00,.6504E+00,.7853E+00,.8124E+00,.8121E+00,.8126E+00,.8257E+00,.8006E+00,.6021E+00/
 data (((g_lw(ai,k,nh),ai= 6, 6),k=1,nwl_lw),nh=0,99)/ &
 .4938E+00,.6006E+00,.7052E+00,.7149E+00,.6782E+00,.7073E+00,.7647E+00,.7410E+00,.7147E+00,.6475E+00,&
 .4978E+00,.6046E+00,.7123E+00,.7238E+00,.6855E+00,.7127E+00,.7685E+00,.7465E+00,.7177E+00,.6538E+00,&
 .5019E+00,.6086E+00,.7194E+00,.7328E+00,.6927E+00,.7182E+00,.7723E+00,.7519E+00,.7207E+00,.6601E+00,&
 .5059E+00,.6127E+00,.7265E+00,.7418E+00,.7000E+00,.7236E+00,.7761E+00,.7573E+00,.7238E+00,.6664E+00,&
 .5099E+00,.6167E+00,.7336E+00,.7507E+00,.7073E+00,.7290E+00,.7799E+00,.7627E+00,.7268E+00,.6728E+00,&
 .5140E+00,.6207E+00,.7407E+00,.7597E+00,.7146E+00,.7344E+00,.7837E+00,.7681E+00,.7298E+00,.6791E+00,&
 .5176E+00,.6239E+00,.7446E+00,.7658E+00,.7204E+00,.7389E+00,.7862E+00,.7717E+00,.7333E+00,.6832E+00,&
 .5212E+00,.6271E+00,.7485E+00,.7720E+00,.7263E+00,.7433E+00,.7887E+00,.7752E+00,.7367E+00,.6874E+00,&
 .5248E+00,.6303E+00,.7524E+00,.7782E+00,.7321E+00,.7477E+00,.7912E+00,.7788E+00,.7402E+00,.6916E+00,&
 .5285E+00,.6336E+00,.7563E+00,.7843E+00,.7380E+00,.7522E+00,.7937E+00,.7824E+00,.7436E+00,.6957E+00,&
 .5321E+00,.6368E+00,.7602E+00,.7905E+00,.7438E+00,.7566E+00,.7962E+00,.7859E+00,.7471E+00,.6999E+00,&
 .5354E+00,.6395E+00,.7628E+00,.7950E+00,.7486E+00,.7602E+00,.7987E+00,.7890E+00,.7487E+00,.7030E+00,&
 .5387E+00,.6422E+00,.7654E+00,.7995E+00,.7534E+00,.7638E+00,.8011E+00,.7921E+00,.7502E+00,.7061E+00,&
 .5420E+00,.6450E+00,.7680E+00,.8040E+00,.7582E+00,.7674E+00,.8035E+00,.7952E+00,.7518E+00,.7092E+00,&
 .5453E+00,.6477E+00,.7706E+00,.8085E+00,.7630E+00,.7710E+00,.8059E+00,.7982E+00,.7534E+00,.7123E+00,&
 .5486E+00,.6504E+00,.7732E+00,.8131E+00,.7677E+00,.7747E+00,.8083E+00,.8013E+00,.7549E+00,.7154E+00,&
 .5516E+00,.6528E+00,.7752E+00,.8165E+00,.7716E+00,.7778E+00,.8100E+00,.8035E+00,.7574E+00,.7178E+00,&
 .5546E+00,.6552E+00,.7772E+00,.8199E+00,.7755E+00,.7810E+00,.8117E+00,.8057E+00,.7599E+00,.7203E+00,&
 .5576E+00,.6576E+00,.7791E+00,.8233E+00,.7794E+00,.7842E+00,.8134E+00,.8078E+00,.7625E+00,.7228E+00,&
 .5606E+00,.6600E+00,.7811E+00,.8267E+00,.7833E+00,.7874E+00,.8151E+00,.8100E+00,.7650E+00,.7252E+00,&
 .5636E+00,.6624E+00,.7830E+00,.8301E+00,.7871E+00,.7906E+00,.8168E+00,.8122E+00,.7675E+00,.7277E+00,&
 .5663E+00,.6645E+00,.7846E+00,.8328E+00,.7904E+00,.7931E+00,.8184E+00,.8142E+00,.7685E+00,.7298E+00,&
 .5691E+00,.6667E+00,.7862E+00,.8355E+00,.7936E+00,.7955E+00,.8201E+00,.8162E+00,.7696E+00,.7319E+00,&
 .5718E+00,.6688E+00,.7878E+00,.8383E+00,.7969E+00,.7980E+00,.8218E+00,.8182E+00,.7707E+00,.7339E+00,&
 .5746E+00,.6709E+00,.7894E+00,.8410E+00,.8002E+00,.8004E+00,.8235E+00,.8202E+00,.7718E+00,.7360E+00,&
 .5773E+00,.6731E+00,.7910E+00,.8437E+00,.8034E+00,.8029E+00,.8251E+00,.8222E+00,.7728E+00,.7381E+00,&
 .5798E+00,.6750E+00,.7924E+00,.8459E+00,.8061E+00,.8052E+00,.8263E+00,.8237E+00,.7744E+00,.7399E+00,&
 .5823E+00,.6770E+00,.7938E+00,.8481E+00,.8088E+00,.8074E+00,.8275E+00,.8251E+00,.7760E+00,.7417E+00,&
 .5849E+00,.6789E+00,.7952E+00,.8503E+00,.8115E+00,.8097E+00,.8287E+00,.8266E+00,.7776E+00,.7435E+00,&
 .5874E+00,.6809E+00,.7965E+00,.8525E+00,.8142E+00,.8120E+00,.8298E+00,.8280E+00,.7792E+00,.7453E+00,&
 .5899E+00,.6828E+00,.7979E+00,.8547E+00,.8169E+00,.8142E+00,.8310E+00,.8295E+00,.7808E+00,.7471E+00,&
 .5922E+00,.6846E+00,.7991E+00,.8565E+00,.8192E+00,.8161E+00,.8323E+00,.8309E+00,.7821E+00,.7487E+00,&
 .5946E+00,.6864E+00,.8003E+00,.8583E+00,.8214E+00,.8179E+00,.8335E+00,.8323E+00,.7834E+00,.7503E+00,&
 .5969E+00,.6882E+00,.8016E+00,.8601E+00,.8237E+00,.8197E+00,.8348E+00,.8337E+00,.7847E+00,.7519E+00,&
 .5992E+00,.6900E+00,.8028E+00,.8619E+00,.8260E+00,.8216E+00,.8361E+00,.8351E+00,.7860E+00,.7535E+00,&
 .6016E+00,.6917E+00,.8040E+00,.8638E+00,.8282E+00,.8234E+00,.8373E+00,.8365E+00,.7874E+00,.7551E+00,&
 .6037E+00,.6934E+00,.8051E+00,.8653E+00,.8302E+00,.8250E+00,.8382E+00,.8376E+00,.7880E+00,.7566E+00,&
 .6059E+00,.6951E+00,.8062E+00,.8668E+00,.8322E+00,.8266E+00,.8390E+00,.8386E+00,.7887E+00,.7580E+00,&
 .6080E+00,.6967E+00,.8073E+00,.8684E+00,.8341E+00,.8282E+00,.8399E+00,.8397E+00,.7893E+00,.7595E+00,&
 .6102E+00,.6984E+00,.8084E+00,.8699E+00,.8361E+00,.8298E+00,.8407E+00,.8407E+00,.7900E+00,.7609E+00,&
 .6124E+00,.7001E+00,.8095E+00,.8714E+00,.8381E+00,.8314E+00,.8416E+00,.8418E+00,.7906E+00,.7624E+00,&
 .6144E+00,.7016E+00,.8105E+00,.8728E+00,.8397E+00,.8328E+00,.8425E+00,.8428E+00,.7919E+00,.7637E+00,&
 .6164E+00,.7031E+00,.8116E+00,.8741E+00,.8414E+00,.8342E+00,.8435E+00,.8438E+00,.7932E+00,.7651E+00,&
 .6184E+00,.7047E+00,.8126E+00,.8754E+00,.8430E+00,.8357E+00,.8444E+00,.8448E+00,.7945E+00,.7664E+00,&
 .6204E+00,.7062E+00,.8136E+00,.8767E+00,.8447E+00,.8371E+00,.8453E+00,.8458E+00,.7958E+00,.7677E+00,&
 .6224E+00,.7078E+00,.8146E+00,.8780E+00,.8463E+00,.8385E+00,.8463E+00,.8468E+00,.7971E+00,.7691E+00,&
 .6243E+00,.7092E+00,.8156E+00,.8792E+00,.8478E+00,.8397E+00,.8470E+00,.8477E+00,.7975E+00,.7703E+00,&
 .6262E+00,.7107E+00,.8165E+00,.8803E+00,.8492E+00,.8409E+00,.8477E+00,.8486E+00,.7978E+00,.7715E+00,&
 .6280E+00,.7121E+00,.8174E+00,.8815E+00,.8507E+00,.8421E+00,.8484E+00,.8495E+00,.7982E+00,.7727E+00,&
 .6299E+00,.7136E+00,.8184E+00,.8826E+00,.8521E+00,.8433E+00,.8492E+00,.8504E+00,.7985E+00,.7740E+00,&
 .6318E+00,.7150E+00,.8193E+00,.8838E+00,.8536E+00,.8444E+00,.8499E+00,.8513E+00,.7989E+00,.7752E+00,&
 .6332E+00,.7161E+00,.8201E+00,.8846E+00,.8546E+00,.8453E+00,.8504E+00,.8519E+00,.7998E+00,.7761E+00,&
 .6346E+00,.7172E+00,.8208E+00,.8854E+00,.8557E+00,.8462E+00,.8509E+00,.8524E+00,.8007E+00,.7771E+00,&
 .6361E+00,.7184E+00,.8215E+00,.8863E+00,.8568E+00,.8471E+00,.8515E+00,.8530E+00,.8015E+00,.7780E+00,&
 .6375E+00,.7195E+00,.8222E+00,.8871E+00,.8578E+00,.8480E+00,.8520E+00,.8535E+00,.8024E+00,.7790E+00,&
 .6390E+00,.7206E+00,.8230E+00,.8879E+00,.8589E+00,.8489E+00,.8525E+00,.8540E+00,.8033E+00,.7799E+00,&
 .6403E+00,.7217E+00,.8237E+00,.8887E+00,.8598E+00,.8497E+00,.8531E+00,.8546E+00,.8040E+00,.7808E+00,&
 .6417E+00,.7227E+00,.8244E+00,.8894E+00,.8607E+00,.8505E+00,.8536E+00,.8552E+00,.8048E+00,.7817E+00,&
 .6431E+00,.7238E+00,.8251E+00,.8902E+00,.8617E+00,.8513E+00,.8542E+00,.8558E+00,.8055E+00,.7826E+00,&
 .6444E+00,.7248E+00,.8258E+00,.8910E+00,.8626E+00,.8521E+00,.8548E+00,.8564E+00,.8062E+00,.7835E+00,&
 .6458E+00,.7259E+00,.8265E+00,.8917E+00,.8635E+00,.8529E+00,.8553E+00,.8570E+00,.8070E+00,.7844E+00,&
 .6471E+00,.7269E+00,.8271E+00,.8924E+00,.8644E+00,.8536E+00,.8558E+00,.8576E+00,.8071E+00,.7853E+00,&
 .6484E+00,.7279E+00,.8278E+00,.8931E+00,.8652E+00,.8544E+00,.8563E+00,.8582E+00,.8073E+00,.7861E+00,&
 .6497E+00,.7289E+00,.8284E+00,.8938E+00,.8661E+00,.8551E+00,.8568E+00,.8587E+00,.8075E+00,.7870E+00,&
 .6510E+00,.7299E+00,.8291E+00,.8945E+00,.8669E+00,.8558E+00,.8572E+00,.8593E+00,.8076E+00,.7878E+00,&
 .6523E+00,.7310E+00,.8298E+00,.8951E+00,.8678E+00,.8565E+00,.8577E+00,.8599E+00,.8078E+00,.7887E+00,&
 .6535E+00,.7319E+00,.8304E+00,.8958E+00,.8685E+00,.8571E+00,.8581E+00,.8603E+00,.8083E+00,.7895E+00,&
 .6548E+00,.7329E+00,.8310E+00,.8964E+00,.8693E+00,.8578E+00,.8584E+00,.8607E+00,.8088E+00,.7903E+00,&
 .6560E+00,.7338E+00,.8316E+00,.8970E+00,.8701E+00,.8585E+00,.8588E+00,.8611E+00,.8094E+00,.7911E+00,&
 .6572E+00,.7348E+00,.8323E+00,.8977E+00,.8709E+00,.8591E+00,.8592E+00,.8615E+00,.8099E+00,.7919E+00,&
 .6585E+00,.7358E+00,.8329E+00,.8983E+00,.8717E+00,.8598E+00,.8595E+00,.8619E+00,.8104E+00,.7927E+00,&
 .6602E+00,.7371E+00,.8338E+00,.8992E+00,.8727E+00,.8607E+00,.8602E+00,.8626E+00,.8114E+00,.7938E+00,&
 .6620E+00,.7385E+00,.8347E+00,.9000E+00,.8737E+00,.8616E+00,.8608E+00,.8633E+00,.8125E+00,.7949E+00,&
 .6637E+00,.7399E+00,.8356E+00,.9008E+00,.8747E+00,.8625E+00,.8615E+00,.8639E+00,.8135E+00,.7961E+00,&
 .6654E+00,.7412E+00,.8364E+00,.9017E+00,.8757E+00,.8633E+00,.8621E+00,.8646E+00,.8145E+00,.7972E+00,&
 .6672E+00,.7426E+00,.8373E+00,.9025E+00,.8768E+00,.8642E+00,.8628E+00,.8653E+00,.8155E+00,.7983E+00,&
 .6695E+00,.7444E+00,.8385E+00,.9036E+00,.8780E+00,.8653E+00,.8635E+00,.8661E+00,.8161E+00,.7998E+00,&
 .6719E+00,.7463E+00,.8397E+00,.9047E+00,.8793E+00,.8664E+00,.8642E+00,.8669E+00,.8167E+00,.8014E+00,&
 .6742E+00,.7481E+00,.8409E+00,.9058E+00,.8806E+00,.8675E+00,.8648E+00,.8677E+00,.8173E+00,.8029E+00,&
 .6765E+00,.7500E+00,.8421E+00,.9068E+00,.8819E+00,.8686E+00,.8655E+00,.8685E+00,.8179E+00,.8044E+00,&
 .6789E+00,.7518E+00,.8433E+00,.9079E+00,.8831E+00,.8697E+00,.8662E+00,.8693E+00,.8186E+00,.8059E+00,&
 .6812E+00,.7537E+00,.8445E+00,.9090E+00,.8843E+00,.8708E+00,.8670E+00,.8701E+00,.8204E+00,.8075E+00,&
 .6846E+00,.7563E+00,.8463E+00,.9104E+00,.8861E+00,.8723E+00,.8682E+00,.8715E+00,.8223E+00,.8096E+00,&
 .6879E+00,.7590E+00,.8480E+00,.9119E+00,.8877E+00,.8738E+00,.8694E+00,.8725E+00,.8232E+00,.8118E+00,&
 .6912E+00,.7615E+00,.8496E+00,.9132E+00,.8892E+00,.8750E+00,.8704E+00,.8738E+00,.8243E+00,.8139E+00,&
 .6948E+00,.7644E+00,.8515E+00,.9147E+00,.8910E+00,.8765E+00,.8712E+00,.8751E+00,.8246E+00,.8162E+00,&
 .6983E+00,.7672E+00,.8533E+00,.9162E+00,.8926E+00,.8780E+00,.8721E+00,.8759E+00,.8265E+00,.8185E+00,&
 .7018E+00,.7700E+00,.8551E+00,.9176E+00,.8941E+00,.8794E+00,.8733E+00,.8771E+00,.8285E+00,.8207E+00,&
 .7053E+00,.7728E+00,.8569E+00,.9189E+00,.8957E+00,.8808E+00,.8745E+00,.8783E+00,.8305E+00,.8230E+00,&
 .7092E+00,.7759E+00,.8589E+00,.9205E+00,.8973E+00,.8822E+00,.8757E+00,.8797E+00,.8317E+00,.8255E+00,&
 .7137E+00,.7794E+00,.8612E+00,.9222E+00,.8992E+00,.8839E+00,.8767E+00,.8812E+00,.8326E+00,.8283E+00,&
 .7188E+00,.7835E+00,.8638E+00,.9241E+00,.9012E+00,.8857E+00,.8781E+00,.8827E+00,.8354E+00,.8316E+00,&
 .7240E+00,.7877E+00,.8665E+00,.9260E+00,.9033E+00,.8876E+00,.8800E+00,.8843E+00,.8378E+00,.8349E+00,&
 .7313E+00,.7934E+00,.8701E+00,.9286E+00,.9059E+00,.8900E+00,.8817E+00,.8867E+00,.8401E+00,.8394E+00,&
 .7391E+00,.7997E+00,.8740E+00,.9313E+00,.9088E+00,.8927E+00,.8843E+00,.8893E+00,.8446E+00,.8443E+00,&
 .7480E+00,.8067E+00,.8784E+00,.9342E+00,.9118E+00,.8955E+00,.8866E+00,.8921E+00,.8478E+00,.8498E+00,&
 .7596E+00,.8157E+00,.8841E+00,.9379E+00,.9155E+00,.8992E+00,.8902E+00,.8964E+00,.8530E+00,.8568E+00,&
 .7726E+00,.8259E+00,.8903E+00,.9418E+00,.9195E+00,.9032E+00,.8945E+00,.9009E+00,.8600E+00,.8645E+00,&
 .7910E+00,.8400E+00,.8986E+00,.9471E+00,.9250E+00,.9091E+00,.9007E+00,.9076E+00,.8704E+00,.8749E+00,&
 .8196E+00,.8613E+00,.9108E+00,.9546E+00,.9335E+00,.9192E+00,.9128E+00,.9197E+00,.8867E+00,.8901E+00/
 data (((g_lw(ai,k,nh),ai= 7, 7),k=1,nwl_lw),nh=0,99)/ &
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01,&
 .1764E-01,.4051E-01,.4930E-01,.8817E-01,.1561E+00,.8955E-01,.1028E+00,.1524E+00,.2399E+00,.3638E-01/
 data (((g_lw(ai,k,nh),ai= 8, 8),k=1,nwl_lw),nh=0,99)/ &
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01,&
 .4977E-01,.9713E-01,.1083E+00,.1703E+00,.2366E+00,.1724E+00,.1964E+00,.2661E+00,.3673E+00,.8486E-01/
 data (((g_lw(ai,k,nh),ai= 9, 9),k=1,nwl_lw),nh=0,99)/ &
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00,&
 .1276E+00,.1922E+00,.2158E+00,.2880E+00,.3066E+00,.3104E+00,.3506E+00,.4227E+00,.5097E+00,.1828E+00/
 data (((g_lw(ai,k,nh),ai=10,10),k=1,nwl_lw),nh=0,99)/ &
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00,&
 .2216E+00,.2753E+00,.3362E+00,.3917E+00,.3482E+00,.4622E+00,.5122E+00,.5561E+00,.6083E+00,.3031E+00/
 data (((g_lw(ai,k,nh),ai=11,11),k=1,nwl_lw),nh=0,99)/ &
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00,&
 .3038E+00,.3371E+00,.4529E+00,.4747E+00,.3811E+00,.6079E+00,.6554E+00,.6541E+00,.6672E+00,.4285E+00/
 data (((g_lw(ai,k,nh),ai=12,12),k=1,nwl_lw),nh=0,99)/ &
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00,&
 .3628E+00,.3826E+00,.5498E+00,.5366E+00,.4239E+00,.7224E+00,.7580E+00,.7138E+00,.6936E+00,.5385E+00/
 data (((g_lw(ai,k,nh),ai=13,13),k=1,nwl_lw),nh=0,99)/ &
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00,&
 .4133E+00,.4348E+00,.6366E+00,.5964E+00,.5163E+00,.8142E+00,.8304E+00,.7488E+00,.7046E+00,.6401E+00/
 data (((g_lw(ai,k,nh),ai=14,14),k=1,nwl_lw),nh=0,99)/ &
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00,&
 .4592E+00,.5048E+00,.6980E+00,.6575E+00,.6399E+00,.8711E+00,.8660E+00,.7663E+00,.7222E+00,.7096E+00/

 contains

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

 subroutine init_opac
 implicit none
!------------------------------------------------------------------------
! Comments: Initialize OPAC aerosol microphysics parameters. 
!
! History;
! 10/2010  Toshi Matsui ; Initial.
! 
! Reference
! M. Hess, P. Koepke, and I. Schult (1998): Optical Properties of Aerosols and clouds: 
!    The software package OPAC, Bull. Am. Met. Soc., 79, 831-844. 
!------------------------------------------------------------------------

!
! Microphysical properties of aerosol components in dry state. Parameters are linked to 
!  OPAC log-normal PSD function. 
!	
 std%inso = 2.51e0 ; r_mode%inso = 0.471e0 ; r_min%inso = 0.005e0 ; r_max%inso = 20.0e0 ; rho%inso = 2.0e0
 std%waso = 2.24e0 ; r_mode%waso = 0.0212e0; r_min%waso = 0.005e0 ; r_max%waso = 20.0e0 ; rho%waso = 1.8e0
 std%soot = 2.00e0 ; r_mode%soot = 0.0118e0; r_min%soot = 0.005e0 ; r_max%soot = 20.0e0 ; rho%soot = 1.0e0
 std%ssam = 2.03e0 ; r_mode%ssam = 0.209e0 ; r_min%ssam = 0.005e0 ; r_max%ssam = 20.0e0 ; rho%ssam = 2.2e0
 std%sscm = 2.03e0 ; r_mode%sscm = 1.750e0 ; r_min%sscm = 0.005e0 ; r_max%sscm = 60.0e0 ; rho%sscm = 2.2e0
 std%minm = 1.95e0 ; r_mode%minm = 0.070e0 ; r_min%minm = 0.005e0 ; r_max%minm = 20.0e0 ; rho%minm = 2.6e0
 std%miam = 2.00e0 ; r_mode%miam = 0.390e0 ; r_min%miam = 0.005e0 ; r_max%miam = 20.0e0 ; rho%miam = 2.6e0
 std%micm = 2.15e0 ; r_mode%micm = 1.900e0 ; r_min%micm = 0.005e0 ; r_max%micm = 60.0e0 ; rho%micm = 2.6e0
 std%mitr = 2.20e0 ; r_mode%mitr = 0.500e0 ; r_min%mitr = 0.020e0 ; r_max%mitr =  5.0e0 ; rho%mitr = 2.6e0
 std%suso = 2.03e0 ; r_mode%suso = 0.0695e0; r_min%suso = 0.005e0 ; r_max%suso = 20.0e0 ; rho%suso = 1.7e0
 
 end subroutine init_opac

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

 subroutine mass2ccn(t_air,s,aero,ccn_out)
 implicit none
!------------------------------------------------------------------------
! Comments: Convert GOCART aerosol mass concentrations into CCN number conc 
!  as a function of temperature and super saturation rate following Kohler equation.
!
!  - LUT approach -
!  LUT approach is much faster than actual resolution of Kohler routine. 
!  Accuracy of LUT approach is generally within 3% (and mean accuracy is 0.41% in C3VP exp).
!  Accuracy is defined as 
!  Accuracy[%] = abs(CCN_lut-CCN_nonlut)/CCN_non_lut * 100
!
! Note that tgmx = 14 : aerosol type (see below), and aero must be in the following order.
!  #   
!  1 = SO4      ! sulfur and its precure
!  2 = BC1+BC2  ! black carbon (soot)
!  3 = OC1      ! non hygroscopic OC
!  4 = OC2      ! hygroscopic OC
!  5 = SS1      ! sea-salt accumulation mode
!  6 = SS2+SS3+SS4 !sea-salt coarse mode
!  7 = DU1      ! dust mode 1
!  8 = DU1      ! dust mode 2
!  9 = DU1      ! dust mode 3
! 10 = DU1      ! dust mode 4
! 11 = DU2      ! dust mode 5
! 12 = DU3      ! dust mode 6
! 13 = DU4      ! dust mode 7
! 14 = DU5      ! dust mode 8
!
! History;
! 02/2007  Toshi Matsui ; Initial.
!------------------------------------------------------------------------
 real,intent(in) :: t_air !air temperature [K]
 real,intent(in) :: s     !super saturation rate [%] 
 real,intent(in) :: aero(tgmx) !aerosol mass conc [g/m3]
 real,intent(out) :: ccn_out  ! CCN concentration [#/cm3]

 integer :: im !looping
 real :: ccn   !accmulating CCN conc [#/cm3]
 real :: lut_ccn_interp(tgmx) ! interpolated LUT value 


 ccn_out = 0.e0 

!
! If no super saturation....
!
 if( s <= 0.e0 ) then
     ccn_out = 0.e0  !total number conc of CCN [#/cm3]
     return
 endif


 ccn = 0.e0      !initialize

!
! interpolate LUT for a given air temperature and super saturation
!
 call interp( t_air, s, lut_ccn_interp )

!
! convert aerosol mass mixing ratio into CCN conc
!
 do im = 1, tgmx

    ccn = ccn + aero(im)*lut_ccn_interp(im)  ! CCN conc [#/cm3]

 enddo

!
! CCN conc ranges from 100 ~ 10000 per cubic centimeter
!
 ccn_out = min(10000.e0, max(100.e0, ccn) )  !total number conc of CCN [#/cm3]
                                     
 end subroutine mass2ccn

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

 subroutine interp(t_air,s_rate,lut_ccn_interp)
 implicit none

!------------------------------------------------------------------------
! Comments: Interpolate CCN LUT for a given temperature and super saturation 
!           rate. 
!
! History;
! 02/2007  Toshi Matsui ; Initial.
!------------------------------------------------------------------------

 real,intent(in) :: t_air  !air temperature [K]
 real,intent(in) :: s_rate !super saturation rate [%] 

 real,intent(out) :: lut_ccn_interp(1:tgmx)  !interpolated CCN LUT for a given temperature and super sat rate.

 real :: t, s  !temperature and super saturation rate
 integer :: it, is  !looping indice
 real :: wgt1_t, wgt2_t ! weight for interpolation
 real :: wgt1_s, wgt2_s ! weight for interpolation!


 t = t_air   !temperature [K]
 if( t_air < pts_t(1)       ) t = pts_t(1)       
 if( t_air > pts_t(mxpts_t) ) t = pts_t(mxpts_t) 

 s = s_rate  !super saturation rate [%]
 if( s_rate < pts_s(1)      ) s = pts_s(1)
 if( s_rate > pts_s(mxpts_s)) s = pts_s(mxpts_s)


 it_loop: do it = 1, mxpts_t-1
    if( t >= pts_t(it) .and. t <= pts_t(it+1) ) then
      wgt1_t = (pts_t(it+1) - t) / ( pts_t(it+1) - pts_t(it) )
      wgt2_t = 1.e0-wgt1_t

      do is = 1, mxpts_s-1
         if( s >= pts_s(is) .and. s <= pts_s(is+1) ) then
             wgt1_s = (pts_s(is+1) - s) / ( pts_s(is+1) - pts_s(is) )
             wgt2_s = 1.e0-wgt1_s

             !
             ! interpolation of 4 point 
             !
             lut_ccn_interp(1:tgmx) =  &
               ( lut_ccn(it,is  ,1:tgmx)*wgt1_t + lut_ccn(it+1,is  ,1:tgmx)*wgt2_t ) * wgt1_s &
             + ( lut_ccn(it,is+1,1:tgmx)*wgt1_t + lut_ccn(it+1,is+1,1:tgmx)*wgt2_t ) * wgt2_s

             exit it_loop

         endif
      enddo

    endif
 enddo it_loop

 end subroutine interp

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

 subroutine mass2icn(p_air,t_air,aero,icn_out,ii,jj,kk)
#ifndef NO_IEEE_MODULE
 use, intrinsic :: ieee_arithmetic
#endif
 implicit none
!------------------------------------------------------------------------
! Comments: Convert GOCART aerosol mass concentrations into IN number conc 
!           as a function of aimbient temperature following DeMott's empirical
!           formulae [DeMott et al. 2010]. 
!
! Note that tgmx = 14 : aerosol type (see below), and aero must be in the following order.
!  #   
!  1 = SO4      ! sulfur and its precure
!  2 = BC1+BC2  ! black carbon (soot)
!  3 = OC1      ! non hygroscopic OC
!  4 = OC2      ! hygroscopic OC
!  5 = SS1      ! sea-salt accumulation mode
!  6 = SS2+SS3+SS4 !sea-salt coarse mode
!  7 = DU1      ! dust mode 1
!  8 = DU1      ! dust mode 2
!  9 = DU1      ! dust mode 3
! 10 = DU1      ! dust mode 4
! 11 = DU2      ! dust mode 5
! 12 = DU3      ! dust mode 6
! 13 = DU4      ! dust mode 7
! 14 = DU5      ! dust mode 8
!
! History;
! 02/2007  Toshi Matsui@NASA GSFC ; Initial.
!
! Citations
! DeMott, P. J., Coauthors 2010: Predicting global atmospheric ice nuclei distributions and 
!     their impacts on climate. Proc. Natl. Acad. Sci. USA, 107:11217–11222.
!
!------------------------------------------------------------------------
 real,intent(in) :: p_air !air pressure [hPa]
 real,intent(in) :: t_air !air temperature [K]
 real,intent(in) :: aero(tgmx) !aerosol mass conc [g/m3]
 real,intent(out) :: icn_out  ! IN concentration [#/L]

 integer :: is !loop
 integer, intent(in) :: ii, jj, kk
 real :: n_025_tot ! total number conc of aerosol radius > 0.25 micron [#/cm3]
 real :: n_025_std  ! aerosol (r>0.25micron) conc in starndard atmosphere [#/scm3]
 real :: icn_std    ! ice nuclei conc in starndard atmosphere [#/scm3]
 real :: t_fact    !temperature factor
 real :: icn_estimate ! estimated IN concentration [#/L]
 integer :: result
! coefficient of empirical formulae in DeMott 2010
 real,parameter :: a = 0.0000594e0
 real,parameter :: b = 3.33e0
 real,parameter :: c = 0.0264e0
 real,parameter :: d = 0.0033

 real,parameter :: p_std = 1013.e0  !standard pressure [hPa]
 real,parameter :: t_std = 273.16e0 !standard temperature [K]

 icn_out = 0.e0

 if( maxval( lut_in_025 ) == 0.e0 ) stop 'MSG mass2icn: you have not initialize lut_in_025 yet. Stop program' 

!
! Essentially integrate non-hygroscopic aerosols 
!
 n_025_tot = 0.e0

 do is = 1, tgmx
    n_025_tot = n_025_tot + lut_in_025(is)*aero(is)  ! accumulating aerosol conc [#/cm3]
 enddo

!
! now convert everything into standard cm-3 (T=273k, P=1013mb). 
!
 n_025_std = n_025_tot * p_std*t_air/(p_air*t_std)  ! [scm-3]

!
! empirical formulae in DeMott 2010 based on starndard atmosphere.
!
 t_fact = max(0.e0, 273.16e0 - t_air )   ! air temprature in deg celcius [degC]

 icn_std =  a * (t_fact**b) * (n_025_std**( c*t_fact + d ))  ! total number conc of IN [#/std L]

!
! convert standard atmos value back to the actual model atmos condition. 
!
 icn_estimate = icn_std * (p_air*t_std) / (p_std*t_air)  ! [#/std L] --> [#/L]

#ifndef NO_IEEE_MODULE
         if( ieee_is_nan( icn_estimate ) ) then
            print*, 'NAN in mass2icn, i,j,k, icn_estimate = ', ii, jj, kk, icn_estimate
            print*, 'icn_std, t_std, p_std, p_air, t_air =', icn_std, t_std, p_std, p_air, t_air
            print*, 'aero = ', aero
         endif
         if( .NOT. ieee_is_finite( icn_estimate ) ) then
            print*, 'INF in mass2icn, i,j,k, icn_estimate = ', ii, jj, kk, icn_estimate
            print*, 'icn_std, t_std, p_std, p_air, t_air =', icn_std, t_std, p_std, p_air, t_air
            print*, 'aero = ', aero
         endif
#endif

!
! IN conc ranges from 100 ~ 1000000 per litter based on DeMott et al. 2010 PNAS.
!
! icn_out = min(1.e6, max(1.e2 ,  icn_estimate) )  ! [#/L]
 icn_out = min(1.e3, max(0.01e0 ,  icn_estimate) )  ! [#/L]

 end subroutine mass2icn

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

 subroutine makelut_ccn_icn
 implicit none
!------------------------------------------------------------------------
! Comments: Create CCN and IN candidate look-up table as a function of super saturation rate
!  and ambient temperature. 
!
! History;
! 10/2010  Toshi Matsui ; Initial.
! 
! Reference
!------------------------------------------------------------------------
 real,parameter :: q_in= 1.e0 !mass mixing ratio [g/m3]
 real :: n_ccn     ! CCN concentration [#/cm3] 
 real :: frac_ccn  ! mass fraction of CCN for CN [-]
 real :: n_gccn    ! GCCN concentration [#/cm3] 
 real :: frac_gccn ! mass fraction of GCCN for CN [-]
 real :: n_025     ! IN candidate concentration [#/cm3]
 real :: frac_025  ! mass fraction of IN candidate for CN [-]

 real :: t_air     ! air temprature [K]
 real :: vant_fac  ! van't Hoff factor [-]
 real :: mol_wgt   ! molecular weight of the chemical compnent of CN 
 real :: s         ! super saturation rate
 integer :: is, it ! for looping

 print *,' inside makelut_ccn_icn ' 

 if(master) print*,'MSG: makelut_ccn_icn: making LUT of CCN and IN'

 call init_opac

!
! hygroscopic species for Cloud Condensation Nuclei (CCN)
!
 lut_in_025 = 0.e0  !initialize zero [#/cm3]

 lut_ccn = 0.e0       ! initialize

 TEMP_LOOP: do it = 1, mxpts_t
    t_air = pts_t(it) ! temprature [K]

 SAT_LOOP : do is = 1, mxpts_s
    s = pts_s(is)     ! super saturation rate  [%]

    ! Sulfate
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%suso, r_mode%suso, r_min%suso, &
!                       r_max%suso, rho%suso , lut_ccn(it,is,1), frac_ccn, n_gccn, frac_gccn,n_025,frac_025)
                        r_max%suso, rho%suso , lut_ccn(it,is,1), frac_ccn, n_gccn, frac_gccn,lut_in_025(1),frac_025)

    ! hydrophilic organic carbon (chemistry is treated as sulfate) 
    ! water soluble 
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4 
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%waso, r_mode%waso, r_min%waso, &
!                       r_max%waso, rho%waso , lut_ccn(it,is,4) , frac_ccn, n_gccn, frac_gccn,n_025,frac_025)
                       r_max%waso, rho%waso , lut_ccn(it,is,4) , frac_ccn, n_gccn, frac_gccn,lut_in_025(4),frac_025)
    ! Seasalt accumulation mode
    vant_fac = 2.e0  ; mol_wgt = 58.44e0   ! NaCL
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%ssam, r_mode%ssam, r_min%ssam, &
!                       r_max%ssam, rho%ssam , lut_ccn(it,is,5), frac_ccn, n_gccn, frac_gccn,n_025,frac_025)  
                       r_max%ssam, rho%ssam , lut_ccn(it,is,5), frac_ccn, n_gccn, frac_gccn,lut_in_025(5),frac_025)

    ! Seasalt coarse mode
    vant_fac = 2.e0  ; mol_wgt = 58.44e0   ! NaCL
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%sscm, r_mode%sscm, r_min%sscm, &
!                       r_max%sscm, rho%sscm , lut_ccn(it,is,6), frac_ccn, n_gccn, frac_gccn,n_025,frac_025) 
                       r_max%sscm, rho%sscm , lut_ccn(it,is,6), frac_ccn, n_gccn, frac_gccn,lut_in_025(6),frac_025)


 enddo SAT_LOOP  

 enddo TEMP_LOOP

!
! Non-hygroscopic species for IN
!
!    lut_in_025 = 0.e0  !initialize zero [#/cm3]

    ! soot 
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%soot, r_mode%soot, r_min%soot, &
                       r_max%soot, rho%soot , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(2),frac_025)

    ! insoluble organic carbon
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%inso, r_mode%inso, r_min%inso, &
                       r_max%inso, rho%inso , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(3),frac_025)

    ! dust mode 1
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%minm, 0.0421, r_min%minm, &
                       r_max%minm, rho%minm , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(7),frac_025)

    ! dust mode 2 
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%minm, 0.0722, r_min%minm, &
                       r_max%minm, rho%minm , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(8),frac_025)

    ! dust mode 3 
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%minm, 0.1354, r_min%minm, &
                       r_max%minm, rho%minm , n_ccn, frac_ccn, n_gccn, frac_gccn, lut_in_025(9),frac_025)

    ! dust mode 4
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%miam, 0.2407, r_min%miam, &
                       r_max%miam, rho%miam , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(10),frac_025)

    ! dust mode 5 
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%miam, 0.4212, r_min%miam, &
                       r_max%miam, rho%miam , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(11),frac_025)

    ! dust mode 6
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%miam, 0.7220, r_min%miam, &
                       r_max%miam, rho%miam , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(12),frac_025)

    ! dust mode 7
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%micm, 1.354, r_min%micm, &
                       r_max%micm, rho%micm , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(13),frac_025)

    ! dust mode 8 
    vant_fac = 3.e0  ; mol_wgt = 132.13e0   ! (NH4)2SO4  --> fake
    call ccn_estimate( q_in,  s, t_air, vant_fac, mol_wgt, std%micm, 2.407, r_min%micm, &
                       r_max%micm, rho%micm , n_ccn, frac_ccn, n_gccn, frac_gccn,lut_in_025(14),frac_025)

 print *,' done makelut_ccn_icn ' 

 end subroutine makelut_ccn_icn

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD

 subroutine ccn_estimate( q , s, t_air, vant_fac, mol_wgt, std, r_mode, &
                          r_min, r_max, rho , n_ccn_out, frac_ccn , n_gccn_out, frac_gccn, &
                          n_025_out, frac_025)
 implicit none
!------------------------------------------------------------------------
! Comments: For given chemical composition, aerosol total mass, size distributions,
! this routine estimate total number concentrations of 1) CCN, 2) Giant CCN, and
! 3) IN-candidate aerosol (D>0.5micron), and correponding mass fractions. 
! 
! Caution for GCCN user. If you want to use GCCN and CCN simultaneously (e.g., RAMS microphysics)
! CCN conc must be corrected in this way. 
!   CCN (fine mode) = n_ccn_out - n_gccn_out
!
! History;
! 10/2010  Toshi Matsui ; Initial.
!      
! Reference
!  Stull, R. (2000), Meteorology for Scientists and Engineer, 502 pp., 
!     Brooks/ Cole Thomson Learning, Pacific Grove, Calif.
!------------------------------------------------------------------------
 real,intent(in) :: q       ! aerosol mass mixing ratio [g/m3]
 real,intent(in) :: s       ! super saturation rate [%]
 real,intent(in) :: t_air   ! air temprature [K]
 real,intent(in) :: vant_fac! van't Hoff factor [-]
 real,intent(in) :: mol_wgt ! molecular weight of the chemical compnent of CN 
 real,intent(in) :: std     ! standard deviation []
 real,intent(in) :: r_mode  ! mode radius [micron]
 real,intent(in) :: r_min   ! minmum radius [micron]
 real,intent(in) :: r_max   ! maximum radius [micron]
 real,intent(in) :: rho     ! density [g/cm3]

 real,intent(out) :: n_ccn_out ! CCN concentration [#/cm3]
 real,intent(out) :: frac_ccn  ! mass fraction of CCN for CN [-]
 real,intent(out) :: n_gccn_out! GCCN concentration [#/cm3]
 real,intent(out) :: frac_gccn ! mass fraction of GCCN for CN [-]
 real,intent(out) :: n_025_out ! IN candidate concentration [#/cm3]
 real,intent(out) :: frac_025  ! mass fraction of IN candidate for CN [-]

 integer :: bin_max = 1000   !maximum of size bin
 integer :: i    ! loop index
 real :: log_dr  ! log-scale size bin width
 real :: dr      ! bin width [micron]
 real :: r       ! radius [micron]
 real :: cum_pd  ! cumulative pd
 real :: pd      ! probability density 
 real :: r15,r25 ! log-interplolated size bin boundary
 real :: n_bin   ! number conc per size bin [#/m3]
 real :: n_ccn   ! CCN conc [#/m3]
 real :: n_gccn  ! GCCN conc [#/m3]
 real :: n_025   ! IN candidate conc [#/m3]
 real :: q_bin   ! mass per size bin [g/m3]
 real :: q_ccn   ! CCN mass [g/m3]
 real :: q_gccn  ! GCCN mass [g/m3]
 real :: q_025   ! IN candidate mass [g/m3]
 real :: r_cm    ! particle radius in cm
 real :: s_crit  ! critical super saturation [%]
 real,parameter :: r_gccn = 2.e0 ! giant CCN radius threshold [micron]
 real,parameter :: r_in = 0.25e0 ! IN candidate radius threshold [micron] following [DeMott et al. 2010]
 real :: q_unit 
 real :: n_tot

!
! Convert aerosol mass mixing ratio to number mixing ratio. 
! This is because log-normal PSD is designed for Ntot. 
!
 call convert_mass2number( q , std, r_mode, r_min, r_max, rho , n_tot )

! Initilize
 cum_pd = 0.e0
 n_ccn  = 0.e0 ; q_ccn  = 0.e0
 n_gccn = 0.e0 ; q_gccn = 0.e0
 n_025 = 0.e0  ; q_025  = 0.e0

!
! set up bin size
!
 log_dr = log10(r_max/r_min) / real(bin_max)  ! logaritm of bin size 

 r = r_min   !initial particle radius [micron]

!
! PSD integration 
!
 do while ( r < r_max ) 

   r = r * ( 10.e0 ** log_dr ) ! particle dry radius [ micron ]

   r15 = r / (10.e0**(0.5e0*log_dr) )
   r25 = r * (10.e0**(0.5e0*log_dr) )
   dr = r25-r15    ! bin width [micron]

   call opac_log_normal_pdf(r,std,r_mode,pd)  ! compute probability density per width

   n_bin = n_tot * pd * dr  ! number per size bin [#/m3]
   r_cm = r * 1.e-4         ! radius [cm]
   q_unit = ( 4.e0/3.e0 * pi_const * r_cm*r_cm*r_cm * rho ) !mass per patcile [g]
   q_bin = n_bin * q_unit ! mass per size bin [g/m3]

   !
   ! Estimate critical super saturation rate
   !
   s_crit = sqrt( 1.278e-15 * mol_wgt / (vant_fac * q_unit * t_air*t_air*t_air ) ) * 100.e0 !Stull eq(8.5)


   if(s > s_crit) then
         n_ccn = n_ccn + n_bin        ! total number conc of CCN [#/m3]
         q_ccn = q_ccn + q_bin        ! total q of CCN [g/m3]
   endif

   if(s > s_crit .and. r > r_gccn) then
         n_gccn = n_gccn + n_bin        ! total number conc of GCCN [#/m3]
         q_gccn = q_gccn + q_bin        ! total q of GCCN [g/m3]
   endif

   if(r > r_in) then
         n_025 = n_025 + n_bin        ! total number conc of IN candidate [#/m3]
         q_025 = q_025 + q_bin        ! total q of IN candidate [g/m3]
   endif


   cum_pd = cum_pd + pd * dr  ! cumulative probability density for sanity check [-]
   
 enddo


!
! CCN output
!
 n_ccn_out = n_ccn * 1.e-6  ! Cloud Condensation Nuclei concentrations [#/cm3]
 frac_ccn = q_ccn / q       ! mass fraction of CCN for CN [-]

!
! GCCN output
!
 n_gccn_out = n_gccn * 1.e-6  ! Giant Cloud Condensation Nuclei concentrations [#/cm3]
 frac_gccn = q_gccn / q       ! mass fraction of GCCN for CN [-]

!
! IN candidate output
!
 n_025_out = n_025 * 1.e-6  ! Aerosol (equivalent to Naer,0.5) concentrations [#/cm3]
 frac_025  = q_025 / q       ! mass fraction of GCCN for CN [-]

 end subroutine ccn_estimate

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD

 subroutine convert_mass2number( q_in, std, r_mode, r_min, r_max, rho , n_tot )
 implicit none

!------------------------------------------------------------------------
! Comments: convert aerosol mass mixing ratio to total number concentration
! following OPAC's log-normal size distribution. 
! 
! History;
! 10/2010  Toshi Matsui ; Initial.
!      
! Reference
!------------------------------------------------------------------------
 real,intent(out) :: n_tot      ! aerosol total number mixing ratio [#/m3]
 real,intent(in) :: q_in       ! aerosol mass mixing ratio [g/m3]
 real,intent(in) :: std     ! standard deviation []
 real,intent(in) :: r_mode  ! mode radius [micron]
 real,intent(in) :: r_min   ! minmum radius [micron]
 real,intent(in) :: r_max   ! maximum radius [micron]
 real,intent(in) :: rho     ! density [g/cm3]

 integer :: bin_max = 1000 
 integer :: i    ! loop index
 real :: log_dr  ! log-scale size bin width
 real :: dr      ! bin width [micron]
 real :: r       ! radius [micron]
 real :: cum_pd  ! cumulative pd
 real :: pd      ! probability density 
 real :: r15,r25 ! log-interplolated size bin boundary
 real :: n_bin   ! number conc per size bin [#/m3]
 real :: q_bin   ! mass per size bin [g/m3]
 real :: r_cm    ! particle radius in cm
 real :: q_unit  !mass per unit particle [g]
 real :: q_integrate 

 real :: n_samp = 1.e5 ! [#/m3]

 cum_pd = 0.e0
 q_integrate = 0.e0

 log_dr = log10(r_max/r_min) / real(bin_max)  ! logaritm of bin size 

 r = r_min   !initial particle radius [micron]

 do while ( r < r_max ) 

   r = r * ( 10.e0 ** log_dr ) ! particle dry radius [ micron ]

   r15 = r / (10.e0**(0.5e0*log_dr) )
   r25 = r * (10.e0**(0.5e0*log_dr) )
   dr = r25-r15    ! bin width [micron]

   call opac_log_normal_pdf(r,std,r_mode,pd)  ! compute probability density per width

   n_bin = n_samp * pd * dr  ! number conc per size bin [#/m3]

   r_cm = r * 1.e-4     ! radius [cm]

   q_unit = ( 4.e0/3.e0 * pi_const * r_cm*r_cm*r_cm * rho ) !mass per patcile [g]

   q_bin = n_bin * q_unit ! number conc per size bin [g/m3]

   cum_pd = cum_pd + pd * dr  ! cumulative probability density for sanity check [-]
  
   q_integrate = q_integrate + q_bin ![g/m3] 

 enddo

 n_tot = q_in * (n_samp / q_integrate)   !total number concentration [#/m3] 

 end subroutine convert_mass2number

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD

 subroutine opac_log_normal_pdf( r, std, r_mode, pd )
 implicit none
!------------------------------------------------------------------------
! Comments: Function of unique OPAC-defined log-normal size distribution.  
! 
! History;
! 10/2010  Toshi Matsui ; Initial.
!      
! Reference
! M. Hess, P. Koepke, and I. Schult (1998): Optical Properties of Aerosols and clouds: 
!    The software package OPAC, Bull. Am. Met. Soc., 79, 831-844. 
!------------------------------------------------------------------------
 real,intent(in) :: r       ! particle radius [micron]
 real,intent(in) :: std     ! standard deviation []
 real,intent(in) :: r_mode  ! mode radius [micron]
 real,intent(out) :: pd     ! probability density
 real :: a, b

 a = 1.e0 / ( sqrt(2.e0*pi_const) * r * log10(std) * log(10.e0) )

 b =  ( log10(r/r_mode) / log10(std) )**2 

 pd = a * exp( - 0.5e0 * b )

 end subroutine opac_log_normal_pdf

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

 subroutine read_mie_sw
 implicit none

!------------------------------------------------------------------------
! Read aerosol mie table & assinge optical properties.
! Assinged values are saved for global variables at the top of module_gocart_offline.
!
! History;
! 02/2007  Toshi Matsui ; Initial.
!------------------------------------------------------------------------

!--------------local variables-----------------------------
 integer,parameter :: nmt = 6    !# of mie tables
 integer,parameter :: nrh  = 36  !# of column (RH) for mie table
 real :: mBex(nmt,nwl,nrh)  ! Mass extinction coefficient [m2/g]
 real :: nBex(tgmx,nwl,nrh) ! reasigned Mass extinction coefficient [m2/g]
 real :: mw0(nmt,nwl,nrh)   ! single scattering albedo [-]
 real :: nw0(tgmx,nwl,nrh)  ! reasigned single scattering albedo [-]
 real :: mg(nmt,nwl,nrh)    ! asymetry factor [-]
 real :: ng(tgmx,nwl,nrh)   ! reasigned asymetry factor [-]
 real :: mRHr(nmt,nrh)      ! relative humidity [-]
 real :: nRHr(tgmx,nrh)     ! reasigned relative humidity [-]
 real :: w1, w2             !weight for pressure interpolation
 real :: wl(nwl)            ! wavelengh interval for SW radiation [um]

!
! Mie table loop
! 1- "suso" :sulfate and its precursors
! 2- "waso" : water soluble organic carbon
! 3- "soot" : black carbon
! 4- "ssam" : sea salt (accumulation,fine mode)
! 5- "sscm" : sea salt (coarse mode)
! 6- "dust" : dust
!
      print*,'MSG  read_mie_sw; read mie tables'

      do t = 1, nmt  !# of mie tables
         at=mie_tbl(t)
         nrs = nrh
        if(at == "dust") nrs = 8
        open(1,file='mie.'//at//'.clirad',status='old')
        read(1,*)aa
        read(1,'(6x,36f10.2)')(mRHr(t,k),k=1,nrs)
        read(1,'(/)')
        read(1,'(a39)') aa
        do k = 1,nwl
         read(1,'(f6.3,36e10.3)')wl(k),(mBex(t,k,n),n=1,nrs)
        end do
        read(1,'(a39)') aa
        do k = 1,nwl
         read(1,'(6x,36e10.3)')(mw0(t,k,n),n=1,nrs)
        end do
        read(1,'(a39)') aa
        do k = 1,nwl
         read(1,'(6x,36e10.3)')(mg(t,k,n),n=1,nrs)
        end do
        close(1)
      enddo
!
! Reasign the mie table for the following order
!

!  1 = SO4      !sulfur and its precure
       ai = 1
       nRHr(ai,:)   = mRHr(1,:)
       nBex(ai,:,:) = mBex(1,:,:)
       nw0(ai,:,:)  = mw0(1,:,:)
       ng(ai,:,:)   = mg(1,:,:)
!  2 = BC1+BC2  !black carbon (soot)
       ai = 2
       nRHr(ai,:)   = mRHr(3,:)
       nBex(ai,:,:) = mBex(3,:,:)
       nw0(ai,:,:)  = mw0(3,:,:)
       ng(ai,:,:)   = mg(3,:,:)
!  3 = OC1      !non hygroscopic OC
       ai = 3
       nRHr(ai,:)   = mRHr(2,:)
       do k = 1,nwl ; do n = 1,nrh
         nBex(ai,k,n) = mBex(2,k,1)
         nw0(ai,k,n)  = mw0(2,k,1)
         ng(ai,k,n)   = mg(2,k,1)
       enddo ; enddo
!  4 = OC2      !hygroscopic OC
       ai = 4
       nRHr(ai,:)   = mRHr(2,:)
       nBex(ai,:,:) = mBex(2,:,:)
       nw0(ai,:,:)  = mw0(2,:,:)
       ng(ai,:,:)   = mg(2,:,:)
!  5 = SS1      !sea-salt accumulation mode
       ai = 5
       nRHr(ai,:)   = mRHr(4,:)
       nBex(ai,:,:) = mBex(4,:,:)
       nw0(ai,:,:)  = mw0(4,:,:)
       ng(ai,:,:)   = mg(4,:,:)
!  6 = SS2+SS3+SS4 !sea-salt coarse mode
       ai = 6
       nRHr(ai,:)   = mRHr(5,:)
       nBex(ai,:,:) = mBex(5,:,:)
       nw0(ai,:,:)  = mw0(5,:,:)
       ng(ai,:,:)   = mg(5,:,:)
!  7 = DU1      ! dust mode 1
!  8 = DU1      ! dust mode 2
!  9 = DU1      ! dust mode 3
! 10 = DU1      ! dust mode 4
! 11 = DU2      ! dust mode 5
! 12 = DU3      ! dust mode 6
! 13 = DU4      ! dust mode 7
! 14 = DU5      ! dust mode 8
       do ai = 7 , 14
       nRHr(ai,:)   = mRHr(1,:)
       do k = 1,nwl ; do n = 1,nrh
         nBex(ai,k,n) = mBex(6,k,ai-6)
         nw0(ai,k,n)  = mw0(6,k,ai-6)
         ng(ai,k,n)   = mg(6,k,ai-6)
       enddo ; enddo
       enddo
!
! Further interporate the Mie Table for RH every 1%
! This reduce CPU time in searching do loop in aero_opt
!

!for RH 0 ~ 79%
       do ai = 1, tgmx ; do k = 1,nwl ; do nh = 0, 79
       do n = 1, 16
         if(nh == nint(nRHr(ai,n)*100.) ) then
          Bex_temp(ai,k,nh) = nBex(ai,k,n)
          w0_temp(ai,k,nh)  = nw0(ai,k,n)
          g_temp(ai,k,nh)   = ng(ai,k,n)
          exit
        elseif( nh > nint(nRHr(ai,n)*100.) .and. &
                nh < nint(nRHr(ai,n+1)*100.)    ) then
          w2 = ( real(nh)/100. - nRHr(ai,n) ) / &
               (nRHr(ai,n+1)-nRHr(ai,n) )
          w1 = max(min( 1.-w2,1. ),0.)
          Bex_temp(ai,k,nh) = w1*nBex(ai,k,n)+w2*nBex(ai,k,n+1)
          w0_temp(ai,k,nh)  = w1*nw0(ai,k,n)+w2*nw0(ai,k,n+1)
          g_temp(ai,k,nh)   = w1*ng(ai,k,n)+w2*ng(ai,k,n+1)
          exit
         endif
       enddo
       enddo ; enddo ; enddo

!for RH 80~99%
       do ai = 1, tgmx ; do k = 1,nwl ; do nh = 80, nrmx
          Bex_temp(ai,k,nh) = nBex(ai,k,nh-63)
          w0_temp(ai,k,nh)  = nw0(ai,k,nh-63)
          g_temp(ai,k,nh)   = ng(ai,k,nh-63)
       enddo ; enddo ; enddo

!       Bex(1:tgmx,1:nwl,0:nrmx) = Bex_temp(1:tgmx,1:nwl,0:nrmx)
!       w0(1:tgmx,1:nwl,0:nrmx) = w0_temp(1:tgmx,1:nwl,0:nrmx)
!       g(1:tgmx,1:nwl,0:nrmx) = g_temp(1:tgmx,1:nwl,0:nrmx)

        end subroutine read_mie_sw

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

  subroutine write_mie_sw
  implicit none
!------------------------------------------------------------------------
! write out aerosol mie table & assinge optical properties.
! Assinged values are saved for global variables at the top of module_gocart_offline.
!
! History;
! 02/2007  Toshi Matsui ; Initial.
!------------------------------------------------------------------------

  open(1,file='mie_table.f90',status='replace')
!
! Bex
!
  do ai = 1, tgmx !aerosol type
       write(1,20) ai,ai!,nh,nh
     do nh = 0, 99 
       if(nh==nrmx) then
         write(1,11) ( Bex_temp(ai,k,nh) , k =1,nwl )
       else
         write(1,10) ( Bex_temp(ai,k,nh) , k =1,nwl )
       endif
     enddo !nh
  enddo !ai

!
! single scattering albedo 
!
  do ai = 1, tgmx !aerosol type
       write(1,21) ai,ai!,nh,nh
     do nh = 0, 99 
       if(nh==nrmx) then
         write(1,11) ( w0_temp(ai,k,nh) , k =1,nwl )
       else
         write(1,10) ( w0_temp(ai,k,nh) , k =1,nwl )
       endif
     enddo !nh
  enddo !ai

!
! asymetry factor
!
  do ai = 1, tgmx !aerosol type
       write(1,22) ai,ai!,nh,nh

     do nh = 0, 99 
       if(nh==nrmx) then
         write(1,11) ( g_temp(ai,k,nh) , k =1,nwl )
       else
         write(1,10) ( g_temp(ai,k,nh) , k =1,nwl )
       endif
     enddo !nh
  enddo !ai


 20 format(1x,"data (((Bex(ai,k,nh),ai=",i2,",",i2,"),k=1,11),nh=0,99)/ &")
 21 format(1x,"data (((w0(ai,k,nh),ai=",i2,",",i2,"),k=1,11),nh=0,99)/ &")
 22 format(1x,"data (((g(ai,k,nh),ai=",i2,",",i2,"),k=1,11),nh=0,99)/ &")

 10 format(1x,e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,  &
                    ",",e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,",&")
 11 format(1x,e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,  &
                    ",",e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,"/")

  close(1)

  end subroutine write_mie_sw

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

  subroutine read_mie_lw
  implicit none

!------------------------------------------------------------------------
! Read aerosol mie table (LW) & assinge optical properties.
! Assinged values are saved for global variables at the top of module_gocart_offline.
!
! History;
! 02/2007  Toshi Matsui ; Initial.
!------------------------------------------------------------------------

!--------------local variables-----------------------------
  integer :: iwn,iwn1,iwn2,iwnb !wavenumber index
  integer,parameter :: nb = 61 ! # of wave band for mie table
  integer,parameter :: nmt = 6     ! # of mie tables
  integer,parameter :: nrh  = 36   ! # of column (RH) for mie table
  real :: wlb(nb)           ! band wavelength
  real :: mBex(nmt,nb,nrh)  ! Mass extinction coefficient [m2/g]
  real :: nBex(tgmx,nb,nrh) ! reasigned Mass extinction coefficient [m2/g]
  real :: mw0(nmt,nb,nrh)   ! single scattering albedo [-]
  real :: nw0(tgmx,nb,nrh)  ! reasigned single scattering albedo [-]
  real :: mg(nmt,nb,nrh)    ! asymetry factor [-]
  real :: ng(tgmx,nb,nrh)   ! reasigned asymetry factor [-]
  real :: mRHr(nmt,nrh)         ! relative humidity [-]
  real :: nRHr(tgmx,nrh)        ! reasigned relative humidity [-]
  real :: w1, w2                ! weight for pressure interpolation

  real :: Bext(tgmx,nb,0:nrmx)   ! temporary Mass extinction coefficient [m2/g]
  real :: w0t(tgmx,nb,0:nrmx)    ! temporary single scattering albedo [-]
  real :: gt(tgmx,nb,0:nrmx)     ! temporary asymetry factor [-]
  real :: Bex_wn(tgmx,250:4000,0:nrmx)  !temp Bex array for wavenumber 
  real :: w0_wn(tgmx,250:4000,0:nrmx)   !temp w0 array for wavenumber
  real :: g_wn(tgmx,250:4000,0:nrmx)    !temp g array for wavenumber

!--------------mie table loop----------------------------------
! 1- "suso" : sulfate and its precursors
! 2- "waso" : water soluble organic carbon
! 3- "soot" : black carbon
! 4- "ssam" : sea salt (accumulation,fine mode)
! 5- "sscm" : sea salt (coarse mode)
! 6- "dust" : dust

      print*,'MSG  read_mie_lw; read mie tables for longwave band'

      do t = 1, nmt  !# of mie tables
         at=mie_tbl(t)
         nrs = nrh
        if(at == "dust") nrs = 8
        open(1,file='mie.'//at//'.out',status='old')
        read(1,*)aa
        read(1,'(6x,36f10.2)')(mRHr(t,k),k=1,nrs)
        read(1,'(/)')
        read(1,'(a39)') aa
        do k = 1,nb
         read(1,'(f6.3,36e10.3)')wlb(k),(mBex(t,k,n),n=1,nrs)
        end do
        read(1,'(a39)') aa
        do k = 1,nb
         read(1,'(6x,36e10.3)')(mw0(t,k,n),n=1,nrs)
        end do
        read(1,'(a39)') aa
        do k = 1,nb
         read(1,'(6x,36e10.3)')(mg(t,k,n),n=1,nrs)
        end do
        close(1)
      enddo

!------------Reasign the mie table for the following order
!  1 = SO4      !sulfur and its precure
       ai = 1
       nRHr(ai,:)   = mRHr(1,:)
       nBex(ai,:,:) = mBex(1,:,:)
       nw0(ai,:,:)  = mw0(1,:,:)
       ng(ai,:,:)   = mg(1,:,:)
!  2 = BC1+BC2  !black carbon (soot)
       ai = 2
       nRHr(ai,:)   = mRHr(3,:)
       nBex(ai,:,:) = mBex(3,:,:)
       nw0(ai,:,:)  = mw0(3,:,:)
       ng(ai,:,:)   = mg(3,:,:)
!  3 = OC1      !non hygroscopic OC
       ai = 3
       nRHr(ai,:)   = mRHr(2,:)
       do k = 1,nb ; do n = 1,nrh
         nBex(ai,k,n) = mBex(2,k,1)
         nw0(ai,k,n)  = mw0(2,k,1)
         ng(ai,k,n)   = mg(2,k,1)
       enddo ; enddo
!  4 = OC2      !hygroscopic OC
       ai = 4
       nRHr(ai,:)   = mRHr(2,:)
       nBex(ai,:,:) = mBex(2,:,:)
       nw0(ai,:,:)  = mw0(2,:,:)
       ng(ai,:,:)   = mg(2,:,:)
!  5 = SS1      !sea-salt accumulation mode
       ai = 5
       nRHr(ai,:)   = mRHr(4,:)
       nBex(ai,:,:) = mBex(4,:,:)
       nw0(ai,:,:)  = mw0(4,:,:)
       ng(ai,:,:)   = mg(4,:,:)
!  6 = SS2+SS3+SS4 !sea-salt coarse mode
       ai = 6
       nRHr(ai,:)   = mRHr(5,:)
       nBex(ai,:,:) = mBex(5,:,:)
       nw0(ai,:,:)  = mw0(5,:,:)
       ng(ai,:,:)   = mg(5,:,:)

!  7 = DU1      ! dust mode 1
!  8 = DU1      ! dust mode 2
!  9 = DU1      ! dust mode 3
! 10 = DU1      ! dust mode 4
! 11 = DU2      ! dust mode 5
! 12 = DU3      ! dust mode 6
! 13 = DU4      ! dust mode 7
! 14 = DU5      ! dust mode 8
       do ai = 7 , 14
       nRHr(ai,:)   = mRHr(1,:)
       do k = 1,nb ; do n = 1,nrh
         nBex(ai,k,n) = mBex(6,k,ai-6)
         nw0(ai,k,n)  = mw0(6,k,ai-6)
         ng(ai,k,n)   = mg(6,k,ai-6)
       enddo ; enddo
       enddo

!
!-----Further interporate the Mie Table for RH every 1%
! for RH 0 ~ 79%
       do ai = 1, tgmx ; do k = 1,nb ; do nh = 0, 79
       do n = 1, 16
         if(nh == nint(nRHr(ai,n)*100.) ) then
          Bext(ai,k,nh) = nBex(ai,k,n)
          w0t(ai,k,nh)  = nw0(ai,k,n)
          gt(ai,k,nh)   = ng(ai,k,n)
          exit
        elseif( nh > nint(nRHr(ai,n)*100.) .and. &
                nh < nint(nRHr(ai,n+1)*100.)    ) then
          w2 = ( real(nh)/100. - nRHr(ai,n) ) / &
               (nRHr(ai,n+1)-nRHr(ai,n) )
          w1 = max(min( 1.-w2,1. ),0.)
          Bext(ai,k,nh) = w1*nBex(ai,k,n)+w2*nBex(ai,k,n+1)
          w0t(ai,k,nh)  = w1*nw0(ai,k,n)+w2*nw0(ai,k,n+1)
          gt(ai,k,nh)   = w1*ng(ai,k,n)+w2*ng(ai,k,n+1)
          exit
         endif
       enddo
       enddo ; enddo ; enddo

!for RH 80~99%
       do ai = 1, tgmx ; do k = 1,nb ; do nh = 80, nrmx
          Bext(ai,k,nh) = nBex(ai,k,nh-63)
          w0t(ai,k,nh)  = nw0(ai,k,nh-63)
          gt(ai,k,nh)   = ng(ai,k,nh-63)
       enddo ; enddo ; enddo


!
! reasinge Bex w0 g for 250~4000  wavenumber ranges
!

  do k = nb,20,-1
     iwn1 = nint(1./(wlb(k)/10000.))
     iwn2 = nint(1./(wlb(k-1)/10000.))
     iwnb = iwn2 - iwn1

     Bex_wn(:,iwn1,:) = Bext(:,k,:)
     Bex_wn(:,iwn2,:) = Bext(:,k-1,:)
     w0_wn(:,iwn1,:)  = w0t(:,k,:)
     w0_wn(:,iwn2,:)  = w0t(:,k-1,:)
     g_wn(:,iwn1,:)   = gt(:,k,:)
     g_wn(:,iwn2,:)   = gt(:,k-1,:)

     do iwn = iwn1+1, iwn2-1
        w2 = (real(iwn)-real(iwn1)) / real(iwnb)
        w1 = max(min( 1.-w2,1. ),0.)
        Bex_wn(:,iwn,:) = w1*Bext(:,k,:) + w2*Bext(:,k-1,:)         
        w0_wn(:,iwn,:) = w1*w0t(:,k,:) + w2*w0t(:,k-1,:)
        g_wn(:,iwn,:) = w1*gt(:,k,:) + w2*gt(:,k-1,:)
     enddo 

  enddo


!
! average the broadband IR optical proerpties (1~9 band)
!
 do iwn = 1, nwl_lw-1

    iwn1 = waven(iwn)
    iwn2 = waven(iwn+1)
    iwnb = iwn2 - iwn1 + 1


    do ai = 1, tgmx ; do nh = 0, nrmx
        Bex_lw_temp(ai, iwn, nh) =  sum( Bex_wn(ai, iwn1:iwn2, nh)) / real(iwnb)
        w0_lw_temp(ai, iwn, nh)  =  sum( w0_wn(ai, iwn1:iwn2, nh)) / real(iwnb)
        g_lw_temp(ai, iwn, nh)   =  sum( g_wn(ai, iwn1:iwn2, nh)) / real(iwnb)
    enddo ; enddo

 enddo
!
! for 10th band
!
    do ai = 1, tgmx ; do nh = 0, nrmx
        Bex_lw_temp(ai, 10, nh) =  sum( Bex_wn(ai, 540:620, nh)) / 81.
        w0_lw_temp(ai, 10, nh)  =  sum( w0_wn(ai, 540:620, nh)) / 81.
        g_lw_temp(ai, 10, nh)   =  sum( g_wn(ai, 540:620, nh)) / 81.
    enddo ; enddo


!       Bex_lw(1:tgmx,1:nwl_lw,0:nrmx) = Bex_lw_temp(1:tgmx,1:nwl_lw,0:nrmx)
!       w0_lw(1:tgmx,1:nwl_lw,0:nrmx) = w0_lw_temp(1:tgmx,1:nwl_lw,0:nrmx)
!       g_lw(1:tgmx,1:nwl_lw,0:nrmx) = g_lw_temp(1:tgmx,1:nwl_lw,0:nrmx)


  end subroutine read_mie_lw

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

  subroutine write_mie_lw
  implicit none
!------------------------------------------------------------------------
! write out aerosol mie table & assinge optical properties.
! Assinged values are saved for global variables at the top of module_gocart_offline.
!
! History;
! 02/2007  Toshi Matsui ; Initial.
!------------------------------------------------------------------------

  open(1,file='mie_lw_table.f90',status='replace')
!
! Bex
!
  do ai = 1, tgmx !aerosol type
       write(1,20) ai,ai!,nh,nh
     do nh = 0, 99
       if(nh==nrmx) then
         write(1,11) ( Bex_lw_temp(ai,k,nh) , k =1,nwl_lw )
       else
         write(1,10) ( Bex_lw_temp(ai,k,nh) , k =1,nwl_lw )
       endif
     enddo !nh
  enddo !ai

!
! single scattering albedo 
!
  do ai = 1, tgmx !aerosol type
       write(1,21) ai,ai!,nh,nh
     do nh = 0, 99
       if(nh==nrmx) then
         write(1,11) ( w0_lw_temp(ai,k,nh) , k =1,nwl_lw )
       else
         write(1,10) ( w0_lw_temp(ai,k,nh) , k =1,nwl_lw )
       endif
     enddo !nh
  enddo !ai

!
! asymetry factor
!
  do ai = 1, tgmx !aerosol type
       write(1,22) ai,ai!,nh,nh

     do nh = 0, 99
       if(nh==nrmx) then
         write(1,11) ( g_lw_temp(ai,k,nh) , k =1,nwl_lw )
       else
         write(1,10) ( g_lw_temp(ai,k,nh) , k =1,nwl_lw )
       endif
     enddo !nh
  enddo !ai


 20 format(1x,"data (((Bex_lw(ai,k,nh),ai=",i2,",",i2,"),k=1,nwl_lw),nh=0,99)/ &")
 21 format(1x,"data (((w0_lw(ai,k,nh),ai=",i2,",",i2,"),k=1,nwl_lw),nh=0,99)/ &")
 22 format(1x,"data (((g_lw(ai,k,nh),ai=",i2,",",i2,"),k=1,nwl_lw),nh=0,99)/ &")

 10 format(1x,e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,  &
                    ",",e9.4,",",e9.4,",",e9.4,",",e9.4,",&")
 11 format(1x,e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,",",e9.4,  &
                    ",",e9.4,",",e9.4,",",e9.4,",",e9.4,"/")

  close(1)


  end subroutine write_mie_lw

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 

  subroutine aero_opt(sw_or_lw,np,nband, pr,ta,sh,dz,aero,tau,ssa,asy)
  implicit none
!------------------------------------------------------------------------
! Subroutine aero_opt compute the optical properties from the model input.
! All the dimension here is model (GCE or WRF) dimension. Not GOCART dimension.
! Note that tgmx = 14 : aerosol type (see below), and aero must be in the following order.
!  #   
!  1 = SO4      ! sulfur and its precure
!  2 = BC1+BC2  ! black carbon (soot)
!  3 = OC1      ! non hygroscopic OC
!  4 = OC2      ! hygroscopic OC
!  5 = SS1      ! sea-salt accumulation mode
!  6 = SS2+SS3+SS4 !sea-salt coarse mode
!  7 = DU1      ! dust mode 1
!  8 = DU1      ! dust mode 2
!  9 = DU1      ! dust mode 3
! 10 = DU1      ! dust mode 4
! 11 = DU2      ! dust mode 5
! 12 = DU3      ! dust mode 6
! 13 = DU4      ! dust mode 7
! 14 = DU5      ! dust mode 8
!
! History;
! 02/2007  Toshi Matsui ; Initial.
!------------------------------------------------------------------------

!-----IO variables
 character(len=2), intent(in) :: sw_or_lw   ! character index that determines sw or lw radiation
 integer, intent(in) :: np            !model verical array size
 integer, intent(in) :: nband         !# of radiation bands
 real, intent(in)    :: aero(np,tgmx) !aerosol mass conc [g/m3]
 real, intent(in)    :: pr(np)        !pressure [mb]
 real, intent(in)    :: ta(np)        !temperature [K]
 real, intent(in)    :: sh(np)        !specific humidity [g/g]
 real, intent(in)    :: dz(np)        !layer thickness [m]
 real, intent(out)   :: tau(np,nband)      !total aerosol optical depth
 real, intent(out)   :: ssa(np,nband)      !total aerosol single scattering albedo
 real, intent(out)   :: asy(np,nband)      !total aerosol asymetry factor

!-----Local variables
 integer :: rhi         !RH index
 real :: es            !saturated vapor pressure [kPa]
 real :: q             !vapor mixing pressure [kPa]
 real :: e             !vapor pressure [kPa]
 real :: rh(np)      !relative humidity [-]
 real :: ext           !mass extinction coef [m2/g]
 real :: tau_typ(tgmx) !optical depth for each aerosol type [-]
 real :: ssa_typ(tgmx) !single scattering albedo for each aerosol type [-]
 real :: asy_typ(tgmx) !asymetery factor for each aerosol type [-]
 real :: w1, w2        !weight for pressure interpolation

!
! compute relative humidity
!
 do k = 1, np
    es = 0.611 * exp( 5423.*( 1./273.15 - 1./ta(k) ) )  !over flat water
    q = sh(k)/(1.-sh(k))                                !mixing ratio
    e = (q / (q+0.622)) * pr(k) * 0.1                   !vapor pressure [mb] -> [kPa]
    rh(k) = min( max(1e-5, e/es) , 0.99)                !relative humidity (set upper limit 99%)
 enddo

!
! Compute total aerosol tau, ssa, & asy
! Algorithm: Total optical properties is computed as
! TAU = (tau1 + tau2 + tau3 +.... )
! SSA = (tau1*w1 + tau2*w2 + tau3*w2 + .... ) / TAU
! ASY = (tau1*w1*g1 + tau2*w2*g1 + tau3*w2*g1 + .... ) / (TAU*SSA)
!
 do k = 1, np !vertical loop

    rhi = int(rh(k)*100.)  !RH index
    w2 = (rh(k) - real(rhi)/100.) / 0.01  !weight
    w1 = max(min( 1.-w2,1. ),0.) !weight

    do n = 1,nband  !wavelengh loop

       tau_typ = 0. ; ssa_typ = 0. ; asy_typ = 0.  !initialization

       rad_select: select case(sw_or_lw)
       case ('sw')  !shortwave radiation
            do t = 1,tgmx !aerosol type loop
               if(rhi == 99) then
                  ext        = Bex(t,n,rhi) 
                  tau_typ(t) = ext * aero(k,t) * dz(k)
                  ssa_typ(t) = w0(t,n,rhi) 
                  if(t>=7) ssa_typ(t) = w0(t,n,rhi) - 0.03  !toshii 3%down for dust 1-8 modes
                  asy_typ(t) = g(t,n,rhi)
               else
                  ext        = w1*Bex(t,n,rhi) + w2*Bex(t,n,rhi+1)
                  tau_typ(t) = ext * aero(k,t) * dz(k)
                  ssa_typ(t) = w1*w0(t,n,rhi) + w2*w0(t,n,rhi+1)
                  if(t>=7) ssa_typ(t) = w1*w0(t,n,rhi) + w2*w0(t,n,rhi+1) - 0.03  !toshii 3%down for dust 1-8 modes
                  asy_typ(t) = w1*g(t,n,rhi) + w2*g(t,n,rhi+1)
               endif
           
             enddo !t
        case ('lw')  !longwave radiation
             do t = 1,tgmx !aerosol type loop
                if(rhi == 99) then
                  ext        = Bex_lw(t,n,rhi)
                  tau_typ(t) = ext * aero(k,t) * dz(k)
                  ssa_typ(t) = w0_lw(t,n,rhi)
                  asy_typ(t) = g_lw(t,n,rhi)
                else
                  ext        = w1*Bex_lw(t,n,rhi) + w2*Bex_lw(t,n,rhi+1)
                  tau_typ(t) = ext * aero(k,t) * dz(k)
                  ssa_typ(t) = w1*w0_lw(t,n,rhi) + w2*w0_lw(t,n,rhi+1)
                  asy_typ(t) = w1*g_lw(t,n,rhi) + w2*g_lw(t,n,rhi+1)
                endif
             enddo !t
         case default
              stop 'MSG aero_opt: the option does not exist: sw_or_lw '
         end select rad_select

         ! compute total optical depth single scatterling albedo, asymetry parameters
         tau(k,n) = sum( tau_typ(1:tgmx) )
         ssa(k,n) = sum( tau_typ(1:tgmx)*ssa_typ(1:tgmx) ) / max(tau(k,n),1e-08)
         asy(k,n) = sum( tau_typ(1:tgmx)*ssa_typ(1:tgmx)*asy_typ(1:tgmx) ) &
                       /  max(tau(k,n)*ssa(k,n),1e-08)

      enddo !n

  enddo ! vertical loop

 end subroutine aero_opt

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD

 end module module_gocart_coupling
#else
 module module_gocart_coupling
 contains
 subroutine dummy
 end subroutine dummy
 end module module_gocart_coupling

#endif

!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
!GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD GODDARD 
